/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.util.ArrayList;
import sybase.isql.FavoritesListItem;
import sybase.isql.FavoritesListener;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLResource;

class FavoritesList {
    private FavoritesListItem _root = new FavoritesListItem(3, ISQLResource.getISQLString(GeneralResources.getName(), "FAVORITES_LIST_ROOT_NAME"), null, null);
    private ArrayList<FavoritesListener> _listeners = new ArrayList();

    FavoritesList() {
    }

    void addFavoritesListener(FavoritesListener favoritesListener) {
        this._listeners.add(favoritesListener);
    }

    void removeFavoritesListener(FavoritesListener favoritesListener) {
        this._listeners.remove(favoritesListener);
    }

    void add(FavoritesListItem favoritesListItem, FavoritesListItem favoritesListItem2, int n) {
        if (favoritesListItem == null) {
            favoritesListItem = this._root;
        }
        favoritesListItem.addChild(favoritesListItem2, n);
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).notifyFavoriteAdded(favoritesListItem, favoritesListItem2);
        }
    }

    void remove(FavoritesListItem favoritesListItem) {
        FavoritesListItem favoritesListItem2 = this._root.getParentForItem(favoritesListItem);
        if (favoritesListItem2 != null) {
            favoritesListItem2.removeChild(favoritesListItem);
            if (favoritesListItem2 == this._root) {
                favoritesListItem2 = null;
            }
            for (int i = 0; i < this._listeners.size(); ++i) {
                this._listeners.get(i).notifyFavoriteRemoved(favoritesListItem2, favoritesListItem);
            }
        }
    }

    void move(FavoritesListItem favoritesListItem, FavoritesListItem favoritesListItem2, FavoritesListItem favoritesListItem3, int n) {
        FavoritesListItem favoritesListItem4 = favoritesListItem == null ? this._root : favoritesListItem;
        FavoritesListItem favoritesListItem5 = favoritesListItem2 == null ? this._root : favoritesListItem2;
        favoritesListItem4.removeChild(favoritesListItem3);
        favoritesListItem5.addChild(favoritesListItem3, n);
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).notifyFavoriteMoved(favoritesListItem, favoritesListItem2, favoritesListItem3);
        }
    }

    FavoritesListItem getChildByName(String string) {
        return this._root.getChildByName(string);
    }

    String save() {
        StringBuilder stringBuilder = new StringBuilder();
        this._root.save(stringBuilder);
        return stringBuilder.toString();
    }

    void load(String string) {
        if (string != null && string.length() != 0) {
            String[] stringArray = string.split("\\s+");
            this._root.load(stringArray, 0);
        }
    }

    FavoritesListItem getRoot() {
        return this._root;
    }

    void notifyItemChanged(FavoritesListItem favoritesListItem) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).notifyFavoriteChanged(favoritesListItem);
        }
    }
}

