/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.util.ArrayList;

class FavoritesListItem {
    static final int CONNECTION = 1;
    static final int FILE = 2;
    static final int FOLDER = 3;
    private ArrayList<FavoritesListItem> _children;
    private int _type;
    private String _name;
    private String _stringData;
    private String _pluginID;

    FavoritesListItem(int n, String string, String string2, String string3) {
        this._type = n;
        this._name = string;
        this._stringData = string2;
        this._pluginID = string3;
        this._children = new ArrayList();
    }

    String getName() {
        return this._name;
    }

    void setName(String string) {
        this._name = string;
    }

    public String toString() {
        return this._name;
    }

    int getType() {
        return this._type;
    }

    String getStringData() {
        return this._stringData;
    }

    String getPluginID() {
        return this._pluginID;
    }

    void addChild(FavoritesListItem favoritesListItem, int n) {
        int n2 = this._children.size();
        if (n > n2) {
            n = n2;
        }
        this._children.add(n, favoritesListItem);
    }

    void removeChild(FavoritesListItem favoritesListItem) {
        this._children.remove(favoritesListItem);
    }

    FavoritesListItem getChildByName(String string) {
        FavoritesListItem favoritesListItem = null;
        for (int i = 0; i < this._children.size(); ++i) {
            FavoritesListItem favoritesListItem2 = this._children.get(i);
            if (!favoritesListItem2.getName().equals(string)) continue;
            favoritesListItem = favoritesListItem2;
            break;
        }
        return favoritesListItem;
    }

    int getChildCount() {
        return this._children.size();
    }

    FavoritesListItem getChild(int n) {
        return this._children.get(n);
    }

    FavoritesListItem getParentForItem(FavoritesListItem favoritesListItem) {
        FavoritesListItem favoritesListItem2 = null;
        if (this._children.contains(favoritesListItem)) {
            favoritesListItem2 = this;
        } else {
            int n = this._children.size();
            for (int i = 0; i < n; ++i) {
                FavoritesListItem favoritesListItem3 = this._children.get(i);
                if (favoritesListItem3._type == 3 && (favoritesListItem2 = favoritesListItem3.getParentForItem(favoritesListItem)) != null) break;
            }
        }
        return favoritesListItem2;
    }

    void save(StringBuilder stringBuilder) {
        int n = this._children.size();
        block5: for (int i = 0; i < n; ++i) {
            FavoritesListItem favoritesListItem = this._children.get(i);
            switch (favoritesListItem.getType()) {
                case 1: {
                    stringBuilder.append("CONNECTION ");
                    stringBuilder.append(this.escape(favoritesListItem.getName()));
                    stringBuilder.append(' ');
                    stringBuilder.append(this.escape(favoritesListItem.getPluginID()));
                    stringBuilder.append(' ');
                    stringBuilder.append(this.escape(favoritesListItem.getStringData()));
                    stringBuilder.append(' ');
                    continue block5;
                }
                case 2: {
                    stringBuilder.append("FILE ");
                    stringBuilder.append(this.escape(favoritesListItem.getName()));
                    stringBuilder.append(' ');
                    stringBuilder.append(this.escape(favoritesListItem.getStringData()));
                    stringBuilder.append(' ');
                    continue block5;
                }
                case 3: {
                    stringBuilder.append("FOLDER ");
                    stringBuilder.append(this.escape(favoritesListItem.getName()));
                    stringBuilder.append(' ');
                    favoritesListItem.save(stringBuilder);
                    stringBuilder.append(" ENDFOLDER ");
                }
            }
        }
    }

    int load(String[] stringArray, int n) {
        String string;
        int n2;
        this._children.clear();
        for (n2 = n; n2 < stringArray.length && (string = this.unescape(stringArray[n2])) != null; ++n2) {
            FavoritesListItem favoritesListItem;
            String string2;
            String string3;
            if (string.equalsIgnoreCase("CONNECTION")) {
                if (n2 + 3 >= stringArray.length) break;
                string3 = this.unescape(stringArray[n2 + 1]);
                String string4 = this.unescape(stringArray[n2 + 2]);
                string2 = this.unescape(stringArray[n2 + 3]);
                n2 += 3;
                favoritesListItem = new FavoritesListItem(1, string3, string2, string4);
                this._children.add(favoritesListItem);
                continue;
            }
            if (string.equalsIgnoreCase("FILE")) {
                if (n2 + 2 >= stringArray.length) break;
                string3 = this.unescape(stringArray[n2 + 1]);
                string2 = this.unescape(stringArray[n2 + 2]);
                n2 += 2;
                favoritesListItem = new FavoritesListItem(2, string3, string2, null);
                this._children.add(favoritesListItem);
                continue;
            }
            if (string.equalsIgnoreCase("FOLDER")) {
                if (n2 + 1 >= stringArray.length) break;
                string3 = this.unescape(stringArray[n2 + 1]);
                ++n2;
                favoritesListItem = new FavoritesListItem(3, string3, null, null);
                this._children.add(favoritesListItem);
                n2 += favoritesListItem.load(stringArray, n2 + 1);
                continue;
            }
            if (!string.equalsIgnoreCase("ENDFOLDER")) break;
            ++n2;
            break;
        }
        return n2 - n;
    }

    private String escape(String string) {
        string = string.replaceAll("\\s", "&nsbp;");
        return string;
    }

    private String unescape(String string) {
        string = string.replaceAll("&nsbp;", " ");
        return string;
    }
}

