/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.FontHelper;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import sybase.isql.FavoritesList;
import sybase.isql.FavoritesListItem;
import sybase.isql.FavoritesListener;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ParentFrame;
import sybase.isql.PluginMgr;

class FavoritesSidebar
extends JTable
implements MouseListener,
MouseMotionListener,
PopupMenuListener,
FavoritesListener {
    private FavoritesList _favorites;
    private int _rolloverRowIndex = -1;
    private JPopupMenu _contextMenu = null;

    FavoritesSidebar(FavoritesList favoritesList) {
        super(new FSModel(favoritesList));
        this._favorites = favoritesList;
        favoritesList.addFavoritesListener(this);
        this.getColumnModel().getColumn(0).setCellRenderer(new FSCellRenderer());
        this.setSelectionMode(0);
        this.setShowGrid(false);
        TableRowSorter<FSModel> tableRowSorter = new TableRowSorter<FSModel>((FSModel)this.getModel());
        tableRowSorter.setRowFilter(new FSFilter());
        this.setRowSorter(tableRowSorter);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setTableHeader(null);
        KeyStroke keyStroke = KeyStroke.getKeyStroke('+');
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FavoritesSidebar.this.expandSelectedRow();
            }
        }, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke('-');
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FavoritesSidebar.this.collapseSelectedRow();
            }
        }, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FavoritesSidebar.this.deleteSelectedItem();
            }
        }, keyStroke, 1);
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.unregisterKeyboardAction(keyStroke);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FavoritesSidebar.this.fireSelectedRow();
            }
        }, keyStroke, 1);
    }

    void destroy() {
        if (this._contextMenu != null) {
            this._contextMenu.setVisible(true);
        }
        this._favorites.removeFavoritesListener(this);
        this._favorites = null;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        if (n > -1) {
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            FavoritesListItem favoritesListItem = fSItem.item;
            switch (favoritesListItem.getType()) {
                case 2: {
                    string = favoritesListItem.getStringData();
                    break;
                }
                case 1: {
                    string = favoritesListItem.getName();
                    break;
                }
                case 3: {
                    int n2 = favoritesListItem.getChildCount();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html> ");
                    stringBuilder.append(ISQLResource.getFormattedString(GeneralResources.getName(), "Contains {0} item(s)", Integer.toString(n2)));
                    if (n2 != 0) {
                        stringBuilder.append("<br>");
                        for (int i = 0; i < n2; ++i) {
                            if (i > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(favoritesListItem.getChild(i).getName());
                            if (i != 2 || n2 <= 3) continue;
                            stringBuilder.append("...");
                            break;
                        }
                    }
                    string = stringBuilder.toString();
                }
            }
        }
        return string;
    }

    int getRolloverRowIndex() {
        return this._rolloverRowIndex;
    }

    private void openContextMenu(Point point) {
        int n = this.rowAtPoint(point);
        if (n > -1) {
            if (!this.isRowSelected(n)) {
                this.setRowSelectionInterval(n, n);
            }
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            this._contextMenu = this.createContextMenu(fSItem);
            this._contextMenu.addPopupMenuListener(this);
            UIUtils.showJPopupMenu((JPopupMenu)this._contextMenu, (JComponent)this, (Point)point);
        }
    }

    private JPopupMenu createContextMenu(FSItem fSItem) {
        SybMenuItem sybMenuItem;
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        JPopupMenu jPopupMenu = new JPopupMenu();
        switch (fSItem.item.getType()) {
            case 2: {
                sybMenuItem = new SybMenuItem(iSQLResource.getISQLString("OPEN_FAVORITE_MENU"));
                sybMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FavoritesSidebar.this.handleContextMenuOpenFile();
                    }
                });
                jPopupMenu.add((JMenuItem)sybMenuItem);
                jPopupMenu.addSeparator();
                break;
            }
            case 1: {
                sybMenuItem = new SybMenuItem(iSQLResource.getISQLString("OPEN_FAVORITE_MENU"));
                sybMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FavoritesSidebar.this.handleContextMenuOpenConnection();
                    }
                });
                jPopupMenu.add((JMenuItem)sybMenuItem);
                jPopupMenu.addSeparator();
            }
        }
        sybMenuItem = new SybMenuItem(iSQLResource.getISQLString("DELETE_FAVORITE_MENU"));
        sybMenuItem.setIcon(ISQLImages.getButtonIcon("delete"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FavoritesSidebar.this.deleteSelectedItem();
            }
        });
        jPopupMenu.add((JMenuItem)sybMenuItem);
        return jPopupMenu;
    }

    private void deleteSelectedItem() {
        int n = this.getSelectedRow();
        if (n > -1) {
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            this.deleteItem(fSItem);
        }
    }

    private void deleteItem(FSItem fSItem) {
        String string = fSItem.item.getType() != 3 ? ISQLResource.getFormattedString(GeneralResources.getName(), "ORGANIZE_FAVORITES_CONFIRM_DELETION", fSItem.item.getName()) : ISQLResource.getFormattedString(GeneralResources.getName(), "ORGANIZE_FAVORITES_CONFIRM_FOLDER_DELETION", fSItem.item.getName());
        ParentFrame parentFrame = (ParentFrame)SwingUtilities.getWindowAncestor(this);
        int n = SybOptionPane.showConfirmDialog((Component)parentFrame, (Object)string, (String)parentFrame.getTitle(), (int)0);
        if (n == 0) {
            this._favorites.remove(fSItem.item);
        }
    }

    private void handleContextMenuOpenFile() {
        int n = this.getSelectedRow();
        if (n > -1) {
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            this.openFile(fSItem);
        }
    }

    private void handleContextMenuOpenConnection() {
        int n = this.getSelectedRow();
        if (n > -1) {
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            this.openConnection(fSItem);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this._contextMenu = null;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this._contextMenu = null;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            this.openContextMenu(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            this.openContextMenu(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            switch (fSItem.item.getType()) {
                case 2: {
                    this.openFile(fSItem);
                    break;
                }
                case 1: {
                    this.openConnection(fSItem);
                    break;
                }
                case 3: {
                    this.expandSelectedRow();
                }
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._rolloverRowIndex != -1) {
            Rectangle rectangle = this.getCellRect(this._rolloverRowIndex, 0, false);
            this.repaint(rectangle);
            this._rolloverRowIndex = -1;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (n != this._rolloverRowIndex) {
            Rectangle rectangle;
            if (this._rolloverRowIndex != -1) {
                rectangle = this.getCellRect(this._rolloverRowIndex, 0, false);
                this.repaint(rectangle);
            }
            rectangle = this.getCellRect(n, 0, false);
            this.repaint(rectangle);
            this._rolloverRowIndex = n;
        }
    }

    private void openFile(FSItem fSItem) {
        ParentFrame parentFrame = (ParentFrame)SwingUtilities.getWindowAncestor(this);
        if (!parentFrame.shouldEnableMenu("Open...")) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        File file = new File(fSItem.item.getStringData());
        if (file.exists() && file.isFile()) {
            parentFrame.openFile(file);
        } else {
            int n = SybOptionPane.showConfirmDialog((Component)this, (Object)ISQLResource.getFormattedString(GeneralResources.getName(), "FAVORITE_FILE_DOES_NOT_EXIST", file.getName()), (String)parentFrame.getTitle(), (int)0);
            if (n == 0) {
                this.deleteItem(fSItem);
            }
        }
    }

    private void openConnection(FSItem fSItem) {
        ParentFrame parentFrame = (ParentFrame)SwingUtilities.getWindowAncestor(this);
        if (parentFrame.isBusy()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        ISQLPlugin iSQLPlugin = PluginMgr.getPlugin(fSItem.item.getPluginID());
        if (iSQLPlugin != null) {
            parentFrame.openConnection(iSQLPlugin, fSItem.item.getStringData());
        }
    }

    private void fireSelectedRow() {
        int n = this.getSelectedRow();
        if (n != -1) {
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            switch (fSItem.item.getType()) {
                case 1: {
                    this.openConnection(fSItem);
                    break;
                }
                case 2: {
                    this.openFile(fSItem);
                    break;
                }
                case 3: {
                    this.expandSelectedRow();
                }
            }
        }
    }

    private void expandSelectedRow() {
        int n = this.getSelectedRow();
        if (n != -1) {
            int n2 = this.getRowSorter().convertRowIndexToModel(n);
            FSModel fSModel = (FSModel)this.getModel();
            fSModel.showChildren(n2);
            n = this.getRowSorter().convertRowIndexToView(n2);
            this.setRowSelectionInterval(n, n);
        }
    }

    private void collapseSelectedRow() {
        int n = this.getSelectedRow();
        if (n != -1) {
            int n2 = this.getRowSorter().convertRowIndexToModel(n);
            FSModel fSModel = (FSModel)this.getModel();
            fSModel.hideChildren(n2);
            n = this.getRowSorter().convertRowIndexToView(n2);
            this.setRowSelectionInterval(n, n);
        }
    }

    @Override
    public void notifyFavoriteAdded(FavoritesListItem favoritesListItem, FavoritesListItem favoritesListItem2) {
        this.refresh();
    }

    @Override
    public void notifyFavoriteRemoved(FavoritesListItem favoritesListItem, FavoritesListItem favoritesListItem2) {
        this.refresh();
    }

    @Override
    public void notifyFavoriteMoved(FavoritesListItem favoritesListItem, FavoritesListItem favoritesListItem2, FavoritesListItem favoritesListItem3) {
        this.refresh();
    }

    @Override
    public void notifyFavoriteChanged(FavoritesListItem favoritesListItem) {
        this.refresh();
    }

    private void refresh() {
        FSModel fSModel = (FSModel)this.getModel();
        fSModel.refresh();
    }

    static class FSCellRenderer
    extends DefaultTableCellRenderer {
        private static Icon _groupIcon = null;
        private static Icon _fileIcon = null;
        private static Icon _planFileIcon = null;
        private static UnderlineBorder _underlineBorder = new UnderlineBorder();
        private static Border _emptyBorder = new EmptyBorder(0, 0, 1, 0);
        private static Hashtable<String, ImageIcon> _iconTable = new Hashtable();
        private Font _defaultFont = null;

        FSCellRenderer() {
        }

        static Icon getFileIcon() {
            if (_fileIcon == null) {
                _fileIcon = ISQLImages.getImageIcon("favorites_file16");
            }
            return _fileIcon;
        }

        static Icon getPlanFileIcon() {
            if (_planFileIcon == null) {
                _planFileIcon = ISQLImages.getImageIcon("plan16");
            }
            return _planFileIcon;
        }

        static Icon getConnectionIcon(FavoritesListItem favoritesListItem) {
            String string = favoritesListItem.getPluginID();
            ImageIcon imageIcon = _iconTable.get(string);
            if (imageIcon == null) {
                ISQLPlugin iSQLPlugin = PluginMgr.getPlugin(string);
                imageIcon = new ImageIcon(iSQLPlugin.getPluginImage(16));
                _iconTable.put(string, imageIcon);
            }
            return imageIcon;
        }

        static Icon getFolderIcon() {
            if (_groupIcon == null) {
                _groupIcon = ISQLImages.getImageIcon("favorites_group16");
            }
            return _groupIcon;
        }

        static Icon getIconForFavorite(FavoritesListItem favoritesListItem) {
            Icon icon;
            switch (favoritesListItem.getType()) {
                case 2: {
                    if (favoritesListItem.getName().endsWith(".saplan")) {
                        icon = FSCellRenderer.getPlanFileIcon();
                        break;
                    }
                    icon = FSCellRenderer.getFileIcon();
                    break;
                }
                case 1: {
                    icon = FSCellRenderer.getConnectionIcon(favoritesListItem);
                    break;
                }
                case 3: {
                    icon = FSCellRenderer.getFolderIcon();
                    break;
                }
                default: {
                    icon = null;
                }
            }
            return icon;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            bl = false;
            FSItem fSItem = (FSItem)object;
            String string = fSItem.item.getName();
            JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            if (string != null && string.length() > 0) {
                if (this._defaultFont == null) {
                    this._defaultFont = jComponent.getFont();
                }
                if (this._defaultFont.canDisplayUpTo(string) == -1) {
                    jComponent.setFont(this._defaultFont);
                } else {
                    FontHelper.setFontForString((Component)jComponent, (Font)this._defaultFont, (String)string);
                }
            }
            jComponent.setBorder(BorderFactory.createCompoundBorder(jComponent.getBorder(), BorderFactory.createEmptyBorder(0, fSItem.depth * 20, 0, 0)));
            int n3 = ((FavoritesSidebar)jTable).getRolloverRowIndex();
            if (n == n3) {
                _underlineBorder.configureForLabel((JLabel)jComponent);
                Border border = jComponent.getBorder();
                jComponent.setBorder(BorderFactory.createCompoundBorder(border, _underlineBorder));
            } else {
                Border border = jComponent.getBorder();
                jComponent.setBorder(BorderFactory.createCompoundBorder(border, _emptyBorder));
            }
            ((JLabel)jComponent).setIcon(FSCellRenderer.getIconForFavorite(fSItem.item));
            Dimension dimension = jComponent.getPreferredSize();
            if (jTable.getRowHeight(n) != dimension.height) {
                jTable.setRowHeight(n, dimension.height);
            }
            return jComponent;
        }

        static class UnderlineBorder
        implements Border {
            private int _x = 0;
            private int _width = 0;
            private Color _color;

            UnderlineBorder() {
            }

            void configureForLabel(JLabel jLabel) {
                this._x = 0;
                this._width = jLabel.getPreferredSize().width;
                this._color = jLabel.getForeground();
                Insets insets = jLabel.getInsets();
                this._width -= insets.left;
                Icon icon = jLabel.getIcon();
                if (icon != null) {
                    int n = icon.getIconWidth() + jLabel.getIconTextGap();
                    this._x += n;
                    this._width -= n;
                }
            }

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 0, 1, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(this._color);
                graphics.drawLine(n + this._x, n2 + n4 - 3, n + this._x + this._width, n2 + n4 - 3);
            }
        }
    }

    static class FSFilter
    extends RowFilter<FSModel, Integer> {
        FSFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends FSModel, ? extends Integer> entry) {
            FSItem fSItem = (FSItem)entry.getValue(0);
            return fSItem.isVisible;
        }
    }

    static class FSModel
    extends DefaultTableModel {
        private FavoritesList _favorites;

        FSModel(FavoritesList favoritesList) {
            this.addColumn("Favorites");
            this._favorites = favoritesList;
            this.refresh();
        }

        private void refresh() {
            this.setRowCount(0);
            FavoritesListItem favoritesListItem = this._favorites.getRoot();
            this.addFavorites(favoritesListItem, 0);
        }

        private void addFavorites(FavoritesListItem favoritesListItem, int n) {
            int n2 = favoritesListItem.getChildCount();
            for (int i = 0; i < n2; ++i) {
                FavoritesListItem favoritesListItem2 = favoritesListItem.getChild(i);
                FSItem fSItem = new FSItem(favoritesListItem2, n);
                this.addRow(new Object[]{fSItem});
                if (fSItem.item.getType() != 3) continue;
                this.addFavorites(favoritesListItem2, n + 1);
            }
        }

        void hideChildren(int n) {
            int n2 = 0;
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            if (fSItem.item.getType() != 3) {
                return;
            }
            int n3 = this.getRowCount();
            for (int i = n + 1; i < n3; ++i) {
                fSItem = (FSItem)this.getValueAt(i, 0);
                if (fSItem.depth <= n2) break;
                fSItem.isVisible = false;
            }
            this.fireTableDataChanged();
        }

        void showChildren(int n) {
            int n2;
            int n3 = 0;
            FSItem fSItem = (FSItem)this.getValueAt(n, 0);
            if (fSItem.item.getType() != 3) {
                return;
            }
            n3 = fSItem.depth;
            int n4 = this.getRowCount();
            for (n2 = 0; n2 < n4; ++n2) {
                fSItem = (FSItem)this.getValueAt(n2, 0);
                if (fSItem.depth <= n3) continue;
                fSItem.isVisible = false;
            }
            for (n2 = n + 1; n2 < n4; ++n2) {
                fSItem = (FSItem)this.getValueAt(n2, 0);
                if (fSItem.depth != n3 + 1) break;
                fSItem.isVisible = true;
            }
            this.fireTableDataChanged();
        }
    }

    static class FSItem {
        FavoritesListItem item;
        int depth;
        boolean isVisible;

        FSItem(FavoritesListItem favoritesListItem, int n) {
            this.item = favoritesListItem;
            this.depth = n;
            this.isVisible = n == 0;
        }

        public String toString() {
            return this.item.getName();
        }
    }
}

