/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLResource;

class GUIDisplayTable
extends JDialog
implements ActionListener {
    private static final String ESCAPE_KEY_COMMAND = "escapeKey";
    private SybButton _ok;
    private JTable _table;
    private JPanel _panel;

    static void create(JFrame jFrame, String string, String[] stringArray, String[][] stringArray2) {
        GUIDisplayTable gUIDisplayTable = new GUIDisplayTable(jFrame, string, stringArray, stringArray2);
        UIUtils.ensureWindowIsVisible((Window)gUIDisplayTable);
        gUIDisplayTable.setVisible(true);
        gUIDisplayTable.release();
        gUIDisplayTable = null;
    }

    private GUIDisplayTable(JFrame jFrame, String string, final String[] stringArray, final String[][] stringArray2) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        this._table = new JTable();
        this._table.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this._table.setModel(new AbstractTableModel(){

            @Override
            public String getColumnName(int n) {
                if (stringArray != null) {
                    return stringArray[n];
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return stringArray2.length;
            }

            @Override
            public int getColumnCount() {
                return stringArray.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return stringArray2[n][n2];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }
        });
        this._table.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setAlignmentX(0.0f);
        this._ok = new SybButton(iSQLResource.getISQLString("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._panel = new JPanel();
        this._panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._panel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this._panel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this._panel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this._panel.add((Component)this._ok, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this._panel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this.getContentPane().add(this._panel);
        this.setTitle(string);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this._table.registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this._table.registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(10, 0, false), 1);
    }

    private void release() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().setDefaultButton(null);
        this._table.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._table.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        this._table = null;
        this._ok.removeActionListener((ActionListener)this);
        this._ok = null;
        this._panel.setLayout(null);
        this._panel = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._ok || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this.setVisible(false);
        }
    }
}

