/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.SybButton;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sybase.isql.GUIDisplayTable;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.IODataClient;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLResource;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;
import sybase.isql.PromptDialog;
import sybase.isql.RowDataPrompt;
import sybase.isql.WindowManager;
import sybase.isql.isql;

class GUIIO
implements IO {
    private ParentFrame _parent = null;

    GUIIO(ParentFrame parentFrame) {
        this._parent = parentFrame;
    }

    void destroy() {
        this._parent = null;
    }

    private JFrame getParentFrame() {
        JFrame jFrame = this._parent == null ? (JFrame)WindowManager.getWindowManager().getActiveJFrame() : this._parent;
        return jFrame;
    }

    @Override
    public void writeln(String string, int n) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (eventQueue.isDispatchThread()) {
            this.openDialog(string, n);
        } else {
            try {
                final String string2 = string;
                final int n2 = n;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GUIIO.this.openDialog(string2, n2);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeln(Exception exception, String string, int n) {
        String string2;
        String string3 = ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL");
        if (exception instanceof SQLException) {
            StringBuilder stringBuilder = new StringBuilder(512);
            for (SQLException sQLException = (SQLException)exception; sQLException != null; sQLException = sQLException.getNextException()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n\n");
                }
                stringBuilder.append(isql.formatSQLExceptionMessage(sQLException));
            }
            string2 = stringBuilder.toString();
        } else {
            string2 = exception.getLocalizedMessage();
        }
        DetailsErrorDialog.showDetailsErrorDialog((Frame)this.getParentFrame(), (String)string3, (String)string, (String)string2, null);
    }

    private int convertMessageType(int n) {
        int n2;
        switch (n) {
            case 2: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    private void openDialog(String string, int n) {
        ISQLConnection iSQLConnection;
        int n2 = this.convertMessageType(n);
        String string2 = ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL");
        if (n == 2 && (iSQLConnection = isql.getConnectionFromIO(this)) != null && Preferences.getBooleanOption(iSQLConnection, "bell")) {
            Toolkit.getDefaultToolkit().beep();
        }
        SybOptionPane.showMessageDialog((Component)this.getParentFrame(), (Object)string, (String)string2, (int)n2);
    }

    @Override
    public int promptForOption(int n, String string, String string2, String[] stringArray, int n2, int n3) {
        int n4;
        block9: {
            n4 = n2;
            if (isql.options.quiet) break block9;
            int n5 = this.convertMessageType(n);
            if (string == null) {
                string = ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL");
            }
            if (n3 == 1) {
                int n6;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                ButtonGroup buttonGroup = new ButtonGroup();
                SybRadioButton[] sybRadioButtonArray = new SybRadioButton[stringArray.length];
                for (n6 = 0; n6 < stringArray.length; ++n6) {
                    sybRadioButtonArray[n6] = new SybRadioButton(stringArray[n6]);
                    buttonGroup.add((AbstractButton)sybRadioButtonArray[n6]);
                    if (n2 == n6) {
                        sybRadioButtonArray[n6].setSelected(true);
                    }
                    jPanel.add((Component)sybRadioButtonArray[n6]);
                }
                SybOptionPane.showMessageDialog((Component)this.getParentFrame(), (Object)new Object[]{string2, jPanel}, (String)string, (int)n5, null);
                for (n6 = 0; n6 < stringArray.length; ++n6) {
                    if (!sybRadioButtonArray[n6].isSelected()) continue;
                    n4 = n6;
                    break;
                }
            } else {
                int n7;
                Object[] objectArray = new SybButton[stringArray.length];
                class ButtonActionListener
                implements ActionListener {
                    ButtonActionListener() {
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JOptionPane jOptionPane = (JOptionPane)SwingUtilities.getAncestorOfClass(JOptionPane.class, (Component)actionEvent.getSource());
                        jOptionPane.setValue(actionEvent.getSource());
                    }
                }
                ButtonActionListener[] buttonActionListenerArray = new ButtonActionListener[stringArray.length];
                for (n7 = 0; n7 < stringArray.length; ++n7) {
                    objectArray[n7] = new SybButton(stringArray[n7]);
                    buttonActionListenerArray[n7] = new ButtonActionListener();
                    objectArray[n7].addActionListener((ActionListener)buttonActionListenerArray[n7]);
                }
                int n8 = SybOptionPane.showOptionDialog((Component)this.getParentFrame(), (Object)string2, (String)string, (int)0, (int)n5, null, (Object[])objectArray, (Object)objectArray[n2]);
                if (n8 != -1) {
                    n4 = n8;
                }
                for (n7 = 0; n7 < objectArray.length; ++n7) {
                    objectArray[n7].removeActionListener((ActionListener)buttonActionListenerArray[n7]);
                    objectArray[n7] = null;
                    buttonActionListenerArray[n7] = null;
                }
            }
        }
        return n4;
    }

    @Override
    public int promptForOptionWithAccessory(int n, String string, String string2, String[] stringArray, int n2, int n3, JComponent jComponent, String[] stringArray2) {
        int n4 = !isql.options.quiet ? PromptDialog.create(this.getParentFrame(), n, string, string2, stringArray, n2, n3, jComponent, stringArray2) : n2;
        return n4;
    }

    @Override
    public void promptForData(String string, String[] stringArray, Class[] classArray, Object[] objectArray, int n, IODataClient iODataClient) {
        RowDataPrompt.create(this.getParentFrame(), string, stringArray, classArray, objectArray, n, iODataClient);
    }

    @Override
    public void showProgress(String string, int n) {
        if (this._parent != null) {
            this._parent.showProgress(string, n);
        }
    }

    @Override
    public void setStatus(Object object, String string) {
        if (this._parent != null) {
            this._parent.updateStatusMessage((Icon)object, string);
        }
    }

    @Override
    public void displayTable(String string, String[] stringArray, String[][] stringArray2) {
        GUIDisplayTable.create(this.getParentFrame(), string, stringArray, stringArray2);
    }
}

