/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.customization.CustomizeDialog;
import com.sybase.util.Launcher;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import com.sybase.util.win32.Registry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import sybase.isql.BasePage;
import sybase.isql.FastLoaderConfigurationDialog;
import sybase.isql.FileAssociation;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLLoader;
import sybase.isql.ISQLResource;
import sybase.isql.Preferences;
import sybase.isql.UserDataComboBox;

class GeneralPage
extends BasePage
implements ActionListener {
    private boolean _opt_echoCommands;
    private boolean _opt_enableFastLoader;
    private String _opt_errorAction;
    private int _opt_fastLoaderPort;
    private int _opt_fastLoaderInactivityTimeout;
    private boolean _opt_associateISQLWithSQLFiles;
    private boolean _opt_setInitialFolderForFileBrowsers;
    private SybCheckBox _echoCommands;
    private UserDataComboBox _errorAction;
    private SybCheckBox _enableFastLoader = null;
    private SybButton _configureFastLoader = null;
    private SybCheckBox _associateISQLWithSQLFiles = null;
    private SybRadioButton _useCurrentFolderForFileBrowsers = null;
    private SybRadioButton _useLastFolderForFileBrowsers = null;
    private static String SCRIPT_FILE_ASSOCIATION_PROGID = "sybase.dbisql_script.11";
    private static String SAPLAN_FILE_ASSOCIATION_PROGID = "sybase.dbisql_saplan.11";
    private static String ASEPLAN_FILE_ASSOCIATION_PROGID = "sybase.dbisql_aseplan.11";

    GeneralPage(CustomizeDialog customizeDialog, ISQLConnection iSQLConnection) {
        super(customizeDialog, iSQLConnection);
        this.readSettings();
        this.createUI();
    }

    private void readSettings() {
        String string;
        this._opt_echoCommands = Preferences.getBooleanOption(this._connection, "echo", false);
        this._opt_errorAction = Preferences.getStringOption(this._connection, "on_error", false);
        this._opt_enableFastLoader = Preferences.fastLauncherEnabled;
        this._opt_fastLoaderPort = Preferences.fastLauncherPort;
        this._opt_fastLoaderInactivityTimeout = Preferences.fastLauncherTimeout;
        this._opt_associateISQLWithSQLFiles = false;
        if (GeneralPage.onWindows() && Registry.isInstalled() && (string = Registry.getValue((int)2, (String)".sql", null)) != null && (string = Registry.getValue((int)2, (String)(string + "\\SHELL\\OPEN\\COMMAND"), null)) != null && string.indexOf(ISQLLoader.getApplicationPath()) != -1) {
            this._opt_associateISQLWithSQLFiles = true;
        }
        this._opt_setInitialFolderForFileBrowsers = Preferences.getBooleanOption(this._connection, "setInitialFolderForFileBrowsers", false);
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = this.createCommandFilePanel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        jPanel = this.createFoldersPanel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        if (GeneralPage.onWindows()) {
            jPanel = this.createFastLoaderPanel();
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this.add((Component)jPanel, gridBagConstraints);
            jPanel = this.createFileAssociationPanel();
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this.add((Component)jPanel, gridBagConstraints);
        }
        Component component = Box.createVerticalGlue();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.add(component, gridBagConstraints);
    }

    @Override
    public void destroy() {
        this._echoCommands = null;
        this._errorAction.removeAllItems();
        this._errorAction = null;
        if (this._enableFastLoader != null) {
            this._enableFastLoader.removeActionListener((ActionListener)this);
            this._enableFastLoader = null;
        }
        if (this._configureFastLoader != null) {
            this._configureFastLoader.removeActionListener((ActionListener)this);
            this._configureFastLoader = null;
        }
        super.destroy();
    }

    private JPanel createFoldersPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ISQLResource.getISQLString(GeneralResources.getName(), "FolderForBrowsers")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.setAlignmentX(0.0f);
        SybLabel sybLabel = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "FoldersForBrowsersAbout"));
        jPanel.add((Component)sybLabel);
        jPanel.add(Box.createVerticalStrut(5));
        this._useLastFolderForFileBrowsers = new SybRadioButton(ISQLResource.getISQLString(GeneralResources.getName(), "UseLastFolderForBrowsers"));
        jPanel.add((Component)this._useLastFolderForFileBrowsers);
        this._useCurrentFolderForFileBrowsers = new SybRadioButton(ISQLResource.getISQLString(GeneralResources.getName(), "UseCurrentFolderForBrowsers"));
        jPanel.add((Component)this._useCurrentFolderForFileBrowsers);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._useCurrentFolderForFileBrowsers);
        buttonGroup.add((AbstractButton)this._useLastFolderForFileBrowsers);
        if (this._opt_setInitialFolderForFileBrowsers) {
            this._useLastFolderForFileBrowsers.setSelected(true);
        } else {
            this._useCurrentFolderForFileBrowsers.setSelected(true);
        }
        return jPanel;
    }

    private JPanel createFastLoaderPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ISQLResource.getISQLString(GeneralResources.getName(), "FastLoader")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.setAlignmentX(0.0f);
        this._enableFastLoader = new SybCheckBox(ISQLResource.getISQLString(GeneralResources.getName(), "EnableFastLoader"));
        this._enableFastLoader.addActionListener((ActionListener)this);
        jPanel.add((Component)this._enableFastLoader);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(Box.createHorizontalGlue());
        this._configureFastLoader = new SybButton(ISQLResource.getISQLString(GeneralResources.getName(), "ConfigureFastLoader"));
        this._configureFastLoader.addActionListener((ActionListener)this);
        jPanel.add((Component)this._configureFastLoader);
        if (this._opt_enableFastLoader) {
            this._enableFastLoader.setSelected(true);
            this._configureFastLoader.setEnabled(true);
        } else {
            this._configureFastLoader.setEnabled(false);
        }
        if (!Preferences.isFastLauncherChangeAllowed()) {
            this._enableFastLoader.setEnabled(false);
            this._configureFastLoader.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel createFileAssociationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ISQLResource.getISQLString(GeneralResources.getName(), "FileAssociation")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.setAlignmentX(0.0f);
        this._associateISQLWithSQLFiles = new SybCheckBox(ISQLResource.getISQLString(GeneralResources.getName(), "AssociateISQLWithSQLFiles"));
        if (this._opt_associateISQLWithSQLFiles) {
            this._associateISQLWithSQLFiles.setSelected(true);
        }
        jPanel.add((Component)this._associateISQLWithSQLFiles);
        if (Platform.isVista()) {
            SybLabel sybLabel = new SybLabel((Icon)ASAComponentsImageLoader.getImageIcon((String)"vistashield", (int)1001));
            jPanel.add((Component)sybLabel);
        }
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._enableFastLoader) {
            if (this._enableFastLoader.isSelected()) {
                this._configureFastLoader.setEnabled(true);
            } else {
                this._configureFastLoader.setEnabled(false);
            }
        } else if (object == this._configureFastLoader) {
            FastLoaderConfigurationDialog fastLoaderConfigurationDialog = new FastLoaderConfigurationDialog((Dialog)this._parent, this._opt_fastLoaderPort, this._opt_fastLoaderInactivityTimeout, 6267, 30);
            UIUtils.ensureWindowIsVisible((Window)fastLoaderConfigurationDialog);
            fastLoaderConfigurationDialog.setVisible(true);
            if (fastLoaderConfigurationDialog.isOK()) {
                this._opt_fastLoaderPort = fastLoaderConfigurationDialog.getPort();
                this._opt_fastLoaderInactivityTimeout = fastLoaderConfigurationDialog.getInactivityTimeout();
            }
            fastLoaderConfigurationDialog.destroy();
            fastLoaderConfigurationDialog = null;
        }
    }

    private JPanel createCommandFilePanel() {
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(iSQLResource.getISQLString("Command Files")), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        jPanel.setAlignmentX(0.0f);
        String[] stringArray = new String[]{iSQLResource.getISQLString("Continue"), iSQLResource.getISQLString("Exit"), iSQLResource.getISQLString("Notify and continue"), iSQLResource.getISQLString("Notify and exit"), iSQLResource.getISQLString("Notify and stop"), iSQLResource.getISQLString("Prompt"), iSQLResource.getISQLString("Stop")};
        Object[] objectArray = new Object[]{"Continue", "Exit", "Notify_continue", "Notify_exit", "Notify_stop", "Prompt", "Stop"};
        SybLabel sybLabel = new SybLabel(iSQLResource.getISQLString("When an error occurs:"));
        this._errorAction = new UserDataComboBox(stringArray, objectArray);
        this._errorAction.setSelectedByUserData(this._opt_errorAction);
        this._errorAction.setAlignmentX(0.0f);
        sybLabel.setLabelFor((Component)this._errorAction);
        jPanel.add((Component)sybLabel);
        jPanel.add(this._errorAction);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this._echoCommands = new SybCheckBox(iSQLResource.getISQLString("Echo command files to log"));
        jPanel.add((Component)this._echoCommands);
        this._echoCommands.setSelected(this._opt_echoCommands);
        jPanel.add((Component)this._echoCommands);
        return jPanel;
    }

    @Override
    public void acceptChanges() {
        int n = this._errorAction.getSelectedIndex();
        if (n != -1) {
            String string;
            this._opt_errorAction = string = (String)this._errorAction.getUserData(n);
        }
        this._opt_echoCommands = this._echoCommands.isSelected();
        if (this._enableFastLoader != null) {
            this._opt_enableFastLoader = this._enableFastLoader.isSelected();
        }
        this._opt_setInitialFolderForFileBrowsers = this._useLastFolderForFileBrowsers.isSelected();
        Preferences.setStringOption(this._connection, "on_error", this._opt_errorAction);
        Preferences.setBooleanOption(this._connection, "echo", this._opt_echoCommands);
        Preferences.setBooleanOption(this._connection, "setInitialFolderForFileBrowsers", this._opt_setInitialFolderForFileBrowsers);
        if (GeneralPage.onWindows()) {
            boolean bl;
            if (Preferences.fastLauncherEnabled != this._opt_enableFastLoader || Preferences.fastLauncherPort != this._opt_fastLoaderPort || Preferences.fastLauncherTimeout != this._opt_fastLoaderInactivityTimeout) {
                int n2 = Preferences.fastLauncherPort;
                Preferences.fastLauncherEnabled = this._opt_enableFastLoader;
                Preferences.fastLauncherPort = this._opt_fastLoaderPort;
                Preferences.fastLauncherTimeout = this._opt_fastLoaderInactivityTimeout;
                if (Package.getPackage("com.sybase.central") == null) {
                    Launcher.stopLauncher((int)n2);
                    if (this._opt_enableFastLoader) {
                        ISQLLoader.startLauncher();
                    }
                }
            }
            if (Registry.isInstalled() && (bl = this._associateISQLWithSQLFiles.isSelected()) != this._opt_associateISQLWithSQLFiles) {
                if (bl) {
                    this.associateDBISQLWithSQLFiles();
                } else {
                    this.disassociateDBISQLWithSQLFiles();
                }
                this._opt_associateISQLWithSQLFiles = bl;
            }
        }
    }

    private void associateDBISQLWithSQLFiles() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append('\"');
        stringBuilder.append(ISQLLoader.getApplicationPath());
        stringBuilder.append("\"");
        stringBuilder.append(" -f \"%1\"");
        FileAssociation.create(new String[]{".sql"}, ISQLResource.getISQLString(GeneralResources.getName(), "SQL_SCRIPT_FILE_TYPE"), SCRIPT_FILE_ASSOCIATION_PROGID, ISQLLoader.getApplicationPath() + ",-1001", stringBuilder.toString());
        FileAssociation.create(new String[]{".saplan"}, ISQLResource.getISQLString(GeneralResources.getName(), "SAPLAN_FILE_TYPE"), SAPLAN_FILE_ASSOCIATION_PROGID, ISQLLoader.getApplicationPath() + ",-1002", stringBuilder.toString());
        FileAssociation.create(new String[]{".aseplan"}, ISQLResource.getISQLString(GeneralResources.getName(), "ASEPLAN_FILE_TYPE"), ASEPLAN_FILE_ASSOCIATION_PROGID, ISQLLoader.getApplicationPath() + ",-1002", stringBuilder.toString());
    }

    private void disassociateDBISQLWithSQLFiles() {
        this.recursiveDeleteKey(2, SCRIPT_FILE_ASSOCIATION_PROGID);
        this.recursiveDeleteKey(2, SAPLAN_FILE_ASSOCIATION_PROGID);
        this.recursiveDeleteKey(2, ASEPLAN_FILE_ASSOCIATION_PROGID);
    }

    private void recursiveDeleteKey(int n, String string) {
        Vector vector = Registry.enumerateKeys((int)n, (String)string);
        for (int i = 0; i < vector.size(); ++i) {
            this.recursiveDeleteKey(n, string + "\\" + vector.elementAt(i).toString());
        }
        boolean bl = Registry.deleteKey((int)n, (String)string);
        if (!bl) {
            // empty if block
        }
    }

    @Override
    public Icon getCustomizationGroupIcon() {
        return ISQLImages.getImageIcon("isql16");
    }

    public String getTitle() {
        return ISQLResource.getISQLString(GeneralResources.getName(), "Commands");
    }

    public void showHelp() {
        ISQLHelpManager.showHelp((ISQLConnectionImpl)this._connection, (Window)this._parent, "HELP_ISQL_OPTIONS_GENERAL");
    }

    public Component getComponent() {
        return this;
    }

    static boolean onWindows() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows") != -1;
    }
}

