/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import sybase.isql.ErrorMessages;
import sybase.isql.HistoryItem;
import sybase.isql.ISQLResource;
import sybase.isql.isql;

class History {
    static final int BACK = -1;
    static final int FORWARD = 1;
    private static final String FILENAME = ".isqlHistory11";
    private static final int DEFAULT_MAXIMUM_SIZE = 50;
    private Vector<HistoryItem> _list = new Vector();
    private int _current = 0;
    private int _maximumSize = 50;

    History() {
    }

    void clear() {
        this._list.clear();
    }

    void add(HistoryItem historyItem) {
        if (this._list.size() > 0 && historyItem.sql.equals(this._list.elementAt((int)(this._list.size() - 1)).sql)) {
            return;
        }
        if (this._list.size() == this._maximumSize) {
            this._list.removeElementAt(0);
        }
        this._list.addElement(historyItem);
        this._current = this._list.size();
    }

    void removeItemAt(int n) {
        if (n < 0 || n >= this._list.size()) {
            throw new IllegalArgumentException("Index is " + n + ", but must be between 0 and " + (this._list.size() - 1));
        }
        this._list.remove(n);
        if (n < this._current) {
            --this._current;
        } else if (n == this._current) {
            ++this._current;
            if (this._current >= this._list.size()) {
                this._current = this._list.size() - 1;
            }
        }
    }

    int getPosition() {
        return this._current;
    }

    int size() {
        return this._list.size();
    }

    HistoryItem historyItemAt(int n) {
        HistoryItem historyItem = null;
        if (n >= 0 && n < this._list.size()) {
            historyItem = this._list.elementAt(n);
        }
        return historyItem;
    }

    boolean canMove(int n) {
        boolean bl = this._list.isEmpty() ? false : (n == 1 ? this._current < this._list.size() - 1 : this._current > 0);
        return bl;
    }

    HistoryItem move(int n) {
        HistoryItem historyItem = this.moveTo(this._current + n);
        return historyItem;
    }

    HistoryItem moveTo(int n) {
        HistoryItem historyItem;
        if (n >= 0 && n < this._list.size()) {
            this._current = n;
            historyItem = this._list.elementAt(this._current);
        } else {
            historyItem = null;
        }
        return historyItem;
    }

    private String getFileName() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(Platform.getUserConfigurationDirectory());
        stringBuffer.append(FILENAME);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        FilterOutputStream filterOutputStream = null;
        FileOutputStream fileOutputStream = null;
        Object var7_3 = null;
        Properties properties = new Properties();
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            String string = this._list.elementAt(i).getRawSQL();
            string = this.filterPasswords(string);
            properties.put(Integer.toString(i), string);
        }
        try {
            fileOutputStream = new FileOutputStream(this.getFileName());
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            properties.store(filterOutputStream, "");
        }
        catch (IOException iOException) {
            String string = ISQLResource.getFormattedString(ErrorMessages.getName(), "CouldNotSaveHistory", iOException.getMessage());
            isql.getDefaultIO().writeln(string, 2);
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String filterPasswords(String string) {
        int n;
        StringBuffer stringBuffer;
        String[] stringArray;
        boolean bl = false;
        SQLTokenizer sQLTokenizer = new SQLTokenizer(string);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
        while ((stringArray = sQLTokenizer.getStatementTokens()) != null) {
            arrayList.add(stringArray);
            stringBuffer = this.filterStatement(stringArray);
            bl |= stringBuffer != null;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                for (n = 0; n < stringArray.length; ++n) {
                    if (n > 0 && !stringArray[n].equals(";")) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(stringArray[n]);
                }
            }
            arrayList2.add(stringBuffer);
        }
        if (bl) {
            stringBuffer = new StringBuffer();
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != ';') {
                    stringBuffer.append(";");
                }
                stringBuffer.append(((StringBuffer)arrayList2.get(n)).toString());
            }
        } else {
            stringBuffer = null;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private StringBuffer filterStatement(String[] stringArray) {
        StringBuffer stringBuffer;
        block22: {
            int n;
            block28: {
                block27: {
                    block26: {
                        block24: {
                            block25: {
                                block23: {
                                    stringBuffer = null;
                                    n = stringArray.length;
                                    if (n <= 3 || !stringArray[0].equalsIgnoreCase("grant") || !stringArray[1].equalsIgnoreCase("connect") || !stringArray[2].equalsIgnoreCase("to")) break block23;
                                    boolean bl = false;
                                    stringBuffer = new StringBuffer();
                                    for (int i = 0; i < n; ++i) {
                                        if (i > 0) {
                                            stringBuffer.append(" ");
                                        }
                                        stringBuffer.append(stringArray[i]);
                                        if (!stringArray[i].equalsIgnoreCase("by") || i <= 0 || !stringArray[i - 1].equalsIgnoreCase("identified")) continue;
                                        stringBuffer.append(" ...");
                                        bl = true;
                                        break;
                                    }
                                    if (bl) break block22;
                                    stringBuffer = null;
                                    break block22;
                                }
                                if (n <= 2 || !stringArray[0].equalsIgnoreCase("connect")) break block24;
                                if (!stringArray[1].equalsIgnoreCase("using")) break block25;
                                boolean bl = false;
                                stringBuffer = new StringBuffer();
                                stringBuffer.append(stringArray[0]);
                                stringBuffer.append(" ");
                                stringBuffer.append(stringArray[1]);
                                for (int i = 2; i < n; ++i) {
                                    stringBuffer.append(" ");
                                    String string = stringArray[i].toLowerCase();
                                    if (string.indexOf("pwd") != -1 || string.indexOf("password") != -1) {
                                        bl = true;
                                        stringBuffer.append("'...'");
                                        break;
                                    }
                                    stringBuffer.append(stringArray[i]);
                                }
                                if (bl) break block22;
                                stringBuffer = null;
                                break block22;
                            }
                            boolean bl = false;
                            stringBuffer = new StringBuffer();
                            for (int i = 0; i < n; ++i) {
                                if (i > 0) {
                                    stringBuffer.append(" ");
                                }
                                stringBuffer.append(stringArray[i]);
                                if (!stringArray[i].equalsIgnoreCase("by") || i <= 0 || i >= n - 1 || !stringArray[i - 1].equalsIgnoreCase("identified")) continue;
                                bl = true;
                                stringBuffer.append(" ...");
                                break;
                            }
                            if (bl) break block22;
                            stringBuffer = null;
                            break block22;
                        }
                        if (n <= 4 || !stringArray[0].equalsIgnoreCase("create") || !stringArray[1].equalsIgnoreCase("database")) break block26;
                        boolean bl = false;
                        stringBuffer = new StringBuffer();
                        for (int i = 0; i < n; ++i) {
                            if (i > 0) {
                                stringBuffer.append(" ");
                            }
                            stringBuffer.append(stringArray[i]);
                            if (!stringArray[i].equalsIgnoreCase("password") || i <= 1 || i >= n - 1 || !stringArray[i - 1].equalsIgnoreCase("dba")) continue;
                            bl = true;
                            stringBuffer.append(" ...");
                            ++i;
                        }
                        if (bl) break block22;
                        stringBuffer = null;
                        break block22;
                    }
                    if (n <= 8 || !stringArray[0].equalsIgnoreCase("create") || !stringArray[1].equalsIgnoreCase("externlogin")) break block27;
                    boolean bl = false;
                    stringBuffer = new StringBuffer();
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(stringArray[i]);
                        if (!stringArray[i].equalsIgnoreCase("by") || i <= 0 || i >= n - 1 || !stringArray[i - 1].equalsIgnoreCase("identified")) continue;
                        bl = true;
                        stringBuffer.append(" ...");
                        break;
                    }
                    if (bl) break block22;
                    stringBuffer = null;
                    break block22;
                }
                if (n <= 7 || !stringArray[0].equalsIgnoreCase("grant") || !stringArray[1].equalsIgnoreCase("remote") || !stringArray[2].equalsIgnoreCase("dba") || !stringArray[3].equalsIgnoreCase("to")) break block28;
                boolean bl = false;
                stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(stringArray[i]);
                    if (!stringArray[i].equalsIgnoreCase("by") || i <= 0 || i >= n - 1 || !stringArray[i - 1].equalsIgnoreCase("identified")) continue;
                    bl = true;
                    stringBuffer.append(" ...");
                    break;
                }
                if (bl) break block22;
                stringBuffer = null;
                break block22;
            }
            if (n == 8 && stringArray[0].equalsIgnoreCase("create") && stringArray[1].equalsIgnoreCase("decrypted") && stringArray[2].equalsIgnoreCase("database") && stringArray[4].equalsIgnoreCase("from") && stringArray[6].equalsIgnoreCase("key")) {
                stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(' ');
                    }
                    if (i == 7) {
                        stringBuffer.append("...");
                        break;
                    }
                    stringBuffer.append(stringArray[i]);
                }
            } else if (n > 6 && stringArray[0].equalsIgnoreCase("create") && stringArray[1].equalsIgnoreCase("encrypted") && (stringArray[2].equalsIgnoreCase("database") || stringArray[2].equalsIgnoreCase("table") && stringArray[3].equalsIgnoreCase("database"))) {
                stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(' ');
                    }
                    if (i >= 6 && i < n - 2 && stringArray[i].equalsIgnoreCase("old") && stringArray[i + 1].equalsIgnoreCase("key")) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(' ');
                        stringBuffer.append(stringArray[i + 1]);
                        stringBuffer.append(" ...");
                        i += 2;
                        continue;
                    }
                    if (i >= 6 && stringArray[i].equalsIgnoreCase("key") && i < n - 1) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(" ...");
                        ++i;
                        continue;
                    }
                    stringBuffer.append(stringArray[i]);
                }
            }
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        this._list = new Vector();
        try {
            fileInputStream = new FileInputStream(this.getFileName());
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            properties.load(bufferedInputStream);
            if (!properties.isEmpty()) {
                for (int i = 0; i < properties.size(); ++i) {
                    String string = Integer.toString(i);
                    String string2 = properties.getProperty(string);
                    if (string2 == null || string2.length() <= 0) continue;
                    this._list.add(new HistoryItem(string2));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            String string = ISQLResource.getFormattedString(ErrorMessages.getName(), "CouldNotLoadHistory", iOException.getMessage());
            isql.getDefaultIO().writeln(string, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = ISQLResource.getISQLString(ErrorMessages.getName(), "HISTORY_FILE_IS_CORRUPT");
            String string3 = ISQLResource.getFormattedString(ErrorMessages.getName(), "CouldNotLoadHistory", string);
            isql.getDefaultIO().writeln(string3, 1);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            this._current = this._list.size();
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static class SQLTokenizer {
        static final int NORMAL = 1;
        static final int IN_SINGLE_LINE_COMMENT = 2;
        static final int IN_C_COMMENT = 3;
        static final int IN_SINGLE_QUOTED_STRING = 4;
        static final int IN_DOUBLE_QUOTED_STRING = 5;
        static final int IN_BRACKETED_IDENTIFIER = 6;
        String _sql;
        int _state = 1;
        boolean _eof = false;
        int _scanIndex = 0;

        SQLTokenizer(String string) {
            this._sql = string;
        }

        String[] getStatementTokens() {
            String string;
            String[] stringArray = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!this._eof && (string = this.scanToken()) != null) {
                arrayList.add(string);
                if (!string.endsWith(";")) continue;
            }
            if (arrayList.size() != 0) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            }
            return stringArray;
        }

        private String scanToken() {
            StringBuffer stringBuffer = new StringBuffer();
            block8: while (this._scanIndex < this._sql.length()) {
                char c = this._sql.charAt(this._scanIndex);
                switch (this._state) {
                    case 1: {
                        if (c == '-' && this._scanIndex < this._sql.length() - 1 && this._sql.charAt(this._scanIndex + 1) == '-') {
                            this._state = 2;
                            ++this._scanIndex;
                            if (stringBuffer.length() <= 0) continue block8;
                            break block8;
                        }
                        if (c == '/' && this._scanIndex < this._sql.length() - 1 && this._sql.charAt(this._scanIndex + 1) == '/') {
                            this._state = 2;
                            ++this._scanIndex;
                            if (stringBuffer.length() <= 0) continue block8;
                            break block8;
                        }
                        if (c == '%') {
                            this._state = 2;
                            ++this._scanIndex;
                            if (stringBuffer.length() <= 0) continue block8;
                            break block8;
                        }
                        if (c == '/' && this._scanIndex < this._sql.length() - 1 && this._sql.charAt(this._scanIndex + 1) == '*') {
                            this._state = 3;
                            this._scanIndex += 2;
                            if (stringBuffer.length() <= 0) continue block8;
                            break block8;
                        }
                        if (c == '\'') {
                            if (stringBuffer.length() > 0) break block8;
                            this._state = 4;
                            ++this._scanIndex;
                            stringBuffer.append(c);
                            continue block8;
                        }
                        if (c == '\"') {
                            if (stringBuffer.length() > 0) break block8;
                            this._state = 5;
                            stringBuffer.append(c);
                            ++this._scanIndex;
                            continue block8;
                        }
                        if (c == '[') {
                            if (stringBuffer.length() > 0) break block8;
                            this._state = 6;
                            stringBuffer.append(c);
                            ++this._scanIndex;
                            continue block8;
                        }
                        if (c == ';') {
                            stringBuffer.append(c);
                            ++this._scanIndex;
                            break block8;
                        }
                        if (Character.isWhitespace(c)) {
                            ++this._scanIndex;
                            if (stringBuffer.length() <= 0) continue block8;
                            break block8;
                        }
                        stringBuffer.append(c);
                        ++this._scanIndex;
                        continue block8;
                    }
                    case 2: {
                        if (c == '\r') {
                            if (this._scanIndex < this._sql.length() - 1 && this._sql.charAt(this._scanIndex + 1) == '\n') {
                                ++this._scanIndex;
                            }
                            ++this._scanIndex;
                            this._state = 1;
                            continue block8;
                        }
                        if (c == '\n') {
                            ++this._scanIndex;
                            this._state = 1;
                            continue block8;
                        }
                        ++this._scanIndex;
                        continue block8;
                    }
                    case 3: {
                        if (c == '*' && this._scanIndex < this._sql.length() - 1 && this._sql.charAt(this._scanIndex + 1) == '/') {
                            this._scanIndex += 2;
                            this._state = 1;
                            continue block8;
                        }
                        ++this._scanIndex;
                        continue block8;
                    }
                    case 4: {
                        if (c == '\'') {
                            stringBuffer.append(c);
                            if (this._scanIndex < this._sql.length() - 1 && this._sql.charAt(this._scanIndex + 1) == '\'') {
                                stringBuffer.append(c);
                                this._scanIndex += 2;
                                continue block8;
                            }
                            this._state = 1;
                            ++this._scanIndex;
                            break block8;
                        }
                        stringBuffer.append(c);
                        ++this._scanIndex;
                        continue block8;
                    }
                    case 5: {
                        if (c == '\"') {
                            stringBuffer.append(c);
                            if (this._scanIndex < this._sql.length() - 1 && this._sql.charAt(this._scanIndex + 1) == '\"') {
                                stringBuffer.append(c);
                                this._scanIndex += 2;
                                continue block8;
                            }
                            this._state = 1;
                            ++this._scanIndex;
                            break block8;
                        }
                        stringBuffer.append(c);
                        ++this._scanIndex;
                        continue block8;
                    }
                    case 6: {
                        ++this._scanIndex;
                        if (c == ']') {
                            stringBuffer.append(c);
                            this._state = 1;
                            break block8;
                        }
                        stringBuffer.append(c);
                        continue block8;
                    }
                    default: {
                        throw new RuntimeException("SQLTokenizer: Unhandled parser state " + this._state);
                    }
                }
            }
            if (this._scanIndex == this._sql.length()) {
                this._eof = true;
            }
            return stringBuffer.toString().trim();
        }
    }
}

