/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.central.editor.SCEditor;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import sybase.isql.GeneralResources;
import sybase.isql.History;
import sybase.isql.HistoryItem;
import sybase.isql.HistoryResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;
import sybase.isql.Preferences;

class HistoryListDialog
extends JDialog
implements ActionListener,
MouseListener,
ListSelectionListener {
    private static final String ESCAPE_KEY_COMMAND = "escapeKey";
    private static final int FIELD_WIDTH = 10;
    private static final int VERT_SPACING = 8;
    private static final int MAJOR_VERT_SPACING = 16;
    private static final int HORIZ_SPACING = 5;
    private static final int HORIZ_INDENT = 16;
    private static final int DEFAULT_LIST_WIDTH = 400;
    private static final int DEFAULT_LIST_HEIGHT = 160;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _clearHistory = null;
    private SybButton _copy = null;
    private JButton _delete = null;
    private JButton _save = null;
    private JTable _list = null;
    private History _history = null;
    private ISQLConnection _connection = null;
    private DeleteHistoryItemAction _deleteHistoryItemAction = null;
    private CopyHistoryItemAction _copyHistoryItemAction = null;
    private SaveHistoryAction _saveHistoryAction = null;
    private boolean _retcode;
    private int[] _selectedHistoryIndices = null;
    private String _selectedHistoryText = null;

    HistoryListDialog(JFrame jFrame) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    boolean create(History history, ISQLConnection iSQLConnection) {
        this._history = history;
        this._connection = iSQLConnection;
        this._retcode = false;
        this._selectedHistoryIndices = null;
        this._selectedHistoryText = null;
        this.createGUI();
        Rectangle rectangle = Preferences.loadWindowSize(iSQLConnection, "historyWindowPosition");
        if (rectangle == null) {
            this.setLocationRelativeTo(this.getParent());
        } else {
            this.setBounds(rectangle);
        }
        UIUtils.ensureWindowIsVisible((Window)this);
        this.setVisible(true);
        Preferences.saveWindowSize(iSQLConnection, "historyWindowPosition", this.getBounds());
        this.destroyGUI();
        this._history = null;
        this._connection = null;
        return this._retcode;
    }

    int[] getSelectedHistoryIndices() {
        return this._selectedHistoryIndices;
    }

    String getSelectedText() {
        return this._selectedHistoryText;
    }

    private void createGUI() {
        ISQLResource iSQLResource = ISQLResource.getISQLResource("HistoryResources");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this._list = new MinimumWidthJTable(400);
        this._list.getTableHeader().setReorderingAllowed(false);
        this._list.setAutoResizeMode(0);
        this._list.setFont(new SCEditor().getFont());
        this._list.setDragEnabled(false);
        this._list.setDefaultRenderer(Object.class, new VariableHeightRenderer());
        this._list.addMouseListener(this);
        this._list.getSelectionModel().addListSelectionListener(this);
        TreeSet<KeyStroke> treeSet = new TreeSet<KeyStroke>();
        treeSet.add(KeyStroke.getKeyStroke(9, 0));
        this._list.setFocusTraversalKeys(0, treeSet);
        treeSet = new TreeSet();
        treeSet.add(KeyStroke.getKeyStroke(9, 1));
        this._list.setFocusTraversalKeys(1, treeSet);
        InputMap inputMap = this._list.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteHistoryItem");
        inputMap.put(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "saveHistory");
        ActionMap actionMap = this._list.getActionMap();
        this._deleteHistoryItemAction = new DeleteHistoryItemAction();
        this._copyHistoryItemAction = new CopyHistoryItemAction();
        this._saveHistoryAction = new SaveHistoryAction();
        actionMap.put("deleteHistoryItem", this._deleteHistoryItemAction);
        actionMap.put("copy", this._copyHistoryItemAction);
        actionMap.put("saveHistory", this._saveHistoryAction);
        this._list.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HistoryListDialog.this.handleOKClick();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this._copy = new SybButton((Icon)ISQLImages.getButtonIcon("copy"));
        this._copy.setFocusable(false);
        this._copy.setMargin(new Insets(2, 2, 2, 2));
        this._copy.addActionListener((ActionListener)this);
        this._copy.setToolTipText(iSQLResource.getISQLString("CopyButtonTooltip"));
        this._delete = new SybButton((Icon)ISQLImages.getButtonIcon("delete"));
        this._delete.setFocusable(false);
        this._delete.setMargin(new Insets(2, 2, 2, 2));
        this._delete.addActionListener(this);
        this._delete.setToolTipText(iSQLResource.getISQLString("DeleteButtonTooltip"));
        this._save = new SybButton((Icon)ISQLImages.getButtonIcon("save"));
        this._save.setFocusable(false);
        this._save.setMargin(new Insets(2, 2, 2, 2));
        this._save.addActionListener(this);
        this._save.setToolTipText(iSQLResource.getISQLString("SaveButtonTooltip"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._copy);
        jPanel2.add(this._delete);
        jPanel2.add(this._save);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this._clearHistory = new SybButton(iSQLResource.getISQLString("ClearHistory"));
        this._clearHistory.addActionListener((ActionListener)this);
        this._ok = new SybButton();
        this._ok.addActionListener((ActionListener)this);
        this._ok.setText(iSQLResource.getISQLString("OK"));
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._cancel = new SybButton();
        this._cancel.addActionListener((ActionListener)this);
        this._cancel.setText(iSQLResource.getISQLString("Cancel"));
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        DialogUtils.makeComponentsSameWidth((JComponent[])new JButton[]{this._ok, this._cancel});
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._clearHistory);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add((Component)this._ok);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add((Component)this._cancel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        this._list.setModel(new HistoryListModel(this._history));
        this.setRowHeightsAndColumnWidths(this._list);
        int n = this._history.getPosition();
        if (n > 0 && n <= this._list.getRowCount()) {
            this._list.setRowSelectionInterval(n - 1, n - 1);
            this.ensureRowIsVisible(this._list, n - 1);
        }
        this.setTitle(iSQLResource.getISQLString("CommandHistory"));
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this._list.requestFocus();
    }

    private void setRowHeightsAndColumnWidths(JTable jTable) {
        Dimension dimension;
        int n = 400;
        VariableHeightRenderer variableHeightRenderer = new VariableHeightRenderer();
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            Object object = jTable.getValueAt(i, 0);
            Component component = variableHeightRenderer.getTableCellRendererComponent(jTable, object, false, false, i, 0);
            dimension = component.getPreferredSize();
            jTable.setRowHeight(i, dimension.height);
            n = Math.max(n, dimension.width);
        }
        n += 2;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (tableColumnModel != null && tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.getColumn(0).setPreferredWidth(n);
        }
        dimension = new Dimension(n, 160);
        jTable.setPreferredScrollableViewportSize(dimension);
        jTable.doLayout();
    }

    private void destroyGUI() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._ok.removeActionListener((ActionListener)this);
        this._ok = null;
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._clearHistory.removeActionListener((ActionListener)this);
        this._clearHistory = null;
        this._copy.removeActionListener((ActionListener)this);
        this._copy = null;
        this._delete.removeActionListener(this);
        this._delete = null;
        this._save.removeActionListener(this);
        this._save = null;
        this._list.getActionMap().remove("deleteHistoryItem");
        this._deleteHistoryItemAction = null;
        this._list.getActionMap().remove("copy");
        this._copyHistoryItemAction = null;
        this._list.getActionMap().remove("saveHistory");
        this._saveHistoryAction = null;
        this._list.getSelectionModel().removeListSelectionListener(this);
        this._list.removeMouseListener(this);
        this._list = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOKClick();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this.handleCancelClick();
        } else if (object == this._clearHistory) {
            this.handleClearHistory();
        } else if (object == this._copy) {
            this.handleCopy();
        } else if (object == this._delete) {
            this.handleDelete();
        } else if (object == this._save) {
            this.handleSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSave() {
        SybFileChooser sybFileChooser = new SybFileChooser(18);
        SybFileFilter sybFileFilter = new SybFileFilter("sql", ISQLResource.getISQLString(GeneralResources.getName(), "SQL Statements (*.{0})"), null);
        sybFileChooser.setFilters(new SybFileFilter[]{sybFileFilter}, 0);
        sybFileChooser.setDefaultExtension("sql");
        if (sybFileChooser.showDialog((Window)this, null, null)) {
            File file = sybFileChooser.getSelectedFile();
            BufferedWriter bufferedWriter = null;
            boolean bl = false;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                String string = this.getCommandDelimiter();
                int n = this._history.size();
                for (int i = 0; i < n; ++i) {
                    HistoryItem historyItem = this._history.historyItemAt(i);
                    bufferedWriter.write(historyItem.getRawSQL());
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                bl = true;
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!bl) {
                    file.delete();
                }
            }
        }
    }

    private void handleCopy() {
        int[] nArray = this._list.getSelectedRows();
        if (nArray != null && nArray.length != 0) {
            String string = this.getCommandDelimiter();
            StringBuffer stringBuffer = new StringBuffer(512);
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                HistoryItem historyItem = this._history.historyItemAt(nArray[i]);
                stringBuffer.append(historyItem.getRawSQL());
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    private String getCommandDelimiter() {
        String string = this._connection != null ? Preferences.getPluginStringPreference((ISQLConnectionImpl)this._connection, "commandDelimiter", ";") : ";";
        return string;
    }

    private void handleDelete() {
        int n = -1;
        int[] nArray = this._list.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this._history.removeItemAt(nArray[i]);
            }
            this._list.setModel(new HistoryListModel(this._history));
            this.setRowHeightsAndColumnWidths(this._list);
            n = nArray[0];
            if (n > this._history.size() - 1) {
                n = this._history.size() - 1;
            }
            if (n >= 0) {
                this._list.setRowSelectionInterval(n, n);
                this.ensureRowIsVisible(this._list, n);
            }
        }
    }

    private void ensureRowIsVisible(JTable jTable, int n) {
        Rectangle rectangle = jTable.getCellRect(n, 0, true);
        jTable.scrollRectToVisible(rectangle);
    }

    private void handleClearHistory() {
        ISQLResource iSQLResource = ISQLResource.getISQLResource("HistoryResources");
        String string = iSQLResource.getISQLString("ConfirmClear");
        try {
            int n = SybOptionPane.showConfirmDialog((Component)this, (Object)string, (String)this.getTitle(), (int)0);
            if (n == 0) {
                this._history.clear();
                this._list.setModel(new DefaultTableModel());
                this.setRowHeightsAndColumnWidths(this._list);
            }
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    private void handleOKClick() {
        int[] nArray;
        int n = this._history.size();
        if (n > 0 && (nArray = this._list.getSelectedRows()) != null && nArray.length > 0) {
            String string = this.getCommandDelimiter();
            StringBuffer stringBuffer = new StringBuffer(512);
            this._selectedHistoryIndices = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this._selectedHistoryIndices[i] = nArray[i];
                if (i > 0) {
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                stringBuffer.append(this._history.historyItemAt(this._selectedHistoryIndices[i]).getRawSQL());
            }
            this._selectedHistoryText = stringBuffer.toString();
        }
        this._retcode = true;
        this.setVisible(false);
    }

    private void handleCancelClick() {
        this._retcode = false;
        this.setVisible(false);
    }

    private void enableButtons() {
        boolean bl = false;
        if (this._list != null && this._list.getSelectedRows().length > 0) {
            Object object = this._list.getValueAt(this._list.getSelectedRow(), 0);
            bl = object != null;
        }
        this._copy.setEnabled(bl);
        this._delete.setEnabled(bl);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.handleOKClick();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.enableButtons();
        }
    }

    static class HistoryListModel
    extends AbstractTableModel {
        History _history;

        HistoryListModel(History history) {
            this._history = history;
        }

        @Override
        public int getRowCount() {
            return this._history.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return ISQLResource.getISQLString(HistoryResources.getName(), "SQLStatements");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = this._history.historyItemAt(n).getRawSQL();
            return string;
        }
    }

    static class VariableHeightRenderer
    implements TableCellRenderer {
        private static Border EmptyBorder = null;
        private static Border FocusBorder = null;

        VariableHeightRenderer() {
            if (EmptyBorder == null) {
                EmptyBorder = BorderFactory.createEmptyBorder(5, 2, 5, 2);
                FocusBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("Table.focusCellHighlightBorder"), BorderFactory.createEmptyBorder(2, 1, 2, 1));
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            if (bl) {
                jPanel.setForeground(jTable.getSelectionForeground());
                jPanel.setBackground(jTable.getSelectionBackground());
            } else {
                jPanel.setForeground(jTable.getForeground());
                Color color = jTable.getBackground();
                if ((n & 1) == 1) {
                    int n3 = color.getRGB();
                    int n4 = (n3 & 0xFF0000) >>> 16;
                    int n5 = (n3 & 0xFF00) >>> 8;
                    int n6 = n3 & 0xFF;
                    n3 = jTable.getSelectionBackground().getRGB();
                    int n7 = (n3 & 0xFF0000) >>> 16;
                    int n8 = (n3 & 0xFF00) >>> 8;
                    int n9 = n3 & 0xFF;
                    int n10 = (n7 - n4) / 10;
                    n4 = n10 > 0 ? Math.min(255, n4 + n10) : Math.max(0, n4 + n10);
                    n10 = (n8 - n5) / 10;
                    n5 = n10 > 0 ? Math.min(255, n5 + n10) : Math.max(0, n5 + n10);
                    n10 = (n9 - n6) / 10;
                    n6 = n10 > 0 ? Math.min(255, n6 + n10) : Math.max(0, n6 + n10);
                    color = new Color(n4, n5, n6);
                }
                jPanel.setBackground(color);
            }
            if (bl2) {
                jPanel.setBorder(FocusBorder);
            } else {
                jPanel.setBorder(EmptyBorder);
            }
            String string = object.toString();
            String[] stringArray = string.split("[\\n\\r]");
            Font font = jTable.getFont();
            for (int i = 0; i < stringArray.length; ++i) {
                JLabel jLabel = new JLabel(stringArray[i]);
                jLabel.setFont(font);
                if (bl) {
                    jLabel.setForeground(jTable.getSelectionForeground());
                }
                jPanel.add(jLabel);
            }
            return jPanel;
        }
    }

    class SaveHistoryAction
    extends AbstractAction {
        SaveHistoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HistoryListDialog.this.handleSave();
        }
    }

    class CopyHistoryItemAction
    extends AbstractAction {
        CopyHistoryItemAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HistoryListDialog.this.handleCopy();
        }
    }

    class DeleteHistoryItemAction
    extends AbstractAction {
        DeleteHistoryItemAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HistoryListDialog.this.handleDelete();
        }
    }

    private static class MinimumWidthJTable
    extends JTable {
        private int _minimumWidth = -1;

        MinimumWidthJTable(int n) {
            this._minimumWidth = n;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this._minimumWidth != -1 && dimension.width < this._minimumWidth) {
                dimension.width = this._minimumWidth;
            }
            return dimension;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            if (dimension.width > 400) {
                dimension.width = 400;
            }
            return dimension;
        }
    }
}

