/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.asa.logon.ASAConnectionInfo;
import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.util.EventQueuePumper;
import java.awt.EventQueue;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.SwingUtilities;
import sybase.isql.ColumnInfo;
import sybase.isql.DataTypeMetaData;
import sybase.isql.Dbg;
import sybase.isql.DescribeOption;
import sybase.isql.DriverType;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLPluginException;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.ISQLResultSetImpl;
import sybase.isql.IdentifierType;
import sybase.isql.ImporterFailedException;
import sybase.isql.JConnectConnectionProxy;
import sybase.isql.ParentFrame;
import sybase.isql.PostLoginProcedureHandler;
import sybase.isql.Preferences;
import sybase.isql.ResultsProcessor;
import sybase.isql.StaticResultSet;
import sybase.isql.TableGenitor;
import sybase.isql.TableInfo;
import sybase.isql.WindowManager;
import sybase.isql.isql;

class ISQLConnectionImpl
implements ISQLConnection,
Runnable {
    private static final int SQL_WCHAR = -8;
    private static final int SQL_WVARCHAR = -9;
    private static final int SQL_WLONGVARCHAR = -10;
    private static final int REQ_CONNECT = 1;
    private static final int REQ_DISCONNECT = 2;
    private static final int REQ_EXECUTE = 3;
    private static final int REQ_CHECK_SYNTAX = 4;
    private static final int REQ_CREATE_TABLE = 5;
    private static final int REQ_LIST_TABLES = 6;
    private static final int REQ_LIST_PROCEDURES = 7;
    private static final int REQ_ADD_TABLE_DATA = 8;
    private static final int REQ_GET_SERVER_NAME = 9;
    private static final int REQ_GET_TABLE_INFO = 10;
    private static final int REQ_TABLE_EXISTS = 11;
    private static final int REQ_GET_COLUMN_NAMES = 12;
    private static final int REQ_DISAMBIGUATE_IDENTIFIER = 13;
    private static final int REQ_LIST_OPTIONS = 14;
    private static final int REQ_CALLBACK = 15;
    private static final int REQ_ASYNC_CALLBACK = 16;
    private static final int REQ_GET_DATABASE_NAMES = 17;
    private static final int REQ_GET_CATALOG = 18;
    private static final int REQ_SET_CATALOG = 19;
    private static final int REQ_DESCRIBE = 20;
    private static final int MAX_CURSOR_COUNT = 255;
    private Connection _connection = null;
    private DriverType _driverType = DriverType.JDBC_ODBC;
    private JConnectConnectionProxy _jconnectConnectionProxy = null;
    private PreparedStatement _statement;
    private boolean _connected = false;
    private int _maxRows = Integer.MAX_VALUE;
    private Vector<ResultSetListItem> _resultSetList = new Vector();
    private String _lastSQLStatement = null;
    private int _databaseType = -1;
    private String _databaseProductName = null;
    private Thread _worker = null;
    private volatile Request _request = null;
    private volatile boolean _requestDone = false;
    private boolean _inClientAsyncCallback = false;
    private int _updateCount = -1;
    private boolean _interruptRequested = false;
    private static int _cursorCount = 0;
    private String _userName = null;
    private String _catalog = null;
    private boolean _isUtilityDatabase = false;
    private boolean _missingJConnectSupport = false;
    private AbstractConnectionInfo _connectionInfo = null;
    private boolean _disconnectAfterRequestFinished = false;
    private DataTypeMetaData[] _dataTypes = null;
    private String _databaseProductVersion = null;
    private boolean _supportsSchemas = true;
    private boolean _supportsCatalogs = false;
    private Statement _previousStatement = null;
    private boolean _isFirstStatementInBatch = true;
    private Vector<String> _bufferedAsyncMessages = null;
    private ISQLPlugin _plugin = null;

    ISQLConnectionImpl() {
    }

    ISQLConnectionImpl(ISQLPlugin iSQLPlugin, AbstractConnectionInfo abstractConnectionInfo) {
        this.setConnectionInfo(iSQLPlugin, abstractConnectionInfo);
    }

    void setConnectionInfo(ISQLPlugin iSQLPlugin, AbstractConnectionInfo abstractConnectionInfo) {
        this._plugin = iSQLPlugin;
        this._connectionInfo = abstractConnectionInfo != null ? (AbstractConnectionInfo)abstractConnectionInfo.clone() : null;
    }

    ISQLPlugin getPlugin() {
        return this._plugin;
    }

    @Override
    public Connection getJDBCConnection() {
        return this._connection;
    }

    private void createWorkerThread() {
        if (this._worker == null) {
            this._worker = new Thread((Runnable)this, "Database interface thread");
            this._worker.start();
            Thread.currentThread();
            Thread.yield();
        }
    }

    private void releaseData() {
        if (this._resultSetList != null) {
            this._resultSetList.removeAllElements();
        }
        this._updateCount = -1;
        if (this._statement != null) {
            try {
                this._statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._statement = null;
        }
        if (this._connection != null) {
            this._connection = null;
        }
        this._jconnectConnectionProxy = null;
        this._lastSQLStatement = null;
        this._connected = false;
        this._databaseType = -1;
        this._databaseProductName = null;
        this._userName = null;
        this._catalog = null;
        this._isUtilityDatabase = false;
        this._dataTypes = null;
        if (this._connectionInfo != null) {
            this._connectionInfo.setPassword(null);
        }
    }

    void updateCachedPreferences() {
        this._maxRows = Preferences.getPluginIntPreference(this, "maximumDisplayedRows", "500");
    }

    @Override
    public void run() {
        Request request;
        Thread.currentThread().setPriority(4);
        while ((request = this.dequeueRequest()) != null) {
            if (!this._connected && request.type != 1 && request.type != 2) {
                if (request instanceof ExecuteRequest) {
                    ((ExecuteRequest)request).errorMessage = ISQLResource.getISQLString(ErrorMessages.getName(), "You are not connected to a database.");
                }
            } else {
                try {
                    switch (request.type) {
                        case 1: {
                            this.handleConnect((ConnectRequest)request);
                            break;
                        }
                        case 2: {
                            this.handleDisconnect();
                            break;
                        }
                        case 3: {
                            this.handleExecute((ExecuteRequest)request);
                            break;
                        }
                        case 20: {
                            this.handleDescribe((DescribeRequest)request);
                            break;
                        }
                        case 4: {
                            this.handleCheckSyntax((CheckSyntaxRequest)request);
                            break;
                        }
                        case 5: {
                            this.handleCreateTable(request);
                            break;
                        }
                        case 6: {
                            this.handleListTables(request);
                            break;
                        }
                        case 7: {
                            this.handleListProcedures(request);
                            break;
                        }
                        case 8: {
                            this.handleAddTableData(request);
                            break;
                        }
                        case 9: {
                            this.handleGetServerName(request);
                            break;
                        }
                        case 17: {
                            this.handleGetDatabaseNames(request);
                            break;
                        }
                        case 18: {
                            this.handleGetCatalog(request);
                            break;
                        }
                        case 19: {
                            this.handleSetCatalog(request);
                            break;
                        }
                        case 10: {
                            this.handleGetTableInfo(request);
                            break;
                        }
                        case 11: {
                            this.handleTableExists((TableExistsRequest)request);
                            break;
                        }
                        case 12: {
                            this.handleGetColumnNames(request);
                            break;
                        }
                        case 14: {
                            this.handleListOptions((ListOptionsRequest)request);
                            break;
                        }
                        case 15: {
                            this.handleCallback(request);
                            break;
                        }
                        case 16: {
                            this.removeRequest();
                            this._inClientAsyncCallback = true;
                            this.handleCallback(request);
                            this._inClientAsyncCallback = false;
                            if (((CallbackRequest)request).e != null) {
                                ExceptionHandler.handleException((Throwable)((CallbackRequest)request).e);
                            }
                            if (!isql.useGUI()) break;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    isql.enableUIForConnection(ISQLConnectionImpl.this, false);
                                    isql.enableUIForConnection(ISQLConnectionImpl.this, true);
                                }
                            });
                            break;
                        }
                        case 13: {
                            this.handleDisambiguateIdentifier((DisambiguateIdentifierRequest)request);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof OutOfMemoryError) {
                        try {
                            System.out.println("*** OutOfMemoryError ***");
                            System.out.println("Request type=" + request.type);
                            System.out.println("Request =" + request);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    request.runtimeError = throwable;
                }
            }
            if (request.type == 2) {
                this._worker = null;
            }
            if (request.type != 16) {
                this.removeRequest();
            }
            if (request.type != 2) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListOptions(ListOptionsRequest listOptionsRequest) {
        Statement statement = null;
        int n = this.getDatabaseType();
        if (n != 0 && n != 2) {
            listOptionsRequest.ok = true;
            return;
        }
        try {
            statement = this.createReadOnlyStatement();
            if (this._connection.getMetaData().getDatabaseMajorVersion() >= 10) {
                listOptionsRequest.ok = statement.execute("select OptionName,Value from dbo.sa_conn_options(-1) order by OptionName");
                if (listOptionsRequest.ok) {
                    ResultSet resultSet = statement.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        if (string.equalsIgnoreCase("connection_authentication")) continue;
                        listOptionsRequest.names.add(string);
                        listOptionsRequest.values.add(string2);
                    }
                    resultSet.close();
                }
            } else {
                listOptionsRequest.ok = statement.execute("call sa_conn_properties()");
                if (listOptionsRequest.ok) {
                    String string;
                    String string3;
                    Properties properties = new Properties();
                    ResultSet resultSet = statement.getResultSet();
                    while (resultSet.next()) {
                        string3 = resultSet.getString(3);
                        string = resultSet.getString(5);
                        if (string3.equalsIgnoreCase("connection_authentication")) continue;
                        properties.setProperty(string3, string);
                    }
                    resultSet.close();
                    String[] stringArray = new String[properties.size()];
                    int n2 = 0;
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        stringArray[n2++] = enumeration.nextElement().toString();
                    }
                    Arrays.sort(stringArray, new Comparator<String>(){
                        Collator _collator = Collator.getInstance();

                        @Override
                        public int compare(String string, String string2) {
                            return this._collator.compare(string, string2);
                        }
                    });
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        string3 = stringArray[n2];
                        string = properties.getProperty(string3);
                        listOptionsRequest.names.add(string3);
                        listOptionsRequest.values.add(string);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            listOptionsRequest.ok = this.checkSQLException("", sQLException, listOptionsRequest);
        }
        finally {
            this.closeStatement(statement);
            statement = null;
        }
    }

    private void handleCallback(Request request) {
        CallbackRequest callbackRequest = (CallbackRequest)request;
        try {
            callbackRequest.r.run();
        }
        catch (Exception exception) {
            callbackRequest.e = exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetColumnNames(Request request) {
        ResultSet resultSet = null;
        GetColumnNamesRequest getColumnNamesRequest = (GetColumnNamesRequest)request;
        if (this._connected) {
            try {
                String string = getColumnNamesRequest.catalog;
                String string2 = getColumnNamesRequest.owner;
                String string3 = getColumnNamesRequest.tableName;
                DatabaseMetaData databaseMetaData = this._connection.getMetaData();
                resultSet = databaseMetaData.getColumns(string, this.escapeSearchString(string2), this.escapeSearchString(string3), "%");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(4));
                }
                getColumnNamesRequest.names = new String[arrayList.size()];
                System.arraycopy(arrayList.toArray(), 0, getColumnNamesRequest.names, 0, arrayList.size());
                arrayList.clear();
                arrayList = null;
            }
            catch (SQLException sQLException) {
                getColumnNamesRequest.names = new String[0];
                getColumnNamesRequest.sqlException = sQLException;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                    resultSet = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] disambiguateTableOrView(String string, String string2, String string3) {
        String[] stringArray = null;
        ResultSet resultSet = null;
        Statement statement = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            statement = this.createReadOnlyStatement();
            stringBuilder.append("select * from ");
            if (string != null) {
                stringBuilder.append(this.quoteIdentifier(string));
                stringBuilder.append(".");
            }
            if (string2 != null) {
                stringBuilder.append(this.quoteIdentifier(string2));
                stringBuilder.append(".");
            }
            stringBuilder.append(this.quoteIdentifier(string3));
            stringBuilder.append(" where 1=2");
            resultSet = statement.executeQuery(stringBuilder.toString());
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData.getColumnCount() > 0) {
                string = resultSetMetaData.getCatalogName(1);
                string2 = resultSetMetaData.getSchemaName(1);
                stringArray = new String[]{string, string2};
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
            this.closeStatement(statement);
            statement = null;
        }
        return stringArray;
    }

    private void handleDisambiguateIdentifier(DisambiguateIdentifierRequest disambiguateIdentifierRequest) {
        switch (disambiguateIdentifierRequest.type) {
            case TABLE_OR_VIEW: {
                disambiguateIdentifierRequest.retcode = this.disambiguateTableOrView(disambiguateIdentifierRequest.catalog, disambiguateIdentifierRequest.schema, disambiguateIdentifierRequest.name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported identifier type :" + (Object)((Object)disambiguateIdentifierRequest.type));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleTableExists(TableExistsRequest tableExistsRequest) {
        boolean bl;
        block14: {
            Object object;
            ResultSet resultSet;
            Statement statement;
            block13: {
                bl = false;
                statement = null;
                resultSet = null;
                object = null;
                try {
                    object = this.disableBlocking();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("SELECT * FROM ");
                    stringBuilder.append(this.quoteOwnerAndTableName(tableExistsRequest.catalog, tableExistsRequest.owner, tableExistsRequest.tableName));
                    stringBuilder.append(" WHERE 1=2");
                    statement = this.createReadOnlyStatement();
                    resultSet = statement.executeQuery(stringBuilder.toString());
                    bl = true;
                    if (resultSet == null) break block13;
                }
                catch (SQLException sQLException) {
                    int n = this.getDatabaseType();
                    if ((n == 0 || n == 2) && sQLException.getErrorCode() == -210) {
                        bl = true;
                    }
                    break block14;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                resultSet = null;
            }
            this.restoreBlocking(object);
            this.closeStatement(statement);
            statement = null;
            break block14;
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                    resultSet = null;
                }
                this.restoreBlocking(object);
                this.closeStatement(statement);
                statement = null;
            }
        }
        tableExistsRequest.exists = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object disableBlocking() {
        Statement statement = null;
        Boolean bl = null;
        int n = this.getDatabaseType();
        if (n == 0 || n == 2) {
            try {
                int n2;
                statement = this.createReadOnlyStatement();
                ResultSet resultSet = statement.executeQuery("if((select connection_property('blocking'))='On') then begin set temporary option blocking='Off';select 1; end else select 0; end if");
                if (resultSet.next() && (n2 = resultSet.getInt(1)) == 1) {
                    bl = Boolean.TRUE;
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (statement != null) {
                    this.closeStatement(statement);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreBlocking(Object object) {
        Statement statement = null;
        if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
            try {
                statement = this.createReadOnlyStatement();
                statement.executeQuery("set temporary option blocking='on'");
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (statement != null) {
                    this.closeStatement(statement);
                }
            }
        }
    }

    private static int convertODBCTypeToJDBC(int n) {
        if (n == -8) {
            n = 1;
        } else if (n == -9) {
            n = 12;
        } else if (n == -10) {
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetTableInfo(Request request) {
        TableInfo tableInfo;
        block29: {
            assert (request instanceof GetTableInfoRequest);
            GetTableInfoRequest getTableInfoRequest = (GetTableInfoRequest)request;
            tableInfo = new TableInfo();
            tableInfo.column = null;
            Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
            try {
                ColumnInfo columnInfo;
                Object object;
                boolean bl;
                String string = getTableInfoRequest.owner;
                String string2 = getTableInfoRequest.tableName;
                String string3 = getTableInfoRequest.catalog;
                this.getDataTypes();
                DatabaseMetaData databaseMetaData = this._connection.getMetaData();
                boolean bl2 = string3 == null && databaseMetaData.supportsCatalogsInDataManipulation();
                boolean bl3 = bl = string == null && databaseMetaData.supportsSchemasInDataManipulation();
                if ((bl2 || bl) && (object = this.disambiguateTableOrView(string3, string, string2)) != null) {
                    string3 = object[0];
                    string = object[1];
                }
                ResultSet resultSet = databaseMetaData.getColumns(string3, this.escapeSearchString(string), this.escapeSearchString(string2), "%");
                int n = resultSet.getMetaData().getColumnCount();
                String string4 = null;
                String string5 = null;
                int n2 = 1;
                while (resultSet.next()) {
                    int n3;
                    columnInfo = new ColumnInfo();
                    if (string5 == null) {
                        string5 = resultSet.getString(1);
                    } else if (!string5.equals(resultSet.getString(1))) {
                        vector.clear();
                        break;
                    }
                    if (string4 == null) {
                        string4 = resultSet.getString(2);
                    } else if (!string4.equals(resultSet.getString(2))) {
                        vector.clear();
                        break;
                    }
                    columnInfo.name = resultSet.getString(4);
                    int n4 = ISQLConnectionImpl.convertODBCTypeToJDBC(resultSet.getShort(5));
                    String string6 = resultSet.getString(6);
                    columnInfo.width = resultSet.getInt(7);
                    if (n >= 9) {
                        columnInfo.scale = resultSet.getInt(9);
                    }
                    columnInfo.type = this.getDataTypeMetaData(n4, string6, columnInfo.width, columnInfo.scale);
                    if (columnInfo.type == null) {
                        columnInfo.type = this.getDataTypeMetaData(n4, null, columnInfo.width, columnInfo.scale);
                    }
                    columnInfo.nullable = n >= 11 ? (n3 = resultSet.getInt(11)) == 1 : false;
                    columnInfo.ordinal = n >= 17 ? resultSet.getInt(17) : n2;
                    vector.addElement(columnInfo);
                    ++n2;
                }
                resultSet.close();
                resultSet = null;
                if (vector.size() == 0) {
                    object = null;
                    try {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("SELECT * FROM ");
                        stringBuffer.append(this.quoteOwnerAndTableName(getTableInfoRequest.owner, getTableInfoRequest.tableName));
                        stringBuffer.append(" WHERE 1=2");
                        object = this.createReadOnlyStatement();
                        resultSet = object.executeQuery(stringBuffer.toString());
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                            columnInfo = new ColumnInfo();
                            columnInfo.name = resultSetMetaData.getColumnName(n2);
                            columnInfo.width = resultSetMetaData.getColumnDisplaySize(n2);
                            columnInfo.scale = resultSetMetaData.getScale(n2);
                            columnInfo.nullable = resultSetMetaData.isNullable(n2) == 1;
                            columnInfo.ordinal = n2;
                            columnInfo.type = this.getDataTypeMetaData(resultSetMetaData.getColumnType(n2), resultSetMetaData.getColumnTypeName(n2), columnInfo.width, columnInfo.scale);
                            ISQLConnectionImpl.convertODBCTypeToJDBC(resultSetMetaData.getColumnType(n2));
                            vector.addElement(columnInfo);
                        }
                    }
                    catch (SQLException sQLException) {
                        vector.clear();
                    }
                    finally {
                        if (object != null) {
                            try {
                                object.close();
                                object = null;
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
                tableInfo.column = new ColumnInfo[vector.size()];
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    tableInfo.column[n2] = (ColumnInfo)vector.elementAt(n2);
                }
                Arrays.sort(tableInfo.column, new Comparator<ColumnInfo>(){

                    @Override
                    public int compare(ColumnInfo columnInfo, ColumnInfo columnInfo2) {
                        int n = columnInfo.ordinal - columnInfo2.ordinal;
                        return n;
                    }
                });
                vector = null;
            }
            catch (SQLException sQLException) {
                if (tableInfo == null) break block29;
                tableInfo.column = null;
                tableInfo = null;
            }
        }
        getTableInfoRequest.info = tableInfo;
    }

    private void handleGetDatabaseNames(Request request) {
        GetDatabaseNamesRequest getDatabaseNamesRequest = (GetDatabaseNamesRequest)request;
        getDatabaseNamesRequest.names.clear();
        try {
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getCatalogs();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                if (string == null || string.isEmpty()) continue;
                getDatabaseNamesRequest.names.add(string);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void handleSetCatalog(Request request) {
        SetCatalogRequest setCatalogRequest = (SetCatalogRequest)request;
        try {
            this._connection.setCatalog(setCatalogRequest.catalog);
        }
        catch (SQLException sQLException) {
            setCatalogRequest.sqlException = sQLException;
            ISQLConnectionImpl.displaySQLException(this, "Could not connect to the database.", sQLException);
        }
    }

    private void handleGetCatalog(Request request) {
        GetCatalogRequest getCatalogRequest = (GetCatalogRequest)request;
        try {
            getCatalogRequest.name = this._connection.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleGetServerName(Request var1_1) {
        var3_2 = null;
        var4_3 = null;
        var2_4 = (GetServerNameRequest)var1_1;
        var5_5 = this.getDatabaseType();
        try {
            var3_2 = this.createReadOnlyStatement();
            switch (var5_5) {
                case 0: 
                case 2: {
                    var4_3 = var3_2.executeQuery("SELECT property('name')");
                    var4_3.next();
                    var2_4.name = var4_3.getString(1);
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 1: {
                    var4_3 = var3_2.executeQuery("SELECT @@servername");
                    var4_3.next();
                    var2_4.name = var4_3.getString(1);
                    ** break;
lbl21:
                    // 1 sources

                    break;
                }
                default: {
                    var2_4.name = "";
                    break;
                }
            }
        }
        catch (SQLException var6_7) {
            var2_4.name = "";
        }
        finally {
            if (var4_3 != null) {
                try {
                    var4_3.close();
                }
                catch (SQLException var6_8) {}
            }
        }
        this.closeStatement(var3_2);
        var3_2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAddTableData(Request request) {
        Vector<Object> vector = null;
        boolean bl = true;
        StringBuffer stringBuffer = null;
        int n = 0;
        boolean bl2 = true;
        boolean bl3 = true;
        SQLException sQLException = null;
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        Object object = null;
        AddTableDataRequest addTableDataRequest = (AddTableDataRequest)request;
        boolean bl4 = addTableDataRequest.ignoreErrors;
        TableInfo tableInfo = this.getTableInfo(addTableDataRequest.catalog, addTableDataRequest.owner, addTableDataRequest.tableName);
        if (tableInfo == null) {
            if (addTableDataRequest.errors != null) {
                addTableDataRequest.errors.add(ISQLResource.getISQLString(ErrorMessages.getName(), "ImporterMissingMetaData"));
            }
            return;
        }
        if (addTableDataRequest.genitor.knowsColumnNames() && !this.tableContainsAllGenitorColumns(tableInfo, addTableDataRequest.genitor)) {
            addTableDataRequest.importerException = new ImporterFailedException(ISQLResource.getISQLString(ErrorMessages.getName(), "COLUMN_MISMATCH"));
            return;
        }
        String string = ISQLResource.getFormattedString(GeneralResources.getName(), "Importing into table {0}", this.quoteOwnerAndTableName(addTableDataRequest.owner, addTableDataRequest.tableName));
        isql.getIO(this).writeln(string, 0);
        try {
            bl3 = this._connection.getAutoCommit();
            this._connection.setAutoCommit(false);
        }
        catch (SQLException sQLException2) {
            // empty catch block
        }
        object = this.disableBlocking();
        if (addTableDataRequest.genitor.knowsColumnNames()) {
            this.sortTableInfo(tableInfo, addTableDataRequest.genitor);
        }
        boolean bl5 = false;
        if (this._databaseType == 0 || this._databaseType == 2) {
            try {
                statement = this.createReadOnlyStatement();
                statement.execute("SAVEPOINT isqlAddTableData");
            }
            catch (SQLException sQLException3) {
            }
            finally {
                if (statement != null) {
                    this.closeStatement(statement);
                    statement = null;
                }
            }
        }
        l = System.currentTimeMillis();
        int n3 = 0;
        while (addTableDataRequest.genitor.moveNext() && addTableDataRequest.genitor.keepGoing(this)) {
            String string2;
            String[] stringArray;
            boolean bl6;
            int n4;
            String string3;
            block78: {
                ++n3;
                long l3 = System.currentTimeMillis();
                if (l3 - l2 >= 750L) {
                    string = ISQLResource.getFormattedString(GeneralResources.getName(), "Reading row {0}", Integer.toString(n3));
                    isql.getIO(this).showProgress(string, -1);
                    l2 = l3;
                }
                try {
                    vector = addTableDataRequest.genitor.getRowData();
                    if (vector == null) {
                    }
                    break block78;
                }
                catch (IOException iOException) {
                    String[] stringArray2 = new String[2];
                    string3 = ISQLResource.getFormattedString(ErrorMessages.getName(), "The following file I/O error occured while importing data:\n{0}\n\nDo you want to keep the data that was read?", iOException.getMessage());
                    stringArray2[0] = ISQLResource.getISQLString(ErrorMessages.getName(), "Yes");
                    stringArray2[1] = ISQLResource.getISQLString(ErrorMessages.getName(), "No");
                    int n5 = isql.getIO(this).promptForOption(1, null, string3, stringArray2, 0, 0);
                    if (n5 == 1) {
                        bl2 = false;
                    }
                    bl = false;
                }
                break;
            }
            if (preparedStatement == null) {
                stringBuffer = new StringBuffer(256);
                stringBuffer.append("INSERT INTO ");
                stringBuffer.append(this.quoteOwnerAndTableName(addTableDataRequest.catalog, addTableDataRequest.owner, addTableDataRequest.tableName));
                n = addTableDataRequest.genitor.getColumnCount();
                if (n > tableInfo.column.length) {
                    n = tableInfo.column.length;
                }
                stringBuffer.append(" (");
                for (n4 = 0; n4 < n; ++n4) {
                    if (n4 != 0) {
                        stringBuffer.append(",");
                    }
                    String string4 = addTableDataRequest.genitor.knowsColumnNames() ? addTableDataRequest.genitor.getColumnName(n4) : tableInfo.column[n4].name;
                    stringBuffer.append(this.quoteIdentifier(string4));
                }
                stringBuffer.append(")");
                stringBuffer.append("VALUES (");
                for (n4 = 0; n4 < n; ++n4) {
                    if (n4 != 0) {
                        stringBuffer.append(",");
                    }
                    if (this._databaseType == 1) {
                        stringBuffer.append("CONVERT(");
                        stringBuffer.append(ISQLConnectionImpl.getSQLTypeName(tableInfo.column[n4].type, tableInfo.column[n4].width, tableInfo.column[n4].scale));
                        stringBuffer.append(",?)");
                        continue;
                    }
                    stringBuffer.append("?");
                }
                stringBuffer.append(")");
                if (Dbg.enabled((String)"Importer")) {
                    Dbg.printlnEx((String)("Table names come from " + (addTableDataRequest.genitor.knowsColumnNames() ? "the genitor (" + addTableDataRequest.genitor.getClass().getName() + ")" : "the tableInfo structure") + "\n" + "Prepared statement: " + stringBuffer.toString()));
                }
                try {
                    preparedStatement = this.createPreparedStatement(stringBuffer.toString());
                }
                catch (SQLException sQLException4) {
                    // empty catch block
                }
            }
            try {
                boolean bl7 = false;
                for (n4 = 0; n4 < n; ++n4) {
                    Object object2;
                    if (n4 < vector.size() && vector.elementAt(n4) != null) {
                        object2 = vector.elementAt(n4);
                    } else {
                        if (tableInfo.column[n4].nullable) {
                            preparedStatement.setNull(n4 + 1, tableInfo.column[n4].type.getSQLType());
                            continue;
                        }
                        switch (tableInfo.column[n4].type.getSQLType()) {
                            case -4: 
                            case -3: 
                            case -2: {
                                object2 = "";
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                object2 = "";
                                break;
                            }
                            default: {
                                object2 = "0";
                            }
                        }
                    }
                    if (object2 instanceof byte[]) {
                        preparedStatement.setBytes(n4 + 1, (byte[])object2);
                        if (((byte[])object2).length <= 510) continue;
                        bl7 = true;
                        continue;
                    }
                    if (object2 instanceof Boolean) {
                        preparedStatement.setBoolean(n4 + 1, (Boolean)object2);
                        continue;
                    }
                    if (object2 instanceof Integer) {
                        preparedStatement.setInt(n4 + 1, (Integer)object2);
                        continue;
                    }
                    if (object2 instanceof Double) {
                        preparedStatement.setDouble(n4 + 1, (Double)object2);
                        continue;
                    }
                    if (object2 instanceof Blob) {
                        preparedStatement.setBlob(n4 + 1, (Blob)object2);
                        continue;
                    }
                    preparedStatement.setString(n4 + 1, object2.toString());
                    if (object2.toString().length() <= 255) continue;
                    bl7 = true;
                }
                if (bl5) {
                    if (bl7) {
                        if (n2 > 0) {
                            preparedStatement.executeUpdate();
                            n2 = 0;
                        }
                        preparedStatement.execute();
                    } else {
                        preparedStatement.addBatch();
                        if (++n2 == 100) {
                            preparedStatement.executeUpdate();
                            n2 = 0;
                        }
                    }
                } else {
                    preparedStatement.execute();
                }
                sQLException = null;
            }
            catch (SQLException sQLException5) {
                bl = false;
                sQLException = sQLException5;
            }
            if (bl) continue;
            if (bl4) {
                if (addTableDataRequest.errors != null) {
                    addTableDataRequest.errors.addElement(sQLException.getLocalizedMessage());
                }
                bl = true;
                continue;
            }
            bl4 = true;
            String string5 = Preferences.getStringOption(this, "on_error");
            if (string5.equalsIgnoreCase("Continue")) {
                bl = true;
                continue;
            }
            switch (this.getDatabaseType()) {
                case 0: 
                case 2: {
                    bl6 = sQLException.getErrorCode() != -210;
                    break;
                }
                default: {
                    bl6 = true;
                }
            }
            if (bl6) {
                stringArray = new String[]{ISQLResource.getISQLString(GeneralResources.getName(), "CONTINUE_BUTTON"), ISQLResource.getISQLString(GeneralResources.getName(), "STOP_BUTTON")};
                string2 = "IMPORT_ERROR_WITH_CONTINUE";
            } else {
                stringArray = new String[]{ISQLResource.getISQLString(GeneralResources.getName(), "OK")};
                string2 = "IMPORT_ERROR";
            }
            string3 = ISQLResource.getFormattedString(GeneralResources.getName(), string2, Integer.toString(n3), isql.formatSQLExceptionMessage(sQLException));
            int n6 = isql.getIO(this).promptForOption(1, ISQLResource.getISQLString(GeneralResources.getName(), "Import"), string3, stringArray, 0, 0);
            if (stringArray.length == 1 || n6 == 1) break;
            bl4 = true;
            bl = true;
        }
        if (n2 > 0) {
            try {
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException6) {
                // empty catch block
            }
        }
        this.closeStatement(preparedStatement);
        preparedStatement = null;
        if (bl) {
            string = ISQLResource.getFormattedString(GeneralResources.getName(), "{0} rows read", Integer.toString(n3), this.quoteOwnerAndTableName(addTableDataRequest.owner, addTableDataRequest.tableName));
            isql.getIO(this).showProgress(string, -1);
            isql.getIO(this).writeln(string, 0);
        }
        if (this._databaseType == 0 || this._databaseType == 2) {
            try {
                statement = this.createReadOnlyStatement();
                if (bl2) {
                    statement.execute("RELEASE SAVEPOINT isqlAddTableData");
                } else {
                    statement.execute("ROLLBACK TO SAVEPOINT isqlAddTableData");
                }
            }
            catch (SQLException sQLException7) {
            }
            finally {
                this.closeStatement(statement);
                statement = null;
            }
        }
        if (bl3) {
            if (this.getDatabaseType() == 1) {
                try {
                    this._connection.commit();
                }
                catch (SQLException sQLException8) {
                    // empty catch block
                }
            }
            try {
                this._connection.setAutoCommit(true);
            }
            catch (SQLException sQLException9) {
                // empty catch block
            }
        }
        this.restoreBlocking(object);
        if (addTableDataRequest.ignoreErrors && addTableDataRequest.errors != null && addTableDataRequest.errors.size() != 0) {
            bl = false;
        }
        addTableDataRequest.ok = bl;
    }

    private boolean tableContainsAllGenitorColumns(TableInfo tableInfo, TableGenitor tableGenitor) {
        boolean bl = true;
        int n = tableGenitor.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = tableGenitor.getColumnName(i);
            boolean bl2 = false;
            for (int j = 0; j < tableInfo.column.length; ++j) {
                if (tableInfo.column[j] == null || !tableInfo.column[j].name.equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void sortTableInfo(TableInfo tableInfo, TableGenitor tableGenitor) {
        int n = tableGenitor.getColumnCount();
        ColumnInfo[] columnInfoArray = new ColumnInfo[n];
        block0: for (int i = 0; i < n; ++i) {
            String string = tableGenitor.getColumnName(i);
            for (int j = 0; j < tableInfo.column.length; ++j) {
                if (tableInfo.column[j] == null || !tableInfo.column[j].name.equalsIgnoreCase(string)) continue;
                columnInfoArray[i] = tableInfo.column[j];
                tableInfo.column[j] = null;
                continue block0;
            }
        }
        tableInfo.column = columnInfoArray;
    }

    private void handleListProcedures(Request request) {
        ListProceduresRequest listProceduresRequest = (ListProceduresRequest)request;
        if (listProceduresRequest.pattern == null) {
            listProceduresRequest.pattern = "%";
        }
        if (this._databaseType == 1) {
            this.handleListASEProcedures(listProceduresRequest);
            return;
        }
        try {
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getProcedures(listProceduresRequest.catalog, listProceduresRequest.schema, listProceduresRequest.pattern);
            while (resultSet.next()) {
                listProceduresRequest.owner.add(resultSet.getString(2));
                listProceduresRequest.name.add(resultSet.getString(3));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void handleListASEProcedures(ListProceduresRequest listProceduresRequest) {
        try {
            Statement statement = this.createReadOnlyStatement();
            String string = "select O.name, U.name from " + listProceduresRequest.catalog + ".dbo.sysobjects O, " + listProceduresRequest.catalog + ".dbo.sysusers U where O.uid = U.uid and O.type = 'P' and O.name like '" + listProceduresRequest.pattern + "'";
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                listProceduresRequest.name.add(resultSet.getString(1));
                listProceduresRequest.owner.add(resultSet.getString(2));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void handleListTables(Request request) {
        ListTablesRequest listTablesRequest = (ListTablesRequest)request;
        if (listTablesRequest.table == null) {
            listTablesRequest.table = "%";
        }
        try {
            String[] stringArray;
            if (listTablesRequest.options != 0) {
                boolean bl = this._driverType == DriverType.JCONNECT;
                int n = 0;
                if ((listTablesRequest.options & 1) != 0) {
                    ++n;
                }
                if ((listTablesRequest.options & 8) != 0) {
                    ++n;
                }
                if ((listTablesRequest.options & 2) != 0) {
                    ++n;
                }
                if ((listTablesRequest.options & 4) != 0) {
                    n = bl ? ++n : (n += 2);
                }
                stringArray = new String[n];
                n = 0;
                if ((listTablesRequest.options & 1) != 0) {
                    stringArray[n++] = "TABLE";
                }
                if ((listTablesRequest.options & 8) != 0) {
                    stringArray[n++] = "GLOBAL TEMPORARY";
                }
                if ((listTablesRequest.options & 2) != 0) {
                    stringArray[n++] = "SYSTEM";
                }
                if ((listTablesRequest.options & 4) != 0) {
                    stringArray[n++] = "VIEW";
                    if (!bl) {
                        stringArray[n++] = "SYSTEM VIEW";
                    }
                }
            } else {
                stringArray = null;
            }
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(listTablesRequest.catalog, listTablesRequest.schema, listTablesRequest.table, stringArray);
            while (resultSet.next()) {
                listTablesRequest.schemas.add(resultSet.getString(2));
                listTablesRequest.names.add(resultSet.getString(3));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreateTable(Request request) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = null;
        CreateTableRequest createTableRequest = (CreateTableRequest)request;
        if (this.getDatabaseType() == 3) {
            this.closePreviousStatement(true);
        }
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(this.quoteOwnerAndTableName(createTableRequest.catalog, createTableRequest.owner, createTableRequest.tableName));
        stringBuffer.append(" (");
        int n = createTableRequest.genitor.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(" ");
            stringBuffer.append(this.quoteIdentifier(createTableRequest.genitor.getColumnName(i)));
            stringBuffer.append(" ");
            DataTypeMetaData dataTypeMetaData = createTableRequest.genitor.getColumnTypeMetaData(i);
            if (dataTypeMetaData == null) {
                createTableRequest.sqlException = new SQLException(ISQLResource.getFormattedString(ErrorMessages.getName(), "COULD_NOT_FIND_DATA_TYPE_FOR_COLUMN", createTableRequest.genitor.getColumnName(i)));
                return;
            }
            stringBuffer.append(" ");
            stringBuffer.append(ISQLConnectionImpl.getSQLTypeName(dataTypeMetaData, createTableRequest.genitor.getColumnWidth(i), createTableRequest.genitor.getColumnScale(i)));
            if (createTableRequest.genitor.isColumnInPrimaryKey(i)) {
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer(64);
                } else {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(this.quoteIdentifier(createTableRequest.genitor.getColumnName(i)));
            }
            if (createTableRequest.genitor.isNullableColumn(i)) {
                stringBuffer.append(" NULL");
                continue;
            }
            stringBuffer.append(" NOT NULL");
        }
        if (stringBuffer2 != null) {
            stringBuffer.append(", PRIMARY KEY(");
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        Statement statement = null;
        try {
            statement = this.createReadOnlyStatement();
            statement.execute(stringBuffer.toString());
            bl = true;
        }
        catch (SQLException sQLException) {
            createTableRequest.sqlException = sQLException;
            bl = false;
        }
        finally {
            if (statement != null) {
                this.closeStatement(statement);
                statement = null;
            }
        }
    }

    DataTypeMetaData getDataTypeMetaData(int n, String string, int n2, int n3) {
        return ISQLConnectionImpl.getDataTypeMetaData(this.getDatabaseType(), this.getDataTypes(), n, string, n2, n3);
    }

    static DataTypeMetaData getDataTypeMetaData(int n, DataTypeMetaData[] dataTypeMetaDataArray, int n2, String string, int n3, int n4) {
        DataTypeMetaData dataTypeMetaData = null;
        if (string != null) {
            if (string.equals("char")) {
                n2 = 1;
            } else if (string.equals("nchar")) {
                n2 = -8;
            } else if (string.equals("nvarchar")) {
                n2 = -9;
            } else if (string.equals("long nvarchar")) {
                n2 = -10;
            }
            if (string.equals("int")) {
                string = "integer";
            }
        }
        if ((n == 0 || n == 2) && string != null) {
            if (string.equalsIgnoreCase("float")) {
                if (n2 == 7) {
                    string = "real";
                } else if (n2 == 8) {
                    string = "double";
                }
            } else if (string.equalsIgnoreCase("time")) {
                n2 = 92;
            } else if (string.equalsIgnoreCase("date")) {
                n2 = 91;
            } else if (string.equalsIgnoreCase("timestamp")) {
                n2 = 93;
            }
        }
        if (n == 1 && string != null) {
            if (string.equalsIgnoreCase("unsigned smallint")) {
                string = "usmallint";
            } else if (string.equalsIgnoreCase("unsigned int")) {
                string = "uint";
            } else if (string.equalsIgnoreCase("unsigned bigint")) {
                string = "ubigint";
            } else if (string.equalsIgnoreCase("double precision")) {
                string = "float";
            } else if (string.equalsIgnoreCase("unichar")) {
                string = "nchar";
            } else if (string.equalsIgnoreCase("date")) {
                n2 = 91;
            } else if (string.equalsIgnoreCase("time")) {
                n2 = 92;
            } else if (string.equalsIgnoreCase("nchar")) {
                n2 = 1;
            }
        }
        for (int i = 0; i < dataTypeMetaDataArray.length; ++i) {
            boolean bl;
            if (dataTypeMetaDataArray[i].getSQLType() != n2) continue;
            if (string != null) {
                if (!string.equalsIgnoreCase(dataTypeMetaDataArray[i].getName()) && (!dataTypeMetaDataArray[i].getName().equalsIgnoreCase("int") || !string.equals("integer"))) continue;
                dataTypeMetaData = dataTypeMetaDataArray[i];
                break;
            }
            if (n3 != -1 && n3 > dataTypeMetaDataArray[i].getMaxPrecision() || n4 != -1 && (n4 < dataTypeMetaDataArray[i].getMinScale() || n4 > dataTypeMetaDataArray[i].getMaxScale())) continue;
            boolean bl2 = bl = string != null && string.regionMatches(0, "unsigned ", 0, 9);
            if (bl != dataTypeMetaDataArray[i].isUnsigned()) continue;
            dataTypeMetaData = dataTypeMetaDataArray[i];
            break;
        }
        if (dataTypeMetaData == null) {
            // empty if block
        }
        return dataTypeMetaData;
    }

    static String getSQLTypeName(DataTypeMetaData dataTypeMetaData, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(dataTypeMetaData.getName());
        int n3 = dataTypeMetaData.getAnnotationFlags();
        if ((n3 & 1) != 0) {
            n = Math.max(1, n);
            stringBuilder.append("(");
            stringBuilder.append(n);
            stringBuilder.append(")");
        } else if ((n3 & 6) == 6) {
            n = Math.max(1, n);
            n2 = Math.max(n2, dataTypeMetaData.getMinScale());
            stringBuilder.append("(");
            stringBuilder.append(n);
            stringBuilder.append(",");
            stringBuilder.append(n2);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private void handleCheckSyntax(CheckSyntaxRequest checkSyntaxRequest) {
        boolean bl;
        PreparedStatement preparedStatement = null;
        String string = checkSyntaxRequest.sql;
        try {
            preparedStatement = this._driverType == DriverType.JCONNECT ? this._jconnectConnectionProxy.prepareStatement(string, true) : this.createPreparedStatement(string);
            preparedStatement.close();
            preparedStatement = null;
            bl = true;
        }
        catch (SQLException sQLException) {
            checkSyntaxRequest.error = sQLException;
            checkSyntaxRequest.errorMessage = ISQLResource.getISQLString(ErrorMessages.getName(), "Could not execute statement.");
            bl = false;
        }
        checkSyntaxRequest.ok = bl;
    }

    void notifyBatchStarts() {
        this._isFirstStatementInBatch = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleExecute(ExecuteRequest executeRequest) {
        boolean bl = false;
        boolean bl2 = true;
        ResultSet resultSet = null;
        boolean bl3 = true;
        boolean bl4 = false;
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        Object object = null;
        boolean bl5 = !isql.options.useGUI || this._isFirstStatementInBatch || !Preferences.getPluginBooleanPreference(this, "showResultsForAllStatements", "0");
        this._isFirstStatementInBatch = false;
        this.closePreviousStatement(bl5);
        String string = executeRequest.sql.trim();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        if (executeRequest.resultsProcessor != null) {
            this._bufferedAsyncMessages = new Vector();
        }
        if (executeRequest.disableBlocking) {
            object = this.disableBlocking();
        }
        try {
            String string2;
            if (!(executeRequest.containsODBCEscapeSequence || string.indexOf("{") == -1 && string.indexOf("}") == -1)) {
                statement = this.createReadOnlyStatement();
                statement.setEscapeProcessing(false);
            } else {
                preparedStatement = this.createPreparedStatement(string);
                if ((this._databaseType == 0 || this._databaseType == 2 || this._databaseType == 1) && this._driverType == DriverType.JCONNECT) {
                    if (++_cursorCount >= 255) {
                        _cursorCount = 0;
                    }
                    string2 = "isql" + Integer.toString(_cursorCount);
                    preparedStatement.setCursorName(string2);
                    preparedStatement.setFetchSize(this._maxRows);
                }
            }
            this._lastSQLStatement = string;
            this._updateCount = -1;
            bl4 = Preferences.getPluginBooleanPreference(this, "showMultipleResultSets", "0");
            if (bl4) {
                try {
                    bl4 = this._connection.getMetaData().supportsMultipleResultSets();
                }
                catch (SQLException sQLException) {
                    bl4 = false;
                }
            }
            this._statement = preparedStatement;
            if (statement != null) {
                bl = statement.execute(string);
                bl4 = true;
            } else if (bl4) {
                bl = this._statement.execute();
            } else {
                if ((this._databaseType == 0 || this._databaseType == 2 || this._databaseType == 1) && this._driverType == DriverType.JCONNECT) {
                    this._statement.setFetchSize(1);
                }
                if (ISQLConnectionImpl.statementReturnsUpdateCount(string)) {
                    this._updateCount = this._statement.executeUpdate();
                } else if (ISQLConnectionImpl.statementReturnsResultSet(string)) {
                    try {
                        resultSet = this._statement.executeQuery();
                    }
                    catch (SQLException sQLException) {
                        String string3 = sQLException.getMessage();
                        if (string3.indexOf("JZ0R2") == -1 && string3.indexOf("No ResultSet was produced") == -1) {
                            throw sQLException;
                        }
                        resultSet = null;
                    }
                } else {
                    bl = this._statement.execute();
                    if (executeRequest.resultsProcessor == null && !bl4) {
                        resultSet = ISQLConnectionImpl.getFirstResultSet(this._statement, bl);
                    }
                }
            }
            try {
                SQLWarning sQLWarning = preparedStatement != null ? preparedStatement.getWarnings() : (statement != null ? statement.getWarnings() : null);
                if (sQLWarning != null && (string2 = sQLWarning.getSQLState()) != null && string2.equals("010P4")) {
                    sQLWarning = null;
                }
                if (this._databaseProductName != null && this._databaseProductName.equals("MySQL")) {
                    string2 = sQLWarning.getSQLState();
                    int n = sQLWarning.getErrorCode();
                    if (string2 != null && string2.equals("01S02") && n == 502) {
                        sQLWarning = null;
                    }
                }
                executeRequest.warning = sQLWarning;
                if (sQLWarning == null) {
                    // empty if block
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (executeRequest.resultsProcessor != null) {
                bl2 = this.callCustomResultsProcessor(executeRequest.resultsProcessor, statement == null ? preparedStatement : statement, string, resultSet, bl, executeRequest);
                boolean bl6 = bl3 = executeRequest.error == null;
            }
            if (!this._isUtilityDatabase && Preferences.getPluginBooleanPreference(this, "autoCommit", "0") && this._connection != null) {
                this._connection.commit();
            }
        }
        catch (SQLException sQLException) {
            executeRequest.error = sQLException;
            bl3 = this.checkSQLException(string, sQLException, executeRequest);
            if (preparedStatement != null) {
                this.closeStatement(preparedStatement);
                preparedStatement = null;
            }
            this._statement = null;
            if (this._connection != null && Preferences.getPluginBooleanPreference(this, "autoCommit", "0")) {
                try {
                    this._connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
        }
        finally {
            this._statement = null;
            if (executeRequest.disableBlocking) {
                this.restoreBlocking(object);
            }
        }
        if (preparedStatement != null) {
            if (bl2) {
                this.closeStatement(preparedStatement);
            } else {
                this._previousStatement = preparedStatement;
                resultSet = null;
            }
            preparedStatement = null;
        }
        if (statement != null) {
            this._previousStatement = statement;
        }
        executeRequest.ok = bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callCustomResultsProcessor(ResultsProcessor resultsProcessor, Statement statement, String string, ResultSet resultSet, boolean bl, ExecuteRequest executeRequest) throws SQLException {
        boolean bl2;
        block33: {
            boolean bl3;
            boolean bl4;
            bl2 = true;
            boolean bl5 = false;
            String string2 = Preferences.getPluginStringPreference(this, "nulls", "(NULL)");
            boolean bl6 = Preferences.getPluginBooleanPreference(this, "showMultipleResultSets", "0");
            boolean bl7 = (executeRequest.cachingHint & 1) != 0;
            boolean bl8 = (executeRequest.cachingHint & 2) != 0;
            boolean bl9 = bl4 = (executeRequest.cachingHint & 4) != 0;
            if (bl4) {
                bl3 = false;
                bl8 = true;
                bl5 = true;
            } else if (isql.options.useGUI) {
                bl3 = Preferences.getPluginBooleanPreference(this, "showResultsForAllStatements", "0");
                bl5 = Preferences.getPluginBooleanPreference(this, "showResultsWithGrids", "1");
            } else {
                int n = Preferences.getIntOption(this, "printResultSetToConsole");
                bl3 = false;
                switch (n) {
                    case 0: {
                        bl3 = false;
                        break;
                    }
                    case 1: {
                        bl3 = false;
                        break;
                    }
                    case 2: {
                        bl3 = true;
                        bl6 = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled option value " + n);
                    }
                }
            }
            resultsProcessor.startProcessingResults(this);
            try {
                boolean bl10;
                boolean bl11;
                int n;
                if (!bl3 && !bl8) {
                    n = 0;
                    bl11 = false;
                    bl10 = false;
                } else {
                    n = this._maxRows;
                    bl11 = bl5 ? bl4 || bl3 || bl6 : false;
                    bl10 = true;
                }
                if (!bl3 && !bl6 && resultSet == null && bl) {
                    resultSet = statement.getResultSet();
                }
                if (resultSet != null) {
                    if (!bl7) {
                        ISQLResultSetImpl iSQLResultSetImpl = new ISQLResultSetImpl(this, string, resultSet, n, null, bl11);
                        this._resultSetList.addElement(new ResultSetListItem(iSQLResultSetImpl, false));
                        if (bl10) {
                            boolean bl12 = resultsProcessor.processResultSet(this, string, iSQLResultSetImpl, bl8);
                            if (bl12 && bl11 && n > 0) {
                                iSQLResultSetImpl.rowExists(n - 1);
                            } else {
                                bl2 = false;
                            }
                        } else {
                            bl2 = false;
                        }
                    }
                    this.sendAsyncMessagesToResultsProcessor(resultsProcessor);
                    break block33;
                }
                int n2 = 0;
                do {
                    block34: {
                        if (bl) {
                            resultSet = statement.getResultSet();
                            if (!bl7) {
                                ISQLResultSetImpl iSQLResultSetImpl = new ISQLResultSetImpl(this, string, resultSet, n, string2, bl11);
                                this._resultSetList.addElement(new ResultSetListItem(iSQLResultSetImpl, !bl10));
                                if (bl10) {
                                    boolean bl13 = resultsProcessor.processResultSet(this, string, iSQLResultSetImpl, bl8);
                                    if (bl13 && bl11 && n > 0) {
                                        iSQLResultSetImpl.rowExists(n - 1);
                                    }
                                    if (!bl6) {
                                        bl10 = false;
                                    }
                                }
                            }
                            bl = this.getMoreResults(statement, string, executeRequest);
                        } else {
                            try {
                                n2 = statement.getUpdateCount();
                                if (n2 == -1) break block34;
                                boolean bl14 = resultsProcessor.processUpdateCount(this, string, n2);
                                if (!bl14) {
                                    break;
                                }
                                bl = this.getMoreResults(statement, string, executeRequest);
                            }
                            catch (SQLException sQLException) {
                                n2 = -1;
                            }
                        }
                    }
                    this.sendAsyncMessagesToResultsProcessor(resultsProcessor);
                } while (bl || n2 != -1);
            }
            catch (ResultsProcessor.ResultsProcessorException resultsProcessorException) {
            }
            finally {
                this._bufferedAsyncMessages = null;
                resultsProcessor.endProcessingResults(this);
            }
        }
        return bl2;
    }

    private boolean getMoreResults(Statement statement, String string, ExecuteRequest executeRequest) {
        boolean bl = false;
        while (true) {
            try {
                bl = statement.getMoreResults();
            }
            catch (SQLException sQLException) {
                SQLException sQLException2;
                while (sQLException2 instanceof SQLWarning) {
                    sQLException2 = sQLException2.getNextException();
                }
                if (sQLException2 == null) continue;
                executeRequest.error = sQLException2;
                this.checkSQLException(string, sQLException2, executeRequest);
                if (sQLException2 != null && sQLException2.getClass().getName().endsWith(".SybSQLException") && sQLException2.getSQLState() == null || "ZZZZZ".equals(sQLException2.getSQLState())) continue;
            }
            break;
        }
        return bl;
    }

    private void sendAsyncMessagesToResultsProcessor(ResultsProcessor resultsProcessor) {
        if (this._bufferedAsyncMessages == null) {
            return;
        }
        int n = this._bufferedAsyncMessages.size();
        if (n != 0) {
            boolean bl = resultsProcessor.processAsyncMessages(this, this._bufferedAsyncMessages);
            if (!bl) {
                for (int i = 0; i < n; ++i) {
                    isql.getIO(this).writeln(this._bufferedAsyncMessages.elementAt(i), 0);
                }
            }
            this._bufferedAsyncMessages.removeAllElements();
        }
    }

    private void handleDescribe(DescribeRequest describeRequest) {
        describeRequest.ok = false;
        if (describeRequest.option == DescribeOption.INDEX) {
            this.describeIndex(describeRequest);
        } else if (describeRequest.option == DescribeOption.CONNECTION) {
            this.describeConnection(describeRequest);
        } else {
            if (describeRequest.option == DescribeOption.TABLE || describeRequest.option == DescribeOption.ANYTHING) {
                this.describeTable(describeRequest);
            }
            if (describeRequest.option == DescribeOption.PROCEDURE || !describeRequest.ok && describeRequest.option == DescribeOption.ANYTHING) {
                this.describeProcedure(describeRequest);
            }
        }
    }

    private String escapeSearchString(String string) {
        String string2 = string;
        try {
            String string3 = this._connection.getMetaData().getSearchStringEscape();
            if (string != null && string3 != null && string3.length() > 0 && (string.indexOf(37) != -1 || string.indexOf(95) != -1 || string.indexOf(string3) != -1)) {
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 8);
                for (int i = 0; i < n; ++i) {
                    char c = string2.charAt(i);
                    if (c == '_' || c == '%') {
                        stringBuilder.append(string3);
                        stringBuilder.append(c);
                        continue;
                    }
                    if (string2.regionMatches(i, string3, 0, string3.length())) {
                        stringBuilder.append(string3);
                        stringBuilder.append(string3);
                        i += string3.length() - 1;
                        continue;
                    }
                    stringBuilder.append(c);
                }
                string2 = stringBuilder.toString();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string2;
    }

    void discardResultsForDescribe() {
        boolean bl = !isql.options.useGUI || this._isFirstStatementInBatch || !Preferences.getPluginBooleanPreference(this, "showResultsForAllStatements", "0");
        this._isFirstStatementInBatch = false;
        this.closePreviousStatement(bl);
    }

    private DataTypeMetaData getVarcharMetaData() {
        DataTypeMetaData dataTypeMetaData = this.getDataTypeMetaData(12, "varchar", -1, -1);
        if (dataTypeMetaData == null) {
            dataTypeMetaData = this.getDataTypeMetaData(12, null, -1, -1);
        }
        return dataTypeMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeTable(DescribeRequest describeRequest) {
        TableInfo tableInfo;
        String[] stringArray;
        ResultSet resultSet = null;
        String string = describeRequest.catalog;
        String string2 = describeRequest.schema;
        String string3 = describeRequest.name;
        int n = this.getDatabaseType();
        if ((string == null && n == 1 || string2 == null && n != 3) && (stringArray = this.disambiguateTableOrView(describeRequest.catalog, describeRequest.schema, describeRequest.name)) != null) {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        boolean bl = describeRequest.ok = (tableInfo = this.getTableInfo(string, string2, string3)) != null && tableInfo.column.length != 0;
        if (describeRequest.ok) {
            int n2;
            ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
            DataTypeMetaData dataTypeMetaData = this.getVarcharMetaData();
            DataTypeMetaData dataTypeMetaData2 = this.getDataTypeMetaData(4, null, -1, -1);
            if (dataTypeMetaData == null || dataTypeMetaData2 == null) {
                describeRequest.ok = false;
                return;
            }
            ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo(dataTypeMetaData, 1, iSQLResource.getISQLString("DescribeColumn"), 32, 0, false), new ColumnInfo(dataTypeMetaData, 2, iSQLResource.getISQLString("DescribeType"), 32, 0, false), new ColumnInfo(dataTypeMetaData2, 3, iSQLResource.getISQLString("DescribeNullable"), 0, 0, false), new ColumnInfo(dataTypeMetaData2, 4, iSQLResource.getISQLString("DescribePrimaryKey"), 0, 0, false)};
            Object[][] objectArray = new Object[tableInfo.column.length][4];
            for (n2 = 0; n2 < tableInfo.column.length; ++n2) {
                DataTypeMetaData dataTypeMetaData3;
                objectArray[n2][0] = tableInfo.column[n2].name;
                objectArray[n2][1] = tableInfo.column[n2].type != null ? ((dataTypeMetaData3 = this.getDataTypeMetaData(tableInfo.column[n2].type.getSQLType(), tableInfo.column[n2].type.getName(), -1, -1)) != null ? ISQLConnectionImpl.getSQLTypeName(dataTypeMetaData3, tableInfo.column[n2].width, tableInfo.column[n2].scale) : iSQLResource.getISQLString("DescribeUnknown")) : iSQLResource.getISQLString("DescribeUnknown");
                objectArray[n2][2] = tableInfo.column[n2].nullable ? 1 : 0;
                objectArray[n2][3] = 0;
            }
            try {
                resultSet = this._connection.getMetaData().getPrimaryKeys(string, string2, string3);
                block14: while (resultSet.next()) {
                    String string4 = resultSet.getString(4);
                    for (n2 = 0; n2 < tableInfo.column.length; ++n2) {
                        if (!tableInfo.column[n2].name.equals(string4)) continue;
                        objectArray[n2][3] = 1;
                        continue block14;
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                    resultSet = null;
                }
            }
            this.discardResultsForDescribe();
            resultSet = StaticResultSet.newInstance(columnInfoArray, objectArray);
            try {
                this.callCustomResultsProcessor(describeRequest.resultsProcessor, null, null, resultSet, true, describeRequest);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeConnection(DescribeRequest describeRequest) {
        ResultSet resultSet = null;
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        DataTypeMetaData dataTypeMetaData = this.getVarcharMetaData();
        if (dataTypeMetaData == null) {
            describeRequest.ok = false;
            return;
        }
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo(dataTypeMetaData, 1, iSQLResource.getISQLString("Property"), 32, 0, false), new ColumnInfo(dataTypeMetaData, 2, iSQLResource.getISQLString("Value"), 128, 0, false)};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        try {
            int n;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            arrayList.add(new Object[]{ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_DB_PRODUCT"), databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion()});
            ISQLPlugin.ConnectionPropertyID[] connectionPropertyIDArray = new ISQLPlugin.ConnectionPropertyID[]{ISQLPlugin.ConnectionPropertyID.HOST_NAME, ISQLPlugin.ConnectionPropertyID.HOST_TCPIP_ADDRESS, ISQLPlugin.ConnectionPropertyID.HOST_OPERATING_SYSTEM, ISQLPlugin.ConnectionPropertyID.SERVER_NAME, ISQLPlugin.ConnectionPropertyID.SERVER_TCPIP_PORT, ISQLPlugin.ConnectionPropertyID.DATABASE_NAME, ISQLPlugin.ConnectionPropertyID.DATABASE_CHARSET, ISQLPlugin.ConnectionPropertyID.CONNECTION_STRING};
            String[] stringArray = new String[]{ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_HOST_NAME"), ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_TCPIP_ADDRESS"), ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_OS"), ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_SERVER_NAME"), ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_TCPIP_PORT"), ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_DATABASE_NAME"), ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_DATABASE_CHARSET"), ISQLResource.getISQLString(GeneralResources.getName(), "DESCRIBE_CONNECTION_CONNECTION_STRING")};
            String[] stringArray2 = this._plugin.getConnectionProperties(this, connectionPropertyIDArray);
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringArray2[n] == null) continue;
                arrayList.add(new Object[]{stringArray[n], stringArray2[n]});
            }
            Object[][] objectArray = new Object[arrayList.size()][2];
            for (n = 0; n < arrayList.size(); ++n) {
                Object[] objectArray2 = (Object[])arrayList.get(n);
                System.arraycopy(objectArray2, 0, objectArray[n], 0, 2);
            }
            resultSet = StaticResultSet.newInstance(columnInfoArray, objectArray);
            this.discardResultsForDescribe();
            try {
                this.callCustomResultsProcessor(describeRequest.resultsProcessor, null, null, resultSet, true, describeRequest);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            describeRequest.ok = true;
        }
        catch (SQLException sQLException) {
        }
        catch (ISQLPluginException iSQLPluginException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describeIndex(DescribeRequest describeRequest) {
        ResultSet resultSet = null;
        String string = this.escapeSearchString(describeRequest.catalog);
        String string2 = this.escapeSearchString(describeRequest.schema);
        String string3 = this.escapeSearchString(describeRequest.name);
        String string4 = describeRequest.name;
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        DataTypeMetaData dataTypeMetaData = this.getVarcharMetaData();
        DataTypeMetaData dataTypeMetaData2 = this.getDataTypeMetaData(-7, "bit", -1, -1);
        if (dataTypeMetaData == null || dataTypeMetaData2 == null) {
            describeRequest.ok = false;
            return;
        }
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo(dataTypeMetaData, 1, iSQLResource.getISQLString("DescribeIndexName"), 32, 0, false), new ColumnInfo(dataTypeMetaData, 2, iSQLResource.getISQLString("DescribeIndexColumns"), 128, 0, false), new ColumnInfo(dataTypeMetaData2, 3, iSQLResource.getISQLString("DescribeIndexUnique"), 0, 0, false), new ColumnInfo(dataTypeMetaData, 4, iSQLResource.getISQLString("DescribeIndexType"), 32, 0, false)};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        try {
            Object[] objectArray;
            int n;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            resultSet = databaseMetaData.getTables(string, string2, string3, null);
            describeRequest.ok = resultSet.next();
            resultSet.close();
            if (!describeRequest.ok) {
                return;
            }
            resultSet = databaseMetaData.getIndexInfo(string, string2, string4, false, false);
            block21: while (resultSet.next()) {
                String string5 = resultSet.getString(9);
                if (string5 == null) continue;
                String string6 = resultSet.getString(6);
                for (n = 0; n < arrayList.size(); ++n) {
                    objectArray = (Object[])arrayList.get(n);
                    if (!((String)objectArray[0]).equals(string6)) continue;
                    objectArray[1] = (String)objectArray[1] + "," + string5;
                    continue block21;
                }
                objectArray = new Object[4];
                objectArray[0] = string6;
                objectArray[1] = string5;
                objectArray[2] = !resultSet.getBoolean(4);
                short s = resultSet.getShort(7);
                switch (s) {
                    case 0: {
                        objectArray[3] = iSQLResource.getISQLString("DescribeIndexTypeStatistic");
                        break;
                    }
                    case 1: {
                        objectArray[3] = iSQLResource.getISQLString("DescribeIndexTypeClustered");
                        break;
                    }
                    case 2: {
                        objectArray[3] = iSQLResource.getISQLString("DescribeIndexTypeHashed");
                        break;
                    }
                    default: {
                        objectArray[3] = iSQLResource.getISQLString("DescribeIndexTypeOther");
                    }
                }
                arrayList.add(objectArray);
            }
            resultSet.close();
            Object[][] objectArray2 = new Object[arrayList.size()][4];
            for (n = 0; n < arrayList.size(); ++n) {
                objectArray = (Object[])arrayList.get(n);
                System.arraycopy(objectArray, 0, objectArray2[n], 0, 4);
            }
            resultSet = StaticResultSet.newInstance(columnInfoArray, objectArray2);
            this.discardResultsForDescribe();
            try {
                this.callCustomResultsProcessor(describeRequest.resultsProcessor, null, null, resultSet, true, describeRequest);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            describeRequest.ok = true;
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void describeProcedure(DescribeRequest describeRequest) {
        ResultSet resultSet = null;
        String string = this.escapeSearchString(describeRequest.catalog);
        String string2 = this.escapeSearchString(describeRequest.schema);
        String string3 = this.escapeSearchString(describeRequest.name);
        try {
            String[] stringArray;
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            ResultSet resultSet2 = databaseMetaData.getProcedures(string, string2, string3);
            if (!resultSet2.next()) {
                describeRequest.ok = false;
                return;
            }
            resultSet2.close();
            this.getDataTypes();
            resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, "%");
            ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
            DataTypeMetaData dataTypeMetaData = this.getVarcharMetaData();
            if (dataTypeMetaData == null) {
                describeRequest.ok = false;
                return;
            }
            ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo(dataTypeMetaData, 1, iSQLResource.getISQLString("DescribeArgumentName"), 32, 0, false), new ColumnInfo(dataTypeMetaData, 2, iSQLResource.getISQLString("DescribeType"), 32, 0, false), new ColumnInfo(dataTypeMetaData, 3, iSQLResource.getISQLString("DescribeInOut"), 32, 0, false)};
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (resultSet.next()) {
                stringArray = new String[3];
                stringArray[0] = resultSet.getString(4);
                short s = resultSet.getShort(5);
                int n = resultSet.getInt(6);
                String string4 = resultSet.getString(7);
                int n2 = resultSet.getInt(8);
                int n3 = resultSet.getInt(10);
                DataTypeMetaData dataTypeMetaData2 = this.getDataTypeMetaData(n, string4, -1, -1);
                stringArray[1] = ISQLConnectionImpl.getSQLTypeName(dataTypeMetaData2, n2, n3);
                switch (s) {
                    case 1: {
                        stringArray[2] = iSQLResource.getISQLString("DescribeIn");
                        break;
                    }
                    case 2: {
                        stringArray[2] = iSQLResource.getISQLString("DescribeInOut");
                        break;
                    }
                    case 4: {
                        stringArray[2] = iSQLResource.getISQLString("DescribeOut");
                        break;
                    }
                    case 5: {
                        stringArray[2] = iSQLResource.getISQLString("DescribeReturn");
                        break;
                    }
                    case 3: {
                        stringArray[2] = iSQLResource.getISQLString("DescribeResult");
                        break;
                    }
                    default: {
                        stringArray[2] = iSQLResource.getISQLString("DescribeUnknown");
                    }
                }
                arrayList.add(stringArray);
            }
            Object[][] objectArray = new String[arrayList.size()][3];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray = (String[])arrayList.get(i);
                System.arraycopy(stringArray, 0, objectArray[i], 0, 3);
            }
            this.discardResultsForDescribe();
            resultSet2 = StaticResultSet.newInstance(columnInfoArray, objectArray);
            try {
                this.callCustomResultsProcessor(describeRequest.resultsProcessor, null, null, resultSet2, true, describeRequest);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            describeRequest.ok = true;
            return;
        }
        catch (SQLException sQLException) {
            describeRequest.ok = false;
            return;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private boolean checkSQLException(String string, SQLException sQLException, Request request) {
        boolean bl = false;
        String string2 = sQLException.getSQLState();
        int n = sQLException.getErrorCode();
        if (string2 != null && (string2.equals("08S01") || string2.equals("HY000") && n == -308 || string2.equals("08001") && n == -100) && string.regionMatches(true, 0, "STOP ENGINE", 0, 11)) {
            bl = true;
            this.releaseData();
        } else if (this._interruptRequested || string2 != null && string2.equals("JZ0PA")) {
            request.errorMessage = ISQLResource.getISQLString(ErrorMessages.getName(), "Operation was cancelled");
            bl = true;
        } else if (string2 != null && (string2.equals("JZ0C0") || string2.equals("HY000") && n == -308 || string2.equals("08S01") && n == -308 || string2.equals("08S01") && n == -85)) {
            ParentFrame parentFrame;
            request.errorMessage = ISQLResource.getISQLString(ErrorMessages.getName(), "ConnectionWasClosed");
            this.releaseData();
            if (isql.useGUI() && (parentFrame = WindowManager.findFrameByConnection(this)) != null) {
                parentFrame.setWindowTitle();
            }
        } else {
            request.errorMessage = ISQLResource.getISQLString(ErrorMessages.getName(), "Could not execute statement.");
        }
        return bl;
    }

    static boolean statementReturnsUpdateCount(String string) {
        boolean bl;
        boolean bl2 = bl = string.length() > 7 && Character.isWhitespace(string.charAt(6));
        if (bl) {
            String string2 = string.substring(0, 6).toUpperCase();
            bl = string2.equals("INSERT") || string2.equals("UPDATE") || string2.equals("DELETE") || string2.equals("MERGE");
        }
        return bl;
    }

    static boolean statementReturnsResultSet(String string) {
        boolean bl = string != null && string.length() > 7 && Character.isWhitespace(string.charAt(6)) && string.substring(0, 6).toUpperCase().equals("SELECT");
        return bl;
    }

    static boolean statementIsProcedureCall(String string) {
        boolean bl = string != null && string.length() > 5 && Character.isWhitespace(string.charAt(4)) && string.substring(0, 4).toUpperCase().equals("CALL");
        return bl;
    }

    static ResultSet getFirstResultSet(Statement statement, boolean bl) {
        ResultSet resultSet = null;
        int n = -1;
        n = 0;
        do {
            if (bl) {
                try {
                    resultSet = statement.getResultSet();
                }
                catch (SQLException sQLException) {}
                break;
            }
            try {
                n = statement.getUpdateCount();
            }
            catch (SQLException sQLException) {
                n = -1;
            }
            if (n == -1) continue;
            try {
                bl = statement.getMoreResults();
            }
            catch (SQLException sQLException) {
                break;
            }
        } while (bl || n != -1);
        return resultSet;
    }

    private void cacheSingleResultSet(String string, ResultSet resultSet) {
        ISQLResultSetImpl iSQLResultSetImpl = new ISQLResultSetImpl(this, string, resultSet, this._maxRows, Preferences.getPluginStringPreference(this, "nulls", "(NULL)"), false);
        this._resultSetList.addElement(new ResultSetListItem(iSQLResultSetImpl, false));
    }

    public boolean getInterruptRequested() {
        return this._interruptRequested;
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void handleConnect(ConnectRequest connectRequest) {
        block10: {
            if (this._plugin == null || this._connectionInfo == null) {
                return;
            }
            try {
                this._connection = this._plugin.connect(this, this._connectionInfo);
                if (connectRequest.warnings != null) {
                    try {
                        SQLWarning sQLWarning;
                        if (sQLWarning != null) {
                            for (sQLWarning = this._connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                                connectRequest.warnings.addElement(sQLWarning.getMessage());
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                try {
                    this._connection.clearWarnings();
                    this.initializeConnection(connectRequest.warnings);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this._connected = true;
            }
            catch (ISQLPluginException iSQLPluginException) {
                Throwable throwable = iSQLPluginException.getCause();
                if (throwable == null) break block10;
                connectRequest.ex = throwable;
                if (connectRequest.warnings == null) break block10;
                connectRequest.warnings.add(iSQLPluginException.getLocalizedMessage());
            }
        }
    }

    boolean supportsSchemas() {
        return this._supportsSchemas;
    }

    boolean supportsCatalogs() {
        return this._supportsCatalogs;
    }

    private void initializeConnection(Vector<String> vector) throws SQLException {
        block20: {
            DatabaseMetaData databaseMetaData = null;
            this._statement = null;
            this._databaseType = -1;
            this._databaseProductName = null;
            this._maxRows = Preferences.getPluginIntPreference(this, "maximumDisplayedRows", "500");
            try {
                databaseMetaData = this._connection.getMetaData();
                this._userName = databaseMetaData.getUserName();
                try {
                    this._supportsCatalogs = databaseMetaData.supportsCatalogsInDataManipulation();
                }
                catch (SQLException sQLException) {
                    this._supportsCatalogs = true;
                }
                try {
                    this._supportsSchemas = databaseMetaData.supportsSchemasInDataManipulation();
                }
                catch (SQLException sQLException) {
                    this._supportsSchemas = true;
                }
                this._driverType = DriverType.JDBC_ODBC;
                try {
                    String string = databaseMetaData.getDriverName();
                    if (string.startsWith("jConnect")) {
                        this._driverType = DriverType.JCONNECT;
                        this._jconnectConnectionProxy = new JConnectConnectionProxy(this._connection);
                    } else {
                        this._driverType = DriverType.JDBC_ODBC;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    this._catalog = this._connection.getCatalog();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("HYC00")) {
                        this._catalog = null;
                    }
                    throw sQLException;
                }
                this._isUtilityDatabase = this._catalog != null && this._catalog.equalsIgnoreCase("UTILITY_DB");
            }
            catch (SQLException sQLException) {
                String string = sQLException.getMessage();
                if (string.indexOf("JZ0SJ") == -1) {
                    throw sQLException;
                }
                this._isUtilityDatabase = this.checkUtilityDatabase();
                if (this._isUtilityDatabase) break block20;
                this._missingJConnectSupport = true;
                if (vector == null) {
                    isql.getIO(this).writeln(ISQLResource.getISQLString(GeneralResources.getName(), "The database does not have jConnect support installed.\nSome functionality in ISQL will not be available."), 0);
                }
                vector.add(ISQLResource.getISQLString(GeneralResources.getName(), "The database does not have jConnect support installed.\nSome functionality in ISQL will not be available."));
            }
        }
        int n = this.getDatabaseType();
        if (isql.options.useGUI && !isql.options.quiet) {
            ParentFrame parentFrame;
            if (n == 0 || n == 2) {
                PostLoginProcedureHandler.execute(this);
            } else if (n == 1 && (parentFrame = WindowManager.findFrameByConnection(this)) != null) {
                parentFrame.fillDBNames(this);
            }
        }
        if (n == 3 && (this._userName == null || this._userName.isEmpty())) {
            this._userName = "dba";
        }
    }

    @Override
    public int getASAMajorVersionNumber() {
        int[] nArray;
        int n = -1;
        int n2 = this.getDatabaseType();
        if ((n2 == 0 || n2 == 2) && (nArray = this._plugin.getDatabaseVersion(this)) != null) {
            n = nArray[0];
        }
        return n;
    }

    boolean isMetaDataAvailable() {
        return !this._missingJConnectSupport;
    }

    boolean isUtilityDatabase() {
        return this._isUtilityDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUtilityDatabase() {
        boolean bl = false;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = this.createReadOnlyStatement();
            boolean bl2 = statement.execute("SELECT db_property('name')");
            if (!bl2) {
            } else {
                resultSet = statement.getResultSet();
                boolean bl3 = bl2 = resultSet != null;
                if (!bl2) {
                } else {
                    bl2 = resultSet.next();
                    if (!bl2) {
                    } else {
                        Object object = resultSet.getObject(1);
                        boolean bl4 = bl2 = object != null;
                        if (!bl2) {
                        } else {
                            boolean bl5 = bl2 = object.toString().length() != 0;
                            if (!bl2) {
                            } else if (object.toString().equalsIgnoreCase("UTILITY_DB")) {
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
            if (statement != null) {
                this.closeStatement(statement);
                statement = null;
            }
        }
        return bl;
    }

    private void handleDisconnect() {
        if (this._connected) {
            block4: {
                if (this._statement != null) {
                    this.closeStatement(this._statement);
                    this._statement = null;
                }
                try {
                    this._plugin.disconnect(this);
                }
                catch (ISQLPluginException iSQLPluginException) {
                    boolean bl;
                    Throwable throwable = iSQLPluginException.getCause();
                    if (!(throwable instanceof SQLException)) break block4;
                    SQLException sQLException = (SQLException)throwable;
                    boolean bl2 = bl = !this.exceptionMeansDatabaseIsDisconnected(sQLException.getErrorCode(), sQLException.getSQLState(), sQLException.getMessage());
                    if (!bl) break block4;
                    ISQLConnectionImpl.displaySQLException(this, "Could not disconnect from the database.", sQLException);
                }
            }
            this.releaseData();
        }
    }

    private boolean exceptionMeansDatabaseIsDisconnected(int n, String string, String string2) {
        if (string2 != null && string2.indexOf("JZ006") != -1) {
            return true;
        }
        switch (this.getDatabaseType()) {
            case 0: 
            case 2: {
                if (n == -308) {
                    return true;
                }
                if (n != -85 || string == null || !string.equals("08S01")) break;
                return true;
            }
        }
        return false;
    }

    private static String getRequestName(int n) {
        String string = null;
        string = Integer.toString(n);
        return string;
    }

    private synchronized void enqueueRequest(Request request) {
        boolean bl;
        if (this._request != null && request.type != 2) {
            throw new IllegalStateException("ISQLConnectionImpl.enqueueRequest() called while request already in progress\n  Current request is " + ISQLConnectionImpl.getRequestName(this._request.type) + "\n" + "  New (ignored) request is " + ISQLConnectionImpl.getRequestName(request.type));
        }
        if (this._request != null && request.type == 2) {
            this._disconnectAfterRequestFinished = true;
            this.interrupt();
            return;
        }
        if (!this._connected && request.type != 1 && request.type != 2) {
            if (!(request instanceof CallbackRequest) || ((CallbackRequest)request).pumpEvents) {
                isql.getIO(this).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "You are not connected to a database."), 2);
            }
            return;
        }
        if (this._worker == null) {
            if (request.type == 2) {
                return;
            }
            this.createWorkerThread();
        }
        this._interruptRequested = false;
        this._request = request;
        this._requestDone = false;
        this.notifyAll();
        isql.enableUIForConnection(this, false);
        boolean bl2 = bl = request.type != 16 && isql.useGUI() && EventQueue.isDispatchThread();
        if (bl && request.type == 15 && !((CallbackRequest)request).pumpEvents) {
            bl = false;
        }
        try {
            Runnable runnable;
            EventQueuePumper.Condition condition;
            if (bl) {
                condition = new EventQueuePumper.Condition(){

                    public boolean keepGoing() {
                        return !ISQLConnectionImpl.this._requestDone;
                    }
                };
                runnable = new Runnable(){

                    @Override
                    public void run() {
                    }
                };
            } else {
                condition = null;
                runnable = null;
            }
            while (!this._requestDone) {
                if (bl) {
                    EventQueuePumper.pump((EventQueuePumper.Condition)condition);
                    if (this._requestDone) break;
                    SwingUtilities.invokeLater(runnable);
                }
                this.wait(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        isql.enableUIForConnection(this, true);
        this._interruptRequested = false;
        if (request.runtimeError != null) {
            throw new Error("Database worker thread request failed because of a runtime error.\nRequest=" + request.toString(), request.runtimeError);
        }
        if (this._disconnectAfterRequestFinished) {
            this._disconnectAfterRequestFinished = false;
            this.disconnect();
        }
    }

    private synchronized Request dequeueRequest() {
        Request request;
        if (this._request == null) {
            try {
                this.wait();
                request = this._request;
            }
            catch (InterruptedException interruptedException) {
                request = null;
            }
        } else {
            request = this._request;
        }
        return request;
    }

    private synchronized void removeRequest() {
        this._request = null;
        this._requestDone = true;
        this.notify();
    }

    @Override
    public boolean isBusy() {
        return this._request != null || this._inClientAsyncCallback;
    }

    @Override
    public void interrupt() {
        if (this._interruptRequested) {
            Dbg.printlnEx((Throwable)new Exception(), (String)("Warning! Repeated interrupt request for connection " + Integer.toHexString(this.hashCode()) + " ignored."));
            return;
        }
        if (!this.isBusy()) {
            Dbg.printlnEx((Throwable)new Exception(), (String)("Warning! interrupt request for connection " + Integer.toHexString(this.hashCode()) + ", but the connection was not busy."));
            return;
        }
        this._interruptRequested = true;
        if (this._statement != null) {
            try {
                if (this._statement != null) {
                    this._statement.cancel();
                }
            }
            catch (SQLException sQLException) {
            }
            catch (Exception exception) {
                this._interruptRequested = false;
            }
        } else if (this._connection != null && this._driverType == DriverType.JCONNECT) {
            try {
                this._jconnectConnectionProxy.cancel();
            }
            catch (SQLException sQLException) {}
        } else if (this.getResultSetCount() > 0) {
            for (int i = 0; i < this._resultSetList.size(); ++i) {
                ResultSet resultSet;
                ISQLResultSet iSQLResultSet = this._resultSetList.get((int)i).isqlResultSet;
                ScrollableResultSet scrollableResultSet = iSQLResultSet.getScrollableResultSet();
                if (scrollableResultSet == null || (resultSet = scrollableResultSet.getJDBCResultSet()) == null) continue;
                try {
                    Statement statement = resultSet.getStatement();
                    statement.cancel();
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        this._inClientAsyncCallback = false;
    }

    String getLastSQLStatement() {
        return this._lastSQLStatement;
    }

    @Override
    public AbstractConnectionInfo getConnectionInfo() {
        return this._connectionInfo;
    }

    boolean canConnect() {
        return this._connectionInfo != null && this._connectionInfo.canAttemptConnection();
    }

    @Override
    public String getDescription() {
        int n = this.getDatabaseType();
        String string = n == 1 ? this.getASEDescription() : this.getASADescription();
        return string;
    }

    private String getASEDescription() {
        boolean bl;
        boolean bl2 = bl = this._connectionInfo.getDatabaseType() == 1;
        if (!bl) {
            return "";
        }
        ASEConnectionInfo aSEConnectionInfo = (ASEConnectionInfo)this._connectionInfo;
        String string = aSEConnectionInfo.getConnectionName();
        if (string == null || string.isEmpty()) {
            String string2 = this.getServerName();
            String string3 = aSEConnectionInfo.getUserName();
            String string4 = this.getUserID();
            string = string2 + " (" + string3 + ") / ";
            string = string + this.getCatalog() + " (" + string4 + ")";
            String string5 = aSEConnectionInfo.getProperty("SERVICEFILTER");
            if (string5 != null && string5.equals("ssl")) {
                string = string + " (SSL)";
            }
        }
        return string;
    }

    private String getASADescription() {
        String string = this._connectionInfo.getDatabaseType() == 0 ? ((ASAConnectionInfo)this._connectionInfo).connectionName : null;
        if (string == null || string.length() == 0) {
            string = this.createDescriptionWithDatabaseName();
        }
        return string;
    }

    private String createDescriptionWithDatabaseName() {
        String string = this.getServerName();
        String string2 = this.getUserID();
        String string3 = string2 == null ? string : (string == null || string.length() == 0 ? (this._catalog == null || this._catalog.length() == 0 ? string2 : ISQLResource.getFormattedString(GeneralResources.getName(), "{0} ({1})", this._catalog, string2)) : ISQLResource.getFormattedString(GeneralResources.getName(), "{0} ({1}) on {2}", this._catalog, string2, string));
        return string3;
    }

    @Override
    public String getServerName() {
        Object object;
        if (this.getDatabaseType() == 1) {
            if (!(this._connectionInfo instanceof ASEConnectionInfo)) {
                return "";
            }
            object = (ASEConnectionInfo)this._connectionInfo;
            String string = ((ASEConnectionInfo)object).getProperty("SERVERNAME");
            if (string != null) {
                return string;
            }
            if (((ASEConnectionInfo)object).host != null && ((ASEConnectionInfo)object).port != -1) {
                return ((ASEConnectionInfo)object).host + ":" + ((ASEConnectionInfo)object).port;
            }
        }
        object = new GetServerNameRequest();
        if (Thread.currentThread() == this._worker) {
            this.handleGetServerName((Request)object);
        } else {
            this.enqueueRequest((Request)object);
        }
        return ((GetServerNameRequest)object).name;
    }

    @Override
    public ArrayList<String> getDatabaseNames() {
        GetDatabaseNamesRequest getDatabaseNamesRequest = new GetDatabaseNamesRequest();
        if (Thread.currentThread() == this._worker) {
            this.handleGetDatabaseNames(getDatabaseNamesRequest);
        } else {
            this.enqueueRequest(getDatabaseNamesRequest);
        }
        return getDatabaseNamesRequest.names;
    }

    static void displaySQLException(ISQLConnection iSQLConnection, String string, SQLException sQLException) {
        IO iO = isql.getIO(iSQLConnection);
        if (iO != null) {
            iO.writeln(ISQLConnectionImpl.gatherSQLExceptionInfo(string, sQLException), 2);
        }
    }

    static String gatherSQLExceptionInfo(String string, SQLException sQLException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ISQLResource.getISQLString(ErrorMessages.getName(), string));
        stringBuilder.append("\n");
        stringBuilder.append(isql.formatSQLExceptionMessage(sQLException));
        stringBuilder.append("\n");
        SQLException sQLException2 = sQLException.getNextException();
        if (sQLException2 != null) {
            stringBuilder.append("\n");
            stringBuilder.append(sQLException2.getMessage());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean describe(String string, String string2, String string3, DescribeOption describeOption, int n, ResultsProcessor resultsProcessor) {
        DescribeRequest describeRequest = new DescribeRequest(string, string2, string3, describeOption, n, resultsProcessor);
        if (Thread.currentThread() == this._worker) {
            this.handleDescribe(describeRequest);
        } else {
            this.enqueueRequest(describeRequest);
        }
        return describeRequest.ok;
    }

    @Override
    public boolean execute(String string, boolean bl, boolean bl2, int n, SQLWarning[] sQLWarningArray, SQLException[] sQLExceptionArray, String[] stringArray, ResultsProcessor resultsProcessor) {
        if (sQLWarningArray != null && sQLWarningArray.length == 0) {
            throw new IllegalArgumentException("warning array length cannot be zero");
        }
        if (sQLExceptionArray != null && sQLExceptionArray.length == 0) {
            throw new IllegalArgumentException("error array length cannot be zero");
        }
        if (stringArray != null && stringArray.length == 0) {
            throw new IllegalArgumentException("errorMessage array length cannot be zero");
        }
        ExecuteRequest executeRequest = new ExecuteRequest(string, bl, bl2, n, resultsProcessor);
        if (Thread.currentThread() == this._worker) {
            this.handleExecute(executeRequest);
        } else {
            this.enqueueRequest(executeRequest);
        }
        if (sQLWarningArray != null) {
            sQLWarningArray[0] = executeRequest.warning;
        }
        if (sQLExceptionArray != null) {
            sQLExceptionArray[0] = executeRequest.error;
        }
        if (stringArray != null) {
            stringArray[0] = executeRequest.errorMessage;
        }
        return executeRequest.ok;
    }

    @Override
    public boolean checkSyntax(String string, SQLException[] sQLExceptionArray, String[] stringArray) {
        if (sQLExceptionArray != null && sQLExceptionArray.length == 0) {
            throw new IllegalArgumentException("error array length must be zero");
        }
        if (stringArray != null && stringArray.length == 0) {
            throw new IllegalArgumentException("errorMessage array length must be zero");
        }
        CheckSyntaxRequest checkSyntaxRequest = new CheckSyntaxRequest(string);
        if (Thread.currentThread() == this._worker) {
            this.handleCheckSyntax(checkSyntaxRequest);
        } else {
            this.enqueueRequest(checkSyntaxRequest);
        }
        if (sQLExceptionArray != null) {
            sQLExceptionArray[0] = checkSyntaxRequest.error;
        }
        if (stringArray != null) {
            stringArray[0] = checkSyntaxRequest.errorMessage;
        }
        return checkSyntaxRequest.ok;
    }

    @Override
    public void connect(Vector<String> vector) throws Exception {
        if (vector != null) {
            vector.clear();
        }
        ConnectRequest connectRequest = new ConnectRequest(vector);
        if (Thread.currentThread() == this._worker) {
            this.handleConnect(connectRequest);
        } else {
            this.enqueueRequest(connectRequest);
        }
        if (connectRequest.ex != null) {
            if (connectRequest.ex instanceof Exception) {
                throw (Exception)connectRequest.ex;
            }
            throw new Exception(connectRequest.ex);
        }
    }

    @Override
    public boolean isConnected() {
        boolean bl = this._connected;
        if (bl) {
            try {
                if (this._driverType == DriverType.JDBC_ODBC && !this.isBusy() && this._connection.isClosed()) {
                    bl = false;
                    this._connected = false;
                }
            }
            catch (SQLException sQLException) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void disconnect() {
        if (Thread.currentThread() == this._worker) {
            this.handleDisconnect();
        } else {
            this.enqueueRequest(new Request(2));
        }
    }

    @Override
    public String[] disambiguateIdentifier(IdentifierType identifierType, String string, String string2, String string3) {
        DisambiguateIdentifierRequest disambiguateIdentifierRequest = new DisambiguateIdentifierRequest(identifierType, string, string2, string3);
        if (Thread.currentThread() == this._worker) {
            this.handleDisambiguateIdentifier(disambiguateIdentifierRequest);
        } else {
            this.enqueueRequest(disambiguateIdentifierRequest);
        }
        return disambiguateIdentifierRequest.retcode;
    }

    @Override
    public boolean tableExists(String string, String string2, String string3) {
        TableExistsRequest tableExistsRequest = new TableExistsRequest(string, string2, string3);
        if (Thread.currentThread() == this._worker) {
            this.handleTableExists(tableExistsRequest);
        } else {
            this.enqueueRequest(tableExistsRequest);
        }
        return tableExistsRequest.exists;
    }

    @Override
    public void listTables(String string, String string2, String string3, int n, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ListTablesRequest listTablesRequest = new ListTablesRequest(string, string2, string3, n, arrayList, arrayList2);
        if (Thread.currentThread() == this._worker) {
            this.handleListTables(listTablesRequest);
        } else {
            this.enqueueRequest(listTablesRequest);
        }
    }

    @Override
    public void listProcedures(String string, String string2, String string3, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ListProceduresRequest listProceduresRequest = new ListProceduresRequest(string, string2, string3, arrayList, arrayList2);
        if (Thread.currentThread() == this._worker) {
            if (this.getDatabaseType() == 1) {
                this.handleListASEProcedures(listProceduresRequest);
            } else {
                this.handleListProcedures(listProceduresRequest);
            }
        } else {
            this.enqueueRequest(listProceduresRequest);
        }
    }

    @Override
    public void createTable(String string, String string2, String string3, TableGenitor tableGenitor) throws SQLException {
        CreateTableRequest createTableRequest = new CreateTableRequest(string, string2, string3, tableGenitor);
        if (Thread.currentThread() == this._worker) {
            this.handleCreateTable(createTableRequest);
        } else {
            this.enqueueRequest(createTableRequest);
        }
        if (createTableRequest.sqlException != null) {
            throw createTableRequest.sqlException;
        }
    }

    @Override
    public boolean addTableData(String string, String string2, String string3, TableGenitor tableGenitor) throws ImporterFailedException {
        AddTableDataRequest addTableDataRequest = new AddTableDataRequest(string, string2, string3, tableGenitor);
        if (Thread.currentThread() == this._worker) {
            this.handleAddTableData(addTableDataRequest);
        } else {
            this.enqueueRequest(addTableDataRequest);
        }
        if (addTableDataRequest.importerException != null) {
            throw addTableDataRequest.importerException;
        }
        return addTableDataRequest.ok;
    }

    @Override
    public boolean addTableData(String string, String string2, String string3, TableGenitor tableGenitor, Vector<String> vector) throws ImporterFailedException {
        AddTableDataRequest addTableDataRequest = new AddTableDataRequest(string, string2, string3, tableGenitor, vector);
        if (Thread.currentThread() == this._worker) {
            this.handleAddTableData(addTableDataRequest);
        } else {
            this.enqueueRequest(addTableDataRequest);
        }
        if (addTableDataRequest.importerException != null) {
            throw addTableDataRequest.importerException;
        }
        return addTableDataRequest.ok;
    }

    @Override
    public String[] getColumnNames(String string, String string2, String string3) throws SQLException {
        GetColumnNamesRequest getColumnNamesRequest = new GetColumnNamesRequest(string, string2, string3);
        if (Thread.currentThread() == this._worker) {
            this.handleGetColumnNames(getColumnNamesRequest);
        } else {
            this.enqueueRequest(getColumnNamesRequest);
        }
        if (getColumnNamesRequest.sqlException != null) {
            throw getColumnNamesRequest.sqlException;
        }
        return getColumnNamesRequest.names;
    }

    @Override
    public TableInfo getTableInfo(String string, String string2, String string3) {
        GetTableInfoRequest getTableInfoRequest = new GetTableInfoRequest(string, string2, string3);
        if (Thread.currentThread() == this._worker) {
            this.handleGetTableInfo(getTableInfoRequest);
        } else {
            this.enqueueRequest(getTableInfoRequest);
        }
        return getTableInfoRequest.info;
    }

    @Override
    public void setMaximumRowCount(int n) {
        this._maxRows = n;
    }

    @Override
    public int getMaximumRowCount() {
        return this._maxRows;
    }

    @Override
    public int getResultSetCount() {
        return this.getResultSetCount(false);
    }

    int getResultSetCount(boolean bl) {
        int n = 0;
        if (this._resultSetList != null) {
            for (int i = 0; i < this._resultSetList.size(); ++i) {
                if (!bl && this._resultSetList.get((int)i).isInternal) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public ISQLResultSet getResultSet(int n) {
        return this.getResultSet(n, false);
    }

    ISQLResultSet getResultSet(int n, boolean bl) {
        ISQLResultSet iSQLResultSet = null;
        if (this._resultSetList != null && n < this._resultSetList.size()) {
            for (int i = 0; i < this._resultSetList.size(); ++i) {
                ResultSetListItem resultSetListItem = this._resultSetList.get(i);
                if (!bl && resultSetListItem.isInternal) continue;
                if (n == 0) {
                    iSQLResultSet = resultSetListItem.isqlResultSet;
                    break;
                }
                --n;
            }
        }
        return iSQLResultSet;
    }

    @Override
    public void discardResultSets() {
        if (this._resultSetList != null) {
            int n = this._resultSetList.size();
            for (int i = 0; i < n; ++i) {
                ISQLResultSet iSQLResultSet = this._resultSetList.get((int)i).isqlResultSet;
                iSQLResultSet.close();
            }
            this._resultSetList.removeAllElements();
        }
    }

    @Override
    public String getName() {
        String string = null;
        if (this._connectionInfo != null) {
            if (this._connectionInfo.getDatabaseType() == 0) {
                string = ((ASAConnectionInfo)this._connectionInfo).connectionName;
            } else if (this._connectionInfo.getDatabaseType() == 1) {
                string = ((ASEConnectionInfo)this._connectionInfo).getConnectionName();
            }
        }
        return string;
    }

    @Override
    public String getUserID() {
        return this._userName;
    }

    void setUserID(String string) {
        this._userName = string;
    }

    @Override
    public boolean setCatalog(String string) throws SQLException {
        boolean bl;
        if (this.getDatabaseType() == 0) {
            bl = false;
        } else {
            SetCatalogRequest setCatalogRequest = new SetCatalogRequest(string);
            if (Thread.currentThread() == this._worker) {
                this.handleSetCatalog(setCatalogRequest);
            } else {
                this.enqueueRequest(setCatalogRequest);
            }
            if (setCatalogRequest.sqlException != null) {
                throw setCatalogRequest.sqlException;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public String getCatalog() {
        String string;
        if (this.getDatabaseType() == 0) {
            string = this._catalog;
        } else {
            GetCatalogRequest getCatalogRequest = new GetCatalogRequest();
            if (Thread.currentThread() == this._worker) {
                this.handleGetCatalog(getCatalogRequest);
            } else {
                this.enqueueRequest(getCatalogRequest);
            }
            string = getCatalogRequest.name;
        }
        return string;
    }

    @Override
    public int getDatabaseType() {
        if (this._databaseType == -1) {
            if (this._connection != null) {
                this._databaseType = 99;
                try {
                    DatabaseMetaData databaseMetaData = this._connection.getMetaData();
                    String string = databaseMetaData.getDatabaseProductName();
                    this._databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
                    this._databaseProductName = string;
                    if (string.indexOf("Adaptive Server Anywhere") != -1 || string.equals("Sybase SQL Anywhere") || string.equals("SQL Anywhere")) {
                        this._databaseType = this._databaseProductVersion != null && this._databaseProductVersion.length() > 0 && this._databaseProductVersion.indexOf("IQ") != -1 ? 2 : 0;
                    } else if (string.equals("Sybase SQL Server") || string.equals("SQL Server") || string.equals("Adaptive Server Enterprise")) {
                        this._databaseType = 1;
                    } else if (string.indexOf("Sybase IQ") != -1) {
                        this._databaseType = 2;
                    } else if (string.equalsIgnoreCase("Adaptive Server IQ")) {
                        this._databaseType = 2;
                    } else if (string.equalsIgnoreCase("UltraLite")) {
                        this._databaseType = 3;
                    }
                }
                catch (SQLException sQLException) {}
            } else {
                this._databaseType = isql.options.getDefaultDatabaseType();
                this._databaseProductName = null;
                this._databaseProductVersion = null;
            }
        }
        return this._databaseType;
    }

    private static String quoteString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    @Override
    public void listOptions(Vector<String> vector, Vector<String> vector2) throws SQLException {
        ListOptionsRequest listOptionsRequest = new ListOptionsRequest(vector, vector2);
        if (Thread.currentThread() == this._worker) {
            this.handleListOptions(listOptionsRequest);
        } else {
            this.enqueueRequest(listOptionsRequest);
        }
        if (listOptionsRequest.errorMessage != null) {
            SQLException sQLException = new SQLException(listOptionsRequest.errorMessage);
            sQLException.initCause(listOptionsRequest.runtimeError);
            throw sQLException;
        }
    }

    @Override
    public DataTypeMetaData[] getDataTypes() {
        if (this._dataTypes == null) {
            if (Thread.currentThread() == this._worker) {
                this.fetchDataTypeMetaData();
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ISQLConnectionImpl.this.fetchDataTypeMetaData();
                    }
                };
                try {
                    this.callbackOnWorkerThread(runnable, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this._dataTypes;
    }

    @Override
    public void releaseDatabaseLocks() {
        if (Thread.currentThread() == this._worker) {
            this.handleReleaseDatabaseLocks();
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ISQLConnectionImpl.this.handleReleaseDatabaseLocks();
                }
            };
            try {
                this.callbackOnWorkerThread(runnable, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReleaseDatabaseLocks() {
        Statement statement = null;
        this.closePreviousStatement(false);
        int n = this.getDatabaseType();
        try {
            int[] nArray;
            boolean bl;
            if (n == 0 && (bl = (nArray = this._plugin.getDatabaseVersion(this)) != null && nArray.length >= 3 ? nArray[0] >= 10 || nArray[0] == 9 && nArray[2] >= 1 : false) && !this._connection.getAutoCommit()) {
                statement = this._connection.createStatement();
                ResultSet resultSet = statement.executeQuery("select connection_property('TransactionStartTime')");
                resultSet.next();
                String string = resultSet.getString(1);
                if (string == null || string.length() == 0) {
                    this._connection.rollback();
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                this.closeStatement(statement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchDataTypeMetaData() {
        ResultSet resultSet = null;
        ArrayList<DataTypeMetaData> arrayList = new ArrayList<DataTypeMetaData>();
        try {
            resultSet = this._connection.getMetaData().getTypeInfo();
            if (resultSet != null) {
                while (resultSet.next()) {
                    arrayList.add(new DataTypeMetaData(resultSet.getInt(2), resultSet.getString(1), resultSet.getInt(3), resultSet.getInt(14), resultSet.getInt(15), resultSet.getBoolean(12), resultSet.getString(6)));
                }
            }
        }
        catch (SQLException sQLException) {
            Dbg.printlnEx((Throwable)sQLException, (String)"Could not get type info");
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
        }
        this._dataTypes = new DataTypeMetaData[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this._dataTypes[i] = (DataTypeMetaData)arrayList.get(i);
        }
        Arrays.sort(this._dataTypes, new Comparator<DataTypeMetaData>(){
            Collator _collator = Collator.getInstance();

            @Override
            public int compare(DataTypeMetaData dataTypeMetaData, DataTypeMetaData dataTypeMetaData2) {
                return this._collator.compare(dataTypeMetaData.getName(), dataTypeMetaData2.getName());
            }
        });
    }

    @Override
    public void executeOnWorkerThread(Runnable runnable, boolean bl) throws Exception {
        this.callbackOnWorkerThread(runnable, bl, false);
    }

    void callbackOnWorkerThread(Runnable runnable) throws Exception {
        this.callbackOnWorkerThread(runnable, false, false);
    }

    void callbackOnWorkerThread(Runnable runnable, boolean bl) throws Exception {
        this.callbackOnWorkerThread(runnable, false, bl);
    }

    void callbackOnWorkerThread(Runnable runnable, boolean bl, boolean bl2) throws Exception {
        if (Thread.currentThread() == this._worker) {
            runnable.run();
        } else {
            CallbackRequest callbackRequest = new CallbackRequest(runnable, bl);
            if (bl2) {
                callbackRequest.type = 16;
            }
            this.enqueueRequest(callbackRequest);
            if (callbackRequest.e != null) {
                throw callbackRequest.e;
            }
        }
    }

    @Override
    public int getUpdateCount() {
        return this._updateCount;
    }

    private Statement createReadOnlyStatement() throws SQLException {
        Statement statement = null;
        try {
            statement = this._connection.createStatement(1003, 1007);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            statement = this._connection.createStatement();
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("HYC00")) {
                statement = this._connection.createStatement();
            }
            throw sQLException;
        }
        if ((this._databaseType == 0 || this._databaseType == 2 || this._databaseType == 1) && this._driverType == DriverType.JCONNECT) {
            statement.setFetchSize(this._maxRows);
        }
        return statement;
    }

    private PreparedStatement createPreparedStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareReadOnlyStatement(this._connection, string, this._maxRows);
        return preparedStatement;
    }

    private void closePreviousStatement(boolean bl) {
        if (this._previousStatement != null) {
            this.closeStatement(this._previousStatement);
            this._previousStatement = null;
        }
        if (bl) {
            this.discardResultSets();
        }
    }

    private PreparedStatement prepareReadOnlyStatement(Connection connection, String string, int n) throws SQLException {
        PreparedStatement preparedStatement;
        if (false & Dbg.enabled((String)"Connection")) {
            Dbg.printlnEx((String)("Preparing: " + string));
        }
        try {
            preparedStatement = connection.prepareStatement(string, 1003, 1007);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            preparedStatement = connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            String string2 = sQLException.getSQLState();
            if (string2 != null && string2.equals("HYC00")) {
                preparedStatement = connection.prepareStatement(string);
            }
            if (false & Dbg.enabled((String)"Connection")) {
                Dbg.printlnEx((Throwable)sQLException, (String)"Note! Got exception during call to Connection.prepareStatement");
            }
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getLocalizedMessage());
        }
        if (this._interruptRequested) {
            throw new SQLException(ISQLResource.getISQLString(ErrorMessages.getName(), "Operation was cancelled"));
        }
        if ((this._databaseType == 0 || this._databaseType == 2 || this._databaseType == 1) && this._driverType == DriverType.JCONNECT) {
            preparedStatement.setFetchSize(n);
        }
        return preparedStatement;
    }

    boolean validateCurrentThread() {
        return ISQLConnectionImpl.validateCurrentThread(this);
    }

    static boolean validateCurrentThread(ISQLConnectionImpl iSQLConnectionImpl) {
        boolean bl = true;
        return bl;
    }

    private String quoteIdentifier(String string) {
        String string2;
        if (this._databaseType == 1) {
            return string;
        }
        try {
            string2 = this._connection.getMetaData().getIdentifierQuoteString();
            if (string2 == null || string2.length() == 0 || string2.equals(" ")) {
                return string;
            }
        }
        catch (Exception exception) {
            string2 = "\"";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        stringBuffer.append(string2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (string2.length() != 1 || c != string2.charAt(0)) continue;
            stringBuffer.append(c);
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    String quoteOwnerAndTableName(String string, String string2) {
        return this.quoteOwnerAndTableName(null, string, string2);
    }

    String quoteOwnerAndTableName(String string, String string2, String string3) {
        String string4 = string2 == null || string2.isEmpty() ? this.quoteIdentifier(string3) : (string == null || string.isEmpty() ? this.quoteIdentifier(string2) + "." + this.quoteIdentifier(string3) : this.quoteIdentifier(string) + "." + this.quoteIdentifier(string2) + "." + this.quoteIdentifier(string3));
        return string4;
    }

    @Override
    public DriverType getDriverType() {
        return this._driverType;
    }

    boolean addLineToBufferedAsyncMessages(String string) {
        boolean bl;
        if (this._bufferedAsyncMessages != null) {
            this._bufferedAsyncMessages.addElement(string);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean dbgEnabled() {
        return false;
    }

    static class CallbackRequest
    extends Request {
        Runnable r;
        boolean pumpEvents;
        Exception e;

        CallbackRequest(Runnable runnable, boolean bl) {
            super(15);
            this.r = runnable;
            this.e = null;
            this.pumpEvents = bl;
        }

        @Override
        public String toString() {
            return "[CallbackRequest:pumpEvents= " + this.pumpEvents + ",runnable is a " + this.r.getClass().getName() + "]";
        }
    }

    static class ListOptionsRequest
    extends Request {
        Vector<String> names;
        Vector<String> values;
        boolean ok;

        ListOptionsRequest(Vector<String> vector, Vector<String> vector2) {
            super(14);
            this.names = vector;
            this.values = vector2;
            this.ok = false;
        }

        @Override
        public String toString() {
            return "[ListOptionsRequest:,names=" + this.names + ",values=" + this.values + "]";
        }
    }

    static class GetColumnNamesRequest
    extends Request {
        String catalog;
        String owner;
        String tableName;
        String[] names;
        SQLException sqlException;

        GetColumnNamesRequest(String string, String string2, String string3) {
            super(12);
            this.catalog = string;
            this.owner = string2;
            this.tableName = string3;
            this.names = null;
            this.sqlException = null;
        }

        @Override
        public String toString() {
            return "[GetColumnNamesRequest:catalog=" + this.catalog + "owner=" + this.owner + ",tableName=" + this.tableName + ",sqlException=" + this.sqlException + "]";
        }
    }

    static class TableExistsRequest
    extends Request {
        String catalog;
        String owner;
        String tableName;
        boolean exists;

        TableExistsRequest(String string, String string2, String string3) {
            super(11);
            this.catalog = string;
            this.owner = string2;
            this.tableName = string3;
            this.exists = false;
        }

        @Override
        public String toString() {
            return "[GetTableExistsRequest:catalog=" + this.owner + ",owner=" + this.owner + ",tableName=" + this.tableName + "]";
        }
    }

    static class DisambiguateIdentifierRequest
    extends Request {
        IdentifierType type;
        String catalog;
        String schema;
        String name;
        String[] retcode;

        DisambiguateIdentifierRequest(IdentifierType identifierType, String string, String string2, String string3) {
            super(13);
            this.type = identifierType;
            this.catalog = string;
            this.schema = string2;
            this.name = string3;
            this.retcode = null;
        }

        @Override
        public String toString() {
            return "[DisambiguateIdentifierRequest:catalog=" + this.catalog + ",schema=" + this.schema + ",name=" + this.name + ",retcode=" + Arrays.toString(this.retcode) + "]";
        }
    }

    static class GetTableInfoRequest
    extends Request {
        String catalog;
        String owner;
        String tableName;
        TableInfo info;

        GetTableInfoRequest(String string, String string2, String string3) {
            super(10);
            this.catalog = string;
            this.owner = string2;
            this.tableName = string3;
        }

        @Override
        public String toString() {
            return "[GetTableInfoRequest:catalog=" + this.owner + "owner=" + this.owner + ",tableName=" + this.tableName + "]";
        }
    }

    static class GetServerNameRequest
    extends Request {
        String name = "";

        GetServerNameRequest() {
            super(9);
        }

        @Override
        public String toString() {
            return "[GetServerNameRequest]";
        }
    }

    static class SetCatalogRequest
    extends Request {
        String catalog;
        SQLException sqlException;

        SetCatalogRequest(String string) {
            super(19);
            this.catalog = string;
            this.sqlException = null;
        }

        @Override
        public String toString() {
            return "[SetCatalogRequest: catalog=" + this.catalog + "]";
        }
    }

    static class GetCatalogRequest
    extends Request {
        String name = null;

        GetCatalogRequest() {
            super(18);
        }

        @Override
        public String toString() {
            return "[GetCatalogRequest]";
        }
    }

    static class GetDatabaseNamesRequest
    extends Request {
        ArrayList<String> names = new ArrayList();

        GetDatabaseNamesRequest() {
            super(17);
        }

        @Override
        public String toString() {
            return "[GetDatabaseNamesRequest]";
        }
    }

    static class AddTableDataRequest
    extends Request {
        boolean ok;
        String catalog;
        String owner;
        String tableName;
        TableGenitor genitor;
        boolean ignoreErrors;
        Vector<String> errors;
        ImporterFailedException importerException = null;

        AddTableDataRequest(String string, String string2, String string3, TableGenitor tableGenitor) {
            super(8);
            this.catalog = string;
            this.tableName = string3;
            this.owner = string2;
            this.genitor = tableGenitor;
            this.ignoreErrors = false;
            this.errors = null;
            this.ok = false;
        }

        AddTableDataRequest(String string, String string2, String string3, TableGenitor tableGenitor, Vector<String> vector) {
            super(8);
            this.catalog = string;
            this.owner = string2;
            this.tableName = string3;
            this.genitor = tableGenitor;
            this.ignoreErrors = true;
            this.errors = vector;
            this.ok = false;
        }

        @Override
        public String toString() {
            return "[AddTableDataRequest:catalog=" + this.catalog + ",owner=" + this.owner + ",tableName=" + this.tableName + ",genitor=" + this.genitor + ",ignoreErrors=" + this.ignoreErrors + ",errors=" + this.errors + ",importerFailedExcepton=" + this.importerException + "]";
        }
    }

    static class ListProceduresRequest
    extends Request {
        String catalog;
        String schema;
        String pattern;
        ArrayList<String> owner;
        ArrayList<String> name;

        ListProceduresRequest(String string, String string2, String string3, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
            super(7);
            this.catalog = string;
            this.schema = string2;
            this.pattern = string3;
            this.name = arrayList2;
            this.owner = arrayList;
        }

        @Override
        public String toString() {
            return "[ListProceduresRequest:catalog=" + this.catalog + ",schema=" + this.schema + ",pattern=" + this.pattern + ",owner=" + this.owner + ",name=" + this.name + "]";
        }
    }

    static class ListTablesRequest
    extends Request {
        ArrayList<String> schemas;
        ArrayList<String> names;
        String catalog;
        String schema;
        String table;
        int options;

        ListTablesRequest(String string, String string2, String string3, int n, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
            super(6);
            this.catalog = string;
            this.schema = string2;
            this.table = string3;
            this.options = n;
            this.schemas = arrayList;
            this.names = arrayList2;
        }

        @Override
        public String toString() {
            return "[ListTablesRequest:catalog=" + this.catalog + ",schema=" + this.schema + ",table=" + this.table + ",options=" + this.options + ",schemas=" + this.schemas + ",names=" + this.names + "]";
        }
    }

    static class CreateTableRequest
    extends Request {
        String catalog;
        String owner;
        String tableName;
        TableGenitor genitor;
        SQLException sqlException;

        CreateTableRequest(String string, String string2, String string3, TableGenitor tableGenitor) {
            super(5);
            this.catalog = string;
            this.owner = string2;
            this.tableName = string3;
            this.genitor = tableGenitor;
            this.sqlException = null;
        }

        @Override
        public String toString() {
            return "[CreateTableRequest:catalog=" + this.catalog + ",owner=" + this.owner + ",tableName=" + this.tableName + ",genitor=" + this.genitor + "]";
        }
    }

    static class CheckSyntaxRequest
    extends ExecuteRequest {
        CheckSyntaxRequest(String string) {
            super(string, false, true, 0, null);
            this.type = 4;
        }

        @Override
        public String toString() {
            return "[CheckSyntaxRequest:sql=" + this.sql + ",error=" + this.error + ",errorMessage=" + this.errorMessage + "]";
        }
    }

    static class ExecuteRequest
    extends Request {
        String sql;
        SQLException error;
        SQLWarning warning;
        boolean containsODBCEscapeSequence;
        boolean disableBlocking;
        int cachingHint;
        ResultsProcessor resultsProcessor;
        boolean ok;

        ExecuteRequest(String string, boolean bl, boolean bl2, int n, ResultsProcessor resultsProcessor) {
            super(3);
            this.sql = string;
            this.warning = null;
            this.error = null;
            this.containsODBCEscapeSequence = bl;
            this.disableBlocking = bl2;
            this.cachingHint = n;
            this.resultsProcessor = resultsProcessor;
            this.ok = false;
        }

        @Override
        public String toString() {
            return "[ExecuteRequest:sql=" + this.sql + ",containsODBCEscapeSequence=" + this.containsODBCEscapeSequence + ",cachingHint=" + this.cachingHint + ",warning=" + this.warning + ",error=" + this.error + ",errorMessage=" + this.errorMessage + ",resultsProcessor=" + (this.resultsProcessor == null ? "null" : this.resultsProcessor.getClass().getName()) + "]";
        }
    }

    static class DescribeRequest
    extends ExecuteRequest {
        String catalog;
        String schema;
        String name;
        DescribeOption option;
        boolean ok;
        ResultsProcessor resultsProcessor;

        DescribeRequest(String string, String string2, String string3, DescribeOption describeOption, int n, ResultsProcessor resultsProcessor) {
            super(null, false, false, n, resultsProcessor);
            this.type = 20;
            this.catalog = string;
            this.schema = string2;
            this.name = string3;
            this.option = describeOption;
            this.resultsProcessor = resultsProcessor;
            this.ok = false;
        }

        @Override
        public String toString() {
            return "[DescribeRequest:catalog=" + (this.catalog == null ? "null" : "\"" + this.catalog + "\"") + ",schema=" + (this.schema == null ? "null" : "\"" + this.schema + "\"") + ",name=" + (this.name == null ? "null" : "\"" + this.name + "\"") + ",option=" + (Object)((Object)this.option) + ",resultsProcessor=" + (this.resultsProcessor == null ? "null" : Dbg.getSignature((Object)this.resultsProcessor)) + ",ok=" + this.ok + "]";
        }
    }

    static class ConnectRequest
    extends Request {
        Vector<String> warnings;
        Throwable ex;

        ConnectRequest(Vector<String> vector) {
            super(1);
            this.warnings = vector;
            this.ex = null;
        }

        @Override
        public String toString() {
            return "[ConnectRequest]";
        }
    }

    static class Request {
        int type;
        Throwable runtimeError;
        String errorMessage;

        Request(int n) {
            this.type = n;
            this.runtimeError = null;
            this.errorMessage = null;
        }

        public String toString() {
            return "[Request: type=" + ISQLConnectionImpl.getRequestName(this.type) + (this.runtimeError == null ? "" : ", runtimeError=" + this.runtimeError.getClass().getName()) + ", errorMessage=" + (this.errorMessage == null ? "" : this.errorMessage) + "]";
        }
    }

    static class ResultSetListItem {
        ISQLResultSet isqlResultSet;
        boolean isInternal;

        ResultSetListItem(ISQLResultSet iSQLResultSet, boolean bl) {
            this.isqlResultSet = iSQLResultSet;
            this.isInternal = bl;
        }
    }
}

