/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.ianywhere.errorreporting.ExceptionHandlerClient;
import com.sybase.util.ImageUtils;
import com.sybase.util.OEMSupport;
import ianywhere.updateService.ASAUpdateServiceClientFactory;
import ianywhere.updateService.UpdateServiceClient;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import javax.swing.JFrame;
import sybase.isql.ASAParser;
import sybase.isql.ASEParser;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLUpdateService;
import sybase.isql.Preferences;
import sybase.isql.isql;

class ISQLExceptionHandlerClient
implements ExceptionHandlerClient {
    ISQLExceptionHandlerClient() {
    }

    public boolean useGUI() {
        return isql.useGUI();
    }

    public void printApplicationInformation(PrintStream printStream) {
        printStream.println(this.getApplicationInformation());
    }

    public String getDefaultFileName() {
        return "isqlError";
    }

    public JFrame getParent() {
        return (JFrame)isql.getJFrame();
    }

    public String getDialogTitle() {
        return ISQLResource.getISQLResource(GeneralResources.getName()).getISQLString("ERROR_REPORTING_TITLE");
    }

    public String getContactInformation() {
        String string = "Please report this information to Sybase";
        return string;
    }

    public String getApplicationInformation() {
        ISQLConnection iSQLConnection;
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(ExceptionHandler.printBox((String)"ISQL", (int)80)).append("\n");
        stringBuffer.append(Calendar.getInstance().getTime()).append("\n");
        stringBuffer.append("ISQL version = ").append(Integer.toString(11)).append(".").append(Integer.toString(0)).append(".").append(Integer.toString(1)).append(", Build ").append(2630).append("\n");
        if (isql.options != null) {
            try {
                stringBuffer.append(isql.options.toString()).append("\n");
            }
            catch (Exception exception) {
                stringBuffer.append("Exception caught while gathering information about options").append("\n");
                stringBuffer.append(this.stackTraceToString(exception));
            }
        } else {
            stringBuffer.append("No information about options available").append("\n");
        }
        try {
            iSQLConnection = isql.getUIActiveConnection();
            if (iSQLConnection != null) {
                if (iSQLConnection.isConnected()) {
                    stringBuffer.append("ConnectionInfo for active connection: ").append(((ISQLConnectionImpl)iSQLConnection).getConnectionInfo()).append("\n");
                    stringBuffer.append("Connection name: ").append(iSQLConnection.getDescription()).append("\n");
                    if (iSQLConnection instanceof ISQLConnectionImpl) {
                        String string = ((ISQLConnectionImpl)iSQLConnection).getLastSQLStatement();
                        if (string == null) {
                            string = "(none)";
                        } else if (string.length() > 512) {
                            string = string.substring(0, 512) + "...";
                        }
                        stringBuffer.append("Last executed SQL statement: ").append(string).append("\n");
                    }
                } else {
                    stringBuffer.append("UI Active connection is disconnected").append("\n");
                }
            } else {
                stringBuffer.append("No current database connection").append("\n");
            }
        }
        catch (Exception exception) {
            stringBuffer.append("Exception caught while getting UI active connection").append("\n");
            stringBuffer.append(this.stackTraceToString(exception));
            iSQLConnection = null;
        }
        if (isql.currentlyExectuingStatments != null) {
            stringBuffer.append("Currently executing statements: ").append(isql.currentlyExectuingStatments).append("\n");
        } else {
            stringBuffer.append("Currently executing statements: (none)").append("\n");
        }
        try {
            iSQLConnection = isql.getUIActiveConnection();
            int n = iSQLConnection != null ? iSQLConnection.getDatabaseType() : (isql.options != null ? isql.options.getDefaultDatabaseType() : 0);
            switch (n) {
                case 1: {
                    stringBuffer.append("\n");
                    stringBuffer.append("Current parser state:").append("\n");
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    ASEParser.getCurrentParserState(new PrintStream(byteArrayOutputStream));
                    stringBuffer.append(byteArrayOutputStream.toString()).append("\n");
                    break;
                }
                default: {
                    stringBuffer.append("\n");
                    stringBuffer.append("Current parser state:").append("\n");
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    ASAParser.getCurrentParserState(new PrintStream(byteArrayOutputStream));
                    stringBuffer.append(byteArrayOutputStream.toString()).append("\n");
                    break;
                }
            }
        }
        catch (Exception exception) {
            stringBuffer.append("Exception caught while getting parser state").append("\n");
            stringBuffer.append(this.stackTraceToString(exception));
        }
        try {
            stringBuffer.append("Settings:\n ");
            stringBuffer.append("maximumDisplayedRows");
            stringBuffer.append("=");
            stringBuffer.append(Integer.toString(Preferences.getPluginIntPreference((ISQLConnectionImpl)iSQLConnection, "maximumDisplayedRows", "500")));
            stringBuffer.append("\n");
            stringBuffer.append("  ").append("showMultipleResultSets").append("=");
            stringBuffer.append(Preferences.getBooleanOption((ISQLConnectionImpl)iSQLConnection, "showMultipleResultSets"));
            stringBuffer.append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Preferences.fastLauncherEnabled) {
                stringBuffer.append("The fast launcher is running\n");
            } else {
                stringBuffer.append("The fast launcher is not running\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        isql.returnCode = 1;
        return stringBuffer.toString();
    }

    String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public String getVendorName() {
        return "iAnywhere";
    }

    public String getProductName() {
        return ISQLResource.getISQLResource(GeneralResources.getName()).getISQLString("ERROR_REPORTING_PRODUCT_NAME");
    }

    public String getApplicationName() {
        return "ISQL";
    }

    public int getApplicationVersionMajor() {
        return 11;
    }

    public int getApplicationVersionMinor() {
        return 0;
    }

    public int getApplicationVersionPatch() {
        return 1;
    }

    public int getApplicationVersionBuild() {
        return 2630;
    }

    public String getModuleName() {
        return "";
    }

    public int getModuleVersionMajor() {
        return 0;
    }

    public int getModuleVersionMinor() {
        return 0;
    }

    public int getModuleVersionPatch() {
        return 0;
    }

    public int getModuleVersionBuild() {
        return 0;
    }

    public Image getIconImage() {
        return ImageUtils.loadImage(this.getClass(), (String)"dbisql64.png");
    }

    public boolean showCheckForUpdates() {
        return OEMSupport.getOEMSupport().getCheckForUpdates();
    }

    public String getCheckForUpdatesURL() {
        UpdateServiceClient updateServiceClient = ASAUpdateServiceClientFactory.getInstance((String)ISQLUpdateService.APPLICATION_ID, (boolean)false);
        return updateServiceClient.getUpdateURL();
    }

    public boolean showErrorReporter() {
        return OEMSupport.getOEMSupport().getReportErrors();
    }

    public boolean showTechSupportLink() {
        return true;
    }

    public String getTechSupportURL() {
        return "http://www.ianywhere.com/support/sql_anywhere.html";
    }

    public String getErrorReportingServiceSubmissionURL() {
        return "http://www.ianywhere.com/projects/submission/sa_submission";
    }

    public String getErrorReportingServiceStatusURL() {
        return "http://www.ianywhere.com/projects/submission/sa_status";
    }

    public String getDataCollectionPolicyURL() {
        return null;
    }
}

