/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.OEMSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import sybase.isql.IO;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHost;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLPreference;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;
import sybase.isql.WindowManager;
import sybase.isql.isql;

class ISQLHostImpl
implements ISQLHost {
    private static ISQLHostImpl _impl = null;

    ISQLHostImpl() {
    }

    static ISQLHost getISQLHost() {
        if (_impl == null) {
            _impl = new ISQLHostImpl();
        }
        return _impl;
    }

    @Override
    public int[] getVersion() {
        return new int[]{11, 0, 1, 2630};
    }

    @Override
    public String getStringPreference(ISQLConnection iSQLConnection, String string, String string2) {
        if (string != null) {
            string2 = string + "." + string2;
        }
        String string3 = Preferences.getStringOption(iSQLConnection, string2);
        return string3;
    }

    @Override
    public ISQLPreference[] getSavedPluginPreferences(String string) {
        ISQLPreference[] iSQLPreferenceArray;
        Properties properties = Preferences.getPluginPreferences(string);
        String[] stringArray = Preferences.getLockedPluginPreferences(string);
        if (properties != null && properties.size() > 0) {
            iSQLPreferenceArray = new ISQLPreference[properties.size()];
            int n = 0;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                String string3 = properties.getProperty(string2);
                boolean bl = false;
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].equalsIgnoreCase(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                iSQLPreferenceArray[n++] = new ISQLPreferencesImpl(string2, string3, bl);
            }
        } else {
            iSQLPreferenceArray = null;
        }
        return iSQLPreferenceArray;
    }

    @Override
    public String[] getLockedPluginPreferences(String string) {
        String[] stringArray = Preferences.getLockedPluginPreferences(string);
        return stringArray;
    }

    @Override
    public String[] getOverriddenPluginPreferences(String string) {
        String[] stringArray = null;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("PluginID cannot be null or empty");
        }
        Properties properties = OEMSupport.getOEMSupport().getApplicationProperties("dbisql");
        if (properties != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3;
                String string4 = (String)enumeration.nextElement();
                int n = string4.indexOf(46);
                if (n == -1) {
                    string3 = null;
                    string2 = string4;
                } else {
                    string3 = string4.substring(0, n);
                    string2 = string4.substring(n + 1);
                }
                if (string2.equalsIgnoreCase("lockedPreferences") || string2.equalsIgnoreCase("disableExecuteAll") || string3 != null && !string3.equals("*") && !string3.equalsIgnoreCase(string)) continue;
                arrayList.add(string2);
                arrayList.add(properties.getProperty(string4));
            }
            if (arrayList.size() > 0) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            }
        }
        return stringArray;
    }

    @Override
    public void processAsynchronousMessage(ISQLConnection iSQLConnection, String string, ISQLHost.AsyncMsgType asyncMsgType) {
        if (iSQLConnection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        switch (asyncMsgType) {
            case MESSAGE: {
                isql.getIO(iSQLConnection).writeln(string, 3);
                break;
            }
            case DEFERRED_MESSAGE: {
                boolean bl = ((ISQLConnectionImpl)iSQLConnection).addLineToBufferedAsyncMessages(string);
                if (bl) break;
                isql.getIO(iSQLConnection).writeln(string, 3);
                break;
            }
            case PROMPT: {
                isql.getIO(iSQLConnection).writeln(string, 4);
            }
        }
    }

    @Override
    public void updateResultSetTableAppearance(ISQLPlugin iSQLPlugin) {
        if (isql.options.useGUI) {
            boolean bl = true;
            String[] stringArray = iSQLPlugin.getPreferenceValues(null, "showResultsWithGrids");
            if (stringArray != null && stringArray.length > 0 && stringArray[0] != null && stringArray[0].length() > 0) {
                bl = stringArray[0].equals("1");
            }
            Object[] objectArray = WindowManager.getParentFrames();
            for (int i = 0; i < objectArray.length; ++i) {
                ParentFrame parentFrame = (ParentFrame)objectArray[i];
                ISQLConnectionImpl iSQLConnectionImpl = (ISQLConnectionImpl)parentFrame.getConnection();
                if (iSQLConnectionImpl != null && iSQLConnectionImpl.getPlugin() != iSQLPlugin) continue;
                parentFrame.updateResultSetTableFont();
                parentFrame.setShowResultsAsText(!bl);
                parentFrame.updateResultSetTableTruncationLength();
            }
        }
    }

    @Override
    public IO getIO(ISQLConnection iSQLConnection) {
        if (iSQLConnection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        IO iO = isql.getIO(iSQLConnection);
        return iO;
    }

    @Override
    public IO getDefaultIO() {
        return isql.getDefaultIO();
    }

    private static class ISQLPreferencesImpl
    implements ISQLPreference {
        private String _name;
        private String _value;
        private boolean _locked;

        ISQLPreferencesImpl(String string, String string2, boolean bl) {
            this._name = string;
            this._value = string2;
            this._locked = bl;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public boolean isLocked() {
            return this._locked;
        }
    }
}

