/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.Launcher;
import com.sybase.util.Loader;
import com.sybase.util.Platform;
import com.sybase.util.win32.Win32Util;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import sybase.isql.ErrorMessages;
import sybase.isql.ISQLResource;
import sybase.isql.PluginMgr;
import sybase.isql.Preferences;

public class ISQLLoader {
    public static final String APP_NAME = "DBISQL";
    static final String ID = "DBISQL" + Integer.toString(11);
    private static final String MAIN_CLASS_NAME = "sybase.isql.isql";
    private static final String ALT_MAIN_CLASS_NAME = "sybase.isql.isql2";
    static String _applicationPath = null;

    static void startLauncher() {
        Launcher.startLauncher((String)APP_NAME, (int)Preferences.fastLauncherPort, (int)Preferences.fastLauncherTimeout, (String)ALT_MAIN_CLASS_NAME, (String)"dbisql.cls");
    }

    static String getApplicationPath() {
        File file;
        int n;
        String string = null;
        if (_applicationPath != null) {
            return _applicationPath;
        }
        String[] stringArray = new String[]{"dbisql.exe", "dbisql.com", "dbisql.bat", "dbisql.cmd", "dbisql"};
        if (Win32Util.isInstalled()) {
            string = Win32Util.getCurrentProcessFileName();
            boolean bl = true;
            String string2 = string.toLowerCase();
            for (n = 0; n < stringArray.length; ++n) {
                if (!string2.endsWith(stringArray[n])) continue;
                bl = false;
                break;
            }
            if (bl) {
                string = null;
            }
            if (!(string == null || (file = new File(string)).exists() && file.isFile())) {
                string = null;
            }
        }
        if (string == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(System.getProperty("user.dir"));
            StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.library.path"), File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            block2: for (n = 0; n < arrayList.size(); ++n) {
                String string3 = (String)arrayList.get(n);
                for (int i = 0; i < stringArray.length; ++i) {
                    file = new File(string3, stringArray[i]);
                    if (!file.exists() || !file.isFile()) continue;
                    string = file.getAbsolutePath();
                    break block2;
                }
            }
        }
        if (string == null) {
            string = "dbisql";
        }
        _applicationPath = string;
        return string;
    }

    private static boolean processInstallerOptions(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].equalsIgnoreCase("-XRegister")) {
                if (stringArray.length - i >= 4) {
                    String string2 = ISQLLoader.stripQuotes(stringArray[i + 1]);
                    string = ISQLLoader.stripQuotes(stringArray[i + 2]);
                    String string3 = ISQLLoader.stripQuotes(stringArray[i + 3]);
                    String string4 = ISQLLoader.stripQuotes(stringArray[i + 4]);
                    String string5 = stringArray.length - i - 1 >= 5 ? ISQLLoader.stripQuotes(stringArray[i + 5]) : null;
                    String string6 = stringArray.length - i - 1 >= 6 ? ISQLLoader.stripQuotes(stringArray[i + 6]) : null;
                    PluginMgr.register(string2, string, string3, string4, string5, string6);
                } else {
                    System.err.println("Error! Not enough parameters for " + stringArray[i]);
                }
                bl = true;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-XUnregister")) continue;
            if (stringArray.length - i >= 1) {
                string = stringArray[i + 1];
                PluginMgr.unregister(string);
            } else {
                System.err.println("Error! Not enough parameters for " + stringArray[i]);
            }
            bl = true;
        }
        return bl;
    }

    private static String stripQuotes(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        int n;
        String string;
        Object var3_1 = null;
        boolean bl = ISQLLoader.processInstallerOptions(stringArray);
        if (bl) {
            Loader.terminate((int)Preferences.fastLauncherPort);
            System.exit(0);
        }
        boolean bl2 = ISQLLoader.shouldRunInConsole(stringArray);
        if (!(Platform.isWindows() || Platform.isMacOS() || bl2 || (string = System.getenv("DISPLAY")) != null && string.length() != 0)) {
            System.err.println(ISQLResource.getISQLString(ErrorMessages.getName(), "DISPLAY_ENV_VAR_NOT_SET"));
            System.exit(1);
        }
        if (!Platform.isWindows() || bl2) {
            stringArray = ISQLLoader.addSQLConnectToArgs(stringArray);
            ISQLLoader.callISQLMethod(MAIN_CLASS_NAME, "main", new Class[]{String[].class}, new Object[]{stringArray});
            return;
        }
        String string2 = System.getProperty("sybase.native.executable");
        if (string2 != null && string2.length() > 4 && (n = string2.lastIndexOf(46)) != -1 && string2.regionMatches(true, n + 1, "com", 0, 3)) {
            string2 = string2.substring(0, n) + ".exe";
            String[] stringArray2 = new String[stringArray.length + 1];
            StringBuilder stringBuilder = new StringBuilder(string2.length() + 2);
            stringBuilder.append('\"');
            stringBuilder.append(string2);
            stringBuilder.append('\"');
            stringArray2[0] = stringBuilder.toString();
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            try {
                Runtime.getRuntime().exec(stringArray2);
                System.exit(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean bl3 = Loader.isForTerminate((String[])stringArray);
        Preferences.load(null);
        if (bl3) {
            Loader.terminate((int)Preferences.fastLauncherPort);
        } else {
            stringArray = ISQLLoader.addSQLConnectToArgs(stringArray);
            boolean bl4 = bl = Preferences.fastLauncherEnabled && Loader.launch((int)Preferences.fastLauncherPort, (String[])stringArray);
            if (!bl) {
                ISQLLoader.callISQLMethod(MAIN_CLASS_NAME, "main", new Class[]{String[].class}, new Object[]{stringArray});
                if (Preferences.fastLauncherEnabled) {
                    ISQLLoader.startLauncher();
                }
            }
        }
    }

    private static String[] addSQLConnectToArgs(String[] stringArray) {
        String string;
        String[] stringArray2;
        String string2 = System.getenv("SQLCONNECT");
        if (string2 == null) {
            string2 = System.getenv("sqlconnect");
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringArray2 = new String[stringArray.length + 2];
            System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
            stringArray2[0] = "-sqlconnect";
            stringArray2[1] = string2;
            stringArray = stringArray2;
        }
        if ((string = System.getenv("ULSQLCONNECT")) == null) {
            string = System.getenv("ulsqlconnect");
        }
        if (string != null && string.trim().length() > 0) {
            stringArray2 = new String[stringArray.length + 2];
            System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
            stringArray2[0] = "-ulsqlconnect";
            stringArray2[1] = string;
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private static boolean shouldRunInConsole(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            char c = stringArray[i].charAt(0);
            if (c == '-' || c == '/') {
                String string = stringArray[i].substring(1);
                if (string.equalsIgnoreCase("nogui") || string.equalsIgnoreCase("version") || string.equals("?")) {
                    bl = true;
                    break;
                }
                if (!string.equalsIgnoreCase("c") && !string.equalsIgnoreCase("dataSource") && !string.equalsIgnoreCase("f") && !string.equalsIgnoreCase("host") && !string.equalsIgnoreCase("locale") && !string.equalsIgnoreCase("port") && !string.equalsIgnoreCase("onerror") && !string.equalsIgnoreCase("sqlconnect") && !string.equalsIgnoreCase("ulsqlconnect")) continue;
                ++i;
                continue;
            }
            bl = true;
            break;
        }
        return bl;
    }

    private static Object callISQLMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        Object object = null;
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, classArray);
            object = method.invoke(clazz, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }
}

