/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.asa.QueryEditor.ASEQueryEditor;
import com.sybase.asa.QueryEditor.DefaultASEQueryModel;
import com.sybase.asa.QueryEditor.DefaultQueryModel;
import com.sybase.asa.QueryEditor.ParseException;
import com.sybase.asa.QueryEditor.QueryEditorDialog;
import com.sybase.asa.QueryEditor.QueryModel;
import com.sybase.asa.QueryEditor.TokenMgrError;
import com.sybase.central.editor.AsynchronousTaskListener;
import com.sybase.central.editor.Editor;
import com.sybase.central.editor.SCEditor;
import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizeDialog;
import com.sybase.customization.CustomizerHost;
import com.sybase.indexConsultant.IndexWizard;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.util.DialogUtils;
import com.sybase.util.ImageLoader;
import com.sybase.util.LabelBar;
import com.sybase.util.Platform;
import com.sybase.util.SCC;
import com.sybase.util.SCCCheckInDialog;
import com.sybase.util.SCCCheckOutDialog;
import com.sybase.util.SCCDiffDialog;
import com.sybase.util.SCCException;
import com.sybase.util.SCCGetDialog;
import com.sybase.util.SCCHistoryDialog;
import com.sybase.util.SCCUndoCheckoutDialog;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybTextArea;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.Connection;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import sybase.isql.EditorRowHeader;
import sybase.isql.EncodingDetector;
import sybase.isql.EncodingDialog;
import sybase.isql.ErrorMessages;
import sybase.isql.ExportWizard;
import sybase.isql.FrontEnd;
import sybase.isql.GeneralResources;
import sybase.isql.History;
import sybase.isql.HistoryItem;
import sybase.isql.HistoryListDialog;
import sybase.isql.IO;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLEvent;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLListener;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.InputOutputOptions;
import sybase.isql.InputStatementWizard;
import sybase.isql.LogFile;
import sybase.isql.MyJSplitPane;
import sybase.isql.OptionsPageController;
import sybase.isql.ParentFrame;
import sybase.isql.PlanFrame;
import sybase.isql.PluginMgr;
import sybase.isql.Preferences;
import sybase.isql.PrintingDialog;
import sybase.isql.ProcedureBrowser;
import sybase.isql.ResultsPanel;
import sybase.isql.RunScriptDialog;
import sybase.isql.SCCRunner;
import sybase.isql.SQLTextComponent;
import sybase.isql.TableBrowser;
import sybase.isql.WhatToPrintDialog;
import sybase.isql.WindowManager;
import sybase.isql.WriteEncodingDialog;
import sybase.isql.isql;

class ISQLPanel
extends JPanel
implements FocusListener,
KeyListener,
MouseListener,
CustomizerHost,
AsynchronousTaskListener,
DocumentListener {
    private static final int INPUT = 1;
    private static final int OUTPUT = 2;
    protected EventListenerList _listeners;
    private History _history = new History();
    private JPanel _sqlPanel;
    private ResultsPanel _resultPanel;
    private ISQLConnection _connection;
    private SQLTextComponent _sql;
    private EditorRowHeader _editorRowHeader;
    private LogFile _logFile = new LogFile();
    private boolean _interruptPending = false;
    private ParentFrame _parent = null;
    private LabelBar _sqlStatementsLabel = null;
    private QueryEditorDialog _queryEditorDialog = null;
    private boolean _printDialogIsOpen = false;
    private File _sqlSavedFileName = null;
    private long _sqlSavedFileNameTimestamp = 0L;
    private boolean _sqlSavedFileIsEditable = true;
    private String _sqlSavedFileEncoding = null;
    private boolean _sqlSavedFileIsModified = false;
    private String _planFileName = null;
    boolean inputStatementInProgress = false;
    boolean outputStatementInProgress = false;
    boolean interruptInputStatement = false;
    boolean interruptOutputStatement = false;
    private boolean _openDialogIsOpen = false;
    private boolean _enabled = true;
    private MyDocumentFilter _documentFilter = null;
    private static final int LEA_DEFAULT = 0;
    private static final int LEA_OPEN_FILE = 1;
    private static final int LEA_INSERT_FILE = 2;
    private int _lastEditorAction = 0;

    SQLTextComponent getTextComponent() {
        return this._sql;
    }

    LogFile getLogFile() {
        return this._logFile;
    }

    File getFileName() {
        File file = this._sqlSavedFileName != null ? this._sqlSavedFileName : (this._planFileName != null ? new File(this._planFileName) : null);
        return file;
    }

    boolean needsSaving() {
        boolean bl;
        boolean bl2 = bl = this._sql.isChanged() && this._sqlSavedFileName != null;
        if (bl && this._sqlSavedFileName == null && this._sql.getText().length() == 0) {
            bl = false;
        }
        return bl;
    }

    boolean needsReloading() {
        return this._sqlSavedFileName != null && this._sqlSavedFileNameTimestamp != this._sqlSavedFileName.lastModified();
    }

    void saveHistory() {
        this._history.save();
    }

    void release() {
        this._listeners = null;
        if (this._sqlStatementsLabel != null) {
            this._sqlStatementsLabel.removeMouseListener((MouseListener)this);
        }
        if (this._sql != null) {
            this._sql.removeAsynchronousTaskListener(this);
            this._sql.removeFocusListener(this);
        }
        if (this._history != null) {
            this._history.save();
            this._history = null;
        }
        if (this._queryEditorDialog != null) {
            this._queryEditorDialog.getQueryEditor().setCustomizerHost(null);
            this._queryEditorDialog.destroy();
            this._queryEditorDialog = null;
        }
        if (this._logFile != null) {
            if (this._logFile.isOpen()) {
                this.stopLogging();
            }
            this._logFile = null;
        }
        if (this._connection != null) {
            if (this._connection.isConnected()) {
                this._connection.disconnect();
            }
            if (this._connection instanceof ISQLConnectionImpl) {
                ((ISQLConnectionImpl)this._connection).setConnectionInfo(null, null);
            }
            this._connection = null;
        }
        this._sqlStatementsLabel = null;
        this._sqlPanel = null;
        if (this._resultPanel != null) {
            this._resultPanel.release();
            this._resultPanel = null;
        }
        if (this._editorRowHeader != null) {
            this._editorRowHeader.destroy();
            this._editorRowHeader = null;
        }
        if (this._sql != null) {
            this._sql.removeKeyListener(this);
            this._sql.setCustomizerHost(null);
            this._sql.release();
            this._sql = null;
        }
        DialogUtils.removeComponents((Container)this);
        this._parent = null;
    }

    void clear() {
        if (this._sql != null) {
            this._sql.setText("");
            this._sql.getDocument().removeDocumentListener(this);
        }
        this.clearResultsPanel();
    }

    void clearResultsPanel() {
        if (this._connection != null) {
            this._resultPanel.clear();
            this._connection.discardResultSets();
            if (this._connection.isConnected() && Preferences.getPluginBooleanPreference((ISQLConnectionImpl)this._connection, "autoReleaseLocks", "0")) {
                this._connection.releaseDatabaseLocks();
            }
        }
    }

    void setSQLStatementsText(String string) {
        if (this._sql != null) {
            this._sql.setText(string);
        }
    }

    void execute(String string) {
        if (this._connection != null) {
            this._sql.setText(string);
            this.handleExecuteClick();
        }
    }

    ISQLConnection getConnection() {
        return this._connection;
    }

    void discardConnection() {
        if (this._connection != null) {
            if (this._connection.isConnected()) {
                this._connection.disconnect();
            }
            this.notifyWindowTitleChange();
        }
    }

    private void makeSQLPanel() {
        this._sqlPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._sqlPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this._sqlStatementsLabel = new LabelBar(ISQLResource.getISQLString(GeneralResources.getName(), "SQL Statements"));
        this._sqlStatementsLabel.setActive(false);
        this._sqlStatementsLabel.addMouseListener((MouseListener)this);
        this._sqlPanel.add((Component)this._sqlStatementsLabel, gridBagConstraints);
        this._sql = SQLTextComponent.newInstance(6, 50);
        this._sql.getAccessibleContext().setAccessibleName(ISQLResource.getISQLString(GeneralResources.getName(), "SQL Statements"));
        this._sql.setCustomizerHost(this);
        this._sql.addKeyListener(this);
        this._sql.addAsynchronousTaskListener(this);
        this._documentFilter = new MyDocumentFilter();
        this._documentFilter.install();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._sql));
        this._editorRowHeader = new EditorRowHeader(this._sql);
        jScrollPane.setRowHeaderView(this._editorRowHeader);
        jScrollPane.setBorder(new BevelBorder(1));
        this._sql.addFocusListener(this);
        SybTextArea sybTextArea = new SybTextArea(6, 50);
        Dimension dimension = sybTextArea.getPreferredSize();
        Dimension dimension2 = jScrollPane.getSize();
        dimension2.height = Math.max(dimension2.height, dimension.height);
        jScrollPane.setPreferredSize(dimension2);
        this._sqlPanel.add((Component)jScrollPane, gridBagConstraints);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this._sqlStatementsLabel.setActive(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this._sqlStatementsLabel.setActive(false);
        }
    }

    ISQLPanel(ParentFrame parentFrame, ISQLConnection iSQLConnection) {
        this._parent = parentFrame;
        this.setConnection(iSQLConnection);
        this.makeSQLPanel();
        this._resultPanel = new ResultsPanel(parentFrame, iSQLConnection);
        MyJSplitPane myJSplitPane = new MyJSplitPane(0, this._sqlPanel, this._resultPanel);
        myJSplitPane.setOneTouchExpandable(true);
        if (Platform.isWindows()) {
            myJSplitPane.setDividerSize(myJSplitPane.getDividerSize() + 2);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(119, 0);
        InputMap inputMap = myJSplitPane.getInputMap(1);
        inputMap = inputMap.getParent();
        inputMap.remove(keyStroke);
        this.setLayout(new BorderLayout());
        this.add(myJSplitPane);
        this._history.load();
    }

    double getSplitBarPosition() {
        JSplitPane jSplitPane;
        double d = -1.0;
        if (this._sql != null && (jSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, (Component)((Object)this._sql))) != null && (d = (double)jSplitPane.getDividerLocation()) != -1.0) {
            d = d * 100.0 / (double)(jSplitPane.getHeight() - jSplitPane.getDividerSize());
        }
        return d;
    }

    void setSplitBarPosition(double d) {
        JSplitPane jSplitPane;
        if (this._sql != null && d != -1.0 && (jSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, (Component)((Object)this._sql))) != null) {
            jSplitPane.setDividerLocation(d / 100.0);
        }
    }

    void setConnection(ISQLConnection iSQLConnection) {
        if (iSQLConnection != this._connection) {
            String string;
            if (this._connection != null && this._connection.isConnected()) {
                this._connection.disconnect();
            }
            this._connection = iSQLConnection;
            if (iSQLConnection.isConnected() && (string = Preferences.getStringOption(this._connection, "isql_log")) != null && string.length() != 0) {
                this.startLogging(string);
            }
            if (this._resultPanel != null) {
                this._resultPanel.setConnection(iSQLConnection);
            }
            this.notifyWindowTitleChange();
        }
    }

    private void handleUndo() {
        this._sql.undo();
    }

    private void handleRedo() {
        this._sql.redo();
    }

    private void handleCut() {
        if (this.shouldEnableMenu("Cut")) {
            this._sql.cut();
        }
    }

    private void handleCopy() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (component == null) {
            Toolkit.getDefaultToolkit().beep();
        } else if (component instanceof JRootPane) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ISQLPanel.this.deferredHandleCopy();
                }
            });
        } else {
            this.deferredHandleCopy();
        }
    }

    private void deferredHandleCopy() {
        ActionMap actionMap;
        Action action;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (component == null) {
            Toolkit.getDefaultToolkit().beep();
        } else if (component == this._sql) {
            if (this.shouldEnableMenu("Copy")) {
                this._sql.copy();
            }
        } else if (component instanceof NullAwareTable) {
            NullAwareTable nullAwareTable = (NullAwareTable)component;
            if (nullAwareTable.getSelectedRow() != -1) {
                nullAwareTable.copy();
            }
        } else if (component instanceof JComponent && (action = (actionMap = ((JComponent)component).getActionMap()).get("copy")) != null && action.isEnabled()) {
            String string = (String)action.getValue("ActionCommandKey");
            ActionEvent actionEvent = new ActionEvent(component, 1001, string);
            action.actionPerformed(actionEvent);
        }
    }

    private JFrame getJFrame() {
        JFrame jFrame = null;
        Container container = this;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof JFrame)) continue;
            jFrame = (JFrame)container;
            break;
        }
        return jFrame;
    }

    private void handleInsertFile() {
        block13: {
            EncodingDetector encodingDetector;
            FileInputStream fileInputStream = null;
            String string = null;
            if (this._openDialogIsOpen) {
                return;
            }
            this._openDialogIsOpen = true;
            File file = this.promptForOpenFileName();
            if (file != null && !(encodingDetector = new EncodingDetector(file)).isDefinitelyUsingDefaultEncoding()) {
                String string2 = Preferences.getStringOption(this._connection, "defaultISQLEncoding");
                string = EncodingDialog.create(this._parent, ISQLResource.getFormattedString(GeneralResources.getName(), "InsertFileWithFileName", file.getName()), file, encodingDetector.getEncoding(), string2);
                if (string != null && string.length() == 0) {
                    file = null;
                }
            }
            if (file != null) {
                long l = this.getFileLengthInCharacters(file, string);
                if (l > Integer.MAX_VALUE) {
                    l = Integer.MAX_VALUE;
                }
                final JProgressBar jProgressBar = new JProgressBar(0, 0, (int)l);
                this._parent.showProgressBar(jProgressBar, ISQLResource.getFormattedString(GeneralResources.getName(), "Loading {0}", file.getName()), ImageLoader.getImageIcon(ImageLoader.class, (String)"save16.gif", (int)1006));
                try {
                    fileInputStream = new FileInputStream(file);
                    Reader reader = string == null ? new BufferedReader(new InputStreamReader(fileInputStream)) : new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string));
                    if (string != null && (string.equalsIgnoreCase("utf8") || string.equalsIgnoreCase("utf-8"))) {
                        reader = new PushbackReader(reader);
                        try {
                            int n = reader.read();
                            if (n != 65279) {
                                ((PushbackReader)reader).unread(n);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    final FileInputStream fileInputStream2 = fileInputStream;
                    BoundedRangeModel boundedRangeModel = jProgressBar.getModel();
                    boundedRangeModel.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                            if (boundedRangeModel.getValue() == boundedRangeModel.getMaximum()) {
                                boundedRangeModel.removeChangeListener(this);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ISQLPanel.this._lastEditorAction = 0;
                                        ISQLPanel.this._parent.hideProgressBar(jProgressBar, null, null);
                                        ISQLPanel.this._sql.requestFocus();
                                        if (fileInputStream2 != null) {
                                            try {
                                                fileInputStream2.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                    this._lastEditorAction = 2;
                    this._sql.insert(reader, this._sql.getCaretPosition(), boundedRangeModel);
                    Preferences.setStringOption(this._connection, "lastFileOpenFolder", file.getParent());
                }
                catch (IOException iOException) {
                    this._parent.hideProgressBar(jProgressBar, null, null);
                    String string3 = ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not insert file.\n{0}", iOException.getMessage());
                    isql.getIO(this._connection).writeln(string3, 2);
                    if (fileInputStream == null) break block13;
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
        }
        this._openDialogIsOpen = false;
    }

    private void handlePaste() {
        if (this.shouldEnableMenu("Paste")) {
            this._sql.paste();
        }
    }

    private void handleDelete() {
        if (this.shouldEnableMenu("Delete")) {
            if (this._sqlStatementsLabel.isActive()) {
                this._sql.replaceSelection("");
            } else {
                this._resultPanel.deleteSelectedRows();
            }
        }
    }

    private void handleClearSQL() {
        if (this.shouldEnableMenu("Clear SQL")) {
            this.clear();
            this._sql.requestFocus();
        }
    }

    private File promptForOpenFileName() {
        File file = null;
        SybFileChooser sybFileChooser = new SybFileChooser(17);
        SybFileFilter sybFileFilter = new SybFileFilter("sql", ISQLResource.getISQLString(GeneralResources.getName(), "SQL Statements (*.{0})"), null);
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[]{sybFileFilter, SybFileFilter.getAllFilesFilter()};
        sybFileChooser.setFilters(sybFileFilterArray, 0);
        file = this.getInitialBrowserDirectory("lastFileOpenFolder", null);
        File file2 = sybFileChooser.showDialog((Window)this._parent, file, null) ? sybFileChooser.getSelectedFile() : null;
        return file2;
    }

    private File getInitialBrowserDirectory(String string, String string2) {
        return ISQLPanel.getInitialBrowserDirectory(this._connection, string, string2);
    }

    static File getInitialBrowserDirectory(ISQLConnection iSQLConnection, String string, String string2) {
        if (!Preferences.getBooleanOption(iSQLConnection, "setInitialFolderForFileBrowsers")) {
            return null;
        }
        String string3 = Preferences.getStringOption(iSQLConnection, string);
        if (string3 == null || string3.length() == 0 || !new File(string3).exists()) {
            if (string2 != null) {
                string3 = Preferences.getStringOption(iSQLConnection, string2);
                if (string3 == null || string3.length() == 0 || !new File(string3).exists()) {
                    string3 = System.getProperty("user.dir");
                }
            } else {
                string3 = System.getProperty("user.dir");
            }
        }
        return new File(string3);
    }

    private static String unescapeForXML(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                if (string.regionMatches(true, i + 1, "lt;", 0, 3)) {
                    stringBuffer.append('<');
                    i += 3;
                    continue;
                }
                if (string.regionMatches(true, i + 1, "gt;", 0, 3)) {
                    stringBuffer.append('>');
                    i += 3;
                    continue;
                }
                if (string.regionMatches(true, i + 1, "amp;", 0, 3)) {
                    stringBuffer.append('&');
                    i += 4;
                    continue;
                }
                if (string.regionMatches(true, i + 1, "apos;", 0, 3)) {
                    stringBuffer.append('\'');
                    i += 5;
                    continue;
                }
                if (string.regionMatches(true, i + 1, "quot;", 0, 3)) {
                    stringBuffer.append('\"');
                    i += 5;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean load(File file) {
        boolean bl;
        EncodingDetector encodingDetector;
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(n + 1);
            ISQLPlugin[] iSQLPluginArray = PluginMgr.getPluginList();
            for (int i = 0; i < iSQLPluginArray.length; ++i) {
                String string3;
                if (!iSQLPluginArray[i].supportsPlanViewer() || (string3 = iSQLPluginArray[i].getPlanFileExtension()) == null || !string3.equalsIgnoreCase(string2) && !string2.equalsIgnoreCase("xml")) continue;
                PlanFrame planFrame = new PlanFrame(this._parent, PlanFrame.getPluginForPlanViewing((ISQLConnectionImpl)this._connection), "");
                return planFrame.loadPlan(file);
            }
        }
        if (!(encodingDetector = new EncodingDetector(file)).isDefinitelyUsingDefaultEncoding()) {
            String string4 = Preferences.getStringOption(this._connection, "defaultISQLEncoding");
            string = EncodingDialog.create(this._parent, ISQLResource.getFormattedString(GeneralResources.getName(), "OpenFileWithFileName", file.getName()), file, encodingDetector.getEncoding(), string4);
            if (string != null && string.length() == 0) {
                return false;
            }
        }
        if (!(bl = this.canLoadQuery())) return bl;
        bl = this.loadSQL(file, string);
        if (!bl) return bl;
        this.updateSourceControlIndicator(file);
        return bl;
    }

    void updateSourceControlIndicator() {
        if (this._sqlSavedFileName != null) {
            this.updateSourceControlIndicator(this._sqlSavedFileName);
        }
    }

    private void updateSourceControlIndicator(File file) {
        int n = 0;
        if (file == null) {
            this._parent.updateSourceControlIndicator(n);
            return;
        }
        int n2 = this.getSCCFileStatus(file);
        if (n2 == 0) {
            n = 0;
        } else if (n2 != -1 && (n2 & 0x40) == 0) {
            n = (n2 & 2) != 0 ? 2 : 1;
        }
        this._parent.updateSourceControlIndicator(n);
    }

    private int getSCCFileStatus(File file) {
        int n;
        block3: {
            n = 0;
            SCC sCC = WindowManager.getWindowManager().getSCC();
            if (sCC != null) {
                try {
                    int[] nArray = sCC.getStatus(new String[]{file.getAbsolutePath()});
                    n = nArray[0];
                }
                catch (SCCException sCCException) {
                    if (sCCException.getErrorCode() != -14) break block3;
                    n = !file.canWrite() ? 1 : -1;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFileLengthInCharacters(File file, String string) {
        long l;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = string == null ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            l = bufferedReader.skip(Integer.MAX_VALUE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            l = 0L;
        }
        catch (IOException iOException) {
            l = 0L;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return l;
    }

    public void loadFailed(Throwable throwable, Editor editor) {
        String string;
        if (this._lastEditorAction == 2) {
            string = ISQLResource.getISQLString(ErrorMessages.getName(), "NotEnoughMemoryToInsertFile");
        } else if (this._lastEditorAction == 1) {
            string = ISQLResource.getFormattedString(ErrorMessages.getName(), "NotEnoughMemoryToOpenFile", this._sqlSavedFileName.getName());
            this.handleNew();
        } else {
            string = ISQLResource.getISQLString(ErrorMessages.getName(), "NotEnoughMemoryToAddText");
        }
        isql.getDefaultIO().writeln(string, 2);
    }

    private boolean loadSQL(File file, String string) {
        boolean bl;
        this._resultPanel.clear();
        try {
            Reader reader = string == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), string);
            if (string != null && (string.equalsIgnoreCase("utf8") || string.equalsIgnoreCase("utf-8"))) {
                reader = new PushbackReader(reader);
                try {
                    int n = reader.read();
                    if (n != 65279) {
                        ((PushbackReader)reader).unread(n);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._sqlSavedFileName = file;
            this._lastEditorAction = 1;
            this._sql.reload(reader, 0);
            this._sql.getDocument().addDocumentListener(this);
            this._documentFilter.install();
            this._lastEditorAction = 0;
            this._sql.setChanged(false);
            this._sql.requestFocusInWindow();
            this._sqlSavedFileNameTimestamp = file.lastModified();
            this._sqlSavedFileEncoding = string;
            this._sqlSavedFileIsEditable = file.canWrite();
            this._sqlSavedFileIsModified = false;
            this._planFileName = null;
            this._parent.setWindowTitle();
            bl = true;
        }
        catch (IOException iOException) {
            String string2 = ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not load query. {0}", iOException.getMessage());
            isql.getIO(this._connection).writeln(string2, 2);
            bl = false;
        }
        return bl;
    }

    private boolean canSQLBeEncoded(String string) {
        boolean bl = true;
        try {
            int n;
            Charset charset = string == null ? Charset.defaultCharset() : Charset.forName(string);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            Document document = this._sql.getDocument();
            int n2 = document.getLength();
            for (int i = 0; i < n2; i += n) {
                n = Math.min(4096, n2 - i);
                String string2 = document.getText(i, n);
                if (charsetEncoder.canEncode(string2)) continue;
                bl = false;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveQueryToSQLFile(File file, String string) {
        boolean bl;
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = string == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, string);
            this._sql.write(outputStreamWriter);
            this._sql.setChanged(false);
            this._sqlSavedFileIsModified = false;
            this._sqlSavedFileIsEditable = true;
            this._sqlSavedFileNameTimestamp = file.lastModified();
            if (!file.equals(this._sqlSavedFileName)) {
                this._sqlSavedFileName = file;
            }
            this.fireUpdateWindowTitleEvent();
            Preferences.setStringOption(null, "lastFileSaveFolder", file.getParent());
            Preferences.getMRUList().addSavedFile(file);
            bl = true;
        }
        catch (IOException iOException) {
            String string2 = ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not save query.\n{0}", iOException.getMessage());
            isql.getIO(this._connection).writeln(string2, 2);
            bl = false;
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    boolean canLoadQuery() {
        int n;
        if (this.needsSaving()) {
            ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
            String string = this._sqlSavedFileName != null ? iSQLResource.getFormattedString("Do you want to save the changes you made to {0}?", this._sqlSavedFileName.getName()) : iSQLResource.getISQLString("Do you want to save your changes?");
            while ((n = SybOptionPane.showConfirmDialog((Component)this, (Object)string, (String)iSQLResource.getISQLString("Open"), (int)1)) == 0) {
                boolean bl;
                if (this._sqlSavedFileName != null) {
                    this.saveQueryToSQLFile(this._sqlSavedFileName, this._sqlSavedFileEncoding);
                    bl = true;
                } else {
                    bl = this.handleSaveQuery();
                }
                if (!bl) continue;
            }
            if (n != 2) {
                this._sql.setChanged(false);
            }
        } else {
            n = 1;
        }
        return n != 2;
    }

    private void handleOpen() {
        boolean bl;
        if (this._openDialogIsOpen) {
            return;
        }
        if (!this.canLoadQuery()) {
            return;
        }
        this._openDialogIsOpen = true;
        File file = this.promptForOpenFileName();
        if (file != null && file.exists() && (bl = this.load(file))) {
            Preferences.setStringOption(this._connection, "lastFileOpenFolder", file.getParent());
            Preferences.getMRUList().addOpenedFile(file);
        }
        this._openDialogIsOpen = false;
    }

    private void handleNew() {
        if (!this.shouldEnableMenu("New")) {
            return;
        }
        if (this.canLoadQuery()) {
            this._sql.getDocument().removeDocumentListener(this);
            this.clear();
            if (this._sqlSavedFileName != null) {
                this._sqlSavedFileName = null;
                this._sqlSavedFileIsEditable = true;
                this._sqlSavedFileNameTimestamp = 0L;
            }
            this._planFileName = null;
            this.fireUpdateWindowTitleEvent();
            this.updateSourceControlIndicator(null);
            this._sql.setEditable(true);
        }
    }

    private void handlePrint() {
        if (!this._printDialogIsOpen) {
            this._printDialogIsOpen = true;
            WhatToPrintDialog.Result result = this._sqlStatementsLabel.isActive() ? WhatToPrintDialog.Result.SQL_STATEMENTS : WhatToPrintDialog.Result.RESULT_SETS;
            Object object = WhatToPrintDialog.open(this._parent, this._connection.getResultSetCount(), result);
            if (object instanceof WhatToPrintDialog.Result) {
                switch ((WhatToPrintDialog.Result)((Object)object)) {
                    case SQL_STATEMENTS: {
                        PrintingDialog.create(this._parent, this._parent.getTitle(), (SCEditor)this._sql);
                    }
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    this._resultPanel.printResultSet(nArray[i], i == 0);
                }
            }
            this._printDialogIsOpen = false;
        }
    }

    private boolean handleSaveQuery() {
        File file;
        boolean bl = false;
        SybFileChooser sybFileChooser = new SybFileChooser(18);
        SybFileFilter sybFileFilter = new SybFileFilter("sql", ISQLResource.getISQLString(GeneralResources.getName(), "SQL Statements (*.{0})"), null);
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[]{sybFileFilter, SybFileFilter.getAllFilesFilter()};
        int n = 0;
        sybFileChooser.setFilters(sybFileFilterArray, n);
        sybFileChooser.setDefaultExtension("sql");
        File file2 = this.getInitialBrowserDirectory("lastFileSaveFolder", null);
        File file3 = this._sqlSavedFileName;
        if (sybFileChooser.showDialog((Window)this._parent, file2, file3) && this.setOutputFileEncoding((file = sybFileChooser.getSelectedFile()).getName())) {
            Preferences.setStringOption(null, "lastFileSaveFolder", file.getParent());
            this.saveQueryToSQLFile(file, this._sqlSavedFileEncoding);
            bl = true;
        }
        return bl;
    }

    private boolean setOutputFileEncoding(String string) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = ISQLResource.getISQLString(GeneralResources.getName(), "Save Query");
        while (true) {
            String string4;
            int n;
            if (!(bl = this.canSQLBeEncoded(string2)) && bl2 && (n = SybOptionPane.showConfirmDialog((Component)this._parent, (Object)(string4 = ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_ENCODING_WILL_CORRUPT_DATA", string2)), (String)string3, (int)0, (int)2)) == 0) {
                bl = true;
            }
            if (bl) {
                this._sqlSavedFileEncoding = string2;
                break;
            }
            WriteEncodingDialog writeEncodingDialog = new WriteEncodingDialog(this._parent, string3, string2);
            bl = writeEncodingDialog.promptForEncoding();
            if (bl) {
                string2 = writeEncodingDialog.getEncoding();
            }
            writeEncodingDialog.destroy();
            if (!bl) break;
            bl2 = true;
        }
        return bl;
    }

    private void addFiltersForImporting(SybFileChooser sybFileChooser, int n) {
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[]{new SybFileFilter(new String[]{"csv", "txt"}, iSQLResource.getISQLString("ASCII/Fixed (*.{0})"), (Object)11), new SybFileFilter("*", iSQLResource.getISQLString("All Files (*.{0})"), (Object)0)};
        int n2 = 0;
        for (int i = 0; i < sybFileFilterArray.length; ++i) {
            if ((Integer)sybFileFilterArray[i].getUserData() != n) continue;
            n2 = i;
            break;
        }
        sybFileChooser.setFilters(sybFileFilterArray, n2);
    }

    private void handleSaveResults() {
        if (this._connection == null || !isql.ensureConnected(this._connection)) {
            return;
        }
        ExportWizard.create(this._parent, (ISQLConnectionImpl)this._connection);
    }

    private void handleRunScript() {
        String string = null;
        File file = this.promptForOpenFileName();
        if (file != null) {
            EncodingDetector encodingDetector = new EncodingDetector(file);
            if (!encodingDetector.isDefinitelyUsingDefaultEncoding()) {
                String string2 = Preferences.getStringOption(this._connection, "defaultISQLEncoding");
                string = EncodingDialog.create(this._parent, ISQLResource.getFormattedString(GeneralResources.getName(), "RunScriptWithFileName", file.getName()), file, encodingDetector.getEncoding(), string2);
                if (string != null && string.length() == 0) {
                    return;
                }
            }
            RunScriptDialog.create(this._parent, this._parent.getConnection(), file, string, false);
            Preferences.setStringOption(this._connection, "lastFileOpenFolder", file.getParent());
        }
    }

    private void handleImport() {
        if (this._connection == null || !isql.ensureConnected(this._connection)) {
            return;
        }
        InputOutputOptions inputOutputOptions = new InputOutputOptions(this._connection);
        boolean bl = InputStatementWizard.create(this._parent, this._connection, inputOutputOptions);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("SELECT * FROM ");
            stringBuilder.append(inputOutputOptions.getQuotedOwnerAndTableName(this._connection));
            this._resultPanel.refresh((ISQLConnectionImpl)this._connection, stringBuilder.toString(), 0, true);
        }
    }

    void enablePanel() {
        this._enabled = true;
    }

    void disablePanel() {
        this._enabled = false;
    }

    void processMenu(String string) {
        if (!this.isEnabled() && !string.equals("Stop")) {
            return;
        }
        if (string.equals("Stop")) {
            this.stopTheCurrentCommand();
        } else if (string.equals("Execute")) {
            this.handleExecuteClick();
        } else if (string.equals("Execute Selection")) {
            this.handleExecuteSelectionClick();
        } else if (string.equals("SINGLE_STEP")) {
            this.handleSingleStep();
        } else if (string.equals("OPEN_PLAN_VIEWER")) {
            this.handleOpenPlanViewer();
        } else if (string.equals("Previous SQL")) {
            this.handlePreviousSQLClick();
        } else if (string.equals("History")) {
            this.handleSQLHistoryClick();
        } else if (string.equals("Next SQL")) {
            this.handleNextSQLClick();
        } else if (string.equals("Undo")) {
            this.handleUndo();
        } else if (string.equals("Redo")) {
            this.handleRedo();
        } else if (string.equals("Cut")) {
            this.handleCut();
        } else if (string.equals("Copy")) {
            this.handleCopy();
        } else if (string.equals("Paste")) {
            this.handlePaste();
        } else if (string.equals("INDENT_TEXT_LEFT")) {
            this._sql.indentText(false);
        } else if (string.equals("INDENT_TEXT_RIGHT")) {
            this._sql.indentText(true);
        } else if (string.equals("ADD_REMOVE_DASH_UNCOMMENT")) {
            this._sql.addRemoveComment("--");
        } else if (string.equals("ADD_REMOVE_SLASH_UNCOMMENT")) {
            this._sql.addRemoveComment("//");
        } else if (string.equals("Insert File...")) {
            this.handleInsertFile();
        } else if (string.equals("Delete")) {
            this.handleDelete();
        } else if (string.equals("Clear SQL")) {
            this.handleClearSQL();
        } else if (string.equals("Save")) {
            if (this._sqlSavedFileName == null) {
                this.handleSaveQuery();
            } else if (this._sqlSavedFileIsEditable) {
                this.saveQueryToSQLFile(this._sqlSavedFileName, this._sqlSavedFileEncoding);
            } else {
                this.handleSaveQuery();
            }
        } else if (string.equals("Save As...")) {
            this.handleSaveQuery();
        } else if (string.equals("PRINT_QUERY")) {
            this.handlePrint();
        } else if (string.equals("Open...")) {
            this.handleOpen();
        } else if (string.equals("Export...")) {
            this.handleSaveResults();
        } else if (string.equals("Connect")) {
            this.handleConnect();
        } else if (string.equals("SelectAll")) {
            this.handleSelectAll();
        } else if (string.equals("SELECT_LINE")) {
            this.handleSelectLine();
        } else if (string.equals("SELECT_STATEMENT")) {
            this.handleSelectStatement();
        } else if (string.equals("SELECT_NEXT_STATEMENT")) {
            this.handleSelectNextStatement();
        } else if (string.equals("SELECT_PREV_STATEMENT")) {
            this.handleSelectPreviousStatement();
        } else if (string.equals("FindReplace")) {
            this.handleFindReplace();
        } else if (string.equals("FindNext")) {
            this.handleFindNext();
        } else if (string.equals("GoToLine")) {
            this.handleGoToLine();
        } else if (string.equals("New")) {
            this.handleNew();
        } else if (string.equals("Options...")) {
            isql.openPreferencesDialog(this._connection);
        } else if (string.equals("SCCGet")) {
            this.handleSCCGet();
        } else if (string.equals("SCCCheckOut")) {
            this.handleSCCCheckOut();
        } else if (string.equals("SCCCheckIn")) {
            if (!this.needsSaving() || this._sqlSavedFileName != null && this.saveQueryToSQLFile(this._sqlSavedFileName, this._sqlSavedFileEncoding)) {
                this.handleSCCCheckIn();
            }
        } else if (string.equals("SCCUndoCheckout")) {
            this.handleSCCUndoCheckout();
        } else if (string.equals("SCCDiff")) {
            this.handleSCCDiff();
        } else if (string.equals("SCCHistory")) {
            this.handleSCCHistory();
        } else if (string.equals("SCCProperties")) {
            this.handleSCCProperties();
        } else if (string.equals("SCCRun")) {
            this.handleSCCRun();
        } else if (string.equals("SCCOpen")) {
            this.handleSCCOpen();
        } else if (this._connection != null) {
            if (string.equals("Run Script...")) {
                this.handleRunScript();
            } else if (string.equals("Import...")) {
                this.handleImport();
            } else if (string.equals("Lookup Table Name")) {
                this.handleLookupTable();
            } else if (string.equals("Lookup Procedure Name")) {
                this.handleLookupProcedure();
            } else if (string.equals("IndexConsultant")) {
                this.handleIndexWizard();
            } else if (string.equals("Start Logging...")) {
                this.handleStartLogging();
            } else if (string.equals("Stop Logging")) {
                this.stopLogging();
            } else if (string.equals("Disconnect")) {
                this.handleDisconnect();
            } else if (string.equals("Edit Query")) {
                this.editQuery();
            }
        }
        this._interruptPending = false;
    }

    private void handleSCCGet() {
        boolean bl;
        SCC sCC = WindowManager.getWindowManager().getSCC();
        if (sCC != null && (bl = SCCGetDialog.create((JFrame)this._parent, (SCC)sCC, (File)this._sqlSavedFileName))) {
            this._sql.setEditable(this._sqlSavedFileName.canWrite());
            this.loadSQL(this._sqlSavedFileName, this._sqlSavedFileEncoding);
            this.updateSourceControlIndicator(this._sqlSavedFileName);
            this.fireUpdateWindowTitleEvent();
        }
    }

    private void handleSCCCheckOut() {
        boolean bl;
        SCC sCC = WindowManager.getWindowManager().getSCC();
        if (sCC != null && (bl = SCCCheckOutDialog.create((JFrame)this._parent, (SCC)sCC, (File)this._sqlSavedFileName))) {
            this._sqlSavedFileIsEditable = this._sqlSavedFileName.canWrite();
            this._sql.setEditable(this._sqlSavedFileIsEditable);
            this.updateSourceControlIndicator(this._sqlSavedFileName);
            this.fireUpdateWindowTitleEvent();
        }
    }

    private void handleSCCCheckIn() {
        boolean bl;
        SCC sCC = WindowManager.getWindowManager().getSCC();
        if (sCC != null && (bl = SCCCheckInDialog.create((JFrame)this._parent, (SCC)sCC, (File)this._sqlSavedFileName))) {
            this._sqlSavedFileIsEditable = this._sqlSavedFileName.canWrite();
            this._sql.setEditable(this._sqlSavedFileIsEditable);
            this.updateSourceControlIndicator(this._sqlSavedFileName);
            this.fireUpdateWindowTitleEvent();
        }
    }

    private void handleSCCUndoCheckout() {
        boolean bl;
        SCC sCC = WindowManager.getWindowManager().getSCC();
        if (sCC != null && (bl = SCCUndoCheckoutDialog.create((JFrame)this._parent, (SCC)sCC, (File)this._sqlSavedFileName))) {
            this._sqlSavedFileIsEditable = this._sqlSavedFileName.canWrite();
            this._sql.setEditable(this._sqlSavedFileIsEditable);
            this.loadSQL(this._sqlSavedFileName, this._sqlSavedFileEncoding);
            this.updateSourceControlIndicator(this._sqlSavedFileName);
        }
    }

    private void handleSCCDiff() {
        SCC sCC;
        if (this.needsSaving()) {
            ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
            int n = SybOptionPane.showConfirmDialog((Component)this, (Object)iSQLResource.getISQLString("SaveChangesBeforeDIFF"), (String)iSQLResource.getISQLString("CompareVersions"), (int)1);
            if (n == 0) {
                this.saveQueryToSQLFile(this._sqlSavedFileName, this._sqlSavedFileEncoding);
            } else if (n == 2) {
                return;
            }
        }
        if ((sCC = WindowManager.getWindowManager().getSCC()) != null) {
            SCCDiffDialog.create((JFrame)this._parent, (SCC)sCC, (File)this._sqlSavedFileName);
        }
    }

    private void handleSCCHistory() {
        SCC sCC = WindowManager.getWindowManager().getSCC();
        if (sCC != null) {
            SCCHistoryDialog.create((JFrame)this._parent, (SCC)sCC, (File)this._sqlSavedFileName);
        }
    }

    private void handleSCCProperties() {
        final String string = this._sqlSavedFileName.getAbsolutePath();
        SCCRunner sCCRunner = new SCCRunner(this){

            @Override
            protected void doit() throws SCCException {
                this._scc.showProperties(string);
            }
        };
        if (!sCCRunner.call()) {
            SybOptionPane.showMessageDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "ErrorShowingSCCFileProperties", this._sqlSavedFileName.getName(), sCCRunner.getException().getLocalizedMessage()), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)0);
        }
    }

    private void handleSCCOpen() {
        WindowManager windowManager = WindowManager.getWindowManager();
        SCC sCC = windowManager.getSCCProvider();
        if (sCC != null) {
            windowManager.openSCCProject(true);
        }
    }

    private void handleSCCRun() {
        SCCRunner sCCRunner = new SCCRunner(this){

            @Override
            protected void doit() throws SCCException {
                this._scc.runSCC(null);
            }
        };
        sCCRunner.call();
    }

    private void handleSelectAll() {
        if (this._sqlStatementsLabel.isActive()) {
            this._sql.selectAll();
        } else {
            this._resultPanel.selectAll();
        }
    }

    private void handleSelectLine() {
        if (this._sqlStatementsLabel.isActive()) {
            this._sql.selectCurrentLine();
        }
    }

    private void handleSelectStatement() {
        if (this._sqlStatementsLabel.isActive()) {
            this._sql.selectCurrentStatement();
        }
    }

    private void handleSelectNextStatement() {
        if (this._sqlStatementsLabel.isActive()) {
            this._sql.selectNextStatement();
        }
    }

    private void handleSelectPreviousStatement() {
        if (this._sqlStatementsLabel.isActive()) {
            this._sql.selectPreviousStatement();
        }
    }

    private void handleFindReplace() {
        this._sql.findReplaceActionPerformed();
    }

    private void handleFindNext() {
        this._sql.findNextActionPerformed();
    }

    private void handleGoToLine() {
        this._sql.goToLineActionPerformed();
        this._sql.requestFocusInWindow();
    }

    private void handleConnect() {
        if (this._connection.isConnected()) {
            return;
        }
        ISQLPlugin iSQLPlugin = ((ISQLConnectionImpl)this._connection).getPlugin();
        if (iSQLPlugin == null && (iSQLPlugin = isql.options.getPlugin()) == null) {
            iSQLPlugin = PluginMgr.getPluginList()[0];
        }
        AbstractConnectionInfo abstractConnectionInfo = iSQLPlugin.getConnectionInfo();
        AbstractConnectionInfo abstractConnectionInfo2 = ((ISQLConnectionImpl)this._connection).getConnectionInfo();
        if (abstractConnectionInfo2 != null) {
            String string = abstractConnectionInfo.getUserName();
            String string2 = abstractConnectionInfo2.getUserName();
            if (string == null || string.equalsIgnoreCase(string2)) {
                abstractConnectionInfo.mergeConnectionString(abstractConnectionInfo2.getConnectionString());
            } else {
                abstractConnectionInfo = abstractConnectionInfo2;
            }
        }
        WindowManager.getWindowManager().connect(this._connection, iSQLPlugin, abstractConnectionInfo, FrontEnd.PromptBehavior.ALWAYS, false, null);
        if (this._connection.isConnected()) {
            this.clearResultsPanel();
            this.printConnectedMessage();
        }
    }

    void printConnectedMessage() {
        String string;
        String string2 = this._connection.getServerName();
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if ((string = this._connection.getCatalog()) != null && string.length() == 0) {
            string = null;
        }
        String string3 = string2 == null ? (string == null ? ISQLResource.getISQLString(GeneralResources.getName(), "CONNECTED") : ISQLResource.getFormattedString(GeneralResources.getName(), "CONNECTED_TO_DATABASE_NO_SERVER", string)) : (string == null ? ISQLResource.getFormattedString(GeneralResources.getName(), "CONNECTED_TO_SERVER", string2) : ISQLResource.getFormattedString(GeneralResources.getName(), "CONNECTED_TO_DATABASE", string, string2));
        isql.getIO(this._connection).writeln(string3, 0);
    }

    private void handleDisconnect() {
        switch (this._connection.getDatabaseType()) {
            case 1: {
                this._resultPanel.refresh((ISQLConnectionImpl)this._connection, "DISCONNECT FROM ASE");
                break;
            }
            default: {
                this._resultPanel.refresh((ISQLConnectionImpl)this._connection, "DISCONNECT");
            }
        }
        this._sql.requestFocus();
    }

    private String getSelectedSQL() {
        String string;
        int n;
        int n2 = this._sql.getSelectionStart();
        if (n2 == (n = this._sql.getSelectionEnd())) {
            this._sql.selectAll();
            n2 = this._sql.getSelectionStart();
            n = this._sql.getSelectionEnd();
        }
        String string2 = this._sql.getSelectedText();
        boolean bl = false;
        if (string2 != null) {
            int n3;
            int n4 = string2.length();
            for (n3 = 0; n3 < n4 && Character.isWhitespace(string2.charAt(n3)); ++n3) {
                ++n2;
                bl = true;
            }
            for (n3 = n4 - 1; n3 >= 0 && Character.isWhitespace(string2.charAt(n3)); --n3) {
                --n;
                bl = true;
            }
            if (bl) {
                this._sql.setSelectionStart(n2);
                this._sql.setSelectionEnd(n);
                string2 = this._sql.getSelectedText();
                if (string2 == null) {
                    string2 = "";
                }
            }
        } else {
            string2 = "";
        }
        if ((string = Preferences.getPluginStringPreference((ISQLConnectionImpl)this._connection, "commandDelimiter", ";")) != null && string.length() != 0 && string2.endsWith(string)) {
            string2 = string2.substring(0, string2.length() - string.length());
            if (this._sql.getSelectedText() != null) {
                this._sql.setSelectionEnd(this._sql.getSelectionEnd() - string.length());
            }
        }
        return string2;
    }

    private void editQuery() {
        Cursor cursor;
        if (this._connection == null || !isql.shouldUseQueryEditor(this._connection)) {
            return;
        }
        int n = this._sql.getSelectionStart();
        int n2 = this._sql.getSelectionEnd();
        String string = this.getSelectedSQL();
        if (this._queryEditorDialog == null) {
            cursor = Cursor.getPredefinedCursor(3);
            this._parent.setCursor(cursor);
            int n3 = isql.options.getDefaultDatabaseType();
            if (this._connection != null) {
                n3 = this._connection.getDatabaseType();
            }
            this._queryEditorDialog = n3 == 1 ? new QueryEditorDialog((Frame)this._parent, this._connection.getJDBCConnection(), ISQLHelpManager.getHelpFolder((ISQLConnectionImpl)this._connection), ISQLHelpManager.getHelpPrefix((ISQLConnectionImpl)this._connection), ISQLHelpManager.getHelpSuffix((ISQLConnectionImpl)this._connection), ASEQueryEditor.class) : new QueryEditorDialog((Frame)this._parent, this._connection.getJDBCConnection(), ISQLHelpManager.getHelpFolder((ISQLConnectionImpl)this._connection), ISQLHelpManager.getHelpPrefix((ISQLConnectionImpl)this._connection), ISQLHelpManager.getHelpSuffix((ISQLConnectionImpl)this._connection));
            this._parent.setCursor(null);
            this._queryEditorDialog.setTitle(ISQLResource.getISQLString(GeneralResources.getName(), "Query Editor"));
            this._queryEditorDialog.getQueryEditor().setCustomizerHost((CustomizerHost)this);
        } else {
            this._queryEditorDialog.setConnection(this._connection.getJDBCConnection());
        }
        cursor = null;
        if (string != null && string.trim().length() > 0) {
            try {
                cursor = this.getQueryModel(string);
            }
            catch (Exception exception) {
            }
            catch (TokenMgrError tokenMgrError) {
                // empty catch block
            }
            if (cursor == null) {
                int n4 = SybOptionPane.showOptionDialog((Component)this._parent, (Object)ISQLResource.getISQLString(ErrorMessages.getName(), "NotASelectStatement"), (String)ISQLResource.getISQLString(GeneralResources.getName(), "Query Editor"), (int)0, (int)2, null, null, null);
                if (n4 == 1) {
                    this._sql.setSelectionStart(n);
                    this._sql.setSelectionEnd(n2);
                    return;
                }
                cursor = this.getQueryModel();
            }
        } else {
            cursor = this.getQueryModel();
        }
        this._queryEditorDialog.setModel((QueryModel)cursor);
        int n5 = this._queryEditorDialog.open();
        if (n5 == 0) {
            string = this._queryEditorDialog.getModel().getSQLQuery();
            if (this._sql.getSelectedText() != null) {
                this._sql.replaceSelection(string);
            } else {
                this._sql.setText(string);
            }
            this._sql.requestFocus();
        }
    }

    private DefaultQueryModel getQueryModel() {
        if (this._connection.getDatabaseType() == 1) {
            return new DefaultASEQueryModel();
        }
        return new DefaultQueryModel();
    }

    private DefaultQueryModel getQueryModel(String string) throws ParseException {
        if (this._connection.getDatabaseType() == 1) {
            return new DefaultASEQueryModel(string);
        }
        return new DefaultQueryModel(string);
    }

    boolean isInterruptable() {
        return this.inputStatementInProgress || this.outputStatementInProgress || this._resultPanel.isInterruptable();
    }

    boolean shouldIncludeMenu(String string) {
        boolean bl;
        int n = this._connection != null && this._connection.isConnected() ? this._connection.getDatabaseType() : isql.options.getDefaultDatabaseType();
        if (n == 0) {
            bl = true;
        } else if (n == 2) {
            bl = !string.equals("IndexConsultant");
        } else if (n == 1) {
            boolean bl2 = bl = !string.equals("IndexConsultant") && !string.equals("SQL Syntax") && !string.equals("OnlineResources") && !string.equals("CheckForSoftwareUpdates");
            if (string.equals("OPEN_PLAN_VIEWER")) {
                ISQLPlugin iSQLPlugin;
                int[] nArray;
                bl = this._connection.isConnected() ? (nArray = (iSQLPlugin = ((ISQLConnectionImpl)this._connection).getPlugin()).getDatabaseVersion(this._connection))[0] >= 15 : false;
            }
        } else {
            bl = n == 3 ? !string.equals("IndexConsultant") && !string.equals("Lookup Procedure Name") : true;
        }
        if (string.equals("Edit Query")) {
            bl = isql.shouldUseQueryEditor(this.getConnection());
        }
        return bl;
    }

    boolean shouldEnableMenu(String string) {
        boolean bl = true;
        if (this.isInterruptable()) {
            bl = string.equals("Stop");
            return bl;
        }
        if (string.equals("Stop")) {
            bl = this.isInterruptable();
        } else if (string.equals("Previous SQL")) {
            bl = this._connection != null && this._history.canMove(-1);
        } else if (string.equals("Next SQL")) {
            bl = this._connection != null && this._history.canMove(1);
        } else if (string.equals("Copy")) {
            String string2;
            bl = this._sqlStatementsLabel.isActive() ? (string2 = this._sql.getSelectedText()) != null && string2.length() != 0 : this._resultPanel.shouldEnableCopy();
        } else if (string.equals("Delete")) {
            String string3;
            bl = this._sqlStatementsLabel.isActive() ? (string3 = this._sql.getSelectedText()) != null && string3.length() != 0 : this._resultPanel.isResultSetTableEditable() && this._resultPanel.isResultSetTableRowSelected();
        } else if (string.equals("Cut")) {
            String string4;
            bl = this._sqlStatementsLabel.isActive() ? (string4 = this._sql.getSelectedText()) != null && string4.length() != 0 : false;
        } else if (string.equals("Paste") || string.equals("FindReplace") || string.equals("FindNext") || string.equals("GoToLine")) {
            bl = this._sqlStatementsLabel.isActive();
        } else if (string.equals("Save")) {
            bl = true;
        } else if (string.equals("Start Logging...")) {
            bl = this._connection != null && !this._logFile.isOpen();
        } else if (string.equals("Stop Logging")) {
            bl = this._connection != null && this._logFile.isOpen();
        } else if (string.equals("Undo")) {
            bl = this._sqlStatementsLabel.isActive() && this._sql.canUndo();
        } else if (string.equals("Redo")) {
            bl = this._sqlStatementsLabel.isActive() && this._sql.canRedo();
        } else if (string.equals("Connect")) {
            bl = this._connection == null || !this._connection.isConnected();
        } else if (string.equals("IndexConsultant")) {
            bl = false;
            if (this._connection != null && this._connection.isConnected()) {
                int n = this._connection.getDatabaseType();
                bl = n == 0 || n == 2;
            }
        } else if (string.equals("OPEN_PLAN_VIEWER")) {
            bl = PlanFrame.getPluginForPlanViewing((ISQLConnectionImpl)this._connection) != null;
        } else if (string.equals("Disconnect") || string.equals("Import...") || string.equals("Export...") || string.equals("Edit Query") || string.equals("Lookup Table Name") || string.equals("Lookup Procedure Name")) {
            bl = this._connection != null && this._connection.isConnected();
        } else if (string.equals("Execute")) {
            bl = !Preferences.isExecuteAllDisabled();
        } else if (string.equals("Lookup Procedure Name") && this._connection.getDatabaseType() == 3) {
            bl = false;
        } else if (string.equals("SCCOpen")) {
            bl = this.shouldEnableSCCItem(11);
        } else if (string.equals("SCCGet")) {
            bl = this.shouldEnableSCCItem(0);
        } else if (string.equals("SCCCheckOut")) {
            bl = this.shouldEnableSCCItem(1);
        } else if (string.equals("SCCCheckIn")) {
            bl = this.shouldEnableSCCItem(2);
        } else if (string.equals("SCCUndoCheckout")) {
            bl = this.shouldEnableSCCItem(3);
        } else if (string.equals("SCCHistory")) {
            bl = this.shouldEnableSCCItem(7);
        } else if (string.equals("SCCDiff")) {
            bl = this.shouldEnableSCCItem(6);
        } else if (string.equals("SCCProperties")) {
            bl = this.shouldEnableSCCItem(9);
        } else if (string.equals("SCCRun")) {
            SCC sCC = WindowManager.getWindowManager().getSCC();
            bl = sCC != null ? (sCC.getCapabilities() & 0x20) != 0 : false;
        } else if (string.equals("SELECT_LINE") || string.equals("SELECT_STATEMENT") || string.equals("SELECT_PREV_STATEMENT") || string.equals("SELECT_NEXT_STATEMENT")) {
            bl = this._sqlStatementsLabel.isActive();
        }
        return bl;
    }

    private boolean shouldEnableSCCItem(int n) {
        boolean bl;
        SCC sCC = WindowManager.getWindowManager().getSCC();
        if (sCC == null) {
            bl = false;
        } else if (n == 11) {
            bl = sCC.supportsCommand(n);
        } else {
            boolean bl2 = bl = this._sqlSavedFileName != null && sCC.supportsCommand(n);
            if (bl) {
                int n2 = this.getSCCFileStatus(this._sqlSavedFileName);
                if (n == 2) {
                    bl = n2 == -1 || (n2 & 1) != 0 && (n2 & 2) != 0 && (n2 & 0x40) == 0;
                } else if (n == 3) {
                    bl = n2 == -1 || (n2 & 1) != 0 && (n2 & 2) != 0 && (n2 & 0x40) == 0;
                } else if (n == 0 || n == 6 || n == 9 || n == 7) {
                    bl = n2 == -1 || (n2 & 1) != 0 && (n2 & 0x40) == 0;
                } else if (n == 1) {
                    bl = n2 == -1 || (n2 & 1) != 0 && (n2 & 2) == 0 && (n2 & 0x40) == 0;
                }
            }
        }
        return bl;
    }

    private void handleStartLogging() {
        File file;
        boolean bl;
        SybFileChooser sybFileChooser = new SybFileChooser(274);
        sybFileChooser.setFilters(new SybFileFilter[]{new SybFileFilter("sql", ISQLResource.getISQLString(GeneralResources.getName(), "SQL Statements (*.{0})"), null), SybFileFilter.getAllFilesFilter()}, 0);
        sybFileChooser.setDefaultExtension("sql");
        File file2 = this.getInitialBrowserDirectory("lastFileSaveFolder", null);
        if (sybFileChooser.showDialog((Window)this._parent, file2, null) && (bl = this.startLogging((file = sybFileChooser.getSelectedFile()).toString()))) {
            Preferences.setStringOption(this._connection, "isql_log", file.toString());
            Preferences.setStringOption(null, "lastFileSaveFolder", file.getParent());
        }
    }

    boolean startLogging(String string) {
        this._logFile.open(string, true, isql.getIO(this._connection));
        return this._logFile.isOpen();
    }

    void stopLogging() {
        this._logFile.close(isql.getIO(this._connection));
        Preferences.setStringOption(this._connection, "isql_log", "");
    }

    private void handleLookupTable() {
        String string;
        String string2 = ISQLResource.getISQLString(GeneralResources.getName(), "Lookup Table Name");
        String[] stringArray = TableBrowser.create(this._parent, this._connection, string2, string = ISQLResource.getISQLString(GeneralResources.getName(), ""), 1);
        if (stringArray != null && stringArray.length != 0) {
            String string3 = stringArray[0];
            if (string3.indexOf(32) != -1) {
                string3 = "\"" + string3 + "\"";
            }
            this.insertDelimitedText(string3);
            this._sql.requestFocus();
        }
    }

    private void insertDelimitedText(String string) {
        char c;
        String string2;
        int n = this._sql.getCaretPosition();
        Document document = this._sql.getDocument();
        try {
            string2 = document.getText(n - 1, 1);
            if (string2 != null && string2.length() != 0 && !Character.isWhitespace(c = string2.charAt(0)) && c != '.' && c != '\"') {
                string = " " + string;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            string2 = document.getText(n, 1);
            if (string2 != null && string2.length() != 0 && !Character.isWhitespace(c = string2.charAt(0)) && c != '.' && c != '\"') {
                string = string + " ";
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this._sql.replaceSelection(string);
    }

    private void handleLookupProcedure() {
        String string = ProcedureBrowser.create(this._parent, this._connection);
        if (string != null) {
            this._sql.replaceSelection(string);
            this._sql.requestFocus();
        }
    }

    private void handleIndexWizard() {
        int n;
        String[] stringArray = new String[1];
        if (Preferences.getBooleanOption(this._connection, "setInitialFolderForFileBrowsers")) {
            stringArray[0] = Preferences.getStringOption(null, "lastFileSaveFolder");
        }
        String string = this.getSelectedSQL();
        String string2 = Preferences.getPluginStringPreference((ISQLConnectionImpl)this._connection, "commandDelimiter", ";");
        if (string2.length() > 0 && (n = string.indexOf(string2)) > 0) {
            string = string.substring(0, n);
        }
        if (string2.length() > 0) {
            IndexWizard.create((JFrame)this._parent, (Connection)this._connection.getJDBCConnection(), (String)string, (char)string2.charAt(0), (String[])stringArray, (String)ISQLHelpManager.getHelpFolder((ISQLConnectionImpl)this._connection), (String)ISQLHelpManager.getHelpPrefix((ISQLConnectionImpl)this._connection), (String)ISQLHelpManager.getHelpSuffix((ISQLConnectionImpl)this._connection), (int)0, (long)0L, (int)this._connection.getASAMajorVersionNumber());
            Preferences.setStringOption(null, "lastFileSaveFolder", stringArray[0]);
        }
    }

    private void handleExecuteClick() {
        this._sql.selectAll();
        this.handleExecuteSelectionClick();
    }

    private void handleSingleStep() {
        boolean bl = this._sql.selectCurrentStatement();
        if (!bl) {
            SybOptionPane.showMessageDialog((Component)this._parent, (Object)ISQLResource.getISQLString(ErrorMessages.getName(), "CANT_SINGLE_STEP"), (String)ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)0);
            return;
        }
        bl = this.handleExecuteSelectionClick();
        if (bl) {
            bl = this._sql.selectNextStatement();
            if (bl) {
                this._sql.ensureSelectionIsVisible();
            } else {
                int n = this._sql.getDocument().getLength();
                this._sql.setSelectionStart(n);
                this._sql.setSelectionEnd(n);
            }
        }
    }

    private void handleOpenPlanViewer() {
        String string;
        String string2 = this._sql.getSelectedText();
        if (string2 == null || string2.isEmpty()) {
            string2 = this._sql.getText();
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (!(string = Preferences.getPluginStringPreference((ISQLConnectionImpl)this._connection, "commandDelimiter", ";")).isEmpty()) {
            int n = string2.indexOf(string);
            if (n > 0) {
                string2 = string2.substring(0, n).trim();
            } else if (n == 0) {
                string2 = null;
            }
        }
        if (this._connection == null || !this._connection.isConnected()) {
            string2 = null;
        }
        if (string2 != null) {
            this._history.add(new HistoryItem(string2));
        }
        PlanFrame planFrame = new PlanFrame(this._parent, PlanFrame.getPluginForPlanViewing((ISQLConnectionImpl)this._connection), string2);
    }

    private boolean handleExecuteSelectionClick() {
        int n;
        boolean bl = false;
        String string = this._sql.getSelectedText();
        if (!(string != null && string.length() != 0 || (string = this._sql.getText()) != null && string.length() != 0)) {
            return bl;
        }
        if (this._planFileName != null) {
            this._planFileName = null;
            this.fireUpdateWindowTitleEvent();
        }
        this._history.add(new HistoryItem(string));
        int n2 = this._sql.getSelectionStart();
        int n3 = this._sql.getSelectionEnd();
        if (n2 == n3) {
            this._sql.selectAll();
            n = 0;
        } else {
            Point point = this._sql.getCaretLineAndColumn(n2);
            n = point.y - 1;
        }
        if (!string.endsWith("\n")) {
            string = string.concat("\n");
        }
        bl = this._resultPanel.refresh((ISQLConnectionImpl)this._connection, string, n, false);
        if (this._connection == null || !this._connection.isBusy() && !this._connection.isConnected()) {
            this.fireUpdateWindowTitleEvent();
        }
        if (this._sql != null) {
            this._sql.requestFocus();
        }
        return bl;
    }

    private void handlePreviousSQLClick() {
        String string = this._sql.getText();
        HistoryItem historyItem = this._history.move(-1);
        if (historyItem != null) {
            if (historyItem.sql.equals(string) && this._history.canMove(-1)) {
                historyItem = this._history.move(-1);
            }
            this._sql.setText(historyItem.sql);
        }
    }

    private void handleNextSQLClick() {
        HistoryItem historyItem = this._history.move(1);
        if (historyItem != null) {
            this._sql.setText(historyItem.sql);
        }
    }

    private void handleSQLHistoryClick() {
        HistoryListDialog historyListDialog = new HistoryListDialog(this._parent);
        boolean bl = historyListDialog.create(this._history, this._connection);
        if (bl) {
            this._sql.setText(historyListDialog.getSelectedText());
        }
    }

    History getHistory() {
        return this._history;
    }

    void stopTheCurrentCommand() {
        if (!this._interruptPending) {
            this._interruptPending = true;
            if (this.inputStatementInProgress) {
                this.interruptInputStatement = true;
            } else if (this.outputStatementInProgress) {
                this.interruptOutputStatement = true;
            } else {
                this._resultPanel.interrupt();
            }
        }
    }

    void updateResultSetTableFont() {
        if (this._resultPanel != null) {
            this._resultPanel.updateResultSetTableFont();
        }
    }

    void updateResultSetTableClipboardFormat() {
        if (this._resultPanel != null) {
            this._resultPanel.updateResultSetTableClipboardFormat();
        }
    }

    void setShowResultsAsText(boolean bl) {
        if (this._resultPanel != null) {
            this._resultPanel.setShowResultsAsText(bl);
        }
    }

    void updateResultSetTableTruncationLength() {
        if (this._resultPanel != null) {
            this._resultPanel.updateResultSetTableTruncationLength();
        }
    }

    private void notifyWindowTitleChange() {
        this.fireUpdateWindowTitleEvent();
    }

    void addISQLListener(ISQLListener iSQLListener) {
        if (iSQLListener != null) {
            if (this._listeners == null) {
                this._listeners = new EventListenerList();
            }
            this._listeners.add(ISQLListener.class, iSQLListener);
        }
    }

    void removeISQLListener(ISQLListener iSQLListener) {
        if (iSQLListener != null && this._listeners != null) {
            this._listeners.remove(ISQLListener.class, iSQLListener);
        }
    }

    private void fireUpdateWindowTitleEvent() {
        ISQLEvent iSQLEvent = null;
        if (this._listeners != null) {
            int n;
            Object[] objectArray = this._listeners.getListenerList();
            for (int i = n = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ISQLListener.class) continue;
                if (iSQLEvent == null) {
                    iSQLEvent = new ISQLEvent(this);
                }
                ((ISQLListener)objectArray[i + 1]).updateWindowTitle(iSQLEvent);
            }
        }
    }

    String getWindowTitle() {
        if (this._planFileName != null) {
            String string = this._connection != null && this._connection.isConnected() ? ISQLResource.getFormattedString(GeneralResources.getName(), "{0} - {1}", this._planFileName, this._connection.getDescription()) : this._planFileName;
            return string;
        }
        String string = this._sqlSavedFileName != null ? (this._sqlSavedFileIsModified ? this._sqlSavedFileName.getName() + "*" : this._sqlSavedFileName.getName()) : null;
        String string2 = this._connection != null && this._connection.isConnected() ? (string == null ? this._connection.getDescription() : (this._sqlSavedFileIsEditable ? ISQLResource.getFormattedString(GeneralResources.getName(), "{0} - {1}", string, this._connection.getDescription()) : ISQLResource.getFormattedString(GeneralResources.getName(), "WindowTitleConnectedWithReadOnlyFile", string, this._connection.getDescription()))) : (string == null ? ISQLResource.getISQLString(GeneralResources.getName(), "(Not Connected)") : (this._sqlSavedFileIsEditable ? string : ISQLResource.getFormattedString(GeneralResources.getName(), "WindowTitleReadOnlyFile", string)));
        return string2;
    }

    void notifyPreferencesChanged() {
        boolean bl = Preferences.getBooleanOption(null, "showSeparateMessagesPane");
        if (bl != this._resultPanel.getShowMessagesSeparately()) {
            Container container = this._resultPanel.getParent();
            container.remove(this._resultPanel);
            this._resultPanel.release();
            this._resultPanel = new ResultsPanel(this._parent, this._connection);
            container.add(this._resultPanel);
        }
    }

    public CustomizeDialog getCustomizeDialog(Window window) {
        int n;
        CustomizeDialog customizeDialog = window instanceof Frame ? new CustomizeDialog((Frame)window) : new CustomizeDialog((Dialog)window);
        if (Platform.isMacOS()) {
            customizeDialog.setTitle(ISQLResource.getISQLString(GeneralResources.getName(), "Preferences"));
        } else {
            customizeDialog.setTitle(ISQLResource.getISQLString(GeneralResources.getName(), "Options"));
        }
        Customizable[] customizableArray = OptionsPageController.getCustomizableComponents(customizeDialog, this._connection);
        for (n = 0; n < customizableArray.length; ++n) {
            customizeDialog.addCustomizationPages(customizableArray[n]);
        }
        customizeDialog.addCustomizationPages((Customizable)this._sql);
        ISQLPlugin[] iSQLPluginArray = PluginMgr.getPluginList();
        for (n = 0; n < iSQLPluginArray.length; ++n) {
            ISQLConnection iSQLConnection = iSQLPluginArray[n] == ((ISQLConnectionImpl)this._connection).getPlugin() ? this._connection : null;
            Customizable customizable = iSQLPluginArray[n].getCustomizableObject(iSQLConnection);
            if (customizable == null) continue;
            customizeDialog.addCustomizationPages(customizable);
        }
        return customizeDialog;
    }

    boolean openCustomizationDialog(JFrame jFrame) {
        CustomizeDialog customizeDialog = this.getCustomizeDialog(jFrame);
        UIUtils.ensureWindowIsVisible((Window)customizeDialog);
        customizeDialog.setVisible(true);
        customizeDialog.destroy();
        boolean bl = customizeDialog.wasOKClicked();
        if (bl) {
            if (this._connection instanceof ISQLConnectionImpl) {
                ((ISQLConnectionImpl)this._connection).updateCachedPreferences();
            }
            Preferences.save(this._connection);
            this.notifyPreferencesChanged();
        }
        bl = true;
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._sql.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    int displaySCCMessage(int n, String string) {
        IO iO;
        if (this._resultPanel != null && (iO = this._resultPanel.getMessagePanelIO()) != null) {
            int n2 = n == 3 ? 2 : 0;
            iO.writeln(string, n2);
        }
        return 0;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        boolean bl;
        int n;
        int n2;
        if (!this._sqlSavedFileIsEditable && ((n2 = keyEvent.getModifiersEx()) & (n = 9088)) == 0 && (bl = Preferences.getBooleanOption(null, "autoCheckout")) && this.shouldEnableSCCItem(1)) {
            this.handleSCCCheckOut();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent(documentEvent);
    }

    private void handleDocumentEvent(DocumentEvent documentEvent) {
        if (this._sqlSavedFileName != null && !this._sqlSavedFileIsModified) {
            this._sqlSavedFileIsModified = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ISQLPanel.this.fireUpdateWindowTitleEvent();
                }
            });
        }
    }

    class MyDocumentFilter
    extends DocumentFilter {
        private DocumentFilter _filter;

        MyDocumentFilter() {
        }

        void install() {
            Document document = ISQLPanel.this._sql.getDocument();
            if (document instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                this._filter = abstractDocument.getDocumentFilter();
                abstractDocument.setDocumentFilter(this);
            }
        }

        void uninstall() {
            Document document;
            if (this._filter != null && (document = ISQLPanel.this._sql.getDocument()) instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                abstractDocument.setDocumentFilter(this._filter);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (ISQLPanel.this._enabled) {
                if (this._filter != null) {
                    this._filter.insertString(filterBypass, n, string, attributeSet);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (ISQLPanel.this._enabled) {
                if (this._filter != null) {
                    this._filter.replace(filterBypass, n, n2, string, attributeSet);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (ISQLPanel.this._enabled) {
                if (this._filter != null) {
                    this._filter.remove(filterBypass, n, n2);
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

