/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.OutOfMemoryException;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.resultSetTable.ScrollableResultSetEvent;
import com.sybase.resultSetTable.ScrollableResultSetListener;
import com.sybase.util.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.NoSuchElementException;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.IOFilter;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.Preferences;
import sybase.isql.ResultSetIO;
import sybase.isql.isql;

class ISQLResultSetImpl
implements ISQLResultSet,
ScrollableResultSetListener {
    private static final int UNKNOWN = -1;
    private ScrollableResultSet _resultSet;
    private String _sql;
    private String _nullDisplayString;
    private ISQLConnection _connection;
    protected int _maxRows;
    private boolean _showScrollableResultSetExceptions;
    private NumberFormat _numberFormatter;

    ISQLResultSetImpl(ISQLConnection iSQLConnection, String string, ResultSet resultSet, int n, String string2, boolean bl) {
        this._resultSet = null;
        this._sql = null;
        this._maxRows = 500;
        this._showScrollableResultSetExceptions = true;
        this._numberFormatter = null;
        this._connection = iSQLConnection;
        this._sql = string;
        this._nullDisplayString = string2;
        this._maxRows = n;
        this.cacheResultSet(resultSet, bl);
    }

    ISQLResultSetImpl(ISQLResultSet iSQLResultSet, int n) {
        block8: {
            this._resultSet = null;
            this._sql = null;
            this._maxRows = 500;
            this._showScrollableResultSetExceptions = true;
            this._numberFormatter = null;
            ISQLResultSetImpl iSQLResultSetImpl = (ISQLResultSetImpl)iSQLResultSet;
            try {
                Statement statement;
                this._connection = iSQLResultSetImpl.getConnection();
                if (!(this._connection instanceof ISQLConnectionImpl)) break block8;
                ISQLConnectionImpl iSQLConnectionImpl = (ISQLConnectionImpl)this._connection;
                this._sql = iSQLResultSetImpl.getSQLStatement();
                try {
                    statement = iSQLConnectionImpl.getJDBCConnection().createStatement(1003, 1007);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    statement = this._connection.getJDBCConnection().createStatement();
                }
                try {
                    statement.execute("set temporary option Return_date_time_as_string=Off");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ResultSet resultSet = statement.executeQuery(this._sql);
                this._nullDisplayString = Preferences.getPluginStringPreference((ISQLConnectionImpl)this._connection, "nulls", "(NULL)");
                this._maxRows = n;
                this.cacheResultSet(resultSet, true);
                resultSet.close();
                try {
                    statement.execute("set temporary option Return_date_time_as_string=On");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    int getMaxRows() {
        return this._maxRows;
    }

    void setMaxRows(int n) {
        this._maxRows = n;
        if (this._resultSet != null) {
            this._resultSet.setMaxRows(n);
        }
    }

    @Override
    public ScrollableResultSet getScrollableResultSet() {
        return this._resultSet;
    }

    @Override
    public void close() {
        if (this._resultSet != null) {
            this._resultSet.destroy();
            this._resultSet = null;
        }
        this._sql = null;
        this._nullDisplayString = null;
        this._connection = null;
    }

    @Override
    public ISQLConnection getConnection() {
        return this._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheResultSet(ResultSet resultSet, boolean bl) {
        ResultSetIO resultSetIO = null;
        IO iO = isql.getIO(this._connection);
        try {
            if (iO instanceof ResultSetIO) {
                resultSetIO = (ResultSetIO)((Object)iO);
            } else {
                while (iO instanceof IOFilter) {
                    if (!((iO = ((IOFilter)iO).getOriginalIO()) instanceof ResultSetIO)) continue;
                    resultSetIO = (ResultSetIO)((Object)iO);
                    break;
                }
            }
            if (resultSetIO != null) {
                resultSetIO.updateFetchingStatus(true);
            }
            this._resultSet = new ScrollableResultSet(this._connection.getJDBCConnection(), resultSet, this._maxRows, 0);
            this._resultSet.addScrollableResultSetListener((ScrollableResultSetListener)this);
            if (bl) {
                int n = Preferences.getPluginIntPreference((ISQLConnectionImpl)this._connection, "truncationLength", "256");
                this._resultSet.setMaxClobCharacters(n);
                this._resultSet.setMaxBlobBytes(n);
                this._resultSet.cacheRows(this._maxRows);
                if (!Preferences.getPluginBooleanPreference((ISQLConnectionImpl)this._connection, "disableResultsEditing", "0") && this._resultSet.getColumnCount() > 0 && this._resultSet.isEditable()) {
                    this._resultSet.isColumnReadOnly(0);
                    this._resultSet.isPrimaryKey(0);
                }
                this._resultSet.notifyResultSetClosure();
            }
        }
        finally {
            if (resultSetIO != null) {
                resultSetIO.updateFetchingStatus(false);
            }
        }
    }

    public void exception(ScrollableResultSetEvent scrollableResultSetEvent) {
        if (this._showScrollableResultSetExceptions) {
            this._showScrollableResultSetExceptions = false;
            Exception exception = scrollableResultSetEvent.getException();
            if (exception != null && exception instanceof OutOfMemoryException) {
                isql.getIO(this._connection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "NOT_ENOUGH_MEMORY_TO_DISPLAY_RESULTSET", Platform.isMacOS() ? ISQLResource.getISQLString(GeneralResources.getName(), "Preferences") : ISQLResource.getISQLString(GeneralResources.getName(), "Options")), 2);
            } else {
                isql.getIO(this._connection).writeln(exception, ISQLResource.getISQLString(ErrorMessages.getName(), "ErrorReadingResultSet"), 2);
            }
        }
    }

    public void stateChanged(ScrollableResultSetEvent scrollableResultSetEvent) {
    }

    @Override
    public int getColumnCount() {
        return this._resultSet.getColumnCount();
    }

    @Override
    public Class getColumnClass(int n) {
        return this._resultSet.getColumnClass(n);
    }

    @Override
    public int getColumnSQLType(int n) {
        return this._resultSet.getColumnType(n);
    }

    @Override
    public String getColumnTypeName(int n) {
        return this._resultSet.getColumnTypeName(n);
    }

    @Override
    public boolean isColumnBinary(int n) {
        return this._resultSet.isColumnBinary(n);
    }

    @Override
    public String getColumnName(int n) {
        return this._resultSet.getColumnName(n);
    }

    @Override
    public String getColumnLabel(int n) {
        return this._resultSet.getColumnLabel(n);
    }

    @Override
    public int getColumnAlignment(int n) {
        return ISQLResultSetImpl.getAlignmentForSQLType(this._resultSet.getColumnType(n));
    }

    static int getAlignmentForSQLType(int n) {
        int n2;
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    @Override
    public int getColumnWidth(int n) {
        return this._resultSet.getColumnWidth(n);
    }

    @Override
    public int getScale(int n) {
        return this._resultSet.getColumnScale(n);
    }

    @Override
    public int getPrecision(int n) {
        return this._resultSet.getColumnPrecision(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._resultSet.getValueAt(n, n2);
    }

    @Override
    public String getStringValueAt(int n, int n2) {
        Object object;
        try {
            object = this._resultSet.getValueAt(n, n2);
        }
        catch (NoSuchElementException noSuchElementException) {
            object = null;
        }
        if (object == null) {
            return this._nullDisplayString;
        }
        if (this.isColumnBinary(n2)) {
            if (object instanceof InputStream) {
                return ISQLResultSetImpl.blobToString((InputStream)object, Preferences.getPluginIntPreference((ISQLConnectionImpl)this._connection, "truncationLength", "256"));
            }
            if (object instanceof byte[]) {
                return ISQLResultSetImpl.byteArrayToString((byte[])object, Preferences.getPluginIntPreference((ISQLConnectionImpl)this._connection, "truncationLength", "256"));
            }
            if (object instanceof LongBinaryValue) {
                return ISQLResultSetImpl.byteArrayToString(((LongBinaryValue)object).getTruncatedValue(), Preferences.getPluginIntPreference((ISQLConnectionImpl)this._connection, "truncationLength", "256"));
            }
        } else {
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return "1";
                }
                return "0";
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                int n3 = bigDecimal.precision();
                int n4 = bigDecimal.scale();
                if (this._numberFormatter == null) {
                    this._numberFormatter = NumberFormat.getInstance();
                    this._numberFormatter.setGroupingUsed(false);
                }
                this._numberFormatter.setMaximumIntegerDigits(n3);
                this._numberFormatter.setMaximumFractionDigits(n4);
                this._numberFormatter.setMinimumFractionDigits(n4);
                return this._numberFormatter.format(object);
            }
        }
        return object.toString();
    }

    static String byteArrayToString(byte[] byArray, int n) {
        int n2 = byArray.length;
        if (n != 0) {
            n2 = Math.min(n2, n);
        }
        StringBuffer stringBuffer = new StringBuffer(n2 * 2 + 2);
        stringBuffer.append("0x");
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[i];
            if (n3 < 0) {
                n3 += 256;
            }
            int n4 = n3 >> 4;
            int n5 = n3 & 0xF;
            if (n4 < 10) {
                stringBuffer.append((char)(48 + n4));
            } else {
                stringBuffer.append((char)(97 + n4 - 10));
            }
            if (n5 < 10) {
                stringBuffer.append((char)(48 + n5));
                continue;
            }
            stringBuffer.append((char)(97 + n5 - 10));
        }
        return stringBuffer.toString();
    }

    static String blobToString(InputStream inputStream, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 2 + 2);
        try {
            int n2;
            int n3 = 0;
            while ((n2 = inputStream.read()) != -1) {
                if (n3 == 0) {
                    stringBuffer.append("0x");
                }
                int n4 = n2 >> 4;
                int n5 = n2 & 0xF;
                if (n4 < 10) {
                    stringBuffer.append((char)(48 + n4));
                } else {
                    stringBuffer.append((char)(97 + n4 - 10));
                }
                if (n5 < 10) {
                    stringBuffer.append((char)(48 + n5));
                } else {
                    stringBuffer.append((char)(97 + n5 - 10));
                }
                if (++n3 != n) continue;
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private byte[] stringToBlob(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n - 2) / 2];
        int n2 = 0;
        for (int i = 2; i < n; i += 2) {
            int n3 = string.charAt(i);
            n3 = n3 >= 48 && n3 <= 57 ? (n3 -= 48) : (n3 >= 97 && n3 <= 102 ? n3 - 97 + 10 : (n3 >= 65 && n3 <= 70 ? n3 - 65 + 10 : 0));
            int n4 = string.charAt(i + 1);
            n4 = n4 >= 48 && n4 <= 57 ? (n4 -= 48) : (n4 >= 97 && n4 <= 102 ? n4 - 97 + 10 : (n4 >= 65 && n4 <= 70 ? n4 - 65 + 10 : 0));
            byArray[n2++] = (byte)((n3 << 4) + n4);
        }
        return byArray;
    }

    @Override
    public int getRowCount() {
        int n = this._resultSet.getRowCount();
        if (n == -1) {
            n = this._maxRows;
        }
        return n;
    }

    @Override
    public boolean rowExists(int n) {
        return this._resultSet.rowExists(n);
    }

    @Override
    public String getSQLStatement() {
        return this._sql;
    }

    @Override
    public boolean hasPartialData() {
        boolean bl;
        boolean bl2 = bl = this._resultSet.hasPartialData() || this._resultSet.getCacheLastRowOnly();
        if (!bl) {
            int n = this._resultSet.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int n2 = this._resultSet.getColumnType(i);
                if (n2 != 91 && n2 != 92 && n2 != 93) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static class CachingAbortedException
    extends Exception {
        CachingAbortedException() {
        }
    }
}

