/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.customization.CustomizeDialog;
import com.sybase.util.FontHelper;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import sybase.isql.BasePage;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;
import sybase.isql.LimitedTextField;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;
import sybase.isql.UserDataComboBox;
import sybase.isql.WindowManager;

class ImportExportPage
extends BasePage {
    private int _opt_importFormat;
    private int _opt_exportFormat;
    private String _opt_fieldSeparator;
    private String _opt_quote;
    private String _opt_escapeCharacter;
    private String _opt_encoding;
    private UserDataComboBox _exportFormat;
    private UserDataComboBox _importFormat;
    private JTextField _fieldSeparator;
    private JTextField _quote;
    private LimitedTextField _escapeCharacter;
    private JComboBox _encoding;

    ImportExportPage(CustomizeDialog customizeDialog, ISQLConnection iSQLConnection) {
        super(customizeDialog, iSQLConnection);
        this.readSettings();
        this.createUI();
    }

    private void readSettings() {
        this._opt_importFormat = Preferences.getFileFormatCode(this._connection, "input_format", false);
        this._opt_exportFormat = Preferences.getFileFormatCode(this._connection, "output_format", false);
        this._opt_fieldSeparator = Preferences.getStringOption(this._connection, "ISQL_field_separator", false);
        this._opt_quote = Preferences.getStringOption(this._connection, "ISQL_quote", false);
        this._opt_escapeCharacter = Preferences.getStringOption(this._connection, "ISQL_escape_character", false);
        this._opt_encoding = Preferences.getStringOption(this._connection, "defaultISQLEncoding", false);
    }

    private void createUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.createExportFormatPanel());
        this.add(this.createImportFormatPanel());
        this.add(this.createASCIIOptionsPanel());
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void destroy() {
        this._exportFormat.removeAll();
        this._exportFormat = null;
        this._importFormat.removeAll();
        this._importFormat = null;
        this._fieldSeparator = null;
        this._quote = null;
        this._escapeCharacter = null;
        super.destroy();
    }

    private JPanel createImportFormatPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        SybLabel sybLabel = new SybLabel(iSQLResource.getISQLString("Default import format:"));
        String[] stringArray = new String[]{iSQLResource.getISQLString("ASCII"), iSQLResource.getISQLString("Fixed")};
        Object[] objectArray = new Object[]{1, 2};
        this._importFormat = new UserDataComboBox(stringArray, objectArray);
        this._importFormat.setSelectedByUserData(this._opt_importFormat);
        sybLabel.setLabelFor((Component)this._importFormat);
        this._importFormat.setMaximumSize(new Dimension(Short.MAX_VALUE, this._importFormat.getPreferredSize().height));
        jPanel.add((Component)sybLabel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this._importFormat);
        return jPanel;
    }

    private JPanel createExportFormatPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        SybLabel sybLabel = new SybLabel(iSQLResource.getISQLString("Default export format:"));
        String[] stringArray = new String[]{iSQLResource.getISQLString("ASCII"), iSQLResource.getISQLString("Fixed"), iSQLResource.getISQLString("HTML"), iSQLResource.getISQLString("XML")};
        Object[] objectArray = new Object[]{1, 2, 3, 13};
        this._exportFormat = new UserDataComboBox(stringArray, objectArray);
        this._exportFormat.setSelectedByUserData(this._opt_exportFormat);
        sybLabel.setLabelFor((Component)this._exportFormat);
        this._exportFormat.setMaximumSize(new Dimension(Short.MAX_VALUE, this._exportFormat.getPreferredSize().height));
        jPanel.add((Component)sybLabel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this._exportFormat);
        return jPanel;
    }

    private JPanel createASCIIOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ISQLResource.getISQLString(GeneralResources.getName(), "ASCII Options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        SybLabel sybLabel = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "Default field separator:"));
        this._fieldSeparator = new JTextField();
        new FontHelper((JTextComponent)this._fieldSeparator);
        this._fieldSeparator.setBorder(BorderFactory.createCompoundBorder(this._fieldSeparator.getBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        this._fieldSeparator.setText(this._opt_fieldSeparator);
        sybLabel.setLabelFor((Component)this._fieldSeparator);
        jPanel.add((Component)sybLabel);
        jPanel.add(this._fieldSeparator);
        SybLabel sybLabel2 = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "Default quote string:"));
        this._quote = new JTextField();
        new FontHelper((JTextComponent)this._quote);
        this._quote.setBorder(BorderFactory.createCompoundBorder(this._quote.getBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        this._quote.setText(this._opt_quote);
        sybLabel2.setLabelFor((Component)this._quote);
        jPanel.add((Component)sybLabel2);
        jPanel.add(this._quote);
        SybLabel sybLabel3 = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "Default escape character:"));
        this._escapeCharacter = new LimitedTextField(1);
        new FontHelper((JTextComponent)this._escapeCharacter);
        this._escapeCharacter.setBorder(BorderFactory.createCompoundBorder(this._escapeCharacter.getBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        this._escapeCharacter.setText(this._opt_escapeCharacter);
        sybLabel3.setLabelFor((Component)this._escapeCharacter);
        jPanel.add((Component)sybLabel3);
        jPanel.add(this._escapeCharacter);
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        jPanel.setMaximumSize(dimension);
        SybLabel sybLabel4 = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "DefaultEncoding"));
        Vector<String> vector = new Vector<String>();
        vector.add(ISQLResource.getISQLString(GeneralResources.getName(), "IWDefaultEncoding"));
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Iterator<String> iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            Charset charset = (Charset)sortedMap.get(iterator.next());
            vector.add(charset.name());
        }
        this._encoding = new JComboBox(vector);
        if (this._opt_encoding == null) {
            this._encoding.setSelectedIndex(0);
        } else {
            this._encoding.setSelectedItem(this._opt_encoding);
        }
        sybLabel4.setLabelFor((Component)this._encoding);
        jPanel.add((Component)sybLabel4);
        jPanel.add(this._encoding);
        return jPanel;
    }

    @Override
    public void acceptChanges() {
        String string;
        Integer n;
        int n2 = this._importFormat.getSelectedIndex();
        if (n2 != -1) {
            n = (Integer)this._importFormat.getUserData(n2);
            this._opt_importFormat = n;
        }
        if ((n2 = this._exportFormat.getSelectedIndex()) != -1) {
            n = (Integer)this._exportFormat.getUserData(n2);
            this._opt_exportFormat = n;
        }
        if ((string = this._quote.getText().trim()).length() != 0) {
            this._opt_quote = string;
        }
        if ((string = this._fieldSeparator.getText().trim()).length() != 0) {
            this._opt_fieldSeparator = string;
        }
        if ((string = this._escapeCharacter.getText().trim()).length() != 0) {
            this._opt_escapeCharacter = string;
        }
        if ((n2 = this._encoding.getSelectedIndex()) == 0) {
            this._opt_encoding = null;
        } else if (n2 > 0) {
            this._opt_encoding = this._encoding.getSelectedItem().toString();
        }
        Preferences.setFileFormatCode(this._connection, "input_format", this._opt_importFormat);
        Preferences.setFileFormatCode(this._connection, "output_format", this._opt_exportFormat);
        Preferences.setStringOption(this._connection, "ISQL_field_separator", this._opt_fieldSeparator);
        Preferences.setStringOption(this._connection, "ISQL_quote", this._opt_quote);
        Preferences.setStringOption(this._connection, "ISQL_escape_character", this._opt_escapeCharacter);
        Preferences.setStringOption(this._connection, "defaultISQLEncoding", this._opt_encoding);
        Object[] objectArray = WindowManager.getParentFrames();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof ParentFrame)) continue;
            ParentFrame parentFrame = (ParentFrame)objectArray[i];
            parentFrame.updateResultSetTableClipboardFormat();
        }
    }

    public String getTitle() {
        return ISQLResource.getISQLString(GeneralResources.getName(), "Import/Export");
    }

    public void showHelp() {
        ISQLHelpManager.showHelp((ISQLConnectionImpl)this._connection, (Window)this._parent, "HELP_ISQL_OPTIONS_IMPORTEXPORT");
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public Icon getCustomizationGroupIcon() {
        return ISQLImages.getImageIcon("import_export16");
    }
}

