/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Vector;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLResource;
import sybase.isql.Importer;
import sybase.isql.ImporterPreviewer;
import sybase.isql.ODBCImporter;
import sybase.isql.Preferences;
import sybase.isql.TableGenitor;
import sybase.isql.TextImporter;

class InputOutputOptions {
    static final int FORMAT_UNKNOWN = 0;
    static final int FORMAT_ASCII = 1;
    static final int FORMAT_FIXED = 2;
    static final int FORMAT_HTML = 3;
    static final int FORMAT_SQL = 4;
    static final int FORMAT_GENERIC_TEXT = 11;
    static final int FORMAT_INTERACTIVE = 12;
    static final int FORMAT_XML = 13;
    static final int FORMAT_ODBC = 14;
    static final int BY_ORDER = 1;
    static final int BY_NAME = 2;
    static final int HEXADECIMAL_ON = 1;
    static final int HEXADECIMAL_OFF = 2;
    static final int HEXADECIMAL_ASIS = 3;
    private int _format = 0;
    private String _fileName;
    private char _escapeCharacter = (char)92;
    private String _delimiter = ",";
    private String _quote = "'";
    private boolean _quoteAll = false;
    private int _columnMatchingTechnique = 1;
    private boolean _noStrip = false;
    private Vector<String> _columnList = new Vector();
    private String _catalog = null;
    private String _owner = null;
    private String _tableName = null;
    private boolean _promptForData = false;
    private boolean _append = false;
    private boolean _verbose = false;
    private int _hexadecimal = 1;
    private TextImporter.Reader _sqlReader = null;
    private String _encoding = null;
    private boolean _escapes = true;
    private String _connectionString = null;
    private boolean _dontCreateTable = false;
    String odbcCatalog = null;
    String odbcSchema = null;
    String odbcTableName = null;
    boolean useByteOrderMark = true;
    boolean useByteOrderMarkSpecified = false;
    private Vector<Integer> _columnWidths = new Vector();
    private static IOFormatInfo[] _formatTable = new IOFormatInfo[]{new IOFormatInfo("UNKNOWN", 0), new IOFormatInfo("ASCII", 1), new IOFormatInfo("TEXT", 1), new IOFormatInfo("FIXED", 2), new IOFormatInfo("HTML", 3), new IOFormatInfo("XML", 13), new IOFormatInfo("SQL", 4)};

    InputOutputOptions(ISQLConnection iSQLConnection) {
        String string = Preferences.getStringOption(iSQLConnection, "ISQL_escape_character");
        if (string != null && string.length() != 0) {
            this._escapeCharacter = string.charAt(0);
        }
        if ((string = Preferences.getStringOption(iSQLConnection, "ISQL_field_separator")) != null && string.length() != 0) {
            this._delimiter = string;
        }
        if ((string = Preferences.getStringOption(iSQLConnection, "ISQL_quote")) != null && string.length() != 0) {
            this._quote = string;
        }
    }

    Importer getImporter() {
        Importer importer;
        switch (this.getFormat()) {
            case 1: 
            case 2: 
            case 11: {
                importer = new TextImporter(this);
                break;
            }
            case 14: {
                importer = new ODBCImporter(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported file format " + this.getFormat());
            }
        }
        return importer;
    }

    TableGenitor getTableGenitor() {
        Importer importer = this.getImporter();
        TableGenitor tableGenitor = importer != null && importer instanceof TableGenitor ? (TableGenitor)((Object)importer) : null;
        return tableGenitor;
    }

    ImporterPreviewer getImporterPreviewer() {
        Importer importer = this.getImporter();
        ImporterPreviewer importerPreviewer = importer != null && importer instanceof ImporterPreviewer ? (ImporterPreviewer)((Object)importer) : null;
        return importerPreviewer;
    }

    void setHexadecimal(int n) {
        this._hexadecimal = n;
    }

    int getHexadecimal() {
        return this._hexadecimal;
    }

    void setFormat(int n) {
        this._format = n;
    }

    int getFormat() {
        return this._format;
    }

    void setFileName(String string) {
        char c;
        char c2;
        if (string != null && (c2 = string.charAt(0)) == (c = string.charAt(string.length() - 1)) && (c2 == '\'' || c2 == '\"')) {
            string = string.substring(1, string.length() - 1);
        }
        this._fileName = string;
    }

    String getFileName() {
        return this._fileName;
    }

    void setEscapeCharacter(char c) {
        this._escapeCharacter = c;
    }

    char getEscapeCharacter() {
        return this._escapeCharacter;
    }

    void setQuote(String string) {
        if (string.length() > 1 && string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        this._quote = string;
    }

    String getQuote() {
        return this._quote;
    }

    void setQuoteAll(boolean bl) {
        this._quoteAll = bl;
    }

    boolean getQuoteAll() {
        return this._quoteAll;
    }

    void setDelimiter(String string) {
        this._delimiter = string;
    }

    String getDelimiter() {
        return this._delimiter;
    }

    void clearColumnWidths() {
        this._columnWidths.removeAllElements();
    }

    void addColumnWidth(int n) {
        this._columnWidths.addElement(n);
    }

    int getColumnWidthCount() {
        return this._columnWidths.size();
    }

    int getColumnWidth(int n) {
        return this._columnWidths.elementAt(n);
    }

    void setColumnMatchingTechnique(int n) {
        this._columnMatchingTechnique = n;
    }

    int getColumnMatchingTechnique() {
        return this._columnMatchingTechnique;
    }

    void setNoStrip(boolean bl) {
        this._noStrip = bl;
    }

    boolean getNoStrip() {
        return this._noStrip;
    }

    void setColumnList(Vector<String> vector) {
        this._columnList.removeAllElements();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this._columnList.addElement(vector.elementAt(i));
        }
    }

    Vector<String> getColumnList() {
        return this._columnList;
    }

    void setOwnerAndTableName(String string, String string2, String string3) {
        this._catalog = string;
        this._owner = string2;
        this._tableName = string3;
    }

    String getCatalog() {
        return this._catalog;
    }

    String getOwner() {
        return this._owner;
    }

    String getTableName() {
        return this._tableName;
    }

    String getQuotedOwnerAndTableName(ISQLConnection iSQLConnection) {
        String string = iSQLConnection instanceof ISQLConnectionImpl ? ((ISQLConnectionImpl)iSQLConnection).quoteOwnerAndTableName(this._catalog, this._owner, this._tableName) : (this._catalog == null ? (this._owner != null ? this._owner + "." + this._tableName : this._tableName) : this._catalog + "." + this._owner + "." + this._tableName);
        return string;
    }

    void setPrompt(boolean bl) {
        this._promptForData = bl;
    }

    boolean getPrompt() {
        return this._promptForData;
    }

    void setAppend(boolean bl) {
        this._append = bl;
    }

    boolean getAppend() {
        return this._append;
    }

    void setVerbose(boolean bl) {
        this._verbose = bl;
    }

    boolean getVerbose() {
        return this._verbose;
    }

    static int getFormatCode(String string) {
        int n = 0;
        if (string != null && string.length() != 0) {
            int n2 = _formatTable.length;
            for (int i = 0; i < n2; ++i) {
                if (!string.equalsIgnoreCase(InputOutputOptions._formatTable[i].name)) continue;
                n = InputOutputOptions._formatTable[i].code;
                break;
            }
        }
        return n;
    }

    static String getFormatName(int n) {
        String string = null;
        int n2 = _formatTable.length;
        for (int i = 0; i < n2; ++i) {
            if (InputOutputOptions._formatTable[i].code != n) continue;
            string = InputOutputOptions._formatTable[i].name;
            break;
        }
        if (string == null) {
            string = "Format " + n;
        }
        return string;
    }

    void setEncoding(String string) {
        this._encoding = string;
    }

    String getEncoding() {
        return this._encoding;
    }

    String getSystemEncoding() {
        return System.getProperty("file.encoding");
    }

    static Vector<String> getEncodingListForDisplay() {
        return InputOutputOptions.getEncodingListForDisplay(false, null);
    }

    boolean getEscapes() {
        return this._escapes;
    }

    void setEscapes(boolean bl) {
        this._escapes = bl;
    }

    static Vector<String> getEncodingListForDisplay(boolean bl, String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = ISQLResource.getISQLString(GeneralResources.getName(), "IWDefaultEncoding");
        vector.add(string2);
        if (bl) {
            SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
            Iterator<String> iterator = sortedMap.keySet().iterator();
            while (iterator.hasNext()) {
                Charset charset = (Charset)sortedMap.get(iterator.next());
                vector.add(charset.name());
            }
        } else {
            String string3 = string;
            if (!(string3 == null || string3.length() <= 0 || string3.equalsIgnoreCase(string2) || string3.equalsIgnoreCase("UTF-8") || string3.equalsIgnoreCase("UTF-16"))) {
                vector.add(string3);
            }
            vector.add("UTF-8");
            vector.add("UTF-16");
        }
        return vector;
    }

    TextImporter.Reader getSQLReader() {
        return this._sqlReader;
    }

    void setSQLReader(TextImporter.Reader reader) {
        this._sqlReader = reader;
    }

    void setConnectionString(String string) {
        this._connectionString = string;
    }

    String getConnectionString() {
        return this._connectionString;
    }

    void setDontCreateTable(boolean bl) {
        this._dontCreateTable = bl;
    }

    boolean getDontCreateTable() {
        return this._dontCreateTable;
    }

    static class IOFormatInfo {
        final String name;
        final int code;

        IOFormatInfo(String string, int n) {
            this.name = string;
            this.code = n;
        }
    }
}

