/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.EventQueuePumper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import sybase.isql.ErrorMessages;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLResource;
import sybase.isql.Importer;
import sybase.isql.ImporterFailedException;
import sybase.isql.ImporterFileFormatException;
import sybase.isql.ImporterMissingMetaDataException;
import sybase.isql.InputOutputOptions;
import sybase.isql.InteractiveImporter;
import sybase.isql.ODBCImporter;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;
import sybase.isql.SQLImporter;
import sybase.isql.TextImporter;
import sybase.isql.WindowManager;
import sybase.isql.isql;

class InputStatement {
    InputStatement() {
    }

    static boolean keepGoing(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame;
        boolean bl = true;
        if (isql.options.useGUI && (parentFrame = WindowManager.findFrameByConnection(iSQLConnection)) != null) {
            EventQueuePumper.pump((EventQueuePumper.Condition)new EventQueuePumper.Condition(){

                public boolean keepGoing() {
                    return !parentFrame.isInterruptRequested(0);
                }
            });
            if (parentFrame.isInterruptRequested(0)) {
                parentFrame.clearInterrupt(0);
                bl = false;
                isql.getIO(iSQLConnection).showProgress(null, -1);
                isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "Operation was cancelled"), 0);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execute(ISQLConnection iSQLConnection, InputOutputOptions inputOutputOptions) throws ImporterFailedException {
        block47: {
            Importer importer = null;
            if (iSQLConnection == null) {
                isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "You are not connected to a database."), 0);
            } else if (iSQLConnection instanceof ISQLConnectionImpl && !((ISQLConnectionImpl)iSQLConnection).isMetaDataAvailable()) {
                isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "ImporterMissingMetaData"), 1);
            } else {
                boolean bl;
                int n = InputStatement.getFormat(iSQLConnection, inputOutputOptions.getFileName(), inputOutputOptions.getFormat());
                inputOutputOptions.setFormat(n);
                switch (n) {
                    case 1: 
                    case 2: {
                        importer = new TextImporter(inputOutputOptions);
                        break;
                    }
                    case 12: {
                        importer = new InteractiveImporter(inputOutputOptions);
                        break;
                    }
                    case 4: {
                        importer = new SQLImporter(inputOutputOptions);
                        break;
                    }
                    case 14: {
                        importer = new ODBCImporter(inputOutputOptions);
                    }
                }
                if (importer == null) {
                    return;
                }
                try {
                    bl = importer.open(iSQLConnection);
                    if (!bl) {
                        return;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new ImporterFailedException(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not find \"{0}\"", inputOutputOptions.getFileName()), fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ImporterFailedException(ISQLResource.getFormattedString(ErrorMessages.getName(), "EncodingNotSupported", inputOutputOptions.getEncoding()), unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    throw new ImporterFailedException(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANT_INPUT_FROM_FILE", inputOutputOptions.getFileName(), iOException.getLocalizedMessage()), iOException);
                }
                try {
                    ParentFrame parentFrame;
                    importer.readMetaData(iSQLConnection);
                    bl = importer.createTable(iSQLConnection);
                    if (!bl) {
                        return;
                    }
                    if (isql.options.useGUI && (parentFrame = WindowManager.findFrameByConnection(iSQLConnection)) != null) {
                        parentFrame.setInputStatementInProgress(true);
                        try {
                            bl = importer.populateTable(iSQLConnection);
                            break block47;
                        }
                        finally {
                            parentFrame.setInputStatementInProgress(false);
                        }
                    }
                    bl = importer.populateTable(iSQLConnection);
                }
                catch (IOException iOException) {
                    isql.getIO(iSQLConnection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "The following file I/O error occured:\n{0}", inputOutputOptions.getFileName()), 2);
                }
                catch (SQLException sQLException) {
                    isql.getIO(iSQLConnection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "CouldNotCreateTable", sQLException.getLocalizedMessage()), 2);
                }
                catch (ImporterFileFormatException importerFileFormatException) {
                    isql.getIO(iSQLConnection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not import {0}.\nThe file may be in an unsupported format, or it could be corrupt.", inputOutputOptions.getFileName()), 2);
                }
                catch (ImporterMissingMetaDataException importerMissingMetaDataException) {
                    isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "ImporterMissingMetaData"), 1);
                }
                finally {
                    try {
                        importer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    static int getFormat(ISQLConnection iSQLConnection, String string, int n) {
        if (n == 0 && (n = TextImporter.guessFormat(string)) == 0 && (n = Preferences.getFileFormatCode(iSQLConnection, "input_format")) == 0) {
            n = 1;
        }
        return n;
    }
}

