/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.asa.logon.LogonDialogClient;
import com.sybase.asa.logon.LogonSource;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.KeySelectionHelper;
import com.sybase.util.MRUComboBox;
import com.sybase.util.NumericTextField;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import sybase.isql.ColWidthTable;
import sybase.isql.DataTypeMetaData;
import sybase.isql.ErrorMessages;
import sybase.isql.ExportWizard;
import sybase.isql.GeneralResources;
import sybase.isql.HistoryItem;
import sybase.isql.IO;
import sybase.isql.IOFilter;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLPanel;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.Importer;
import sybase.isql.ImporterFailedException;
import sybase.isql.ImporterFileFormatException;
import sybase.isql.ImporterMissingMetaDataException;
import sybase.isql.ImporterPreviewer;
import sybase.isql.InputOutputOptions;
import sybase.isql.InputStatement;
import sybase.isql.ParentFrame;
import sybase.isql.ParserUtils;
import sybase.isql.PluginMgr;
import sybase.isql.Preferences;
import sybase.isql.PreviewTable;
import sybase.isql.Ruler;
import sybase.isql.TableGenitor;
import sybase.isql.TableInfo;
import sybase.isql.isql;

class InputStatementWizard
extends JDialog
implements ActionListener,
TableGenitor {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String SHOW_NEXT_BUTTON = "Next";
    private static final String SHOW_IMPORT_BUTTON = "Import";
    private static final String SHOW_ABORT_BUTTON = "Abort";
    private static final String SHOW_CLOSE_BUTTON = "Close";
    private static final int DEFAULT_COLUMN_TYPE = 12;
    private static final int DEFAULT_COLUMN_PRECISION = 254;
    private static final int DEFAULT_COLUMN_SCALE = 6;
    static InputStatementWizard TheWizard = null;
    private static boolean _retcode;
    private boolean _aborted = false;
    private ISQLResource _bundle;
    private ISQLConnection _connection;
    private CardLayout _nextOrImportPanelLayout;
    private JPanel _nextOrImportPanel;
    private JPanel _cardPanel;
    private CardLayout _cardPanelLayout;
    private SybButton _backButton;
    private SybButton _nextButton;
    private SybButton _importButton;
    private SybButton _cancelButton;
    private SybButton _abortButton;
    private SybButton _closeButton;
    private InputOutputOptions _options;
    private Object _disabledControlsCookie = null;
    private boolean _inputFromFile = true;
    private String _srcConnectionParameters = null;
    private String _secureSrcConnectionParameters = null;
    private Connection _srcConnection = null;
    private boolean _srcSQLNeedsSchema = true;
    private boolean _srcSQLNeedsCatalog = false;
    private String _srcSQLCatalogSeparator = null;
    private String _srcIdentifierQuoteString = null;
    private static final String SOURCE_TYPE_PANEL = "sourceType";
    private static final String TABLE_NAME_PANEL = "tableName";
    private static final String ASCII_PANEL = "asciiOptions";
    private static final String COLWIDTH_PANEL = "colWidthOptions";
    private static final String TEXT_FORMAT_PANEL = "textFormat";
    private static final String COLUMN_DETAILS_PANEL = "columnDetails";
    private static final String DSN_PANEL = "DSN_PANEL";
    private static final String SOURCE_TABLE_PANEL = "SOURCE_TABLE_PANEL";
    private static final String STATUS_PANEL = "STATUS_PANEL";
    private WizardPanel _tableNamePanel;
    private WizardPanel _textFormatPanel;
    private WizardPanel _colWidthPanel;
    private WizardPanel _asciiPanel;
    private WizardPanel _columnDetailsPanel;
    private WizardPanel _sourceTablePanel;
    private boolean _isCreatingNewTable = false;
    private String[] _columnNames = null;
    private DataTypeMetaData[] _columnTypeMetaData = null;
    private int[] _columnWidths = null;
    private int _columnCount = -1;
    private int[] _newTableColumnPrecisions = null;
    private int[] _newTableColumnScales = null;
    private DataTypeMetaData[] _newDataTypeMetaData = null;
    private TableInfo _existingTableMetaData = null;
    private boolean[] _isColumnInPrimaryKey = null;
    private boolean[] _isNullableColumn = null;

    static boolean create(JFrame jFrame, ISQLConnection iSQLConnection, InputOutputOptions inputOutputOptions) {
        _retcode = false;
        InputStatementWizard inputStatementWizard = new InputStatementWizard(jFrame, iSQLConnection, inputOutputOptions);
        UIUtils.ensureWindowIsVisible((Window)inputStatementWizard);
        inputStatementWizard.setVisible(true);
        inputStatementWizard.destroy();
        return _retcode;
    }

    private InputStatementWizard(JFrame jFrame, ISQLConnection iSQLConnection, InputOutputOptions inputOutputOptions) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        TheWizard = this;
        this._options = inputOutputOptions;
        this._connection = iSQLConnection;
        this._bundle = ISQLResource.getISQLResource(GeneralResources.getName());
        this.createGUI();
        this.setLocationRelativeTo(jFrame);
    }

    private void createGUI() {
        this._cardPanelLayout = new CardLayout();
        this._cardPanel = new JPanel(this._cardPanelLayout);
        this._sourceTablePanel = new SourceTablePage();
        this._cardPanel.add((Component)new SourceTypePanel(), SOURCE_TYPE_PANEL);
        this._cardPanel.add((Component)new DSNPage(), DSN_PANEL);
        this._cardPanel.add((Component)this._sourceTablePanel, SOURCE_TABLE_PANEL);
        this._textFormatPanel = new TextFormatPanel();
        this._tableNamePanel = new TableNamePanel();
        this._colWidthPanel = new ColWidthPanel();
        this._asciiPanel = new AsciiPanel();
        this._columnDetailsPanel = new ColumnDetailsPanel();
        this._cardPanel.add((Component)this._textFormatPanel, TEXT_FORMAT_PANEL);
        this._cardPanel.add((Component)this._tableNamePanel, TABLE_NAME_PANEL);
        this._cardPanel.add((Component)this._colWidthPanel, COLWIDTH_PANEL);
        this._cardPanel.add((Component)this._asciiPanel, ASCII_PANEL);
        this._cardPanel.add((Component)this._columnDetailsPanel, COLUMN_DETAILS_PANEL);
        this._cardPanel.add((Component)new StatusPanel(), STATUS_PANEL);
        this._cardPanelLayout.show(this._cardPanel, SOURCE_TYPE_PANEL);
        this.getSelectedPage().initialize();
        this.getSelectedPage().setInitialized(true);
        this._backButton = new SybButton(this._bundle.getISQLString("< Back"));
        this._backButton.setEnabled(false);
        this._nextButton = new SybButton(this._bundle.getISQLString("Next >"));
        this.getRootPane().setDefaultButton((JButton)this._nextButton);
        this._importButton = new SybButton(this._bundle.getISQLString("IW_IMPORT_BUTTON"));
        this._abortButton = new SybButton(this._bundle.getISQLString("IW_ABORT_BUTTON"));
        this._closeButton = new SybButton(this._bundle.getISQLString("IW_CLOSE_BUTTON"));
        this._cancelButton = new SybButton(this._bundle.getISQLString("Cancel"));
        this._nextOrImportPanelLayout = new CardLayout();
        this._nextOrImportPanel = new JPanel(this._nextOrImportPanelLayout);
        this._nextOrImportPanel.add((Component)this._nextButton, SHOW_NEXT_BUTTON);
        this._nextOrImportPanel.add((Component)this._importButton, SHOW_IMPORT_BUTTON);
        this._nextOrImportPanel.add((Component)this._abortButton, SHOW_ABORT_BUTTON);
        this._nextOrImportPanel.add((Component)this._closeButton, SHOW_CLOSE_BUTTON);
        Dimension dimension = this._nextOrImportPanel.getMinimumSize();
        this._nextOrImportPanel.setMaximumSize(dimension);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this._backButton.addActionListener((ActionListener)this);
        this._nextButton.addActionListener((ActionListener)this);
        this._importButton.addActionListener((ActionListener)this);
        this._abortButton.addActionListener((ActionListener)this);
        this._closeButton.addActionListener((ActionListener)this);
        this._cancelButton.addActionListener((ActionListener)this);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._backButton, this._nextButton, this._importButton, this._cancelButton, this._abortButton, this._closeButton});
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.controlShadow), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)this._backButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this._nextOrImportPanel);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add((Component)this._cancelButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this._cardPanel, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBackground(SystemColor.window);
        this.setContentPane(jPanel2);
        this.setTitle(this._bundle.getISQLString("Import Wizard"));
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    private void destroy() {
        if (this._srcConnection != null) {
            try {
                this._srcConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._srcConnection = null;
        }
        Component[] componentArray = this._cardPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            WizardPanel wizardPanel = (WizardPanel)componentArray[i];
            wizardPanel.destroy();
        }
        TheWizard = null;
        this._connection = null;
        this._cardPanel = null;
        this._closeButton.removeActionListener((ActionListener)this);
        this._closeButton = null;
        this._abortButton.removeActionListener((ActionListener)this);
        this._abortButton = null;
        this._backButton.removeActionListener((ActionListener)this);
        this._backButton = null;
        this._nextButton.removeActionListener((ActionListener)this);
        this._nextButton = null;
        this._importButton.removeActionListener((ActionListener)this);
        this._importButton = null;
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._cancelButton.removeActionListener((ActionListener)this);
        this._cancelButton = null;
        this._options = null;
        this._columnNames = null;
        this._columnTypeMetaData = null;
        this._columnWidths = null;
        this._disabledControlsCookie = null;
        this._sourceTablePanel = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._backButton) {
            this.handleBack();
        } else if (object == this._nextButton) {
            this.handleNext();
        } else if (object == this._importButton) {
            this.handleImport();
        } else if (object == this._cancelButton) {
            this.handleCancel();
        } else if (object == this._closeButton) {
            this.setVisible(false);
        } else if (object == this._abortButton) {
            this.handleAbort();
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    private void handleAbort() {
        this._abortButton.setEnabled(false);
        ParentFrame parentFrame = (ParentFrame)SwingUtilities.getAncestorOfClass(ParentFrame.class, this);
        parentFrame.requestInterrupt(0);
        this._aborted = true;
    }

    private WizardPanel getSelectedPage() {
        WizardPanel wizardPanel = null;
        Component[] componentArray = this._cardPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            wizardPanel = (WizardPanel)componentArray[i];
            break;
        }
        return wizardPanel;
    }

    private void handleBack() {
        WizardPanel wizardPanel = this.getSelectedPage();
        wizardPanel.commit();
        String string = wizardPanel.getPreviousPageID();
        this._cardPanelLayout.show(this._cardPanel, string);
        wizardPanel = this.getSelectedPage();
        wizardPanel.setInitialFocus();
        this._backButton.setEnabled(wizardPanel.getPreviousPageID() != null);
        this._nextOrImportPanelLayout.show(this._nextOrImportPanel, SHOW_NEXT_BUTTON);
        this.getRootPane().setDefaultButton((JButton)this._nextButton);
    }

    private void handleNext() {
        String string;
        WizardPanel wizardPanel = this.getSelectedPage();
        this.disableDialogControls();
        wizardPanel.commit();
        boolean bl = wizardPanel.hasValidData();
        this.enableDialogControls();
        if (bl && (string = wizardPanel.getNextPageID()) != null) {
            this._cardPanelLayout.show(this._cardPanel, string);
            this._backButton.setEnabled(true);
            wizardPanel = this.getSelectedPage();
            if (!wizardPanel.isInitialized()) {
                this.disableDialogControls();
                wizardPanel.initialize();
                this.enableDialogControls();
                wizardPanel.setInitialized(true);
            }
            wizardPanel.setInitialFocus();
            if (wizardPanel.getNextPageID() != null) {
                this._nextOrImportPanelLayout.show(this._nextOrImportPanel, SHOW_NEXT_BUTTON);
                this.getRootPane().setDefaultButton((JButton)this._nextButton);
            } else {
                this._nextOrImportPanelLayout.show(this._nextOrImportPanel, SHOW_IMPORT_BUTTON);
                this.getRootPane().setDefaultButton((JButton)this._importButton);
            }
        }
    }

    private void handleImport() {
        WizardPanel wizardPanel = this.getSelectedPage();
        this.disableDialogControls();
        wizardPanel.commit();
        boolean bl = wizardPanel.hasValidData();
        this.enableDialogControls();
        if (bl) {
            this._backButton.setEnabled(false);
            this._cancelButton.setEnabled(false);
            this._nextOrImportPanelLayout.show(this._nextOrImportPanel, SHOW_ABORT_BUTTON);
            this.getRootPane().setDefaultButton(null);
            this._cardPanelLayout.show(this._cardPanel, STATUS_PANEL);
            wizardPanel = this.getSelectedPage();
            wizardPanel.initialize();
            this._nextOrImportPanelLayout.show(this._nextOrImportPanel, SHOW_CLOSE_BUTTON);
            this.getRootPane().setDefaultButton((JButton)this._closeButton);
            ((StatusPanel)wizardPanel).setFocusToMessageList();
        }
    }

    private void disableDialogControls() {
        this._disabledControlsCookie = DialogUtils.disableControls((Container)this.getContentPane());
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void enableDialogControls() {
        DialogUtils.enableControls((Object)this._disabledControlsCookie);
        this._disabledControlsCookie = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void setPreviewTableSize(JTable jTable, JScrollPane jScrollPane) {
        Dimension dimension = jTable.getPreferredScrollableViewportSize();
        dimension.height = 6 * jTable.getRowHeight();
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (jTableHeader != null) {
            TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, "X", false, false, 0, 0);
            dimension.height += component.getPreferredSize().height;
        }
        jScrollPane.getViewport().setMinimumSize(dimension);
        jScrollPane.setAlignmentX(0.0f);
    }

    private void createDatabaseTable() throws ImporterFailedException {
        TableGenitor tableGenitor;
        boolean bl = false;
        String string = null;
        Importer importer = this._options.getImporter();
        if (importer instanceof ImporterPreviewer) {
            tableGenitor = this;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this._columnCount; ++i) {
                vector.add(this._columnNames[i]);
            }
            this._options.setColumnList(vector);
        } else {
            tableGenitor = null;
            try {
                bl = importer.open(this._connection);
                if (!bl) {
                    throw new ImporterFailedException(this._bundle.getISQLString("IW_SOURCE_COULD_NOT_BE_OPENED"));
                }
                importer.readMetaData(this._connection);
                tableGenitor = (TableGenitor)((Object)importer);
            }
            catch (IOException iOException) {
                string = iOException.getLocalizedMessage();
            }
            catch (ImporterFileFormatException importerFileFormatException) {
                string = importerFileFormatException.getLocalizedMessage();
            }
            catch (ImporterMissingMetaDataException importerMissingMetaDataException) {
                string = ISQLResource.getISQLString(ErrorMessages.getName(), "ImporterMissingMetaData");
            }
            catch (ImporterFailedException importerFailedException) {
                string = importerFailedException.getLocalizedMessage();
            }
        }
        if (tableGenitor != null) {
            try {
                this._connection.createTable(this._options.getCatalog(), this._options.getOwner(), this._options.getTableName(), tableGenitor);
                bl = true;
            }
            catch (SQLException sQLException) {
                string = sQLException.getLocalizedMessage();
                bl = false;
            }
        } else {
            bl = false;
        }
        try {
            importer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!bl) {
            if (string == null) {
                string = "";
            }
            throw new ImporterFailedException(string);
        }
    }

    @Override
    public boolean knowsColumnNames() {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    @Override
    public DataTypeMetaData getColumnTypeMetaData(int n) {
        if (this._isCreatingNewTable) {
            return this._newDataTypeMetaData[n];
        }
        return this._columnTypeMetaData[n];
    }

    @Override
    public int getColumnWidth(int n) {
        int n2 = this._newTableColumnPrecisions != null ? this._newTableColumnPrecisions[n] : (this._columnTypeMetaData[n].getSQLType() == 3 || this._columnTypeMetaData[n].getSQLType() == 2 ? 30 : 254);
        return n2;
    }

    @Override
    public int getColumnScale(int n) {
        if (this._newTableColumnScales != null) {
            return this._newTableColumnScales[n];
        }
        return 6;
    }

    @Override
    public boolean isColumnInPrimaryKey(int n) {
        return this._isColumnInPrimaryKey != null && this._isColumnInPrimaryKey[n];
    }

    @Override
    public boolean isNullableColumn(int n) {
        return this._isNullableColumn != null && this._isNullableColumn[n];
    }

    @Override
    public Vector<Object> getRowData() {
        return null;
    }

    @Override
    public boolean moveNext() {
        return false;
    }

    @Override
    public boolean keepGoing(ISQLConnection iSQLConnection) {
        return true;
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    static String readLine(InputStreamReader inputStreamReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(512);
        while (true) {
            int n;
            if ((n = inputStreamReader.read()) == -1) {
                if (stringBuffer.length() != 0) break;
                return null;
            }
            if (n == 13) {
                inputStreamReader.read();
                break;
            }
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String[] getColumnNames() {
        if (this._columnNames == null) {
            this.initializeColumnMetaData();
        }
        return this._columnNames;
    }

    public int[] getColumnWidths() {
        if (this._columnWidths == null) {
            int n = this.getColumnCount();
            this._columnWidths = new int[n];
            Arrays.fill(this._columnWidths, 1);
        }
        return this._columnWidths;
    }

    @Override
    public int getColumnCount() {
        int n;
        if (this._columnWidths != null) {
            n = this._columnWidths.length;
        } else if (!this._isCreatingNewTable && !this._options.getColumnList().isEmpty()) {
            n = this._options.getColumnList().size();
        } else {
            ImporterPreviewer importerPreviewer;
            if (this._columnCount == -1 && (importerPreviewer = this._options.getImporterPreviewer()) != null) {
                try {
                    this._columnCount = importerPreviewer.getPreviewColumnCount();
                }
                catch (ImporterFailedException importerFailedException) {
                    this._columnCount = 0;
                    SybOptionPane.showMessageDialog((Component)this, (Object)this._bundle.getFormattedString("IW_PREVIEW_COULD_NOT_BE_CREATED", importerFailedException.getLocalizedMessage()), (String)this._bundle.getISQLString("Import Wizard"), (int)0);
                }
            }
            n = this._columnCount;
        }
        return n;
    }

    private DataTypeMetaData getDefaultColumnTypeMetaData() {
        DataTypeMetaData dataTypeMetaData = null;
        DataTypeMetaData[] dataTypeMetaDataArray = this._connection.getDataTypes();
        for (int i = 0; i < dataTypeMetaDataArray.length; ++i) {
            if (!dataTypeMetaDataArray[i].getName().equalsIgnoreCase("varchar")) continue;
            dataTypeMetaData = dataTypeMetaDataArray[i];
            break;
        }
        if (dataTypeMetaData == null) {
            // empty if block
        }
        return dataTypeMetaData;
    }

    private void initializeColumnMetaData() {
        int n = this.getColumnCount();
        this._columnNames = new String[n];
        MessageFormat messageFormat = new MessageFormat(this._bundle.getISQLString("Column{0}"));
        for (int i = 0; i < n; ++i) {
            this._columnNames[i] = messageFormat.format(new Object[]{i + 1});
        }
        this._columnTypeMetaData = new DataTypeMetaData[n];
        Arrays.fill(this._columnTypeMetaData, this.getDefaultColumnTypeMetaData());
        this._isColumnInPrimaryKey = new boolean[n];
        Arrays.fill(this._isColumnInPrimaryKey, false);
        this._isNullableColumn = new boolean[n];
        Arrays.fill(this._isNullableColumn, true);
        this._newTableColumnPrecisions = new int[n];
        Arrays.fill(this._newTableColumnPrecisions, 254);
        this._newTableColumnScales = new int[n];
        Arrays.fill(this._newTableColumnScales, 6);
        this._newDataTypeMetaData = new DataTypeMetaData[n];
        Arrays.fill(this._newDataTypeMetaData, this.getDefaultColumnTypeMetaData());
    }

    private void fixupColumnMetaData() {
        MessageFormat messageFormat = null;
        if (this._columnNames == null) {
            this.initializeColumnMetaData();
        } else {
            int[] nArray;
            boolean[] blArray;
            int n = this.getColumnCount();
            int n2 = this._columnNames.length;
            String[] stringArray = new String[n];
            if (n < n2) {
                System.arraycopy(this._columnNames, 0, stringArray, 0, n);
            } else {
                System.arraycopy(this._columnNames, 0, stringArray, 0, n2);
                messageFormat = new MessageFormat(this._bundle.getISQLString("Column{0}"));
                for (int i = n2; i < n; ++i) {
                    stringArray[i] = messageFormat.format(new Object[]{i + 1});
                }
            }
            this._columnNames = stringArray;
            n2 = this._columnTypeMetaData.length;
            Object[] objectArray = new DataTypeMetaData[n];
            if (n < n2) {
                System.arraycopy(this._columnTypeMetaData, 0, objectArray, 0, n);
            } else {
                System.arraycopy(this._columnTypeMetaData, 0, objectArray, 0, n2);
                Arrays.fill(objectArray, n2, n, this.getDefaultColumnTypeMetaData());
            }
            this._columnTypeMetaData = objectArray;
            if (this._isColumnInPrimaryKey != null) {
                n2 = this._isColumnInPrimaryKey.length;
                blArray = new boolean[n];
                if (n < n2) {
                    System.arraycopy(this._isColumnInPrimaryKey, 0, blArray, 0, n);
                } else {
                    System.arraycopy(this._isColumnInPrimaryKey, 0, blArray, 0, n2);
                    Arrays.fill(blArray, n2, n, false);
                }
                this._isColumnInPrimaryKey = blArray;
            }
            if (this._isNullableColumn != null) {
                n2 = this._isNullableColumn.length;
                blArray = new boolean[n];
                if (n < n2) {
                    System.arraycopy(this._isNullableColumn, 0, blArray, 0, n);
                } else {
                    System.arraycopy(this._isNullableColumn, 0, blArray, 0, n2);
                    Arrays.fill(blArray, n2, n, true);
                }
                this._isNullableColumn = blArray;
            }
            if (this._newTableColumnPrecisions != null) {
                n2 = this._newTableColumnPrecisions.length;
                nArray = new int[n];
                if (n < n2) {
                    System.arraycopy(this._newTableColumnPrecisions, 0, nArray, 0, n);
                } else {
                    System.arraycopy(this._newTableColumnPrecisions, 0, nArray, 0, n2);
                    Arrays.fill(nArray, n2, n, 254);
                }
                this._newTableColumnPrecisions = nArray;
            }
            if (this._newTableColumnScales != null) {
                n2 = this._newTableColumnScales.length;
                nArray = new int[n];
                if (n < n2) {
                    System.arraycopy(this._newTableColumnScales, 0, nArray, 0, n);
                } else {
                    System.arraycopy(this._newTableColumnScales, 0, nArray, 0, n2);
                    Arrays.fill(nArray, n2, n, 6);
                }
                this._newTableColumnScales = nArray;
            }
            if (this._newDataTypeMetaData != null) {
                n2 = this._newDataTypeMetaData.length;
                objectArray = new DataTypeMetaData[n];
                if (n < n2) {
                    System.arraycopy(this._newDataTypeMetaData, 0, objectArray, 0, n);
                } else {
                    System.arraycopy(this._newDataTypeMetaData, 0, objectArray, 0, n2);
                    Arrays.fill(objectArray, n2, n, null);
                }
                this._newDataTypeMetaData = objectArray;
            }
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static /* synthetic */ int[] access$402(InputStatementWizard inputStatementWizard, int[] nArray) {
        inputStatementWizard._columnWidths = nArray;
        return nArray;
    }

    static /* synthetic */ String[] access$502(InputStatementWizard inputStatementWizard, String[] stringArray) {
        inputStatementWizard._columnNames = stringArray;
        return stringArray;
    }

    static /* synthetic */ DataTypeMetaData[] access$602(InputStatementWizard inputStatementWizard, DataTypeMetaData[] dataTypeMetaDataArray) {
        inputStatementWizard._columnTypeMetaData = dataTypeMetaDataArray;
        return dataTypeMetaDataArray;
    }

    static /* synthetic */ boolean[] access$702(InputStatementWizard inputStatementWizard, boolean[] blArray) {
        inputStatementWizard._isColumnInPrimaryKey = blArray;
        return blArray;
    }

    static /* synthetic */ boolean[] access$802(InputStatementWizard inputStatementWizard, boolean[] blArray) {
        inputStatementWizard._isNullableColumn = blArray;
        return blArray;
    }

    class StatusPanel
    extends WizardPanel {
        private ExportWizard.InstructionLabel _iLabel;
        private JProgressBar _progressBar;
        private SybLabel _text;
        private JTextArea _messages;
        private ExportWizard.GradientPanel _gradientPanel;

        StatusPanel() {
            this.setName(InputStatementWizard.STATUS_PANEL);
            this.setLayout(new GridBagLayout());
            this._iLabel = new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("IW_STATUS_PANEL_INSTRUCTION"));
            this._gradientPanel = new ExportWizard.GradientPanel(new GridBagLayout());
            this._gradientPanel.setGradientColor(Color.blue);
            this._gradientPanel.add((Component)((Object)this._iLabel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)this._gradientPanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
            this._text = new SybLabel();
            this._text.setText("MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM");
            new FontHelper((JLabel)this._text);
            Dimension dimension = this._text.getPreferredSize();
            this._text.setMinimumSize(dimension);
            this._text.setText(" ");
            this.add((Component)this._text, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 30, 5, 30), 0, 0));
            this._progressBar = new JProgressBar();
            this._progressBar.setIndeterminate(true);
            this.add((Component)this._progressBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 30, 0, 30), 0, 0));
            this._messages = new JTextArea();
            this._messages.setLineWrap(true);
            this._messages.setWrapStyleWord(true);
            this._messages.setEditable(false);
            this._messages.setFont(this._text.getFont());
            new FontHelper((JTextComponent)this._messages);
            JScrollPane jScrollPane = new JScrollPane(this._messages);
            this.add((Component)jScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 21, 1, new Insets(10, 30, 0, 30), 0, 0));
        }

        @Override
        void initialize() {
            boolean bl;
            MyIOFilter myIOFilter = new MyIOFilter(isql.getIO(InputStatementWizard.this._connection));
            isql.setIO(InputStatementWizard.this._connection, myIOFilter);
            this.addEquivalentSQLToHistory();
            if (InputStatementWizard.this._options.getFormat() == 14) {
                InputStatementWizard.this._options.setConnectionString(InputStatementWizard.this._srcConnectionParameters);
            }
            if (InputStatementWizard.this._isCreatingNewTable) {
                try {
                    InputStatementWizard.this.createDatabaseTable();
                    bl = true;
                }
                catch (ImporterFailedException importerFailedException) {
                    bl = false;
                    myIOFilter.writeln(ISQLResource.getFormattedString(GeneralResources.getName(), "Could not create table \"{0}\"\n{1}", InputStatementWizard.this._options.getTableName(), importerFailedException.getMessage()), 2);
                }
            } else {
                bl = true;
            }
            if (bl) {
                try {
                    InputStatement.execute(InputStatementWizard.this._connection, InputStatementWizard.this._options);
                    bl = true;
                }
                catch (ImporterFailedException importerFailedException) {
                    myIOFilter.writeln(importerFailedException.getLocalizedMessage(), 2);
                    bl = false;
                }
            }
            isql.setIO(InputStatementWizard.this._connection, myIOFilter.getOriginalIO());
            this._progressBar.setIndeterminate(false);
            this._progressBar.setValue(this._progressBar.getMaximum());
            if (bl) {
                if (!InputStatementWizard.this._aborted) {
                    this._gradientPanel.setGradientColor(Color.green);
                    this._iLabel.setText(InputStatementWizard.this._bundle.getISQLString("IW_STATUS_PANEL_IMPORT_COMPLETED"));
                    this._iLabel.setIcon(new ExportWizard.OKIcon(24));
                } else {
                    this._gradientPanel.setGradientColor(Color.orange.darker());
                    this._iLabel.setText(InputStatementWizard.this._bundle.getISQLString("IW_STATUS_PANEL_IMPORT_ABORTED"));
                    this._iLabel.setIcon(new ExportWizard.WarningIcon(24));
                }
                Component[] componentArray = InputStatementWizard.this._cardPanel.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    WizardPanel wizardPanel = (WizardPanel)componentArray[i];
                    wizardPanel.saveMRULists();
                }
                _retcode = true;
            } else {
                this._gradientPanel.setGradientColor(Color.red);
                this._iLabel.setText(InputStatementWizard.this._bundle.getISQLString("IW_STATUS_PANEL_IMPORT_FAILED"));
                this._iLabel.setIcon(new ExportWizard.ErrorIcon(24));
            }
            this._iLabel.setIconTextGap(10);
        }

        private void addEquivalentSQLToHistory() {
            int n = InputStatementWizard.this._options.getFormat();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(InputStatementWizard.this._bundle.getISQLString("IW_STATUS_PANEL_SQL_COMMENT"));
            stringBuilder.append("input ");
            if (n == 14) {
                stringBuilder.append("using '");
                if (InputStatementWizard.this._secureSrcConnectionParameters != null) {
                    stringBuilder.append(ParserUtils.escapeApostrophes(InputStatementWizard.this._secureSrcConnectionParameters));
                }
                stringBuilder.append("' from \"");
                if (((InputStatementWizard)InputStatementWizard.this)._options.odbcCatalog != null) {
                    stringBuilder.append(((InputStatementWizard)InputStatementWizard.this)._options.odbcCatalog);
                    stringBuilder.append('.');
                }
                if (((InputStatementWizard)InputStatementWizard.this)._options.odbcSchema == null) {
                    if (((InputStatementWizard)InputStatementWizard.this)._options.odbcCatalog != null) {
                        stringBuilder.append('.');
                    }
                } else {
                    stringBuilder.append(((InputStatementWizard)InputStatementWizard.this)._options.odbcSchema);
                    stringBuilder.append('.');
                }
                stringBuilder.append(((InputStatementWizard)InputStatementWizard.this)._options.odbcTableName);
                stringBuilder.append("\" into ");
                stringBuilder.append(InputStatementWizard.this._options.getQuotedOwnerAndTableName(InputStatementWizard.this._connection));
                stringBuilder.append(" create table ");
                if (InputStatementWizard.this._isCreatingNewTable) {
                    stringBuilder.append("on");
                } else {
                    stringBuilder.append("off");
                }
            } else {
                stringBuilder.append("into ");
                stringBuilder.append(InputStatementWizard.this._options.getQuotedOwnerAndTableName(InputStatementWizard.this._connection));
                stringBuilder.append(" from '");
                stringBuilder.append(ParserUtils.escapeFileName(InputStatementWizard.this._options.getFileName()));
                stringBuilder.append("'");
                if (n == 1) {
                    stringBuilder.append(" format ascii");
                    if (InputStatementWizard.this._options.getEscapes()) {
                        stringBuilder.append(" escapes on escape character '");
                        char c = InputStatementWizard.this._options.getEscapeCharacter();
                        stringBuilder.append(c);
                        if (c == '\\') {
                            stringBuilder.append(c);
                        }
                        stringBuilder.append("'");
                    }
                    if (InputStatementWizard.this._options.getDelimiter() != null) {
                        stringBuilder.append(" delimited by '");
                        stringBuilder.append(InputStatementWizard.this._options.getDelimiter());
                        stringBuilder.append("'");
                    }
                    if (InputStatementWizard.this._options.getEncoding() != null) {
                        stringBuilder.append(" encoding '");
                        stringBuilder.append(InputStatementWizard.this._options.getEncoding());
                        stringBuilder.append("'");
                    }
                    if (InputStatementWizard.this._options.getNoStrip()) {
                        stringBuilder.append(" nostrip");
                    }
                } else if (n == 2) {
                    stringBuilder.append(" format fixed");
                    int n2 = InputStatementWizard.this._options.getColumnWidthCount();
                    if (n2 > 0) {
                        stringBuilder.append(" column widths(");
                        for (int i = 0; i < n2; ++i) {
                            if (i > 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append(InputStatementWizard.this._options.getColumnWidth(i));
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            String string = stringBuilder.toString();
            ParentFrame parentFrame = (ParentFrame)SwingUtilities.getAncestorOfClass(ParentFrame.class, this);
            parentFrame.getHistory().add(new HistoryItem(string));
        }

        @Override
        void commit() {
        }

        @Override
        boolean hasValidData() {
            return true;
        }

        @Override
        void setInitialFocus() {
        }

        @Override
        String getPreviousPageID() {
            return null;
        }

        @Override
        String getNextPageID() {
            return null;
        }

        @Override
        void destroy() {
            this._iLabel = null;
            this._progressBar = null;
            this._text = null;
            this._messages = null;
        }

        void setFocusToMessageList() {
            this._messages.requestFocusInWindow();
        }

        class MyIOFilter
        extends IOFilter
        implements Runnable {
            private Vector<String> _messages;
            private String _progress;

            MyIOFilter(IO iO) {
                super(iO);
                this._messages = new Vector();
            }

            @Override
            public synchronized void writeln(String string, int n) {
                this._messages.add(string);
                SwingUtilities.invokeLater(this);
            }

            @Override
            public synchronized void showProgress(String string, int n) {
                this._progress = string;
                SwingUtilities.invokeLater(this);
            }

            @Override
            public synchronized void run() {
                if (this._progress != null) {
                    StatusPanel.this._text.setText(this._progress);
                    this._progress = null;
                }
                while (this._messages.size() > 0) {
                    String string = this._messages.get(0);
                    this._messages.remove(0);
                    StatusPanel.this._messages.append(string);
                    StatusPanel.this._messages.append("\n");
                }
                StatusPanel.this._messages.setCaretPosition(StatusPanel.this._messages.getText().length());
            }
        }
    }

    class ColumnDetailsPanel
    extends WizardPanel
    implements ActionListener,
    DocumentListener,
    ListSelectionListener {
        private static final String EXISTING_TABLE_PANEL_NAME = "existing";
        private static final String NEW_TABLE_PANEL_NAME = "new";
        private PreviewTable _preview;
        private JTextField _columnName;
        private JTextField _columnType;
        private JComboBox _columnNameCombo;
        private JComboBox _columnTypeCombo;
        private int _selectedColumn;
        private boolean _columnsWereReordered;
        private DataTypeMetaData[] _typeMetaData;
        private SybCheckBox _primaryKeyCheckBox;
        private SybCheckBox _allowNULLsCheckBox;
        private SybLabel _maxLengthLabel;
        private NumericTextField _maxLengthField;
        private SybLabel _precisionLabel;
        private NumericTextField _precisionField;
        private SybLabel _scaleLabel;
        private NumericTextField _scaleField;
        private JPanel _cardPanel;
        private boolean _ignoreEvents;

        ColumnDetailsPanel() {
            this._selectedColumn = -1;
            this._columnsWereReordered = false;
            this._typeMetaData = null;
            this._primaryKeyCheckBox = null;
            this._allowNULLsCheckBox = null;
            this._maxLengthLabel = null;
            this._maxLengthField = null;
            this._precisionLabel = null;
            this._precisionField = null;
            this._scaleLabel = null;
            this._scaleField = null;
            this._cardPanel = null;
            this._ignoreEvents = false;
            this.setLayout(new BoxLayout(this, 1));
            ExportWizard.InstructionLabel instructionLabel = InputStatementWizard.this._isCreatingNewTable ? new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("Use this panel to assign the name and data type to each imported column.")) : new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("Use this panel to associate a database column with each imported column."));
            this.add((Component)((Object)instructionLabel));
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this._preview = new PreviewTable(InputStatementWizard.this._connection);
            this._preview.setColumnSelectionAllowed(true);
            this._preview.setRowSelectionAllowed(false);
            this._preview.getColumnModel().getSelectionModel().setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this._preview, 21, 32);
            InputStatementWizard.this.setPreviewTableSize(this._preview, jScrollPane);
            InputMap inputMap = this._preview.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), "null");
            inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "null");
            inputMap.put(KeyStroke.getKeyStroke("TAB"), "focusNext");
            inputMap.put(KeyStroke.getKeyStroke("shift TAB"), "focusPrevious");
            ActionMap actionMap = this._preview.getActionMap();
            actionMap.put("focusNext", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnDetailsPanel.this._preview.transferFocus();
                }
            });
            actionMap.put("focusPrevious", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnDetailsPanel.this._preview.transferFocusBackward();
                }
            });
            this.add(jScrollPane);
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            int n = 0;
            SybLabel sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("Column name:"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)sybLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            this._columnNameCombo = new JComboBox();
            this._columnNameCombo.setEditable(false);
            sybLabel.setLabelFor((Component)this._columnNameCombo);
            this._columnNameCombo.addActionListener(this);
            jPanel.add((Component)this._columnNameCombo, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 1.0;
            jPanel.add(Box.createGlue(), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("Data type:"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)sybLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            this._typeMetaData = InputStatementWizard.this._connection.getDataTypes();
            this._columnType = new JTextField(20);
            this._columnType.setEditable(false);
            sybLabel.setLabelFor((Component)this._columnType);
            jPanel.add((Component)this._columnType, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 3;
            jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            n = 0;
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("Column name:"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)sybLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            this._columnName = new JTextField(20);
            new FontHelper((JTextComponent)this._columnName);
            sybLabel.setLabelFor((Component)this._columnName);
            this._columnName.getDocument().addDocumentListener(this);
            jPanel2.add((Component)this._columnName, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add(Box.createGlue(), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("Data type:"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)sybLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            this._typeMetaData = InputStatementWizard.this._connection.getDataTypes();
            this._columnTypeCombo = new JComboBox<DataTypeMetaData>(this._typeMetaData);
            this._columnTypeCombo.setEditable(false);
            sybLabel.setLabelFor((Component)this._columnTypeCombo);
            this._columnTypeCombo.addActionListener(this);
            jPanel2.add((Component)this._columnTypeCombo, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            this._maxLengthLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IWColumnMaxLength"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)this._maxLengthLabel, gridBagConstraints);
            this._maxLengthField = new NumericTextField();
            this._maxLengthLabel.setLabelFor((Component)this._maxLengthField);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)this._maxLengthField, gridBagConstraints);
            this._maxLengthField.getDocument().addDocumentListener(this);
            gridBagConstraints.gridy = n++;
            this._precisionLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IWColumnPrecision"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)this._precisionLabel, gridBagConstraints);
            this._precisionField = new NumericTextField();
            this._precisionLabel.setLabelFor((Component)this._precisionField);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)this._precisionField, gridBagConstraints);
            this._precisionField.getDocument().addDocumentListener(this);
            gridBagConstraints.gridy = n++;
            this._scaleLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IWColumnScale"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)this._scaleLabel, gridBagConstraints);
            this._scaleField = new NumericTextField();
            this._scaleLabel.setLabelFor((Component)this._scaleField);
            this._scaleField.getDocument().addDocumentListener(this);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)this._scaleField, gridBagConstraints);
            n = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            jPanel2.add(Box.createHorizontalStrut(20), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            this._primaryKeyCheckBox = new SybCheckBox(InputStatementWizard.this._bundle.getISQLString("IWIsPrimaryKeyColumn"));
            this._primaryKeyCheckBox.setOpaque(false);
            this._primaryKeyCheckBox.addActionListener((ActionListener)this);
            jPanel2.add((Component)this._primaryKeyCheckBox, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            this._allowNULLsCheckBox = new SybCheckBox(InputStatementWizard.this._bundle.getISQLString("IWColumnAllowsNulls"));
            this._allowNULLsCheckBox.setOpaque(false);
            this._allowNULLsCheckBox.addActionListener((ActionListener)this);
            jPanel2.add((Component)this._allowNULLsCheckBox, gridBagConstraints);
            this._cardPanel = new JPanel(new CardLayout());
            this._cardPanel.setOpaque(false);
            this._cardPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(InputStatementWizard.this._bundle.getISQLString("Column properties")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            this._cardPanel.setAlignmentX(0.0f);
            this._cardPanel.add((Component)jPanel2, NEW_TABLE_PANEL_NAME);
            this._cardPanel.add((Component)jPanel, EXISTING_TABLE_PANEL_NAME);
            this.add(this._cardPanel);
            this.setName(InputStatementWizard.COLUMN_DETAILS_PANEL);
        }

        @Override
        public void initialize() {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, InputStatementWizard.this._isCreatingNewTable ? NEW_TABLE_PANEL_NAME : EXISTING_TABLE_PANEL_NAME);
            if (InputStatementWizard.this._columnNames == null) {
                InputStatementWizard.this.initializeColumnMetaData();
            }
            if (!InputStatementWizard.this._isCreatingNewTable) {
                int n = Math.min(((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column.length, InputStatementWizard.this._columnCount);
                for (int i = 0; i < n; ++i) {
                    ((InputStatementWizard)InputStatementWizard.this)._columnNames[i] = ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column[i].name;
                }
                this._columnNameCombo.setModel(new DefaultComboBoxModel<String>(this.getSortedColumnNames()));
            }
            this._preview.refresh(InputStatementWizard.this._options, InputStatementWizard.this._isCreatingNewTable);
            this.setColumnHeadingText();
            this._preview.getColumnModel().getSelectionModel().addListSelectionListener(this);
            if (this._preview.getColumnCount() > 0) {
                this._preview.setColumnSelectionInterval(0, 0);
                this._selectedColumn = 0;
            }
            this.enableControls();
        }

        @Override
        void destroy() {
            this._columnName.getDocument().removeDocumentListener(this);
            this._columnNameCombo.removeActionListener(this);
            this._columnTypeCombo.removeActionListener(this);
            this._preview.getColumnModel().getSelectionModel().removeListSelectionListener(this);
            this._primaryKeyCheckBox.removeActionListener((ActionListener)this);
            this._allowNULLsCheckBox.removeActionListener((ActionListener)this);
            this._maxLengthField.getDocument().removeDocumentListener(this);
            this._precisionField.getDocument().removeDocumentListener(this);
            this._scaleField.getDocument().removeDocumentListener(this);
            this._preview = null;
            this._columnName = null;
            this._columnType = null;
            this._columnNameCombo = null;
            this._columnTypeCombo = null;
            this._primaryKeyCheckBox = null;
            this._allowNULLsCheckBox = null;
            this._maxLengthLabel = null;
            this._maxLengthField = null;
            this._precisionLabel = null;
            this._precisionField = null;
            this._scaleLabel = null;
            this._scaleField = null;
            this._cardPanel = null;
        }

        @Override
        void setInitialFocus() {
            this._preview.requestFocusInWindow();
        }

        private String[] getSortedColumnNames() {
            int n = ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column.length;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column[i].name;
            }
            Arrays.sort(stringArray, new Comparator<String>(){
                Collator _collator = Collator.getInstance();

                @Override
                public int compare(String string, String string2) {
                    return this._collator.compare(string, string2);
                }
            });
            return stringArray;
        }

        @Override
        boolean hasValidData() {
            return true;
        }

        @Override
        void commit() {
            if (this._columnsWereReordered) {
                InputStatementWizard.this._options.setColumnMatchingTechnique(2);
                int n = InputStatementWizard.this._columnNames.length;
                Vector<String> vector = new Vector<String>(n);
                for (int i = 0; i < n; ++i) {
                    vector.addElement(InputStatementWizard.this._columnNames[i]);
                }
                InputStatementWizard.this._options.setColumnList(vector);
            }
        }

        private void setColumnHeadingText() {
            TableColumnModel tableColumnModel = this._preview.getColumnModel();
            String[] stringArray = InputStatementWizard.this.getColumnNames();
            int n = tableColumnModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                tableColumnModel.getColumn(i).setHeaderValue(stringArray[i]);
            }
            this._preview.getTableHeader().resizeAndRepaint();
        }

        private void refreshColumnProperties(int n) {
            if (InputStatementWizard.this._isCreatingNewTable) {
                this._ignoreEvents = true;
                this._columnName.setText(InputStatementWizard.this._columnNames[n]);
                DataTypeMetaData dataTypeMetaData = InputStatementWizard.this._newDataTypeMetaData[n];
                int n2 = dataTypeMetaData.getAnnotationFlags();
                int n3 = this._columnTypeCombo.getItemCount();
                for (int i = 0; i < n3; ++i) {
                    DataTypeMetaData dataTypeMetaData2 = (DataTypeMetaData)this._columnTypeCombo.getItemAt(i);
                    if (dataTypeMetaData != dataTypeMetaData2) continue;
                    this._columnTypeCombo.setSelectedIndex(i);
                    break;
                }
                if ((n2 & 1) != 0) {
                    this._maxLengthField.setText(Integer.toString(InputStatementWizard.this._newTableColumnPrecisions[n]));
                }
                if ((n2 & 2) != 0) {
                    this._precisionField.setText(Integer.toString(InputStatementWizard.this._newTableColumnPrecisions[n]));
                }
                if ((n2 & 4) != 0) {
                    this._scaleField.setText(Integer.toString(InputStatementWizard.this._newTableColumnScales[n]));
                }
                this._primaryKeyCheckBox.setSelected(InputStatementWizard.this._isColumnInPrimaryKey[n]);
                this._allowNULLsCheckBox.setSelected(InputStatementWizard.this._isNullableColumn[n]);
                this._ignoreEvents = false;
                this.enableControls();
            } else {
                String string = InputStatementWizard.this._columnNames[n];
                this._columnNameCombo.setSelectedItem(string);
                int n4 = -1;
                for (int i = 0; i < ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column.length; ++i) {
                    if (!((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column[i].name.equals(string)) continue;
                    n4 = i;
                    break;
                }
                if (n4 == -1) {
                    return;
                }
                int n5 = ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column[n4].type.getAnnotationFlags();
                String string2 = ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column[n4].type.getName();
                if ((n5 & 4) != 0) {
                    string2 = string2 + "(" + ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column[n4].width + "," + ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column[n4].scale + ")";
                } else if (n5 != 0) {
                    string2 = string2 + "(" + ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column[n4].width + ")";
                }
                this._columnType.setText(string2);
            }
        }

        private void enableControls() {
            if (InputStatementWizard.this._isCreatingNewTable) {
                int n = InputStatementWizard.this._columnTypeMetaData[this._selectedColumn].getAnnotationFlags();
                boolean bl = (n & 1) != 0;
                this._maxLengthLabel.setEnabled(bl);
                this._maxLengthField.setEnabled(bl);
                if (!bl) {
                    this._maxLengthField.setText("");
                }
                bl = (n & 2) != 0;
                this._precisionLabel.setEnabled(bl);
                this._precisionField.setEnabled(bl);
                if (!bl) {
                    this._precisionField.setText("");
                }
                bl = (n & 4) != 0;
                this._scaleLabel.setEnabled(bl);
                this._scaleField.setEnabled(bl);
                if (!bl) {
                    this._scaleField.setText("");
                }
                boolean bl2 = bl = this._primaryKeyCheckBox.isEnabled() && this._primaryKeyCheckBox.isSelected();
                if (bl) {
                    this._allowNULLsCheckBox.setEnabled(false);
                    this._allowNULLsCheckBox.setSelected(false);
                } else {
                    this._allowNULLsCheckBox.setEnabled(true);
                }
                boolean bl3 = bl = this._allowNULLsCheckBox.isEnabled() && this._allowNULLsCheckBox.isSelected();
                if (bl) {
                    this._primaryKeyCheckBox.setEnabled(false);
                    this._primaryKeyCheckBox.setSelected(false);
                } else {
                    this._primaryKeyCheckBox.setEnabled(true);
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                this._selectedColumn = listSelectionModel.getMinSelectionIndex();
                this.refreshColumnProperties(this._selectedColumn);
            } else {
                this._selectedColumn = -1;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._ignoreEvents) {
                return;
            }
            Object object = actionEvent.getSource();
            if (object == this._columnTypeCombo) {
                this.handleColumnTypeChange();
            } else if (object == this._columnNameCombo) {
                this.handleColumnNameChange();
            } else if (object == this._primaryKeyCheckBox) {
                ((InputStatementWizard)InputStatementWizard.this)._isColumnInPrimaryKey[this._selectedColumn] = this._primaryKeyCheckBox.isSelected();
                this.enableControls();
            } else if (object == this._allowNULLsCheckBox) {
                ((InputStatementWizard)InputStatementWizard.this)._isNullableColumn[this._selectedColumn] = this._allowNULLsCheckBox.isSelected();
                this.enableControls();
            }
        }

        private void handleColumnTypeChange() {
            if (this._selectedColumn != -1) {
                DataTypeMetaData dataTypeMetaData;
                ((InputStatementWizard)InputStatementWizard.this)._columnTypeMetaData[this._selectedColumn] = dataTypeMetaData = (DataTypeMetaData)this._columnTypeCombo.getSelectedItem();
                ((InputStatementWizard)InputStatementWizard.this)._newDataTypeMetaData[this._selectedColumn] = dataTypeMetaData;
                this.enableControls();
                int n = dataTypeMetaData.getAnnotationFlags();
                if ((n & 1) != 0) {
                    this._maxLengthField.setText("254");
                }
                if ((n & 2) != 0) {
                    this._precisionField.setText("30");
                }
                if ((n & 4) != 0) {
                    this._scaleField.setText("6");
                }
            }
        }

        private void handleColumnNameChange() {
            boolean bl = false;
            if (InputStatementWizard.this._isCreatingNewTable) {
                String string = this._columnName.getText().trim();
                if (string != null && string.length() != 0 && !string.equalsIgnoreCase(InputStatementWizard.this._columnNames[this._selectedColumn])) {
                    this._preview.getColumnModel().getColumn(this._selectedColumn).setHeaderValue(string);
                    this._preview.getTableHeader().resizeAndRepaint();
                    ((InputStatementWizard)InputStatementWizard.this)._columnNames[this._selectedColumn] = string;
                    bl = true;
                }
            } else {
                String string = this._columnNameCombo.getSelectedItem().toString();
                String string2 = InputStatementWizard.this._columnNames[this._selectedColumn];
                for (int i = 0; i < InputStatementWizard.this._columnNames.length; ++i) {
                    if (!InputStatementWizard.this._columnNames[i].equalsIgnoreCase(string)) continue;
                    ((InputStatementWizard)InputStatementWizard.this)._columnNames[i] = string2;
                    this._preview.getColumnModel().getColumn(i).setHeaderValue(string2);
                    break;
                }
                ((InputStatementWizard)InputStatementWizard.this)._columnNames[this._selectedColumn] = string;
                this._preview.getColumnModel().getColumn(this._selectedColumn).setHeaderValue(string);
                this._preview.getTableHeader().resizeAndRepaint();
                this._columnsWereReordered = true;
                bl = true;
            }
            if (bl && !InputStatementWizard.this._isCreatingNewTable) {
                this.refreshColumnProperties(this._selectedColumn);
            }
        }

        private String getNameForSQLType(int n) {
            String string = null;
            for (int i = 0; i < this._typeMetaData.length; ++i) {
                if (this._typeMetaData[i].getSQLType() != n) continue;
                string = this._typeMetaData[i].getName();
                break;
            }
            if (string == null) {
                string = "";
            }
            return string;
        }

        private void handleNumericPropertyChanged(JTextField jTextField, int[] nArray) {
            String string = jTextField.getText().trim();
            if (string.length() > 0) {
                try {
                    int n;
                    nArray[this._selectedColumn] = n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        private void handleDocumentEvent(DocumentEvent documentEvent) {
            if (this._selectedColumn == -1 || this._ignoreEvents) {
                return;
            }
            Document document = documentEvent.getDocument();
            if (document == this._columnName.getDocument()) {
                this.handleColumnNameChange();
            }
            if (InputStatementWizard.this._isCreatingNewTable) {
                if (document == this._maxLengthField.getDocument()) {
                    this.handleNumericPropertyChanged((JTextField)this._maxLengthField, InputStatementWizard.this._newTableColumnPrecisions);
                } else if (document == this._precisionField.getDocument()) {
                    this.handleNumericPropertyChanged((JTextField)this._precisionField, InputStatementWizard.this._newTableColumnPrecisions);
                } else if (document == this._scaleField.getDocument()) {
                    this.handleNumericPropertyChanged((JTextField)this._scaleField, InputStatementWizard.this._newTableColumnScales);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        @Override
        String getPreviousPageID() {
            int n = InputStatementWizard.this._options.getFormat();
            if (n == 1) {
                return InputStatementWizard.ASCII_PANEL;
            }
            return InputStatementWizard.COLWIDTH_PANEL;
        }

        @Override
        String getNextPageID() {
            return null;
        }
    }

    class ColWidthPanel
    extends WizardPanel {
        private ColWidthTable _preview;
        private Ruler _ruler;
        private JScrollPane _scrollPane;

        ColWidthPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.add((Component)((Object)new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("Click between columns in the preview below to add/remove column breaks."))));
            this.add((Component)new SybLabel(InputStatementWizard.this._bundle.getISQLString("To move a column break, drag it with the mouse.")));
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            this._preview = new ColWidthTable();
            this._scrollPane = new JScrollPane(this._preview, 21, 32);
            this._ruler = new Ruler(this._preview);
            this._scrollPane.setColumnHeaderView(this._ruler);
            this._preview.setRuler(this._ruler);
            InputMap inputMap = this._preview.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), "null");
            inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "null");
            inputMap.put(KeyStroke.getKeyStroke("TAB"), "focusNext");
            inputMap.put(KeyStroke.getKeyStroke("shift TAB"), "focusPrevious");
            inputMap.put(KeyStroke.getKeyStroke("SPACE"), "addColumnBreak");
            ActionMap actionMap = this._preview.getActionMap();
            actionMap.put("focusNext", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColWidthPanel.this._preview.transferFocus();
                }
            });
            actionMap.put("focusPrevious", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColWidthPanel.this._preview.transferFocusBackward();
                }
            });
            actionMap.put("addColumnBreak", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ColWidthPanel.this._preview.getSelectedColumn();
                    if (n != -1) {
                        ColWidthPanel.this._ruler.toggleColumnBreak(n);
                    }
                }
            });
            this._scrollPane.setPreferredSize(new Dimension(100, 40));
            this.add(this._scrollPane);
            this.add(Box.createVerticalStrut(10));
            JPanel jPanel = new JPanel(){

                @Override
                public boolean isValidateRoot() {
                    return true;
                }
            };
            jPanel.setOpaque(false);
            SybLabel sybLabel = new SybLabel(" ");
            jPanel.setLayout(new FlowLayout(0));
            sybLabel.setAlignmentX(0.0f);
            jPanel.setAlignmentX(0.0f);
            jPanel.add((Component)sybLabel);
            this.add(jPanel);
            this._preview.setSummary(sybLabel);
            this.setName(InputStatementWizard.COLWIDTH_PANEL);
        }

        @Override
        void initialize() {
            if (this._preview.getRowCount() == 0) {
                this.readSampleData();
            }
            int n = 0;
            int n2 = InputStatementWizard.this._options.getColumnWidthCount();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = InputStatementWizard.this._options.getColumnWidth(i);
                nArray[i] = n;
                n += n3;
            }
            this._scrollPane.setColumnHeaderView(this._ruler);
        }

        @Override
        void destroy() {
            this._preview = null;
            this._ruler = null;
            this._scrollPane = null;
        }

        @Override
        void setInitialFocus() {
            this._preview.requestFocusInWindow();
        }

        private void readSampleData() {
            String[] stringArray = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(InputStatementWizard.this._options.getFileName());
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                stringArray = new String[6];
                for (int i = 0; i < 6; ++i) {
                    stringArray[i] = InputStatementWizard.readLine(inputStreamReader);
                    if (stringArray[i] != null) continue;
                    stringArray[i] = "";
                }
                inputStreamReader.close();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this._preview.setData(stringArray);
        }

        @Override
        boolean hasValidData() {
            int n;
            int n2 = this._ruler.getColumnBreakCount() + 1;
            return InputStatementWizard.this._isCreatingNewTable || n2 <= ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column.length || (n = SybOptionPane.showConfirmDialog((Component)this, (Object)ISQLResource.getFormattedString(GeneralResources.getName(), "IWTooManyColumns", InputStatementWizard.this._options.getQuotedOwnerAndTableName(InputStatementWizard.this._connection), Integer.toString(((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column.length), Integer.toString(n2)), (String)InputStatementWizard.this._bundle.getISQLString("Import Wizard"), (int)0)) != 0;
        }

        @Override
        void commit() {
            int n;
            int n2;
            int n3 = this._ruler.getColumnBreakCount() + 1;
            if (!InputStatementWizard.this._isCreatingNewTable && n3 > ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column.length) {
                n3 = ((InputStatementWizard)InputStatementWizard.this)._existingTableMetaData.column.length;
            }
            int n4 = InputStatementWizard.this._columnWidths != null ? InputStatementWizard.this._columnWidths.length : -1;
            InputStatementWizard.this._options.clearColumnWidths();
            int n5 = n3 - 1;
            int n6 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                n = this._ruler.getColumnBreak(n2);
                InputStatementWizard.this._options.addColumnWidth(n - n6);
                n6 = n;
            }
            InputStatementWizard.this._options.addColumnWidth(this._preview.getColumnCount() - n6);
            InputStatementWizard.this._options.setColumnList(new Vector<String>());
            n5 = n3 - 1;
            InputStatementWizard.access$402(InputStatementWizard.this, new int[n3]);
            n6 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                n = this._ruler.getColumnBreak(n2);
                ((InputStatementWizard)InputStatementWizard.this)._columnWidths[n2] = n - n6;
                n6 = n;
            }
            ((InputStatementWizard)InputStatementWizard.this)._columnWidths[n2] = this._preview.getColumnCount() - n6;
            if (n4 != ++n5) {
                InputStatementWizard.this._columnCount = n5;
                InputStatementWizard.this.fixupColumnMetaData();
                InputStatementWizard.this._columnDetailsPanel.setInitialized(false);
            }
        }

        @Override
        String getPreviousPageID() {
            return InputStatementWizard.TABLE_NAME_PANEL;
        }

        @Override
        String getNextPageID() {
            return InputStatementWizard.COLUMN_DETAILS_PANEL;
        }
    }

    class AsciiPanel
    extends WizardPanel
    implements ActionListener,
    ItemListener,
    DocumentListener {
        private SybRadioButton _comma;
        private SybRadioButton _semicolon;
        private SybRadioButton _tab;
        private SybRadioButton _otherDelimiter;
        private JTextField _delimiter;
        private SybCheckBox _stripTrailingBlanks;
        private SybCheckBox _enableEscapes;
        private JTextField _escapeCharacter;
        private JComboBox _encoding;
        private PreviewTable _preview;

        AsciiPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.add((Component)((Object)new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("The following options control the way the ASCII file is read."))));
            SybLabel sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("Change the options to suit your file."));
            this.add((Component)sybLabel);
            this.add(Box.createRigidArea(new Dimension(0, 10)));
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(InputStatementWizard.this._bundle.getISQLString("Field delimiter")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this._comma = new SybRadioButton(InputStatementWizard.this._bundle.getISQLString("Comma ( , )"));
            this._comma.setOpaque(false);
            this._semicolon = new SybRadioButton(InputStatementWizard.this._bundle.getISQLString("Semicolon ( ; )"));
            this._semicolon.setOpaque(false);
            this._tab = new SybRadioButton(InputStatementWizard.this._bundle.getISQLString("Tab"));
            this._tab.setOpaque(false);
            this._otherDelimiter = new SybRadioButton(InputStatementWizard.this._bundle.getISQLString("Other"));
            this._otherDelimiter.setOpaque(false);
            this._delimiter = new JTextField(1);
            Dimension dimension = this._delimiter.getPreferredSize();
            dimension.width = Short.MAX_VALUE;
            this._delimiter.setMaximumSize(dimension);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._comma);
            buttonGroup.add((AbstractButton)this._semicolon);
            buttonGroup.add((AbstractButton)this._tab);
            buttonGroup.add((AbstractButton)this._otherDelimiter);
            JPanel jPanel2 = new JPanel();
            jPanel2.setOpaque(false);
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add((Component)this._otherDelimiter);
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel2.add(this._delimiter);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add((Component)this._comma);
            jPanel.add((Component)this._semicolon);
            jPanel.add((Component)this._tab);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setOpaque(false);
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(InputStatementWizard.this._bundle.getISQLString("Other options")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            this._stripTrailingBlanks = new SybCheckBox(InputStatementWizard.this._bundle.getISQLString("Strip trailing blanks"));
            this._stripTrailingBlanks.setOpaque(false);
            jPanel3.add((Component)this._stripTrailingBlanks);
            this._enableEscapes = new SybCheckBox(InputStatementWizard.this._bundle.getISQLString("IWEnableEscapes"));
            this._enableEscapes.setOpaque(false);
            jPanel3.add((Component)this._enableEscapes);
            this._escapeCharacter = new JTextField(3);
            dimension = this._escapeCharacter.getPreferredSize();
            this._escapeCharacter.setMaximumSize(dimension);
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("Escape character:"));
            sybLabel.setLabelFor((Component)this._escapeCharacter);
            jPanel2 = new JPanel();
            jPanel2.setOpaque(false);
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setAlignmentX(0.0f);
            jPanel2.add(Box.createHorizontalStrut(30));
            jPanel2.add((Component)sybLabel);
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel2.add(this._escapeCharacter);
            jPanel3.add(jPanel2);
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IWEncoding"));
            this._encoding = new JComboBox<String>(InputOutputOptions.getEncodingListForDisplay());
            sybLabel.setLabelFor((Component)this._encoding);
            dimension = this._encoding.getPreferredSize();
            dimension.width = Short.MAX_VALUE;
            this._encoding.setMaximumSize(dimension);
            jPanel2 = new JPanel();
            jPanel2.setOpaque(false);
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setAlignmentX(0.0f);
            jPanel2.add((Component)sybLabel);
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel2.add(this._encoding);
            jPanel3.add(Box.createVerticalStrut(5));
            jPanel3.add(jPanel2);
            jPanel3.add(Box.createVerticalGlue());
            jPanel2 = new JPanel(new GridLayout(1, 2));
            jPanel2.setOpaque(false);
            jPanel2.setAlignmentX(0.0f);
            jPanel2.add(jPanel);
            jPanel2.add(jPanel3);
            this.add(jPanel2);
            this._comma.addItemListener((ItemListener)this);
            this._semicolon.addItemListener((ItemListener)this);
            this._tab.addItemListener((ItemListener)this);
            this._otherDelimiter.addItemListener((ItemListener)this);
            this._delimiter.getDocument().addDocumentListener(this);
            this._stripTrailingBlanks.addActionListener((ActionListener)this);
            this._enableEscapes.addItemListener((ItemListener)this);
            this._encoding.addActionListener(this);
            this.add(Box.createRigidArea(new Dimension(0, 20)));
            jPanel2 = new JPanel();
            jPanel2.setOpaque(false);
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setAlignmentX(0.0f);
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(InputStatementWizard.this._bundle.getISQLString("Preview")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this._preview = new PreviewTable(InputStatementWizard.this._connection);
            this._preview.setFocusable(false);
            this._preview.setTableHeader(null);
            JScrollPane jScrollPane = new JScrollPane(this._preview, 21, 32);
            InputStatementWizard.this.setPreviewTableSize(this._preview, jScrollPane);
            jPanel2.add(jScrollPane);
            this.add(jPanel2);
            this.add(Box.createVerticalGlue());
            this.setName(InputStatementWizard.ASCII_PANEL);
        }

        @Override
        void destroy() {
            this._comma.removeItemListener((ItemListener)this);
            this._semicolon.removeItemListener((ItemListener)this);
            this._tab.removeItemListener((ItemListener)this);
            this._otherDelimiter.removeItemListener((ItemListener)this);
            this._delimiter.getDocument().removeDocumentListener(this);
            this._stripTrailingBlanks.removeActionListener((ActionListener)this);
            this._enableEscapes.removeItemListener((ItemListener)this);
            this._encoding.removeActionListener(this);
            this._comma = null;
            this._semicolon = null;
            this._tab = null;
            this._otherDelimiter = null;
            this._delimiter = null;
            this._stripTrailingBlanks = null;
            this._enableEscapes = null;
            this._escapeCharacter = null;
            this._encoding = null;
            this._preview = null;
        }

        @Override
        public void initialize() {
            this._enableEscapes.setSelected(true);
            this._escapeCharacter.setText(Preferences.getStringOption(InputStatementWizard.this._connection, "ISQL_escape_character"));
            this._stripTrailingBlanks.setSelected(true);
            String string = Preferences.getStringOption(InputStatementWizard.this._connection, "defaultISQLEncoding");
            if (string == null) {
                this._encoding.setSelectedIndex(0);
            } else {
                this._encoding.setSelectedItem(string);
            }
            string = Preferences.getStringOption(InputStatementWizard.this._connection, "ISQL_field_separator");
            if (string.equals(",")) {
                this._comma.setSelected(true);
                this._delimiter.setEnabled(false);
            } else if (string.equals(";")) {
                this._semicolon.setSelected(true);
                this._delimiter.setEnabled(false);
            } else if (string.equals("\t")) {
                this._tab.setSelected(true);
                this._delimiter.setEnabled(false);
            } else {
                this._otherDelimiter.setSelected(true);
                this._delimiter.setText(string);
            }
        }

        @Override
        void setInitialFocus() {
            if (this._comma.isSelected()) {
                this._comma.requestFocusInWindow();
            } else if (this._semicolon.isSelected()) {
                this._semicolon.requestFocusInWindow();
            } else if (this._tab.isSelected()) {
                this._tab.requestFocusInWindow();
            } else {
                this._delimiter.requestFocusInWindow();
            }
        }

        @Override
        boolean hasValidData() {
            String string;
            if (this._comma.isSelected()) {
                string = ",";
            } else if (this._semicolon.isSelected()) {
                string = ";";
            } else if (this._tab.isSelected()) {
                string = "\t";
            } else {
                string = this._delimiter.getText().trim();
                if (string.isEmpty()) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getISQLString("IW_ASCII_PANEL_MISSING_FIELD_DELIMITER"), (String)InputStatementWizard.this._bundle.getISQLString("Import Wizard"), (int)0);
                    return false;
                }
            }
            if (this._enableEscapes.isSelected()) {
                String string2 = this._escapeCharacter.getText().trim();
                if (string2.isEmpty()) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getISQLString("IW_ASCII_PANEL_MISSING_ESCAPE_CHAR"), (String)InputStatementWizard.this._bundle.getISQLString("Import Wizard"), (int)0);
                    return false;
                }
                if (string2.equals(string)) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getISQLString("IW_ASCII_PANEL_DELIMITER_ESCAPE_CHAR_CONFLICT"), (String)InputStatementWizard.this._bundle.getISQLString("Import Wizard"), (int)0);
                    return false;
                }
            }
            return true;
        }

        @Override
        void commit() {
            String string;
            int n;
            String string2;
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            String string3 = this._comma.isSelected() ? "," : (this._semicolon.isSelected() ? ";" : (this._tab.isSelected() ? "\t" : this._delimiter.getText().trim()));
            if (string3.length() != 0 && !string3.equals(InputStatementWizard.this._options.getDelimiter())) {
                InputStatementWizard.this._options.setDelimiter(string3);
                bl3 = true;
            }
            if ((bl2 = this._enableEscapes.isSelected()) != InputStatementWizard.this._options.getEscapes()) {
                InputStatementWizard.this._options.setEscapes(bl2);
                bl3 = true;
            }
            if (bl2 && (string3 = this._escapeCharacter.getText().trim()).length() != 0 && string3.charAt(0) != InputStatementWizard.this._options.getEscapeCharacter()) {
                InputStatementWizard.this._options.setEscapeCharacter(string3.charAt(0));
                bl3 = true;
            }
            boolean bl4 = bl = !this._stripTrailingBlanks.isSelected();
            if (bl != InputStatementWizard.this._options.getNoStrip()) {
                InputStatementWizard.this._options.setNoStrip(bl);
                bl3 = true;
            }
            if (!(string2 = (n = this._encoding.getSelectedIndex()) == 0 ? InputStatementWizard.this._options.getSystemEncoding() : (n > 0 ? this._encoding.getSelectedItem().toString() : string)).equals(string = InputStatementWizard.this._options.getEncoding())) {
                bl3 = true;
                InputStatementWizard.this._options.setEncoding(string2);
            }
            int n2 = this._preview.getColumnCount();
            if (bl3) {
                if (InputStatementWizard.this._isCreatingNewTable) {
                    InputStatementWizard.this._columnCount = -1;
                    InputStatementWizard.access$402(InputStatementWizard.this, null);
                    InputStatementWizard.access$502(InputStatementWizard.this, null);
                    InputStatementWizard.access$602(InputStatementWizard.this, null);
                    InputStatementWizard.access$702(InputStatementWizard.this, null);
                    InputStatementWizard.access$802(InputStatementWizard.this, null);
                    InputStatementWizard.this._options.setColumnList(new Vector<String>());
                }
                InputStatementWizard.this._columnDetailsPanel.setInitialized(false);
            }
            if (InputStatementWizard.this._columnCount != n2) {
                this._preview.refresh(InputStatementWizard.this._options, InputStatementWizard.this._isCreatingNewTable);
                InputStatementWizard.this._columnCount = this._preview.getColumnCount();
                InputStatementWizard.this.fixupColumnMetaData();
            }
        }

        @Override
        String getPreviousPageID() {
            return InputStatementWizard.TABLE_NAME_PANEL;
        }

        @Override
        String getNextPageID() {
            return InputStatementWizard.COLUMN_DETAILS_PANEL;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.commit();
            this.refresh();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (itemEvent.getStateChange() == 1 && (object == this._comma || object == this._semicolon || object == this._tab || object == this._otherDelimiter)) {
                this._delimiter.setEnabled(object == this._otherDelimiter);
                this.commit();
                this.refresh();
            } else if (object == this._enableEscapes) {
                this._escapeCharacter.setEnabled(this._enableEscapes.isSelected());
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.otherDelimiterChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.otherDelimiterChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.otherDelimiterChanged();
        }

        private void otherDelimiterChanged() {
            this.commit();
            this.refresh();
        }

        private void refresh() {
            this._preview.refresh(InputStatementWizard.this._options, InputStatementWizard.this._isCreatingNewTable);
        }
    }

    private static class ReadOnlyTableModel
    extends DefaultTableModel {
        ReadOnlyTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class TableNamePanel
    extends WizardPanel
    implements ItemListener {
        private SybRadioButton _useExistingTable;
        private SybRadioButton _createTable;
        private JPanel _createTablePanel;
        private JTable _tables;
        private KeySelectionHelper _ksh;
        private Object _cookie;
        private SybComboBox _owner;
        private SybLabel _ownerLabel;
        private JTextField _tableName;
        private Object _enablingCookie;
        private JPanel _existingTableDatabasesPanel;
        private SybComboBox _existingTableDatabases;
        private SybLabel _existingTableDatabasesLabel;
        private SybComboBox _newTableDatabases;
        private SybLabel _newTableDatabasesLabel;
        private ArrayList<String> _databases;

        TableNamePanel() {
            this._cookie = null;
            this._enablingCookie = null;
            this._existingTableDatabasesPanel = null;
            this._existingTableDatabases = null;
            this._existingTableDatabasesLabel = null;
            this._newTableDatabases = null;
            this._newTableDatabasesLabel = null;
            this._databases = null;
            this.setName(InputStatementWizard.TABLE_NAME_PANEL);
            this.setLayout(new GridBagLayout());
            ExportWizard.InstructionLabel instructionLabel = new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_INSTRUCTION"));
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
            this._useExistingTable = new SybRadioButton(InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_EXISTING_TABLE"));
            this._useExistingTable.setOpaque(false);
            this._createTable = new SybRadioButton(InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_NEW_TABLE"));
            this._createTable.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._useExistingTable);
            buttonGroup.add((AbstractButton)this._createTable);
            this._tables = new JTable();
            this._tables.setDefaultRenderer(Object.class, FontHelper.getTableCellRenderer());
            this._ksh = new KeySelectionHelper((JComponent)this._tables);
            this._tables.getTableHeader().setReorderingAllowed(false);
            this._tables.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this._tables);
            this._tables.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TableNamePanel.this.getNextPageID() == null) {
                        InputStatementWizard.this.handleImport();
                    } else {
                        InputStatementWizard.this.handleNext();
                    }
                }
            }, KeyStroke.getKeyStroke(10, 0), 0);
            jScrollPane.setPreferredSize(new Dimension(200, 175));
            this._existingTableDatabasesLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_DATABASE"));
            this._existingTableDatabases = new SybComboBox();
            this._existingTableDatabases.addItemListener((ItemListener)this);
            this._existingTableDatabasesLabel.setLabelFor((Component)this._existingTableDatabases);
            this._existingTableDatabasesPanel = new JPanel(new GridBagLayout());
            this._existingTableDatabasesPanel.setOpaque(false);
            this._existingTableDatabasesPanel.add((Component)this._existingTableDatabasesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            this._existingTableDatabasesPanel.add((Component)this._existingTableDatabases, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this._createTablePanel = new JPanel(new GridBagLayout());
            this._createTablePanel.setOpaque(false);
            this._newTableDatabasesLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_DATABASE"));
            this._newTableDatabases = new SybComboBox();
            this._newTableDatabasesLabel.setLabelFor((Component)this._newTableDatabases);
            this._createTablePanel.add((Component)this._newTableDatabasesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
            this._createTablePanel.add((Component)this._newTableDatabases, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
            this._ownerLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_OWNER_LABEL"));
            this._owner = new SybComboBox();
            new FontHelper((JComboBox)this._owner);
            this._ownerLabel.setLabelFor((Component)this._owner);
            this._createTablePanel.add((Component)this._ownerLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            this._createTablePanel.add((Component)this._owner, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            SybLabel sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_TABLE_NAME_LABEL"));
            this._tableName = new JTextField(20);
            new FontHelper((JTextComponent)this._tableName);
            sybLabel.setLabelFor((Component)this._tableName);
            this._createTablePanel.add((Component)sybLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 5), 0, 0));
            this._createTablePanel.add((Component)this._tableName, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._useExistingTable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._existingTableDatabasesPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 5, 0), 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.add((Component)this._createTable, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)this._createTablePanel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            this._useExistingTable.addItemListener((ItemListener)this);
            this._createTable.addItemListener((ItemListener)this);
            this._useExistingTable.setSelected(true);
        }

        @Override
        void destroy() {
            this._useExistingTable.removeItemListener((ItemListener)this);
            this._useExistingTable = null;
            this._existingTableDatabases.removeItemListener((ItemListener)this);
            this._existingTableDatabases = null;
            this._existingTableDatabasesLabel = null;
            this._existingTableDatabasesPanel = null;
            this._newTableDatabases = null;
            this._newTableDatabasesLabel = null;
            this._createTable.removeItemListener((ItemListener)this);
            this._createTable = null;
            this._createTablePanel = null;
            this._tables = null;
            this._ksh.destroy();
            this._ksh = null;
            this._owner = null;
            this._ownerLabel = null;
            this._tableName = null;
        }

        @Override
        void initialize() {
            String string;
            this._databases = InputStatementWizard.this._connection.getDatabaseNames();
            if (this._databases.size() > 0) {
                Vector<String> vector = new Vector<String>(this._databases);
                this._newTableDatabases.setModel(new DefaultComboBoxModel<String>(vector));
                this._existingTableDatabases.setModel(new DefaultComboBoxModel<String>(vector));
                this._newTableDatabasesLabel.setVisible(true);
                this._newTableDatabases.setVisible(true);
                this._existingTableDatabasesPanel.setVisible(true);
                String string2 = InputStatementWizard.this._connection.getCatalog();
                string2 = ExportWizard.sanitizeString(string2);
                if (string2 != null && !string2.isEmpty()) {
                    this._newTableDatabases.setSelectedItem((Object)string2);
                    this._existingTableDatabases.setSelectedItem((Object)string2);
                }
            } else {
                this._newTableDatabasesLabel.setVisible(false);
                this._newTableDatabases.setVisible(false);
                this._existingTableDatabasesPanel.setVisible(false);
                Object var3_3 = null;
            }
            this.refreshExistingTableList();
            if (((ISQLConnectionImpl)InputStatementWizard.this._connection).supportsSchemas()) {
                this.refreshSchemaList();
                this._owner.setVisible(true);
                this._ownerLabel.setVisible(true);
            } else {
                this._owner.setVisible(false);
                this._ownerLabel.setVisible(false);
            }
            this._createTable.setSelected(true);
            if (InputStatementWizard.this._options.getFormat() == 14) {
                string = ((InputStatementWizard)InputStatementWizard.this)._options.odbcTableName;
            } else {
                File file = new File(InputStatementWizard.this._options.getFileName());
                string = file.getName();
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    string = string.substring(0, n);
                }
            }
            this._tableName.setText(string);
            this._owner.setSelectedItem((Object)InputStatementWizard.this._connection.getUserID());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshSchemaList() {
            String string;
            ResultSet resultSet = null;
            Vector<String> vector = new Vector<String>();
            String string2 = this._newTableDatabases.isVisible() ? this._newTableDatabases.getSelectedItem().toString() : null;
            try {
                DatabaseMetaData databaseMetaData = InputStatementWizard.this._connection.getJDBCConnection().getMetaData();
                resultSet = databaseMetaData.getSchemas();
                while (resultSet.next()) {
                    try {
                        String string3 = resultSet.getString(2);
                        if (string3 == null ^ string2 == null || string3 != null && !string3.equals(string2)) {
                            continue;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    vector.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            if ((string = InputStatementWizard.this._connection.getUserID()) != null && !string.isEmpty() && !vector.contains(string)) {
                vector.insertElementAt(string, 0);
            }
            this._owner.setModel(new DefaultComboBoxModel(vector));
        }

        private void refreshExistingTableList() {
            int n;
            Object object;
            String string = null;
            if (this._existingTableDatabases.isVisible() && (object = this._existingTableDatabases.getSelectedItem()) != null) {
                string = object.toString();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            InputStatementWizard.this._connection.listTables(string, null, null, 1, arrayList, arrayList2);
            int n2 = arrayList2.size();
            Object[][] objectArray = new Object[n2][2];
            for (n = 0; n < n2; ++n) {
                objectArray[n][0] = arrayList2.get(n);
                objectArray[n][1] = arrayList.get(n);
            }
            Object[] objectArray2 = new Object[]{InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_TABLE_NAME_COLUMN"), InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_OWNER_COLUMN")};
            this._tables.setModel(new ReadOnlyTableModel(objectArray, objectArray2));
            TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(this._tables.getModel());
            ArrayList<RowSorter.SortKey> arrayList3 = new ArrayList<RowSorter.SortKey>();
            arrayList3.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            arrayList3.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList3);
            this._tables.setRowSorter(tableRowSorter);
            String string2 = InputStatementWizard.this._options.getTableName();
            if (string2 != null && string2.length() != 0) {
                for (n = 0; n < n2; ++n) {
                    if (!objectArray[n][0].equals(string2)) continue;
                    int n3 = this._tables.convertRowIndexToView(n);
                    this._tables.setRowSelectionInterval(n3, n3);
                    Rectangle rectangle = this._tables.getCellRect(n3, 0, true);
                    this._tables.scrollRectToVisible(rectangle);
                    break;
                }
            }
            if (this._tables.getSelectedRow() == -1 && this._tables.getRowCount() > 0) {
                this._tables.setRowSelectionInterval(0, 0);
            }
        }

        @Override
        void setInitialFocus() {
            if (this._createTable.isSelected()) {
                this._tableName.requestFocusInWindow();
            } else {
                this._tables.requestFocusInWindow();
            }
        }

        @Override
        void commit() {
            String string;
            String string2;
            String string3;
            boolean bl = false;
            boolean bl2 = this._createTable.isSelected();
            if (bl2 != InputStatementWizard.this._isCreatingNewTable) {
                InputStatementWizard.this._isCreatingNewTable = bl2;
                bl = true;
            }
            if (InputStatementWizard.this._isCreatingNewTable) {
                String string4;
                string3 = null;
                Object object = this._newTableDatabases.getSelectedItem();
                if (object != null) {
                    string3 = object.toString();
                }
                string2 = null;
                object = this._owner.getSelectedItem();
                if (object != null && (string2 = object.toString()).isEmpty()) {
                    string2 = null;
                }
                string = string4 = this._tableName.getText().trim();
            } else {
                int n;
                string3 = null;
                Object object = this._existingTableDatabases.getSelectedItem();
                if (object != null) {
                    string3 = object.toString();
                }
                if ((n = this._tables.getSelectedRow()) != -1) {
                    object = this._tables.getValueAt(n, 1);
                    string2 = object != null ? object.toString() : null;
                    string = this._tables.getValueAt(n, 0).toString();
                } else {
                    string3 = null;
                    string2 = null;
                    string = null;
                }
            }
            if (string == null && InputStatementWizard.this._options.getTableName() != null || string != null && InputStatementWizard.this._options.getTableName() == null || string != null && !string.equals(InputStatementWizard.this._options.getTableName()) || string2 != null && InputStatementWizard.this._options.getOwner() == null || string2 == null && InputStatementWizard.this._options.getOwner() != null || string2 != null && !string2.equals(InputStatementWizard.this._options.getOwner()) || string3 != null && InputStatementWizard.this._options.getCatalog() == null || string3 == null && InputStatementWizard.this._options.getCatalog() != null || string3 != null && !string3.equals(InputStatementWizard.this._options.getCatalog())) {
                bl = true;
            }
            if (bl) {
                if (InputStatementWizard.this._isCreatingNewTable) {
                    InputStatementWizard.this._existingTableMetaData = null;
                } else {
                    InputStatementWizard.this._existingTableMetaData = InputStatementWizard.this._connection.getTableInfo(string3, string2, string);
                }
                InputStatementWizard.this._options.setOwnerAndTableName(string3, string2, string);
                InputStatementWizard.this._columnDetailsPanel.setInitialized(false);
            }
        }

        @Override
        boolean hasValidData() {
            String string = InputStatementWizard.this._options.getCatalog();
            String string2 = InputStatementWizard.this._options.getTableName();
            String string3 = InputStatementWizard.this._options.getOwner();
            if (InputStatementWizard.this._isCreatingNewTable) {
                if (string2 == null || string2.length() == 0) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_MISSING_TABLE_NAME"), (String)InputStatementWizard.this.getTitle(), (int)0);
                    this._tableName.requestFocusInWindow();
                    return false;
                }
                if (string2 != null && InputStatementWizard.this._connection.tableExists(string, string3, string2)) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getFormattedString("IW_TABLE_NAME_PANEL_DUPLICATE_TABLE_NAME", string2), (String)InputStatementWizard.this.getTitle(), (int)0);
                    this._tableName.requestFocusInWindow();
                    return false;
                }
                if (string3 != null && string3.length() > 0) {
                    OwnerNameChecker ownerNameChecker = new OwnerNameChecker(string3);
                    if (!ownerNameChecker.ok) {
                        SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getFormattedString("IW_TABLE_NAME_PANEL_UNKNOWN_OWNER", string3), (String)InputStatementWizard.this.getTitle(), (int)0);
                        this._owner.requestFocusInWindow();
                        return false;
                    }
                }
                if (string != null && !string.isEmpty() && (string3 == null || string3.isEmpty()) && ((ISQLConnectionImpl)InputStatementWizard.this._connection).supportsSchemas()) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getFormattedString("IW_TABLE_NAME_PANEL_NEEDS_OWNER", string3), (String)InputStatementWizard.this.getTitle(), (int)0);
                    return false;
                }
            } else if (string2 == null || string2.length() == 0) {
                SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getISQLString("IW_TABLE_NAME_PANEL_SELECT_A_TABLE"), (String)InputStatementWizard.this.getTitle(), (int)0);
                this._tables.requestFocusInWindow();
                return false;
            }
            return true;
        }

        @Override
        String getPreviousPageID() {
            if (InputStatementWizard.this._options.getFormat() == 14) {
                return InputStatementWizard.SOURCE_TABLE_PANEL;
            }
            return InputStatementWizard.TEXT_FORMAT_PANEL;
        }

        @Override
        String getNextPageID() {
            int n = InputStatementWizard.this._options.getFormat();
            if (n == 1) {
                return InputStatementWizard.ASCII_PANEL;
            }
            if (n == 2) {
                return InputStatementWizard.COLWIDTH_PANEL;
            }
            return null;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this._existingTableDatabases) {
                this.refreshExistingTableList();
            } else if (object == this._newTableDatabases) {
                this.refreshSchemaList();
            } else if (object == this._useExistingTable || object == this._createTable) {
                if (this._useExistingTable.isSelected()) {
                    this._existingTableDatabasesLabel.setEnabled(true);
                    this._existingTableDatabases.setEnabled(true);
                    this._tables.setEnabled(true);
                    if (this._enablingCookie == null) {
                        this._enablingCookie = DialogUtils.disableControls((Container)this._createTablePanel);
                    }
                } else {
                    this._existingTableDatabasesLabel.setEnabled(false);
                    this._existingTableDatabases.setEnabled(false);
                    this._tables.setEnabled(false);
                    if (this._enablingCookie != null) {
                        DialogUtils.enableControls((Object)this._enablingCookie);
                        this._enablingCookie = null;
                    }
                }
            }
        }

        class OwnerNameChecker
        implements Runnable {
            boolean ok;
            private String _ownerName;

            OwnerNameChecker(String string) {
                block2: {
                    this._ownerName = string;
                    this.ok = true;
                    try {
                        InputStatementWizard.this._connection.executeOnWorkerThread(this, false);
                    }
                    catch (Exception exception) {
                        if (!(exception instanceof RuntimeException)) break block2;
                        throw (RuntimeException)exception;
                    }
                }
            }

            @Override
            public void run() {
                ISQLPlugin iSQLPlugin = ((ISQLConnectionImpl)InputStatementWizard.this._connection).getPlugin();
                String string = iSQLPlugin.getPluginID();
                if (string != null && string.equals("SQLAnywhere")) {
                    this.validateWithSASystemTables(iSQLPlugin);
                } else {
                    this.validateWithJDBCMetaData();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void validateWithSASystemTables(ISQLPlugin iSQLPlugin) {
                String string = null;
                int[] nArray = iSQLPlugin.getDatabaseVersion(InputStatementWizard.this._connection);
                string = nArray[0] >= 10 ? "select count(*) from sys.sysuser where user_name='" + this._ownerName + "'" : "select count(*) from sys.sysuserlist where name='" + this._ownerName + "'";
                if (string != null) {
                    Statement statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = InputStatementWizard.this._connection.getJDBCConnection().createStatement();
                        resultSet = statement.executeQuery(string);
                        if (!resultSet.next()) return;
                        int n = resultSet.getInt(1);
                        this.ok = n != 0;
                        return;
                    }
                    catch (SQLException sQLException) {
                        return;
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
                this.validateWithJDBCMetaData();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void validateWithJDBCMetaData() {
                ResultSet resultSet = null;
                try {
                    DatabaseMetaData databaseMetaData = InputStatementWizard.this._connection.getJDBCConnection().getMetaData();
                    resultSet = databaseMetaData.getSchemas();
                    this.ok = false;
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        if (string == null || string.length() <= 0 || !string.equalsIgnoreCase(this._ownerName)) continue;
                        this.ok = true;
                        break;
                    }
                }
                catch (SQLException sQLException) {
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }
    }

    static class DBTypeRenderer
    extends DefaultListCellRenderer {
        DBTypeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            LogonSource logonSource = (LogonSource)object;
            this.setText(logonSource.getDisplayName());
            this.setIcon(logonSource.getIcon());
            return this;
        }
    }

    static class DBTypeComboBox
    extends SybComboBox {
        static DBTypeRenderer _renderer = null;

        DBTypeComboBox(LogonSource[] logonSourceArray) {
            super((Object[])logonSourceArray);
            this.setEditable(false);
            if (_renderer == null) {
                _renderer = new DBTypeRenderer();
            }
            this.setRenderer(_renderer);
        }
    }

    class DSNPage
    extends WizardPanel
    implements ItemListener {
        private CardLayout _cardLayout;
        private JPanel _cardPanel;
        private DBTypeComboBox _dbType;
        private LogonSource _selectedLogonSource;
        private ISQLPlugin[] _plugins;

        DSNPage() {
            this.setName(InputStatementWizard.DSN_PANEL);
            this.setLayout(new GridBagLayout());
            ExportWizard.InstructionLabel instructionLabel = new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("IW_DSN_PAGE_INSTRUCTION"));
            SybLabel sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_DSN_PAGE_LABEL"));
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)sybLabel, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 15, 0), 0, 0));
            this._cardLayout = new CardLayout();
            this._cardPanel = new JPanel(this._cardLayout);
            this._plugins = PluginMgr.getPluginList();
            LogonSource[] logonSourceArray = new LogonSource[this._plugins.length];
            for (int i = 0; i < this._plugins.length; ++i) {
                logonSourceArray[i] = this._plugins[i].getLogonSource();
                JPanel jPanel = logonSourceArray[i].getPanel(1);
                jPanel.setBackground(SystemColor.window);
                this._cardPanel.add((Component)jPanel, logonSourceArray[i].getDisplayName());
            }
            this._dbType = new DBTypeComboBox(logonSourceArray);
            this._dbType.addItemListener(this);
            if (logonSourceArray.length > 0) {
                this._dbType.setSelectedIndex(0);
                this._selectedLogonSource = logonSourceArray[0];
            } else {
                this._selectedLogonSource = null;
            }
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_DSN_PAGE_DATABASE_TYPE_LABEL"));
            sybLabel.setLabelFor((Component)((Object)this._dbType));
            this.add((Component)sybLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)((Object)this._dbType), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this._cardPanel, new GridBagConstraints(0, 4, 0, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 99, 1, 1, 0.0, 1.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        void destroy() {
            this._dbType.removeItemListener(this);
            this._dbType = null;
            this._cardLayout = null;
            this._cardPanel = null;
            this._plugins = null;
        }

        @Override
        void initialize() {
        }

        @Override
        void setInitialFocus() {
            this._dbType.requestFocusInWindow();
        }

        @Override
        void commit() {
            boolean bl;
            String string;
            AbstractConnectionInfo abstractConnectionInfo = this._selectedLogonSource.getConnectionInfo();
            String string2 = abstractConnectionInfo.getURL();
            if (string2.regionMatches(true, 0, string = "jdbc:odbc:", 0, string.length())) {
                string2 = string2.substring(string.length());
                InputStatementWizard.this._srcConnectionParameters = string2;
            } else {
                InputStatementWizard.this._srcConnectionParameters = abstractConnectionInfo.getConnectionString();
            }
            String string3 = abstractConnectionInfo.getPassword();
            boolean bl2 = bl = string3 != null && !string3.isEmpty();
            if (bl) {
                abstractConnectionInfo.setPassword("***");
            }
            if ((string2 = abstractConnectionInfo.getURL()).regionMatches(true, 0, string, 0, string.length())) {
                string2 = string2.substring(string.length());
                InputStatementWizard.this._secureSrcConnectionParameters = string2;
            } else {
                InputStatementWizard.this._secureSrcConnectionParameters = abstractConnectionInfo.getConnectionString();
            }
            if (bl) {
                abstractConnectionInfo.setPassword(string3);
            }
        }

        @Override
        boolean hasValidData() {
            if (InputStatementWizard.this._srcConnection != null) {
                try {
                    InputStatementWizard.this._srcConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                InputStatementWizard.this._srcConnection = null;
            }
            boolean bl = false;
            if (this._selectedLogonSource != null) {
                int n = this._dbType.getSelectedIndex();
                ISQLPlugin iSQLPlugin = this._plugins[n];
                ClassLoader classLoader = iSQLPlugin.getClass().getClassLoader();
                InputStatementWizard.this._srcConnection = this._selectedLogonSource.connect(null, null, classLoader);
                if (InputStatementWizard.this._srcConnection != null) {
                    InputStatementWizard.this._srcSQLNeedsSchema = true;
                    InputStatementWizard.this._srcSQLNeedsCatalog = false;
                    InputStatementWizard.this._srcSQLCatalogSeparator = null;
                    InputStatementWizard.this._srcIdentifierQuoteString = "\"";
                    try {
                        DatabaseMetaData databaseMetaData = InputStatementWizard.this._srcConnection.getMetaData();
                        InputStatementWizard.this._srcSQLNeedsSchema = databaseMetaData.supportsSchemasInDataManipulation();
                        InputStatementWizard.this._srcSQLNeedsCatalog = databaseMetaData.supportsCatalogsInDataManipulation();
                        if (InputStatementWizard.this._srcSQLNeedsCatalog) {
                            InputStatementWizard.this._srcSQLCatalogSeparator = databaseMetaData.getCatalogSeparator();
                        }
                        InputStatementWizard.this._srcIdentifierQuoteString = databaseMetaData.getIdentifierQuoteString();
                        if (InputStatementWizard.this._srcIdentifierQuoteString != null && InputStatementWizard.this._srcIdentifierQuoteString.isEmpty()) {
                            InputStatementWizard.this._srcIdentifierQuoteString = null;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    bl = true;
                }
            }
            InputStatementWizard.this._sourceTablePanel.setInitialized(false);
            return bl;
        }

        @Override
        protected void saveMRULists() {
            if (InputStatementWizard.this._options.getFormat() == 14 && this._selectedLogonSource != null) {
                this._selectedLogonSource.notifyConnectOK();
                com.sybase.asa.logon.Preferences.makePermanent();
            }
        }

        @Override
        String getPreviousPageID() {
            return InputStatementWizard.SOURCE_TYPE_PANEL;
        }

        @Override
        String getNextPageID() {
            return InputStatementWizard.SOURCE_TABLE_PANEL;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this._dbType && itemEvent.getStateChange() == 1) {
                LogonSource logonSource = (LogonSource)this._dbType.getSelectedItem();
                this._cardLayout.show(this._cardPanel, logonSource.getDisplayName());
                this._selectedLogonSource = logonSource;
            }
        }

        private class ConnectionClient
        implements LogonDialogClient {
            private AbstractConnectionInfo _connectionInfo = null;

            private ConnectionClient() {
            }

            @Override
            public boolean handleOK(JDialog jDialog, LogonSource logonSource) {
                this._connectionInfo = logonSource.getConnectionInfo();
                return true;
            }

            AbstractConnectionInfo getConnectionInfo() {
                return this._connectionInfo;
            }
        }
    }

    class SourceTablePage
    extends WizardPanel
    implements ItemListener {
        private SybLabel _dbName;
        private SybLabel _dbType;
        private SybLabel _dbVersion;
        private JTable _tables;
        private KeySelectionHelper _ksh;
        private JPanel _catalogPanel;
        private SybComboBox _catalogsCB;
        private String _dbProductName;

        SourceTablePage() {
            this.setName(InputStatementWizard.SOURCE_TABLE_PANEL);
            this.setLayout(new GridBagLayout());
            ExportWizard.InstructionLabel instructionLabel = new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_INSTRUCTION"));
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            SybLabel sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_DB_DESCRIPTION_LABEL"));
            jPanel.add((Component)sybLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_DB_DESCRIPTION_NAME"));
            jPanel.add((Component)sybLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 0, 0), 0, 0));
            this._dbName = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_DB_DESCRIPTION_UNKNOWN"));
            new FontHelper((JLabel)this._dbName);
            jPanel.add((Component)this._dbName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_DB_DESCRIPTION_TYPE"));
            jPanel.add((Component)sybLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 0, 0), 0, 0));
            this._dbType = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_DB_DESCRIPTION_UNKNOWN"));
            jPanel.add((Component)this._dbType, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_DB_DESCRIPTION_VERSION"));
            jPanel.add((Component)sybLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 0, 0), 0, 0));
            this._dbVersion = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_DB_DESCRIPTION_UNKNOWN"));
            jPanel.add((Component)this._dbVersion, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_DATABASES"));
            this._catalogsCB = new SybComboBox();
            this._catalogsCB.addItemListener((ItemListener)this);
            this._catalogPanel = new JPanel(new GridBagLayout());
            this._catalogPanel.setOpaque(false);
            this._catalogPanel.add((Component)sybLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0));
            this._catalogPanel.add((Component)this._catalogsCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
            this._tables = new JTable();
            this._tables.setDefaultRenderer(Object.class, FontHelper.getTableCellRenderer());
            this._ksh = new KeySelectionHelper((JComponent)this._tables);
            this._tables.getTableHeader().setReorderingAllowed(false);
            this._tables.setSelectionMode(0);
            this._tables.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceTablePage.this.getNextPageID() == null) {
                        InputStatementWizard.this.handleImport();
                    } else {
                        InputStatementWizard.this.handleNext();
                    }
                }
            }, KeyStroke.getKeyStroke(10, 0), 0);
            JScrollPane jScrollPane = new JScrollPane(this._tables);
            jScrollPane.setPreferredSize(new Dimension(200, 175));
            this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 20, 0), 0, 0));
            this.add((Component)this._catalogPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)jScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 10, 0), 0, 0));
        }

        @Override
        void destroy() {
            this._tables = null;
            this._ksh.destroy();
            this._ksh = null;
            this._dbVersion = null;
            this._dbType = null;
            this._dbName = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void initialize() {
            if (InputStatementWizard.this._srcConnection != null) {
                ResultSet resultSet = null;
                try {
                    String string;
                    String string2;
                    DatabaseMetaData databaseMetaData;
                    block47: {
                        databaseMetaData = InputStatementWizard.this._srcConnection.getMetaData();
                        string2 = null;
                        this._dbProductName = null;
                        string = null;
                        try {
                            this._dbProductName = databaseMetaData.getDatabaseProductName();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        try {
                            string2 = databaseMetaData.getDatabaseProductVersion();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        try {
                            string = InputStatementWizard.this._srcConnection.getCatalog();
                            string = ExportWizard.sanitizeString(string);
                        }
                        catch (SQLException sQLException) {
                            if (this._dbProductName == null || this._dbProductName.indexOf("SQL Anywhere") == -1 && this._dbProductName.indexOf("Adaptive Server Anywhere") == -1) break block47;
                            Statement statement = null;
                            resultSet = null;
                            try {
                                statement = InputStatementWizard.this._srcConnection.createStatement();
                                resultSet = statement.executeQuery("select db_name()");
                                if (resultSet.next()) {
                                    string = resultSet.getString(1);
                                }
                            }
                            catch (SQLException sQLException2) {
                            }
                            finally {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (SQLException sQLException3) {}
                                }
                                if (statement != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (SQLException sQLException4) {}
                                }
                            }
                        }
                    }
                    if (string != null) {
                        this._dbName.setText(string);
                    }
                    if (this._dbProductName != null) {
                        this._dbType.setText(this._dbProductName);
                    }
                    if (string2 != null) {
                        this._dbVersion.setText(string2);
                    }
                    Vector<String> vector = new Vector<String>();
                    resultSet = null;
                    try {
                        resultSet = databaseMetaData.getCatalogs();
                        while (resultSet.next()) {
                            string = resultSet.getString(1);
                            if (string == null || string.isEmpty()) continue;
                            vector.add(string);
                        }
                    }
                    catch (SQLException sQLException) {
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                            resultSet = null;
                        }
                    }
                    if (vector.size() == 0) {
                        this._catalogPanel.setVisible(false);
                    } else {
                        this._catalogsCB.setModel(new DefaultComboBoxModel(vector));
                        this._catalogPanel.setVisible(true);
                    }
                    this.refreshTableList();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshTableList() {
            Object object;
            ResultSet resultSet = null;
            String string = null;
            if (this._catalogPanel.isVisible() && (object = this._catalogsCB.getSelectedItem()) != null) {
                string = object.toString();
            }
            ArrayList<TableInfo> arrayList = new ArrayList<TableInfo>();
            try {
                DatabaseMetaData databaseMetaData = InputStatementWizard.this._srcConnection.getMetaData();
                resultSet = databaseMetaData.getTables(!InputStatementWizard.this._srcSQLNeedsCatalog ? null : string, null, "%", null);
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    String string5 = resultSet.getString(4);
                    if (string5.toLowerCase().indexOf("system") != -1 || string3 != null && string3.toLowerCase().equals("sys") || string5.toLowerCase().indexOf("view") != -1 || string5.toLowerCase().indexOf("local temporary") != -1 || string3 != null && string3.equalsIgnoreCase("dbo") && this._dbProductName != null && this._dbProductName.equals("SQL Anywhere")) continue;
                    arrayList.add(new TableInfo(string2, string3, string4, string5));
                }
                resultSet.close();
                resultSet = null;
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                    resultSet = null;
                }
            }
            int n = 1;
            if (InputStatementWizard.this._srcSQLNeedsSchema) {
                ++n;
            }
            int n2 = arrayList.size();
            Object[][] objectArray = new Object[n2][n];
            for (int i = 0; i < n2; ++i) {
                TableInfo tableInfo = (TableInfo)arrayList.get(i);
                objectArray[i][0] = tableInfo.tableName;
                if (!InputStatementWizard.this._srcSQLNeedsSchema) continue;
                objectArray[i][1] = tableInfo.owner;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_TABLE_NAME_COLUMN"));
            if (InputStatementWizard.this._srcSQLNeedsSchema) {
                arrayList2.add(InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_OWNER_COLUMN"));
            }
            Object[] objectArray2 = new Object[arrayList2.size()];
            arrayList2.toArray(objectArray2);
            this._tables.setModel(new ReadOnlyTableModel(objectArray, objectArray2));
            TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(this._tables.getModel());
            ArrayList<RowSorter.SortKey> arrayList3 = new ArrayList<RowSorter.SortKey>();
            arrayList3.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            if (n > 1) {
                arrayList3.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            }
            if (n > 2) {
                arrayList3.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
            }
            tableRowSorter.setSortKeys(arrayList3);
            this._tables.setRowSorter(tableRowSorter);
            if (this._tables.getRowCount() > 0) {
                this._tables.setRowSelectionInterval(0, 0);
            }
        }

        @Override
        void setInitialFocus() {
            this._tables.requestFocusInWindow();
        }

        @Override
        String getNextPageID() {
            return InputStatementWizard.TABLE_NAME_PANEL;
        }

        @Override
        String getPreviousPageID() {
            return InputStatementWizard.DSN_PANEL;
        }

        @Override
        void commit() {
            int n = this._tables.getSelectedRow();
            if (n != -1) {
                Object object;
                ((InputStatementWizard)InputStatementWizard.this)._options.odbcTableName = this._tables.getValueAt(n, 0).toString();
                if (InputStatementWizard.this._srcSQLNeedsSchema) {
                    object = this._tables.getValueAt(n, 1);
                    ((InputStatementWizard)InputStatementWizard.this)._options.odbcSchema = object != null ? object.toString() : null;
                }
                if (InputStatementWizard.this._srcSQLNeedsCatalog) {
                    object = this._catalogsCB.getSelectedItem();
                    ((InputStatementWizard)InputStatementWizard.this)._options.odbcCatalog = object != null ? object.toString() : null;
                }
            } else {
                ((InputStatementWizard)InputStatementWizard.this)._options.odbcCatalog = null;
                ((InputStatementWizard)InputStatementWizard.this)._options.odbcSchema = null;
                ((InputStatementWizard)InputStatementWizard.this)._options.odbcTableName = null;
            }
        }

        @Override
        boolean hasValidData() {
            if (((InputStatementWizard)InputStatementWizard.this)._options.odbcTableName == null) {
                SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getISQLString("IW_SRC_TABLE_PAGE_SELECT_A_TABLE"), (String)InputStatementWizard.this.getTitle(), (int)0);
                this._tables.requestFocusInWindow();
                return false;
            }
            return true;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.refreshTableList();
        }

        class TableInfo {
            String database;
            String owner;
            String tableName;
            String type;

            TableInfo(String string, String string2, String string3, String string4) {
                this.database = string;
                this.owner = string2;
                this.tableName = string3;
                this.type = string4;
            }
        }
    }

    class TextFormatPanel
    extends WizardPanel
    implements ActionListener {
        private MRUComboBox _mruFileName;
        private SybButton _pbBrowse;
        private SybCheckBox _cbFixedFormat;

        TextFormatPanel() {
            this.setName(InputStatementWizard.TEXT_FORMAT_PANEL);
            this.setLayout(new GridBagLayout());
            ExportWizard.InstructionLabel instructionLabel = new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("IW_TEXT_FORMAT_PANEL_INSTRUCTION"));
            SybLabel sybLabel = new SybLabel(InputStatementWizard.this._bundle.getISQLString("IW_TEXT_FORMAT_PANEL_FILE_NAME_LABEL"));
            this._mruFileName = new MRUComboBox(Preferences.getImportWizardMRUFileNameList());
            new FontHelper((JComboBox)this._mruFileName);
            sybLabel.setLabelFor((Component)this._mruFileName);
            this._pbBrowse = new SybButton(InputStatementWizard.this._bundle.getISQLString("IW_TEXT_FORMAT_PANEL_BROWSE_BUTTON"));
            this._pbBrowse.addActionListener((ActionListener)this);
            this._cbFixedFormat = new SybCheckBox(InputStatementWizard.this._bundle.getISQLString("IW_TEXT_FORMAT_PANEL_FIXED_WIDTH_CHECKBOX"));
            this._cbFixedFormat.setOpaque(false);
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)sybLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this._mruFileName, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this._pbBrowse, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this._cbFixedFormat, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 99, 1, 1, 0.0, 1.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        void destroy() {
            this._mruFileName = null;
            this._pbBrowse.removeActionListener((ActionListener)this);
            this._pbBrowse = null;
            this._cbFixedFormat = null;
        }

        @Override
        void initialize() {
            int n;
            String string = InputStatementWizard.this._options.getFileName();
            if (string != null) {
                this._mruFileName.setSelectedItem((Object)string);
            }
            if ((n = InputStatementWizard.this._options.getFormat()) == 2) {
                this._cbFixedFormat.setSelected(true);
            }
        }

        @Override
        void setInitialFocus() {
            this._mruFileName.requestFocusInWindow();
        }

        @Override
        boolean hasValidData() {
            File file;
            String string = this._mruFileName.getStringValue();
            if (string.length() == 0) {
                SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getISQLString("IW_TEXT_FORMAT_PANEL_MISSING_FILE_NAME"), (String)InputStatementWizard.this._bundle.getISQLString("Import Wizard"), (int)0);
                this._mruFileName.requestFocusInWindow();
                return false;
            }
            if (string.length() != 0 && !(file = new File(string)).exists()) {
                SybOptionPane.showMessageDialog((Component)this, (Object)InputStatementWizard.this._bundle.getFormattedString("IW_TEXT_FORMAT_PANEL_MISSING_FILE", string), (String)InputStatementWizard.this._bundle.getISQLString("Import Wizard"), (int)0);
                this._mruFileName.requestFocusInWindow();
                return false;
            }
            return true;
        }

        @Override
        void commit() {
            String string = this._mruFileName.getStringValue();
            if (string.length() != 0) {
                InputStatementWizard.this._options.setFileName(string);
            }
            int n = InputStatementWizard.this._options.getFormat();
            int n2 = this._cbFixedFormat.isSelected() ? 2 : 1;
            InputStatementWizard.this._options.setFormat(n2);
            if (n2 != n) {
                InputStatementWizard.this._columnCount = -1;
                InputStatementWizard.access$402(InputStatementWizard.this, null);
                InputStatementWizard.access$502(InputStatementWizard.this, null);
                InputStatementWizard.access$602(InputStatementWizard.this, null);
                InputStatementWizard.access$702(InputStatementWizard.this, null);
                InputStatementWizard.access$802(InputStatementWizard.this, null);
                InputStatementWizard.this._options.setColumnList(new Vector<String>());
                InputStatementWizard.this._colWidthPanel.setInitialized(false);
                InputStatementWizard.this._asciiPanel.setInitialized(false);
                InputStatementWizard.this._columnDetailsPanel.setInitialized(false);
            }
        }

        @Override
        String getPreviousPageID() {
            return InputStatementWizard.SOURCE_TYPE_PANEL;
        }

        @Override
        String getNextPageID() {
            int n = InputStatementWizard.this._options.getFormat();
            if (n == 1 || n == 2) {
                return InputStatementWizard.TABLE_NAME_PANEL;
            }
            return InputStatementWizard.DSN_PANEL;
        }

        @Override
        protected void saveMRULists() {
            if (InputStatementWizard.this._options.getFormat() != 14) {
                Preferences.setImportWizardMRUFileNameList(this._mruFileName.getMRUList());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._pbBrowse) {
                this.handleBrowse();
            }
        }

        private void handleBrowse() {
            SybFileChooser sybFileChooser = new SybFileChooser(17);
            sybFileChooser.setFilters(new SybFileFilter[]{new SybFileFilter(new String[]{"csv", "txt"}, InputStatementWizard.this._bundle.getISQLString("ASCII/Fixed (*.{0})")), SybFileFilter.getAllFilesFilter()}, 0);
            File file = ISQLPanel.getInitialBrowserDirectory(InputStatementWizard.this._connection, "lastImportFolder", "lastExportFolder");
            if (sybFileChooser.showDialog((Window)InputStatementWizard.this, file, null)) {
                File file2 = sybFileChooser.getSelectedFile();
                this._mruFileName.setSelectedItem((Object)file2.toString());
                Preferences.setStringOption(InputStatementWizard.this._connection, "lastImportFolder", file2.getParent());
            }
        }
    }

    class SourceTypePanel
    extends WizardPanel {
        private SybRadioButton _rbTextFile;
        private SybRadioButton _rbODBC;

        SourceTypePanel() {
            this.setName(InputStatementWizard.SOURCE_TYPE_PANEL);
            this.setLayout(new GridBagLayout());
            ExportWizard.InstructionLabel instructionLabel = new ExportWizard.InstructionLabel(InputStatementWizard.this._bundle.getISQLString("IW_SRCTYPE_PANEL_INSTRUCTION"));
            this.add((Component)((Object)instructionLabel), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 10, 0), 0, 0));
            this._rbTextFile = new SybRadioButton(InputStatementWizard.this._bundle.getISQLString("IW_SRCTYPE_PANEL_TEXT_FILE"));
            this._rbTextFile.setOpaque(false);
            this._rbODBC = new SybRadioButton(InputStatementWizard.this._bundle.getISQLString("IW_SRCTYPE_PANEL_ODBC_DATABASE"));
            this._rbODBC.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._rbTextFile);
            buttonGroup.add((AbstractButton)this._rbODBC);
            this.add((Component)this._rbTextFile, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._rbODBC, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 99, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        void destroy() {
            this._rbTextFile = null;
            this._rbODBC = null;
        }

        @Override
        String getPreviousPageID() {
            return null;
        }

        @Override
        String getNextPageID() {
            String string = InputStatementWizard.this._inputFromFile ? InputStatementWizard.TEXT_FORMAT_PANEL : InputStatementWizard.DSN_PANEL;
            return string;
        }

        @Override
        boolean hasValidData() {
            return true;
        }

        @Override
        void commit() {
            InputStatementWizard.this._inputFromFile = this._rbTextFile.isSelected();
            int n = InputStatementWizard.this._options.getFormat();
            int n2 = InputStatementWizard.this._inputFromFile ? 1 : 14;
            if (n != n2) {
                InputStatementWizard.this._options.setFormat(n2);
                InputStatementWizard.this._options.setFileName(null);
            }
        }

        @Override
        void setInitialFocus() {
            if (this._rbTextFile.isSelected()) {
                this._rbTextFile.requestFocusInWindow();
            } else {
                this._rbODBC.requestFocusInWindow();
            }
        }

        @Override
        void initialize() {
            if (InputStatementWizard.this._inputFromFile) {
                this._rbTextFile.setSelected(true);
            }
        }
    }

    abstract class WizardPanel
    extends JPanel {
        protected boolean _initialized = false;

        abstract String getPreviousPageID();

        abstract String getNextPageID();

        abstract boolean hasValidData();

        abstract void commit();

        abstract void setInitialFocus();

        abstract void initialize();

        abstract void destroy();

        boolean isInitialized() {
            return this._initialized;
        }

        void setInitialized(boolean bl) {
            this._initialized = bl;
        }

        protected void saveMRULists() {
        }

        WizardPanel() {
            this.setBackground(SystemColor.window);
            this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        }
    }
}

