/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.util.Vector;
import sybase.isql.DataTypeMetaData;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.IODataClient;
import sybase.isql.IOFilter;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLResource;
import sybase.isql.Importer;
import sybase.isql.ImporterFailedException;
import sybase.isql.InputOutputOptions;
import sybase.isql.TableGenitor;
import sybase.isql.TableInfo;
import sybase.isql.isql;

class InteractiveImporter
implements Importer,
TableGenitor {
    private InputOutputOptions _options;
    private TableInfo _tableInfo = null;
    private int _columnCount = -1;
    private Vector<Object> _rowData = null;

    InteractiveImporter(InputOutputOptions inputOutputOptions) {
        this._options = inputOutputOptions;
    }

    @Override
    public boolean open(ISQLConnection iSQLConnection) {
        return true;
    }

    @Override
    public void readMetaData(ISQLConnection iSQLConnection) {
    }

    @Override
    public boolean createTable(ISQLConnection iSQLConnection) {
        String string;
        String string2;
        String string3 = this._options.getCatalog();
        boolean bl = iSQLConnection.tableExists(string3, string2 = this._options.getOwner(), string = this._options.getTableName());
        if (bl) {
            this._tableInfo = iSQLConnection.getTableInfo(string3, string2, string);
            this._columnCount = this._tableInfo.column.length;
        } else {
            isql.getIO(iSQLConnection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "The table you selected ({0}) does not exist. Create it first, then try importing the data again.", string), 0);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean populateTable(final ISQLConnection iSQLConnection) {
        boolean bl = true;
        IODataClient iODataClient = new IODataClient(){

            @Override
            public int submitData(Object object, Object[] objectArray) {
                boolean bl;
                InteractiveImporter.this._rowData = new Vector(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    InteractiveImporter.this._rowData.add(objectArray[i]);
                }
                Vector<String> vector = new Vector<String>();
                try {
                    bl = iSQLConnection.addTableData(InteractiveImporter.this._options.getCatalog(), InteractiveImporter.this._options.getOwner(), InteractiveImporter.this._options.getTableName(), InteractiveImporter.this, vector);
                }
                catch (ImporterFailedException importerFailedException) {
                    bl = false;
                    vector.add(importerFailedException.getLocalizedMessage());
                }
                if (!bl && vector.size() != 0) {
                    Component component = object != null && object instanceof Component ? (Component)object : null;
                    SybOptionPane.showMessageDialog((Component)component, (Object)vector.elementAt(0), (String)ISQLResource.getISQLString(GeneralResources.getName(), "Interactive Input"), (int)0);
                }
                return bl ? -1 : 0;
            }
        };
        String string = isql.options.useGUI ? ISQLResource.getFormattedString(GeneralResources.getName(), "You are adding data to table \"{0}\".\nEnter column values in the fields below, then click Add or Done.", this._options.getTableName()) : ISQLResource.getFormattedString(GeneralResources.getName(), "INTERACTIVE_EXPLANATION_NOGUI", this._options.getTableName());
        String[] stringArray = new String[this._columnCount];
        Class[] classArray = new Class[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            stringArray[i] = this._tableInfo.column[i].name;
            classArray[i] = String.class;
        }
        IO iO = isql.getIO(iSQLConnection);
        IOFilter iOFilter = new IOFilter(iO){

            @Override
            public void writeln(Exception exception, String string, int n) {
                this.writeln(string, n);
            }

            @Override
            public void writeln(String string, int n) {
                if (n == 0) {
                    super.writeln(string, n);
                } else {
                    isql.getDefaultIO().writeln(string, n);
                }
            }
        };
        isql.setIO(iSQLConnection, iOFilter);
        iOFilter.promptForData(string, stringArray, classArray, null, 1, iODataClient);
        isql.setIO(iSQLConnection, iO);
        iOFilter = null;
        return bl;
    }

    @Override
    public boolean close() {
        this._rowData = null;
        this._tableInfo = null;
        this._columnCount = -1;
        this._options = null;
        return true;
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public boolean knowsColumnNames() {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this._tableInfo.column[n].name;
    }

    @Override
    public DataTypeMetaData getColumnTypeMetaData(int n) {
        return this._tableInfo.column[n].type;
    }

    @Override
    public int getColumnWidth(int n) {
        return this._tableInfo.column[n].width;
    }

    @Override
    public int getColumnScale(int n) {
        return 6;
    }

    @Override
    public boolean isColumnInPrimaryKey(int n) {
        return false;
    }

    @Override
    public boolean isNullableColumn(int n) {
        return true;
    }

    @Override
    public Vector<Object> getRowData() {
        Vector<Object> vector = this._rowData;
        this._rowData = null;
        return vector;
    }

    @Override
    public boolean moveNext() {
        return this._rowData != null;
    }

    @Override
    public boolean keepGoing(ISQLConnection iSQLConnection) {
        return true;
    }
}

