/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class LimitedTextField
extends JTextField {
    LimitedTextField(int n) {
        this.setDocument(new LimitedDocument(n));
    }

    static class LimitedDocument
    extends PlainDocument {
        int _limit;

        LimitedDocument(int n) {
            this._limit = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null) {
                if (this.getLength() + string.length() <= this._limit) {
                    super.insertString(n, string, attributeSet);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

