/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import sybase.isql.ErrorMessages;
import sybase.isql.IO;
import sybase.isql.ISQLResource;

class LogFile {
    private OutputStreamWriter _file = null;
    private boolean _warnAboutLogFailures = true;

    LogFile() {
    }

    boolean open(String string, boolean bl, IO iO) {
        if (this._file != null) {
            this.close(iO);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
            this._file = new OutputStreamWriter(fileOutputStream);
        }
        catch (IOException iOException) {
            iO.writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not create/open log file.\n{0}", iOException.getMessage()), 2);
            this._file = null;
        }
        return this._file != null;
    }

    boolean isOpen() {
        return this._file != null;
    }

    void write(String string, IO iO) {
        block3: {
            if (this._file != null) {
                try {
                    this._file.write(string);
                    this._file.write("\n");
                    this._file.flush();
                }
                catch (IOException iOException) {
                    if (!this._warnAboutLogFailures) break block3;
                    this._warnAboutLogFailures = false;
                    iO.writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not write to log file.\n{0}\nFurther errors writing to this file will not be reported.", iOException.getMessage()), 2);
                }
            }
        }
    }

    void close(IO iO) {
        if (this._file != null) {
            try {
                this._file.close();
                this._file = null;
            }
            catch (IOException iOException) {
                iO.writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not close log file.\n{0}", iOException.getMessage()), 2);
            }
        }
    }
}

