/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.customization.CustomizeDialog;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sybase.isql.BasePage;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;
import sybase.isql.Preferences;

class MessagesPage
extends BasePage {
    private int _opt_messageLines;
    private boolean _opt_timeCommands;
    private boolean _opt_showSeparateMessagesPane;
    private SybCheckBox _timeCommands;
    private JTextField _messageLines;
    private SybCheckBox _showSeparateMessagesPane;

    MessagesPage(CustomizeDialog customizeDialog, ISQLConnection iSQLConnection) {
        super(customizeDialog, iSQLConnection);
        this.readSettings();
        this.createUI();
    }

    private void readSettings() {
        this._opt_messageLines = Preferences.getIntOption(this._connection, "defaultMessagesPaneHeight", false);
        this._opt_showSeparateMessagesPane = Preferences.getBooleanOption(this._connection, "showSeparateMessagesPane", false);
        this._opt_timeCommands = Preferences.getBooleanOption(this._connection, "ISQL_command_timing", false);
    }

    private void createUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.createTimeCommandsPanel());
        this._showSeparateMessagesPane = new SybCheckBox(ISQLResource.getISQLString(GeneralResources.getName(), "Show separate messages pane"));
        if (this._opt_showSeparateMessagesPane) {
            this._showSeparateMessagesPane.setSelected(true);
        }
        this.add((Component)this._showSeparateMessagesPane);
        this.add(this.createMessagesLinesPanel());
        this.add(Box.createVerticalGlue());
    }

    public String getTitle() {
        return ISQLResource.getISQLString(GeneralResources.getName(), "Messages");
    }

    @Override
    public void destroy() {
        this._timeCommands = null;
        this._messageLines = null;
        super.destroy();
    }

    public void showHelp() {
        ISQLHelpManager.showHelp((ISQLConnectionImpl)this._connection, (Window)this._parent, "HELP_ISQL_OPTIONS_MESSAGES");
    }

    public Component getComponent() {
        return this;
    }

    private JPanel createMessagesLinesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        SybLabel sybLabel = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "Default number of lines in Messages pane:"));
        this._messageLines = new JTextField(16);
        this._messageLines.setText(Integer.toString(this._opt_messageLines));
        Dimension dimension = this._messageLines.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        this._messageLines.setMaximumSize(dimension);
        sybLabel.setLabelFor((Component)this._messageLines);
        jPanel.add((Component)sybLabel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this._messageLines);
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    private JPanel createTimeCommandsPanel() {
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this._timeCommands = new SybCheckBox(iSQLResource.getISQLString("Measure execution time for SQL statements"));
        this._timeCommands.setSelected(this._opt_timeCommands);
        jPanel.add((Component)this._timeCommands);
        return jPanel;
    }

    @Override
    public void acceptChanges() {
        this._opt_timeCommands = this._timeCommands.isSelected();
        this._opt_showSeparateMessagesPane = this._showSeparateMessagesPane.isSelected();
        try {
            this._opt_messageLines = Integer.parseInt(this._messageLines.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Preferences.setBooleanOption(this._connection, "ISQL_command_timing", this._opt_timeCommands);
        Preferences.setBooleanOption(this._connection, "showSeparateMessagesPane", this._opt_showSeparateMessagesPane);
        Preferences.setIntOption(this._connection, "defaultMessagesPaneHeight", this._opt_messageLines);
    }

    @Override
    public Icon getCustomizationGroupIcon() {
        return ISQLImages.getImageIcon("message16");
    }
}

