/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.util.Platform;
import com.sybase.util.win32.Registry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Vector;
import sybase.isql.DataTypeMetaData;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLPluginException;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.OutputStatement;
import sybase.isql.ParentFrame;
import sybase.isql.PluginMgr;
import sybase.isql.UnbufferedISQLResultSet;
import sybase.isql.WindowManager;
import sybase.isql.isql;

class ODBCExporter
implements Runnable {
    private ISQLConnectionImpl _connection = null;
    private ISQLResultSet _resultSet = null;
    private ISQLPlugin _plugin = null;
    private String _connectionString = null;
    private String _dstCatalog = null;
    private String _dstOwner = null;
    private String _dstTable = null;
    private boolean _createTable = true;
    private Vector<String> _errorMessages = null;
    private boolean _retcode = false;
    private Connection _odbcConnection = null;
    private String _failedConnectionMessage = null;
    private PreparedStatement _insertStatement = null;
    private boolean _moreData = true;
    private int _rowNumber = -1;
    private ArrayList<DataTypeMetaData> _dataTypes = null;
    private int[] _dstColumnTypes = null;
    private String _databaseProductName = null;
    private String _quoteString = "";
    private int _maxColumnNameLength;
    private boolean _supportsCatalogsInTableDefinitions = false;
    private boolean _supportsSchemasInTableDefinitions = false;
    private boolean _supportsCatalogsInDataManipulation = false;
    private boolean _supportsSchemasInDataManipulation = false;

    static boolean export(ISQLConnectionImpl iSQLConnectionImpl, ISQLPlugin iSQLPlugin, String string, String string2, String string3, String string4, boolean bl, Vector<String> vector) {
        ODBCExporter oDBCExporter;
        boolean bl2;
        block5: {
            bl2 = false;
            ISQLResultSet[] iSQLResultSetArray = OutputStatement.getResultSetsForLastStatement(iSQLConnectionImpl);
            if (iSQLResultSetArray == null) {
                vector.add(ISQLResource.getISQLString(ErrorMessages.getName(), "Could not execute OUTPUT statement because no result set was available."));
                return false;
            }
            if (iSQLResultSetArray.length > 1) {
                vector.add(ISQLResource.getISQLString(ErrorMessages.getName(), "OUTPUT_FAILED_TOO_MANY_RESULTS"));
                return false;
            }
            if (iSQLPlugin == null && (iSQLPlugin = ODBCExporter.getPluginFromConnectionString(string)) == null) {
                iSQLPlugin = iSQLConnectionImpl.getPlugin();
            }
            oDBCExporter = new ODBCExporter(iSQLConnectionImpl, iSQLResultSetArray[0], iSQLPlugin, string, string2, string3, string4, bl, vector);
            try {
                oDBCExporter._retcode = true;
                oDBCExporter.setImporterActive(true);
                iSQLConnectionImpl.executeOnWorkerThread(oDBCExporter, true);
                oDBCExporter.setImporterActive(false);
                bl2 = oDBCExporter._retcode;
            }
            catch (Exception exception) {
                if (!(exception instanceof RuntimeException)) break block5;
                throw (RuntimeException)exception;
            }
        }
        oDBCExporter.destroy();
        return bl2;
    }

    static ISQLPlugin getPluginFromConnectionString(String string) {
        ISQLPlugin iSQLPlugin = null;
        if (string != null) {
            int n = string.toLowerCase().indexOf("driver=");
            if (n != -1) {
                String string2 = string.substring(n + 7);
                if ((n = string2.indexOf(59)) != -1) {
                    string2 = string2.substring(0, n);
                }
                iSQLPlugin = PluginMgr.getPluginForODBCDriver(string2);
            } else {
                n = string.toLowerCase().indexOf("dsn=");
                if (n != -1) {
                    String string3 = string.substring(n + 4);
                    if ((n = string3.indexOf(59)) != -1) {
                        string3 = string3.substring(0, n);
                    }
                    iSQLPlugin = PluginMgr.getPluginForODBCDSN(string3);
                } else {
                    n = string.indexOf("<HOST>=");
                    if (n != -1) {
                        iSQLPlugin = PluginMgr.getPlugin("ASE");
                    }
                }
            }
        }
        return iSQLPlugin;
    }

    private ODBCExporter(ISQLConnectionImpl iSQLConnectionImpl, ISQLResultSet iSQLResultSet, ISQLPlugin iSQLPlugin, String string, String string2, String string3, String string4, boolean bl, Vector<String> vector) {
        this._connection = iSQLConnectionImpl;
        this._resultSet = iSQLResultSet;
        this._plugin = iSQLPlugin;
        this._connectionString = string;
        this._dstCatalog = string2;
        this._dstOwner = string3;
        this._dstTable = string4;
        this._createTable = bl;
        this._errorMessages = vector;
    }

    private void destroy() {
        this._connection = null;
        this._resultSet = null;
        this._errorMessages = null;
    }

    private void setImporterActive(boolean bl) {
        ParentFrame parentFrame;
        if (isql.options.useGUI && (parentFrame = WindowManager.findFrameByConnection(this._connection)) != null) {
            parentFrame.setOutputStatementInProgress(bl);
        }
    }

    @Override
    public void run() {
        long l = 0L;
        IO iO = null;
        iO = isql.getIO(this._connection);
        if (this.connect()) {
            boolean bl;
            ISQLResultSet iSQLResultSet;
            if (!OutputStatement.canExportResultSetAsIs(this._resultSet)) {
                try {
                    iSQLResultSet = new UnbufferedISQLResultSet(this._resultSet, this._connection);
                }
                catch (SQLException sQLException) {
                    this._errorMessages.add(ISQLResource.getFormattedString(ErrorMessages.getName(), "OUTPUT_STATEMENT_REEXECUTE_FAILED", isql.formatSQLExceptionMessage(sQLException)));
                    this._retcode = false;
                    this.disconnect();
                    return;
                }
                bl = true;
            } else {
                iSQLResultSet = this._resultSet;
                bl = false;
            }
            int n = iSQLResultSet.getColumnCount();
            this._dataTypes = this.getDataTypes();
            if (this._dataTypes.size() == 0) {
                this._errorMessages.add(ISQLResource.getISQLString(ErrorMessages.getName(), "ODBC_EXPORT_CANT_DESCRIBE_TYPES"));
                this._retcode = false;
                this.disconnect();
                return;
            }
            this._dstColumnTypes = new int[n];
            for (int i = 0; i < n; ++i) {
                this._dstColumnTypes[i] = this.getBestDataTypeIndex(i);
                if (this._dstColumnTypes[i] != -1) continue;
                this._errorMessages.add(ISQLResource.getFormattedString(ErrorMessages.getName(), "ODBC_EXPORT_CANT_MAP_TYPE", this._resultSet.getColumnTypeName(i)));
                this._retcode = false;
                this.disconnect();
                return;
            }
            String string = ISQLResource.getFormattedString(GeneralResources.getName(), "Exporting data to \"{0}\"", this._dstTable);
            iO.writeln(string, 0);
            boolean bl2 = this.destinationTableExists();
            if (!bl2) {
                if (this._createTable) {
                    boolean bl3 = false;
                    try {
                        bl3 = this._odbcConnection.getAutoCommit();
                        if (!bl3) {
                            this._odbcConnection.setAutoCommit(true);
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    bl2 = this.createDestinationTable();
                    if (!bl3) {
                        try {
                            this._odbcConnection.setAutoCommit(false);
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    iO.writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "ODBC_EXPORT_DST_TABLE_DOES_NOT_EXIST", this._dstTable), 2);
                    this._rowNumber = 0;
                }
            }
            if (bl2 && this.prepareInsertStatement()) {
                while (this.moveSomeData(iSQLResultSet)) {
                    long l2 = System.currentTimeMillis();
                    if (l2 - l >= 750L) {
                        iO.showProgress(ISQLResource.getFormattedString(GeneralResources.getName(), "Writing row {0}", Integer.toString(this._rowNumber)), -1);
                        l = l2;
                    }
                    if (this.keepGoing()) continue;
                }
                this.closePreparedStatement();
            }
            if (bl) {
                iSQLResultSet.close();
            }
            this.disconnect();
            if (this._retcode) {
                string = ISQLResource.getFormattedString(GeneralResources.getName(), "{0} rows written", Integer.toString(this._rowNumber), this._dstTable);
                iO.showProgress(string, -1);
                iO.writeln(string, 0);
            } else {
                isql.getIO(iSQLResultSet.getConnection()).showProgress("", -1);
            }
        } else {
            iO.writeln(this._failedConnectionMessage, 2);
            this._retcode = false;
        }
    }

    private boolean prepareInsertStatement() {
        boolean bl;
        int n;
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("INSERT INTO ");
        stringBuilder.append(this.quoteOwnerAndTableName(false));
        int n2 = this._resultSet.getColumnCount();
        stringBuilder.append(" (");
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.quoteIdentifier(this._resultSet.getColumnName(n)));
        }
        stringBuilder.append(") ");
        stringBuilder.append("VALUES (");
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                stringBuilder.append(",");
            }
            if (this._databaseProductName.equals("Oracle")) {
                switch (this._resultSet.getColumnSQLType(n)) {
                    case 91: {
                        stringBuilder.append("to_date(?,'yyyy-mm-dd')");
                        break;
                    }
                    case 92: {
                        stringBuilder.append("to_date(?,'hh24:mi:ss')");
                        break;
                    }
                    case 93: {
                        stringBuilder.append("to_date(?,'yyyy-mm-dd hh24:mi:ss')");
                        break;
                    }
                    default: {
                        stringBuilder.append('?');
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append('?');
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            this._insertStatement = this._odbcConnection.prepareStatement(string);
            bl = true;
        }
        catch (SQLException sQLException) {
            this._errorMessages.add(sQLException.getLocalizedMessage());
            this._retcode = false;
            bl = false;
        }
        return bl;
    }

    private void closePreparedStatement() {
        if (this._insertStatement != null) {
            try {
                this._insertStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._insertStatement = null;
        }
    }

    private boolean keepGoing() {
        ParentFrame parentFrame;
        boolean bl = this._moreData;
        if (bl && isql.options.useGUI && (parentFrame = WindowManager.findFrameByConnection(this._connection)) != null) {
            if (parentFrame.isInterruptRequested(1)) {
                parentFrame.clearInterrupt(1);
                bl = false;
                isql.getIO(this._connection).showProgress(null, -1);
                isql.getIO(this._connection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "Operation was cancelled"), 0);
            }
        }
        return bl;
    }

    private boolean moveSomeData(ISQLResultSet iSQLResultSet) {
        boolean bl = true;
        int n = 0;
        try {
            int n2 = iSQLResultSet.getColumnCount();
            ++this._rowNumber;
            if (iSQLResultSet.rowExists(this._rowNumber)) {
                for (n = 0; n < n2; ++n) {
                    int n3 = this._dataTypes.get(this._dstColumnTypes[n]).getSQLType();
                    Object object = iSQLResultSet.getValueAt(this._rowNumber, n);
                    if (object != null) {
                        char c;
                        Object object2;
                        if (this._databaseProductName.equals("Oracle") && (object instanceof Date || object instanceof Time || object instanceof Timestamp)) {
                            object2 = Calendar.getInstance();
                            ((Calendar)object2).setTime((java.util.Date)object);
                            StringBuilder stringBuilder = new StringBuilder();
                            if (object instanceof Date || object instanceof Timestamp) {
                                int n4 = ((Calendar)object2).get(1);
                                if (n4 < 1000) {
                                    stringBuilder.append('0');
                                }
                                if (n4 < 100) {
                                    stringBuilder.append('0');
                                }
                                if (n4 < 10) {
                                    stringBuilder.append('0');
                                }
                                stringBuilder.append(Integer.toString(n4));
                                stringBuilder.append('-');
                                c = ((Calendar)object2).get(2) + 1;
                                if (c < '\n') {
                                    stringBuilder.append('0');
                                }
                                stringBuilder.append(Integer.toString(c));
                                stringBuilder.append('-');
                                int n5 = ((Calendar)object2).get(5);
                                if (n5 < 10) {
                                    stringBuilder.append('0');
                                }
                                stringBuilder.append(Integer.toString(n5));
                            }
                            if (object instanceof Timestamp) {
                                stringBuilder.append(' ');
                            }
                            if (object instanceof Time || object instanceof Timestamp) {
                                int n6 = ((Calendar)object2).get(11);
                                if (n6 < 10) {
                                    stringBuilder.append('0');
                                }
                                stringBuilder.append(Integer.toString(n6));
                                stringBuilder.append(':');
                                int n7 = ((Calendar)object2).get(12);
                                if (n7 < 10) {
                                    stringBuilder.append('0');
                                }
                                stringBuilder.append(Integer.toString(n7));
                                stringBuilder.append(':');
                                int n8 = ((Calendar)object2).get(13);
                                if (n8 < 10) {
                                    stringBuilder.append('0');
                                }
                                stringBuilder.append(Integer.toString(n8));
                            }
                            object = stringBuilder.toString();
                        }
                        if (this._databaseProductName.equals("EXCEL")) {
                            if (Platform.isWindows() && Registry.isInstalled() && (object instanceof BigDecimal || object instanceof Double || object instanceof Float)) {
                                String string = object.toString();
                                object2 = Registry.getValue((int)1, (String)"Control Panel\\International", (String)"sDecimal");
                                c = DecimalFormatSymbols.getInstance().getDecimalSeparator();
                                if (object2 != null && !((String)object2).isEmpty() && ((String)object2).charAt(0) != c && string.indexOf(c) != -1) {
                                    string = string.replace(new String(new char[]{c}), (CharSequence)object2);
                                }
                                object = string;
                            } else if (n3 == 92 || n3 == 91 || n3 == 93) {
                                object = object.toString();
                            }
                        }
                        if (object instanceof byte[]) {
                            this._insertStatement.setBytes(n + 1, (byte[])object);
                            continue;
                        }
                        if (object instanceof ByteArrayInputStream) {
                            try {
                                object2 = (ByteArrayInputStream)object;
                                byte[] byArray = new byte[((ByteArrayInputStream)object2).available()];
                                c = ((InputStream)object2).read(byArray);
                                if (c != byArray.length) {
                                    byte[] byArray2 = new byte[c];
                                    System.arraycopy(byArray, 0, byArray2, 0, c);
                                    byArray = byArray2;
                                }
                                this._insertStatement.setBytes(n + 1, byArray);
                                continue;
                            }
                            catch (IOException iOException) {
                                throw new SQLException(iOException);
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                throw new SQLException(outOfMemoryError);
                            }
                        }
                        if (object instanceof LongBinaryValue) {
                            this._insertStatement.setBytes(n + 1, ((LongBinaryValue)object).getTruncatedValue());
                            continue;
                        }
                        if (object instanceof Boolean) {
                            this._insertStatement.setBoolean(n + 1, (Boolean)object);
                            continue;
                        }
                        if (object instanceof Integer) {
                            this._insertStatement.setInt(n + 1, (Integer)object);
                            continue;
                        }
                        if (object instanceof Short) {
                            this._insertStatement.setShort(n + 1, (Short)object);
                            continue;
                        }
                        if (object instanceof Long) {
                            if (this._databaseProductName.equals("EXCEL")) {
                                this._insertStatement.setString(n + 1, object.toString());
                                continue;
                            }
                            this._insertStatement.setLong(n + 1, (Long)object);
                            continue;
                        }
                        if (object instanceof Double) {
                            this._insertStatement.setDouble(n + 1, (Double)object);
                            continue;
                        }
                        if (object instanceof BigDecimal) {
                            this._insertStatement.setBigDecimal(n + 1, (BigDecimal)object);
                            continue;
                        }
                        if (object instanceof Float) {
                            if (this._databaseProductName.equals("EXCEL")) {
                                object2 = new BigDecimal(object.toString());
                                this._insertStatement.setBigDecimal(n + 1, (BigDecimal)object2);
                                continue;
                            }
                            this._insertStatement.setFloat(n + 1, ((Float)object).floatValue());
                            continue;
                        }
                        if (object instanceof Date) {
                            this._insertStatement.setDate(n + 1, (Date)object);
                            continue;
                        }
                        if (object instanceof Time) {
                            this._insertStatement.setTime(n + 1, (Time)object);
                            continue;
                        }
                        if (object instanceof Timestamp) {
                            this._insertStatement.setTimestamp(n + 1, (Timestamp)object);
                            continue;
                        }
                        this._insertStatement.setString(n + 1, object.toString());
                        continue;
                    }
                    this._insertStatement.setNull(n + 1, n3);
                }
                n = -1;
                int n9 = this._insertStatement.executeUpdate();
                if (n9 == 0) {
                    // empty if block
                }
            } else {
                this._moreData = false;
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            String string = ISQLResource.getFormattedString(ErrorMessages.getName(), "ODBC_EXPORT_COULD_NOT_INSERT_ROW", Integer.toString(this._rowNumber));
            if (n >= 0) {
                string = string + ISQLResource.getFormattedString(ErrorMessages.getName(), "ODBC_EXPORT_DATA_NOT_ALLOWED", this._resultSet.getColumnName(n));
            }
            this._errorMessages.add(string);
            do {
                this._errorMessages.add(sQLException2.getLocalizedMessage());
            } while ((sQLException2 = sQLException2.getNextException()) != null);
            this._retcode = false;
            bl = false;
        }
        return bl;
    }

    private String quoteOwnerAndTableName(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            bl2 = this._supportsCatalogsInTableDefinitions;
            bl3 = this._supportsSchemasInTableDefinitions;
        } else {
            bl2 = this._supportsCatalogsInDataManipulation;
            bl3 = this._supportsSchemasInDataManipulation;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2 && this._dstCatalog != null) {
            stringBuilder.append(this.quoteIdentifier(this._dstCatalog));
            stringBuilder.append('.');
        }
        if (bl3 && this._dstOwner != null) {
            stringBuilder.append(this.quoteIdentifier(this._dstOwner));
            stringBuilder.append('.');
        }
        stringBuilder.append(this.quoteIdentifier(this._dstTable));
        return stringBuilder.toString();
    }

    private String quoteIdentifier(String string) {
        if (this._quoteString != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this._quoteString);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                stringBuilder.append(c);
                if (this._quoteString.length() != 1 || c != this._quoteString.charAt(0)) continue;
                stringBuilder.append(c);
            }
            stringBuilder.append(this._quoteString);
            string = stringBuilder.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destinationTableExists() {
        boolean bl = false;
        Statement statement = null;
        try {
            statement = this._odbcConnection.createStatement();
            String string = "select * from " + this.quoteOwnerAndTableName(false) + " where 1=2";
            ResultSet resultSet = statement.executeQuery(string);
            resultSet.next();
            bl = true;
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    private ArrayList<DataTypeMetaData> getDataTypes() {
        ArrayList<DataTypeMetaData> arrayList = new ArrayList<DataTypeMetaData>();
        ResultSet resultSet = null;
        try {
            resultSet = this._odbcConnection.getMetaData().getTypeInfo();
            while (resultSet.next()) {
                DataTypeMetaData dataTypeMetaData = new DataTypeMetaData(resultSet.getInt(2), resultSet.getString(1), resultSet.getInt(3), resultSet.getInt(14), resultSet.getInt(15), resultSet.getBoolean(12), resultSet.getString(6));
                arrayList.add(dataTypeMetaData);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return arrayList;
    }

    private int getBestDataTypeIndex(int n) {
        int n2;
        int n3 = -1;
        String string = this._resultSet.getColumnTypeName(n);
        int n4 = this._resultSet.getColumnSQLType(n);
        if (string.equalsIgnoreCase("nchar")) {
            n4 = -8;
        } else if (string.equalsIgnoreCase("nvarchar")) {
            n4 = -9;
        } else if (string.equalsIgnoreCase("long nvarchar")) {
            n4 = -10;
        }
        if (n4 == -3 && string != null && string.equalsIgnoreCase("uniqueidentifier")) {
            for (n2 = 0; n2 < this._dataTypes.size(); ++n2) {
                DataTypeMetaData dataTypeMetaData = this._dataTypes.get(n2);
                if (dataTypeMetaData.getSQLType() != -11 || !string.equalsIgnoreCase(dataTypeMetaData.getName())) continue;
                return n2;
            }
        }
        if (n4 == 12 && string != null && string.equals("nvarchar") && !this._databaseProductName.equals("SQL Server")) {
            n4 = -9;
        }
        if (this._databaseProductName.equals("ACCESS") && n4 == 12 && string.equalsIgnoreCase("varchar")) {
            n4 = -10;
            string = "LONGCHAR";
        }
        if (this._databaseProductName.equals("EXCEL")) {
            if (n4 == 1 || n4 == -1 || n4 == -15 || n4 == -9 || n4 == -16) {
                n4 = 12;
                string = "VARCHAR";
            } else if (!(n4 != 2 && n4 != 4 && n4 != -6 && n4 != 5 && n4 != -5 && n4 != 6 && n4 != 7 && n4 != 3 || string.equalsIgnoreCase("money") || string.equalsIgnoreCase("smallmoney"))) {
                n4 = 8;
                string = "NUMBER";
            } else if (n4 == 91 && string.equals("date") || n4 == 92 && string.equals("time") || n4 == 93 && string.equals("timestamp")) {
                n4 = 12;
                string = "varchar";
            }
        }
        if (this._databaseProductName.equals("MySQL")) {
            if (n4 == -6 && string.equalsIgnoreCase("tinyint")) {
                string = "tinyint unsigned";
            } else if (n4 == 5 && string.equalsIgnoreCase("unsigned smallint")) {
                string = "smallint unsigned";
            } else if (n4 == 4 && string.equalsIgnoreCase("unsigned int")) {
                string = "int unsigned";
            } else if (n4 == -5 && string.equalsIgnoreCase("unsigned bigint")) {
                string = "bigint unsigned";
            } else if (n4 == 93 && string.equalsIgnoreCase("timestamp")) {
                string = "datetime";
            }
        }
        if (this._databaseProductName.equals("Microsoft SQL Server")) {
            if (string.equalsIgnoreCase("timestamp")) {
                string = "datetime";
            } else if (string.equalsIgnoreCase("double")) {
                string = "real";
                n4 = 7;
            } else if (string.equalsIgnoreCase("unsigned tinyint")) {
                string = "smallint";
                n4 = 5;
            } else if (string.equalsIgnoreCase("unsigned smallint")) {
                string = "int";
                n4 = 4;
            } else if (string.equalsIgnoreCase("unsigned int")) {
                string = "bigint";
                n4 = -5;
            } else if (string.equalsIgnoreCase("unsigned bigint")) {
                string = "real";
                n4 = 7;
            }
        }
        if (this._databaseProductName.equals("SQL Server") && string.equalsIgnoreCase("double")) {
            string = "real";
            n4 = 7;
        }
        if (this._databaseProductName.equals("Oracle") && (string.equalsIgnoreCase("date") || string.equalsIgnoreCase("time") || string.equalsIgnoreCase("timestamp"))) {
            string = "DATE";
            n4 = 93;
        }
        if ((n3 = this.findType(n4, string)) == -1) {
            n3 = this.findType(n4, null);
        }
        if (n3 == -1) {
            int[] nArray = new int[]{-7, -6, 5, 4, -5, 6, 7, 2, 8};
            if (n4 == -7 || n4 == -6 || n4 == 5 || n4 == 4 || n4 == -5 || n4 == 6 || n4 == 7 || n4 == 2) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != n4) continue;
                    for (int i = n2 + 1; i < nArray.length && (n3 = this.findType(nArray[i], null)) == -1; ++i) {
                    }
                    break;
                }
                if (n3 == -1 && n4 == 2) {
                    n3 = this.findType(3, null);
                }
            } else if (n4 == 3) {
                n3 = this.findType(2, null);
            }
        }
        if (n3 == -1) {
            n3 = this.findType(-1, null);
        }
        return n3;
    }

    private int findType(int n, String string) {
        int n2 = -1;
        for (int i = 0; i < this._dataTypes.size(); ++i) {
            DataTypeMetaData dataTypeMetaData = this._dataTypes.get(i);
            if (string != null && !dataTypeMetaData.getName().equalsIgnoreCase(string) || dataTypeMetaData.getSQLType() != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDestinationTable() {
        int n;
        int n2 = this._resultSet.getColumnCount();
        for (n = 0; n < n2; ++n) {
            String string = this._resultSet.getColumnName(n);
            if (string.length() <= this._maxColumnNameLength) continue;
            this._errorMessages.add(ISQLResource.getFormattedString(ErrorMessages.getName(), "ODBC_EXPORT_COLUMN_NAME_TOO_LONG", string, Integer.toString(this._maxColumnNameLength)));
            this._retcode = false;
            return false;
        }
        ScrollableResultSet scrollableResultSet = this._resultSet.getScrollableResultSet();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create table ");
        stringBuilder.append(this.quoteOwnerAndTableName(true));
        stringBuilder.append('(');
        StringBuilder stringBuilder2 = new StringBuilder();
        for (n = 0; n < n2; ++n) {
            int n3;
            DataTypeMetaData dataTypeMetaData = this._dataTypes.get(this._dstColumnTypes[n]);
            switch (dataTypeMetaData.getSQLType()) {
                case 2: 
                case 3: {
                    n3 = this._resultSet.getPrecision(n);
                    break;
                }
                default: {
                    n3 = this._resultSet.getColumnWidth(n);
                }
            }
            String string = ISQLConnectionImpl.getSQLTypeName(dataTypeMetaData, n3, this._resultSet.getScale(n));
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.quoteIdentifier(this._resultSet.getColumnName(n)));
            stringBuilder.append(' ');
            stringBuilder.append(string);
            if (scrollableResultSet == null) continue;
            if (scrollableResultSet.isPrimaryKey(n)) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(',');
                }
                stringBuilder2.append(this.quoteIdentifier(this._resultSet.getColumnName(n)));
            }
            boolean bl = false;
            try {
                bl = this._odbcConnection.getMetaData().supportsNonNullableColumns();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!bl) continue;
            int n4 = scrollableResultSet.getColumnNullability(n);
            if (n4 == 1) {
                if (this._databaseProductName.startsWith("DB2")) continue;
                stringBuilder.append(" null");
                continue;
            }
            stringBuilder.append(" not null");
        }
        if (stringBuilder2.length() > 0 && !this._databaseProductName.equals("EXCEL")) {
            stringBuilder.append(",primary key(");
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append(')');
        }
        stringBuilder.append(')');
        String string = stringBuilder.toString();
        Statement statement = null;
        try {
            statement = this._odbcConnection.createStatement();
            statement.execute(string);
        }
        catch (SQLException sQLException) {
            this._errorMessages.add(sQLException.getLocalizedMessage());
            this._retcode = false;
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return true;
    }

    private String getColumnTypeName(int n) {
        int n2 = this._resultSet.getColumnSQLType(n);
        String string = this._resultSet.getColumnTypeName(n);
        int n3 = this._resultSet.getPrecision(n);
        int n4 = this._resultSet.getScale(n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        switch (n2) {
            case 2: {
                stringBuilder.append('(');
                stringBuilder.append(Integer.toString(n3));
                stringBuilder.append(',');
                stringBuilder.append(Integer.toString(n4));
                stringBuilder.append(')');
                break;
            }
            case -15: 
            case -9: 
            case -3: 
            case -2: 
            case 1: 
            case 12: {
                stringBuilder.append('(');
                stringBuilder.append(Integer.toString(n3));
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    private boolean connect() {
        boolean bl = false;
        this._failedConnectionMessage = null;
        try {
            AbstractConnectionInfo abstractConnectionInfo = this._plugin.getConnectionInfo();
            abstractConnectionInfo.mergeConnectionString(this._connectionString);
            this._odbcConnection = this._plugin.connect(null, abstractConnectionInfo);
            DatabaseMetaData databaseMetaData = this._odbcConnection.getMetaData();
            this._quoteString = databaseMetaData.getIdentifierQuoteString();
            if (this._quoteString != null && this._quoteString.equals(" ")) {
                this._quoteString = null;
            }
            try {
                this._databaseProductName = databaseMetaData.getDatabaseProductName();
            }
            catch (SQLException sQLException) {
                this._databaseProductName = null;
            }
            try {
                this._maxColumnNameLength = databaseMetaData.getMaxColumnNameLength();
            }
            catch (SQLException sQLException) {
                this._maxColumnNameLength = Integer.MAX_VALUE;
            }
            try {
                this._supportsCatalogsInTableDefinitions = databaseMetaData.supportsCatalogsInTableDefinitions();
            }
            catch (SQLException sQLException) {
                this._supportsCatalogsInTableDefinitions = false;
            }
            try {
                this._supportsSchemasInTableDefinitions = databaseMetaData.supportsSchemasInTableDefinitions();
            }
            catch (SQLException sQLException) {
                this._supportsSchemasInTableDefinitions = false;
            }
            try {
                this._supportsCatalogsInDataManipulation = databaseMetaData.supportsCatalogsInDataManipulation();
            }
            catch (SQLException sQLException) {
                this._supportsCatalogsInDataManipulation = false;
            }
            try {
                this._supportsSchemasInDataManipulation = databaseMetaData.supportsSchemasInDataManipulation();
            }
            catch (SQLException sQLException) {
                this._supportsSchemasInDataManipulation = false;
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            this._failedConnectionMessage = sQLException.getLocalizedMessage();
        }
        catch (ISQLPluginException iSQLPluginException) {
            this._failedConnectionMessage = iSQLPluginException.getLocalizedMessage();
        }
        return bl;
    }

    private void disconnect() {
        try {
            if (this._retcode) {
                try {
                    this._odbcConnection.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this._odbcConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._odbcConnection = null;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

