/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.logon.AbstractConnectionInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sybase.isql.DataTypeMetaData;
import sybase.isql.ErrorMessages;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLPluginException;
import sybase.isql.ISQLResource;
import sybase.isql.Importer;
import sybase.isql.ImporterFailedException;
import sybase.isql.ImporterFileFormatException;
import sybase.isql.ImporterMissingMetaDataException;
import sybase.isql.InputOutputOptions;
import sybase.isql.InputStatement;
import sybase.isql.ODBCExporter;
import sybase.isql.TableGenitor;

class ODBCImporter
implements Importer,
TableGenitor {
    private InputOutputOptions _options = null;
    private Connection _odbcConnection = null;
    private ResultSet _dataResultSet = null;
    private int[] _dataResultSetType = null;
    private boolean[] _dataResultSetIsSigned = null;
    private String _srcDatabase = null;
    private String _srcOwner = null;
    private String _srcTable = null;
    private String _dstDatabase = null;
    private String _dstOwner = null;
    private String _dstTable = null;
    private ISQLConnectionImpl _dstConnection = null;
    private String _databaseProductName = null;
    private String _quoteString = "";
    private String _catalogSeparator = ".";
    private int _columnCount = 0;
    private ArrayList<String> _columnName = null;
    private ArrayList<Integer> _dataType = null;
    private ArrayList<String> _typeName = null;
    private ArrayList<Integer> _columnSize = null;
    private ArrayList<Integer> _decimalDigits = null;
    private ArrayList<Integer> _nullable = null;
    private ArrayList<String> _default = null;
    private ArrayList<Integer> _charByteLength = null;
    private ArrayList<String> _isNullable = null;
    private ArrayList<Boolean> _isPrimaryKey = null;
    private DataTypeMetaData[] _dataTypeMetaData = null;

    ODBCImporter(InputOutputOptions inputOutputOptions) {
        if (inputOutputOptions.getTableName() == null || inputOutputOptions.getTableName().length() == 0) {
            throw new IllegalArgumentException("Table name is not set");
        }
        if (inputOutputOptions.getConnectionString() == null || inputOutputOptions.getConnectionString().length() == 0) {
            throw new IllegalArgumentException("The connection string is not set");
        }
        this._dstDatabase = inputOutputOptions.getCatalog();
        this._dstOwner = inputOutputOptions.getOwner();
        this._dstTable = inputOutputOptions.getTableName();
        if (inputOutputOptions.odbcTableName != null) {
            this._srcDatabase = inputOutputOptions.odbcCatalog;
            this._srcOwner = inputOutputOptions.odbcSchema;
            this._srcTable = inputOutputOptions.odbcTableName;
        } else {
            Pattern pattern = Pattern.compile("(?:(?:[\\\"\\[]?([^\"\\]]*)[\\\"\\]]?\\.)?[\\\"\\[]?([^\"\\]]*)[\\\"\\]]?\\.)?[\\\"\\[]?([^\"\\]]*)[\\\"\\]]?");
            Matcher matcher = pattern.matcher(inputOutputOptions.getFileName());
            if (matcher.matches() && matcher.groupCount() == 3) {
                this._srcDatabase = matcher.group(1);
                this._srcOwner = matcher.group(2);
                this._srcTable = matcher.group(3);
                if (this._srcDatabase != null && this._srcDatabase.length() == 0) {
                    this._srcDatabase = null;
                }
                if (this._srcOwner != null && this._srcOwner.length() == 0) {
                    this._srcOwner = null;
                }
            }
        }
        this._options = inputOutputOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean open(ISQLConnection iSQLConnection) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        boolean bl = false;
        Statement statement = null;
        assert (iSQLConnection instanceof ISQLConnectionImpl);
        this._dstConnection = (ISQLConnectionImpl)iSQLConnection;
        if (this._odbcConnection != null) return true;
        ISQLPlugin iSQLPlugin = ODBCExporter.getPluginFromConnectionString(this._options.getConnectionString());
        if (iSQLPlugin == null) {
            iSQLPlugin = ((ISQLConnectionImpl)iSQLConnection).getPlugin();
        }
        AbstractConnectionInfo abstractConnectionInfo = iSQLPlugin.getConnectionInfo();
        abstractConnectionInfo.mergeConnectionString(this._options.getConnectionString());
        try {
            this._odbcConnection = iSQLPlugin.connect(null, abstractConnectionInfo);
            bl = true;
            try {
                DatabaseMetaData databaseMetaData = this._odbcConnection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                if (!string.equals("SQL Anywhere")) return bl;
                statement = this._odbcConnection.createStatement();
                statement.execute("set temporary option Return_date_time_as_String='On';set temporary option time_format=;set temporary option date_format=;set temporary option timestamp_format=");
                return bl;
            }
            catch (SQLException sQLException) {
                return bl;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                    statement = null;
                }
            }
        }
        catch (ISQLPluginException iSQLPluginException) {
            throw new IOException(iSQLPluginException.getLocalizedMessage(), iSQLPluginException);
        }
    }

    @Override
    public void readMetaData(ISQLConnection iSQLConnection) throws IOException, ImporterFileFormatException, ImporterMissingMetaDataException, ImporterFailedException {
        ResultSet resultSet = null;
        this._columnCount = 0;
        this._columnName = new ArrayList();
        this._dataType = new ArrayList();
        this._typeName = new ArrayList();
        this._columnSize = new ArrayList();
        this._decimalDigits = new ArrayList();
        this._nullable = new ArrayList();
        this._default = new ArrayList();
        this._charByteLength = new ArrayList();
        this._isNullable = new ArrayList();
        this._isPrimaryKey = new ArrayList();
        this._dataTypeMetaData = null;
        this._databaseProductName = null;
        try {
            int n;
            DatabaseMetaData databaseMetaData = this._odbcConnection.getMetaData();
            try {
                this._quoteString = databaseMetaData.getIdentifierQuoteString();
                if (this._quoteString != null && this._quoteString.equals("")) {
                    this._quoteString = null;
                }
            }
            catch (SQLException sQLException) {
                this._quoteString = null;
            }
            try {
                this._catalogSeparator = databaseMetaData.getCatalogSeparator();
                if (this._catalogSeparator != null && this._catalogSeparator.equals("")) {
                    this._catalogSeparator = ".";
                }
            }
            catch (SQLException sQLException) {
                this._catalogSeparator = ".";
            }
            try {
                this._databaseProductName = databaseMetaData.getDatabaseProductName();
            }
            catch (SQLException sQLException) {
                this._databaseProductName = null;
            }
            this._dataTypeMetaData = iSQLConnection.getDataTypes();
            resultSet = databaseMetaData.getColumns(this._srcDatabase, this._srcOwner, this._srcTable, "%");
            while (resultSet.next()) {
                ++this._columnCount;
                this._columnName.add(resultSet.getString(4));
                this._dataType.add(resultSet.getInt(5));
                this._typeName.add(resultSet.getString(6));
                this._columnSize.add(resultSet.getInt(7));
                this._decimalDigits.add(resultSet.getInt(9));
                this._nullable.add(resultSet.getInt(11));
                this._default.add(resultSet.getString(13));
                this._charByteLength.add(resultSet.getInt(16));
                this._isNullable.add(resultSet.getString(18));
            }
            resultSet.close();
            if (this._columnCount == 0) {
                throw new ImporterFailedException(this.formatSourceTableName());
            }
            if (this._databaseProductName.equals("Oracle")) {
                for (n = 0; n < this._columnCount; ++n) {
                    String string = this._typeName.get(n);
                    if (!string.equals("BFILE") && !string.equals("ROW") && !string.equals("UROW")) continue;
                    throw new ImporterFailedException(ErrorMessages.getISQLString(ErrorMessages.getName(), "CANNOT_IMPORT_UNSUPPORTED_ORACLE_TYPES"));
                }
            }
            try {
                resultSet = databaseMetaData.getPrimaryKeys(null, this._srcOwner, this._srcTable);
                boolean[] blArray = new boolean[this._columnCount];
                block19: while (resultSet.next()) {
                    String string = resultSet.getString(4);
                    for (n = 0; n < this._columnCount; ++n) {
                        if (!this._columnName.get(n).equals(string)) continue;
                        blArray[n] = true;
                        continue block19;
                    }
                }
                resultSet.close();
                for (n = 0; n < this._columnCount; ++n) {
                    this._isPrimaryKey.add(blArray[n]);
                }
            }
            catch (SQLException sQLException) {
                for (n = 0; n < this._columnCount; ++n) {
                    this._isPrimaryKey.add(Boolean.FALSE);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new ImporterFailedException(this.formatSourceTableName());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String formatSourceTableName() {
        String string = this._srcOwner == null ? ErrorMessages.getFormattedString(ErrorMessages.getName(), "TABLE_DOES_NOT_EXIST", this._srcTable) : ErrorMessages.getFormattedString(ErrorMessages.getName(), "TABLE_DOES_NOT_EXIST2", this._srcOwner, this._srcTable);
        return string;
    }

    @Override
    public boolean createTable(ISQLConnection iSQLConnection) throws IOException, SQLException, ImporterFileFormatException {
        if (!iSQLConnection.tableExists(this._dstDatabase, this._dstOwner, this._dstTable)) {
            if (this._options.getDontCreateTable()) {
                throw new IOException(this.formatSourceTableName());
            }
            iSQLConnection.createTable(this._dstDatabase, this._dstOwner, this._dstTable, this);
        }
        return true;
    }

    @Override
    public boolean populateTable(ISQLConnection iSQLConnection) throws IOException, ImporterFailedException {
        boolean bl;
        Statement statement = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("SELECT * FROM ");
            if (this._srcDatabase != null) {
                stringBuilder.append(this.quoteIdentifier(this._srcDatabase));
                stringBuilder.append(this._catalogSeparator);
            }
            if (this._srcOwner != null) {
                stringBuilder.append(this.quoteIdentifier(this._srcOwner));
                stringBuilder.append('.');
            }
            stringBuilder.append(this.quoteIdentifier(this._srcTable));
            String string = stringBuilder.toString();
            statement = this._odbcConnection.createStatement();
            this._dataResultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = this._dataResultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this._dataResultSetType = new int[n];
            this._dataResultSetIsSigned = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this._dataResultSetType[i] = resultSetMetaData.getColumnType(i + 1);
                this._dataResultSetIsSigned[i] = resultSetMetaData.isSigned(i + 1);
            }
            bl = iSQLConnection.addTableData(this._dstDatabase, this._dstOwner, this._dstTable, this);
        }
        catch (SQLException sQLException) {
            ImporterFailedException importerFailedException = new ImporterFailedException(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_READ_DATA_FROM_SOURCE_TABLE", sQLException.getLocalizedMessage()), sQLException);
            throw importerFailedException;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    private String quoteIdentifier(String string) {
        if (this._quoteString != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this._quoteString);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                stringBuilder.append(c);
                if (this._quoteString.length() != 1 || c != this._quoteString.charAt(0)) continue;
                stringBuilder.append(c);
            }
            stringBuilder.append(this._quoteString);
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public boolean close() throws IOException {
        if (this._odbcConnection != null) {
            try {
                this._odbcConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._odbcConnection = null;
        }
        this._dataResultSet = null;
        this._options = null;
        this._dstConnection = null;
        return true;
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public boolean knowsColumnNames() {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return this._columnName.get(n);
    }

    @Override
    public DataTypeMetaData getColumnTypeMetaData(int n) {
        int n2 = this._dataType.get(n);
        String string = this._typeName.get(n);
        int n3 = this._decimalDigits.get(n);
        int n4 = this._columnSize.get(n);
        DataTypeMetaData dataTypeMetaData = this._dstConnection.getDataTypeMetaData(n2, string, n4, n3);
        if (dataTypeMetaData == null) {
            boolean bl = false;
            if (n2 == -9) {
                if (string.equalsIgnoreCase("varchar")) {
                    string = "nvarchar";
                    bl = true;
                }
            } else if (n2 == 8) {
                if (n3 <= 15) {
                    string = "double";
                } else {
                    n2 = 2;
                    string = "numeric";
                }
                bl = true;
            } else if (n2 == -6 && string.equalsIgnoreCase("tinyint unsigned")) {
                string = "unsigned tinyint";
                bl = true;
            } else if (n2 == 5 && string.equalsIgnoreCase("smallint unsigned")) {
                string = "unsigned smallint";
                bl = true;
            } else if (n2 == 4 && string.equalsIgnoreCase("integer unsigned")) {
                string = "unsigned int";
                bl = true;
            } else if (n2 == -5 && string.equalsIgnoreCase("bigint unsigned")) {
                string = "unsigned bigint";
                bl = true;
            }
            if (this._databaseProductName.equals("Microsoft SQL Server")) {
                if (string.equals("int identity")) {
                    string = "int";
                    bl = true;
                } else if (string.equals("tinyint identity")) {
                    string = "tinyint";
                    bl = true;
                } else if (string.equals("bigint identity")) {
                    string = "bigint";
                    bl = true;
                } else if (string.equals("numeric() identity")) {
                    string = "numeric";
                    bl = true;
                } else if (string.equals("decimal() identity")) {
                    string = "decimal";
                    bl = true;
                }
            }
            if (this._databaseProductName.equals("SQL Server")) {
                if (n2 == 9) {
                    n2 = 91;
                    string = "date";
                    n4 = -1;
                    n3 = -1;
                    bl = true;
                } else if (n2 == 10) {
                    n2 = 92;
                    string = "time";
                    n4 = -1;
                    n3 = -1;
                    bl = true;
                } else if (n2 == 11) {
                    n2 = 93;
                    n4 = -1;
                    n3 = -1;
                    string = "timestamp";
                    bl = true;
                }
            }
            if (this._databaseProductName.equals("Oracle")) {
                if (string.equals("LONG") && n2 == -1) {
                    string = "long varchar";
                    bl = true;
                } else if (string.equals("VARCHAR2") && n2 == 12) {
                    string = "varchar";
                    bl = true;
                } else if (string.equals("NVARCHAR2") && n2 == -9) {
                    string = "nvarchar";
                    bl = true;
                }
            }
            if (this._databaseProductName.equals("DB2/NT")) {
                if (n2 == -98) {
                    n2 = -4;
                    string = "long varbinary";
                    n4 = -1;
                    n3 = -1;
                    bl = true;
                } else if (n2 == -99) {
                    n2 = -1;
                    string = "long varchar";
                    n4 = -1;
                    n3 = -1;
                    bl = true;
                } else if (n2 == -350) {
                    n2 = -16;
                    string = "long nvarchar";
                    n4 = -1;
                    n3 = -1;
                    bl = true;
                }
            }
            if (this._databaseProductName.equals("MySQL") && n2 == 4 && string.equalsIgnoreCase("mediumint")) {
                n2 = 4;
                string = "int";
                n4 = -1;
                n3 = -1;
                bl = true;
            }
            if (n2 == 9 && string.equals("date")) {
                n2 = 91;
                bl = true;
            } else if (n2 == 10 && string.equals("time")) {
                n2 = 92;
                bl = true;
            } else if (n2 == 11 && string.equals("timestamp")) {
                n2 = 93;
                bl = true;
            }
            if (this._dstConnection.getDatabaseType() == 3) {
                if (n2 == 3) {
                    boolean bl2 = false;
                    for (int i = 0; i < this._dataTypeMetaData.length; ++i) {
                        if (this._dataTypeMetaData[i].getSQLType() != 3) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        n2 = 2;
                        string = "numeric";
                        bl = true;
                    }
                } else if (n2 == -15 || n2 == -9) {
                    string = "varchar";
                    n2 = 12;
                    n4 *= 3;
                    bl = true;
                } else if (n2 == 7 && string.equalsIgnoreCase("float")) {
                    string = "real";
                    bl = true;
                }
            }
            if (bl && (dataTypeMetaData = this._dstConnection.getDataTypeMetaData(n2, string, n4, n3)) != null || (dataTypeMetaData = ISQLConnectionImpl.getDataTypeMetaData(0, this._dataTypeMetaData, n2, null, n4, n3)) != null) {
                // empty if block
            }
        }
        return dataTypeMetaData;
    }

    @Override
    public int getColumnWidth(int n) {
        return this._columnSize.get(n);
    }

    @Override
    public int getColumnScale(int n) {
        return this._decimalDigits.get(n);
    }

    @Override
    public boolean isColumnInPrimaryKey(int n) {
        return this._isPrimaryKey.get(n);
    }

    @Override
    public boolean isNullableColumn(int n) {
        boolean bl = false;
        String string = this._isNullable.get(n);
        boolean bl2 = bl = string != null && string.equals("YES");
        if (!bl) {
            bl = this._nullable.get(n) == 1;
        }
        return bl;
    }

    @Override
    public Vector<Object> getRowData() throws IOException {
        Vector<Object> vector;
        int n = 0;
        try {
            vector = new Vector<Object>();
            for (n = 1; n <= this._columnCount; ++n) {
                Object object;
                int n2 = this._dataResultSetType[n - 1];
                if (n2 == 4) {
                    object = this._dataResultSetIsSigned[n - 1] ? this._dataResultSet.getObject(n) : Long.valueOf(this._dataResultSet.getLong(n));
                } else if (n2 == -6) {
                    int n3 = this._dataResultSet.getInt(n);
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    object = n3;
                } else {
                    object = n2 == -5 ? (this._dataResultSetIsSigned[n - 1] ? Long.valueOf(this._dataResultSet.getLong(n)) : this._dataResultSet.getBigDecimal(n)) : this._dataResultSet.getObject(n);
                }
                if (this._dataResultSet.wasNull()) {
                    object = null;
                }
                vector.add(object);
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getLocalizedMessage());
        }
        return vector;
    }

    @Override
    public boolean moveNext() {
        boolean bl;
        try {
            bl = this._dataResultSet.next();
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean keepGoing(ISQLConnection iSQLConnection) {
        return InputStatement.keepGoing(iSQLConnection);
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

