/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import sybase.isql.FavoritesList;
import sybase.isql.FavoritesListItem;
import sybase.isql.FavoritesSidebar;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;

class OrganizeFavoritesDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    private static final String F1_KEY = "F1_KEY";
    private static Rectangle _bounds = null;
    private ParentFrame _parent = null;
    private FavoritesTree _favoritesTree = null;
    private FavoritesList _favorites = null;
    private ISQLResource _bundle;
    private SybButton _delete = null;
    private SybButton _rename = null;
    private SybButton _moveUp = null;
    private SybButton _moveDown = null;
    private SybButton _newFolder = null;
    private SybButton _close = null;
    private SybButton _help = null;

    static void create(ParentFrame parentFrame) {
        OrganizeFavoritesDialog organizeFavoritesDialog = new OrganizeFavoritesDialog(parentFrame);
        organizeFavoritesDialog.setVisible(true);
        organizeFavoritesDialog.destroy();
    }

    private OrganizeFavoritesDialog(ParentFrame parentFrame) {
        super((Window)parentFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        this._parent = parentFrame;
        this._favorites = Preferences.getFavorites();
        this._bundle = ISQLResource.getISQLResource(GeneralResources.getName());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(this._bundle.getISQLString("ORGANIZE_FAVORITES_ABOUT"));
        jPanel.add((Component)sybMultiLineLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 5, 0), 0, 0));
        SybLabel sybLabel = new SybLabel(this._bundle.getISQLString("ORGANIZE_FAVORITES_FAVORITES_LABEL"));
        this._favoritesTree = new FavoritesTree(Preferences.getFavorites());
        this._favoritesTree.setSelectionRow(0);
        this._favoritesTree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this._favoritesTree);
        sybLabel.setLabelFor((Component)jScrollPane);
        jPanel.add((Component)sybLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 5, 1.0, 1.0, 23, 1, new Insets(0, 0, 5, 10), 0, 0));
        this._delete = new SybButton(this._bundle.getISQLString("ORGANIZE_FAVORITES_DELETE"));
        this._delete.addActionListener((ActionListener)this);
        this._rename = new SybButton(this._bundle.getISQLString("ORGANIZE_FAVORITES_RENAME"));
        this._rename.addActionListener((ActionListener)this);
        this._moveUp = new SybButton(this._bundle.getISQLString("ORGANIZE_FAVORITES_MOVE_UP"));
        this._moveUp.addActionListener((ActionListener)this);
        this._moveDown = new SybButton(this._bundle.getISQLString("ORGANIZE_FAVORITES_MOVE_DOWN"));
        this._moveDown.addActionListener((ActionListener)this);
        this._newFolder = new SybButton(this._bundle.getISQLString("ORGANIZE_FAVORITES_NEW_FOLDER"));
        this._newFolder.addActionListener((ActionListener)this);
        jPanel.add((Component)this._delete, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this._rename, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this._moveUp, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this._moveDown, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this._newFolder, new GridBagConstraints(1, 6, 1, 1, 0.0, 1.0, 23, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._close = new SybButton(this._bundle.getISQLString("ORGANIZE_FAVORITES_CLOSE"));
        this._close.addActionListener((ActionListener)this);
        this._help = new SybButton(this._bundle.getISQLString("ORGANIZE_FAVORITES_HELP"));
        this._help.addActionListener((ActionListener)this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._close);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._help);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._close, this._help});
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 7, 0, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.setTitle(this._bundle.getISQLString("ORGANIZE_FAVORITES_TITLE"));
        this.getRootPane().getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton((JButton)this._close);
        this.getRootPane().registerKeyboardAction(this, F1_KEY, KeyStroke.getKeyStroke(112, 0, true), 2);
        this.enableButtons();
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        if (_bounds != null) {
            this.setBounds(_bounds);
            UIUtils.ensureWindowIsVisible((Window)this);
        } else {
            this.setLocationRelativeTo(parentFrame);
        }
    }

    private void destroy() {
        _bounds = this.getBounds();
        this._bundle = null;
        if (this._favoritesTree != null) {
            this._favoritesTree.removeTreeSelectionListener(this);
            this._favoritesTree = null;
        }
        if (this._delete != null) {
            this._delete.removeActionListener((ActionListener)this);
            this._delete = null;
        }
        if (this._rename != null) {
            this._rename.removeActionListener((ActionListener)this);
            this._rename = null;
        }
        if (this._moveUp != null) {
            this._moveUp.removeActionListener((ActionListener)this);
            this._moveUp = null;
        }
        if (this._moveDown != null) {
            this._moveDown.removeActionListener((ActionListener)this);
            this._moveDown = null;
        }
        if (this._newFolder != null) {
            this._newFolder.removeActionListener((ActionListener)this);
            this._newFolder = null;
        }
        if (this._close != null) {
            this.getRootPane().setDefaultButton(null);
            this._close.removeActionListener((ActionListener)this);
            this._close = null;
        }
        if (this._help != null) {
            this._help.removeActionListener((ActionListener)this);
            this._help = null;
        }
        this._parent = null;
        this._favorites = null;
        DialogUtils.removeComponents((Container)this);
    }

    private void handleNewFolder() {
        String string;
        String string2 = this._bundle.getISQLString("ADD_FAVORITE_NEW_FOLDER_TITLE");
        while ((string = SybOptionPane.showInputDialog((Component)this, (Object)this._bundle.getISQLString("ADD_FAVORITE_NEW_FOLDER_DESC"), (String)string2, (int)2)) != null) {
            if ((string = string.trim()).length() == 0) {
                SybOptionPane.showMessageDialog((Component)this, (Object)this._bundle.getISQLString("ORGANIZE_FAVORITES_EMPTY_NAME"), (String)this.getTitle(), (int)0);
                continue;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._favoritesTree.getLastSelectedPathComponent();
            FavoritesListItem favoritesListItem = (FavoritesListItem)defaultMutableTreeNode.getUserObject();
            if (favoritesListItem.getType() != 3) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                favoritesListItem = (FavoritesListItem)defaultMutableTreeNode.getUserObject();
            }
            if (favoritesListItem.getChildByName(string) != null) {
                SybOptionPane.showMessageDialog((Component)this, (Object)ISQLResource.getFormattedString(GeneralResources.getName(), "ORGANIZE_FAVORITES_DUPLICATE_NAME", string, favoritesListItem.getName()), (String)string2, (int)0);
                continue;
            }
            FavoritesListItem favoritesListItem2 = new FavoritesListItem(3, string, null, null);
            this._favorites.add(favoritesListItem, favoritesListItem2, favoritesListItem.getChildCount());
            FavoritesTreeModel favoritesTreeModel = (FavoritesTreeModel)this._favoritesTree.getModel();
            favoritesTreeModel.refresh();
            TreePath treePath = favoritesTreeModel.findNode((DefaultMutableTreeNode)favoritesTreeModel.getRoot(), string);
            if (treePath != null) {
                this._favoritesTree.setSelectionPath(treePath);
            }
            this._favoritesTree.requestFocusInWindow();
            break;
        }
    }

    private void handleRename() {
        String string;
        TreePath treePath = this._favoritesTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        FavoritesListItem favoritesListItem = (FavoritesListItem)defaultMutableTreeNode.getUserObject();
        while ((string = SybOptionPane.showInputDialog((Component)this, (Object)this._bundle.getISQLString("ORGANIZE_FAVORITES_RENAME_PROMPT"), (Object)favoritesListItem.getName())) != null && !string.equals(favoritesListItem.getName())) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
            FavoritesListItem favoritesListItem2 = (FavoritesListItem)defaultMutableTreeNode2.getUserObject();
            if ((string = string.trim()).length() == 0) {
                SybOptionPane.showMessageDialog((Component)this, (Object)this._bundle.getISQLString("ORGANIZE_FAVORITES_EMPTY_NAME"), (String)this.getTitle(), (int)0);
                continue;
            }
            if (favoritesListItem2.getChildByName(string) != null) {
                SybOptionPane.showMessageDialog((Component)this, (Object)ISQLResource.getFormattedString(GeneralResources.getName(), "ORGANIZE_FAVORITES_DUPLICATE_NAME", string, favoritesListItem2.getName()), (String)this.getTitle(), (int)0);
                continue;
            }
            favoritesListItem.setName(string);
            this._favorites.notifyItemChanged(favoritesListItem);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._favoritesTree.getModel();
            defaultTreeModel.reload(defaultMutableTreeNode);
            this._favoritesTree.setSelectionPath(treePath);
            this._favoritesTree.requestFocusInWindow();
            break;
        }
    }

    private void handleMoveUp() {
        this.handleMoveDir(-1);
    }

    private void handleMoveDown() {
        this.handleMoveDir(1);
    }

    private void handleMoveDir(int n) {
        TreePath treePath = this._favoritesTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode != null && !defaultMutableTreeNode.isRoot()) {
            TreePath treePath2 = treePath.getParentPath();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._favoritesTree.getModel();
            int n2 = defaultTreeModel.getIndexOfChild(defaultMutableTreeNode2, defaultMutableTreeNode);
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2 + n);
            this._favoritesTree.setSelectionPath(treePath);
            this._favoritesTree.requestFocusInWindow();
            FavoritesListItem favoritesListItem = (FavoritesListItem)defaultMutableTreeNode2.getUserObject();
            FavoritesListItem favoritesListItem2 = (FavoritesListItem)defaultMutableTreeNode.getUserObject();
            this._favorites.move(favoritesListItem, favoritesListItem, favoritesListItem2, n2 + n);
        }
    }

    private void handleDelete() {
        TreePath treePath = this._favoritesTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        FavoritesListItem favoritesListItem = (FavoritesListItem)defaultMutableTreeNode.getUserObject();
        String string = favoritesListItem.getType() != 3 ? this._bundle.getFormattedString("ORGANIZE_FAVORITES_CONFIRM_DELETION", favoritesListItem.getName()) : this._bundle.getFormattedString("ORGANIZE_FAVORITES_CONFIRM_FOLDER_DELETION", favoritesListItem.getName());
        int n = SybOptionPane.showConfirmDialog((Component)this, (Object)string, (String)this.getTitle(), (int)0);
        if (n == 0) {
            ((DefaultTreeModel)this._favoritesTree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
            this._favorites.remove(favoritesListItem);
        }
    }

    private void handleHelp() {
        ISQLConnection iSQLConnection = this._parent.getConnection();
        if (iSQLConnection != null) {
            ISQLHelpManager.showHelp((ISQLConnectionImpl)iSQLConnection, this, "HELP_ISQL_ORGANIZE_FAVORITES");
        }
    }

    private void handleClose() {
        ISQLConnection iSQLConnection = this._parent.getConnection();
        if (iSQLConnection != null) {
            Preferences.save(iSQLConnection);
        }
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._close) {
            this.handleClose();
        } else if (object == this._delete) {
            this.handleDelete();
        } else if (object == this._rename) {
            this.handleRename();
        } else if (object == this._moveUp) {
            this.handleMoveUp();
        } else if (object == this._moveDown) {
            this.handleMoveDown();
        } else if (object == this._newFolder) {
            this.handleNewFolder();
        } else if (object == this._help || actionEvent.getActionCommand().equals(F1_KEY)) {
            this.handleHelp();
        }
    }

    private boolean canMoveDown() {
        return this.canMoveDir(1);
    }

    private boolean canMoveUp() {
        return this.canMoveDir(-1);
    }

    private boolean canMoveDir(int n) {
        TreePath treePath = this._favoritesTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._favoritesTree.getModel();
        int n2 = defaultTreeModel.getChildCount(defaultMutableTreeNode2);
        int n3 = defaultTreeModel.getIndexOfChild(defaultMutableTreeNode2, defaultMutableTreeNode);
        boolean bl = (n3 += n) >= 0 && n3 < n2;
        return bl;
    }

    private void enableButtons() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._favoritesTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            if (defaultMutableTreeNode.isRoot()) {
                this._delete.setEnabled(false);
                this._rename.setEnabled(false);
                this._moveUp.setEnabled(false);
                this._moveDown.setEnabled(false);
            } else {
                this._moveUp.setEnabled(this.canMoveUp());
                this._moveDown.setEnabled(this.canMoveDown());
                this._delete.setEnabled(true);
                this._rename.setEnabled(true);
            }
            this._newFolder.setEnabled(true);
        } else {
            this._delete.setEnabled(false);
            this._rename.setEnabled(false);
            this._moveUp.setEnabled(false);
            this._moveDown.setEnabled(false);
            this._newFolder.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.enableButtons();
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static class FavoritesTreeModel
    extends DefaultTreeModel {
        private FavoritesList _favorites;

        FavoritesTreeModel(FavoritesList favoritesList) {
            super(null);
            this._favorites = favoritesList;
            this.refresh();
        }

        void refresh() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this._favorites.getRoot());
            this.addNodes(defaultMutableTreeNode, this._favorites.getRoot());
            this.setRoot(defaultMutableTreeNode);
        }

        private void addNodes(DefaultMutableTreeNode defaultMutableTreeNode, FavoritesListItem favoritesListItem) {
            int n = favoritesListItem.getChildCount();
            for (int i = 0; i < n; ++i) {
                FavoritesListItem favoritesListItem2 = favoritesListItem.getChild(i);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(favoritesListItem2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                if (favoritesListItem2.getChildCount() <= 0) continue;
                this.addNodes(defaultMutableTreeNode2, favoritesListItem2);
            }
        }

        TreePath findNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
            TreePath treePath = null;
            int n = this.getChildCount(defaultMutableTreeNode);
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.getChild(defaultMutableTreeNode, i);
                String string2 = defaultMutableTreeNode2.getUserObject().toString();
                if (string2.equalsIgnoreCase(string)) {
                    Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
                    do {
                        stack.add(defaultMutableTreeNode2);
                    } while ((defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) != null);
                    n = stack.size();
                    Object[] objectArray = new Object[n];
                    for (i = 0; i < n; ++i) {
                        objectArray[i] = stack.pop();
                    }
                    treePath = new TreePath(objectArray);
                    break;
                }
                treePath = this.findNode(defaultMutableTreeNode2, string);
                if (treePath != null) break;
            }
            return treePath;
        }
    }

    static class FavoritesTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Font _defaultFont = null;

        FavoritesTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string;
            Icon icon = null;
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (n == 0) {
                icon = ISQLImages.getImageIcon("favorites_root16");
            } else {
                FavoritesListItem favoritesListItem = (FavoritesListItem)((DefaultMutableTreeNode)object).getUserObject();
                switch (favoritesListItem.getType()) {
                    case 2: {
                        icon = FavoritesSidebar.FSCellRenderer.getFileIcon();
                        break;
                    }
                    case 1: {
                        icon = FavoritesSidebar.FSCellRenderer.getConnectionIcon(favoritesListItem);
                        break;
                    }
                    case 3: {
                        icon = FavoritesSidebar.FSCellRenderer.getFolderIcon();
                    }
                }
            }
            ((JLabel)component).setIcon(icon);
            if (object != null && (string = object.toString()).length() > 0) {
                if (this._defaultFont == null) {
                    this._defaultFont = component.getFont();
                }
                FontHelper.setFontForString((Component)component, (Font)this._defaultFont, (String)string);
            }
            return component;
        }
    }

    static class FavoritesTree
    extends JTree {
        private FavoritesList _favorites;

        FavoritesTree(FavoritesList favoritesList) {
            super(new FavoritesTreeModel(favoritesList));
            this._favorites = favoritesList;
            this.setEditable(false);
            this.setVisibleRowCount(8);
            this.setCellRenderer(new FavoritesTreeCellRenderer());
            this.getSelectionModel().setSelectionMode(1);
        }

        void refresh() {
            this.setModel(new FavoritesTreeModel(this._favorites));
        }
    }
}

