/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.util.EventQueuePumper;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.ISQLResultSetImpl;
import sybase.isql.InputOutputOptions;
import sybase.isql.OutputXML;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;
import sybase.isql.StaticResultSet;
import sybase.isql.UnbufferedISQLResultSet;
import sybase.isql.WindowManager;
import sybase.isql.isql;

class OutputStatement {
    static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static boolean _reportUnmappableCharacterExceptions = true;

    OutputStatement() {
    }

    static boolean keepGoing(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame;
        boolean bl = true;
        if (isql.options.useGUI && (parentFrame = WindowManager.findFrameByConnection(iSQLConnection)) != null) {
            EventQueuePumper.pump((EventQueuePumper.Condition)new EventQueuePumper.Condition(){

                public boolean keepGoing() {
                    return !parentFrame.isInterruptRequested(1);
                }
            });
            if (parentFrame.isInterruptRequested(1)) {
                parentFrame.clearInterrupt(1);
                bl = false;
                isql.getIO(iSQLConnection).showProgress(null, -1);
                isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "Operation was cancelled"), 0);
            }
        }
        return bl;
    }

    static ISQLResultSet[] getResultSetsForLastStatement(ISQLConnectionImpl iSQLConnectionImpl) {
        ISQLResultSet[] iSQLResultSetArray = null;
        int n = iSQLConnectionImpl.getResultSetCount(true);
        if (n > 0) {
            int n2;
            String string = null;
            for (n2 = n - 1; n2 >= 0; --n2) {
                ISQLResultSet iSQLResultSet = iSQLConnectionImpl.getResultSet(n2, true);
                String string2 = iSQLResultSet.getSQLStatement();
                if (string == null) {
                    string = string2;
                    continue;
                }
                if (!string.equals(string2)) break;
            }
            iSQLResultSetArray = new ISQLResultSet[n - ++n2];
            int n3 = 0;
            while (n2 < n) {
                iSQLResultSetArray[n3++] = iSQLConnectionImpl.getResultSet(n2++, true);
            }
        }
        return iSQLResultSetArray;
    }

    static boolean execute(ISQLConnectionImpl iSQLConnectionImpl, InputOutputOptions inputOutputOptions, Vector<String> vector) {
        boolean bl = false;
        ISQLResultSet[] iSQLResultSetArray = OutputStatement.getResultSetsForLastStatement(iSQLConnectionImpl);
        int n = iSQLResultSetArray != null ? iSQLResultSetArray.length : 0;
        if (n != 0) {
            if (inputOutputOptions.getEncoding() == null || inputOutputOptions.getEncoding().length() == 0) {
                inputOutputOptions.setEncoding(inputOutputOptions.getSystemEncoding());
            }
            if (!inputOutputOptions.getEscapes()) {
                inputOutputOptions.setEscapeCharacter('\u0000');
            }
            bl = n == 1 ? OutputStatement.output(iSQLConnectionImpl, iSQLResultSetArray[0], inputOutputOptions, vector) : OutputStatement.outputMultipleResultSets(iSQLConnectionImpl, iSQLResultSetArray, inputOutputOptions, vector);
        } else {
            vector.add(ISQLResource.getISQLString(ErrorMessages.getName(), "Could not execute OUTPUT statement because no result set was available."));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean outputMultipleResultSets(ISQLConnectionImpl iSQLConnectionImpl, ISQLResultSet[] iSQLResultSetArray, InputOutputOptions inputOutputOptions, Vector<String> vector) {
        ISQLResultSet iSQLResultSet;
        String string;
        boolean bl = false;
        Statement statement = null;
        String string2 = inputOutputOptions.getFileName();
        int n = string2.lastIndexOf(".");
        if (n == -1) {
            string = null;
        } else {
            string = string2.substring(n);
            string2 = string2.substring(0, n);
        }
        boolean bl2 = false;
        int n2 = iSQLResultSetArray.length;
        for (n = 0; n < n2 && (bl2 = OutputStatement.canExportResultSetAsIs(iSQLResultSet = iSQLResultSetArray[n])); ++n) {
        }
        if (!bl2) {
            try {
                iSQLResultSet = iSQLResultSetArray[0];
                String string3 = iSQLResultSet.getSQLStatement();
                try {
                    statement = iSQLConnectionImpl.getJDBCConnection().prepareStatement(string3, 1003, 1007);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    statement = iSQLConnectionImpl.getJDBCConnection().prepareStatement(string3);
                }
                boolean bl3 = statement.execute();
                int n3 = -1;
                n = 0;
                do {
                    if (bl3) {
                        ResultSet resultSet = statement.getResultSet();
                        UnbufferedISQLResultSet unbufferedISQLResultSet = new UnbufferedISQLResultSet(resultSet, iSQLConnectionImpl, string3);
                        String string4 = string2.concat("-");
                        string4 = string4.concat(Integer.toString(n + 1));
                        if (string != null) {
                            string4 = string4.concat(string);
                        }
                        inputOutputOptions.setFileName(string4);
                        bl = OutputStatement.output(iSQLConnectionImpl, unbufferedISQLResultSet, inputOutputOptions, vector);
                        if (!bl) {
                        }
                        ++n;
                        continue;
                    }
                    n3 = statement.getUpdateCount();
                } while ((bl3 = statement.getMoreResults()) || n3 != -1);
            }
            catch (SQLException sQLException) {
                boolean bl4 = false;
                return bl4;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        } else {
            for (n = 0; n < n2; ++n) {
                String string5 = string2.concat("-");
                string5 = string5.concat(Integer.toString(n + 1));
                if (string != null) {
                    string5 = string5.concat(string);
                }
                iSQLResultSet = iSQLResultSetArray[n];
                inputOutputOptions.setFileName(string5);
                bl = OutputStatement.output(iSQLConnectionImpl, iSQLResultSet, inputOutputOptions, vector);
                if (!bl) break;
            }
        }
        return bl;
    }

    private static boolean checkForBinaryColumns(ISQLResultSet iSQLResultSet) {
        boolean bl = true;
        int n = iSQLResultSet.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!iSQLResultSet.isColumnBinary(i)) continue;
            String[] stringArray = new String[2];
            String string = ISQLResource.getISQLString(ErrorMessages.getName(), "The result set you are exporting contains binary data, but the file format you have chosen does not.\nDo you want to export the data anyway?");
            stringArray[0] = ISQLResource.getISQLString(ErrorMessages.getName(), "Yes");
            stringArray[1] = ISQLResource.getISQLString(ErrorMessages.getName(), "No");
            int n2 = isql.getIO(iSQLResultSet.getConnection()).promptForOption(1, null, string, stringArray, 0, 0);
            if (n2 != 1) break;
            bl = false;
            break;
        }
        return bl;
    }

    static boolean canExportResultSetAsIs(ISQLResultSet iSQLResultSet) {
        boolean bl;
        ResultSet resultSet;
        ScrollableResultSet scrollableResultSet = iSQLResultSet.getScrollableResultSet();
        if (scrollableResultSet != null && (resultSet = scrollableResultSet.getJDBCResultSet()) != null && StaticResultSet.isStaticResultSet(resultSet)) {
            if (iSQLResultSet instanceof ISQLResultSetImpl) {
                ((ISQLResultSetImpl)iSQLResultSet).setMaxRows(Integer.MAX_VALUE);
            }
            return true;
        }
        boolean bl2 = bl = !iSQLResultSet.hasPartialData();
        if (!bl && scrollableResultSet != null && !scrollableResultSet.isClosed()) {
            try {
                if (scrollableResultSet.getJDBCResultSet().isBeforeFirst() && iSQLResultSet instanceof ISQLResultSetImpl) {
                    ((ISQLResultSetImpl)iSQLResultSet).setMaxRows(Integer.MAX_VALUE);
                    scrollableResultSet.setMaxClobCharacters(Integer.MAX_VALUE);
                    scrollableResultSet.setMaxBlobBytes(Integer.MAX_VALUE);
                    scrollableResultSet.setCacheLastRowOnly(true);
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return bl;
    }

    private static boolean output(ISQLConnection iSQLConnection, ISQLResultSet iSQLResultSet, InputOutputOptions inputOutputOptions, Vector<String> vector) {
        boolean bl;
        ParentFrame parentFrame;
        _reportUnmappableCharacterExceptions = true;
        if (isql.options.useGUI && (parentFrame = WindowManager.findFrameByConnection(iSQLConnection)) != null) {
            parentFrame.setOutputStatementInProgress(true);
            bl = OutputStatement.output1(iSQLConnection, iSQLResultSet, inputOutputOptions, vector);
            parentFrame.setOutputStatementInProgress(false);
        } else {
            bl = OutputStatement.output1(iSQLConnection, iSQLResultSet, inputOutputOptions, vector);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isReturnDateTimeAsStringOn(ISQLConnection iSQLConnection) {
        boolean bl;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = iSQLConnection.getJDBCConnection().createStatement();
            resultSet = statement.executeQuery("SELECT CONNECTION_PROPERTY('Return_date_time_as_string')");
            resultSet.next();
            String string = resultSet.getString(1).trim();
            bl = string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("1");
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setReturnDateTimeAsString(ISQLConnection iSQLConnection, String string) {
        Statement statement = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET TEMPORARY OPTION Return_date_time_as_string=");
        stringBuffer.append(string);
        try {
            statement = iSQLConnection.getJDBCConnection().createStatement();
            statement.execute(stringBuffer.toString());
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
    }

    private static OutputStreamWriter createASCIIWriter(OutputStream outputStream, InputOutputOptions inputOutputOptions) throws IOException {
        String string = inputOutputOptions.getEncoding();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        if (inputOutputOptions.useByteOrderMark && (string.equalsIgnoreCase("UTF-8") || string.equalsIgnoreCase("UTF-16LE") || string.equalsIgnoreCase("UTF-16BE"))) {
            outputStreamWriter.write(65279);
        }
        return outputStreamWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean output1(ISQLConnection iSQLConnection, ISQLResultSet iSQLResultSet, InputOutputOptions inputOutputOptions, Vector<String> vector) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        OutputStreamWriter outputStreamWriter = null;
        int n = 0;
        if (!OutputStatement.canExportResultSetAsIs(iSQLResultSet)) {
            try {
                iSQLResultSet = new UnbufferedISQLResultSet(iSQLResultSet, iSQLConnection);
            }
            catch (SQLException sQLException) {
                vector.add(ISQLResource.getFormattedString(ErrorMessages.getName(), "OUTPUT_STATEMENT_REEXECUTE_FAILED", isql.formatSQLExceptionMessage(sQLException)));
                return false;
            }
            bl2 = true;
        }
        if (inputOutputOptions.getFormat() != 1 && inputOutputOptions.getFormat() != 13 && !(bl = OutputStatement.checkForBinaryColumns(iSQLResultSet))) {
            if (iSQLResultSet instanceof UnbufferedISQLResultSet) {
                iSQLResultSet.close();
            }
            return false;
        }
        String string2 = inputOutputOptions.getFileName();
        File file = new File(string2);
        try {
            isql.enableUIForConnection(iSQLConnection, false);
            FileOutputStream fileOutputStream = new FileOutputStream(file, inputOutputOptions.getAppend());
            if (inputOutputOptions.getVerbose() && vector != null) {
                outputStreamWriter = OutputStatement.createASCIIWriter(fileOutputStream, inputOutputOptions);
                outputStreamWriter.write("-- ");
                outputStreamWriter.write(ISQLResource.getISQLString(GeneralResources.getName(), "Executing command:"));
                outputStreamWriter.write(System.getProperty("line.separator"));
                string = iSQLResultSet.getSQLStatement();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    outputStreamWriter.write("--   ");
                    outputStreamWriter.write(string);
                    outputStreamWriter.write(System.getProperty("line.separator"));
                }
                for (int i = 0; i < vector.size(); ++i) {
                    outputStreamWriter.write("-- ");
                    outputStreamWriter.write(vector.get(i));
                    outputStreamWriter.write(System.getProperty("line.separator"));
                }
            }
            string = ISQLResource.getFormattedString(GeneralResources.getName(), "Exporting data to \"{0}\"", file.getAbsolutePath());
            isql.getIO(iSQLConnection).writeln(string, 0);
            switch (inputOutputOptions.getFormat()) {
                case 1: {
                    if (outputStreamWriter == null) {
                        outputStreamWriter = OutputStatement.createASCIIWriter(fileOutputStream, inputOutputOptions);
                    }
                    n = OutputStatement.outputASCII(iSQLResultSet, inputOutputOptions, new BufferedWriter(outputStreamWriter));
                    break;
                }
                case 2: {
                    if (outputStreamWriter == null) {
                        outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                    }
                    n = OutputStatement.outputFixed(iSQLResultSet, inputOutputOptions, outputStreamWriter);
                    break;
                }
                case 3: {
                    if (outputStreamWriter == null) {
                        outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                    }
                    n = OutputStatement.outputHTML(iSQLResultSet, outputStreamWriter);
                    break;
                }
                case 13: {
                    n = OutputXML.export(iSQLResultSet, fileOutputStream);
                    break;
                }
                case 4: {
                    if (outputStreamWriter == null) {
                        outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                    }
                    n = OutputStatement.outputSQL(iSQLResultSet, inputOutputOptions, outputStreamWriter);
                }
            }
            bl = true;
        }
        catch (IOException iOException) {
            string = ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not save result set.\n{0}", iOException.getMessage());
            isql.getIO(iSQLConnection).writeln(string, 2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            string = ISQLResource.getISQLString(ErrorMessages.getName(), "COULD_NOT_SAVE_RESULTSET_ENCODER_FAILED");
            isql.getIO(iSQLConnection).writeln(string, 2);
        }
        finally {
            isql.enableUIForConnection(iSQLConnection, true);
        }
        if (bl) {
            string = ISQLResource.getFormattedString(GeneralResources.getName(), "{0} rows written", Integer.toString(n), file.getAbsolutePath());
            isql.getIO(iSQLConnection).showProgress(string, -1);
            isql.getIO(iSQLConnection).writeln(string, 0);
            if (inputOutputOptions.getVerbose() && outputStreamWriter != null) {
                try {
                    outputStreamWriter.write(System.getProperty("line.separator"));
                    outputStreamWriter.write("-- ");
                    outputStreamWriter.write(string);
                    outputStreamWriter.write(System.getProperty("line.separator"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (outputStreamWriter != null) {
            try {
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                string = ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not save result set.\n{0}", iOException.getMessage());
                isql.getIO(iSQLConnection).writeln(string, 2);
            }
        }
        if (bl2) {
            iSQLResultSet.close();
            iSQLResultSet = null;
        }
        return bl;
    }

    private static void outputStreamAsIs(Writer writer, InputStream inputStream, String string) throws IOException {
        int n;
        if (string != null) {
            writer.write(string);
        }
        while ((n = inputStream.read()) != -1) {
            writer.write((char)n);
        }
        if (string != null) {
            writer.write(string);
        }
    }

    private static void outputStreamAsHexString(Writer writer, InputStream inputStream, String string) throws IOException {
        int n;
        writer.write("0x");
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i];
                if (n2 < 0) {
                    n2 += 256;
                }
                writer.write(hexTable[n2 >> 4 & 0xF]);
                writer.write(hexTable[n2 & 0xF]);
            }
        }
    }

    private static void outputString(String string, boolean bl, String string2, char c, Writer writer, String string3) throws IOException {
        CharsetEncoder charsetEncoder = null;
        CharBuffer charBuffer = CharBuffer.allocate(1);
        char c2 = bl && string2.length() == 1 ? string2.charAt(0) : (char)'\u0000';
        if (bl) {
            writer.write(string2);
        }
        if (c == '\u0000') {
            writer.write(string);
        } else {
            boolean bl2;
            boolean bl3 = bl2 = string3 != null && (string3.equalsIgnoreCase("UTF-16") || string3.equalsIgnoreCase("UTF-16BE") || string3.equalsIgnoreCase("UTF-16LE"));
            if (string3 != null) {
                try {
                    charsetEncoder = Charset.forName(string3).newEncoder();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            for (int i = 0; i < string.length(); ++i) {
                char c3 = string.charAt(i);
                if (Character.isISOControl(c3)) {
                    if (bl2) {
                        writer.write(c);
                        writer.write("x00");
                    }
                    writer.write(c);
                    writer.write(120);
                    writer.write(hexTable[c3 >> 4 & 0xF]);
                    writer.write(hexTable[c3 & 0xF]);
                    continue;
                }
                if (c3 == c || bl && c3 == c2) {
                    writer.write(c3);
                    writer.write(c3);
                    continue;
                }
                if (c3 >= ' ' && c3 < '\u0080') {
                    writer.write(c3);
                    continue;
                }
                if (_reportUnmappableCharacterExceptions) {
                    try {
                        if (charsetEncoder != null) {
                            charBuffer.clear();
                            charBuffer.put(0, c3);
                            charsetEncoder.reset();
                            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
                        }
                    }
                    catch (UnmappableCharacterException unmappableCharacterException) {
                        if (_reportUnmappableCharacterExceptions) {
                            _reportUnmappableCharacterExceptions = false;
                            if (string3 != null) {
                                isql.getIO(null).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "CannotWriteStringUsingEncoding", string3), 1);
                            } else {
                                isql.getIO(null).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "CannotWriteStringUsingDefaultEncoding"), 1);
                            }
                        }
                        c3 = '?';
                    }
                }
                try {
                    writer.write(c3);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            writer.write(string2);
        }
    }

    static boolean isPrintableASCII(char c) {
        int n = Character.getType(c);
        return n != 15 && n != 13 && n != 18 && n != 0;
    }

    private static int outputASCII(ISQLResultSet iSQLResultSet, InputOutputOptions inputOutputOptions, Writer writer) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        InputStream inputStream = null;
        long l = 0L;
        long l2 = 0L;
        String string = Preferences.getStringOption(iSQLResultSet.getConnection(), "output_nulls");
        n4 = Preferences.getIntOption(iSQLResultSet.getConnection(), "output_length");
        String string2 = inputOutputOptions.getDelimiter();
        if (string2.equals("\\t")) {
            string2 = "\t";
        }
        char c = (n2 = inputOutputOptions.getHexadecimal()) == 3 ? (char)'\u0000' : inputOutputOptions.getEscapeCharacter();
        String string3 = System.getProperty("line.separator");
        int n5 = iSQLResultSet.getColumnCount();
        int n6 = iSQLResultSet.getRowCount();
        boolean[] blArray = new boolean[n5];
        boolean[] blArray2 = new boolean[n5];
        for (n = 0; n < n5; ++n) {
            blArray[n] = iSQLResultSet.isColumnBinary(n);
            if (!blArray[n]) continue;
            String string4 = iSQLResultSet.getColumnTypeName(n);
            blArray2[n] = string4 != null && string4.length() > 0 && string4.equals("uniqueidentifier");
        }
        for (int i = 0; i < n6; ++i) {
            block29: {
                try {
                    if (!iSQLResultSet.rowExists(i)) {
                    }
                    break block29;
                }
                catch (SQLException sQLException) {
                    isql.getIO(iSQLResultSet.getConnection()).writeln(sQLException, ISQLResource.getISQLString(ErrorMessages.getName(), "ErrorReadingResultSet"), 2);
                }
                break;
            }
            if (!OutputStatement.keepGoing(iSQLResultSet.getConnection())) break;
            long l3 = System.currentTimeMillis();
            if (l3 - l >= 750L) {
                isql.getIO(iSQLResultSet.getConnection()).showProgress(ISQLResource.getFormattedString(GeneralResources.getName(), "Writing row {0}", Integer.toString(i)), -1);
                l = l3;
            }
            for (n = 0; n < n5; ++n) {
                try {
                    String string5;
                    if (blArray[n]) {
                        if (iSQLResultSet.getValueAt(i, n) != null) {
                            if (blArray2[n]) {
                                string5 = OutputStatement.getUniqueIdentifier(iSQLResultSet, i, n);
                                writer.write(string5);
                            } else {
                                Object object = iSQLResultSet.getValueAt(i, n);
                                if (object instanceof byte[]) {
                                    inputStream = new ByteArrayInputStream((byte[])object);
                                } else if (object instanceof InputStream) {
                                    inputStream = (InputStream)object;
                                } else if (object instanceof LongBinaryValue) {
                                    LongBinaryValue longBinaryValue = (LongBinaryValue)object;
                                    inputStream = longBinaryValue.isPartialValue() ? new FileInputStream(longBinaryValue.getFile()) : new ByteArrayInputStream(longBinaryValue.getTruncatedValue());
                                }
                                switch (n2) {
                                    case 2: {
                                        int n7 = inputStream.available();
                                        if (n4 != 0 && n7 > n4) {
                                            n7 = n4;
                                        }
                                        byte[] byArray = new byte[n7];
                                        inputStream.read(byArray);
                                        string5 = new String(byArray);
                                        OutputStatement.outputString(string5, true, inputOutputOptions.getQuote(), c, writer, inputOutputOptions.getEncoding());
                                        break;
                                    }
                                    case 1: {
                                        OutputStatement.outputStreamAsHexString(writer, inputStream, inputOutputOptions.getQuote());
                                        break;
                                    }
                                    case 3: {
                                        OutputStatement.outputStreamAsIs(writer, inputStream, inputOutputOptions.getQuote());
                                    }
                                }
                            }
                        }
                    } else {
                        boolean bl;
                        if (iSQLResultSet.getValueAt(i, n) != null) {
                            string5 = iSQLResultSet.getStringValueAt(i, n);
                            if (n4 != 0 && string5.length() > n4) {
                                string5 = string5.substring(0, n4);
                            }
                            bl = inputOutputOptions.getQuoteAll() || iSQLResultSet.getColumnClass(n) == String.class;
                        } else {
                            string5 = string;
                            bl = false;
                        }
                        OutputStatement.outputString(string5, bl, inputOutputOptions.getQuote(), c, writer, inputOutputOptions.getEncoding());
                    }
                    if (n == n5 - 1) continue;
                    writer.write(string2);
                    continue;
                }
                catch (SQLException sQLException) {
                    break;
                }
            }
            writer.write(string3);
            ++n3;
        }
        writer.flush();
        return n3;
    }

    private static String getUniqueIdentifier(ISQLResultSet iSQLResultSet, int n, int n2) {
        String string;
        try {
            byte[] byArray;
            Object object = iSQLResultSet.getValueAt(n, n2);
            if (object instanceof InputStream) {
                byArray = new byte[16];
                ((InputStream)object).read(byArray);
            } else if (object instanceof byte[]) {
                byArray = (byte[])object;
            } else if (object instanceof LongBinaryValue) {
                byArray = ((LongBinaryValue)object).getTruncatedValue();
            } else {
                throw new IllegalArgumentException("Error! Unexpected object type " + object.getClass().getName());
            }
            StringBuilder stringBuilder = new StringBuilder(36);
            for (int i = 0; i < 16; ++i) {
                int n3 = byArray[i];
                if (n3 < 0) {
                    n3 += 256;
                }
                int n4 = n3 >> 4;
                int n5 = n3 & 0xF;
                if (n4 < 10) {
                    stringBuilder.append((char)(48 + n4));
                } else {
                    stringBuilder.append((char)(65 + n4 - 10));
                }
                if (n5 < 10) {
                    stringBuilder.append((char)(48 + n5));
                } else {
                    stringBuilder.append((char)(65 + n5 - 10));
                }
                if (i != 3 && i != 5 && i != 7 && i != 9) continue;
                stringBuilder.append('-');
            }
            string = stringBuilder.toString();
        }
        catch (IOException iOException) {
            string = "";
        }
        catch (SQLException sQLException) {
            string = "";
        }
        return string;
    }

    private static int outputFixed(ISQLResultSet iSQLResultSet, InputOutputOptions inputOutputOptions, OutputStreamWriter outputStreamWriter) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean[] blArray = new boolean[]{false};
        String string = System.getProperty("line.separator");
        String string2 = Preferences.getStringOption(iSQLResultSet.getConnection(), "output_nulls");
        int n5 = iSQLResultSet.getColumnCount();
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = iSQLResultSet.getColumnSQLType(n3);
            if (n2 != -1 && n2 != -4 && n2 != 2000) continue;
            isql.getIO(iSQLResultSet.getConnection()).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "Note! Data includes LONG VARCHAR and/or LONG VARBINARY columns.\nNote! Data in these columns will be truncated at 64 characters/bytes."), 1);
            break;
        }
        if (inputOutputOptions.getColumnWidthCount() < n5) {
            for (n3 = inputOutputOptions.getColumnWidthCount(); n3 < n5; ++n3) {
                n = iSQLResultSet.getColumnWidth(n3);
                inputOutputOptions.addColumnWidth(n);
            }
        }
        long l = 0L;
        int n6 = iSQLResultSet.getRowCount();
        for (int i = 0; i < n6; ++i) {
            block15: {
                try {
                    if (!iSQLResultSet.rowExists(i)) {
                    }
                    break block15;
                }
                catch (SQLException sQLException) {
                    isql.getIO(iSQLResultSet.getConnection()).writeln(sQLException, ISQLResource.getISQLString(ErrorMessages.getName(), "ErrorReadingResultSet"), 2);
                }
                break;
            }
            if (!OutputStatement.keepGoing(iSQLResultSet.getConnection())) break;
            long l2 = System.currentTimeMillis();
            if (l2 > l) {
                isql.getIO(iSQLResultSet.getConnection()).showProgress(ISQLResource.getFormattedString(GeneralResources.getName(), "Writing row {0}", Integer.toString(i)), -1);
                l = l2 + 500L;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                int n7 = iSQLResultSet.getColumnAlignment(n3);
                n = inputOutputOptions.getColumnWidth(n3);
                n2 = iSQLResultSet.getColumnSQLType(n3);
                if (n2 == 2000 || n > 32768) {
                    n = 32768;
                }
                try {
                    String string3;
                    if (iSQLResultSet.getValueAt(i, n3) != null) {
                        string3 = iSQLResultSet.getStringValueAt(i, n3);
                        string3 = OutputStatement.removeControlCharacters(string3, n, blArray);
                        if (blArray[0] && bl2) {
                            bl2 = false;
                            isql.getIO(iSQLResultSet.getConnection()).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "FIXED_FORMAT_DATA_CONTAINS_CONTROL_CHAR"), 1);
                        }
                    } else {
                        string3 = string2;
                    }
                    string3 = OutputStatement.padString(string3, n7, n);
                    outputStreamWriter.write(string3);
                    continue;
                }
                catch (SQLException sQLException) {
                    break;
                }
            }
            outputStreamWriter.write(string);
            ++n4;
        }
        bl = true;
        return n4;
    }

    private static String removeControlCharacters(String string, int n, boolean[] blArray) {
        String string2;
        StringBuilder stringBuilder = null;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) {
                if (stringBuilder != null) continue;
                stringBuilder = new StringBuilder(n2);
                if (i <= 0) continue;
                stringBuilder.append(string.substring(0, i));
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
            if (stringBuilder.length() > n) break;
        }
        if (stringBuilder != null) {
            string2 = stringBuilder.toString();
            blArray[0] = true;
        } else {
            string2 = string;
        }
        return string2;
    }

    private static String padString(String string, int n, int n2) {
        int n3 = string.length();
        if (n2 == n3) {
            return string;
        }
        if (n3 > n2) {
            return string.substring(0, n2);
        }
        int n4 = n2 - n3;
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n4; ++i) {
            stringBuffer.append(' ');
        }
        if (n == 1) {
            stringBuffer.insert(0, string);
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static String escapeForHTML(String string, Object object) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 50);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char c = string.charAt(i);
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c < '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            boolean bl2 = bl = object != null && object instanceof CharsetEncoder && OutputStatement.canEncode((CharsetEncoder)object, c);
            if (bl) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("&#");
            stringBuffer.append(Integer.toString(c));
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    private static boolean canEncode(CharsetEncoder charsetEncoder, char c) {
        boolean bl;
        charsetEncoder.reset();
        charsetEncoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer charBuffer = CharBuffer.allocate(1);
        charBuffer.put(c);
        charBuffer.flip();
        try {
            charsetEncoder.encode(charBuffer);
            bl = true;
        }
        catch (CharacterCodingException characterCodingException) {
            bl = false;
        }
        return bl;
    }

    private static int outputHTML(ISQLResultSet iSQLResultSet, OutputStreamWriter outputStreamWriter) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        CharsetEncoder charsetEncoder = null;
        String string = Preferences.getStringOption(iSQLResultSet.getConnection(), "output_nulls");
        n3 = Preferences.getIntOption(iSQLResultSet.getConnection(), "output_length");
        String string2 = outputStreamWriter.getEncoding();
        if (Charset.isSupported(string2)) {
            try {
                Charset charset = Charset.forName(string2);
                charsetEncoder = charset.newEncoder();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                charsetEncoder = null;
            }
        }
        outputStreamWriter.write("<html>\n");
        outputStreamWriter.write("<head>\n");
        outputStreamWriter.write("<META content=\"text/html;charset=");
        outputStreamWriter.write(string2);
        outputStreamWriter.write("\">\n");
        outputStreamWriter.write("</head>\n");
        outputStreamWriter.write("<body>\n");
        outputStreamWriter.write("<table border>\n");
        int n4 = iSQLResultSet.getColumnCount();
        int n5 = iSQLResultSet.getRowCount();
        StringBuffer stringBuffer = new StringBuffer();
        outputStreamWriter.write("<tr>");
        for (n = 0; n < n4; ++n) {
            outputStreamWriter.write("<th>");
            outputStreamWriter.write(OutputStatement.escapeForHTML(iSQLResultSet.getColumnName(n), charsetEncoder));
            outputStreamWriter.write("</th>");
        }
        outputStreamWriter.write("</tr>\n");
        long l = 0L;
        for (int i = 0; i < n5; ++i) {
            block15: {
                try {
                    if (!iSQLResultSet.rowExists(i)) {
                    }
                    break block15;
                }
                catch (SQLException sQLException) {
                    isql.getIO(iSQLResultSet.getConnection()).writeln(sQLException, ISQLResource.getISQLString(ErrorMessages.getName(), "ErrorReadingResultSet"), 2);
                }
                break;
            }
            if (!OutputStatement.keepGoing(iSQLResultSet.getConnection())) break;
            long l2 = System.currentTimeMillis();
            if (l2 > l) {
                isql.getIO(iSQLResultSet.getConnection()).showProgress(ISQLResource.getFormattedString(GeneralResources.getName(), "Writing row {0}", Integer.toString(i)), -1);
                l = l2 + 500L;
            }
            stringBuffer.append("<tr>");
            for (n = 0; n < n4; ++n) {
                try {
                    String string3;
                    Object object = iSQLResultSet.getValueAt(i, n);
                    if (object != null) {
                        string3 = iSQLResultSet.getStringValueAt(i, n);
                        if (n3 != 0 && string3.length() > n3) {
                            string3 = string3.substring(0, n3);
                        }
                    } else {
                        string3 = string;
                    }
                    stringBuffer.append("<td>");
                    stringBuffer.append(OutputStatement.escapeForHTML(string3, charsetEncoder));
                    stringBuffer.append("</td>");
                    continue;
                }
                catch (SQLException sQLException) {
                    break;
                }
            }
            stringBuffer.append("</tr>\n");
            stringBuffer.append(System.getProperty("line.separator"));
            outputStreamWriter.write(stringBuffer.toString());
            stringBuffer.setLength(0);
            ++n2;
        }
        outputStreamWriter.write("</table>\n");
        outputStreamWriter.write("</body>\n");
        outputStreamWriter.write("</html>\n");
        return n2;
    }

    private static int outputSQL(ISQLResultSet iSQLResultSet, InputOutputOptions inputOutputOptions, OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write(iSQLResultSet.getSQLStatement());
        outputStreamWriter.write(";\n");
        outputStreamWriter.write("input format sql;\n");
        int n = OutputStatement.outputASCII(iSQLResultSet, inputOutputOptions, outputStreamWriter);
        outputStreamWriter.write("END\n");
        return n;
    }
}

