/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import sybase.isql.ErrorMessages;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.OutputStatement;
import sybase.isql.isql;

class OutputXML {
    private static final String INDENT = "    ";
    private static final String INDENT_2 = "        ";
    private static final int CDATA_CHUNK_LENGTH = 32;

    OutputXML() {
    }

    static int export(ISQLResultSet iSQLResultSet, FileOutputStream fileOutputStream) throws IOException {
        if (iSQLResultSet == null) {
            throw new IllegalArgumentException("ResultSet cannot be null");
        }
        if (fileOutputStream == null) {
            throw new IllegalArgumentException("FileOutputStream cannot be null");
        }
        int n = 0;
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            n = OutputXML.writeXML(outputStreamWriter, iSQLResultSet);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
                outputStreamWriter = null;
            }
        }
        return n;
    }

    private static int writeXML(OutputStreamWriter outputStreamWriter, ISQLResultSet iSQLResultSet) throws IOException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        outputStreamWriter.write(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE resultset [\n");
        stringBuffer.append("    <!ELEMENT resultset (resultsetdata) >\n");
        stringBuffer.append("    <!ELEMENT resultsetdata (row)* >\n");
        stringBuffer.append("    <!ELEMENT row (column)+ >\n");
        stringBuffer.append("    <!ELEMENT column (#PCDATA)>\n");
        stringBuffer.append("    <!ATTLIST column\n");
        stringBuffer.append("        null (true | false) \"false\"\n");
        stringBuffer.append("        name CDATA #IMPLIED\n");
        stringBuffer.append("    >\n");
        stringBuffer.append("]>\n");
        outputStreamWriter.write(stringBuffer.toString());
        n = OutputXML.writeXMLResultSet(outputStreamWriter, iSQLResultSet);
        return n;
    }

    private static int writeXMLResultSet(OutputStreamWriter outputStreamWriter, ISQLResultSet iSQLResultSet) throws IOException {
        int n = iSQLResultSet.getColumnCount();
        outputStreamWriter.write("<resultset>\n");
        int n2 = 0;
        while (true) {
            block12: {
                try {
                    if (!iSQLResultSet.rowExists(n2)) {
                    }
                    break block12;
                }
                catch (SQLException sQLException) {
                    isql.getIO(iSQLResultSet.getConnection()).writeln(sQLException, ISQLResource.getISQLString(ErrorMessages.getName(), "ErrorReadingResultSet"), 2);
                }
                break;
            }
            outputStreamWriter.write("    <row>\n");
            for (int i = 0; i < n; ++i) {
                try {
                    StringBuffer stringBuffer = new StringBuffer(1024);
                    stringBuffer.append(INDENT_2);
                    stringBuffer.append("<column name=\"");
                    stringBuffer.append(OutputXML.escapeForXML(iSQLResultSet.getColumnName(i)));
                    stringBuffer.append("\"");
                    Object object = iSQLResultSet.getValueAt(n2, i);
                    if (object == null) {
                        stringBuffer.append(" null=\"true\">");
                    } else {
                        stringBuffer.append(">");
                        switch (iSQLResultSet.getColumnSQLType(i)) {
                            case -4: 
                            case -3: 
                            case -2: {
                                OutputXML.formatBinaryValue(stringBuffer, object);
                                break;
                            }
                            default: {
                                OutputXML.formatStringValue(stringBuffer, iSQLResultSet.getStringValueAt(n2, i));
                            }
                        }
                    }
                    stringBuffer.append("</column>\n");
                    outputStreamWriter.write(stringBuffer.toString());
                    continue;
                }
                catch (SQLException sQLException) {
                    break;
                }
            }
            outputStreamWriter.write("    </row>\n");
            ++n2;
        }
        outputStreamWriter.write("</resultset>\n");
        return n2;
    }

    private static String escapeForXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void encodeCDATA(StringBuffer stringBuffer, byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = (byArray[n2] & 0xF0) >> 4;
            stringBuffer.append(OutputStatement.hexTable[n3]);
            n3 = byArray[n2] & 0xF;
            stringBuffer.append(OutputStatement.hexTable[n3]);
            if (++n2 % 32 != 0) continue;
            stringBuffer.append("\n");
        }
    }

    private static void encodeCDATA(StringBuffer stringBuffer, InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        while ((n = inputStream.read()) != -1) {
            int n3 = (n & 0xF0) >> 4;
            stringBuffer.append(OutputStatement.hexTable[n3]);
            n3 = n & 0xF;
            stringBuffer.append(OutputStatement.hexTable[n3]);
            if (++n2 % 32 != 0) continue;
            stringBuffer.append("\n");
        }
    }

    private static void formatBinaryValue(StringBuffer stringBuffer, Object object) throws IOException {
        if (object instanceof byte[]) {
            stringBuffer.append("<![CDATA[");
            OutputXML.encodeCDATA(stringBuffer, (byte[])object);
            stringBuffer.append("]]>");
        } else if (object instanceof InputStream) {
            stringBuffer.append("<![CDATA[");
            OutputXML.encodeCDATA(stringBuffer, (InputStream)object);
            stringBuffer.append("]]>");
        }
    }

    private static void formatStringValue(StringBuffer stringBuffer, Object object) throws IOException {
        if (!(object instanceof String)) {
            OutputXML.formatBinaryValue(stringBuffer, object);
            return;
        }
        String string = (String)object;
        if (OutputXML.containsNonXMLChar(string)) {
            stringBuffer.append("<![CDATA[");
            OutputXML.encodeCDATA(stringBuffer, string.getBytes("UTF8"));
            stringBuffer.append("]]>");
        } else {
            stringBuffer.append(OutputXML.escapeForXML(string));
        }
    }

    private static boolean isXMLChar(char c) {
        return c == '\t' || c == '\n' || c == '\r' || ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd';
    }

    private static boolean containsNonXMLChar(String string) {
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (OutputXML.isXMLChar(string.charAt(i))) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

