/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.DialogUtils;
import com.sybase.util.HTMLWindow;
import com.sybase.util.OEMSupport;
import com.sybase.util.Platform;
import com.sybase.util.SybCheckBoxMenuItem;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybTitledPanel;
import com.sybase.util.SybTitledPanelCloseEvent;
import com.sybase.util.SybTitledPanelCloseListener;
import com.sybase.util.SybToolBarButton;
import com.sybase.util.UIUtils;
import com.sybase.util.win32.Registry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import sybase.isql.AboutBox;
import sybase.isql.AddToFavoritesDialog;
import sybase.isql.CollapsingSplitPane;
import sybase.isql.Dbg;
import sybase.isql.DynamicMenu;
import sybase.isql.DynamicMenuInfo;
import sybase.isql.FavoritesListItem;
import sybase.isql.FavoritesMenuItem;
import sybase.isql.FavoritesSidebar;
import sybase.isql.FileMenuItem;
import sybase.isql.GUIIO;
import sybase.isql.GeneralResources;
import sybase.isql.GuardSeparator;
import sybase.isql.History;
import sybase.isql.IO;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLEvent;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLJMenu;
import sybase.isql.ISQLListener;
import sybase.isql.ISQLPanel;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLUpdateService;
import sybase.isql.LogFile;
import sybase.isql.MRUList;
import sybase.isql.MenuResources;
import sybase.isql.OrganizeFavoritesDialog;
import sybase.isql.PlanFrame;
import sybase.isql.PluginMgr;
import sybase.isql.PostLoginProcedureHandler;
import sybase.isql.Preferences;
import sybase.isql.SQLTextComponent;
import sybase.isql.StatusBar;
import sybase.isql.WindowManager;
import sybase.isql.WindowMenuItem;
import sybase.isql.isql;

class ParentFrame
extends JFrame
implements MenuListener,
ISQLListener,
WindowListener,
ActionListener,
SybTitledPanelCloseListener {
    static final int INPUT_STATEMENT = 0;
    static final int OUTPUT_STATEMENT = 1;
    private static final int BUTTON = 1;
    private static final int SEPARATOR = 2;
    private static Icon _blank = null;
    private ISQLPanel _isqlPanel = null;
    private GUIIO _io = null;
    private int _disabledCount = 0;
    private JToolBar _toolbar = null;
    private JComboBox _dbComboBox = null;
    private FavoritesSidebar _favoritesSidebar = null;
    private CollapsingSplitPane _splitPane = null;
    private SybTitledPanel _favoritesPanel = null;
    private boolean _deferredShutdownRequested = false;
    private Timer _deferredShutdownTimer = null;
    private Hashtable<JMenuItem, Action> _menuItemActionTable = new Hashtable();
    private StatusBar _statusBar = null;
    private static final int ACTION_OPEN = 0;
    private static final int ACTION_SAVE_QUERY = 1;
    private static final int ACTION_SAVE_RESULTS = 2;
    private static final int ACTION_EXIT = 3;
    private static final int ACTION_CUT = 4;
    private static final int ACTION_COPY = 5;
    private static final int ACTION_PASTE = 6;
    private static final int ACTION_DELETE = 7;
    private static final int ACTION_EXECUTE = 8;
    private static final int ACTION_PREVIOUS_SQL = 9;
    private static final int ACTION_NEXT_SQL = 10;
    private static final int ACTION_SQL_HISTORY = 11;
    private static final int ACTION_ABOUT = 12;
    private static final int ACTION_NEW_WINDOW = 13;
    private static final int ACTION_CLEAR_SQL = 14;
    private static final int ACTION_IMPORT = 15;
    private static final int ACTION_LOOKUP_TABLE = 16;
    private static final int ACTION_START_LOGGING = 17;
    private static final int ACTION_STOP_LOGGING = 18;
    private static final int ACTION_OPTIONS = 19;
    private static final int ACTION_STOP = 20;
    private static final int ACTION_LOOKUP_PROCEDURE = 21;
    private static final int ACTION_SAVE_QUERY_AS = 22;
    private static final int ACTION_RUN_SCRIPT = 23;
    private static final int ACTION_EXECUTE_SELECTION = 24;
    private static final int ACTION_UNDO = 25;
    private static final int ACTION_REDO = 26;
    private static final int ACTION_CONNECT = 27;
    private static final int ACTION_DISCONNECT = 28;
    private static final int ACTION_CLOSE_WINDOW = 29;
    private static final int ACTION_HELP_INDEX = 30;
    private static final int ACTION_INSERT_FILE = 31;
    private static final int ACTION_ONLINE_RESOURCES = 32;
    private static final int ACTION_EDIT_QUERY = 33;
    private static final int ACTION_SELECT_ALL = 34;
    private static final int ACTION_FIND_REPLACE = 35;
    private static final int ACTION_FIND_NEXT = 36;
    private static final int ACTION_GO_TO_LINE = 37;
    private static final int ACTION_OPEN_PLAN_VIEWER = 38;
    private static final int ACTION_NEW = 39;
    private static final int ACTION_HELP_SQL_SYNTAX = 40;
    private static final int ACTION_INDEX_WIZARD = 41;
    private static final int ACTION_CHECK_FOR_SOFTWARE_UPDATES = 42;
    private static final int ACTION_PRINT_QUERY = 43;
    private static final int ACTION_SCC_GET = 44;
    private static final int ACTION_SCC_CHECKOUT = 45;
    private static final int ACTION_SCC_CHECKIN = 46;
    private static final int ACTION_SCC_UNDO_CHECKOUT = 47;
    private static final int ACTION_SCC_DIFF = 48;
    private static final int ACTION_SCC_PROPERTIES = 49;
    private static final int ACTION_SCC_RUN = 50;
    private static final int ACTION_SCC_HISTORY = 51;
    private static final int ACTION_SCC_OPEN = 52;
    private static final int ACTION_ADD_TO_FAVORITES = 53;
    private static final int ACTION_ORGANIZE_FAVORITES = 54;
    private static final int ACTION_SHOW_FAVORITES = 55;
    private static final int ACTION_SELECT_LINE = 56;
    private static final int ACTION_SELECT_STATEMENT = 57;
    private static final int ACTION_SELECT_NEXT_STATEMENT = 58;
    private static final int ACTION_SELECT_PREV_STATEMENT = 59;
    private static final int ACTION_HELP_KEYBOARD_SHORTCUTS = 60;
    private static final int ACTION_SINGLE_STEP = 61;
    private static final int ACTION_INDENT_TEXT_LEFT = 62;
    private static final int ACTION_INDENT_TEXT_RIGHT = 63;
    private static final int ACTION_ADD_REMOVE_DASH_COMMENT = 64;
    private static final int ACTION_ADD_REMOVE_SLASH_COMMENT = 65;
    private static final int NUMBER_OF_ACTIONS = 66;
    private ISQLAction[] _action = new ISQLAction[66];

    ParentFrame(ISQLConnection iSQLConnection, Rectangle rectangle) {
        this._io = new GUIIO(this);
        isql.setIO(iSQLConnection, this._io);
        this.createGUI(iSQLConnection, rectangle);
    }

    IO getIO() {
        return this._io;
    }

    ISQLConnection getConnection() {
        if (this._isqlPanel == null) {
            return null;
        }
        return this._isqlPanel.getConnection();
    }

    void setConnection(ISQLConnection iSQLConnection) {
        if (iSQLConnection != null) {
            isql.setIO(iSQLConnection, this._io);
        }
        this._isqlPanel.setConnection(iSQLConnection);
        this.notifyConnectionChanged();
    }

    void openConnection(ISQLPlugin iSQLPlugin, String string) {
        this._isqlPanel.processMenu("Disconnect");
        AbstractConnectionInfo abstractConnectionInfo = iSQLPlugin.getConnectionInfo();
        abstractConnectionInfo.deserialize(string);
        if (!Preferences.getAllowPasswordsInFavorites()) {
            abstractConnectionInfo.setPassword(null);
        }
        WindowManager.getWindowManager().connectFrameUsingConnectionInfo(this, iSQLPlugin, abstractConnectionInfo);
        if (this._isqlPanel.getConnection().isConnected()) {
            this._isqlPanel.printConnectedMessage();
        }
    }

    void notifyConnectionChanged() {
        ISQLConnection iSQLConnection = this._isqlPanel.getConnection();
        int n = iSQLConnection.getDatabaseType();
        if (n == 1) {
            this.fillDBNames(iSQLConnection);
        } else if (isql.options.useGUI && !isql.options.quiet && (n == 0 || n == 2)) {
            PostLoginProcedureHandler.execute((ISQLConnectionImpl)iSQLConnection);
        }
        this.enableToolbarButtons();
    }

    void updateCursorLocation(int n, int n2) {
        this._statusBar.setCursorLocation(n, n2);
    }

    void updateStatusMessage(Icon icon, String string) {
        this._statusBar.setStatusMessage(icon, string);
    }

    void clearStatusMessage() {
        this.updateStatusMessage(null, " ");
    }

    void updateSourceControlIndicator() {
        if (this._isqlPanel != null) {
            this._isqlPanel.updateSourceControlIndicator();
        }
    }

    void updateSourceControlIndicator(int n) {
        this._statusBar.setSourceControlIndicator(n);
    }

    void saveSplitBarPosition() {
        double d = this._isqlPanel.getSplitBarPosition();
        if (d != -1.0) {
            Preferences.setDoubleOption(this._isqlPanel.getConnection(), "mainSplitBarPosition", d);
        }
    }

    void setSplitBarPosition() {
        double d = Preferences.getDoubleOption(this._isqlPanel.getConnection(), "mainSplitBarPosition");
        if (d > 0.0) {
            this._isqlPanel.setSplitBarPosition(d);
        }
    }

    private void saveWindowPosition() {
        ISQLConnection iSQLConnection = this._isqlPanel.getConnection();
        int n = this.getExtendedState();
        Preferences.setIntOption(iSQLConnection, "windowState", n);
        if (n == 0) {
            Rectangle rectangle = this.getBounds();
            Preferences.saveWindowSize(iSQLConnection, "windowPosition", rectangle);
        }
    }

    private void guiFini() {
        JMenuBar jMenuBar;
        this.saveWindowPosition();
        this.saveSplitBarPosition();
        boolean bl = this._splitPane.isLeftComponentVisible();
        Preferences.setShowFavorites(bl);
        if (bl) {
            Preferences.setFavoritesWidth(this._splitPane.getDividerLocation());
        }
        Preferences.save(this._isqlPanel.getConnection());
        this.removeWindowListener(this);
        if (this._isqlPanel != null) {
            this._isqlPanel.removeISQLListener(this);
            this._isqlPanel.release();
            this._isqlPanel = null;
        }
        if (this._menuItemActionTable != null) {
            this._menuItemActionTable.clear();
            this._menuItemActionTable = null;
        }
        if (this._favoritesSidebar != null) {
            this._favoritesSidebar.destroy();
            this._favoritesSidebar = null;
        }
        if ((jMenuBar = this.getJMenuBar()) != null) {
            int n = jMenuBar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = jMenuBar.getComponent(i);
                if (component instanceof DynamicMenu) {
                    ((DynamicMenu)((Object)component)).destroy();
                }
                if (component instanceof JMenu) {
                    ((JMenu)component).removeMenuListener(this);
                }
                component = null;
            }
            jMenuBar = null;
        }
        if (this._statusBar != null) {
            this._statusBar.destroy();
            this._statusBar = null;
        }
        this._action = null;
        if (this._io != null) {
            this._io.destroy();
            this._io = null;
        }
        this._favoritesPanel.removeCloseListener((SybTitledPanelCloseListener)this);
        this._favoritesPanel = null;
        this._dbComboBox.removeActionListener(this);
        this._dbComboBox = null;
        this._toolbar = null;
        this.setJMenuBar(null);
        DialogUtils.removeComponents((Container)this);
        WindowManager.notifyFrameClosed(this);
    }

    private void createGUI(ISQLConnection iSQLConnection, Rectangle rectangle) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(ISQLImages.getImage("dbisql32.png"));
        arrayList.add(ISQLImages.getImage("dbisql64.png"));
        arrayList.add(ISQLImages.getImage("isql16"));
        this.setIconImages(arrayList);
        this.setBounds(rectangle);
        this.setWindowCaption(null);
        this._favoritesSidebar = new FavoritesSidebar(Preferences.getFavorites());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this._favoritesSidebar, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this._favoritesPanel = new SybTitledPanel((JComponent)jScrollPane, ISQLResource.getISQLString(GeneralResources.getName(), "FAVORITES_SIDEBAR_TITLE"));
        this._favoritesPanel.addCloseListener((SybTitledPanelCloseListener)this);
        this._isqlPanel = new ISQLPanel(this, iSQLConnection);
        this._isqlPanel.addISQLListener(this);
        this._splitPane = new CollapsingSplitPane(1, (Component)this._favoritesPanel, this._isqlPanel);
        this._splitPane.setDividerLocation(Preferences.getFavoritesWidth());
        if (!Preferences.getShowFavorites()) {
            this._splitPane.hideLeftComponent();
        }
        this.getContentPane().add(this._splitPane);
        this.createActions();
        this.createMenuBar();
        this.createToolBar();
        this.createStatusBar();
        this._isqlPanel.getTextComponent().updateStatusBarInformation();
        this.setSplitBarPosition();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    void enableToolbarButtons() {
        boolean bl = this._isqlPanel.shouldEnableMenu("Previous SQL");
        this._action[9].setEnabled(bl);
        bl = this._isqlPanel.shouldEnableMenu("History");
        this._action[11].setEnabled(bl);
        bl = this._isqlPanel.shouldEnableMenu("Next SQL");
        this._action[10].setEnabled(bl);
        bl = this._isqlPanel.shouldEnableMenu("Execute");
        this._action[8].setEnabled(bl);
        bl = this._isqlPanel.shouldEnableMenu("Execute Selection");
        this._action[24].setEnabled(bl);
        boolean bl2 = this._isqlPanel.getConnection() != null && this._isqlPanel.getConnection().isConnected() && this._isqlPanel.getConnection().getDatabaseType() == 1;
        this._dbComboBox.setVisible(bl2);
        if (bl2) {
            this._dbComboBox.setEnabled(bl);
            if (!bl) {
                this._dbComboBox.removeActionListener(this);
            }
        }
        bl = this._isqlPanel.shouldEnableMenu("Stop");
        this._action[20].setEnabled(bl);
        if (this._toolbar != null) {
            this._toolbar.repaint(0L);
        }
    }

    void fillDBNames(ISQLConnection iSQLConnection) {
        this._dbComboBox.removeActionListener(this);
        ArrayList<String> arrayList = iSQLConnection.getDatabaseNames();
        this._dbComboBox.removeActionListener(this);
        this._dbComboBox.removeAllItems();
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this._dbComboBox.addItem(iterator.next());
        }
        String string = iSQLConnection.getCatalog();
        this.setDBName(string);
        this._dbComboBox.addActionListener(this);
    }

    void setDBName(String string) {
        this._dbComboBox.setSelectedItem(string);
        this.setWindowTitle();
    }

    void refreshDatabaseList(ISQLConnection iSQLConnection) {
        if (this._dbComboBox != null) {
            this.fillDBNames(iSQLConnection);
        }
    }

    public void enableUI(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (this._disabledCount != 0) {
                --this._disabledCount;
            }
            if (this._disabledCount == 0) {
                this._isqlPanel.enablePanel();
                bl2 = true;
            }
        } else {
            if (this._disabledCount == 0) {
                this._isqlPanel.disablePanel();
                bl2 = true;
            }
            ++this._disabledCount;
        }
        if (bl2) {
            this.enableToolbarButtons();
        }
    }

    History getHistory() {
        return this._isqlPanel.getHistory();
    }

    private void createActions() {
        class ActionInfo {
            int index;
            String text;
            String iconID;

            ActionInfo(int n, String string, String string2) {
                this.index = n;
                this.text = string;
                this.iconID = string2;
            }
        }
        ActionInfo[] actionInfoArray = new ActionInfo[]{new ActionInfo(39, "New", "new"), new ActionInfo(13, "New Window", null), new ActionInfo(0, "Open...", "open"), new ActionInfo(29, "Close Window", null), new ActionInfo(1, "Save", "save"), new ActionInfo(22, "Save As...", null), new ActionInfo(2, "Export...", null), new ActionInfo(43, "PRINT_QUERY", "print"), new ActionInfo(23, "Run Script...", null), new ActionInfo(15, "Import...", null), new ActionInfo(3, "Exit", null), new ActionInfo(25, "Undo", "undo"), new ActionInfo(26, "Redo", "redo"), new ActionInfo(4, "Cut", "cut"), new ActionInfo(5, "Copy", "copy"), new ActionInfo(6, "Paste", "paste"), new ActionInfo(31, "Insert File...", null), new ActionInfo(7, "Delete", null), new ActionInfo(14, "Clear SQL", null), new ActionInfo(8, "Execute", "execute"), new ActionInfo(24, "Execute Selection", "execute_selection"), new ActionInfo(61, "SINGLE_STEP", null), new ActionInfo(38, "OPEN_PLAN_VIEWER", null), new ActionInfo(20, "Stop", "stop"), new ActionInfo(9, "Previous SQL", "back"), new ActionInfo(10, "Next SQL", "forward"), new ActionInfo(62, "INDENT_TEXT_LEFT", null), new ActionInfo(63, "INDENT_TEXT_RIGHT", null), new ActionInfo(64, "ADD_REMOVE_DASH_UNCOMMENT", null), new ActionInfo(65, "ADD_REMOVE_SLASH_UNCOMMENT", null), new ActionInfo(11, "History", "history"), new ActionInfo(27, "Connect", "connect"), new ActionInfo(28, "Disconnect", "disconnect"), new ActionInfo(17, "Start Logging...", null), new ActionInfo(18, "Stop Logging", null), new ActionInfo(16, "Lookup Table Name", null), new ActionInfo(21, "Lookup Procedure Name", null), new ActionInfo(41, "IndexConsultant", null), new ActionInfo(19, "Options...", null), new ActionInfo(30, "Index", "help16"), new ActionInfo(40, "SQL Syntax", null), new ActionInfo(60, "HELP_KEYBOARD_SHORTCUTS", null), new ActionInfo(42, "CheckForSoftwareUpdates", null), new ActionInfo(12, "About", null), new ActionInfo(32, "OnlineResources", null), new ActionInfo(33, "Edit Query", null), new ActionInfo(34, "SelectAll", null), new ActionInfo(56, "SELECT_LINE", null), new ActionInfo(57, "SELECT_STATEMENT", null), new ActionInfo(58, "SELECT_NEXT_STATEMENT", null), new ActionInfo(59, "SELECT_PREV_STATEMENT", null), new ActionInfo(35, "FindReplace", null), new ActionInfo(36, "FindNext", null), new ActionInfo(37, "GoToLine", null), new ActionInfo(44, "SCCGet", null), new ActionInfo(45, "SCCCheckOut", null), new ActionInfo(46, "SCCCheckIn", null), new ActionInfo(47, "SCCUndoCheckout", null), new ActionInfo(48, "SCCDiff", null), new ActionInfo(51, "SCCHistory", null), new ActionInfo(49, "SCCProperties", null), new ActionInfo(50, "SCCRun", null), new ActionInfo(52, "SCCOpen", null), new ActionInfo(53, "ADD_TO_FAVORITES", null), new ActionInfo(54, "ORGANIZE_FAVORITES", null), new ActionInfo(55, "SHOW_FAVORITES", null)};
        ISQLResource iSQLResource = ISQLResource.getISQLResource(MenuResources.getName());
        _blank = ISQLImages.getImageIcon("blank16");
        for (int i = 0; i < actionInfoArray.length; ++i) {
            int n = actionInfoArray[i].index;
            String string = iSQLResource.getISQLString(actionInfoArray[i].text);
            this._action[n] = actionInfoArray[i].iconID != null ? new ISQLAction(n, actionInfoArray[i].text, string, actionInfoArray[i].iconID) : new ISQLAction(n, actionInfoArray[i].text, string, _blank);
        }
    }

    private String getCanonicalActionCommand(JMenuItem jMenuItem) {
        return this.getCanonicalActionCommand(jMenuItem.getActionCommand());
    }

    private String getCanonicalActionCommand(JMenu jMenu) {
        String string = jMenu instanceof ISQLJMenu ? ((ISQLJMenu)((Object)jMenu)).canonicalText : jMenu.getActionCommand();
        return string;
    }

    private String getCanonicalActionCommand(String string) {
        String string2 = string;
        for (int i = 0; i < this._action.length; ++i) {
            if (!this._action[i]._localizedText.equals(string)) continue;
            string2 = this._action[i]._text;
            break;
        }
        return string2;
    }

    boolean isCloseable() {
        return this._isqlPanel != null && this._isqlPanel.canLoadQuery();
    }

    boolean isBusy() {
        return this._isqlPanel != null && this._isqlPanel.isInterruptable();
    }

    private boolean needsSaving() {
        return this._isqlPanel.needsSaving();
    }

    private void processHelpIndex() {
        this.showHelpTopic("HELP_ISQL_MAIN_PAGE");
    }

    private void processHelpSQLSyntax() {
        this.showHelpTopic("HELP_ISQL_SQL_SYNTAX");
    }

    private void processHelpKeyboardShortcuts() {
        this.showHelpTopic("HELP_ISQL_KEYBOARD_SHORTCUTS");
    }

    private void showHelpTopic(String string) {
        ISQLConnectionImpl iSQLConnectionImpl = (ISQLConnectionImpl)this._isqlPanel.getConnection();
        if (iSQLConnectionImpl != null) {
            ISQLHelpManager.showHelp(iSQLConnectionImpl, this, string);
        }
    }

    private void processOnlineResources() {
        if (Registry.isInstalled()) {
            String string = "SOFTWARE\\Sybase\\SQL Anywhere\\" + Integer.toString(11) + "." + Integer.toString(0);
            String string2 = Registry.getValue((int)0, (String)string, (String)"Online Resources");
            if (string2 != null && string2.length() != 0) {
                HTMLWindow.open((String)string2, (String)ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL"), (Image)ISQLImages.getImage("isql16"), (int)800, (int)600);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void processAbout() {
        AboutBox.open(this);
    }

    private void processNewWindow() {
        ParentFrame parentFrame;
        AbstractConnectionInfo abstractConnectionInfo = null;
        this._isqlPanel.saveHistory();
        WindowManager windowManager = WindowManager.getWindowManager();
        ISQLConnection iSQLConnection = this._isqlPanel.getConnection();
        if (iSQLConnection != null && iSQLConnection instanceof ISQLConnectionImpl) {
            abstractConnectionInfo = ((ISQLConnectionImpl)iSQLConnection).getConnectionInfo();
            ISQLPlugin iSQLPlugin = ((ISQLConnectionImpl)iSQLConnection).getPlugin();
            parentFrame = windowManager.createWindow(iSQLPlugin, abstractConnectionInfo);
        } else {
            parentFrame = windowManager.createWindow();
        }
        UIUtils.ensureWindowIsVisible((Window)parentFrame);
        parentFrame.setVisible(true);
    }

    private void processExitMenu() {
        if (this.isOKToClose()) {
            this.close();
        }
    }

    private void toggleFavoritesVisibility() {
        boolean bl = this._splitPane.isLeftComponentVisible();
        if (bl) {
            this._splitPane.hideLeftComponent();
        } else {
            this._splitPane.showLeftComponent();
        }
        Preferences.setShowFavorites(!bl);
    }

    private void processAddToFavorites() {
        AddToFavoritesDialog.create(this);
    }

    private void processOrganizeFavorites() {
        OrganizeFavoritesDialog.create(this);
    }

    /*
     * Unable to fully structure code
     */
    void processMenu(String var1_1, ActionEvent var2_2) {
        block13: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        block12: {
                                                            if (!this.shouldEnableMenu(var1_1)) {
                                                                return;
                                                            }
                                                            if (!var1_1.equals("New Window")) break block12;
                                                            this.processNewWindow();
                                                            break block13;
                                                        }
                                                        if (!var1_1.equals("Close Window")) break block14;
                                                        if (this.isOKToClose()) {
                                                            this.close();
                                                        }
                                                        break block13;
                                                    }
                                                    if (!var1_1.equals("Exit")) break block15;
                                                    this.processExitMenu();
                                                    break block13;
                                                }
                                                if (!var1_1.equals("About")) break block16;
                                                this.processAbout();
                                                break block13;
                                            }
                                            if (!var1_1.equals("Index")) break block17;
                                            this.processHelpIndex();
                                            break block13;
                                        }
                                        if (!var1_1.equals("SQL Syntax")) break block18;
                                        this.processHelpSQLSyntax();
                                        break block13;
                                    }
                                    if (!var1_1.equals("HELP_KEYBOARD_SHORTCUTS")) break block19;
                                    this.processHelpKeyboardShortcuts();
                                    break block13;
                                }
                                if (!var1_1.equals("OnlineResources")) break block20;
                                this.processOnlineResources();
                                break block13;
                            }
                            if (!var1_1.equals("CheckForSoftwareUpdates")) break block21;
                            ISQLUpdateService.showCheckForUpdatesDialog(this);
                            break block13;
                        }
                        if (!var1_1.equals("SHOW_FAVORITES")) break block22;
                        this.toggleFavoritesVisibility();
                        break block13;
                    }
                    if (!var1_1.equals("ADD_TO_FAVORITES")) break block23;
                    this.processAddToFavorites();
                    break block13;
                }
                if (!var1_1.equals("ORGANIZE_FAVORITES")) break block24;
                this.processOrganizeFavorites();
                break block13;
            }
            if (this._disabledCount != 0 && !var1_1.equals("Stop")) {
                Toolkit.getDefaultToolkit().beep();
            }
            if (var1_1.equals("Stop")) {
                this._action[20].setEnabled(false);
                if (this._toolbar != null) {
                    this._toolbar.repaint(0L);
                }
            }
            if (!var1_1.equals("Clear SQL") || var2_2.getSource() instanceof JMenuItem) ** GOTO lbl-1000
            var3_3 = this.getJMenuBar();
            var5_4 = var3_3.isSelected();
            var6_5 = var3_3.getSelectionModel().getSelectedIndex();
            if (var6_5 != -1 && !(var4_6 = var3_3.getMenu(var6_5)).isSelected()) {
                var5_4 = false;
            }
            if (var5_4) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                var3_3.getSelectionModel().clearSelection();
            } else {
                var7_7 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                var8_8 = var7_7.getFocusOwner();
                if (var8_8 != null && var8_8 instanceof JRootPane) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                } else lbl-1000:
                // 2 sources

                {
                    this._isqlPanel.processMenu(var1_1);
                    if (this._isqlPanel != null) {
                        this.enableToolbarButtons();
                    }
                }
            }
        }
        if (this._deferredShutdownRequested && this._deferredShutdownTimer == null) {
            this._deferredShutdownTimer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!ParentFrame.this._isqlPanel.isInterruptable()) {
                        ParentFrame.this._deferredShutdownTimer.stop();
                        ParentFrame.this.processExitMenu();
                        ParentFrame.this._deferredShutdownTimer = null;
                        ParentFrame.this._deferredShutdownRequested = false;
                    } else {
                        ParentFrame.this._isqlPanel.stopTheCurrentCommand();
                        ParentFrame.this._deferredShutdownTimer.restart();
                    }
                }
            });
            this._deferredShutdownTimer.setRepeats(false);
            this._deferredShutdownTimer.start();
        }
    }

    boolean shouldEnableMenu(String string) {
        boolean bl = false;
        if (string.equals("Exit") || string.equals("New Window") || string.equals("Close Window") || string.equals("Index") || string.equals("OnlineResources") || string.equals("About")) {
            bl = true;
        } else if (string.equals("ADD_TO_FAVORITES")) {
            if (this._isqlPanel.isInterruptable()) {
                return false;
            }
            ISQLConnection iSQLConnection = this.getConnection();
            boolean bl2 = iSQLConnection != null && iSQLConnection.isConnected();
            File file = this.getFile();
            bl = bl2 || file != null;
        } else {
            bl = this._isqlPanel.shouldEnableMenu(string);
        }
        return bl;
    }

    private JMenu createMenu(ISQLResource iSQLResource, String string, String string2) {
        ISQLJMenu iSQLJMenu = new ISQLJMenu(iSQLResource.getISQLString(string), string);
        ((AbstractButton)((Object)iSQLJMenu)).setMnemonic(iSQLResource.getISQLChar(string2));
        return iSQLJMenu;
    }

    private void createStatusBar() {
        this._statusBar = new StatusBar();
        this.getContentPane().add((Component)this._statusBar, "South");
    }

    void recreateToolBar() {
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof ToolbarPanel)) continue;
            this.getContentPane().remove(componentArray[i]);
            this.createToolBar();
            this.validate();
            break;
        }
    }

    private void createToolBar() {
        JToolBar jToolBar = null;
        ISQLToolbarButton iSQLToolbarButton = null;
        String string = null;
        class ToolbarInfo {
            int type = -1;
            int command = -1;
            String hintText;

            ToolbarInfo(int n, String string) {
                this.type = 1;
                this.command = n;
                this.hintText = string;
            }

            ToolbarInfo() {
                this.type = 2;
            }
        }
        ToolbarInfo[] toolbarInfoArray = new ToolbarInfo[]{new ToolbarInfo(9, "Recall previous SQL statement"), new ToolbarInfo(11, "Open a list of past SQL statements"), new ToolbarInfo(10, "Recall next SQL statement"), new ToolbarInfo(), new ToolbarInfo(8, "Execute SQL statement(s)"), new ToolbarInfo(20, "Interrupt the SQL statement")};
        ISQLResource iSQLResource = ISQLResource.getISQLResource(MenuResources.getName());
        jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        for (int i = 0; i < toolbarInfoArray.length; ++i) {
            if (toolbarInfoArray[i].type == 1) {
                if (toolbarInfoArray[i].command == 8 && Preferences.getExecuteToolbarButtonSemantics().equals("selection")) {
                    toolbarInfoArray[i].command = 24;
                    toolbarInfoArray[i].hintText = "Execute selected statement(s)";
                }
                iSQLToolbarButton = new ISQLToolbarButton(this._action[toolbarInfoArray[i].command]);
                jToolBar.add((Component)((Object)iSQLToolbarButton));
                iSQLToolbarButton.setText(null);
                if (toolbarInfoArray[i].hintText == null) continue;
                string = iSQLResource.getISQLString(toolbarInfoArray[i].hintText);
                iSQLToolbarButton.setToolTipText(string);
                continue;
            }
            jToolBar.addSeparator();
        }
        this._dbComboBox = new DBComboBox();
        ToolbarPanel toolbarPanel = new ToolbarPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        toolbarPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        toolbarPanel.add((Component)jToolBar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        Component component = Box.createGlue();
        gridBagLayout.setConstraints(component, gridBagConstraints);
        toolbarPanel.add(component);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this._dbComboBox, gridBagConstraints);
        toolbarPanel.add(this._dbComboBox);
        this._dbComboBox.setVisible(false);
        this.getContentPane().add((Component)toolbarPanel, "North");
        this._toolbar = jToolBar;
        this.enableToolbarButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._dbComboBox) {
            String string = this._dbComboBox.getSelectedItem().toString();
            try {
                this._isqlPanel.getConnection().setCatalog(string);
                isql.notifyDatabaseSelected(this._isqlPanel.getConnection(), string);
            }
            catch (SQLException sQLException) {
                Dbg.printlnEx((Throwable)sQLException, (String)("Could not set database to " + string));
                this._dbComboBox.setSelectedItem(this._isqlPanel.getConnection().getCatalog());
            }
        }
    }

    private void createMenuBar() {
        int n;
        DynamicMenuInfo[] dynamicMenuInfoArray;
        DynamicMenuInfo[] dynamicMenuInfoArray2;
        DynamicMenuInfo[] dynamicMenuInfoArray3 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[52], 52, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[44], 44, 0, 0), new DynamicMenuInfo(1, this._action[45], 45, 0, 0), new DynamicMenuInfo(1, this._action[46], 46, 0, 0), new DynamicMenuInfo(1, this._action[47], 47, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[48], 48, 0, 0), new DynamicMenuInfo(1, this._action[51], 51, 0, 0), new DynamicMenuInfo(1, this._action[49], 49, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[50], 50, 0, 0)};
        DynamicMenuInfo[] dynamicMenuInfoArray4 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[39], 39, 78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[0], 0, 79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[1], 1, 83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[22], 22, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo("SourceControl", dynamicMenuInfoArray3), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[43], 43, 80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[23], 23, 0, 0), new DynamicMenuInfo(3), new DynamicMenuInfo(3), new DynamicMenuInfo(1, this._action[3], 3, 115, 8)};
        if (Platform.isMacOS()) {
            dynamicMenuInfoArray2 = new DynamicMenuInfo[dynamicMenuInfoArray4.length - 2];
            System.arraycopy(dynamicMenuInfoArray4, 0, dynamicMenuInfoArray2, 0, dynamicMenuInfoArray4.length - 2);
            dynamicMenuInfoArray4 = dynamicMenuInfoArray2;
        }
        dynamicMenuInfoArray2 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[34], 34, 65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[56], 56, 44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[57], 57, 46, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[58], 58, 40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[59], 59, 38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())};
        DynamicMenuInfo[] dynamicMenuInfoArray5 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[63], 63, 46, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1), new DynamicMenuInfo(1, this._action[62], 62, 44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1), new DynamicMenuInfo(1, this._action[64], 64, 45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[65], 65, 47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())};
        DynamicMenuInfo[] dynamicMenuInfoArray6 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[25], 25, 90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[26], 26, 89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[4], 4, 88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[5], 5, 67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[6], 6, 86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[7], 7, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[35], 35, 70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[36], 36, 114, 0), new DynamicMenuInfo(1, this._action[37], 37, 71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[31], 31, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[14], 14, 27, 0), new DynamicMenuInfo("SELECT", dynamicMenuInfoArray2), new DynamicMenuInfo("ADVANCED", dynamicMenuInfoArray5)};
        DynamicMenuInfo[] dynamicMenuInfoArray7 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[8], 8, 116, 0), new DynamicMenuInfo(1, this._action[24], 24, Platform.isMacOS() ? 0 : 120, 0), new DynamicMenuInfo(1, this._action[61], 61, Platform.isMacOS() ? 0 : 120, Platform.isMacOS() ? 0 : 1), new DynamicMenuInfo(1, this._action[20], 20, 3, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[9], 9, Platform.isSunOS() ? 38 : 37, Platform.isSunOS() ? 2 : 8), new DynamicMenuInfo(1, this._action[10], 10, Platform.isSunOS() ? 40 : 39, Platform.isSunOS() ? 2 : 8), new DynamicMenuInfo(1, this._action[11], 11, 72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[17], 17, 0, 0), new DynamicMenuInfo(1, this._action[18], 18, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[27], 27, Platform.isMacOS() ? 0 : 122, 0), new DynamicMenuInfo(1, this._action[28], 28, Platform.isMacOS() ? 0 : 123, 0)};
        DynamicMenuInfo[] dynamicMenuInfoArray8 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[2], 2, 0, 0), new DynamicMenuInfo(1, this._action[15], 15, 0, 0)};
        DynamicMenuInfo[] dynamicMenuInfoArray9 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[53], 53, 0, 0), new DynamicMenuInfo(1, this._action[54], 54, 0, 0), new DynamicMenuInfo(5, this._action[55], 55, 0, 0), new DynamicMenuInfo(2)};
        DynamicMenuInfo[] dynamicMenuInfoArray10 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[16], 16, 118, 0), new DynamicMenuInfo(1, this._action[21], 21, 119, 0), new DynamicMenuInfo(1, this._action[33], 33, 81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), new DynamicMenuInfo(1, this._action[41], 41, 0, 0), new DynamicMenuInfo(1, this._action[38], 38, 116, 1), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[19], 19, 0, 0)};
        if (Platform.isMacOS()) {
            dynamicMenuInfoArray = new DynamicMenuInfo[dynamicMenuInfoArray10.length - 2];
            System.arraycopy(dynamicMenuInfoArray10, 0, dynamicMenuInfoArray, 0, dynamicMenuInfoArray10.length - 2);
            dynamicMenuInfoArray10 = dynamicMenuInfoArray;
        }
        dynamicMenuInfoArray = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[13], 13, 0, 0), new DynamicMenuInfo(1, this._action[29], 29, 0, 0), new DynamicMenuInfo(2)};
        DynamicMenuInfo[] dynamicMenuInfoArray11 = new DynamicMenuInfo[]{new DynamicMenuInfo(1, this._action[30], 30, 112, 0), new DynamicMenuInfo(1, this._action[40], 40, 0, 0), new DynamicMenuInfo(1, this._action[60], 60, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[42], 42, 0, 0), new DynamicMenuInfo(1, this._action[32], 32, 0, 0), new DynamicMenuInfo(2), new DynamicMenuInfo(1, this._action[12], 12, 0, 0)};
        ArrayList<DynamicMenuInfo> arrayList = new ArrayList<DynamicMenuInfo>();
        block5: for (n = 0; n < dynamicMenuInfoArray11.length; ++n) {
            switch (dynamicMenuInfoArray11[n].command) {
                case 32: {
                    if (!Platform.isWindows()) continue block5;
                    arrayList.add(dynamicMenuInfoArray11[n]);
                    continue block5;
                }
                case 42: {
                    if (!OEMSupport.getOEMSupport().getCheckForUpdates()) continue block5;
                    arrayList.add(dynamicMenuInfoArray11[n]);
                    continue block5;
                }
                case 12: {
                    if (Platform.isMacOS()) continue block5;
                    arrayList.add(dynamicMenuInfoArray11[n]);
                    continue block5;
                }
                default: {
                    arrayList.add(dynamicMenuInfoArray11[n]);
                }
            }
        }
        for (n = arrayList.size() - 1; n > 0; --n) {
            if (((DynamicMenuInfo)arrayList.get((int)n)).type != 2 || n != arrayList.size() - 1 && ((DynamicMenuInfo)arrayList.get((int)(n - 1))).type != 2) continue;
            arrayList.remove(n);
        }
        if (arrayList.size() != dynamicMenuInfoArray11.length) {
            dynamicMenuInfoArray11 = new DynamicMenuInfo[arrayList.size()];
            arrayList.toArray(dynamicMenuInfoArray11);
        }
        JMenuBar jMenuBar = new JMenuBar();
        ISQLResource iSQLResource = ISQLResource.getISQLResource(MenuResources.getName());
        DynamicMenu dynamicMenu = new DynamicMenu(this, "File", iSQLResource.getISQLString("File"), dynamicMenuInfoArray4);
        dynamicMenu.addMenuListener(this);
        jMenuBar.add((JMenu)((Object)dynamicMenu));
        dynamicMenu = new DynamicMenu(this, "Edit", iSQLResource.getISQLString("Edit"), dynamicMenuInfoArray6);
        dynamicMenu.addMenuListener(this);
        jMenuBar.add((JMenu)((Object)dynamicMenu));
        dynamicMenu = new DynamicMenu(this, "SQL", iSQLResource.getISQLString("SQL"), dynamicMenuInfoArray7);
        dynamicMenu.addMenuListener(this);
        jMenuBar.add((JMenu)((Object)dynamicMenu));
        dynamicMenu = new DynamicMenu(this, "Data", iSQLResource.getISQLString("Data"), dynamicMenuInfoArray8);
        dynamicMenu.addMenuListener(this);
        jMenuBar.add((JMenu)((Object)dynamicMenu));
        dynamicMenu = new DynamicMenu(this, "FAVORITES", iSQLResource.getISQLString("FAVORITES"), dynamicMenuInfoArray9);
        dynamicMenu.addMenuListener(this);
        jMenuBar.add((JMenu)((Object)dynamicMenu));
        dynamicMenu = new DynamicMenu(this, "Tools", iSQLResource.getISQLString("Tools"), dynamicMenuInfoArray10);
        dynamicMenu.addMenuListener(this);
        jMenuBar.add((JMenu)((Object)dynamicMenu));
        dynamicMenu = new DynamicMenu(this, "Window", iSQLResource.getISQLString("Window"), dynamicMenuInfoArray);
        dynamicMenu.addMenuListener(this);
        jMenuBar.add((JMenu)((Object)dynamicMenu));
        dynamicMenu = new DynamicMenu(this, "Help", iSQLResource.getISQLString("Help"), dynamicMenuInfoArray11);
        dynamicMenu.addMenuListener(this);
        jMenuBar.add((JMenu)((Object)dynamicMenu));
        this.setJMenuBar(jMenuBar);
    }

    void registerMenu(JMenu jMenu) {
        jMenu.setIcon(null);
        jMenu.addMenuListener(this);
    }

    void registerMenuItem(JMenuItem jMenuItem, Action action) {
        this._menuItemActionTable.put(jMenuItem, action);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        int n;
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        boolean bl = false;
        jMenu = (JMenu)menuEvent.getSource();
        String string = this.getCanonicalActionCommand(jMenu);
        if (string.equals("Window")) {
            this.rebuildWindowMenu(jMenu);
        } else if (string.equals("FAVORITES")) {
            this.rebuildFavoritesMenu(jMenu);
        } else if (string.equals("File")) {
            this.rebuildFileMenu(jMenu);
        }
        int n2 = jMenu.getItemCount();
        for (n = 0; n < n2; ++n) {
            boolean bl2;
            jMenuItem = jMenu.getItem(n);
            if (jMenuItem == null) continue;
            if (jMenuItem instanceof WindowMenuItem) {
                jMenuItem.setEnabled(true);
                continue;
            }
            if (jMenuItem instanceof FileMenuItem) {
                bl2 = this.shouldEnableMenu("Open...");
                jMenuItem.setEnabled(bl2);
                continue;
            }
            if (jMenuItem instanceof FavoritesMenuItem) {
                bl2 = this.shouldEnableMenu("Open...");
                jMenuItem.setEnabled(bl2);
                continue;
            }
            ISQLAction iSQLAction = (ISQLAction)this._menuItemActionTable.get(jMenuItem);
            if (iSQLAction == null) continue;
            bl2 = this.shouldEnableMenu(iSQLAction._text);
            iSQLAction.setEnabled(bl2);
            boolean bl3 = jMenuItem.isVisible();
            if (bl3 == this._isqlPanel.shouldIncludeMenu(iSQLAction._text)) continue;
            jMenuItem.setVisible(!bl3);
            bl = true;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component[] componentArray = jMenu.getMenuComponents();
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof JSeparator) && !componentArray[n].isVisible()) continue;
            arrayList.add(componentArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Component component = (Component)arrayList.get(n);
            if (!(component instanceof JSeparator)) continue;
            if (n == arrayList.size() - 1) {
                component.setVisible(false);
                continue;
            }
            Component component2 = (Component)arrayList.get(n + 1);
            if (component2 instanceof JSeparator) {
                component.setVisible(true);
                component2.setVisible(false);
                ++n;
                continue;
            }
            component.setVisible(true);
        }
    }

    private void rebuildFileMenu(JMenu jMenu) {
        Component component;
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        if (Platform.isMacOS()) {
            boolean bl = false;
            n2 = jMenu.getItemCount();
            for (n = 0; n < n2; ++n) {
                component = jMenu.getMenuComponent(n);
                if (component instanceof GuardSeparator) {
                    bl = true;
                    n3 = n;
                    n4 = n;
                    continue;
                }
                if (!bl) continue;
                jMenu.remove(component);
                --n;
                --n2;
            }
            if (n3 == -1) {
                jMenu.getPopupMenu().add(new GuardSeparator());
                n4 = n3 = jMenu.getItemCount() - 1;
            }
        } else {
            n2 = jMenu.getItemCount();
            for (n = n2 - 1; n >= 0; --n) {
                component = jMenu.getMenuComponent(n);
                if (!(component instanceof GuardSeparator)) continue;
                if (n4 == -1) {
                    n4 = n;
                    continue;
                }
                if (n3 != -1) continue;
                n3 = n;
                break;
            }
            if (n3 != -1 && n4 != -1) {
                for (n = n4 - 1; n > n3; --n) {
                    jMenu.remove(n);
                }
            }
            if (n3 == -1) {
                n3 = n4;
                jMenu.getPopupMenu().insert(new GuardSeparator(), n3);
            }
        }
        MRUList mRUList = Preferences.getMRUList();
        n2 = mRUList.getCount();
        if (n2 == 0) {
            if (n3 != -1) {
                jMenu.remove(n3);
            }
        } else {
            String string = ISQLResource.getISQLString(GeneralResources.getName(), "{0} {1}");
            String[] stringArray = new String[2];
            for (n = 0; n < n2 && n < 10; ++n) {
                stringArray[0] = String.valueOf(n + 1);
                stringArray[1] = mRUList.getFile(n);
                String string2 = SybMessageFormat.format((String)string, (Object[])stringArray);
                FileMenuItem fileMenuItem = new FileMenuItem(string2, null);
                fileMenuItem.setMnemonic(String.valueOf(n + 1).charAt(0));
                fileMenuItem.setActionCommand(stringArray[1]);
                fileMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        ParentFrame.this.processFileMenu(ParentFrame.this.getCanonicalActionCommand(jMenuItem));
                    }
                });
                jMenu.insert(fileMenuItem, n3 + 1 + n);
            }
            stringArray = null;
        }
    }

    private void processFileMenu(String string) {
        ParentFrame parentFrame = WindowManager.findFrameByFileName(string);
        if (parentFrame != null) {
            if (parentFrame.getState() == 1) {
                parentFrame.setState(0);
            }
            parentFrame.setVisible(true);
            parentFrame._isqlPanel.load(new File(string));
        } else {
            this._isqlPanel.load(new File(string));
        }
    }

    private void rebuildFavoritesMenu(JMenu jMenu) {
        Component component;
        int n;
        while ((n = jMenu.getItemCount()) != 0 && !((component = jMenu.getMenuComponent(n - 1)) instanceof JSeparator)) {
            jMenu.remove(n - 1);
        }
        n = jMenu.getItemCount();
        for (int i = 0; i < n - 1; ++i) {
            component = jMenu.getMenuComponent(i);
            if (!(component instanceof SybCheckBoxMenuItem)) continue;
            ((SybCheckBoxMenuItem)component).setSelected(this._splitPane.isLeftComponentVisible());
        }
        FavoritesListItem favoritesListItem = Preferences.getFavorites().getRoot();
        if (favoritesListItem.getChildCount() > 0) {
            this.addContentsToMenu(jMenu, Preferences.getFavorites().getRoot());
        } else {
            JMenuItem jMenuItem = new JMenuItem(ISQLResource.getISQLString(GeneralResources.getName(), "NO_FAVORITES_MENU_ITEM"));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
    }

    void addContentsToMenu(JMenu jMenu, FavoritesListItem favoritesListItem) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JMenuItem) {
                    FavoritesListItem favoritesListItem = (FavoritesListItem)((JComponent)object).getClientProperty("item");
                    if (favoritesListItem.getType() == 2) {
                        ParentFrame.this.openFile(new File(favoritesListItem.getStringData()));
                    } else {
                        ISQLPlugin iSQLPlugin = PluginMgr.getPlugin(favoritesListItem.getPluginID());
                        ParentFrame.this.openConnection(iSQLPlugin, favoritesListItem.getStringData());
                    }
                }
            }
        };
        int n = favoritesListItem.getChildCount();
        block5: for (int i = 0; i < n; ++i) {
            String string;
            Icon icon;
            FavoritesMenuItem favoritesMenuItem;
            FavoritesListItem favoritesListItem2 = favoritesListItem.getChild(i);
            switch (favoritesListItem2.getType()) {
                case 3: {
                    JMenu jMenu2 = new JMenu(favoritesListItem2.getName());
                    jMenu2.setIcon(FavoritesSidebar.FSCellRenderer.getFolderIcon());
                    if (favoritesListItem2.getChildCount() > 0) {
                        this.addContentsToMenu(jMenu2, favoritesListItem2);
                    } else {
                        favoritesMenuItem = new SybMenuItem(GeneralResources.getISQLString(GeneralResources.getName(), "EMPTY_FAVORITE_MENU"));
                        favoritesMenuItem.setEnabled(false);
                        jMenu2.add(favoritesMenuItem);
                    }
                    jMenu.add(jMenu2);
                    continue block5;
                }
                case 1: {
                    icon = FavoritesSidebar.FSCellRenderer.getConnectionIcon(favoritesListItem2);
                    string = favoritesListItem2.getName();
                    break;
                }
                case 2: {
                    icon = FavoritesSidebar.FSCellRenderer.getIconForFavorite(favoritesListItem2);
                    string = favoritesListItem2.getName();
                    break;
                }
                default: {
                    continue block5;
                }
            }
            favoritesMenuItem = new FavoritesMenuItem(string, icon);
            favoritesMenuItem.putClientProperty("item", favoritesListItem2);
            favoritesMenuItem.addActionListener(actionListener);
            jMenu.add(favoritesMenuItem);
        }
    }

    private void rebuildWindowMenu(JMenu jMenu) {
        JMenuItem jMenuItem;
        Component component;
        int n;
        while ((n = jMenu.getItemCount()) != 0 && !((component = jMenu.getMenuComponent(n - 1)) instanceof JSeparator)) {
            jMenu.remove(n - 1);
        }
        Object[] objectArray = WindowManager.getParentFrames();
        PlanFrame[] planFrameArray = PlanFrame.getAllPlanFrames();
        if (planFrameArray != null) {
            Object[] objectArray2 = new Object[objectArray.length + planFrameArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            System.arraycopy(planFrameArray, 0, objectArray2, objectArray.length, planFrameArray.length);
            objectArray = objectArray2;
        }
        n = objectArray.length;
        String string = ISQLResource.getISQLString(GeneralResources.getName(), "{0} {1}");
        String[] stringArray = new String[2];
        for (int i = 0; i < n && i < 10; ++i) {
            stringArray[0] = String.valueOf(i + 1);
            stringArray[1] = ((Frame)objectArray[i]).getTitle();
            String string2 = SybMessageFormat.format((String)string, (Object[])stringArray);
            jMenuItem = new WindowMenuItem(string2, null);
            jMenuItem.setMnemonic(String.valueOf(i + 1).charAt(0));
            jMenuItem.setActionCommand(String.valueOf(i));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    ParentFrame.processWindowMenu(jMenuItem.getActionCommand());
                }
            });
            jMenu.add(jMenuItem);
        }
        stringArray = null;
        if (n == 0) {
            ISQLResource iSQLResource = ISQLResource.getISQLResource(MenuResources.getName());
            jMenuItem = new SybMenuItem(iSQLResource.getISQLString("(None)"));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
        jMenuItem = jMenu.getItem(0);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.setEnabled(true);
        }
    }

    private static void processWindowMenu(String string) {
        JFrame jFrame;
        Object[] objectArray;
        int n = Integer.parseInt(string);
        if (n < (objectArray = WindowManager.getParentFrames()).length) {
            jFrame = (JFrame)objectArray[n];
        } else {
            PlanFrame[] planFrameArray = PlanFrame.getAllPlanFrames();
            jFrame = planFrameArray[n -= objectArray.length];
        }
        if (jFrame.getState() == 1) {
            jFrame.setState(0);
        }
        jFrame.setVisible(true);
    }

    private void setWindowCaption(String string) {
        String string2;
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        if (string == null) {
            string2 = iSQLResource.getISQLString("Interactive SQL");
        } else {
            string2 = iSQLResource.getISQLString("{0} - Interactive SQL");
            String[] stringArray = new String[]{string};
            string2 = SybMessageFormat.format((String)string2, (Object[])stringArray);
            stringArray = null;
        }
        this.setTitle(string2);
    }

    void close() {
        this.setVisible(false);
        this.guiFini();
    }

    boolean isOKToClose() {
        boolean bl = false;
        if (this.isCloseable()) {
            if (this._isqlPanel != null && this._isqlPanel.isInterruptable()) {
                int n = SybOptionPane.showConfirmDialog((Component)this, (Object)ISQLResource.getISQLString(GeneralResources.getName(), "StatementStillRunning"), (String)this.getTitle(), (int)0);
                if (n == 0) {
                    this._isqlPanel.stopTheCurrentCommand();
                    this._deferredShutdownRequested = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.isOKToClose()) {
            this.close();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.guiFini();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    boolean isInterruptRequested(int n) {
        boolean bl;
        if (n == 0) {
            bl = this._isqlPanel.interruptInputStatement;
        } else if (n == 1) {
            bl = this._isqlPanel.interruptOutputStatement;
        } else {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        return bl;
    }

    void clearInterrupt(int n) {
        if (n == 0) {
            this._isqlPanel.interruptInputStatement = false;
        } else if (n == 1) {
            this._isqlPanel.interruptOutputStatement = false;
        } else {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    void requestInterrupt(int n) {
        if (n == 0) {
            this._isqlPanel.interruptInputStatement = true;
        } else if (n == 1) {
            this._isqlPanel.interruptOutputStatement = true;
        } else {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    void setInputStatementInProgress(boolean bl) {
        this._isqlPanel.inputStatementInProgress = bl;
    }

    void setOutputStatementInProgress(boolean bl) {
        this._isqlPanel.outputStatementInProgress = bl;
    }

    void setWindowTitle() {
        this.setTitle(this._isqlPanel.getWindowTitle());
    }

    void notifyConnectionClosed() {
        this._isqlPanel.discardConnection();
        this.enableToolbarButtons();
    }

    private LogFile getLogFile() {
        return this._isqlPanel.getLogFile();
    }

    boolean startLogging(String string) {
        LogFile logFile = this.getLogFile();
        boolean bl = logFile != null ? logFile.open(string, true, isql.getIO(this.getConnection())) : false;
        return bl;
    }

    void log(String string) {
        LogFile logFile = this.getLogFile();
        logFile.write(string, isql.getIO(this.getConnection()));
    }

    void stopLogging() {
        LogFile logFile = this.getLogFile();
        if (logFile != null) {
            logFile.close(isql.getIO(this.getConnection()));
        }
    }

    void clear() {
        this._isqlPanel.clear();
    }

    void executeSQL(String string) {
        this._isqlPanel.execute(string);
    }

    void setSQLStatement(String string) {
        this._isqlPanel.setSQLStatementsText(string);
    }

    int[] getSQLStatementsTextSelection() {
        SQLTextComponent sQLTextComponent = this._isqlPanel.getTextComponent();
        int[] nArray = new int[]{sQLTextComponent.getSelectionStart(), sQLTextComponent.getSelectionEnd()};
        return nArray;
    }

    void setSQLStatementsTextSelection(int[] nArray) {
        SQLTextComponent sQLTextComponent = this._isqlPanel.getTextComponent();
        sQLTextComponent.setSelectionStart(nArray[0]);
        sQLTextComponent.setSelectionEnd(nArray[1]);
    }

    void setSQLStatementsTextSelection(int n, int n2) {
        SQLTextComponent sQLTextComponent = this._isqlPanel.getTextComponent();
        sQLTextComponent.setSelectedLines(n, n2);
    }

    File getFile() {
        return this._isqlPanel.getFileName();
    }

    @Override
    public void updateWindowTitle(ISQLEvent iSQLEvent) {
        this.setTitle(this._isqlPanel.getWindowTitle());
    }

    void updateResultSetTableFont() {
        if (this._isqlPanel != null) {
            this._isqlPanel.updateResultSetTableFont();
        }
    }

    void updateResultSetTableClipboardFormat() {
        if (this._isqlPanel != null) {
            this._isqlPanel.updateResultSetTableClipboardFormat();
        }
    }

    void updateResultSetTableTruncationLength() {
        if (this._isqlPanel != null) {
            this._isqlPanel.updateResultSetTableTruncationLength();
        }
    }

    void setShowResultsAsText(boolean bl) {
        if (this._isqlPanel != null) {
            this._isqlPanel.setShowResultsAsText(bl);
        }
    }

    void showProgress(String string, int n) {
    }

    void showProgressBar(JProgressBar jProgressBar, String string, Icon icon) {
        this._statusBar.addProgressBar(jProgressBar, string, icon);
    }

    void hideProgressBar(JProgressBar jProgressBar, String string, Icon icon) {
        this._statusBar.removeProgressBar(jProgressBar, string, icon);
    }

    void requestDefaultFocus() {
        if (this._isqlPanel != null) {
            this._isqlPanel.getTextComponent().requestFocus();
        }
    }

    void openCustomizationDialog() {
        if (this._isqlPanel != null) {
            this._isqlPanel.openCustomizationDialog(this);
        }
    }

    void openFile(File file) {
        if (this._isqlPanel != null && this._disabledCount == 0) {
            this.enableUI(false);
            this._isqlPanel.load(file);
            this.enableUI(true);
        }
    }

    int displaySCCMessage(int n, String string) {
        int n2 = this._isqlPanel != null ? this._isqlPanel.displaySCCMessage(n, string) : 0;
        return n2;
    }

    public void closeRequested(SybTitledPanelCloseEvent sybTitledPanelCloseEvent) {
        this.hideFavorites();
    }

    private void hideFavorites() {
        this._splitPane.hideLeftComponent();
        Preferences.setShowFavorites(false);
    }

    class DBComboBox
    extends JComboBox
    implements MouseListener {
        private MouseListener[] _listeners;
        private MouseListener[] _cbListeners;

        DBComboBox() {
            this.setPrototypeDisplayValue("012345678901234567890123456789012");
            ComboBoxUI comboBoxUI = this.getUI();
            if (comboBoxUI instanceof BasicComboBoxUI) {
                int n;
                MouseListener[] mouseListenerArray;
                try {
                    Field field = BasicComboBoxUI.class.getDeclaredField("arrowButton");
                    field.setAccessible(true);
                    JButton jButton = (JButton)field.get(comboBoxUI);
                    mouseListenerArray = jButton.getMouseListeners();
                    this._listeners = new MouseListener[mouseListenerArray.length];
                    for (n = 0; n < mouseListenerArray.length; ++n) {
                        this._listeners[n] = mouseListenerArray[n];
                        jButton.removeMouseListener(mouseListenerArray[n]);
                    }
                    jButton.addMouseListener(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mouseListenerArray = this.getMouseListeners();
                this._cbListeners = new MouseListener[mouseListenerArray.length];
                for (n = 0; n < mouseListenerArray.length; ++n) {
                    this._cbListeners[n] = mouseListenerArray[n];
                    this.removeMouseListener(mouseListenerArray[n]);
                }
                this.addMouseListener(this);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isPopupVisible() && this.isEnabled()) {
                ISQLConnection iSQLConnection = ParentFrame.this._isqlPanel.getConnection();
                if (iSQLConnection != null) {
                    ParentFrame.this.refreshDatabaseList(iSQLConnection);
                }
                super.setPopupVisible(true);
            } else {
                super.setPopupVisible(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JButton) {
                for (int i = 0; i < this._listeners.length; ++i) {
                    this._listeners[i].mouseReleased(mouseEvent);
                }
            } else {
                for (int i = 0; i < this._cbListeners.length; ++i) {
                    this._cbListeners[i].mouseReleased(mouseEvent);
                }
            }
        }

        @Override
        public void setPopupVisible(boolean bl) {
            ISQLConnection iSQLConnection;
            if (bl && ParentFrame.this._isqlPanel != null && (iSQLConnection = ParentFrame.this._isqlPanel.getConnection()) != null) {
                ParentFrame.this.refreshDatabaseList(iSQLConnection);
            }
            super.setPopupVisible(bl);
        }
    }

    class ISQLAction
    extends AbstractAction {
        int _command;
        String _text;
        String _localizedText;
        String _iconID;
        Icon _icon;

        public ISQLAction(int n, String string, String string2, Icon icon) {
            super(string2, icon);
            this._command = n;
            this._text = string;
            this._localizedText = string2;
            this._icon = icon;
        }

        public ISQLAction(int n, String string, String string2, String string3) {
            super(string2);
            this._command = n;
            this._text = string;
            this._localizedText = string2;
            this._iconID = string3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParentFrame.this.processMenu(this._text, actionEvent);
        }

        String getText() {
            return this._localizedText;
        }

        @Override
        public Object getValue(String string) {
            if (string.equals("SmallIcon")) {
                if (this._icon == null && this._iconID != null) {
                    this._icon = ISQLImages.getToolbarIcon(this._iconID);
                    if (this._icon == null) {
                        this._icon = ISQLImages.getImageIcon(this._iconID);
                    }
                    this._iconID = null;
                }
                return this._icon;
            }
            return super.getValue(string);
        }
    }

    static class DisabledAcceleratorFirer
    implements ActionListener {
        private ISQLAction _action;
        private JMenuItem _item;

        DisabledAcceleratorFirer(JMenuItem jMenuItem, ISQLAction iSQLAction) {
            this._item = jMenuItem;
            this._action = iSQLAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._action.actionPerformed(actionEvent);
        }
    }

    static class ISQLToolbarButton
    extends SybToolBarButton {
        ISQLToolbarButton(Action action) {
            if (action.getValue("SmallIcon") != null) {
                super.putClientProperty((Object)"hideActionText", (Object)Boolean.TRUE);
            }
            super.setHorizontalTextPosition(0);
            super.setVerticalTextPosition(3);
            this.setAction(action);
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean isDefaultCapable() {
            return false;
        }

        public boolean isFocusPainted() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isRequestFocusEnabled() {
            return false;
        }

        protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
            PropertyChangeListener propertyChangeListener = super.createActionPropertyChangeListener(this.getAction());
            return propertyChangeListener;
        }
    }

    static class ToolbarPanel
    extends JPanel {
        ToolbarPanel() {
        }
    }
}

