/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.UTLocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sybase.isql.ASAParser;
import sybase.isql.ASEParser;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLParser;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.Preferences;
import sybase.isql.ResultsProcessor;
import sybase.isql.isql;

class ParserUtils {
    private static Hashtable<String, String> _canonicalEncodingNameTable = null;

    ParserUtils() {
    }

    static void showOptionList(ISQLConnection iSQLConnection) {
        int n = iSQLConnection.getDatabaseType();
        if (n == 3) {
            String string = ISQLResource.getISQLString(ErrorMessages.getName(), "SET_NOT_SUPPORTED_BY_ULTRALITE");
            isql.getIO(iSQLConnection).writeln(string, 2);
            return;
        }
        try {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            iSQLConnection.listOptions(vector, vector2);
            ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
            String string = n == 0 || n == 2 ? iSQLResource.getFormattedString("Options for {0}", iSQLConnection.getUserID()) : iSQLResource.getISQLString("Options");
            String[] stringArray = new String[]{iSQLResource.getISQLString("Option"), iSQLResource.getISQLString("Value")};
            int n2 = vector.size();
            String[][] stringArray2 = new String[n2][2];
            for (int i = 0; i < n2; ++i) {
                stringArray2[i][0] = vector.get(i);
                stringArray2[i][1] = vector2.get(i);
            }
            isql.getIO(iSQLConnection).displayTable(string, stringArray, stringArray2);
        }
        catch (SQLException sQLException) {
            isql.getIO(iSQLConnection).writeln(sQLException.getMessage(), 2);
        }
    }

    static String getCanonicalEncodingName(String string) {
        if (UTLocale.isInstalled()) {
            string = UTLocale.getJavaEncoding((String)string);
        }
        return string;
    }

    static String getDefaultEncoding(ISQLConnection iSQLConnection) {
        String string = Preferences.getStringOption(iSQLConnection, "defaultISQLEncoding");
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        return string;
    }

    static void setDefaultEncoding(ISQLConnection iSQLConnection, String string) {
        Preferences.setStringOption(iSQLConnection, "defaultISQLEncoding", string);
    }

    private static boolean isValidEncoding(String string) {
        boolean bl;
        try {
            new String(new byte[]{65}, string);
            bl = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl = false;
        }
        return bl;
    }

    static String[] getHelpIDs(ISQLConnectionImpl iSQLConnectionImpl, int n, String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        ISQLPlugin iSQLPlugin = iSQLConnectionImpl.getPlugin();
        if (iSQLPlugin != null) {
            String string2 = iSQLPlugin.getHelpIDForError(n);
            if (string2 != null) {
                String string3 = ISQLResource.getFormattedString(ErrorMessages.getName(), "HelpForErrorCode", Integer.toString(n));
                arrayList.add(string2);
                arrayList.add(string3);
            }
            if ((stringArray = iSQLPlugin.getHelpIDForSQL(string)) != null) {
                arrayList.add(stringArray[0]);
                arrayList.add(stringArray[1]);
            }
        }
        stringArray = arrayList.size() == 0 ? null : arrayList.toArray(new String[0]);
        return stringArray;
    }

    static String[] getHelpIDs(ISQLConnectionImpl iSQLConnectionImpl, String string) {
        ISQLPlugin iSQLPlugin = iSQLConnectionImpl.getPlugin();
        String[] stringArray = iSQLPlugin != null ? iSQLPlugin.getHelpIDForSQL(string) : null;
        return stringArray;
    }

    static String stripQuotes(String string) {
        String string2 = string;
        int n = string.length();
        if (n >= 2) {
            char c = string.charAt(0);
            if (c == '\'' || c == '\"') {
                StringBuilder stringBuilder = new StringBuilder(n);
                for (int i = 1; i < n - 1; ++i) {
                    char c2 = string.charAt(i);
                    stringBuilder.append(c2);
                    if (c2 != c) continue;
                    ++i;
                }
                string2 = stringBuilder.toString();
            } else if (c == '[') {
                int n2 = string.indexOf(93, 1);
                if (n2 != -1) {
                    string2 = string.substring(1, n2);
                }
            } else if (c == '`' && string.charAt(n - 1) == '`') {
                string2 = string.substring(1, n - 1);
            }
        }
        return string2;
    }

    static String formatSQL(String string) {
        try {
            int n;
            String string2;
            int n2 = Integer.MAX_VALUE;
            ArrayList<String> arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                n = 0;
                while ((n = string2.indexOf(9, n)) != -1) {
                    string2 = string2.substring(0, n) + "        " + string2.substring(n + 1);
                }
                arrayList.add(string2);
                if (string2.length() < n2) {
                    n2 = string2.length();
                }
                for (n = 0; n < n2; ++n) {
                    if (Character.isWhitespace(string2.charAt(n))) continue;
                    if (n >= n2) break;
                    n2 = n;
                    break;
                }
                if (isql.options.useGUI || arrayList.size() != 5) continue;
                arrayList.add("...");
                break;
            }
            bufferedReader.close();
            if (n2 == Integer.MAX_VALUE) {
                n2 = 0;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < arrayList.size(); ++n) {
                if (n > 0) {
                    stringBuffer.append("\n");
                }
                string2 = ((String)arrayList.get(n)).substring(n2);
                stringBuffer.append(string2);
            }
            arrayList.clear();
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    static ISQLParser getParser(ISQLParser iSQLParser, ISQLConnection iSQLConnection, Reader reader) {
        ISQLParser iSQLParser2;
        int n;
        if (iSQLConnection != null) {
            n = iSQLConnection.getDatabaseType();
            if (n == 2) {
                n = 0;
            }
        } else {
            n = isql.options.getDefaultDatabaseType();
        }
        if (iSQLParser != null && n == iSQLParser.getDatabaseType()) {
            iSQLParser2 = iSQLParser;
            iSQLParser2.ReInit(reader);
        } else {
            switch (n) {
                case 1: {
                    iSQLParser2 = new ASEParser(reader);
                    break;
                }
                default: {
                    iSQLParser2 = new ASAParser(reader);
                }
            }
            iSQLParser2.enableDebuggingOutput();
        }
        return iSQLParser2;
    }

    static String escapeFileName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 16);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String escapeApostrophes(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder.append(c);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static File searchForFileForInput(String string, File file) {
        String string2;
        File file2 = null;
        file2 = new File(string);
        if (file2.isAbsolute() && file2.exists() && file2.isFile()) {
            return file2;
        }
        if (file != null && (string2 = file.getParent()) != null && (file2 = new File(string2, string)).exists() && file2.isFile()) {
            return file2;
        }
        string2 = System.getProperty("user.dir");
        if (string2 != null && string2.length() != 0 && (file2 = ParserUtils.findFileInPath(string, string2)) != null) {
            return file2;
        }
        return file2;
    }

    static File searchForFile(String string, File file) {
        String string2;
        String string3;
        File file2 = null;
        boolean bl = true;
        file2 = new File(string);
        if (file2.isAbsolute() && file2.exists() && file2.isFile()) {
            return file2;
        }
        bl = string.indexOf(".") == -1;
        while (!((file2 = ParserUtils.findFileInPath(string, null)) != null || file != null && (string3 = file.getParent()) != null && (file2 = ParserUtils.findFileInPath(string, string3)) != null || (string2 = System.getProperty("user.dir")) != null && string2.length() != 0 && (file2 = ParserUtils.findFileInPath(string, string2)) != null)) {
            string2 = System.getProperty("sqlpath");
            if (string2 == null) {
                string2 = System.getenv("SQLPATH");
                if (string2 == null) {
                    string2 = "";
                }
                System.setProperty("sqlpath", string2);
            }
            if (string2 != null && string2.length() != 0 && (file2 = ParserUtils.findFileInPath(string, string2)) != null) break;
            string2 = System.getProperty("path");
            if (string2 == null) {
                string2 = System.getenv("PATH");
                if (string2 == null) {
                    string2 = "";
                }
                System.setProperty("path", string2);
            }
            if (string2 != null && string2.length() != 0 && (file2 = ParserUtils.findFileInPath(string, string2)) != null || !bl) break;
            bl = false;
            string = string.concat(".sql");
        }
        return file2;
    }

    private static File findFileInPath(String string, String string2) {
        File file = null;
        if (string2 != null) {
            String string3 = System.getProperty("path.separator");
            String string4 = System.getProperty("file.separator");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.setLength(0);
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append(string4);
                stringBuffer.append(string);
                file = new File(stringBuffer.toString());
                if (!file.exists() || !file.isFile()) {
                    file = null;
                    continue;
                }
                break;
            }
        } else {
            file = new File(string);
            if (!file.exists() || !file.isFile()) {
                file = null;
            }
        }
        return file;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static class PUResultsProcessor
    implements ResultsProcessor {
        PUResultsProcessor() {
        }

        @Override
        public void startProcessingResults(ISQLConnection iSQLConnection) {
        }

        @Override
        public boolean processResultSet(ISQLConnection iSQLConnection, String string, ISQLResultSet iSQLResultSet, boolean bl) throws ResultsProcessor.ResultsProcessorException {
            return true;
        }

        @Override
        public boolean processUpdateCount(ISQLConnection iSQLConnection, String string, int n) {
            return true;
        }

        @Override
        public boolean processAsyncMessages(ISQLConnection iSQLConnection, Vector<String> vector) {
            return true;
        }

        @Override
        public void endProcessingResults(ISQLConnection iSQLConnection) {
        }
    }
}

