/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.central.editor.Parser;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.editor.WsqlParser;
import com.sybase.util.DialogUtils;
import com.sybase.util.ImageLoader;
import com.sybase.util.SybButton;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLPanel;
import sybase.isql.ISQLPlanViewer;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ParentFrame;
import sybase.isql.PluginMgr;
import sybase.isql.Preferences;
import sybase.isql.isql;

class PlanFrame
extends JFrame
implements ActionListener,
DocumentListener,
WindowListener {
    private static final String HELP_KEY_COMMAND = "HelpKey";
    private static final int MIN_FRAME_WIDTH = 600;
    private static final int MIN_FRAME_HEIGHT = 400;
    private static final String SHOW_SQL = "ShowSQL";
    private static final String HIDE_SQL = "HideSQL";
    private static int _highestFrameNumber = 0;
    private static PrinterJob _printerJob = null;
    private static PageFormat _pageFormat = null;
    private static ArrayList<PlanFrame> _frames = new ArrayList();
    private ISQLResource _bundle = ISQLResource.getISQLResource(GeneralResources.getName());
    private int _frameNumber;
    private File _loadedFile = null;
    private ISQLPlugin _plugin;
    private ISQLConnectionImpl _connection;
    private ISQLPlanViewer _isqlPlanViewer = null;
    private JPanel _sqlPanel;
    private SCEditor _sql;
    private SybButton _options = null;
    private SybButton _save;
    private SybButton _open;
    private SybButton _print;
    private SybButton _showSQL;
    private SybButton _hideSQL;
    private SybButton _close;
    private SybButton _help;
    private JPanel _showHidePanel;
    private CardLayout _showHidePanelLayout;

    PlanFrame(ParentFrame parentFrame, ISQLPlugin iSQLPlugin, String string) {
        this._plugin = iSQLPlugin;
        this._connection = (ISQLConnectionImpl)parentFrame.getConnection();
        this.createUI(parentFrame, string);
        if (string != null) {
            this.setBusy(true);
            this._isqlPlanViewer.showPlan(string);
            this.setBusy(false);
        }
    }

    private void setBusy(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this._options != null) {
            this._options.setEnabled(!bl);
            this._open.setEnabled(!bl);
            this._save.setEnabled(this._isqlPlanViewer.hasPlan() && !bl);
            this._print.setEnabled(!bl);
            this._close.setEnabled(!bl);
        }
    }

    private void createUI(ParentFrame parentFrame, String string) {
        Rectangle rectangle;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._sql = new SCEditor(){

            public Dimension getPreferredScrollableViewportSize() {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.height = 5 * fontMetrics.getHeight();
                dimension.width = 500;
                return dimension;
            }
        };
        this._sql.setEditorType((Parser)WsqlParser.getInstance());
        this._sql.setEditable(this._connection.isConnected() && this._connection.getPlugin() == this._plugin);
        JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        this._sqlPanel = new JPanel(new GridBagLayout());
        jScrollPane.setBorder(BorderFactory.createTitledBorder(this._bundle.getISQLString("PLAN_FRAME_SQL_LABEL")));
        this._sqlPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._sqlPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 10, 0), 0, 0));
        jPanel.add((Component)this._sqlPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
        if (string != null) {
            this._sql.setText(string);
        }
        this._isqlPlanViewer = this._plugin.getPlanViewer(this._connection);
        JComponent jComponent = this._isqlPlanViewer.getComponent();
        jPanel.add((Component)jComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 10, 0), 0, 0));
        this._open = new SybButton(this._bundle.getISQLString("PLAN_FRAME_OPEN_BUTTON"));
        this._open.addActionListener((ActionListener)this);
        this._save = new SybButton(this._bundle.getISQLString("PLAN_FRAME_SAVE_BUTTON"));
        this._save.addActionListener((ActionListener)this);
        this._print = new SybButton(this._bundle.getISQLString("PLAN_FRAME_PRINT_BUTTON"));
        this._print.addActionListener((ActionListener)this);
        this._showSQL = new SybButton(this._bundle.getISQLString("PLAN_FRAME_SHOW_SQL_BUTTON"));
        this._showSQL.addActionListener((ActionListener)this);
        this._hideSQL = new SybButton(this._bundle.getISQLString("PLAN_FRAME_HIDE_SQL_BUTTON"));
        this._hideSQL.addActionListener((ActionListener)this);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._showSQL, this._hideSQL});
        this._showHidePanelLayout = new CardLayout();
        this._showHidePanel = new JPanel(this._showHidePanelLayout);
        this._showHidePanel.add((Component)this._showSQL, SHOW_SQL);
        this._showHidePanel.add((Component)this._hideSQL, HIDE_SQL);
        this._showHidePanelLayout.show(this._showHidePanel, HIDE_SQL);
        Dimension dimension = this._showHidePanel.getMinimumSize();
        this._showHidePanel.setMaximumSize(dimension);
        this._close = new SybButton(this._bundle.getISQLString("PLAN_FRAME_CLOSE_BUTTON"));
        this._close.addActionListener((ActionListener)this);
        this._help = new SybButton(this._bundle.getISQLString("PLAN_FRAME_HELP_BUTTON"));
        this._help.addActionListener((ActionListener)this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        if (this._isqlPlanViewer.hasOptionsDialog()) {
            this._options = new SybButton(this._bundle.getISQLString("PLAN_FRAME_OPTIONS_BUTTON"));
            this._options.addActionListener((ActionListener)this);
            jPanel2.add((Component)this._options);
            jPanel2.add(Box.createHorizontalStrut(5));
        }
        jPanel2.add((Component)this._open);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._save);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._print);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this._showHidePanel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._close);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._help);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (!this._isqlPlanViewer.supportsHelp()) {
            this._help.setVisible(false);
        } else {
            this.getRootPane().registerKeyboardAction(this, HELP_KEY_COMMAND, KeyStroke.getKeyStroke(112, 0, false), 1);
        }
        if (!this._isqlPlanViewer.supportsPrinting()) {
            this._print.setVisible(false);
        }
        if (!this._isqlPlanViewer.canOpenPlanFiles()) {
            this._open.setVisible(false);
        }
        if (!this._isqlPlanViewer.canSavePlanFiles()) {
            this._save.setVisible(false);
        }
        if (!Preferences.isSQLVisibleInPlanViewer) {
            this.hideSQL();
        }
        this.getContentPane().add(jPanel);
        this.pack();
        this._frameNumber = ++_highestFrameNumber;
        this.refreshTitle();
        this.setIconImage(parentFrame.getIconImage());
        this.setLocationRelativeTo(parentFrame);
        Rectangle rectangle2 = Preferences.planViewerWindowSize;
        if (rectangle2 != null) {
            rectangle = rectangle2;
        } else {
            rectangle = this.getBounds();
            if (rectangle.width < 600) {
                rectangle.width = 600;
            }
            if (rectangle.height < 400) {
                rectangle.height = 400;
            }
        }
        Dimension dimension2 = this.getPreferredSize();
        if (rectangle.width < dimension2.width) {
            rectangle.width = dimension2.width;
        }
        if (rectangle.height < dimension2.height) {
            rectangle.height = dimension2.height;
        }
        this.setBounds(rectangle);
        UIUtils.ensureWindowIsVisible((Window)this);
        this.setDefaultCloseOperation(0);
        _frames.add(this);
        this._sql.getDocument().addDocumentListener(this);
        this.addWindowListener(this);
        this.setVisible(true);
    }

    private void refreshTitle() {
        String string = this._loadedFile == null ? this._bundle.getFormattedString("PLAN_FRAME_TITLE", Integer.toString(this._frameNumber)) : this._bundle.getFormattedString("PLAN_FRAME_TITLE_WITH_FILENAME", this._loadedFile.getName());
        this.setTitle(string);
    }

    static PlanFrame[] getAllPlanFrames() {
        PlanFrame[] planFrameArray = new PlanFrame[_frames.size()];
        _frames.toArray(planFrameArray);
        return planFrameArray;
    }

    private void showSQL() {
        this._sqlPanel.setVisible(true);
        this._showHidePanelLayout.show(this._showHidePanel, HIDE_SQL);
    }

    private void hideSQL() {
        this._sqlPanel.setVisible(false);
        this._showHidePanelLayout.show(this._showHidePanel, SHOW_SQL);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._open) {
            this.handleOpen();
        } else if (object == this._save) {
            this.handleSaveAs();
        } else if (object == this._print) {
            this._isqlPlanViewer.print();
        } else if (object == this._showSQL) {
            this.showSQL();
            Preferences.isSQLVisibleInPlanViewer = this._sqlPanel.isVisible();
        } else if (object == this._hideSQL) {
            this.hideSQL();
            Preferences.isSQLVisibleInPlanViewer = this._sqlPanel.isVisible();
        } else if (object == this._close) {
            this.handleClose();
        } else if (object == this._help || actionEvent.getActionCommand().equals(HELP_KEY_COMMAND)) {
            this._isqlPlanViewer.showHelp();
        } else if (object == this._options && this._isqlPlanViewer.showOptionsDialog(this)) {
            this.setBusy(true);
            this._isqlPlanViewer.showPlan(this._isqlPlanViewer.getSQL());
            this.setBusy(false);
        }
    }

    private void handleOpen() {
        File file = PlanFrame.promptForPlanFileName(this, 1, this._connection);
        if (file != null) {
            this.loadPlan(file);
        }
    }

    static ISQLPlugin getPluginForPlanViewing(ISQLConnectionImpl iSQLConnectionImpl) {
        ISQLPlugin[] iSQLPluginArray;
        ISQLPlugin iSQLPlugin = null;
        if (iSQLConnectionImpl != null && (iSQLPlugin = iSQLConnectionImpl.getPlugin()) != null && !iSQLPlugin.supportsPlanViewer()) {
            iSQLPlugin = null;
        }
        if (iSQLPlugin == null && (iSQLPluginArray = PluginMgr.getPluginList()).length > 0) {
            for (int i = 0; i < iSQLPluginArray.length && !(iSQLPlugin = iSQLPluginArray[0]).supportsPlanViewer(); ++i) {
                iSQLPlugin = null;
            }
        }
        return iSQLPlugin;
    }

    private static File promptForPlanFileName(Window window, int n, ISQLConnectionImpl iSQLConnectionImpl) {
        File file = null;
        File file2 = null;
        SybFileChooser sybFileChooser = new SybFileChooser(n | 0x10);
        ArrayList<SybFileFilter> arrayList = new ArrayList<SybFileFilter>();
        int n2 = 0;
        ISQLPlugin iSQLPlugin = PlanFrame.getPluginForPlanViewing(iSQLConnectionImpl);
        ISQLPlugin[] iSQLPluginArray = PluginMgr.getPluginList();
        for (int i = 0; i < iSQLPluginArray.length; ++i) {
            if (!iSQLPluginArray[i].supportsPlanViewer()) continue;
            if (iSQLPluginArray[i] == iSQLPlugin) {
                n2 = i;
            }
            String string = iSQLPluginArray[i].getPlanFileExtension();
            SybFileFilter sybFileFilter = new SybFileFilter(string, ISQLResource.getISQLString(GeneralResources.getName(), "PLAN_FILE_DESCRIPTION"), null);
            arrayList.add(sybFileFilter);
        }
        SybFileFilter sybFileFilter = new SybFileFilter("xml", ISQLResource.getISQLString(GeneralResources.getName(), "PLAN_FILE_DESCRIPTION"), null);
        arrayList.add(sybFileFilter);
        arrayList.add(SybFileFilter.getAllFilesFilter());
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[arrayList.size()];
        arrayList.toArray(sybFileFilterArray);
        sybFileChooser.setFilters(sybFileFilterArray, n2);
        file2 = ISQLPanel.getInitialBrowserDirectory(iSQLConnectionImpl, "lastFileOpenFolder", null);
        if (sybFileChooser.showDialog(window, file2, null)) {
            file = sybFileChooser.getSelectedFile();
            Preferences.setStringOption(iSQLConnectionImpl, "lastFileOpenFolder", file.getParent());
        }
        return file;
    }

    boolean loadPlan(File file) {
        boolean bl;
        Object object;
        Object object2;
        Cloneable cloneable;
        int n;
        ISQLPlugin iSQLPlugin = null;
        String string = file.getName().toLowerCase();
        ISQLPlugin[] iSQLPluginArray = PluginMgr.getPluginList();
        for (n = 0; n < iSQLPluginArray.length; ++n) {
            String string2;
            if (!iSQLPluginArray[n].supportsPlanViewer() || !string.endsWith(string2 = iSQLPluginArray[n].getPlanFileExtension().toLowerCase())) continue;
            iSQLPlugin = iSQLPluginArray[n];
            break;
        }
        if (iSQLPlugin == null) {
            int n2 = 0;
            for (n = 0; n < iSQLPluginArray.length; ++n) {
                if (!iSQLPluginArray[n].supportsPlanViewer()) continue;
                ++n2;
                if (iSQLPlugin == null) {
                    iSQLPlugin = iSQLPluginArray[n];
                    continue;
                }
                iSQLPlugin = null;
                break;
            }
            if (iSQLPlugin == null && n2 > 0) {
                cloneable = new ArrayList();
                for (n = 0; n < iSQLPluginArray.length; ++n) {
                    if (!iSQLPluginArray[n].supportsPlanViewer()) continue;
                    ((ArrayList)cloneable).add(iSQLPluginArray[n].getPluginName());
                }
                object2 = new String[((ArrayList)cloneable).size()];
                ((ArrayList)cloneable).toArray((T[])object2);
                object = SybOptionPane.showInputDialog((Component)this, (Object)ISQLResource.getISQLString(GeneralResources.getName(), "PLAN_TYPE_PROMPT"), (String)ISQLResource.getISQLString(GeneralResources.getName(), "PLAN_TYPE_PROMPT_TITLE"), (int)3, (Icon)ImageLoader.getImageIcon(this.getClass(), (String)"question", (int)1003), (Object[])object2, (Object)0);
                if (object != null) {
                    for (n = 0; n < ((Object[])object2).length; ++n) {
                        if (object2[n] != object) continue;
                        iSQLPlugin = iSQLPluginArray[n];
                        break;
                    }
                }
            }
        }
        if (iSQLPlugin == null) {
            isql.getIO(this._connection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not load XML plan.\n{0}", file.getName(), ""), 2);
            return false;
        }
        if (iSQLPlugin != this._plugin) {
            object2 = this._isqlPlanViewer.getComponent();
            object = (JPanel)object2.getParent();
            GridBagLayout gridBagLayout = (GridBagLayout)((Container)object).getLayout();
            cloneable = gridBagLayout.getConstraints((Component)object2);
            ((Container)object).remove((Component)object2);
            this._isqlPlanViewer.destroy();
            this._plugin = iSQLPlugin;
            this._isqlPlanViewer = this._plugin.getPlanViewer(this._connection);
            object2 = this._isqlPlanViewer.getComponent();
            ((Container)object).add((Component)object2, cloneable);
            ((Container)object).validate();
        }
        try {
            bl = this._isqlPlanViewer.loadPlan(file);
            if (bl) {
                String string3 = this._isqlPlanViewer.getSQL();
                if (string3 != null) {
                    this._sql.setText(string3);
                }
                Preferences.getMRUList().addOpenedFile(file);
                this._loadedFile = file;
                this.refreshTitle();
            }
        }
        catch (IOException iOException) {
            isql.getIO(this._connection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not load XML plan.\n{0}", file.getName(), iOException.getLocalizedMessage()), 2);
            bl = false;
        }
        return bl;
    }

    private boolean handleSaveAs() {
        boolean bl = false;
        if (!this._isqlPlanViewer.hasPlan()) {
            return false;
        }
        SybFileChooser sybFileChooser = new SybFileChooser(18);
        String string = this._plugin.getPlanFileExtension();
        SybFileFilter sybFileFilter = new SybFileFilter(string, ISQLResource.getISQLString(GeneralResources.getName(), "PLAN_FILE_DESCRIPTION"), null);
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[]{sybFileFilter, SybFileFilter.getAllFilesFilter()};
        int n = 0;
        sybFileChooser.setFilters(sybFileFilterArray, n);
        sybFileChooser.setDefaultExtension(string);
        File file = ISQLPanel.getInitialBrowserDirectory(this._connection, "lastFileSaveFolder", null);
        if (sybFileChooser.showDialog((Window)this, file, null)) {
            File file2 = sybFileChooser.getSelectedFile();
            Preferences.setStringOption(null, "lastFileSaveFolder", file2.getParent());
            try {
                this._isqlPlanViewer.savePlan(file2);
                this._loadedFile = file2;
                this.refreshTitle();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            bl = true;
        }
        return bl;
    }

    private void handleClose() {
        this.setVisible(false);
        _frames.remove(this);
        Preferences.planViewerWindowSize = this.getBounds();
        if (this._frameNumber == _highestFrameNumber) {
            --_highestFrameNumber;
        }
        this._connection = null;
        this._isqlPlanViewer.destroy();
        this._isqlPlanViewer = null;
        this._sqlPanel = null;
        if (this._options != null) {
            this._options.removeActionListener((ActionListener)this);
            this._options = null;
        }
        this._sql.getDocument().removeDocumentListener(this);
        this._sql = null;
        this._save.removeActionListener((ActionListener)this);
        this._save = null;
        this._open.removeActionListener((ActionListener)this);
        this._open = null;
        this._print.removeActionListener((ActionListener)this);
        this._print = null;
        this._showSQL.removeActionListener((ActionListener)this);
        this._showSQL = null;
        this._hideSQL.removeActionListener((ActionListener)this);
        this._hideSQL = null;
        this._close.removeActionListener((ActionListener)this);
        this._close = null;
        this._help.removeActionListener((ActionListener)this);
        this._help = null;
        this._showHidePanel = null;
        this._showHidePanelLayout = null;
        this.removeWindowListener(this);
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.handleClose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange();
    }

    private void handleDocumentChange() {
        String string = this._sql.getText();
        this._isqlPlanViewer.notifySQLChanged(string);
    }
}

