/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.FileLocator;
import com.sybase.util.Platform;
import com.sybase.util.Profile;
import com.sybase.util.SybClassLoader;
import com.sybase.util.SybOptionPane;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import sybase.isql.ErrorMessages;
import sybase.isql.ISQLHostImpl;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;

class PluginMgr {
    private static ArrayList<Plugin> _pluginList = new ArrayList();
    private static boolean _reportErrors = true;
    private static long _repositoryFileTimestamp = 0L;

    PluginMgr() {
    }

    static void register(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string2 == null || string2.isEmpty()) {
            PluginMgr.reportError(ISQLResource.getISQLString(ErrorMessages.getName(), "CANNOT_REGISTER_PLUGIN_BAD_ID"));
            return;
        }
        if (string3 == null || string3.isEmpty()) {
            PluginMgr.reportError(ISQLResource.getISQLString(ErrorMessages.getName(), "CANNOT_REGISTER_PLUGIN_NO_MAIN_CLASS"));
            return;
        }
        if (string4 == null || string4.isEmpty()) {
            PluginMgr.reportError(ISQLResource.getISQLString(ErrorMessages.getName(), "CANNOT_REGISTER_PLUGIN_BAD_CLASSPATH"));
            return;
        }
        File file = PluginMgr.getRepositoryFile();
        Profile profile = new Profile();
        try {
            profile.open(file.getAbsolutePath());
            profile.removeSection(string2);
            profile.removeSection('\"' + string2 + '\"');
            if (string != null) {
                profile.addValue(string2, "classLoaderName", string);
            }
            profile.addValue(string2, "mainclass", string3);
            profile.addValue(string2, "classpath", string4);
            if (string5 != null) {
                profile.addValue(string2, "path", string5);
            }
            if (string6 != null) {
                String[] stringArray = string6.split(";");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf("=");
                    if (n == -1) continue;
                    String string7 = stringArray[i].substring(0, n);
                    String string8 = stringArray[i].substring(n + 1);
                    profile.addValue(string2, string7, string8);
                }
            }
            profile.save();
        }
        catch (IOException iOException) {
            PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_REGISTER_PLUGIN", iOException.getLocalizedMessage()));
        }
    }

    static void unregister(String string) {
        if (string == null || string.length() == 0) {
            PluginMgr.reportError(ISQLResource.getISQLString(ErrorMessages.getName(), "CANNOT_UNREGISTER_PLUGIN_BAD_ID"));
            return;
        }
        File file = PluginMgr.getRepositoryFile();
        Profile profile = new Profile();
        try {
            profile.open(file.getAbsolutePath());
            profile.removeSection(string);
            profile.removeSection('\"' + string + '\"');
            profile.save();
        }
        catch (IOException iOException) {
            PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_UNREGISTER_PLUGIN", iOException.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unload() {
        int n;
        try {
            Field field = ClassLoader.class.getDeclaredField("nativeLibraries");
            field.setAccessible(true);
            for (n = 0; n < _pluginList.size(); ++n) {
                SybClassLoader sybClassLoader = PluginMgr._pluginList.get((int)n)._classLoader;
                Object object = field.get(sybClassLoader);
                if (object == null || !(object instanceof Vector)) continue;
                Object object2 = object;
                synchronized (object2) {
                    ((Vector)object).clear();
                    continue;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        for (n = 0; n < _pluginList.size(); ++n) {
            _pluginList.get(n).releaseResources();
        }
        _pluginList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean load() {
        boolean bl = true;
        boolean bl2 = true;
        Profile profile = null;
        String string = null;
        File file = PluginMgr.getRepositoryFile();
        long l = file.lastModified();
        if (_pluginList.size() != 0 && _repositoryFileTimestamp == l) {
            return true;
        }
        _repositoryFileTimestamp = l;
        PluginMgr.unload();
        if (file.exists()) {
            profile = new Profile();
            try {
                profile.open(file.getAbsolutePath());
                String[] stringArray = profile.getSections();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        PluginMgr.processProfileSection(profile, stringArray[i]);
                    }
                }
            }
            catch (IOException iOException) {
                if (_pluginList.size() != 0) {
                    string = ISQLResource.getFormattedString(ErrorMessages.getName(), "IO_ERROR_READING_REPOSITORY_FILE", file.getName());
                } else {
                    string = ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_START_WITHOUT_PLUGINS", file.getName());
                    bl = false;
                    bl2 = false;
                }
                PluginMgr.reportError(string);
            }
            finally {
                if (profile != null) {
                    profile.close();
                }
            }
        }
        if (_pluginList.size() == 0) {
            PluginMgr.loadSQLAnywherePlugins();
            if (_pluginList.size() == 0 && bl2) {
                PluginMgr.reportError(ISQLResource.getISQLString(ErrorMessages.getName(), "CANNOT_START_NO_PLUGINS_REGISTERED"));
                bl = false;
            }
        }
        return bl;
    }

    private static void loadSQLAnywherePlugins() {
        _reportErrors = false;
        String string = File.pathSeparator;
        String string2 = "sa11";
        String string3 = "saip11.jar" + string + "jodbc.jar" + string;
        PluginMgr.loadPlugin(string2, "SQLAnywhere", "com.sybase.saisqlplugin.SAISQLPlugin", string3, null, null);
        if (Platform.isWindows() || Platform.isLinux()) {
            PluginMgr.loadPlugin(string2, "UltraLite", "com.sybase.saisqlplugin.ULISQLPlugin", string3, null, null);
        }
        PluginMgr.loadPlugin(string2, "GenericODBC", "com.sybase.saisqlplugin.GenericODBCPlugin", string3, null, null);
        _reportErrors = true;
    }

    static ISQLPlugin[] getPluginList() {
        ISQLPlugin[] iSQLPluginArray = new ISQLPlugin[_pluginList.size()];
        for (int i = 0; i < _pluginList.size(); ++i) {
            iSQLPluginArray[i] = PluginMgr._pluginList.get((int)i)._plugin;
        }
        return iSQLPluginArray;
    }

    static ISQLPlugin getPlugin(String string) {
        ISQLPlugin iSQLPlugin = null;
        for (int i = 0; i < _pluginList.size() && !(iSQLPlugin = PluginMgr._pluginList.get((int)i)._plugin).getPluginID().equals(string); ++i) {
            iSQLPlugin = null;
        }
        return iSQLPlugin;
    }

    static ISQLPlugin getPluginForODBCDriver(String string) {
        ISQLPlugin iSQLPlugin = null;
        for (int i = 0; i < _pluginList.size() && !(iSQLPlugin = PluginMgr._pluginList.get((int)i)._plugin).supportsODBCDriver(string); ++i) {
            iSQLPlugin = null;
        }
        return iSQLPlugin;
    }

    static ISQLPlugin getPluginForODBCDSN(String string) {
        ISQLPlugin iSQLPlugin = null;
        for (int i = 0; i < _pluginList.size() && !(iSQLPlugin = PluginMgr._pluginList.get((int)i)._plugin).supportsODBCDSN(string); ++i) {
            iSQLPlugin = null;
        }
        return iSQLPlugin;
    }

    static ISQLPlugin getPluginForPlanFile(String string) {
        ISQLPlugin iSQLPlugin = null;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            boolean bl = Platform.isWindows();
            for (int i = 0; i < _pluginList.size(); ++i) {
                String string2;
                ISQLPlugin iSQLPlugin2 = PluginMgr._pluginList.get((int)i)._plugin;
                if (!iSQLPlugin2.supportsPlanViewer() || (string2 = iSQLPlugin2.getPlanFileExtension()) == null || string2.isEmpty()) continue;
                if (string2.regionMatches(bl, 0, string, n + 1, string2.length())) {
                    iSQLPlugin = iSQLPlugin2;
                    break;
                }
                if (!string2.equalsIgnoreCase("xml")) continue;
                iSQLPlugin = iSQLPlugin2;
                break;
            }
        }
        return iSQLPlugin;
    }

    private static void processProfileSection(Profile profile, String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Properties properties = null;
        String[] stringArray = profile.getKeys(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string6 = profile.getValue(string, stringArray[i]);
            if (stringArray[i].equalsIgnoreCase("mainclass")) {
                string4 = string6;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("classpath")) {
                string3 = string6;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("path")) {
                string5 = string6;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("classLoaderName")) {
                string2 = string6;
                continue;
            }
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty(stringArray[i], string6);
        }
        PluginMgr.loadPlugin(string2, string, string4, string3, string5, properties);
    }

    private static void loadPlugin(String string, String string2, String string3, String string4, String string5, Properties properties) {
        Plugin plugin;
        int n;
        if (string3 == null || string3.isEmpty() || string4 == null || string4.isEmpty()) {
            PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_LOAD_PLUGIN", string2));
            return;
        }
        boolean bl = false;
        String[] stringArray = string4.split(File.pathSeparator);
        File[] fileArray = new File[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            File file;
            fileArray[n] = new File(stringArray[n]);
            if (!fileArray[n].isAbsolute() && FileLocator.isInstalled() && (file = FileLocator.find((String)fileArray[n].getPath())) != null) {
                fileArray[n] = file;
                bl = true;
            }
            if (fileArray[n].exists() && fileArray[n].isFile()) continue;
            PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_LOAD_PLUGIN_MISSING_FILES", string2, fileArray[n].getName()));
            return;
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < fileArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(File.pathSeparator);
                }
                stringBuilder.append(fileArray[n].getAbsolutePath());
            }
            string4 = stringBuilder.toString();
        }
        if (string5 != null && string5.length() > 0) {
            stringArray = string5.split(File.pathSeparator);
            for (n = 0; n < stringArray.length; ++n) {
                File file = new File(stringArray[n]);
                if (file.exists() && file.isFile()) continue;
                PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_LOAD_PLUGIN_MISSING_DIRS", string2, file.getName()));
                return;
            }
        }
        SybClassLoader sybClassLoader = null;
        if (string != null) {
            for (n = 0; n < _pluginList.size(); ++n) {
                plugin = _pluginList.get(n);
                if (!string.equals(plugin._classLoaderName)) continue;
                sybClassLoader = plugin._classLoader;
                break;
            }
        }
        if (sybClassLoader == null) {
            ClassLoader classLoader = PluginMgr.class.getClassLoader();
            sybClassLoader = new SybClassLoader(classLoader);
            sybClassLoader.addToClasspath(string4);
        }
        try {
            Class clazz = sybClassLoader.loadClass(string3);
            clazz.getConstructor(new Class[0]);
            ISQLPlugin iSQLPlugin = (ISQLPlugin)clazz.newInstance();
            if (iSQLPlugin.setISQLHost(ISQLHostImpl.getISQLHost())) {
                plugin = new Plugin(iSQLPlugin, sybClassLoader, string, properties);
                _pluginList.add(plugin);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_LOAD_PLUGIN_MISSING_COMPONENTS", string2, noClassDefFoundError.getLocalizedMessage()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_LOAD_PLUGIN_MISSING_MAIN_CLASS", string2, classNotFoundException.getLocalizedMessage()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_LOAD_PLUGIN_MISSING_ENTRY_POINT", string2, noSuchMethodException.getLocalizedMessage()));
        }
        catch (Exception exception) {
            PluginMgr.reportError(ISQLResource.getFormattedString(ErrorMessages.getName(), "CANNOT_LOAD_PLUGIN_UNEXPECTED_ERROR", string2, exception.getLocalizedMessage()));
        }
    }

    private static void reportError(String string) {
        int n;
        boolean bl = false;
        String string2 = System.getProperty("sybase.native.executable");
        if (string2 != null && string2.length() > 4 && (n = string2.lastIndexOf(46)) != -1 && string2.regionMatches(true, n + 1, "com", 0, 3)) {
            bl = true;
        }
        if (bl) {
            System.err.println(string);
        } else {
            SybOptionPane.showMessageDialog(null, (Object)string, (String)ISQLResource.getISQLString(ErrorMessages.getName(), "ISQL Error"), (int)0);
        }
    }

    private static File getRepositoryFile() {
        File file;
        String string = System.getProperty("isql.repositoryDirectory");
        if (string != null && !string.isEmpty()) {
            file = new File(string, "dbisql.rep");
        } else {
            File file2 = Platform.getApplicationConfigurationDirectory((String)"DBISQL 11.0.1");
            file = new File(file2, "dbisql.rep");
        }
        return file;
    }

    static int getDatabaseTypeForPlugin(ISQLPlugin iSQLPlugin) {
        String string = iSQLPlugin.getPluginID();
        int n = string.equals("SQLAnywhere") ? 0 : (string.equals("Ultralite") ? 3 : (string.equals("ASE") ? 1 : (string.equals("SybaseIQ") ? 2 : 99)));
        return n;
    }

    static ISQLPlugin getPluginForDatabaseType(int n) {
        ISQLPlugin iSQLPlugin = null;
        if (_pluginList != null) {
            for (int i = 0; i < _pluginList.size(); ++i) {
                iSQLPlugin = PluginMgr._pluginList.get((int)i)._plugin;
                String string = iSQLPlugin.getPluginID();
                if (n == 0 && string.equals("SQLAnywhere") || n == 3 && string.equals("Ultralite") || n == 1 && string.equals("ASE") || n == 2 && string.equals("SybaseIQ")) break;
                iSQLPlugin = null;
            }
        }
        return iSQLPlugin;
    }

    static ISQLPlugin getPluginForConnectionInfo(AbstractConnectionInfo abstractConnectionInfo) {
        ISQLPlugin iSQLPlugin = null;
        if (_pluginList != null) {
            AbstractConnectionInfo abstractConnectionInfo2;
            for (int i = 0; !(i >= _pluginList.size() || (abstractConnectionInfo2 = (iSQLPlugin = PluginMgr._pluginList.get((int)i)._plugin).getConnectionInfo()) != null && abstractConnectionInfo2.getClass().equals(abstractConnectionInfo.getClass())); ++i) {
                iSQLPlugin = null;
            }
        }
        return iSQLPlugin;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    private static class Plugin {
        ISQLPlugin _plugin;
        SybClassLoader _classLoader;
        Properties _installerProperties;
        String _classLoaderName;

        Plugin(ISQLPlugin iSQLPlugin, SybClassLoader sybClassLoader, String string, Properties properties) {
            this._plugin = iSQLPlugin;
            this._classLoader = sybClassLoader;
            this._classLoaderName = string;
            this._installerProperties = properties;
        }

        void releaseResources() {
            this._plugin = null;
            this._classLoader.releaseResources();
            if (this._installerProperties != null) {
                this._installerProperties.clear();
                this._installerProperties = null;
            }
            this._classLoaderName = null;
        }
    }
}

