/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.OEMSupport;
import com.sybase.util.Platform;
import com.sybase.util.UIUtils;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sybase.isql.ErrorMessages;
import sybase.isql.FavoritesList;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLPreference;
import sybase.isql.ISQLResource;
import sybase.isql.InputOutputOptions;
import sybase.isql.MRUList;
import sybase.isql.PluginMgr;
import sybase.isql.isql;

class Preferences {
    static final boolean TEMPORARY = true;
    static final boolean PERMANENT = false;
    static final String LAST_FILE_OPEN_FOLDER = "lastFileOpenFolder";
    static final String LAST_FILE_SAVE_FOLDER = "lastFileSaveFolder";
    static final String LAST_IMPORT_FOLDER = "lastImportFolder";
    static final String LAST_EXPORT_FOLDER = "lastExportFolder";
    static final String WINDOW_POSITION = "windowPosition";
    static final String HISTORY_WINDOW_POSITION = "historyWindowPosition";
    static final String WINDOW_STATE = "windowState";
    static final String DEFAULT_MESSAGES_PANE_HEIGHT = "defaultMessagesPaneHeight";
    static final String JDBC_DRIVER = "defaultJDBCDriver";
    static final String JCONNECT = "jConnect";
    static final String ODBC = "ODBC";
    static final String DEFAULT_JDBC_DRIVER = "ODBC";
    static final String MRU_LIST = "mruList";
    static final String SHOW_SEPARATE_MESSAGES_PANE = "showSeparateMessagesPane";
    static final String MAIN_SPLIT_BAR_POSITION = "mainSplitBarPosition";
    static final String EXPORT_WIZARD_MRU_FILENAME_LIST = "exportWizardMRUFileNameList";
    static final String EXPORT_WIZARD_MRU_DSN_LIST = "exportWizardMRUDSNList";
    static final String EXPORT_WIZARD_MRU_DRIVER_LIST = "exportWizardMRUDriverList";
    static final String IMPORT_WIZARD_MRU_FILENAME_LIST = "importWizardMRUFileNameList";
    static final String IMPORT_WIZARD_MRU_DSN_LIST = "importWizardMRUDSNList";
    static final String IMPORT_WIZARD_MRU_DRIVER_LIST = "importWizardMRUDriverList";
    static final String ISQL_MESSAGES = "messages";
    static final int ISQL_MESSAGES_ASYNC = 1;
    static final int ISQL_MESSAGES_ERRORS = 2;
    static final int DEFAULT_ISQL_MESSAGES = 3;
    static final String DEFAULT_ISQL_ENCODING = "defaultISQLEncoding";
    static final String SET_INITIAL_FOLDER_FOR_FILE_BROWSERS = "setInitialFolderForFileBrowsers";
    static final boolean DEFAULT_SET_INITIAL_FOLDER_FOR_FILE_BROWSERS = true;
    static final String AUTO_CHECKOUT = "autoCheckout";
    static final boolean DEFAULT_AUTO_CHECKOUT = true;
    static final String AUTO_REFETCH = "auto_refetch";
    static final boolean DEFAULT_AUTO_REFETCH = true;
    static final String BELL = "bell";
    static final boolean DEFAULT_BELL = false;
    static final String COMMAND_FILE_ECHO = "echo";
    static final boolean DEFAULT_COMMAND_FILE_ECHO = true;
    static final String IMPORT_FORMAT = "input_format";
    static final String DEFAULT_IMPORT_FORMAT = "ASCII";
    static final String LOG_FILE = "isql_log";
    static final String DEFAULT_LOG_FILE = "";
    static final String COMMAND_FILE_ERROR_ACTION = "on_error";
    static final String DEFAULT_COMMAND_FILE_ERROR_ACTION = "Prompt";
    static final String EXPORT_FORMAT = "output_format";
    static final String DEFAULT_EXPORT_FORMAT = "ASCII";
    static final String OUTPUT_LENGTH = "output_length";
    static final int DEFAULT_OUTPUT_LENGTH = 0;
    static final String OUTPUT_NULLS = "output_nulls";
    static final String DEFAULT_OUTPUT_NULLS = "";
    static final String FIELD_SEPARATOR = "ISQL_field_separator";
    static final String DEFAULT_FIELD_SEPARATOR = ",";
    static final String QUOTE = "ISQL_quote";
    static final String DEFAULT_QUOTE = "'";
    static final String ESCAPE_CHARACTER = "ISQL_escape_character";
    static final String DEFAULT_ESCAPE_CHARACTER = "\\";
    static final String COMMAND_TIMING = "ISQL_command_timing";
    static final boolean DEFAULT_COMMAND_TIMING = true;
    static final String PRINT_RESULT_SET_TO_CONSOLE = "printResultSetToConsole";
    static final int PRINT_RESULT_SET_TO_CONSOLE_LAST = 0;
    static final int PRINT_RESULT_SET_TO_CONSOLE_NONE = 1;
    static final int PRINT_RESULT_SET_TO_CONSOLE_ALL = 2;
    static final int DEFAULT_PRINT_RESULT_SET_TO_CONSOLE = 0;
    static final String UUID_HAS_HYPHENS = "UUID_has_hyphens";
    static final boolean DEFAULT_UUID_HAS_HYPHENS = true;
    private static final String SOURCE_CONTROL_SYSTEM = "sourceControlSystem";
    static final String DEFAULT_SOURCE_CONTROL_SYSTEM = null;
    private static final String SOURCE_CONTROL_USER = "sourceControlUser";
    static final String DEFAULT_SOURCE_CONTROL_USER = null;
    private static final String SOURCE_CONTROL_PROJECT = "sourceControlProject";
    static final String DEFAULT_SOURCE_CONTROL_PROJECT = null;
    private static final String SOURCE_CONTROL_PROJPATH = "sourceControlProjPath";
    static final String DEFAULT_SOURCE_CONTROL_PROJPATH = null;
    private static final String SOURCE_CONTROL_AUXPROJPATH = "sourceControlAuxProjPath";
    static final String DEFAULT_SOURCE_CONTROL_AUXPROJPATH = null;
    static final String EXECUTE_TOOLBAR_BUTTON_SEMANTICS = "executeToolbarButtonSemantics";
    static final String ETBS_ALL = "all";
    static final String ETBS_SELECTION = "selection";
    private static final String DEFAULT_EXECUTE_TOOLBAR_BUTTON_SEMANTICS = "all";
    private static String _executeToolbarButtonSemantics = "all";
    private static final String FAST_LAUNCHER_ENABLED = "fastLauncherEnabled";
    private static final boolean FAST_LAUNCHER_ENABLED_DEFAULT = true;
    private static final String FAST_LAUNCHER_PORT = "fastLauncherPort";
    static final int FAST_LAUNCHER_PORT_DEFAULT = 6267;
    private static final String FAST_LAUNCHER_TIMEOUT = "fastLauncherTimeout";
    static final int FAST_LAUNCHER_TIMEOUT_DEFAULT = 30;
    static boolean fastLauncherEnabled = true;
    static int fastLauncherPort = 6267;
    static int fastLauncherTimeout = 30;
    static final String DISABLE_EXECUTE_ALL = "disableExecuteAll";
    private static boolean _isExecuteAllDisabled = false;
    static final String LOCKED_PREFERENCES = "lockedPreferences";
    static final String ALLOW_PASSWORDS_IN_FAVORITES = "allowPasswordsInFavorites";
    private static boolean _allowPasswordsInFavorites = true;
    static final String ALLOW_READ_CLIENT_FILE = "allowReadClientFile";
    static final String ALLOW_WRITE_CLIENT_FILE = "allowWriteClientFile";
    static final String ACFO_ON = "On";
    static final String ACFO_OFF = "Off";
    static final String ACFO_PROMPT = "Prompt";
    static final String DEFAULT_ALLOW_READ_CLIENT_FILE = "Prompt";
    static final String DEFAULT_ALLOW_WRITE_CLIENT_FILE = "Prompt";
    private static final String FAVORITES = "favorites";
    private static FavoritesList _favorites = null;
    private static final String FAVORITES_WIDTH = "favoritesWidth";
    private static final int DEFAULT_FAVORITES_WIDTH = 150;
    private static int _favoritesWidth = 150;
    private static final String SHOW_FAVORITES = "showFavorites";
    private static final boolean DEFAULT_SHOW_FAVORITES = false;
    private static boolean _showFavorites = false;
    private static Hashtable<String, Properties> _pluginPreferences = new Hashtable();
    private static Hashtable<String, String> _lockedPluginPreferences = new Hashtable();
    private static String IS_SQL_VISIBLE_IN_PLAN_VIEWER = "isSQLVisibleInPlanViewer";
    static boolean isSQLVisibleInPlanViewer = true;
    private static String PLAN_VIEWER_WINDOW_SIZE = "planViewerWindowSize";
    static Rectangle planViewerWindowSize = null;
    private static final MetaData[] _metaData = new MetaData[]{new MetaData(1, "auto_refetch", true), new MetaData(0, "output_format", "ASCII"), new MetaData(0, "input_format", "ASCII"), new MetaData(0, "ISQL_field_separator", ","), new MetaData(0, "ISQL_quote", "'"), new MetaData(0, "ISQL_escape_character", "\\"), new MetaData(1, "echo", true), new MetaData(0, "on_error", "Prompt"), new MetaData(1, "bell", false), new MetaData(1, "ISQL_command_timing", true), new MetaData(0, "output_nulls", ""), new MetaData(2, "output_length", 0), new MetaData(0, "isql_log", ""), new MetaData(130, "messages", 3), new MetaData(129, "UUID_has_hyphens", true), new MetaData(0, "lastFileOpenFolder", null), new MetaData(0, "lastFileSaveFolder", null), new MetaData(0, "lastImportFolder", null), new MetaData(0, "lastExportFolder", null), new MetaData(0, "windowPosition", null), new MetaData(0, "historyWindowPosition", null), new MetaData(2, "windowState", 0), new MetaData(3, "mainSplitBarPosition", null), new MetaData(0, "defaultJDBCDriver", "ODBC"), new MetaData(2, "defaultMessagesPaneHeight", 7), new MetaData(128, "mruList", null), new MetaData(1, "showSeparateMessagesPane", false), new MetaData(128, "defaultISQLEncoding", null), new MetaData(2, "printResultSetToConsole", 0), new MetaData(1, "setInitialFolderForFileBrowsers", true), new MetaData(128, "sourceControlSystem", DEFAULT_SOURCE_CONTROL_SYSTEM), new MetaData(128, "sourceControlUser", DEFAULT_SOURCE_CONTROL_USER), new MetaData(128, "sourceControlProject", DEFAULT_SOURCE_CONTROL_PROJECT), new MetaData(128, "sourceControlProjPath", DEFAULT_SOURCE_CONTROL_PROJPATH), new MetaData(128, "sourceControlAuxProjPath", DEFAULT_SOURCE_CONTROL_AUXPROJPATH), new MetaData(1, "autoCheckout", true), new MetaData(0, "favorites", null), new MetaData(1, "showFavorites", false), new MetaData(0, "favoritesWidth", 150), new MetaData(128, "allowReadClientFile", "Prompt"), new MetaData(128, "allowWriteClientFile", "Prompt")};
    private static WeakHashMap<ISQLConnection, OptionSet> _map = new WeakHashMap();
    private static MRUList _mruList = null;
    private static String _exportWizardMRUFileNameList = null;
    private static String _exportWizardMRUDSNList = null;
    private static String _exportWizardMRUDriverList = null;
    private static String _importWizardMRUFileNameList = null;
    private static String _importWizardMRUDSNList = null;
    private static String _importWizardMRUDriverList = null;
    private static String _sourceControlSystem = null;
    private static String _sourceControlUser = null;
    private static String _sourceControlProject = null;
    private static String _sourceControlProjectPath = null;
    private static String _sourceControlAuxProjectPath = null;

    Preferences() {
    }

    static void load(ISQLConnection iSQLConnection) {
        Preferences.getOptionSetForConnection(iSQLConnection);
    }

    private static OptionSet getOptionSetForConnection(ISQLConnection iSQLConnection) {
        OptionSet optionSet = _map.get(iSQLConnection);
        if (optionSet == null) {
            optionSet = new OptionSet(_metaData);
            _map.put(iSQLConnection, optionSet);
            try {
                optionSet.load();
            }
            catch (IOException iOException) {
                String string = ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not load preferences file. {0}", iOException.getMessage());
                isql.getIO(iSQLConnection).writeln(string, 2);
            }
        }
        return optionSet;
    }

    static void save(ISQLConnection iSQLConnection) {
        OptionSet optionSet = _map.get(iSQLConnection);
        if (optionSet != null) {
            try {
                optionSet.save(iSQLConnection);
            }
            catch (IOException iOException) {
                String string = ISQLResource.getFormattedString(ErrorMessages.getName(), "Could not save preferences file. {0}", iOException.getMessage());
                isql.getIO(iSQLConnection).writeln(string, 2);
            }
            if (iSQLConnection != null) {
                _map.remove(null);
            }
        }
    }

    static void discard(ISQLConnection iSQLConnection) {
        OptionSet optionSet = _map.get(iSQLConnection);
        if (optionSet != null) {
            optionSet.destroy();
        }
    }

    static boolean isFastLauncherChangeAllowed() {
        return !Preferences.isPreferenceLocked(FAST_LAUNCHER_ENABLED);
    }

    static boolean isExecuteAllDisabled() {
        return _isExecuteAllDisabled;
    }

    private static void setPolymorphicOption(ISQLConnection iSQLConnection, String string, Object object, boolean bl) {
        OptionSet optionSet = Preferences.getOptionSetForConnection(iSQLConnection);
        boolean bl2 = Preferences.isKnownOption(string);
        if (!(bl2 && Preferences.isPreferenceLocked(string) || !bl2 && Preferences.isPluginPreferenceLocked((ISQLConnectionImpl)iSQLConnection, string))) {
            optionSet.setOption(string, object, bl);
        }
    }

    static void setStringOption(ISQLConnection iSQLConnection, String string, String string2) {
        Preferences.setPolymorphicOption(iSQLConnection, string, string2, false);
    }

    static void setStringOption(ISQLConnection iSQLConnection, String string, String string2, boolean bl) {
        Preferences.setPolymorphicOption(iSQLConnection, string, string2, bl);
    }

    static String getStringOption(ISQLConnection iSQLConnection, String string) {
        return Preferences.getStringOption(iSQLConnection, string, true);
    }

    static String getStringOption(ISQLConnection iSQLConnection, String string, boolean bl) {
        String string2 = null;
        if (string.equals(COMMAND_FILE_ERROR_ACTION) && isql.options.defaultOnErrorAction != null) {
            return isql.options.defaultOnErrorAction;
        }
        OptionSet optionSet = Preferences.getOptionSetForConnection(iSQLConnection);
        Object object = optionSet.getOption(string, bl);
        if (object != null) {
            if (object instanceof String) {
                string2 = (String)object;
            } else {
                throw new RuntimeException("Tried to get option " + string + " as a string, but " + "data type is " + object.getClass().getName());
            }
        }
        return string2;
    }

    static boolean isKnownOption(String string) {
        boolean bl = false;
        for (int i = 0; i < _metaData.length; ++i) {
            if (!Preferences._metaData[i].name.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static void setPluginPreference(String string, String string2) {
        int n = string.indexOf(".");
        if (n == -1) {
            return;
        }
        String string3 = string.substring(0, n);
        string = string.substring(n + 1);
        Properties properties = _pluginPreferences.get(string3);
        if (properties == null) {
            properties = new Properties();
            _pluginPreferences.put(string3, properties);
        }
        properties.setProperty(string, string2);
    }

    static Properties getPluginPreferences(String string) {
        return _pluginPreferences.get(string);
    }

    static String[] getLockedPluginPreferences(String string) {
        StringTokenizer stringTokenizer;
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = _lockedPluginPreferences.get(string);
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        if ((string2 = _lockedPluginPreferences.get("*")) != null) {
            stringTokenizer = new StringTokenizer(string2, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    static void setFontOption(ISQLConnection iSQLConnection, String string, Font font, boolean bl) {
        Preferences.setStringOption(iSQLConnection, string, Preferences.createFontDescription(font), bl);
    }

    static Font getFontOption(ISQLConnection iSQLConnection, String string, boolean bl) {
        String string2 = Preferences.getStringOption(iSQLConnection, string, bl);
        Font font = Preferences.parseFontDescription(string2);
        return font;
    }

    static Font getFontOption(String string) {
        return Preferences.getFontOption(null, string, true);
    }

    static String createFontDescription(Font font) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(Float.toString(font.getSize2D()));
        stringBuffer.append(';');
        stringBuffer.append(font.getName());
        stringBuffer.append(';');
        stringBuffer.append(Integer.toString(font.getStyle()));
        return stringBuffer.toString();
    }

    static Font parseFontDescription(String string) {
        Font font = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() == 3) {
            try {
                float f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                String string2 = stringTokenizer.nextToken();
                int n = Integer.valueOf(stringTokenizer.nextToken());
                font = new Font(string2, n, (int)f);
                if ((float)((int)f) != f) {
                    font = font.deriveFont(f);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return font;
    }

    static void setIntOption(ISQLConnection iSQLConnection, String string, int n) {
        Preferences.setIntOption(iSQLConnection, string, n, false);
    }

    static void setIntOption(ISQLConnection iSQLConnection, String string, int n, boolean bl) {
        Preferences.setPolymorphicOption(iSQLConnection, string, n, bl);
    }

    static int getIntOption(ISQLConnection iSQLConnection, String string) {
        return Preferences.getIntOption(iSQLConnection, string, true);
    }

    static int getIntOption(ISQLConnection iSQLConnection, String string, boolean bl) {
        Object object = null;
        int n = 0;
        OptionSet optionSet = Preferences.getOptionSetForConnection(iSQLConnection);
        object = optionSet.getOption(string, bl);
        if (object != null) {
            if (object instanceof Integer) {
                n = (Integer)object;
            } else {
                throw new RuntimeException("Tried to get option " + string + " as integer, but " + "data type is " + object.getClass().getName());
            }
        }
        return n;
    }

    static void setDoubleOption(ISQLConnection iSQLConnection, String string, double d) {
        Preferences.setDoubleOption(iSQLConnection, string, d, false);
    }

    static void setDoubleOption(ISQLConnection iSQLConnection, String string, double d, boolean bl) {
        Preferences.setPolymorphicOption(iSQLConnection, string, new Double(d), bl);
    }

    static double getDoubleOption(ISQLConnection iSQLConnection, String string) {
        return Preferences.getDoubleOption(iSQLConnection, string, true);
    }

    static double getDoubleOption(ISQLConnection iSQLConnection, String string, boolean bl) {
        Object object = null;
        double d = 0.0;
        OptionSet optionSet = Preferences.getOptionSetForConnection(iSQLConnection);
        object = optionSet.getOption(string, bl);
        if (object != null) {
            if (object instanceof Double) {
                d = (Double)object;
            } else {
                throw new RuntimeException("Tried to get option " + string + " as double, but " + "data type is " + object.getClass().getName());
            }
        }
        return d;
    }

    static void setBooleanOption(ISQLConnection iSQLConnection, String string, boolean bl) {
        Preferences.setBooleanOption(iSQLConnection, string, bl, false);
    }

    static void setBooleanOption(ISQLConnection iSQLConnection, String string, boolean bl, boolean bl2) {
        Preferences.setPolymorphicOption(iSQLConnection, string, bl, bl2);
    }

    static boolean getBooleanOption(ISQLConnection iSQLConnection, String string) {
        return Preferences.getBooleanOption(iSQLConnection, string, true);
    }

    static boolean getBooleanOption(ISQLConnection iSQLConnection, String string, boolean bl) {
        Object object = null;
        boolean bl2 = false;
        OptionSet optionSet = Preferences.getOptionSetForConnection(iSQLConnection);
        object = optionSet.getOption(string, bl);
        if (object != null) {
            if (object instanceof Boolean) {
                bl2 = (Boolean)object;
            } else {
                throw new RuntimeException("Tried to get option " + string + " as boolean, but " + "data type is " + object.getClass().getName());
            }
        }
        return bl2;
    }

    static int getFileFormatCode(ISQLConnection iSQLConnection, String string) {
        return Preferences.getFileFormatCode(iSQLConnection, string, true);
    }

    static int getFileFormatCode(ISQLConnection iSQLConnection, String string, boolean bl) {
        String string2 = Preferences.getStringOption(iSQLConnection, string, bl);
        return InputOutputOptions.getFormatCode(string2);
    }

    static void setFileFormatCode(ISQLConnection iSQLConnection, String string, int n) {
        String string2 = InputOutputOptions.getFormatName(n);
        Preferences.setStringOption(iSQLConnection, string, string2);
    }

    static MRUList getMRUList() {
        if (_mruList == null) {
            _mruList = new MRUList("");
        }
        return _mruList;
    }

    static String getExportWizardMRUFileNameList() {
        return _exportWizardMRUFileNameList;
    }

    static void setExportWizardMRUFileNameList(String string) {
        _exportWizardMRUFileNameList = string;
    }

    static String getExportWizardMRUDSNList() {
        return _exportWizardMRUDSNList;
    }

    static void setExportWizardMRUDSNList(String string) {
        _exportWizardMRUDSNList = string;
    }

    static String getExportWizardMRUDriverList() {
        return _exportWizardMRUDriverList;
    }

    static void setExportWizardMRUDriverList(String string) {
        _exportWizardMRUDriverList = string;
    }

    static String getImportWizardMRUFileNameList() {
        return _importWizardMRUFileNameList;
    }

    static void setImportWizardMRUFileNameList(String string) {
        _importWizardMRUFileNameList = string;
    }

    static String getImportWizardMRUDSNList() {
        return _importWizardMRUDSNList;
    }

    static void setImportWizardMRUDSNList(String string) {
        _importWizardMRUDSNList = string;
    }

    static String getImportWizardMRUDriverList() {
        return _importWizardMRUDriverList;
    }

    static void setImportWizardMRUDriverList(String string) {
        _importWizardMRUDriverList = string;
    }

    static boolean getAllowPasswordsInFavorites() {
        return _allowPasswordsInFavorites;
    }

    static String getExecuteToolbarButtonSemantics() {
        return _executeToolbarButtonSemantics;
    }

    static void setExecuteToolbarButtonSemantics(String string) {
        if (string.equals("all") || string.equals(ETBS_SELECTION)) {
            _executeToolbarButtonSemantics = string;
        }
    }

    static String getSourceControlSystem() {
        return _sourceControlSystem;
    }

    static void setSourceControlSystem(String string) {
        _sourceControlSystem = string;
    }

    static String getSourceControlUser() {
        return _sourceControlUser;
    }

    static void setSourceControlUser(String string) {
        _sourceControlUser = string;
    }

    static String getSourceControlProject() {
        return _sourceControlProject;
    }

    static void setSourceControlProject(String string) {
        _sourceControlProject = string;
    }

    static String getSourceControlProjectPath() {
        return _sourceControlProjectPath;
    }

    static void setSourceControlProjectPath(String string) {
        _sourceControlProjectPath = string;
    }

    static String getSourceControlAuxProjectPath() {
        return _sourceControlAuxProjectPath;
    }

    static void setSourceControlAuxProjectPath(String string) {
        _sourceControlAuxProjectPath = string;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static Boolean stringToBoolean(String string) {
        boolean bl = string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("TRUE");
        return bl;
    }

    private static Rectangle stringToRectangle(String string) {
        Rectangle rectangle = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() == 4) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            try {
                Rectangle rectangle2 = UIUtils.getWorkArea((int)n, (int)n2);
                n = Math.max(n, rectangle2.x);
                n2 = Math.max(n2, rectangle2.y);
                if (n > rectangle2.x + rectangle2.width) {
                    n = rectangle2.x;
                }
                if (n2 > rectangle2.y + rectangle2.height) {
                    n2 = rectangle2.y;
                }
                n3 = Math.min(n3, rectangle2.width);
                n4 = Math.min(n4, rectangle2.height);
                rectangle = new Rectangle(n, n2, n3, n4);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return rectangle;
    }

    static Rectangle loadWindowSize(ISQLConnection iSQLConnection, String string) {
        String string2 = Preferences.getStringOption(iSQLConnection, string);
        Rectangle rectangle = string2 != null ? Preferences.stringToRectangle(string2) : null;
        return rectangle;
    }

    private static String rectangleToString(Rectangle rectangle) {
        String string = rectangle.x + " " + rectangle.y + " " + rectangle.width + " " + rectangle.height;
        return string;
    }

    static void saveWindowSize(ISQLConnection iSQLConnection, String string, Rectangle rectangle) {
        String string2 = Preferences.rectangleToString(rectangle);
        Preferences.setStringOption(iSQLConnection, string, string2);
    }

    static FavoritesList getFavorites() {
        if (_favorites == null) {
            _favorites = new FavoritesList();
        }
        return _favorites;
    }

    static boolean getShowFavorites() {
        return _showFavorites;
    }

    static void setShowFavorites(boolean bl) {
        _showFavorites = bl;
    }

    static int getFavoritesWidth() {
        return _favoritesWidth;
    }

    static void setFavoritesWidth(int n) {
        _favoritesWidth = n;
    }

    private static String booleanToString(Boolean bl) {
        return bl != false ? ACFO_ON : ACFO_OFF;
    }

    static boolean isPreferenceLocked(String string) {
        String string2;
        boolean bl = false;
        if (_lockedPluginPreferences != null && (string2 = _lockedPluginPreferences.get("*")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static boolean isPluginPreferenceLocked(ISQLConnectionImpl iSQLConnectionImpl, String string) {
        return iSQLConnectionImpl.getPlugin().isPreferenceLocked(iSQLConnectionImpl, string);
    }

    static int getPluginIntPreference(ISQLConnectionImpl iSQLConnectionImpl, String string, String string2) {
        int n = 0;
        String string3 = Preferences.getPluginStringPreference(iSQLConnectionImpl, string, string2);
        try {
            n = Integer.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    static boolean getPluginBooleanPreference(ISQLConnectionImpl iSQLConnectionImpl, String string, String string2) {
        String string3 = Preferences.getPluginStringPreference(iSQLConnectionImpl, string, string2);
        return string3 != null && (string3.equals("1") || string3.equalsIgnoreCase("on"));
    }

    static String getPluginStringPreference(ISQLConnectionImpl iSQLConnectionImpl, String string, String string2) {
        String string3 = null;
        ISQLPlugin[] iSQLPluginArray = PluginMgr.getPluginList();
        for (int i = 0; i < iSQLPluginArray.length; ++i) {
            if (iSQLConnectionImpl != null && iSQLConnectionImpl.getPlugin() != null && iSQLConnectionImpl.getPlugin() != iSQLPluginArray[i]) continue;
            String[] stringArray = iSQLPluginArray[i].getPreferenceValues(iSQLConnectionImpl, string);
            if (stringArray != null && stringArray.length > 0) {
                string3 = stringArray[0];
            }
            if (iSQLConnectionImpl != null) break;
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    static void setPluginStringPreference(ISQLConnectionImpl iSQLConnectionImpl, boolean bl, String string, String string2) {
        iSQLConnectionImpl.getPlugin().setPreferenceValue(iSQLConnectionImpl, bl, string, string2);
    }

    static void setPluginBooleanPreference(ISQLConnectionImpl iSQLConnectionImpl, boolean bl, String string, boolean bl2) {
        iSQLConnectionImpl.getPlugin().setPreferenceValue(iSQLConnectionImpl, bl, string, bl2 ? "1" : "0");
    }

    static void setPluginIntPreference(ISQLConnectionImpl iSQLConnectionImpl, boolean bl, String string, int n) {
        iSQLConnectionImpl.getPlugin().setPreferenceValue(iSQLConnectionImpl, bl, string, Integer.toString(n));
    }

    static class OptionSet {
        private static final String FILENAME = ".isqlPreferences11";
        private MetaData[] _metaData;
        private Object[] _values;
        private Object[] _tempValues;
        private boolean _needsSaving;

        OptionSet(MetaData[] metaDataArray) {
            this._metaData = metaDataArray;
            this._values = new Object[metaDataArray.length];
            this._tempValues = new Object[metaDataArray.length];
            for (int i = 0; i < metaDataArray.length; ++i) {
                this._values[i] = this._metaData[i].defaultValue;
            }
            Arrays.fill(this._tempValues, null);
            this._needsSaving = false;
        }

        void destroy() {
            this._metaData = null;
            Arrays.fill(this._values, null);
            this._values = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void load() throws IOException {
            String string;
            String string2;
            BufferedInputStream bufferedInputStream = null;
            boolean bl = false;
            Properties properties = new Properties();
            File file = new File(OptionSet.getFileName());
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.loadFromXML(bufferedInputStream);
                bufferedInputStream.close();
                if (!properties.isEmpty()) {
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        string2 = enumeration.nextElement().toString();
                        string = properties.getProperty(string2);
                        if (string == null) continue;
                        if (string2.equals(Preferences.MRU_LIST)) {
                            _mruList = new MRUList(string);
                            continue;
                        }
                        if (string2.equals(Preferences.EXPORT_WIZARD_MRU_FILENAME_LIST)) {
                            _exportWizardMRUFileNameList = string;
                            continue;
                        }
                        if (string2.equals(Preferences.EXPORT_WIZARD_MRU_DSN_LIST)) {
                            _exportWizardMRUDSNList = string;
                            continue;
                        }
                        if (string2.equals(Preferences.EXPORT_WIZARD_MRU_DRIVER_LIST)) {
                            _exportWizardMRUDriverList = string;
                            continue;
                        }
                        if (string2.equals(Preferences.IMPORT_WIZARD_MRU_FILENAME_LIST)) {
                            _importWizardMRUFileNameList = string;
                            continue;
                        }
                        if (string2.equals(Preferences.IMPORT_WIZARD_MRU_DSN_LIST)) {
                            _importWizardMRUDSNList = string;
                            continue;
                        }
                        if (string2.equals(Preferences.IMPORT_WIZARD_MRU_DRIVER_LIST)) {
                            _importWizardMRUDriverList = string;
                            continue;
                        }
                        if (string2.equals(Preferences.SOURCE_CONTROL_SYSTEM)) {
                            _sourceControlSystem = string;
                            continue;
                        }
                        if (string2.equals(Preferences.SOURCE_CONTROL_USER)) {
                            _sourceControlUser = string;
                            continue;
                        }
                        if (string2.equals(Preferences.SOURCE_CONTROL_PROJECT)) {
                            _sourceControlProject = string;
                            continue;
                        }
                        if (string2.equals(Preferences.SOURCE_CONTROL_PROJPATH)) {
                            _sourceControlProjectPath = string;
                            continue;
                        }
                        if (string2.equals(Preferences.SOURCE_CONTROL_AUXPROJPATH)) {
                            _sourceControlAuxProjectPath = string;
                            continue;
                        }
                        if (string2.equals(Preferences.EXECUTE_TOOLBAR_BUTTON_SEMANTICS)) {
                            if (!string.equalsIgnoreCase("all") && !string.equalsIgnoreCase(Preferences.ETBS_SELECTION)) continue;
                            _executeToolbarButtonSemantics = string;
                            continue;
                        }
                        if (string2.equals(Preferences.FAVORITES)) {
                            if (_favorites != null) continue;
                            _favorites = new FavoritesList();
                            _favorites.load(string);
                            continue;
                        }
                        if (string2.equals(Preferences.SHOW_FAVORITES)) {
                            _showFavorites = Preferences.stringToBoolean(string);
                            continue;
                        }
                        if (string2.equals(Preferences.FAVORITES_WIDTH)) {
                            try {
                                _favoritesWidth = Integer.decode(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                _favoritesWidth = 150;
                            }
                            continue;
                        }
                        if (string2.equals(IS_SQL_VISIBLE_IN_PLAN_VIEWER)) {
                            isSQLVisibleInPlanViewer = Preferences.stringToBoolean(string);
                            continue;
                        }
                        if (string2.equals(PLAN_VIEWER_WINDOW_SIZE)) {
                            planViewerWindowSize = Preferences.stringToRectangle(string);
                            continue;
                        }
                        if (string2.equals(Preferences.FAST_LAUNCHER_ENABLED)) {
                            fastLauncherEnabled = Preferences.stringToBoolean(string);
                            continue;
                        }
                        if (string2.equals(Preferences.FAST_LAUNCHER_TIMEOUT)) {
                            try {
                                fastLauncherTimeout = Integer.decode(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                fastLauncherTimeout = 30;
                            }
                            continue;
                        }
                        if (string2.equals(Preferences.FAST_LAUNCHER_PORT)) {
                            try {
                                fastLauncherPort = Integer.decode(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                fastLauncherPort = 6267;
                            }
                            continue;
                        }
                        if (Preferences.isKnownOption(string2)) {
                            this.setOption(string2, string, false);
                            continue;
                        }
                        Preferences.setPluginPreference(string2, string);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
                bl = true;
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Properties properties2 = OEMSupport.getOEMSupport().getApplicationProperties("dbisql");
            if (properties2 != null) {
                Enumeration<?> enumeration = properties2.propertyNames();
                String string3 = ".lockedPreferences";
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    if (string2.equalsIgnoreCase(Preferences.ALLOW_PASSWORDS_IN_FAVORITES)) {
                        string = properties2.getProperty(string2);
                        _allowPasswordsInFavorites = Preferences.stringToBoolean(string);
                    }
                    if (string2.equalsIgnoreCase(Preferences.LOCKED_PREFERENCES)) {
                        string = properties2.getProperty(string2);
                        if (string == null || string.isEmpty()) continue;
                        _lockedPluginPreferences.put("*", string);
                        continue;
                    }
                    string3 = ".lockedPreferences";
                    if (string2.length() > string3.length() && string2.regionMatches(true, string2.length() - string3.length(), string3, 0, string3.length())) {
                        string = properties2.getProperty(string2);
                        if (string == null || string.isEmpty()) continue;
                        String string4 = string2.substring(0, string2.length() - string3.length());
                        _lockedPluginPreferences.put(string4, string);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(Preferences.DISABLE_EXECUTE_ALL)) {
                        string = properties2.getProperty(string2);
                        if (string == null || string.isEmpty()) continue;
                        _isExecuteAllDisabled = Preferences.stringToBoolean(string);
                        continue;
                    }
                    string3 = ".disableExecuteAll";
                    if (string2.length() <= string3.length() || !string2.regionMatches(true, string2.length() - string3.length(), string3, 0, string3.length()) || (string = properties2.getProperty(string2)) == null || string.isEmpty()) continue;
                    _isExecuteAllDisabled = Preferences.stringToBoolean(string);
                }
            }
            if (bl) {
                file.delete();
            }
        }

        Object getOption(String string, boolean bl) {
            Object object = null;
            for (int i = 0; i < this._metaData.length; ++i) {
                if (!this._metaData[i].name.equalsIgnoreCase(string)) continue;
                if (bl && this._tempValues[i] != null) {
                    object = this._tempValues[i];
                    break;
                }
                object = this._values[i];
                break;
            }
            return object;
        }

        void setOption(String string, Object object, boolean bl) {
            Object object2 = null;
            for (int i = 0; i < this._metaData.length; ++i) {
                if (!this._metaData[i].name.equalsIgnoreCase(string)) continue;
                switch (this._metaData[i].type) {
                    case 0: {
                        object2 = (String)object;
                        break;
                    }
                    case 1: {
                        if (object instanceof Boolean) {
                            object2 = object;
                            break;
                        }
                        if (!(object instanceof String)) break;
                        object2 = Preferences.stringToBoolean((String)object);
                        break;
                    }
                    case 2: {
                        try {
                            if (object instanceof Integer) {
                                object2 = object;
                                break;
                            }
                            if (!(object instanceof String)) break;
                            object2 = Integer.valueOf((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case 3: {
                        try {
                            if (object instanceof Double) {
                                object2 = object;
                                break;
                            }
                            object2 = Double.valueOf((String)object);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (object2 == null) break;
                if (bl) {
                    this._tempValues[i] = object2;
                    break;
                }
                this._values[i] = object2;
                this._tempValues[i] = null;
                this._needsSaving = true;
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(ISQLConnection iSQLConnection) throws IOException {
            int n;
            FilterOutputStream filterOutputStream = null;
            assert (iSQLConnection != null);
            if (!this._needsSaving) {
                return;
            }
            Properties properties = new Properties();
            for (n = 0; n < this._values.length; ++n) {
                if (this._values[n] == null || !this._metaData[n].persistent) continue;
                properties.put(this._metaData[n].name, this._values[n].toString());
            }
            if (_mruList != null) {
                properties.put(Preferences.MRU_LIST, _mruList.toString());
            }
            if (_exportWizardMRUFileNameList != null) {
                properties.put(Preferences.EXPORT_WIZARD_MRU_FILENAME_LIST, _exportWizardMRUFileNameList);
            }
            if (_exportWizardMRUDSNList != null) {
                properties.put(Preferences.EXPORT_WIZARD_MRU_DSN_LIST, _exportWizardMRUDSNList);
            }
            if (_exportWizardMRUDriverList != null) {
                properties.put(Preferences.EXPORT_WIZARD_MRU_DRIVER_LIST, _exportWizardMRUDriverList);
            }
            if (_importWizardMRUFileNameList != null) {
                properties.put(Preferences.IMPORT_WIZARD_MRU_FILENAME_LIST, _importWizardMRUFileNameList);
            }
            if (_importWizardMRUDSNList != null) {
                properties.put(Preferences.IMPORT_WIZARD_MRU_DSN_LIST, _importWizardMRUDSNList);
            }
            if (_importWizardMRUDriverList != null) {
                properties.put(Preferences.IMPORT_WIZARD_MRU_DRIVER_LIST, _importWizardMRUDriverList);
            }
            if (_sourceControlSystem != null) {
                properties.put(Preferences.SOURCE_CONTROL_SYSTEM, _sourceControlSystem);
            }
            if (_sourceControlUser != null) {
                properties.put(Preferences.SOURCE_CONTROL_USER, _sourceControlUser);
            }
            if (_sourceControlProject != null) {
                properties.put(Preferences.SOURCE_CONTROL_PROJECT, _sourceControlProject);
            }
            if (_sourceControlProjectPath != null) {
                properties.put(Preferences.SOURCE_CONTROL_PROJPATH, _sourceControlProjectPath);
            }
            if (_sourceControlAuxProjectPath != null) {
                properties.put(Preferences.SOURCE_CONTROL_AUXPROJPATH, _sourceControlAuxProjectPath);
            }
            properties.put(Preferences.EXECUTE_TOOLBAR_BUTTON_SEMANTICS, _executeToolbarButtonSemantics);
            if (_favorites != null) {
                properties.put(Preferences.FAVORITES, _favorites.save());
                properties.put(Preferences.FAVORITES_WIDTH, Integer.toString(_favoritesWidth));
                properties.put(Preferences.SHOW_FAVORITES, Preferences.booleanToString(_showFavorites));
            }
            properties.put(IS_SQL_VISIBLE_IN_PLAN_VIEWER, Preferences.booleanToString(isSQLVisibleInPlanViewer));
            if (planViewerWindowSize != null) {
                properties.put(PLAN_VIEWER_WINDOW_SIZE, Preferences.rectangleToString(planViewerWindowSize));
            }
            properties.put(Preferences.FAST_LAUNCHER_ENABLED, Preferences.booleanToString(fastLauncherEnabled));
            properties.put(Preferences.FAST_LAUNCHER_PORT, Integer.toString(fastLauncherPort));
            properties.put(Preferences.FAST_LAUNCHER_TIMEOUT, Integer.toString(fastLauncherTimeout));
            ISQLPlugin[] iSQLPluginArray = PluginMgr.getPluginList();
            for (n = 0; n < iSQLPluginArray.length; ++n) {
                ISQLPreference[] iSQLPreferenceArray = iSQLPluginArray[n] == ((ISQLConnectionImpl)iSQLConnection).getPlugin() ? iSQLPluginArray[n].getPreferences(iSQLConnection) : iSQLPluginArray[n].getPreferences(null);
                if (iSQLPreferenceArray == null || iSQLPreferenceArray.length == 0) continue;
                String string = iSQLPluginArray[n].getPluginID();
                for (int i = 0; i < iSQLPreferenceArray.length; ++i) {
                    String string2 = iSQLPreferenceArray[i].getValue();
                    if (string2 == null) continue;
                    properties.setProperty(string + "." + iSQLPreferenceArray[i].getName(), string2.toString());
                }
            }
            try {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(OptionSet.getFileName()));
                properties.storeToXML(filterOutputStream, null);
                this._needsSaving = false;
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private static String getFileName() {
            return OptionSet.getQualifiedFileName(FILENAME);
        }

        private static String getQualifiedFileName(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Platform.getUserConfigurationDirectory());
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
    }

    static class MetaData {
        static final int STRING = 0;
        static final int BOOLEAN = 1;
        static final int INT = 2;
        static final int DOUBLE = 3;
        static final int TYPE_MASK = 15;
        static final int TRANSIENT = 128;
        static final int GLOBAL = 128;
        String name;
        int type;
        Object defaultValue;
        boolean persistent = true;

        MetaData(int n, String string, Object object) {
            this.name = string;
            this.type = n & 0xF;
            this.persistent = (n & 0x80) == 0;
            this.defaultValue = object;
        }
    }
}

