/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Vector;
import sybase.isql.ColumnInfo;
import sybase.isql.ISQLConnection;
import sybase.isql.InputStatementWizard;
import sybase.isql.Preview;
import sybase.isql.TableGenitor;
import sybase.isql.TableInfo;

class PreviewConnection
implements InvocationHandler {
    private String[] _columnNames = null;
    private ISQLConnection _connection;
    private boolean _getTableInfoFromWizard;
    Vector[] rowData = null;

    static ISQLConnection newInstance(ISQLConnection iSQLConnection, boolean bl) {
        Object object = Proxy.newProxyInstance(iSQLConnection.getClass().getClassLoader(), new Class[]{Preview.class, ISQLConnection.class}, (InvocationHandler)new PreviewConnection(iSQLConnection, bl));
        return (ISQLConnection)object;
    }

    private PreviewConnection(ISQLConnection iSQLConnection, boolean bl) {
        this._connection = iSQLConnection;
        this._getTableInfoFromWizard = bl;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        Object object2 = null;
        String string = method.getName();
        if (string.equals("tableExists")) {
            assert (objectArray.length == 3);
            boolean bl = this.tableExists((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
            object2 = bl;
        } else if (!string.equals("createTable")) {
            if (string.equals("addTableData")) {
                assert (objectArray.length == 4);
                String string2 = (String)objectArray[0];
                String string3 = (String)objectArray[1];
                String string4 = (String)objectArray[2];
                TableGenitor tableGenitor = (TableGenitor)objectArray[3];
                boolean bl = this.addTableData(string2, string3, string4, tableGenitor);
                object2 = bl;
            } else if (string.equals("getColumnNames")) {
                assert (objectArray.length == 3);
                object2 = this.getColumnNames((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
            } else if (string.equals("getTableInfo")) {
                assert (objectArray.length == 3);
                object2 = this.getTableInfo((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
            } else {
                try {
                    object2 = method.invoke((Object)this._connection, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return object2;
    }

    private boolean tableExists(String string, String string2, String string3) {
        boolean bl = this._getTableInfoFromWizard ? true : this._connection.tableExists(string, string2, string3);
        return bl;
    }

    private boolean addTableData(String string, String string2, String string3, TableGenitor tableGenitor) {
        int n;
        int n2 = tableGenitor.getColumnCount();
        this._columnNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            this._columnNames[n] = tableGenitor.getColumnName(n);
        }
        this.rowData = new Vector[6];
        for (n = 0; n < 6 && tableGenitor.moveNext(); ++n) {
            try {
                this.rowData[n] = tableGenitor.getRowData();
                continue;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return true;
    }

    private String[] getColumnNames(String string, String string2, String string3) {
        String[] stringArray;
        if (this._getTableInfoFromWizard) {
            stringArray = InputStatementWizard.TheWizard.getColumnNames();
        } else {
            try {
                stringArray = this._connection.getColumnNames(string, string2, string3);
            }
            catch (SQLException sQLException) {
                stringArray = new String[]{};
            }
        }
        return stringArray;
    }

    private TableInfo getTableInfo(String string, String string2, String string3) {
        TableInfo tableInfo = null;
        if (this._getTableInfoFromWizard) {
            String[] stringArray = InputStatementWizard.TheWizard.getColumnNames();
            int[] nArray = InputStatementWizard.TheWizard.getColumnWidths();
            int n = InputStatementWizard.TheWizard.getColumnCount();
            tableInfo = new TableInfo();
            tableInfo.column = new ColumnInfo[n];
            for (int i = 0; i < n; ++i) {
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.ordinal = i;
                columnInfo.name = stringArray[i];
                columnInfo.type = InputStatementWizard.TheWizard.getColumnTypeMetaData(i);
                columnInfo.width = nArray[i];
                columnInfo.nullable = true;
                tableInfo.column[i] = columnInfo;
            }
        } else {
            tableInfo = this._connection.getTableInfo(string, string2, string3);
        }
        return tableInfo;
    }

    int getColumnCount() {
        int n = this._getTableInfoFromWizard ? InputStatementWizard.TheWizard.getColumnCount() : (this._columnNames != null ? this._columnNames.length : 0);
        return n;
    }
}

