/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.central.editor.SCEditor;
import com.sybase.util.FontHelper;
import com.sybase.util.JREUtils;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLResource;
import sybase.isql.ImporterFailedException;
import sybase.isql.ImporterPreviewer;
import sybase.isql.InputOutputOptions;
import sybase.isql.Preferences;
import sybase.isql.PreviewConnection;
import sybase.isql.PreviewTableModel;

class PreviewTable
extends JTable {
    private PreviewTableModel _tableModel;
    private ISQLConnection _connection;

    PreviewTable(ISQLConnection iSQLConnection) {
        this._connection = iSQLConnection;
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        String string = Preferences.getPluginStringPreference((ISQLConnectionImpl)iSQLConnection, "resultSetFont", "(SYSTEM)");
        if (string.equals("(EDITOR)")) {
            SCEditor sCEditor = new SCEditor();
            this.setFont(sCEditor.getFont());
        } else if (string.equals("(SYSTEM)")) {
            this.setDefaultRenderer(Object.class, FontHelper.getTableCellRenderer());
        } else {
            Font font = Preferences.parseFontDescription(string);
            if (font != null) {
                this.setFont(font);
            }
        }
        Object[] objectArray = new Object[6];
        Arrays.fill(objectArray, " ");
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 6);
        this.setModel(defaultTableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(InputOutputOptions inputOutputOptions, boolean bl) {
        ISQLConnection iSQLConnection = PreviewConnection.newInstance(this._connection, bl);
        ImporterPreviewer importerPreviewer = inputOutputOptions.getImporterPreviewer();
        if (importerPreviewer != null) {
            try {
                importerPreviewer.readPreviewData(iSQLConnection);
            }
            catch (ImporterFailedException importerFailedException) {
                SybOptionPane.showMessageDialog((Component)this, (Object)ISQLResource.getFormattedString(GeneralResources.getName(), "IW_PREVIEW_COULD_NOT_BE_CREATED", importerFailedException.getLocalizedMessage()), (String)ISQLResource.getISQLString(GeneralResources.getName(), "Import Wizard"), (int)0);
            }
            finally {
                importerPreviewer = null;
            }
        }
        this._tableModel = new PreviewTableModel(iSQLConnection);
        this.setModel(this._tableModel);
        this.createDefaultColumnsFromModel();
        this.setInitialColumnWidths();
    }

    private void setInitialColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.getColumnCount();
        int n2 = Math.min(this.getRowCount(), 10);
        for (int i = 0; i < n; ++i) {
            int n3;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (this.getTableHeader() != null) {
                tableCellRenderer = JREUtils.getTableCellRenderer((JTable)this, (int)i);
                n3 = tableCellRenderer.getTableCellRendererComponent(null, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
            } else {
                n3 = 0;
            }
            Class<?> clazz = this.getColumnClass(i);
            tableCellRenderer = this.getDefaultRenderer(clazz);
            for (int j = 0; j < n2; ++j) {
                int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)j, (int)i), (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n3 = Math.max(n3, n4);
            }
            tableColumn.setPreferredWidth(n3 + 6);
        }
        this.sizeColumnsToFit(-1);
    }
}

