/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.central.editor.SCEditor;
import com.sybase.util.DialogUtils;
import com.sybase.util.ImageUtils;
import com.sybase.util.PrintJobListener;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PrinterException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLResource;

class PrintingDialog
extends JDialog
implements PrintJobListener,
ActionListener,
Runnable,
WindowListener {
    private SCEditor _editor;
    private SybLabel _status;
    private SybButton _cancel;
    private boolean _isPrinting = false;
    private int _currentPage;

    static void create(Frame frame, String string, SCEditor sCEditor) {
        PrintingDialog printingDialog = new PrintingDialog(frame, string, sCEditor);
        sCEditor.print(string, (PrintJobListener)printingDialog);
    }

    private PrintingDialog(Frame frame, String string, SCEditor sCEditor) {
        super((Window)frame, string, Dialog.ModalityType.DOCUMENT_MODAL);
        this._editor = sCEditor;
        this.createUI(frame);
    }

    private void createUI(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this._status = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "PrintingStarting"), (Icon)new ImageIcon(ImageUtils.loadImage((Object)this, (String)"printing.gif")), 2);
        Dimension dimension = this._status.getPreferredSize();
        if (dimension.width < 300) {
            dimension.width = 300;
            this._status.setPreferredSize(dimension);
        }
        jPanel.add((Component)this._status);
        jPanel.add(Box.createVerticalStrut(10));
        this._cancel = new SybButton(ISQLResource.getISQLString(GeneralResources.getName(), "PrintingCancel"));
        this._cancel.addActionListener((ActionListener)this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._cancel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.addWindowListener(this);
        this.pack();
        this.setLocationRelativeTo(component);
        this.setResizable(false);
    }

    private void destroy() {
        this.removeWindowListener(this);
        if (this._cancel != null) {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
        }
        this._editor = null;
        this._status = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._cancel) {
            this.handleCancel();
        }
    }

    private void handleCancel() {
        this._editor.cancelPrint();
        this.setVisible(false);
        this.destroy();
    }

    public void printingStarted() {
    }

    public void printingStopped() {
        this._isPrinting = false;
        SwingUtilities.invokeLater(this);
    }

    public void printingPage(int n) {
        this._isPrinting = true;
        this._currentPage = n;
        SwingUtilities.invokeLater(this);
    }

    public void printerException(PrinterException printerException) {
    }

    @Override
    public void run() {
        if (this._isPrinting) {
            if (!this.isVisible()) {
                UIUtils.ensureWindowIsVisible((Window)this);
                this.setVisible(true);
            }
            if (this._status != null) {
                this._status.setText(ISQLResource.getFormattedString(GeneralResources.getName(), "PrintingStatus", Integer.toString(this._currentPage)));
            }
        } else {
            this.setVisible(false);
            this.destroy();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this._isPrinting) {
            this.handleCancel();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

