/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLResource;
import sybase.isql.OwnerAndName;
import sybase.isql.ProcedureBrowserResources;

class ProcedureBrowser
extends JDialog
implements ActionListener,
DocumentListener,
MouseListener {
    private static final int FIELD_WIDTH = 10;
    private static final int VERT_SPACING = 8;
    private static final int MAJOR_VERT_SPACING = 16;
    private static final int HORIZ_SPACING = 5;
    private static final int HORIZ_INDENT = 16;
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String F1_KEY = "F1_KEY";
    private static final int TIMER_DELAY = 800;
    private JTextField _pattern = null;
    private JList _list = null;
    private SybCheckBox _showOwnerNamesBox = null;
    private SybCheckBox _showSystemObjectsBox = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _help = null;
    private Timer _timer = null;
    private JComboBox _dbComboBox = null;
    private static boolean _initialShowOwnerNames = false;
    private static boolean _initialShowSystemObjects = false;
    private ISQLConnection _connection = null;
    private String _procName = null;
    private boolean _refreshInProgress = false;

    static String create(JFrame jFrame, ISQLConnection iSQLConnection) {
        ProcedureBrowser procedureBrowser = new ProcedureBrowser(jFrame, iSQLConnection);
        procedureBrowser.setVisible(true);
        procedureBrowser.destroyUI();
        return procedureBrowser._procName;
    }

    static String create(JDialog jDialog, ISQLConnection iSQLConnection) {
        ProcedureBrowser procedureBrowser = new ProcedureBrowser(jDialog, iSQLConnection);
        procedureBrowser.setVisible(true);
        procedureBrowser.destroyUI();
        return procedureBrowser._procName;
    }

    private ProcedureBrowser(JFrame jFrame, ISQLConnection iSQLConnection) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        this._connection = iSQLConnection;
        this.createUI(jFrame);
    }

    private ProcedureBrowser(JDialog jDialog, ISQLConnection iSQLConnection) {
        super((Window)jDialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this._connection = iSQLConnection;
        this.createUI(jDialog);
    }

    private void createUI(Window window) {
        Object object;
        Serializable serializable;
        Object object2;
        this._timer = new Timer(800, this);
        this._timer.setRepeats(false);
        ISQLResource iSQLResource = ISQLResource.getISQLResource(ProcedureBrowserResources.getName());
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        int n = 0;
        SybLabel sybLabel = new SybLabel(iSQLResource.getISQLString("1."));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        jPanel.add((Component)sybLabel);
        sybLabel = new SybLabel(iSQLResource.getISQLString("Type the first few characters of the procedure you're looking for"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        jPanel.add((Component)sybLabel);
        this._pattern = new JTextField();
        this._pattern.getDocument().addDocumentListener(this);
        sybLabel.setLabelFor((Component)this._pattern);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(this._pattern, gridBagConstraints);
        jPanel.add(this._pattern);
        sybLabel = new SybLabel(iSQLResource.getISQLString("2."));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(16, 0, 0, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        jPanel.add((Component)sybLabel);
        sybLabel = new SybLabel(iSQLResource.getISQLString("Click the procedure you want, then click OK"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        jPanel.add((Component)sybLabel);
        if (this._connection.getDatabaseType() == 1) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            this._dbComboBox = new JComboBox();
            jPanel.add((Component)this._dbComboBox, gridBagConstraints);
            object2 = this._connection.getCatalog();
            serializable = this._connection.getDatabaseNames();
            object = ((ArrayList)serializable).iterator();
            while (object.hasNext()) {
                this._dbComboBox.addItem(object.next());
            }
            this._dbComboBox.setSelectedItem(object2);
            this._dbComboBox.addActionListener(this);
            ++n;
        }
        this._list = new JList();
        this._list.setCellRenderer(FontHelper.getListCellRenderer());
        this._list.setSelectionMode(0);
        this._list.addMouseListener(this);
        sybLabel.setLabelFor((Component)this._list);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        this._showOwnerNamesBox = new SybCheckBox(iSQLResource.getISQLString("ShowOwnerNames"));
        this._showOwnerNamesBox.setSelected(_initialShowOwnerNames);
        this._showOwnerNamesBox.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)this._showOwnerNamesBox, gridBagConstraints);
        if (this._connection.getDatabaseType() == 0 || this._connection.getDatabaseType() == 2) {
            this._showSystemObjectsBox = new SybCheckBox(iSQLResource.getISQLString("ShowSystemObjects"));
            this._showSystemObjectsBox.setSelected(_initialShowSystemObjects);
            this._showSystemObjectsBox.addActionListener((ActionListener)this);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            jPanel.add((Component)this._showSystemObjectsBox, gridBagConstraints);
        }
        ++n;
        object2 = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
        jPanel.add((Component)object2);
        this._ok = new SybButton(iSQLResource.getISQLString("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._cancel = new SybButton(iSQLResource.getISQLString("Cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this._help = new SybButton(iSQLResource.getISQLString("Help"));
        this._help.addActionListener((ActionListener)this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._ok);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add((Component)this._cancel);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add((Component)this._help);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JButton[]{this._ok, this._cancel, this._help});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        Container container = this.getContentPane();
        container.add(jPanel);
        this._pattern.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        this.getRootPane().registerKeyboardAction(this, F1_KEY, KeyStroke.getKeyStroke(112, 0, true), 2);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        String string = "ScrollUp";
        String string2 = "ScrollDown";
        serializable = this._pattern.getInputMap(0);
        ((InputMap)serializable).put(KeyStroke.getKeyStroke(38, 0, false), string);
        ((InputMap)serializable).put(KeyStroke.getKeyStroke(40, 0, false), string2);
        object = this._pattern.getActionMap();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ProcedureBrowser.this._list.getSelectedIndex();
                if (--n < 0) {
                    n = 0;
                }
                ProcedureBrowser.this._list.setSelectedIndex(n);
                ProcedureBrowser.this._list.ensureIndexIsVisible(n);
            }
        };
        ((ActionMap)object).put(string, abstractAction);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ProcedureBrowser.this._list.getSelectedIndex();
                int n2 = ProcedureBrowser.this._list.getModel().getSize();
                if (++n == n2) {
                    n = n2 - 1;
                }
                ProcedureBrowser.this._list.setSelectedIndex(n);
                ProcedureBrowser.this._list.ensureIndexIsVisible(n);
            }
        };
        ((ActionMap)object).put(string2, abstractAction);
        this.setTitle(iSQLResource.getISQLString("Lookup Procedure Name"));
        this.refreshList();
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width = Math.max(dimension.width, 300);
        jPanel.setPreferredSize(dimension);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(window);
        UIUtils.ensureWindowIsVisible((Window)this);
    }

    private void destroyUI() {
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
        this._timer.removeActionListener(this);
        this._timer = null;
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, true));
        this.getRootPane().setDefaultButton(null);
        this._showOwnerNamesBox.removeActionListener((ActionListener)this);
        this._showOwnerNamesBox = null;
        if (this._showSystemObjectsBox != null) {
            this._showSystemObjectsBox.removeActionListener((ActionListener)this);
            this._showSystemObjectsBox = null;
        }
        this._pattern.getDocument().removeDocumentListener(this);
        this._pattern = null;
        this._ok.removeActionListener((ActionListener)this);
        this._ok = null;
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._help.removeActionListener((ActionListener)this);
        this._help = null;
        if (this._dbComboBox != null) {
            this._dbComboBox.removeActionListener(this);
            this._dbComboBox = null;
        }
        this._list.removeMouseListener(this);
        this._list = null;
        this._connection = null;
        DialogUtils.removeComponents((Container)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        if (this._refreshInProgress) {
            this._timer.restart();
            return;
        }
        try {
            this._refreshInProgress = true;
            this.refreshList2();
        }
        finally {
            this._refreshInProgress = false;
        }
    }

    private void refreshList2() {
        int n;
        OwnerAndName ownerAndName = null;
        Component component = this.getFocusOwner();
        ownerAndName = (OwnerAndName)this._list.getSelectedValue();
        String string = this._pattern.getText();
        if (string.indexOf(37) == -1) {
            string = string + "%";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = this._dbComboBox != null ? this._dbComboBox.getSelectedItem().toString() : null;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._connection.listProcedures(string2, null, string, arrayList2, arrayList);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this._showSystemObjectsBox != null && !this._showSystemObjectsBox.isSelected()) {
            for (n = arrayList2.size() - 1; n >= 0; --n) {
                String string3;
                String string4 = arrayList2.get(n);
                if (string4 == null || !(string3 = string4.toString()).equalsIgnoreCase("DBO") && !string3.equalsIgnoreCase("RS_SYSTABGROUP") && !string3.equalsIgnoreCase("SYS")) continue;
                arrayList2.remove(n);
                arrayList.remove(n);
            }
        }
        OwnerAndName.sortByOwnerThenName = this._showOwnerNamesBox.isSelected();
        Object[] objectArray = new OwnerAndName[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            objectArray[n] = new OwnerAndName(arrayList2.get(n), arrayList.get(n));
        }
        Arrays.sort(objectArray);
        this._list.setListData(objectArray);
        if (objectArray.length > 0) {
            n = 0;
            if (ownerAndName != null && (n = Arrays.binarySearch(objectArray, ownerAndName)) < 0) {
                n = 0;
            }
            this._list.setSelectedIndex(n);
            this._list.ensureIndexIsVisible(n);
        }
        if (component != null) {
            component.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (object == this._showOwnerNamesBox) {
            _initialShowOwnerNames = this._showOwnerNamesBox.isSelected();
            this._timer.stop();
            this.refreshList();
        } else if (object == this._showSystemObjectsBox) {
            if (this._showSystemObjectsBox != null) {
                _initialShowSystemObjects = this._showSystemObjectsBox.isSelected();
            }
            this._timer.stop();
            this.refreshList();
        } else if (object == this._dbComboBox) {
            this._timer.stop();
            this.refreshList();
        } else if (object == this._timer) {
            this.refreshList();
        } else if (object == this._help || actionEvent.getActionCommand().equals(F1_KEY)) {
            this.handleHelp();
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    private void handleOK() {
        this.setVisible(false);
        Object e = this._list.getSelectedValue();
        if (e != null) {
            this._procName = e.toString();
        }
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    private void handleHelp() {
        ISQLHelpManager.showHelp((ISQLConnectionImpl)this._connection, this, "HELP_ISQL_PROCEDURE_BROWSER");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n = this._list.locationToIndex(mouseEvent.getPoint());
            this._list.setSelectedIndex(n);
            this.handleOK();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this._timer.restart();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this._timer.restart();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this._timer.restart();
    }
}

