/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.DropDownButtonEvent;
import com.sybase.util.DropDownButtonListener;
import com.sybase.util.FontHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybDropDownButton;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLResource;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;
import sybase.isql.SQLTextComponent;

class PromptDialog
extends JDialog
implements ActionListener,
DropDownButtonListener,
WindowListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String HELP_KEY_COMMAND = "HelpKey";
    private int _rc;
    JButton _copyButton = null;
    JButton[] _buttons;
    private SybDropDownButton _helpButton;
    private int _escapeOption;
    private String _helpKeyword = null;
    private HelpItem[] _helpItems = null;
    private String _message;
    private String _details;
    private static ClipboardOwner _defaultClipboardOwner = null;

    static int create(JFrame jFrame, int n, String string, String string2, String[] stringArray, int n2, int n3, JComponent jComponent, String[] stringArray2) {
        PromptDialog promptDialog = new PromptDialog(jFrame, n, string, string2, stringArray, n2, n3, jComponent, stringArray2);
        UIUtils.ensureWindowIsVisible((Window)promptDialog);
        promptDialog.setVisible(true);
        promptDialog.destroyGUI();
        return promptDialog._rc;
    }

    private PromptDialog(JFrame jFrame, int n, String string, String string2, String[] stringArray, int n2, int n3, JComponent jComponent, String[] stringArray2) {
        super((Window)jFrame, string, Dialog.ModalityType.DOCUMENT_MODAL);
        int n4;
        Component component;
        JComponent[] jComponentArray;
        Object object;
        JButton jButton = null;
        this._rc = -1;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        int n5 = 0;
        JLabel jLabel = n == 2 ? new JLabel(UIManager.getIcon("OptionPane.errorIcon")) : (n == 1 ? new JLabel(UIManager.getIcon("OptionPane.warningIcon")) : new JLabel(UIManager.getIcon("OptionPane.informationIcon")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._message = string2;
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(this.escapeAmpersands(string2));
        new FontHelper((JLabel)sybMultiLineLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n5++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)sybMultiLineLabel, gridBagConstraints);
        if (jComponent != null) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n5++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        boolean bl = false;
        if (jComponent != null && jComponent instanceof JScrollPane && ((Container)(object = (jComponentArray = (JComponent[])jComponent).getViewport())).getComponentCount() > 0 && (component = ((Container)object).getComponent(0)) instanceof SQLTextComponent) {
            this._details = ((SQLTextComponent)((Object)component)).getText();
            bl = true;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        if (bl) {
            this._copyButton = new SybButton(ISQLResource.getISQLString(GeneralResources.getName(), "COPY_BUTTON"));
            this._copyButton.addActionListener(this);
            jPanel2.add(this._copyButton);
            jPanel2.add(Box.createHorizontalStrut(5));
        }
        this._buttons = new JButton[stringArray.length];
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            this._buttons[n4] = new SybButton(stringArray[n4]);
            jPanel2.add(this._buttons[n4]);
            this._buttons[n4].addActionListener(this);
            if (n4 == n2) {
                this.getRootPane().setDefaultButton(this._buttons[n4]);
                jButton = this._buttons[n4];
            }
            jPanel2.add(Box.createHorizontalStrut(5));
        }
        if (stringArray2 != null) {
            this._helpItems = new HelpItem[stringArray2.length / 2];
            for (n4 = 0; n4 < stringArray2.length; n4 += 2) {
                this._helpItems[n4 / 2] = new HelpItem(stringArray2[n4], stringArray2[n4 + 1]);
            }
            this._helpButton = new SybDropDownButton(ISQLResource.getISQLString(GeneralResources.getName(), "Help"), (Object[])this._helpItems);
            this._helpButton.addActionListener((ActionListener)this);
            this._helpButton.addDropDownButtonListener((DropDownButtonListener)this);
            jPanel2.add((Component)this._helpButton);
        }
        if (bl) {
            jComponentArray = new JButton[this._buttons.length + 1];
            jComponentArray[0] = this._copyButton;
            System.arraycopy(this._buttons, 0, jComponentArray, 1, this._buttons.length);
        } else {
            jComponentArray = this._buttons;
        }
        DialogUtils.makeComponentsSameWidth((JComponent[])jComponentArray);
        jPanel2.add(Box.createHorizontalGlue());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n5++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (n3 != -1) {
            this._escapeOption = n3;
            this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        }
        if (stringArray2 != null) {
            this.getRootPane().registerKeyboardAction(this, HELP_KEY_COMMAND, KeyStroke.getKeyStroke(112, 0, false), 1);
        }
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pack();
        if (jButton != null) {
            jButton.requestFocus();
        }
        this.setLocationRelativeTo(jFrame);
        if (n == 2 && Preferences.getBooleanOption((ISQLConnection)(object = jFrame instanceof ParentFrame ? ((ParentFrame)jFrame).getConnection() : null), "bell")) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private String escapeAmpersands(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuilder.append(c);
            }
            stringBuilder.append(c);
        }
        string = stringBuilder.toString();
        return string;
    }

    private void destroyGUI() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, false));
        this.removeWindowListener(this);
        for (int i = 0; i < this._buttons.length; ++i) {
            this._buttons[i].removeActionListener(this);
        }
        this._buttons = null;
        if (this._copyButton != null) {
            this._copyButton.removeActionListener(this);
            this._copyButton = null;
        }
        if (this._helpButton != null) {
            this._helpButton.removeActionListener((ActionListener)this);
            this._helpButton.removeDropDownButtonListener((DropDownButtonListener)this);
            this._helpButton = null;
        }
        this._details = null;
        this._message = null;
        this.getRootPane().setDefaultButton(null);
        DialogUtils.removeComponents((Container)this);
    }

    private void handleEscape() {
        this._rc = this._escapeOption;
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (this._escapeOption != -1 && (string = actionEvent.getActionCommand()) != null && string.equals(ESCAPE_KEY_COMMAND)) {
            this.handleEscape();
            return;
        }
        string = actionEvent.getActionCommand();
        if (string != null && string.equals(HELP_KEY_COMMAND)) {
            this.showHelp(this._helpItems[0].getHelpID());
            return;
        }
        for (int i = 0; i < this._buttons.length; ++i) {
            if (object != this._buttons[i]) continue;
            this._rc = i;
            this.setVisible(false);
            return;
        }
        if (object == this._helpButton) {
            if (this._helpItems.length == 1) {
                this.showHelp(this._helpItems[0].getHelpID());
            } else {
                this._helpButton.showDropDown();
            }
        } else if (object == this._copyButton) {
            this.handleCopy();
        }
    }

    private void handleCopy() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._message);
        if (this._details != null && this._details.length() > 0) {
            stringBuilder.append('\n');
            stringBuilder.append('\n');
            stringBuilder.append(this._details);
        }
        String string = stringBuilder.toString();
        if (_defaultClipboardOwner == null) {
            _defaultClipboardOwner = new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            };
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, _defaultClipboardOwner);
    }

    private void showHelp(String string) {
        ParentFrame parentFrame = (ParentFrame)SwingUtilities.getAncestorOfClass(ParentFrame.class, this);
        if (parentFrame != null) {
            ISQLConnectionImpl iSQLConnectionImpl = (ISQLConnectionImpl)parentFrame.getConnection();
            ISQLHelpManager.showHelp(iSQLConnectionImpl, this, string);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.handleEscape();
    }

    public void dropDownItemClicked(DropDownButtonEvent dropDownButtonEvent) {
        this.showHelp(this._helpItems[dropDownButtonEvent.getIndex()].getHelpID());
    }

    public void dropDownOpening(DropDownButtonEvent dropDownButtonEvent) {
    }

    static class HelpItem {
        String _id;
        String _displayText;

        HelpItem(String string, String string2) {
            this._id = string;
            this._displayText = string2;
        }

        String getHelpID() {
            return this._id;
        }

        public String toString() {
            return this._displayText;
        }
    }
}

