/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.resultSetTable.ClipboardFormat;
import com.sybase.resultSetTable.GenericResultSetTableClient;
import com.sybase.resultSetTable.OutOfMemoryException;
import com.sybase.resultSetTable.ResultSetTable;
import com.sybase.resultSetTable.ResultSetTableClient;
import com.sybase.resultSetTable.ResultSetTableEvent;
import com.sybase.resultSetTable.ResultSetTableListener;
import com.sybase.resultSetTable.SAResultSetTableClient;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.resultSetTable.WaitForRowsDialog;
import com.sybase.resultSetTable.WorkerThread;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.LabelBar;
import com.sybase.util.Platform;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import sybase.isql.Dbg;
import sybase.isql.DriverType;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.HistoryItem;
import sybase.isql.IO;
import sybase.isql.IODataClient;
import sybase.isql.IOFilter;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLEngine;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLParser;
import sybase.isql.ISQLParserListener;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.ISQLResultSetImpl;
import sybase.isql.ParentFrame;
import sybase.isql.ParseException;
import sybase.isql.ParserStringReader;
import sybase.isql.ParserUtils;
import sybase.isql.Preferences;
import sybase.isql.ResultSetIO;
import sybase.isql.ResultsProcessor;
import sybase.isql.TextResultsPanel;
import sybase.isql.TokenMgrError;
import sybase.isql.UserAbortedParsingError;
import sybase.isql.isql;

class ResultsPanel
extends JPanel
implements ResultSetTableListener,
ChangeListener,
FocusListener,
MouseListener,
ResultsProcessor,
ActionListener,
ISQLParserListener {
    private static ImageIcon _fetchingImage = null;
    private static ImageIcon _partialTableImage = null;
    private static ImageIcon _tableImage = null;
    private JSplitPane _splitPane;
    private JTabbedPane _tabbedPane;
    private ISQLParser _parser = null;
    private JList _messages;
    private MsgListModel _listModel;
    private ISQLConnection _connection;
    private LogTextOut _logTextOut;
    private String _lastResultSetGeneratingStatement = null;
    private boolean _showMessagesSeparately;
    private boolean _ignoreStateChangedEvents = true;
    private LabelBar _labelBar = null;
    private LabelBar _messagesLabelBar = null;
    private ParentFrame _parent = null;
    private volatile boolean _fetchBlockInProgress;
    private boolean _errorDialogIsOpen = false;
    private TextResultsPanel _textResultsPanel = null;
    private boolean _showResultsAsText;
    private MyResultSetTableClient _rstClient = null;
    private Timer _timer = null;
    private int _statementSelectionLineNumberOffset;
    private boolean _isParserRunning = false;
    private int _lastStatementStartLine = -1;
    private int _lastStatementEndLine = -1;

    ResultsPanel(ParentFrame parentFrame, ISQLConnection iSQLConnection) {
        this._parent = parentFrame;
        this._showMessagesSeparately = Preferences.getBooleanOption(null, "showSeparateMessagesPane");
        boolean bl = this._showResultsAsText = !Preferences.getPluginBooleanPreference((ISQLConnectionImpl)iSQLConnection, "showResultsWithGrids", "1");
        if (_fetchingImage == null) {
            URL uRL = this.getClass().getResource("fetching.gif");
            _fetchingImage = uRL != null ? new ImageIcon(uRL) : ISQLImages.getImageIcon("fetching");
        }
        if (_tableImage == null) {
            _tableImage = ISQLImages.getImageIcon("table");
        }
        if (_partialTableImage == null) {
            _partialTableImage = ISQLImages.getImageIcon("partial_table");
        }
        this.setLayout(new BoxLayout(this, 1));
        this._listModel = new MsgListModel();
        this._messages = new JList(this._listModel);
        this._messages.setCellRenderer(FontHelper.getListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this._messages);
        jScrollPane.setAlignmentX(0.0f);
        int n = Preferences.getIntOption(null, "defaultMessagesPaneHeight");
        this._messages.setVisibleRowCount(n);
        MessagesPanel messagesPanel = new MessagesPanel();
        messagesPanel.setLayout(new BoxLayout(messagesPanel, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this._labelBar = new LabelBar(ISQLResource.getISQLString(GeneralResources.getName(), "Results"));
        this._labelBar.setActive(false);
        this._labelBar.addMouseListener((MouseListener)this);
        jPanel.setAlignmentX(0.0f);
        jPanel.add((Component)this._labelBar);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.setTabPlacement(3);
        this._tabbedPane.setAlignmentX(0.0f);
        this._tabbedPane.setTabLayoutPolicy(1);
        this._tabbedPane.addChangeListener(this);
        jPanel.add(this._tabbedPane);
        if (this._showMessagesSeparately) {
            this._messagesLabelBar = new LabelBar(ISQLResource.getISQLString(GeneralResources.getName(), "Messages"));
            this._messagesLabelBar.addMouseListener((MouseListener)this);
            messagesPanel.add((Component)this._messagesLabelBar);
            messagesPanel.add(jScrollPane);
            this._splitPane = new JSplitPane(0, messagesPanel, jPanel);
            this.add(this._splitPane);
            this._tabbedPane.addTab(ISQLResource.getISQLString(GeneralResources.getName(), "(no data)"), new JPanel());
        } else {
            messagesPanel.add(jScrollPane);
            this._tabbedPane.addTab(ISQLResource.getISQLString(GeneralResources.getName(), "Messages"), messagesPanel);
            this.add(jPanel);
        }
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(119, 0));
        this.setConnection(iSQLConnection);
        this.addFocusListeners();
    }

    boolean isResultSetSelected() {
        Component component = this._tabbedPane.getSelectedComponent();
        return component != null && component instanceof ResultSetPanel;
    }

    void printResultSet(int n, boolean bl) {
        int n2 = this._tabbedPane.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = this._tabbedPane.getComponent(i);
            if (!(component instanceof ResultSetPanel)) continue;
            if (n == 0) {
                ResultSetPanel resultSetPanel = (ResultSetPanel)component;
                this.printResultSet(resultSetPanel.getResultSetTable(), bl);
                break;
            }
            --n;
        }
    }

    boolean isResultSetTableRowSelected() {
        boolean bl = false;
        Component component = this._tabbedPane.getSelectedComponent();
        if (component != null && component instanceof ResultSetPanel) {
            ResultSetPanel resultSetPanel = (ResultSetPanel)component;
            int n = resultSetPanel.getResultSetTable().getSelectedRow();
            bl = n != -1;
        }
        return bl;
    }

    boolean shouldEnableCopy() {
        boolean bl = false;
        Component component = this._tabbedPane.getSelectedComponent();
        if (component != null) {
            if (component instanceof ResultSetPanel) {
                ResultSetPanel resultSetPanel = (ResultSetPanel)component;
                int n = resultSetPanel.getResultSetTable().getSelectedRow();
                bl = n != -1;
            } else if (component instanceof TextResultsPanel) {
                TextResultsPanel textResultsPanel = (TextResultsPanel)component;
                bl = textResultsPanel.hasSelectedText();
            } else if (component instanceof MessagesPanel) {
                bl = this._messages.getSelectedIndex() != -1;
            }
        }
        return bl;
    }

    boolean isResultSetTableEditable() {
        boolean bl = false;
        Component component = this._tabbedPane.getSelectedComponent();
        if (component != null && component instanceof ResultSetPanel) {
            ResultSetPanel resultSetPanel = (ResultSetPanel)component;
            bl = resultSetPanel.getResultSetTable().isEditable();
        }
        return bl;
    }

    void deleteSelectedRows() {
        Component component = this._tabbedPane.getSelectedComponent();
        if (component != null && component instanceof ResultSetPanel) {
            ResultSetPanel resultSetPanel = (ResultSetPanel)component;
            ResultSetTable resultSetTable = resultSetPanel.getResultSetTable();
            resultSetTable.deleteRows();
        }
    }

    void setShowResultsAsText(boolean bl) {
        this._showResultsAsText = bl;
    }

    IO getMessagePanelIO() {
        return this._logTextOut;
    }

    void addFocusListeners() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.getComponentList(arrayList, this);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Component component = arrayList.get(i);
            component.removeFocusListener(this);
            component.addFocusListener(this);
        }
    }

    private void removeFocusListeners() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.getComponentList(arrayList, this);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Component component = arrayList.get(i);
            component.removeFocusListener(this);
        }
    }

    private void getComponentList(ArrayList<Component> arrayList, Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                this.getComponentList(arrayList, (Container)component);
            }
            arrayList.add(component);
        }
    }

    void release() {
        this.removeFocusListeners();
        this.clear();
        if (this._logTextOut != null) {
            isql.setIO(this._connection, this._logTextOut._io);
            this._logTextOut.fini();
            this._logTextOut = null;
        }
        if (this._tabbedPane != null) {
            this._tabbedPane.removeChangeListener(this);
            this._tabbedPane = null;
        }
        if (this._textResultsPanel != null) {
            this._textResultsPanel.destroy();
            this._textResultsPanel = null;
        }
        if (this._messagesLabelBar != null) {
            this._messagesLabelBar.removeMouseListener((MouseListener)this);
            this._messagesLabelBar = null;
        }
        this._labelBar.removeMouseListener((MouseListener)this);
        this._labelBar = null;
        this._parser = null;
        this._messages = null;
        this._listModel = null;
        this._connection = null;
        this._splitPane = null;
        this._parent = null;
        if (this._rstClient != null) {
            this._rstClient.destroy();
            this._rstClient = null;
        }
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            if (this._showMessagesSeparately) {
                if (focusEvent.getSource() == this._messages) {
                    this._messagesLabelBar.setActive(true);
                    this._labelBar.setActive(false);
                } else {
                    this._messagesLabelBar.setActive(false);
                    this._labelBar.setActive(true);
                }
            } else {
                this._labelBar.setActive(true);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component;
        if (!(focusEvent.isTemporary() || (component = focusEvent.getOppositeComponent()) != null && SwingUtilities.isDescendingFrom(component, this))) {
            if (this._showMessagesSeparately) {
                this._messagesLabelBar.setActive(false);
            }
            this._labelBar.setActive(false);
        }
    }

    void setConnection(ISQLConnection iSQLConnection) {
        if (this._connection != iSQLConnection) {
            this._connection = iSQLConnection;
            IO iO = isql.getIO(iSQLConnection);
            this._logTextOut = new LogTextOut(this._messages, iO);
            isql.setIO(iSQLConnection, this._logTextOut);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        if (!this._ignoreStateChangedEvents && (n = this._tabbedPane.getSelectedIndex()) != -1) {
            Component component = this._tabbedPane.getSelectedComponent();
            if (component != null && component instanceof ResultSetPanel) {
                ResultSetPanel resultSetPanel = (ResultSetPanel)component;
                resultSetPanel.setStatusMessage(this._parent);
            } else {
                this._parent.clearStatusMessage();
            }
        }
    }

    void clear() {
        this.clearTabbedPane();
        this._listModel.clear();
    }

    @Override
    public void notifyStatementExecution(String string, int n, int n2, int n3, int n4) {
        this._lastStatementStartLine = n;
        this._lastStatementEndLine = n3;
        if (this._timer == null || !this._timer.isRunning()) {
            if (this._timer == null) {
                this._timer = new Timer(500, this);
                this._timer.setRepeats(false);
            }
            this._timer.start();
            this.selectCurrentStatement();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.selectCurrentStatement();
    }

    private void selectCurrentStatement() {
        if (this._lastStatementStartLine != -1) {
            this._parent.setSQLStatementsTextSelection(this._lastStatementStartLine + this._statementSelectionLineNumberOffset - 1, this._lastStatementEndLine + this._statementSelectionLineNumberOffset - 1);
            this._lastStatementStartLine = -1;
            this._lastStatementEndLine = -1;
        }
    }

    boolean refresh(ISQLConnectionImpl iSQLConnectionImpl, String string) {
        return this.refresh(iSQLConnectionImpl, string, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refresh(ISQLConnectionImpl iSQLConnectionImpl, String string, int n, boolean bl) {
        Object object;
        TextResultsPanel textResultsPanel;
        boolean bl2 = false;
        this._ignoreStateChangedEvents = true;
        this._listModel.clear();
        this.clearTabbedPane();
        this._parent.clearStatusMessage();
        if (this._showResultsAsText) {
            textResultsPanel = this.getTextResultsPanel();
            textResultsPanel.reset();
        }
        iSQLConnectionImpl.notifyBatchStarts();
        this._statementSelectionLineNumberOffset = n;
        int[] nArray = this._parent.getSQLStatementsTextSelection();
        try {
            this._isParserRunning = true;
            bl2 = this.executeSQL(string, iSQLConnectionImpl, bl, n, false);
        }
        finally {
            this._isParserRunning = false;
            if (this._timer != null) {
                this._timer.stop();
            }
            if (this._parent != null && nArray[0] != -1) {
                this._parent.setSQLStatementsTextSelection(nArray);
            }
        }
        if (!this.isVisible() || this._connection == null) {
            return bl2;
        }
        iSQLConnectionImpl = (ISQLConnectionImpl)this._connection;
        string = iSQLConnectionImpl.getLastSQLStatement();
        if (string == null) {
            string = "";
        }
        if (iSQLConnectionImpl.isConnected()) {
            if (iSQLConnectionImpl.getResultSetCount() != 0 && ISQLConnectionImpl.statementReturnsResultSet(string)) {
                this._lastResultSetGeneratingStatement = string;
            } else if (!ISQLConnectionImpl.statementReturnsUpdateCount(string)) {
                this._lastResultSetGeneratingStatement = null;
            }
            if (ISQLConnectionImpl.statementIsProcedureCall(string)) {
                this._logTextOut.writeln(ISQLResource.getISQLString(GeneralResources.getName(), "Procedure completed"), 0);
            }
            if (this._lastResultSetGeneratingStatement != null && Preferences.getPluginBooleanPreference(iSQLConnectionImpl, "autoRefetch", "1") && ISQLConnectionImpl.statementReturnsUpdateCount(string)) {
                IO iO = isql.getIO(iSQLConnectionImpl);
                isql.setIO(iSQLConnectionImpl, new SilentIO(iO));
                this.executeSQL(this._lastResultSetGeneratingStatement, iSQLConnectionImpl, true, 0, false);
                isql.setIO(iSQLConnectionImpl, iO);
            }
        } else {
            this._lastResultSetGeneratingStatement = null;
        }
        int n2 = iSQLConnectionImpl.getResultSetCount();
        if (this._showResultsAsText || n2 > 0) {
            if (this._showResultsAsText) {
                String string2 = ISQLResource.getISQLString(GeneralResources.getName(), "Results");
                textResultsPanel = this.getTextResultsPanel();
                this._tabbedPane.insertTab(string2, null, textResultsPanel, null, 0);
            } else {
                for (int i = 0; i < n2; ++i) {
                    ISQLResultSet iSQLResultSet = iSQLConnectionImpl.getResultSet(i);
                    if (iSQLResultSet instanceof ISQLResultSetImpl && (((ISQLResultSetImpl)(object = (ISQLResultSetImpl)iSQLResultSet)).getMaxRows() == 0 || ((ISQLResultSetImpl)object).getScrollableResultSet().getCacheLastRowOnly())) continue;
                    String string3 = n2 > 1 ? ISQLResource.getFormattedString(GeneralResources.getName(), "Result Set {0}", Integer.toString(i + 1)) : ISQLResource.getISQLString(GeneralResources.getName(), "Results");
                    this._tabbedPane.insertTab(string3, null, this.createResultSetPanel(iSQLResultSet), null, i);
                }
            }
        } else if (this._showMessagesSeparately) {
            this._tabbedPane.addTab(ISQLResource.getISQLString(GeneralResources.getName(), "(no data)"), new JPanel());
        }
        if (this._tabbedPane.getTabCount() > 0) {
            this._tabbedPane.setSelectedIndex(0);
        }
        if (iSQLConnectionImpl.getResultSetCount() > 0 && (object = this._tabbedPane.getSelectedComponent()) != null && object instanceof ResultSetPanel) {
            ((ResultSetPanel)object).setStatusMessage(this._parent);
        }
        this.addFocusListeners();
        this._ignoreStateChangedEvents = false;
        return bl2;
    }

    @Override
    public void startProcessingResults(ISQLConnection iSQLConnection) {
    }

    @Override
    public boolean processResultSet(ISQLConnection iSQLConnection, String string, ISQLResultSet iSQLResultSet, boolean bl) {
        return true;
    }

    @Override
    public boolean processUpdateCount(ISQLConnection iSQLConnection, String string, int n) {
        String string2;
        int n2 = ISQLEngine.guessUpdateType(string);
        switch (n2) {
            case 1: {
                string2 = "{0} record(s) inserted";
                break;
            }
            case 2: {
                string2 = "{0} record(s) updated";
                break;
            }
            case 3: {
                string2 = "{0} record(s) deleted";
                break;
            }
            default: {
                if (iSQLConnection.getDatabaseType() == 1) {
                    return true;
                }
                string2 = "{0} record(s) affected";
            }
        }
        this._logTextOut.writeln(ISQLResource.getFormattedString(GeneralResources.getName(), string2, Integer.toString(n)), 0);
        return true;
    }

    @Override
    public boolean processAsyncMessages(ISQLConnection iSQLConnection, Vector<String> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this._logTextOut.writeln(vector.get(i), 0);
        }
        return true;
    }

    @Override
    public void endProcessingResults(ISQLConnection iSQLConnection) {
    }

    private void clearTabbedPane() {
        int n = this._tabbedPane.getTabCount();
        for (int i = n - 1; i >= 0; --i) {
            Component component = this._tabbedPane.getComponentAt(i);
            if (component instanceof MessagesPanel) continue;
            this._tabbedPane.remove(component);
            if (!(component instanceof ResultSetPanel)) continue;
            ((ResultSetPanel)component).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSQL(String string, ISQLConnection iSQLConnection, boolean bl, int n, boolean bl2) {
        boolean bl3 = false;
        isql.currentlyExectuingStatments = string;
        ParserStringReader parserStringReader = new ParserStringReader(string);
        this._parser = ParserUtils.getParser(this._parser, iSQLConnection, parserStringReader);
        if (this._showResultsAsText) {
            this._parser.setResultsProcessor(this.getTextResultsPanel());
        } else {
            this._parser.setResultsProcessor(this);
        }
        try {
            if (bl2) {
                this._parser.setParserListener(this);
            }
            this._parser.parse(iSQLConnection, bl);
            if (this._parent != null) {
                int n2 = this._parser.getErrorStartLine();
                int n3 = this._parser.getErrorEndLine();
                if (n2 != -1 && n3 != -1) {
                    this._parent.setSQLStatementsTextSelection(n2 + n - 1, n3 + n - 1);
                } else {
                    bl3 = true;
                }
            }
        }
        catch (TokenMgrError tokenMgrError) {
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ISQLResource.getISQLString(ErrorMessages.getName(), "Could not execute statement."));
                stringBuffer.append("\n");
                stringBuffer.append(tokenMgrError.getMessage());
                isql.getIO(iSQLConnection).writeln(stringBuffer.toString(), 2);
            }
            iSQLConnection.discardResultSets();
        }
        catch (ParseException parseException) {
            if (!bl) {
                isql.getIO(iSQLConnection).writeln(parseException.getMessage(), 2);
            }
            iSQLConnection.discardResultSets();
        }
        catch (UserAbortedParsingError userAbortedParsingError) {
            if (!bl && !isql.isShutdownRequested()) {
                isql.getIO(iSQLConnection).writeln(userAbortedParsingError.getMessage(), 2);
            }
            iSQLConnection.discardResultSets();
        }
        finally {
            if (bl2) {
                this._parser.setParserListener(null);
            }
        }
        isql.currentlyExectuingStatments = null;
        return bl3;
    }

    void updateResultSetTableTruncationLength() {
        int n = Preferences.getPluginIntPreference((ISQLConnectionImpl)this._connection, "truncationLength", "256");
        ArrayList arrayList = new ArrayList();
        DialogUtils.enumerateComponents(arrayList, (Container)this);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof ResultSetTable)) continue;
            ((ResultSetTable)e).setTruncationLength(n);
        }
    }

    void updateResultSetTableClipboardFormat() {
        ArrayList arrayList = new ArrayList();
        DialogUtils.enumerateComponents(arrayList, (Container)this);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof ResultSetTable)) continue;
            this.setResultSetTableClipboardFormat((ResultSetTable)e);
        }
    }

    private void setResultSetTableClipboardFormat(ResultSetTable resultSetTable) {
        ClipboardFormat clipboardFormat = new ClipboardFormat();
        String string = Preferences.getStringOption(this._connection, "ISQL_field_separator");
        if (string.equals("\\t")) {
            string = "\t";
        }
        clipboardFormat.columnDelimiter = string;
        clipboardFormat.quoteString = Preferences.getStringOption(this._connection, "ISQL_quote");
        string = Preferences.getStringOption(this._connection, "ISQL_escape_character");
        clipboardFormat.escapeChar = string.charAt(0);
        resultSetTable.setClipboardFormat(clipboardFormat);
    }

    void updateResultSetTableFont() {
        ArrayList arrayList = new ArrayList();
        DialogUtils.enumerateComponents(arrayList, (Container)this);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof ResultSetTable)) continue;
            this.setResultSetTableFont((ResultSetTable)e);
        }
    }

    void setResultSetTableFont(ResultSetTable resultSetTable) {
        String string = Preferences.getPluginStringPreference((ISQLConnectionImpl)this._connection, "resultSetFont", "(SYSTEM)");
        if (string == null || string.length() == 0 || string.equals("(SYSTEM)")) {
            resultSetTable.setFont(0, null);
        } else if (string.equals("(EDITOR)")) {
            resultSetTable.setFont(1, null);
        } else {
            Font font = Preferences.parseFontDescription(string);
            if (font != null) {
                resultSetTable.setFont(2, font);
            }
        }
    }

    private ResultSetPanel createResultSetPanel(ISQLResultSet iSQLResultSet) {
        Connection connection = this._connection.getJDBCConnection();
        ScrollableResultSet scrollableResultSet = iSQLResultSet.getScrollableResultSet();
        this._rstClient = new MyResultSetTableClient(this._connection, this._parent);
        ResultSetTable resultSetTable = new ResultSetTable((ResultSetTableClient)this._rstClient);
        resultSetTable.setSortable(true);
        if (Preferences.getPluginBooleanPreference((ISQLConnectionImpl)this._connection, "disableResultsEditing", "0")) {
            resultSetTable.setEditable(false);
        }
        this.setResultSetTableFont(resultSetTable);
        this.setResultSetTableClipboardFormat(resultSetTable);
        boolean bl = Preferences.getBooleanOption(iSQLResultSet.getConnection(), "UUID_has_hyphens");
        resultSetTable.setShowUUIDWithHyphens(bl);
        if (Preferences.getPluginBooleanPreference((ISQLConnectionImpl)this._connection, "showResultsRowNumber", "1")) {
            resultSetTable.showRowHeader(true);
        }
        resultSetTable.setNullDisplayString(Preferences.getPluginStringPreference((ISQLConnectionImpl)iSQLResultSet.getConnection(), "nulls", "(NULL)"));
        resultSetTable.setTruncationLength(Preferences.getPluginIntPreference((ISQLConnectionImpl)iSQLResultSet.getConnection(), "truncationLength", "256"));
        resultSetTable.setSelectionMode(2);
        resultSetTable.addResultSetTableListener((ResultSetTableListener)this);
        TreeSet<KeyStroke> treeSet = new TreeSet<KeyStroke>();
        treeSet.add(KeyStroke.getKeyStroke(9, 0));
        resultSetTable.setFocusTraversalKeys(0, treeSet);
        treeSet = new TreeSet();
        treeSet.add(KeyStroke.getKeyStroke(9, 1));
        resultSetTable.setFocusTraversalKeys(1, treeSet);
        ResultSetPanel resultSetPanel = new ResultSetPanel(resultSetTable, (ISQLConnectionImpl)this._connection);
        resultSetTable.setResultSet(connection, scrollableResultSet, (WorkerThread)resultSetPanel);
        resultSetPanel.setLayout(new GridLayout(0, 1));
        resultSetPanel.setOpaque(true);
        resultSetPanel.setBackground(SystemColor.window);
        resultSetPanel.setAlignmentX(0.0f);
        return resultSetPanel;
    }

    private TextResultsPanel getTextResultsPanel() {
        if (this._textResultsPanel == null) {
            this._textResultsPanel = new TextResultsPanel((ISQLConnectionImpl)this._connection);
        }
        return this._textResultsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exception(ResultSetTableEvent resultSetTableEvent) {
        if (this._errorDialogIsOpen) {
            return true;
        }
        try {
            this._errorDialogIsOpen = true;
            Exception exception = resultSetTableEvent.getException();
            String string = exception instanceof OutOfMemoryException ? ISQLResource.getFormattedString(ErrorMessages.getName(), "NOT_ENOUGH_MEMORY_TO_DISPLAY_RESULTSET", Platform.isMacOS() ? ISQLResource.getISQLString(GeneralResources.getName(), "Preferences") : ISQLResource.getISQLString(GeneralResources.getName(), "Options")) : exception.getLocalizedMessage();
            string = string + "\n";
            if (exception instanceof SQLWarning) {
                String string2 = Preferences.getStringOption(this._connection, "on_error");
                if (string2 != null && string2.equals("Continue")) {
                    this._logTextOut.writeln(string, 0);
                } else {
                    this._logTextOut._io.writeln(string, 1);
                }
            } else {
                this._logTextOut._io.writeln(exception, ISQLResource.getISQLString(ErrorMessages.getName(), "ErrorReadingResultSet"), 2);
            }
        }
        finally {
            this._errorDialogIsOpen = false;
        }
        return true;
    }

    public void selectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void notify(ResultSetTableEvent resultSetTableEvent) {
        int n = resultSetTableEvent.getNotificationId();
        ResultSetTable resultSetTable = (ResultSetTable)resultSetTableEvent.getSource();
        if (n == 8) {
            this._parent.updateStatusMessage(_fetchingImage, ISQLResource.getISQLString(GeneralResources.getName(), "Fetching rows..."));
            this._fetchBlockInProgress = true;
            this._parent.enableToolbarButtons();
        } else if (n == 9) {
            ResultsPanel.setStatusMessageForResultSetTable(this._parent, resultSetTable);
            this._fetchBlockInProgress = false;
            this._parent.enableToolbarButtons();
        } else if (n == 7) {
            ResultsPanel.setStatusMessageForResultSetTable(this._parent, resultSetTable);
            if (Preferences.getPluginBooleanPreference((ISQLConnectionImpl)this._connection, "autoReleaseLocks", "0")) {
                this._connection.releaseDatabaseLocks();
            }
            this._fetchBlockInProgress = false;
            this._parent.enableToolbarButtons();
        } else if (n == 10) {
            this._fetchBlockInProgress = false;
            this._parent.updateStatusMessage(null, ISQLResource.getFormattedString(GeneralResources.getName(), "Interrupted by user", Integer.toString(resultSetTable.getRowCount())));
            this._parent.enableToolbarButtons();
        }
    }

    private boolean canFetchMore(ScrollableResultSet scrollableResultSet) {
        boolean bl = !Preferences.getPluginBooleanPreference((ISQLConnectionImpl)this._connection, "showMultipleResultSets", "0") && !Preferences.getPluginBooleanPreference((ISQLConnectionImpl)this._connection, "showResultsForAllStatements", "0") && !scrollableResultSet.isClosed();
        return bl;
    }

    void printResultSet(ResultSetTable resultSetTable, boolean bl) {
        ScrollableResultSet scrollableResultSet = resultSetTable.getScrollableResultSet();
        if (scrollableResultSet == null) {
            return;
        }
        if (!scrollableResultSet.hasCachedAllRows()) {
            int n = scrollableResultSet.getCachedRowCount();
            String string = ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL");
            boolean bl2 = this.canFetchMore(scrollableResultSet);
            if (bl2) {
                int n2 = SybOptionPane.showConfirmDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_PRINTING_WITH_INCOMPLETE_RESULTS", Integer.toString(n)), (String)string, (int)0, (int)2);
                if (n2 == 1) {
                    resultSetTable.setMaximumRows(n);
                    scrollableResultSet.setMaxRows(n);
                } else {
                    resultSetTable.setMaximumRows(Integer.MAX_VALUE);
                    scrollableResultSet.setMaxRows(Integer.MAX_VALUE);
                    new WaitForRowsDialog((Frame)this._parent, scrollableResultSet);
                    resultSetTable.synchronizeTableModelWithResultSet();
                    ResultsPanel.setStatusMessageForResultSetTable(this._parent, resultSetTable);
                }
            } else {
                SybOptionPane.showMessageDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_PRINTING_CACHED_ROWS_ONLY", Integer.toString(n)), (String)string, (int)2);
            }
        }
        resultSetTable.print(bl);
    }

    public boolean selectAll(ResultSetTableEvent resultSetTableEvent) {
        ResultSetTable resultSetTable = (ResultSetTable)resultSetTableEvent.getSource();
        this.selectAllResultSetTable(resultSetTable);
        return true;
    }

    private void selectAllResultSetTable(ResultSetTable resultSetTable) {
        ScrollableResultSet scrollableResultSet = resultSetTable.getScrollableResultSet();
        if (scrollableResultSet == null) {
            return;
        }
        if (!scrollableResultSet.hasCachedAllRows()) {
            int n = scrollableResultSet.getCachedRowCount();
            String string = ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL");
            boolean bl = this.canFetchMore(scrollableResultSet);
            if (bl) {
                int n2 = SybOptionPane.showConfirmDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_SELECTING_WITH_INCOMPLETE_RESULTS", Integer.toString(n)), (String)string, (int)0, (int)2);
                if (n2 == 0) {
                    resultSetTable.setMaximumRows(Integer.MAX_VALUE);
                    scrollableResultSet.setMaxRows(Integer.MAX_VALUE);
                    new WaitForRowsDialog((Frame)this._parent, scrollableResultSet);
                    resultSetTable.synchronizeTableModelWithResultSet();
                    ResultsPanel.setStatusMessageForResultSetTable(this._parent, resultSetTable);
                } else {
                    resultSetTable.setMaximumRows(n);
                    scrollableResultSet.setMaxRows(n);
                }
            } else {
                SybOptionPane.showMessageDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_SELECTING_CACHED_ROWS_ONLY", Integer.toString(n)), (String)string, (int)2);
            }
        }
        resultSetTable.selectAll();
    }

    public boolean copyColumn(ResultSetTableEvent resultSetTableEvent) {
        ResultSetTable resultSetTable = (ResultSetTable)resultSetTableEvent.getSource();
        this.copyColumnResultSetTable(resultSetTable);
        return false;
    }

    private void copyColumnResultSetTable(ResultSetTable resultSetTable) {
        ScrollableResultSet scrollableResultSet = resultSetTable.getScrollableResultSet();
        if (scrollableResultSet == null) {
            return;
        }
        if (!scrollableResultSet.hasCachedAllRows()) {
            int n = scrollableResultSet.getCachedRowCount();
            String string = ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL");
            boolean bl = this.canFetchMore(scrollableResultSet);
            if (bl) {
                int n2 = SybOptionPane.showConfirmDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_COPYING_WITH_INCOMPLETE_RESULTS", Integer.toString(n)), (String)string, (int)0, (int)2);
                if (n2 == 0) {
                    resultSetTable.setMaximumRows(Integer.MAX_VALUE);
                    scrollableResultSet.setMaxRows(Integer.MAX_VALUE);
                    new WaitForRowsDialog((Frame)this._parent, scrollableResultSet);
                    resultSetTable.synchronizeTableModelWithResultSet();
                    ResultsPanel.setStatusMessageForResultSetTable(this._parent, resultSetTable);
                } else {
                    resultSetTable.setMaximumRows(n);
                    scrollableResultSet.setMaxRows(n);
                }
            } else {
                SybOptionPane.showMessageDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_COPYING_CACHED_ROWS_ONLY", Integer.toString(n)), (String)string, (int)2);
            }
        }
    }

    public boolean sortColumn(ResultSetTableEvent resultSetTableEvent) {
        boolean bl = false;
        final ResultSetTable resultSetTable = (ResultSetTable)resultSetTableEvent.getSource();
        final ScrollableResultSet scrollableResultSet = resultSetTable.getScrollableResultSet();
        if (scrollableResultSet != null && !scrollableResultSet.hasCachedAllRows()) {
            int n = scrollableResultSet.getCachedRowCount();
            String string = ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL");
            boolean bl2 = this.canFetchMore(scrollableResultSet);
            if (bl2) {
                int n2 = SybOptionPane.showConfirmDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_SORTING_WITH_INCOMPLETE_RESULTS", Integer.toString(n)), (String)string, (int)0, (int)2);
                if (n2 == 1) {
                    resultSetTable.setMaximumRows(n);
                    scrollableResultSet.setMaxRows(n);
                } else {
                    resultSetTable.setMaximumRows(Integer.MAX_VALUE);
                    scrollableResultSet.setMaxRows(Integer.MAX_VALUE);
                    final RowSorter.SortKey sortKey = resultSetTable.getSortKey();
                    resultSetTable.setSortKey(null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new WaitForRowsDialog((Frame)ResultsPanel.this._parent, scrollableResultSet);
                            resultSetTable.synchronizeTableModelWithResultSet();
                            ResultsPanel.setStatusMessageForResultSetTable(ResultsPanel.this._parent, resultSetTable);
                            resultSetTable.setSortKey(sortKey);
                        }
                    });
                }
            } else {
                SybOptionPane.showMessageDialog((Component)this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "WARNING_SORTING_CACHED_ROWS_ONLY", Integer.toString(n)), (String)string, (int)2);
            }
        }
        return bl;
    }

    boolean getShowMessagesSeparately() {
        return this._showMessagesSeparately;
    }

    ParentFrame getParentFrame() {
        return this._parent;
    }

    void selectAll() {
        Component component = this._tabbedPane.getSelectedComponent();
        if (component instanceof ResultSetPanel) {
            ResultSetTable resultSetTable = ((ResultSetPanel)component).getResultSetTable();
            this.selectAllResultSetTable(resultSetTable);
            resultSetTable.requestFocus();
        } else if (component instanceof TextResultsPanel) {
            ((TextResultsPanel)component).selectAll();
        } else if (component instanceof MessagesPanel) {
            this._messages.requestFocusInWindow();
            int n = this._messages.getModel().getSize();
            this._messages.setSelectionInterval(0, n - 1);
        }
    }

    void interrupt() {
        boolean bl = false;
        int n = this._tabbedPane.getTabCount();
        for (int i = n - 1; i >= 0; --i) {
            Component component = this._tabbedPane.getComponentAt(i);
            if (component instanceof ResultSetPanel) {
                ((ResultSetPanel)component).interrupt();
                bl = true;
                continue;
            }
            if (!(component instanceof TextResultsPanel)) continue;
            ((TextResultsPanel)component).interrupt();
            bl = true;
        }
        if (this._parser != null) {
            this._parser.interrupt();
        }
        this._connection.interrupt();
    }

    boolean isInterruptable() {
        boolean bl = false;
        boolean bl2 = bl = this._isParserRunning || this._connection.isBusy();
        if (!bl && !(bl = this._fetchBlockInProgress)) {
            Component component;
            int n = this._tabbedPane.getTabCount();
            for (int i = n - 1; !(i < 0 || (component = this._tabbedPane.getComponentAt(i)) instanceof ResultSetPanel && (bl = ((ResultSetPanel)component).isInterruptable())); --i) {
            }
        }
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._labelBar) {
            this._tabbedPane.requestFocus();
        } else if (mouseEvent.getSource() == this._messagesLabelBar) {
            this._messages.requestFocus();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private static void setStatusMessageForResultSetTable(ParentFrame parentFrame, ResultSetTable resultSetTable) {
        String string;
        ImageIcon imageIcon;
        int n = resultSetTable.getRowCount();
        if (resultSetTable.isBusy()) {
            imageIcon = _fetchingImage;
            string = ISQLResource.getISQLString(GeneralResources.getName(), "Fetching rows...");
        } else if (resultSetTable.isRowCountAnEstimate() || resultSetTable.getMaximumRows() == n) {
            imageIcon = _partialTableImage;
            string = ISQLResource.getFormattedString(GeneralResources.getName(), "First {0} rows", Integer.toString(n));
        } else {
            imageIcon = _tableImage;
            string = ISQLResource.getFormattedString(GeneralResources.getName(), "{0} rows", Integer.toString(n));
        }
        parentFrame.updateStatusMessage(imageIcon, string);
    }

    class MyResultSetTableClient
    implements ResultSetTableClient,
    ResultSetTableClient.UI,
    Runnable {
        private ResultSetTableClient _client;
        private ResultSetTableClient.UI _ui;
        private ResultSetTableClient.Operation _operation;
        private ResultSetTable _rst;
        private String _sql;
        private int[] _parmTypes;
        private Object[] _parms;
        private ResultSetTableClient.NextAction _nextAction;
        private Object[] _rowData;
        private boolean _exceptionWasCaught;
        private SQLException _e;
        private ISQLConnection _ci;
        private Warning _warningType = null;
        private int _warningUpdateCount;

        MyResultSetTableClient(ISQLConnection iSQLConnection, JFrame jFrame) {
            int n = iSQLConnection.getDatabaseType();
            this._client = n == 0 || n == 3 || n == 2 ? new SAResultSetTableClient(iSQLConnection.getJDBCConnection(), jFrame) : new GenericResultSetTableClient(iSQLConnection.getJDBCConnection(), jFrame);
            this._ci = iSQLConnection;
            this._ui = this._client.getUI();
            this._client.setUI((ResultSetTableClient.UI)this);
        }

        public ResultSetTableClient.NextAction executeSQL(ResultSetTable resultSetTable, ResultSetTableClient.Operation operation, String string, Object[] objectArray, int[] nArray) {
            this._nextAction = ResultSetTableClient.NextAction.CANCEL;
            try {
                this._rst = resultSetTable;
                this._operation = operation;
                this._sql = string;
                this._parmTypes = nArray;
                this._parms = objectArray;
                this._e = null;
                this._exceptionWasCaught = false;
                this._rowData = null;
                ((ISQLConnectionImpl)this._ci).callbackOnWorkerThread(this, false);
                if (this._exceptionWasCaught) {
                    this._nextAction = this._ui.handleSQLException(operation, this._e);
                } else {
                    ResultsPanel.this._parent.getHistory().add(new HistoryItem(this._sql));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this._nextAction;
        }

        public Object[] executeRefetchSQL(ResultSetTable resultSetTable, ResultSetTableClient.Operation operation, String string) {
            this._rowData = null;
            try {
                this._rst = resultSetTable;
                this._operation = operation;
                this._sql = string;
                this._e = null;
                this._exceptionWasCaught = false;
                ((ISQLConnectionImpl)this._ci).callbackOnWorkerThread(this, false);
                if (this._exceptionWasCaught) {
                    this._ui.handleSQLException(operation, this._e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this._rowData;
        }

        void destroy() {
            this._operation = null;
            this._rst = null;
            this._sql = null;
            this._parmTypes = null;
            this._parms = null;
            this._nextAction = null;
            this._rowData = null;
            this._e = null;
            this._ci = null;
            this._warningType = null;
        }

        @Override
        public void run() {
            if (this._warningType != null && EventQueue.isDispatchThread()) {
                if (this._warningType == Warning.NO_ROWS_AFFECTED) {
                    SybOptionPane.showMessageDialog((Component)ResultsPanel.this._parent, (Object)ISQLResource.getISQLString(ErrorMessages.getName(), "NO_ROWS_AFFECTED"), (String)ResultsPanel.this._parent.getTitle(), (int)2);
                } else if (this._warningType == Warning.MULTIPLE_ROWS_AFFECTED) {
                    SybOptionPane.showMessageDialog((Component)ResultsPanel.this._parent, (Object)ISQLResource.getFormattedString(ErrorMessages.getName(), "MULTIPLE_ROWS_AFFECTED", Integer.toString(this._warningUpdateCount)), (String)ResultsPanel.this._parent.getTitle(), (int)2);
                }
                this._warningType = null;
                return;
            }
            switch (this._operation) {
                case INSERT: 
                case UPDATE: 
                case DELETE: 
                case MULTIPLE_DELETE: {
                    this._nextAction = this._client.executeSQL(this._rst, this._operation, this._sql, this._parms, this._parmTypes);
                    break;
                }
                case REFETCH_AFTER_INSERT: 
                case REFETCH_AFTER_UPDATE: 
                case REFETCH_LONG_VALUE: {
                    this._rowData = this._client.executeRefetchSQL(this._rst, this._operation, this._sql);
                    break;
                }
            }
        }

        public void setUI(ResultSetTableClient.UI uI) {
        }

        public ResultSetTableClient.UI getUI() {
            return null;
        }

        public boolean isTableEditable(String string, String string2, String string3) {
            return this._client.isTableEditable(string, string2, string3);
        }

        public void executeCallback(ResultSetTable resultSetTable, Runnable runnable) {
            this._client.executeCallback(resultSetTable, runnable);
        }

        public ResultSetTableClient.NextAction handleSQLException(ResultSetTableClient.Operation operation, SQLException sQLException) {
            this._exceptionWasCaught = true;
            this._e = sQLException;
            return ResultSetTableClient.NextAction.COMPLETE;
        }

        public ResultSetTableClient.NextAction warnMultipleRowsAffected(ResultSetTableClient.Operation operation, int n) {
            this._warningType = Warning.MULTIPLE_ROWS_AFFECTED;
            this._warningUpdateCount = n;
            try {
                SwingUtilities.invokeLater(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ResultSetTableClient.NextAction.COMPLETE;
        }

        public void warnNoRowsAffected(ResultSetTableClient.Operation operation) {
            this._warningType = Warning.NO_ROWS_AFFECTED;
            try {
                SwingUtilities.invokeLater(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static enum Warning {
        MULTIPLE_ROWS_AFFECTED,
        NO_ROWS_AFFECTED;

    }

    static class ResultSetPanel
    extends JPanel
    implements WorkerThread,
    Runnable {
        private ResultSetTable _rst;
        private ISQLConnectionImpl _connection;
        private volatile AsyncFetchInfo _asyncFetchInfo = new AsyncFetchInfo();
        private Object _pauseObject = new Object();
        private int _pauseCount = 0;
        private boolean _isPaused = false;

        ResultSetPanel(ResultSetTable resultSetTable, ISQLConnectionImpl iSQLConnectionImpl) {
            this._rst = resultSetTable;
            this._connection = iSQLConnectionImpl;
            this.add((Component)resultSetTable);
        }

        ResultSetTable getResultSetTable() {
            return this._rst;
        }

        boolean isInterruptable() {
            return this._rst.isBusy();
        }

        void interrupt() {
            this._rst.interrupt();
        }

        void destroy() {
            if (this._rst != null) {
                this._rst.destroy();
                this._rst = null;
            }
            this._connection = null;
        }

        void setStatusMessage(ParentFrame parentFrame) {
            ResultsPanel.setStatusMessageForResultSetTable(parentFrame, this._rst);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fetchRows(int n) {
            boolean bl;
            int n2;
            AsyncFetchInfo asyncFetchInfo = this._asyncFetchInfo;
            synchronized (asyncFetchInfo) {
                n2 = this._asyncFetchInfo.rowCount;
                if (n <= n2) {
                    return;
                }
                this._asyncFetchInfo.rowCount = n;
                bl = this._asyncFetchInfo.fetcherIsRunning;
            }
            if (!bl && n2 == 0) {
                try {
                    this._connection.callbackOnWorkerThread(this, true);
                }
                catch (Exception exception) {
                    AsyncFetchInfo asyncFetchInfo2 = this._asyncFetchInfo;
                    synchronized (asyncFetchInfo2) {
                        this._asyncFetchInfo.rowCount = 0;
                    }
                    this._rst.notifyEndOfResultSet();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ScrollableResultSet scrollableResultSet = null;
            int n = -1;
            Hashtable<Integer, Boolean> hashtable = new Hashtable<Integer, Boolean>();
            AsyncFetchInfo asyncFetchInfo = this._asyncFetchInfo;
            synchronized (asyncFetchInfo) {
                this._asyncFetchInfo.fetcherIsRunning = true;
            }
            while (true) {
                boolean bl;
                block34: {
                    boolean bl2;
                    asyncFetchInfo = this._asyncFetchInfo;
                    synchronized (asyncFetchInfo) {
                        if (this._asyncFetchInfo.abort) {
                            this._asyncFetchInfo.abort = false;
                            this._asyncFetchInfo.fetcherIsRunning = false;
                            break;
                        }
                        if (this._asyncFetchInfo.rowCount == 0) {
                            this._asyncFetchInfo.fetcherIsRunning = false;
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        bl2 = false;
                        this._rst.notifyFetcherIdle();
                        break;
                    }
                    this.allowPause();
                    if (scrollableResultSet == null) {
                        scrollableResultSet = this._rst.getScrollableResultSet();
                    }
                    try {
                        this._asyncFetchInfo.fetchInProgress = true;
                        bl = scrollableResultSet.next();
                    }
                    catch (SQLException sQLException) {
                        int n2;
                        Integer n3;
                        bl = false;
                        if (!this._asyncFetchInfo.abort && !hashtable.containsKey(n3 = Integer.valueOf(n2 = sQLException.getErrorCode()))) {
                            hashtable.put(n3, Boolean.TRUE);
                            this._rst.notifyFetcherException((Exception)sQLException);
                        }
                        if (this._connection.getDriverType() != DriverType.JDBC_ODBC || (n2 = sQLException.getErrorCode()) == -308 || n2 == -853 || n2 == -85) break block34;
                        try {
                            int n4 = scrollableResultSet.getJDBCResultSet().getRow();
                            if (n == -1 || n != n4) {
                                n = n4;
                                continue;
                            }
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                    }
                    finally {
                        this._asyncFetchInfo.fetchInProgress = false;
                        continue;
                    }
                }
                if (!bl) {
                    asyncFetchInfo = this._asyncFetchInfo;
                    synchronized (asyncFetchInfo) {
                        this._asyncFetchInfo.rowCount = 0;
                        this._asyncFetchInfo.fetcherIsRunning = false;
                    }
                    if (this._rst == null) break;
                    this._rst.notifyEndOfResultSet();
                    break;
                }
                SQLWarning sQLWarning = scrollableResultSet.getWarnings();
                if (sQLWarning != null) {
                    this._rst.notifyFetcherException((Exception)sQLWarning);
                }
                this._rst.readRowData();
                asyncFetchInfo = this._asyncFetchInfo;
                synchronized (asyncFetchInfo) {
                    --this._asyncFetchInfo.rowCount;
                    if (this._asyncFetchInfo.rowCount < 0) {
                        this._asyncFetchInfo.rowCount = 0;
                    }
                }
            }
            asyncFetchInfo = this._asyncFetchInfo;
            synchronized (asyncFetchInfo) {
                this._asyncFetchInfo.fetcherIsRunning = false;
            }
            hashtable.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFetchCount() {
            int n;
            AsyncFetchInfo asyncFetchInfo = this._asyncFetchInfo;
            synchronized (asyncFetchInfo) {
                n = this._asyncFetchInfo.rowCount;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abortFetch() {
            Object object = this._asyncFetchInfo;
            synchronized (object) {
                this._asyncFetchInfo.rowCount = 0;
                this._asyncFetchInfo.abort = true;
            }
            if (this._asyncFetchInfo.fetchInProgress) {
                object = this._asyncFetchInfo;
                synchronized (object) {
                    this._asyncFetchInfo.fetchInProgress = false;
                }
                object = Toolkit.getDefaultToolkit().getSystemEventQueue();
                if (EventQueue.isDispatchThread()) {
                    try {
                        ResultSet resultSet = this._rst.getResultSet();
                        Statement statement = resultSet.getStatement();
                        if (statement != null) {
                            try {
                                statement.cancel();
                            }
                            catch (Exception exception) {
                                Dbg.printlnEx((Throwable)exception, (String)("Note! Exception caught while canceling statement " + Integer.toHexString(statement.hashCode())));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void terminate() {
            this.abortFetch();
            this._rst = null;
            this._connection = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pause() {
            boolean bl = false;
            boolean bl2 = false;
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("This method must be called from the AWT thread. It was called from " + Thread.currentThread().getName());
            }
            Object object = this._pauseObject;
            synchronized (object) {
                ++this._pauseCount;
                if (this._pauseCount == 1) {
                    AsyncFetchInfo asyncFetchInfo = this._asyncFetchInfo;
                    synchronized (asyncFetchInfo) {
                        bl = this._asyncFetchInfo.fetcherIsRunning;
                    }
                    if (bl) {
                        try {
                            this._pauseObject.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this._isPaused || !bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unpause() {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("This method must be called from the AWT thread. It was called from " + Thread.currentThread().getName());
            }
            Object object = this._pauseObject;
            synchronized (object) {
                if (this._pauseCount > 0) {
                    --this._pauseCount;
                    if (this._pauseCount == 0) {
                        this._pauseObject.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void allowPause() {
            Object object = this._pauseObject;
            synchronized (object) {
                if (this._pauseCount > 0) {
                    try {
                        this._isPaused = true;
                        this._pauseObject.wait();
                        this._isPaused = false;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean dbgEnabled() {
            return false;
        }

        static class AsyncFetchInfo {
            int rowCount = 0;
            boolean abort = false;
            boolean fetchInProgress = false;
            boolean fetcherIsRunning = false;

            AsyncFetchInfo() {
            }
        }
    }

    static class MessagesPanel
    extends JPanel {
        MessagesPanel() {
        }
    }

    class LogTextOut
    implements IO,
    ResultSetIO,
    ActionListener {
        private static final int BUFFERING_INTERVAL = 100;
        private IO _io;
        private JList _listBox;
        private long _lastWriteTime = 0L;
        private Vector<String> _buffer = new Vector(100);
        private Timer _timer = null;
        private boolean _forceMessageSerialization = false;

        LogTextOut(JList jList, IO iO) {
            this._io = iO;
            this._listBox = jList;
        }

        @Override
        public void writeln(String string, int n) {
            this.writeln(null, string, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void writeln(final Exception exception, final String string, final int n) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (!this._forceMessageSerialization) {
                if (eventQueue.isDispatchThread()) {
                    this.writeln2(exception, string, n);
                    return;
                }
            }
            this._forceMessageSerialization = true;
            if (n != 4) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogTextOut.this.writeln2(exception, string, n);
                    }
                });
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LogTextOut.this.writeln2(exception, string, 1);
                    }
                });
                return;
            }
            catch (Exception exception2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogTextOut.this.writeln2(exception, string, n);
                    }
                });
            }
        }

        private void writeln2(Exception exception, String string, int n) {
            int n2 = 0;
            int n3 = 0;
            if (this._buffer == null) {
                return;
            }
            if (string == null) {
                return;
            }
            if (!isql.options.quiet || n == 2 || n == 3) {
                if (n == 1 || n == 2) {
                    if (exception == null) {
                        this._io.writeln(string, n);
                    } else {
                        this._io.writeln(exception, string, n);
                    }
                } else {
                    while (true) {
                        if ((n3 = string.indexOf(10, n2)) == -1) {
                            if (n2 > string.length()) break;
                            this._buffer.add(string.substring(n2));
                            break;
                        }
                        if (n3 > 0 && string.charAt(n3 - 1) == '\r') {
                            this._buffer.add(string.substring(n2, n3 - 1));
                        } else {
                            this._buffer.add(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                    }
                    long l = System.currentTimeMillis();
                    if (this._lastWriteTime == 0L) {
                        this._lastWriteTime = l;
                        if (this._timer == null) {
                            this._timer = new Timer(100, this);
                            this._timer.setRepeats(false);
                            this._timer.start();
                        } else {
                            this._timer.restart();
                        }
                    }
                }
                if (n == 2 && Preferences.getBooleanOption(ResultsPanel.this._connection, "bell")) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._buffer == null) {
                return;
            }
            if (this._buffer.size() != 0) {
                this.addBufferedLinesToModel();
            }
        }

        private void addBufferedLinesToModel() {
            if (ResultsPanel.this._showResultsAsText && ResultsPanel.this._textResultsPanel != null) {
                ResultsPanel.this._textResultsPanel.addLines(this._buffer);
            } else {
                ResultsPanel.this._listModel.addLines(this._buffer);
                this.ensureLastLineIsVisible();
            }
            this._buffer.removeAllElements();
            this._lastWriteTime = 0L;
            this._forceMessageSerialization = false;
        }

        @Override
        public int promptForOption(int n, String string, String string2, String[] stringArray, int n2, int n3) {
            int n4;
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (eventQueue.isDispatchThread()) {
                n4 = this._io.promptForOption(n, string, string2, stringArray, n2, n3);
            } else {
                final int n5 = n;
                final String string3 = string;
                final String string4 = string2;
                final String[] stringArray2 = stringArray;
                final int n6 = n2;
                final int n7 = n3;
                final int[] nArray = new int[1];
                n4 = n2;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            nArray[0] = LogTextOut.this.promptForOption(n5, string3, string4, stringArray2, n6, n7);
                        }
                    });
                    n4 = nArray[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return n4;
        }

        @Override
        public int promptForOptionWithAccessory(int n, String string, String string2, String[] stringArray, int n2, int n3, JComponent jComponent, String[] stringArray2) {
            return this._io.promptForOptionWithAccessory(n, string, string2, stringArray, n2, n3, jComponent, stringArray2);
        }

        @Override
        public void promptForData(String string, String[] stringArray, Class[] classArray, Object[] objectArray, int n, IODataClient iODataClient) {
            this._io.promptForData(string, stringArray, classArray, objectArray, n, iODataClient);
        }

        @Override
        public void showProgress(final String string, int n) {
            if (EventQueue.isDispatchThread()) {
                this.showProgress2(string);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogTextOut.this.showProgress2(string);
                    }
                });
            }
        }

        private void showProgress2(String string) {
            if (ResultsPanel.this._parent != null) {
                ResultsPanel.this._parent.updateStatusMessage(null, string);
            }
        }

        @Override
        public void setStatus(final Object object, final String string) {
            if (EventQueue.isDispatchThread()) {
                this.setStatus2(object, string);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogTextOut.this.setStatus2(object, string);
                    }
                });
            }
        }

        private void setStatus2(Object object, String string) {
            if (ResultsPanel.this._parent != null) {
                ResultsPanel.this._parent.updateStatusMessage((Icon)object, string);
            }
        }

        @Override
        public void updateFetchingStatus(boolean bl) {
            if (bl) {
                ImageIcon imageIcon = _fetchingImage;
                String string = ISQLResource.getISQLString(GeneralResources.getName(), "Fetching rows...");
                ResultsPanel.this._parent.updateStatusMessage(imageIcon, string);
            } else {
                ResultsPanel.this._parent.clearStatusMessage();
            }
        }

        private void ensureLastLineIsVisible() {
            int n = ResultsPanel.this._listModel.getSize() - 1;
            if (n >= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ResultsPanel.this._listModel != null && LogTextOut.this._listBox != null) {
                            int n = ResultsPanel.this._listModel.getSize() - 1;
                            LogTextOut.this._listBox.ensureIndexIsVisible(n);
                        }
                    }
                });
            }
        }

        @Override
        public void displayTable(String string, String[] stringArray, String[][] stringArray2) {
            this._io.displayTable(string, stringArray, stringArray2);
        }

        void fini() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
            if (this._buffer != null) {
                this._buffer.clear();
                this._buffer = null;
            }
            this._io = null;
            this._listBox = null;
        }
    }

    static class MsgListModel
    extends AbstractListModel {
        private static final int RING_SIZE = 1000;
        private int _head = 0;
        private int _tail = 0;
        private Vector<String> _elements = new Vector();
        private int _statusLine = -1;

        MsgListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            n = (n + this._head) % 1000;
            return this._elements.elementAt(n);
        }

        @Override
        public int getSize() {
            return this._elements.size();
        }

        synchronized void addLines(Vector<String> vector) {
            int n = this._tail;
            for (int i = 0; i < vector.size(); ++i) {
                if (this._tail == this._head && this._elements.size() > 0) {
                    this._head = (this._head + 1) % 1000;
                }
                if (this._elements.size() < 1000) {
                    this._elements.insertElementAt(vector.elementAt(i), this._tail);
                } else {
                    this._elements.setElementAt(vector.elementAt(i), this._tail);
                }
                this._tail = (this._tail + 1) % 1000;
            }
            if (this._elements.size() < 1000) {
                this.fireIntervalAdded(this, n, this._tail - 1);
            } else {
                this.fireContentsChanged(this, 0, 999);
            }
        }

        void clear() {
            this._statusLine = -1;
            this._tail = 0;
            this._head = 0;
            int n = this._elements.size();
            if (n != 0) {
                this._elements.removeAllElements();
                this.fireIntervalRemoved(this, 0, n - 1);
            }
        }

        void setStatus(String string) {
            if (this._statusLine == -1) {
                this._statusLine = this._elements.size();
                this._elements.addElement(string);
                this.fireIntervalAdded(this, this._statusLine, this._statusLine);
            } else {
                this._elements.setElementAt(string, this._statusLine);
                this.fireContentsChanged(this, this._statusLine, this._statusLine);
            }
        }

        void removeStatus() {
            if (this._statusLine != -1) {
                this._elements.remove(this._statusLine);
                this.fireIntervalRemoved(this, this._statusLine, this._statusLine);
                this._statusLine = -1;
            }
        }

        boolean hasStatusLine() {
            return this._statusLine != -1;
        }
    }

    static class SilentIO
    extends IOFilter {
        SilentIO(IO iO) {
            super(iO);
        }

        @Override
        public void writeln(String string, int n) {
        }
    }
}

