/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import sybase.isql.GeneralResources;
import sybase.isql.IODataClient;
import sybase.isql.ISQLResource;
import sybase.isql.isql;

class RowDataPrompt
extends JDialog
implements ActionListener,
FocusListener,
WindowListener {
    private JButton _done;
    private JButton _add;
    private JButton _clear;
    private JButton _ok;
    private JTextField[] _textFields;
    private JScrollPane _scrollPane;
    private IODataClient _client;

    static void create(JFrame jFrame, String string, String[] stringArray, Class[] classArray, Object[] objectArray, int n, IODataClient iODataClient) {
        RowDataPrompt rowDataPrompt = new RowDataPrompt(jFrame, string, stringArray, classArray, objectArray, n);
        rowDataPrompt._client = iODataClient;
        UIUtils.ensureWindowIsVisible((Window)rowDataPrompt);
        rowDataPrompt.setVisible(true);
        rowDataPrompt.destroyGUI();
    }

    private RowDataPrompt(JFrame jFrame, String string, String[] stringArray, Class[] classArray, Object[] objectArray, int n) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Vector<String> vector = this.parseMessages(string);
        int n2 = vector.size();
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                SybLabel sybLabel = new SybLabel(vector.elementAt(i));
                sybLabel.setAlignmentX(0.0f);
                jPanel.add((Component)sybLabel);
            }
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        JPanel jPanel2 = this.createDataPanel(stringArray, classArray, objectArray);
        this._scrollPane = new JScrollPane(jPanel2);
        this._scrollPane.setAlignmentX(0.0f);
        jPanel.add(this._scrollPane);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel3 = new JPanel();
        this._clear = new SybButton(ISQLResource.getISQLString(GeneralResources.getName(), "Clear Fields"));
        this._clear.addActionListener(this);
        jPanel3.add(this._clear);
        if (n == 1) {
            this._add = new SybButton(ISQLResource.getISQLString(GeneralResources.getName(), "Add"));
            this._add.addActionListener(this);
            jPanel3.add(this._add);
            this._done = new SybButton(ISQLResource.getISQLString(GeneralResources.getName(), "Done"));
            this._done.addActionListener(this);
            jPanel3.add(this._done);
            DialogUtils.makeComponentsSameWidth((JComponent[])new JButton[]{this._clear, this._add, this._done});
            this.getRootPane().setDefaultButton(this._add);
        } else {
            this._ok = new SybButton(ISQLResource.getISQLString(GeneralResources.getName(), "OK"));
            this._ok.addActionListener(this);
            jPanel3.add(this._ok);
            DialogUtils.makeComponentsSameWidth((JComponent[])new JButton[]{this._clear, this._ok});
            this.getRootPane().setDefaultButton(this._ok);
        }
        jPanel3.setAlignmentX(0.0f);
        Dimension dimension = jPanel3.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        jPanel3.setMaximumSize(dimension);
        jPanel.add(jPanel3);
        this.getContentPane().add((Component)jPanel, "Center");
        this.setTitle(ISQLResource.getISQLString(GeneralResources.getName(), "Interactive Input"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private void destroyGUI() {
        this.removeWindowListener(this);
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        for (int i = 0; i < this._textFields.length; ++i) {
            this._textFields[i].removeFocusListener(this);
            this._textFields[i] = null;
        }
        this._textFields = null;
        if (this._done != null) {
            this._done.removeActionListener(this);
            this._done = null;
        }
        if (this._add != null) {
            this._add.removeActionListener(this);
            this._add = null;
        }
        if (this._clear != null) {
            this._clear.removeActionListener(this);
            this._clear = null;
        }
        if (this._ok != null) {
            this._ok.removeActionListener(this);
            this._ok = null;
        }
        this._scrollPane = null;
        this._client = null;
        DialogUtils.removeComponents((Container)this);
    }

    private JPanel createDataPanel(String[] stringArray, Class[] classArray, Object[] objectArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentX(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        int n = stringArray.length;
        this._textFields = new JTextField[n];
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        for (int i = 0; i < n; ++i) {
            SybLabel sybLabel = new SybLabel(stringArray[i]);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)sybLabel, gridBagConstraints);
            this._textFields[i] = new JTextField();
            this._textFields[i].addFocusListener(this);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this._textFields[i], gridBagConstraints);
            if (objectArray != null && objectArray[i] != null) {
                this._textFields[i].setText(objectArray[i].toString());
            }
            Keymap keymap = this._textFields[i].getKeymap();
            keymap.removeKeyStrokeBinding(keyStroke);
        }
        Component component = Box.createVerticalGlue();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        jPanel.add(component, gridBagConstraints);
        return jPanel;
    }

    private Vector<String> parseMessages(String string) {
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        while (true) {
            if ((n2 = string.indexOf(10, n)) == -1) {
                if (n >= string.length()) break;
                vector.addElement(string.substring(n));
                break;
            }
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        return vector;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._add) {
            this.handleAdd();
        } else if (object == this._clear) {
            this.handleClear();
        } else if (object == this._done) {
            this.handleDone();
        } else if (object == this._ok) {
            this.handleOK();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        int n = this._textFields.length;
        for (int i = 0; i < n; ++i) {
            if (this._textFields[i] != object) continue;
            this.ensureFieldIsVisible(i);
            break;
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private boolean handleAdd() {
        boolean bl = false;
        int n = this._textFields.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._textFields[i].getText();
        }
        int n2 = this._client.submitData(this, objectArray);
        if (n2 == -1) {
            this.handleClear();
            this._textFields[0].requestFocus();
            this.ensureFieldIsVisible(0);
            bl = true;
        } else {
            this._textFields[n2].requestFocus();
            this.ensureFieldIsVisible(n2);
        }
        return bl;
    }

    private void handleClear() {
        int n = this._textFields.length;
        for (int i = 0; i < n; ++i) {
            this._textFields[i].setText("");
        }
    }

    private void handleOK() {
        boolean bl = this.handleAdd();
        if (bl) {
            this.setVisible(false);
        }
    }

    private void handleDone() {
        int n;
        boolean bl = true;
        int n2 = this._textFields.length;
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            String string = this._textFields[i].getText().trim();
            if (string.length() == 0) continue;
            bl2 = true;
            break;
        }
        if (bl2 && (n = isql.getIO().promptForOption(1, this.getTitle(), ISQLResource.getISQLString(GeneralResources.getName(), "The dialog contains unadded data. Do you want to add it before closing the dialog?"), new String[]{ISQLResource.getISQLString(GeneralResources.getName(), "YES_BUTTON"), ISQLResource.getISQLString(GeneralResources.getName(), "NO_BUTTON")}, 0, 0)) == 0) {
            bl = this.handleAdd();
        }
        if (bl) {
            this.setVisible(false);
        }
    }

    private void ensureFieldIsVisible(int n) {
        boolean bl;
        Rectangle rectangle = this._textFields[n].getBounds();
        JViewport jViewport = this._scrollPane.getViewport();
        Rectangle rectangle2 = jViewport.getViewRect();
        boolean bl2 = bl = rectangle.y >= rectangle2.y && rectangle.y < rectangle2.y + rectangle2.height;
        if (!bl) {
            Point point = rectangle.y < rectangle2.y ? new Point(0, rectangle.y) : new Point(0, rectangle.y + rectangle.height - rectangle2.height);
            jViewport.setViewPosition(point);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.handleDone();
    }
}

