/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import sybase.isql.ColWidthTable;

class Ruler
extends JPanel {
    private static int _cellWidth = 0;
    protected static final int TabWidth = 6;
    protected static final int TabHeight = 4;
    protected static final Border DefaultBorder = new RulerBorder();
    private JTable _table;
    private TabSet _tabs;
    private Font _unitsFont;
    private int _fontHeight;
    private int _fontAscent;

    Ruler(JTable jTable) {
        Border border;
        this._table = jTable;
        _cellWidth = this._table.getCellRect((int)0, (int)0, (boolean)true).width;
        this.setBackground(Color.white);
        MouseInputListener mouseInputListener = this.createMouseInputListener();
        if (mouseInputListener != null) {
            this.addMouseListener(mouseInputListener);
            this.addMouseMotionListener(mouseInputListener);
            jTable.addMouseListener(mouseInputListener);
            jTable.addMouseMotionListener(mouseInputListener);
        }
        if ((border = this.createBorder()) != null) {
            this.setBorder(border);
        }
    }

    int getColumnBreakCount() {
        if (this._tabs != null) {
            return this._tabs.getTabCount();
        }
        return 0;
    }

    int getColumnBreak(int n) {
        return (int)this._tabs.getTab(n).getPosition() / _cellWidth;
    }

    void toggleColumnBreak(int n) {
        int[] nArray;
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.getColumnBreakCount();
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.getColumnBreak(n3);
            if (n2 != n) continue;
            bl = true;
            break;
        }
        if (bl) {
            int n5 = 0;
            nArray = new int[n4 - 1];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = this.getColumnBreak(n3);
                if (n2 == n) continue;
                nArray[n5++] = n2;
            }
        } else {
            boolean bl2 = true;
            int n6 = 0;
            nArray = new int[n4 + 1];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = this.getColumnBreak(n3);
                if (bl2 && n < n2) {
                    bl2 = false;
                    nArray[n6++] = n;
                }
                nArray[n6++] = n2;
            }
            if (bl2) {
                nArray[n6++] = n;
            }
        }
        this.setColumnBreaks(nArray);
    }

    void setColumnBreaks(int[] nArray) {
        TabSet tabSet;
        this._tabs = null;
        int n = nArray.length;
        if (n > 0) {
            TabStop[] tabStopArray = new TabStop[n];
            for (int i = 0; i < n; ++i) {
                tabStopArray[i] = new TabStop(nArray[i] * _cellWidth);
            }
            tabSet = new TabSet(tabStopArray);
        } else {
            tabSet = null;
        }
        this.setTabSet(tabSet);
    }

    protected void setTabSet(TabSet tabSet) {
        this._tabs = tabSet;
        this.repaint();
        if (this._table != null) {
            this._table.repaint();
            if (this._table instanceof ColWidthTable) {
                ((ColWidthTable)this._table).updateSummary();
            }
        }
    }

    protected TabSet getTabSet() {
        return this._tabs;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this._table.getBounds();
        super.setBounds(n, n2, rectangle.width, n4);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.getInsets();
        _cellWidth = this._table.getCellRect((int)0, (int)0, (boolean)true).width;
        this.updateFontIfNecessary();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.drawScale(graphics, rectangle, insets);
        this.drawColumnBreaks(graphics, rectangle, insets);
    }

    protected void drawScale(Graphics graphics, Rectangle rectangle, Insets insets) {
        int n = this.getUnitsFontAscent();
        int n2 = this.getUnitsFontHeight() / 2;
        if (insets != null) {
            n += insets.top;
            n2 += insets.top;
        }
        graphics.setColor(this.getUnitsColor());
        graphics.setFont(this.getUnitsFont());
        int n3 = rectangle.x + rectangle.width;
        block4: for (int i = Math.max(0, rectangle.x / _cellWidth * _cellWidth); i <= n3; i += _cellWidth) {
            switch (i / _cellWidth % 10) {
                case 0: {
                    String string = Integer.toString(i / _cellWidth);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    graphics.drawString(string, i - fontMetrics.stringWidth(string) / 2, n);
                    continue block4;
                }
                case 5: {
                    graphics.drawLine(i, n2 - 3, i, n2 + 3);
                    continue block4;
                }
                default: {
                    graphics.drawLine(i, n2 - 1, i, n2 + 1);
                }
            }
        }
    }

    protected void drawColumnBreaks(Graphics graphics, Rectangle rectangle, Insets insets) {
        TabSet tabSet = this.getTabSet();
        int n = rectangle.x - 10;
        int n2 = rectangle.x + rectangle.width + 10;
        int n3 = this.getUnitsFontHeight() + 4;
        if (insets != null) {
            n3 += insets.top;
        }
        if (tabSet != null) {
            TabStop tabStop;
            graphics.setColor(this.getTabColor());
            do {
                if ((tabStop = tabSet.getTabAfter((float)n + 0.01f)) == null) continue;
                n = (int)tabStop.getPosition();
                if (n <= n2) {
                    this.drawBreak(graphics, n, n3);
                    continue;
                }
                tabStop = null;
            } while (tabStop != null);
        }
    }

    protected void drawBreak(Graphics graphics, int n, int n2) {
        int n3 = n - 3;
        int[] nArray = new int[]{n3, n3 + 6 + 1, n3 + 3};
        int[] nArray2 = new int[]{n2 - 4, n2 - 4, n2};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    protected Color getUnitsColor() {
        return Color.black;
    }

    protected Font getUnitsFont() {
        return this.getFont();
    }

    protected Color getTabColor() {
        return Color.black;
    }

    @Override
    public Dimension getPreferredSize() {
        this.updateFontIfNecessary();
        Insets insets = this.getInsets();
        if (insets != null) {
            return new Dimension(insets.left + insets.right + 10, insets.top + insets.bottom + this.getUnitsFontHeight() + 4);
        }
        return new Dimension(10, this.getUnitsFontHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private int getUnitsFontAscent() {
        return this._fontAscent;
    }

    private int getUnitsFontHeight() {
        return this._fontHeight;
    }

    private void updateFontIfNecessary() {
        Font font = this.getUnitsFont();
        if (this._unitsFont != font) {
            FontMetrics fontMetrics;
            this._fontAscent = 0;
            this._fontHeight = 0;
            if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
                this._fontHeight = fontMetrics.getHeight();
                this._fontAscent = fontMetrics.getAscent();
                this._unitsFont = font;
            }
        }
    }

    protected TabStop getTabClosestTo(int n) {
        TabSet tabSet = this.getTabSet();
        float f = n;
        if (tabSet != null) {
            for (int i = tabSet.getTabCount() - 1; i >= 0; --i) {
                TabStop tabStop = tabSet.getTab(i);
                if (!(f >= tabStop.getPosition() - 6.0f) || !(f <= tabStop.getPosition() + 6.0f)) continue;
                return tabStop;
            }
        }
        return null;
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected Border createBorder() {
        return DefaultBorder;
    }

    protected class MouseInputHandler
    extends MouseInputAdapter {
        protected TabStop _tab;
        protected TabSet _originalTabs;
        protected TabStop _originalTab;
        protected boolean _dragging;

        protected MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this._dragging = true;
            this._originalTabs = Ruler.this.getTabSet();
            this._originalTab = Ruler.this.getTabClosestTo(mouseEvent.getX());
            this._tab = this._originalTab == null ? this.createTabStop(mouseEvent.getX()) : null;
            this.resetTabs();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this._dragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TabStop tabStop;
            if (this._dragging && (tabStop = this.createTabStop(mouseEvent.getX())) != this._tab && (tabStop != null && this._tab != null && !tabStop.equals(this._tab) || tabStop == null || this._tab == null)) {
                this._tab = tabStop;
                this.resetTabs();
            }
        }

        protected void resetTabs() {
            TabStop[] tabStopArray;
            if (this._tab == null) {
                if (this._originalTab != null && this._originalTabs != null) {
                    int n = this._originalTabs.getTabCount();
                    if (n > 1) {
                        TabStop[] tabStopArray2 = new TabStop[n - 1];
                        int n2 = 0;
                        for (int i = 0; i < n; ++i) {
                            TabStop tabStop = this._originalTabs.getTab(i);
                            if (tabStop == this._originalTab) continue;
                            tabStopArray2[n2++] = tabStop;
                        }
                        Ruler.this.setTabSet(new TabSet(tabStopArray2));
                    } else {
                        Ruler.this.setTabSet(null);
                    }
                } else {
                    Ruler.this.setTabSet(this._originalTabs);
                }
                return;
            }
            if (this._originalTabs == null) {
                tabStopArray = new TabStop[]{this._tab};
            } else if (this._originalTab == null) {
                if (this.isTabInSet(this._tab.getPosition(), this._originalTabs)) {
                    return;
                }
                int n = this._originalTabs.getTabCount();
                int n3 = this._originalTabs.getTabIndexAfter(this._tab.getPosition());
                tabStopArray = new TabStop[n + 1];
                if (n3 == -1) {
                    for (int i = 0; i < n; ++i) {
                        tabStopArray[i] = this._originalTabs.getTab(i);
                    }
                    tabStopArray[n] = this._tab;
                } else {
                    int n4;
                    for (n4 = 0; n4 < n3; ++n4) {
                        tabStopArray[n4] = this._originalTabs.getTab(n4);
                    }
                    tabStopArray[n3] = this._tab;
                    for (n4 = n3; n4 < n; ++n4) {
                        tabStopArray[n4 + 1] = this._originalTabs.getTab(n4);
                    }
                }
            } else {
                if (this.isTabInSet(this._tab.getPosition(), this._originalTabs)) {
                    return;
                }
                int n = this._originalTabs.getTabCount();
                int n5 = this._originalTabs.getTabIndexAfter(this._tab.getPosition());
                int n6 = 0;
                tabStopArray = new TabStop[n];
                if (n5 == -1) {
                    for (int i = 0; i < n; ++i) {
                        tabStopArray[n6] = this._originalTabs.getTab(i);
                        if (tabStopArray[n6] == this._originalTab) continue;
                        ++n6;
                    }
                    tabStopArray[n6] = this._tab;
                } else {
                    int n7;
                    for (n7 = 0; n7 < n5; ++n7) {
                        tabStopArray[n6] = this._originalTabs.getTab(n7);
                        if (tabStopArray[n6] == this._originalTab) continue;
                        ++n6;
                    }
                    tabStopArray[n6++] = this._tab;
                    for (n7 = n5; n7 < n && n6 < n; ++n7) {
                        tabStopArray[n6] = this._originalTabs.getTab(n7);
                        if (tabStopArray[n6] == this._originalTab) continue;
                        ++n6;
                    }
                }
            }
            if (tabStopArray != null) {
                Ruler.this.setTabSet(new TabSet(tabStopArray));
            } else {
                Ruler.this.setTabSet(null);
            }
        }

        private boolean isTabInSet(float f, TabSet tabSet) {
            boolean bl = false;
            int n = tabSet.getTabCount();
            for (int i = 0; i < n; ++i) {
                if (tabSet.getTab(i).getPosition() != f) continue;
                bl = true;
                break;
            }
            return bl;
        }

        protected TabStop createTabStop(int n) {
            TabStop tabStop = null;
            if (n >= 0 && n < Ruler.this.getBounds().width) {
                n += 3;
                tabStop = Ruler.this.getTabClosestTo(n = n / _cellWidth * _cellWidth);
                if (tabStop == null) {
                    tabStop = new TabStop(n, 0, 0);
                }
            }
            return tabStop;
        }
    }

    protected static class RulerBorder
    implements Border {
        protected static final Insets DefaultInsets = new Insets(2, 0, 4, 0);

        protected RulerBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.darkGray);
            graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n2, n + n3, n2);
            graphics.fillRect(n, n2 + n4 - 3, n3, 2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return (Insets)DefaultInsets.clone();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

