/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.central.editor.Parser;
import com.sybase.central.editor.SCEditor;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import sybase.isql.ExportWizard;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLParser;
import sybase.isql.ISQLParserListener;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLSCEditorParser;

class RunScriptDialog
extends JDialog
implements ActionListener,
ISQLParserListener,
Runnable {
    private static final String SHOW_DETAILS = "SHOW";
    private static final String HIDE_DETAILS = "HIDE";
    private static final String CANCEL_BUTTON = "CANCEL";
    private static final String CLOSE_BUTTON = "CLOSE";
    private JFrame _parent;
    private ISQLConnection _connection;
    private ISQLResource _bundle;
    private File _scriptFile;
    private String _encoding = null;
    private JProgressBar _progressBar;
    private SybCheckBox _closeWhenDone;
    private SybButton _cancel;
    private SybButton _close;
    private JPanel _cancelClosePanel;
    private CardLayout _cancelCloseLayout;
    private SybButton _showDetails;
    private SybButton _hideDetails;
    private JPanel _showHideDetailsPanel;
    private CardLayout _showHideDetailsLayout;
    private JPanel _detailsPanel;
    private SCEditor _sql;
    private JComponent _verticalGlue;
    private SybLabel _status;
    private Thread _worker;
    private ISQLParser _parser;
    private boolean _ok = false;
    private Timer _timer = null;
    private String _deferredSQL;
    private int _deferredProgressIncrement = 0;

    static void create(JFrame jFrame, ISQLConnection iSQLConnection, File file, String string, boolean bl) {
        RunScriptDialog runScriptDialog = new RunScriptDialog(jFrame, iSQLConnection, file, string, bl);
        runScriptDialog.setVisible(true);
        runScriptDialog.destroy();
    }

    private RunScriptDialog(JFrame jFrame, ISQLConnection iSQLConnection, File file, String string, boolean bl) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        this._parent = jFrame;
        this._connection = iSQLConnection;
        this._scriptFile = file;
        this._encoding = string;
        this._bundle = ISQLResource.getISQLResource(GeneralResources.getName());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Insets insets = new Insets(0, 0, 0, 0);
        this._status = new SybLabel(this._bundle.getFormattedString("EXECUTING_FILE", this._scriptFile.getName()));
        Font font = this._status.getFont();
        font = font.deriveFont(1, font.getSize2D() * 1.25f);
        this._status.setFont(font);
        this._status.setIconTextGap(10);
        jPanel.add((Component)this._status, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this._progressBar = new JProgressBar();
        jPanel.add((Component)this._progressBar, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 21, 2, new Insets(10, 20, 10, 20), 0, 0));
        this._verticalGlue = new JPanel();
        jPanel.add((Component)this._verticalGlue, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 21, 3, insets, 0, 0));
        this._closeWhenDone = new SybCheckBox(this._bundle.getISQLString("CLOSE_THIS_DIALOG_WHEN_DONE"));
        if (bl) {
            this._closeWhenDone.setSelected(true);
        }
        jPanel.add((Component)this._closeWhenDone, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 10), 0, 0));
        this._showDetails = new SybButton(this._bundle.getISQLString("SHOW_DETAILS_BUTTON"));
        this._showDetails.addActionListener((ActionListener)this);
        this._hideDetails = new SybButton(this._bundle.getISQLString("HIDE_DETAILS_BUTTON"));
        this._hideDetails.addActionListener((ActionListener)this);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._showDetails, this._hideDetails});
        this._showHideDetailsLayout = new CardLayout();
        this._showHideDetailsPanel = new JPanel(this._showHideDetailsLayout);
        this._showHideDetailsPanel.add((Component)this._showDetails, SHOW_DETAILS);
        this._showHideDetailsPanel.add((Component)this._hideDetails, HIDE_DETAILS);
        this._showHideDetailsLayout.show(this._showHideDetailsPanel, SHOW_DETAILS);
        jPanel.add((Component)this._showHideDetailsPanel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        this._cancel = new SybButton(this._bundle.getISQLString("CANCEL_BUTTON"));
        this._cancel.addActionListener((ActionListener)this);
        this._close = new SybButton(this._bundle.getISQLString("CLOSE_BUTTON"));
        this._close.addActionListener((ActionListener)this);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._cancel, this._close});
        this._cancelCloseLayout = new CardLayout();
        this._cancelClosePanel = new JPanel(this._cancelCloseLayout);
        this._cancelClosePanel.add((Component)this._cancel, CANCEL_BUTTON);
        this._cancelClosePanel.add((Component)this._close, CLOSE_BUTTON);
        this._cancelCloseLayout.show(this._cancelClosePanel, CANCEL_BUTTON);
        jPanel.add((Component)this._cancelClosePanel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        this._detailsPanel = new JPanel(new GridBagLayout());
        this._detailsPanel.setVisible(false);
        this._detailsPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 10, 0), 0, 0));
        SybLabel sybLabel = new SybLabel(this._bundle.getISQLString("EXECUTING_SQL"));
        this._detailsPanel.add((Component)sybLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        this._sql = new SCEditor(){

            public Dimension getPreferredScrollableViewportSize() {
                int n = 5 * this.getFontMetrics(this.getFont()).getHeight();
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.height = n;
                return dimension;
            }
        };
        this._sql.setEditable(false);
        this._sql.setEditorType((Parser)ISQLSCEditorParser.getInstance());
        sybLabel.setLabelFor((Component)this._sql);
        JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
        this._detailsPanel.add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        jPanel.add((Component)this._detailsPanel, new GridBagConstraints(0, 4, 0, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        this.setTitle(this._bundle.getISQLString("RUN_SCRIPT_TITLE"));
        this.getRootPane().setContentPane(jPanel);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        UIUtils.ensureWindowIsVisible((Window)this);
        this._worker = new Thread((Runnable)this, "ScriptRunner");
        this._worker.start();
    }

    private void destroy() {
        if (this._worker != null) {
            try {
                this._worker.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._parent = null;
        this._scriptFile = null;
        this._status = null;
        this._progressBar = null;
        this._closeWhenDone = null;
        this._showDetails.removeActionListener((ActionListener)this);
        this._showDetails = null;
        this._hideDetails.removeActionListener((ActionListener)this);
        this._hideDetails = null;
        this._showHideDetailsPanel = null;
        this._showHideDetailsLayout = null;
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._close.removeActionListener((ActionListener)this);
        this._close = null;
        this._cancelClosePanel = null;
        this._cancelCloseLayout = null;
        this._sql = null;
        this._verticalGlue = null;
        this._parser = null;
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    private void reportError(Throwable throwable) {
        if (this._status == null) {
            return;
        }
        this._status.setIcon((Icon)new ExportWizard.ErrorIcon(24));
        if (throwable instanceof OutOfMemoryError) {
            SybOptionPane.showMessageDialog((Component)this, (Object)this._bundle.getISQLString("RUN_SCRIPT_OUT_OF_MEMORY_MESSAGE"), (String)this.getTitle(), (int)0);
        } else {
            DetailsErrorDialog.showDialog((Component)this, (String)this._bundle.getISQLString("RUN_SCRIPT_ERROR_TITLE"), (String)this._bundle.getISQLString("RUN_SCRIPT_ERROR_MESSAGE"), (String)throwable.getLocalizedMessage(), null);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK], 0[TRYBLOCK], 15[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deferredReportError(final Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunScriptDialog.this.reportError(throwable);
            }
        });
    }

    private void setProgressBarMaximum(int n) {
        this._progressBar.setMaximum(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        if (this._progressBar == null) {
            return;
        }
        RunScriptDialog runScriptDialog = this;
        synchronized (runScriptDialog) {
            this._progressBar.setValue(this._progressBar.getValue() + this._deferredProgressIncrement);
            this._sql.setText(this._deferredSQL);
            this._deferredSQL = null;
            this._deferredProgressIncrement = 0;
            if (this._timer == null) {
                this._timer = new Timer(500, this);
                this._timer.setRepeats(false);
            }
            this._timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferredUpdateStatus() {
        if (this._progressBar == null) {
            return;
        }
        RunScriptDialog runScriptDialog = this;
        synchronized (runScriptDialog) {
            if (this._deferredSQL == null) {
                return;
            }
            this._progressBar.setValue(this._progressBar.getValue() + this._deferredProgressIncrement);
            this._sql.setText(this._deferredSQL);
            this._deferredSQL = null;
            this._deferredProgressIncrement = 0;
        }
    }

    private void setDone() {
        if (this._status == null) {
            return;
        }
        this._progressBar.setValue(this._progressBar.getMaximum());
        this._sql.setText("");
        if (this._ok && this._parser.getErrorStartLine() == -1) {
            this._status.setText(this._bundle.getISQLString("EXECUTION_COMPLETE"));
            this._status.setIcon((Icon)new ExportWizard.OKIcon(24));
        } else {
            this._status.setText(this._bundle.getISQLString("EXECUTION_TERMINATED"));
            this._status.setIcon((Icon)new ExportWizard.ErrorIcon(24));
        }
        if (this._closeWhenDone.isSelected()) {
            this.setVisible(false);
        } else {
            this._cancelCloseLayout.show(this._cancelClosePanel, CLOSE_BUTTON);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._close) {
            this._close.setEnabled(false);
            this.setVisible(false);
        } else if (object == this._cancel) {
            this._cancel.setEnabled(false);
            this._parser.interrupt();
            this._connection.interrupt();
            this.setVisible(false);
        } else if (object == this._showDetails) {
            this._showHideDetailsLayout.show(this._showHideDetailsPanel, HIDE_DETAILS);
            this._verticalGlue.setVisible(false);
            this._detailsPanel.setVisible(true);
            this.pack();
        } else if (object == this._hideDetails) {
            this._showHideDetailsLayout.show(this._showHideDetailsPanel, SHOW_DETAILS);
            this._verticalGlue.setVisible(true);
            this._detailsPanel.setVisible(false);
            this.pack();
        } else if (object == this._timer) {
            this.deferredUpdateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStatementExecution(String string, int n, int n2, int n3, int n4) {
        RunScriptDialog runScriptDialog = this;
        synchronized (runScriptDialog) {
            this._deferredSQL = string;
            ++this._deferredProgressIncrement;
            if (this._timer == null || !this._timer.isRunning()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RunScriptDialog.this.updateStatus();
                    }
                });
            }
        }
    }
}

