/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.resultSetTable.ScrollableResultSet;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import sybase.isql.DataTypeMetaData;
import sybase.isql.ErrorMessages;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.Importer;
import sybase.isql.ImporterFailedException;
import sybase.isql.InputOutputOptions;
import sybase.isql.InputStatement;
import sybase.isql.TableGenitor;
import sybase.isql.TextImporter;
import sybase.isql.isql;

class SQLImporter
implements Importer,
TableGenitor {
    private InputOutputOptions _options = null;
    private String _line = null;
    private int _columnCount = 0;
    private String[] _columnName = null;
    private DataTypeMetaData[] _columnTypeMetaData = null;
    private int[] _columnWidth = null;
    private int[] _columnScale = null;

    SQLImporter(InputOutputOptions inputOutputOptions) {
        this._options = inputOutputOptions;
    }

    @Override
    public boolean open(ISQLConnection iSQLConnection) {
        return true;
    }

    @Override
    public void readMetaData(ISQLConnection iSQLConnection) throws ImporterFailedException {
        boolean bl = true;
        int n = ((ISQLConnectionImpl)iSQLConnection).getResultSetCount(true);
        ISQLResultSet iSQLResultSet = n > 0 ? ((ISQLConnectionImpl)iSQLConnection).getResultSet(n - 1, true) : null;
        if (iSQLResultSet == null) {
            throw new ImporterFailedException(ISQLResource.getISQLString(ErrorMessages.getName(), "NoCurrentQuery"));
        }
        ScrollableResultSet scrollableResultSet = iSQLResultSet.getScrollableResultSet();
        String string = null;
        String string2 = null;
        for (int i = 0; i < scrollableResultSet.getColumnCount(); ++i) {
            String string3 = scrollableResultSet.getColumnTableName(i);
            String string4 = scrollableResultSet.getColumnSchemaName(i);
            if (i == 0) {
                string = string3;
                string2 = string4;
                if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) continue;
                bl = false;
                break;
            }
            if (string3 != null && string3.length() != 0 && string4 != null && string4.length() != 0 && string.equalsIgnoreCase(string3) && string2.equalsIgnoreCase(string4)) continue;
            bl = false;
            break;
        }
        if (!bl) {
            throw new ImporterFailedException(ISQLResource.getISQLString(ErrorMessages.getName(), "CannotImportIntoJoin"));
        }
    }

    @Override
    public boolean createTable(ISQLConnection iSQLConnection) {
        return true;
    }

    @Override
    public boolean populateTable(ISQLConnection iSQLConnection) throws ImporterFailedException {
        boolean bl = false;
        int n = ((ISQLConnectionImpl)iSQLConnection).getResultSetCount(true);
        ISQLResultSet iSQLResultSet = n > 0 ? ((ISQLConnectionImpl)iSQLConnection).getResultSet(n - 1, true) : null;
        if (iSQLResultSet != null) {
            String string = null;
            String string2 = null;
            ScrollableResultSet scrollableResultSet = iSQLResultSet.getScrollableResultSet();
            if (scrollableResultSet != null && scrollableResultSet.getColumnCount() > 0) {
                string2 = scrollableResultSet.getColumnTableName(0);
                string = scrollableResultSet.getColumnSchemaName(0);
            }
            if (string2 == null) {
                return false;
            }
            this._columnCount = iSQLResultSet.getColumnCount();
            this._columnName = new String[this._columnCount];
            this._columnTypeMetaData = new DataTypeMetaData[this._columnCount];
            this._columnWidth = new int[this._columnCount];
            this._columnScale = new int[this._columnCount];
            for (int i = 0; i < this._columnCount; ++i) {
                this._columnName[i] = iSQLResultSet.getColumnName(i);
                this._columnTypeMetaData[i] = ((ISQLConnectionImpl)iSQLConnection).getDataTypeMetaData(iSQLResultSet.getColumnSQLType(i), null, iSQLResultSet.getPrecision(i), iSQLResultSet.getScale(i));
                this._columnWidth[i] = iSQLResultSet.getColumnWidth(i);
                this._columnScale[i] = iSQLResultSet.getScale(i);
            }
            bl = iSQLConnection.addTableData(null, string, string2, this);
            iSQLResultSet = null;
        } else {
            isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "NoCurrentQuery"), 2);
        }
        return bl;
    }

    @Override
    public boolean close() {
        this._columnCount = 0;
        this._columnName = null;
        this._columnTypeMetaData = null;
        this._columnWidth = null;
        this._columnScale = null;
        return true;
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public boolean knowsColumnNames() {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return this._columnName[n];
    }

    @Override
    public DataTypeMetaData getColumnTypeMetaData(int n) {
        return this._columnTypeMetaData[n];
    }

    @Override
    public int getColumnWidth(int n) {
        return this._columnWidth[n];
    }

    @Override
    public int getColumnScale(int n) {
        return this._columnScale[n];
    }

    @Override
    public boolean isColumnInPrimaryKey(int n) {
        return false;
    }

    @Override
    public boolean isNullableColumn(int n) {
        return true;
    }

    @Override
    public Vector<Object> getRowData() {
        Vector<Object> vector = this._line != null ? TextImporter.getAsciiRowData(this._options, this._line) : null;
        return vector;
    }

    @Override
    public boolean moveNext() {
        try {
            this._line = this._options.getSQLReader().readLine();
        }
        catch (ImporterFailedException importerFailedException) {
            this._line = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._line = null;
        }
        return this._line != null;
    }

    @Override
    public boolean keepGoing(ISQLConnection iSQLConnection) {
        return InputStatement.keepGoing(iSQLConnection);
    }
}

