/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.ianywhere.textCompleter.SCEditorWithTextCompleter;
import com.ianywhere.textCompleter.TextCompleter;
import com.ianywhere.textCompleter.TextCompleterAdapter;
import com.ianywhere.textCompleter.TextCompleterClient;
import com.sybase.central.editor.SCEditor;
import com.sybase.customization.CustomizationPage;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybTextArea;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import sybase.isql.CustomizationPageProxy;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLParser;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLSCEditorParser;
import sybase.isql.ParentFrame;
import sybase.isql.ParserUtils;
import sybase.isql.PluginMgr;
import sybase.isql.StatementLocation;

class SQLTextComponent
extends SCEditorWithTextCompleter
implements UndoableEditListener,
DocumentListener,
CaretListener {
    private Insets _insets = new Insets(2, 2, 2, 2);
    private Action _undoAction = null;
    private Action _redoAction = null;
    private boolean _addSelectLineAndStatementMenuItems = true;
    private ArrayList<StatementLocation> _statementLocations = null;

    static JComponent newInstanceOnScrollPane(int n, int n2, String string) {
        SQLTextComponent sQLTextComponent = SQLTextComponent.newInstance(n, n2);
        sQLTextComponent.setText(string);
        sQLTextComponent.setEditable(false);
        MyJScrollPane myJScrollPane = new MyJScrollPane(sQLTextComponent);
        SybTextArea sybTextArea = new SybTextArea(n, n2);
        Insets insets = sQLTextComponent.getInsets();
        Dimension dimension = sybTextArea.getPreferredSize();
        Dimension dimension2 = myJScrollPane.getSize();
        dimension2.height = Math.max(dimension2.height, dimension.height) + insets.top + insets.bottom;
        dimension2.width = Math.max(dimension2.width, dimension.width) + insets.left + insets.right;
        myJScrollPane.setPreferredSize(dimension2);
        return myJScrollPane;
    }

    static SQLTextComponent newInstance(int n, int n2) {
        SQLTextComponent sQLTextComponent = new SQLTextComponent();
        sQLTextComponent.setEditorType(ISQLSCEditorParser.getInstance());
        sQLTextComponent.addCaretListener(sQLTextComponent);
        return sQLTextComponent;
    }

    static void release(JComponent object) {
        if (object instanceof SQLTextComponent) {
            ((SQLTextComponent)object).release();
        } else if (object instanceof MyJScrollPane) {
            object = ((MyJScrollPane)object)._c;
            ((SQLTextComponent)object).release();
        }
    }

    void release() {
        this.removeCaretListener(this);
        this._undoAction = null;
        this._redoAction = null;
        this.destroy();
    }

    private SQLTextComponent() {
        this.setTextCompleterClient((TextCompleterClient)new MyTextCompleterClient((JTextComponent)((Object)this)));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("document")) {
                    SQLTextComponent.this._statementLocations = null;
                }
            }
        });
    }

    public Insets getInsets() {
        return this._insets;
    }

    public void setUndoAction(Action action) {
        this._undoAction = action;
    }

    public void setRedoAction(Action action) {
        this._redoAction = action;
    }

    private void updateUndoState() {
        if (this._undoAction != null) {
            this._undoAction.setEnabled(this.getUndoManager().canUndo());
        }
    }

    private void updateRedoState() {
        if (this._redoAction != null) {
            this._redoAction.setEnabled(this.getUndoManager().canRedo());
        }
    }

    public boolean canUndo() {
        return this.getUndoManager().canUndo();
    }

    public boolean canRedo() {
        return this.getUndoManager().canRedo();
    }

    public void undo() {
        if (this.getUndoManager().canUndo()) {
            this.getUndoManager().undo();
        }
    }

    public void redo() {
        if (this.getUndoManager().canRedo()) {
            this.getUndoManager().redo();
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        super.undoableEditHappened(undoableEditEvent);
        this.updateUndoState();
        this.updateRedoState();
    }

    private void getStatementLocations() {
        if (this._statementLocations == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String string = this.getText();
            if (string.length() > 0 && !string.endsWith("\r\n")) {
                string = string.concat("\r\n");
            }
            StringReader stringReader = new StringReader(string);
            ISQLParser iSQLParser = ParserUtils.getParser(null, null, stringReader);
            this._statementLocations = iSQLParser.getStatementLocations();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    boolean selectStatement(int n) {
        boolean bl = false;
        int n2 = n + 1;
        this.getStatementLocations();
        for (int i = 0; i < this._statementLocations.size(); ++i) {
            StatementLocation statementLocation = this._statementLocations.get(i);
            if (statementLocation.startLine > n2 || n2 > statementLocation.endLine) continue;
            int n3 = this.getDot(statementLocation.startLine, statementLocation.startColumn);
            int n4 = this.getDot(statementLocation.endLine, statementLocation.endColumn);
            this.setCaretPosition(n4);
            this.moveCaretPosition(n3);
            bl = true;
            break;
        }
        return bl;
    }

    void selectPreviousStatement() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = this.getCaret().getDot();
        Point point = this.getCaretLineAndColumn(n3);
        this.getStatementLocations();
        for (int i = this._statementLocations.size() - 1; i > 0; --i) {
            boolean bl2;
            StatementLocation statementLocation = this._statementLocations.get(i - 1);
            StatementLocation statementLocation2 = this._statementLocations.get(i);
            boolean bl3 = bl2 = (statementLocation.endLine < point.y || statementLocation.endLine == point.y && statementLocation.endColumn <= point.x) && (point.y < statementLocation2.endLine || statementLocation2.endLine == point.y && statementLocation2.endColumn >= point.x);
            if (bl2) {
                n = this.getDot(statementLocation.startLine, statementLocation.startColumn);
                n2 = this.getDot(statementLocation.endLine, statementLocation.endColumn);
                bl = true;
                break;
            }
            if (i != this._statementLocations.size() - 1 || statementLocation2.endLine >= point.y && (statementLocation2.endLine != point.y || statementLocation2.endColumn >= point.x)) continue;
            n = this.getDot(statementLocation2.startLine, statementLocation2.startColumn);
            n2 = this.getDot(statementLocation2.endLine, statementLocation2.endColumn);
            bl = true;
            break;
        }
        if (bl) {
            this.setCaretPosition(n2);
            this.moveCaretPosition(n);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    boolean selectNextStatement() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = this.getSelectionEnd();
        Point point = this.getCaretLineAndColumn(n3);
        this.getStatementLocations();
        for (int i = 0; i < this._statementLocations.size() - 1; ++i) {
            boolean bl2;
            StatementLocation statementLocation = this._statementLocations.get(i);
            StatementLocation statementLocation2 = this._statementLocations.get(i + 1);
            boolean bl3 = bl2 = (statementLocation.startLine < point.y || statementLocation.startLine == point.y && statementLocation.startColumn <= point.x) && (point.y < statementLocation2.startLine || statementLocation2.startLine == point.y && point.x < statementLocation2.startColumn);
            if (bl2) {
                n = this.getDot(statementLocation2.startLine, statementLocation2.startColumn);
                n2 = this.getDot(statementLocation2.endLine, statementLocation2.endColumn);
                bl = true;
                break;
            }
            if (i != 0 || point.y >= statementLocation.startLine && (point.y != statementLocation.startLine || point.x > statementLocation.startColumn)) continue;
            n = this.getDot(statementLocation.startLine, statementLocation.startColumn);
            n2 = this.getDot(statementLocation.endLine, statementLocation.endColumn);
            bl = true;
            break;
        }
        if (bl) {
            this.setCaretPosition(n2);
            this.moveCaretPosition(n);
            this.ensureSelectionIsVisible();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return bl;
    }

    private int getDot(int n, int n2) {
        int n3 = 0;
        String string = this.getText();
        int n4 = this.getIndentSize();
        int n5 = 1;
        int n6 = 1;
        for (int i = 0; i < string.length() && (n5 != n || n6 != n2); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                ++n5;
                n6 = 1;
                ++n3;
                continue;
            }
            if (c == '\t') {
                int n7 = n4 - (n6 - 1) % n4;
                n6 += n7;
                ++n3;
                continue;
            }
            if (c == '\r') continue;
            ++n6;
            ++n3;
        }
        return n3;
    }

    void ensureSelectionIsVisible() {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        try {
            Rectangle rectangle = this.modelToView(n);
            Rectangle rectangle2 = this.modelToView(n2);
            this.scrollRectToVisible(rectangle.union(rectangle2));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this._statementLocations = null;
        super.changedUpdate(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this._statementLocations = null;
        super.insertUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this._statementLocations = null;
        super.removeUpdate(documentEvent);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updateLineAndColumnLabel(caretEvent.getDot());
    }

    void updateStatusBarInformation() {
        this.updateLineAndColumnLabel(this.getCaret().getDot());
    }

    private void updateLineAndColumnLabel(int n) {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (window != null && window instanceof ParentFrame) {
            Point point = this.getCaretLineAndColumn(n);
            ((ParentFrame)window).updateCursorLocation(point.y, point.x);
        }
    }

    void selectCurrentLine() {
        this.requestFocusInWindow();
        int n = this.getCaretLineAndColumn().y - 1;
        this.setSelectedLines(n, n, false);
    }

    boolean selectCurrentStatement() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        this.requestFocusInWindow();
        int n3 = this.getSelectionEnd();
        Point point = this.getCaretLineAndColumn(n3);
        this.getStatementLocations();
        for (int i = 0; i < this._statementLocations.size(); ++i) {
            boolean bl2;
            StatementLocation statementLocation = this._statementLocations.get(i);
            if (statementLocation.startLine > point.y) {
                bl2 = true;
            } else {
                boolean bl3 = bl2 = (statementLocation.startLine < point.y || statementLocation.startLine == point.y && statementLocation.startColumn <= point.x) && (point.y < statementLocation.endLine || statementLocation.endLine == point.y && point.x <= statementLocation.endColumn);
            }
            if (!bl2) continue;
            n = this.getDot(statementLocation.startLine, statementLocation.startColumn);
            n2 = this.getDot(statementLocation.endLine, statementLocation.endColumn);
            bl = true;
            break;
        }
        if (bl) {
            this.setCaretPosition(n2);
            this.moveCaretPosition(n);
        }
        return bl;
    }

    public JPopupMenu getPopupMenu() {
        ParentFrame parentFrame = null;
        ISQLPlugin iSQLPlugin = null;
        JPopupMenu jPopupMenu = super.getPopupMenu();
        if (this._addSelectLineAndStatementMenuItems) {
            this._addSelectLineAndStatementMenuItems = false;
            jPopupMenu.insert(new JSeparator(), 0);
            jPopupMenu.insert((Component)((Object)new SelectLineMenuItem()), 0);
            jPopupMenu.insert((Component)((Object)new SelectStatementMenuItem()), 0);
        }
        try {
            char c;
            int n;
            for (n = this.getCaret().getMark(); n > 0 && !Character.isWhitespace(c = this.getText(n - 1, 1).charAt(0)); --n) {
            }
            int n2 = Math.min(n + 256, this.getDocument().getLength());
            String[] stringArray = null;
            String string = this.getText(n, n2 - n);
            parentFrame = (ParentFrame)SwingUtilities.getAncestorOfClass(ParentFrame.class, (Component)((Object)this));
            if (parentFrame != null) {
                ISQLPlugin[] iSQLPluginArray;
                ISQLConnectionImpl iSQLConnectionImpl = (ISQLConnectionImpl)parentFrame.getConnection();
                iSQLPlugin = iSQLConnectionImpl.getPlugin();
                if (iSQLPlugin == null && (iSQLPluginArray = PluginMgr.getPluginList()).length > 0) {
                    iSQLPlugin = iSQLPluginArray[0];
                }
                if (iSQLPlugin != null) {
                    stringArray = iSQLPlugin.getHelpIDForSQL(string);
                }
            }
            Component component = jPopupMenu.getComponentCount() > 0 ? jPopupMenu.getComponent(0) : null;
            if (stringArray != null) {
                HelpMenuItem helpMenuItem;
                String string2 = ISQLResource.getFormattedString(ErrorMessages.getName(), "HelpForStatement", (String)stringArray[1]);
                if (component != null && component instanceof HelpMenuItem) {
                    helpMenuItem = (HelpMenuItem)((Object)component);
                    helpMenuItem.setText(string2);
                } else {
                    helpMenuItem = new HelpMenuItem(string2);
                    jPopupMenu.insert(new JSeparator(), 0);
                    jPopupMenu.insert((Component)((Object)helpMenuItem), 0);
                }
                helpMenuItem.setHelpKey(stringArray[0]);
                helpMenuItem.setPlugin(iSQLPlugin);
                helpMenuItem.setParent(parentFrame);
            } else if (component != null && component instanceof HelpMenuItem) {
                ((HelpMenuItem)((Object)component)).destroy();
                jPopupMenu.remove(1);
                jPopupMenu.remove(0);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return jPopupMenu;
    }

    void setSelectedLines(int n, int n2) {
        this.setSelectedLines(n, n2, false);
    }

    void setSelectedLines(int n, int n2, boolean bl) {
        int n3 = this.getSelectionStart();
        int n4 = this.getSelectionEnd();
        this.goTo(n2 + 1 + 1);
        int n5 = this.getCaretPosition();
        this.goTo(n + 1);
        int n6 = this.getCaretPosition();
        if (bl) {
            int n7;
            int n8;
            if (n3 < n4) {
                n8 = n3;
                n7 = n4;
            } else {
                n8 = n4;
                n7 = n3;
            }
            if (n8 < n6) {
                n6 = n8;
            }
            if (n7 > n5) {
                n5 = n7;
            }
        }
        this.setCaretPosition(n5);
        this.moveCaretPosition(n6);
    }

    public CustomizationPage[] getCustomizationPages() {
        ParentFrame parentFrame;
        CustomizationPage[] customizationPageArray = super.getCustomizationPages();
        if (customizationPageArray != null && (parentFrame = (ParentFrame)SwingUtilities.getAncestorOfClass(ParentFrame.class, (Component)((Object)this))) != null) {
            ISQLConnectionImpl iSQLConnectionImpl = (ISQLConnectionImpl)parentFrame.getConnection();
            for (int i = 0; i < customizationPageArray.length; ++i) {
                Object object = Proxy.newProxyInstance(customizationPageArray[i].getClass().getClassLoader(), new Class[]{CustomizationPage.class}, (InvocationHandler)new CustomizationPageProxy(parentFrame, iSQLConnectionImpl, customizationPageArray[i]));
                customizationPageArray[i] = (CustomizationPage)object;
            }
        }
        return customizationPageArray;
    }

    static {
        SCEditor.setHelpFolder((String)ISQLHelpManager.getHelpFolder(null), (String)ISQLHelpManager.getHelpPrefix(null), (String)ISQLHelpManager.getHelpSuffix(null));
        TextCompleter.setHelpFolder((String)ISQLHelpManager.getHelpFolder(null), (String)ISQLHelpManager.getHelpPrefix(null), (String)ISQLHelpManager.getHelpSuffix(null));
    }

    class SelectStatementMenuItem
    extends SybMenuItem
    implements ActionListener {
        SelectStatementMenuItem() {
            super(ISQLResource.getISQLString(GeneralResources.getName(), "EDITOR_MENU_SELECT_STATEMENT"));
            this.addActionListener(this);
        }

        void destroy() {
            this.removeActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SQLTextComponent.this.selectCurrentStatement();
        }
    }

    class SelectLineMenuItem
    extends SybMenuItem
    implements ActionListener {
        SelectLineMenuItem() {
            super(ISQLResource.getISQLString(GeneralResources.getName(), "EDITOR_MENU_SELECT_LINE"));
            this.addActionListener(this);
        }

        void destroy() {
            this.removeActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SQLTextComponent.this.selectCurrentLine();
        }
    }

    private static class HelpMenuItem
    extends SybMenuItem
    implements ActionListener {
        private String _helpKey;
        private ISQLPlugin _plugin;
        private Window _parent;

        HelpMenuItem(String string) {
            super(string);
            this.addActionListener(this);
        }

        void setHelpKey(String string) {
            this._helpKey = string;
        }

        void setPlugin(ISQLPlugin iSQLPlugin) {
            this._plugin = iSQLPlugin;
        }

        void setParent(Window window) {
            this._parent = window;
        }

        void destroy() {
            this._helpKey = null;
            this._plugin = null;
            this._parent = null;
            this.removeActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._plugin.showHelp(this._parent, this._helpKey);
        }
    }

    static class MyTextCompleterClient
    extends TextCompleterAdapter {
        private JTextComponent _editor;

        MyTextCompleterClient(JTextComponent jTextComponent) {
            this._editor = jTextComponent;
        }

        public Connection getConnection() {
            ParentFrame parentFrame = (ParentFrame)SwingUtilities.getAncestorOfClass(ParentFrame.class, this._editor);
            Connection connection = parentFrame != null ? parentFrame.getConnection().getJDBCConnection() : null;
            return connection;
        }
    }

    static class MyJScrollPane
    extends JScrollPane {
        SQLTextComponent _c;

        MyJScrollPane(SQLTextComponent sQLTextComponent) {
            super((Component)((Object)sQLTextComponent));
            this._c = sQLTextComponent;
        }
    }
}

