/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.customization.CustomizeDialog;
import com.sybase.util.Platform;
import com.sybase.util.SCC;
import com.sybase.util.SCCException;
import com.sybase.util.SCCFactory;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import sybase.isql.BasePage;
import sybase.isql.Dbg;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;
import sybase.isql.Preferences;
import sybase.isql.WindowManager;

class SourceControlPage
extends BasePage
implements ActionListener,
ItemListener {
    private boolean _opt_enableSourceControl;
    private String _opt_sourceControlSystem;
    private boolean _opt_autoCheckout;
    private SybCheckBox _enableSourceControl = null;
    private SybButton _configure = null;
    private SybLabel _label = null;
    private SybRadioButton _win32SCC = null;
    private SybRadioButton _customSCC = null;
    private SybCheckBox _autoCheckout = null;
    private SybMultiLineLabel _aboutCustom = null;
    private SCC _scc = null;
    private boolean _eventListenersAdded = false;
    private String _customSourceControlName;
    private String _defaultSourceControlName;

    SourceControlPage(CustomizeDialog customizeDialog, ISQLConnection iSQLConnection) {
        super(customizeDialog, iSQLConnection);
        this.readSettings();
        this.createUI();
    }

    private void readSettings() {
        String string = Preferences.getSourceControlSystem();
        boolean bl = this._opt_enableSourceControl = string != null && string.length() != 0;
        if (this._opt_enableSourceControl) {
            this._opt_sourceControlSystem = string;
            this._opt_autoCheckout = Preferences.getBooleanOption(this._connection, "autoCheckout", false);
        } else {
            this._opt_autoCheckout = true;
        }
    }

    private void saveSettings() {
        Preferences.setSourceControlSystem(this._opt_sourceControlSystem);
        Preferences.setBooleanOption(this._connection, "autoCheckout", this._opt_autoCheckout);
    }

    private void createUI() {
        this._customSourceControlName = SCCFactory.getCustomSourceControlName();
        this._defaultSourceControlName = SCCFactory.getDefaultSourceControlName();
        if (this._defaultSourceControlName != null && this._defaultSourceControlName.equals(this._customSourceControlName)) {
            this._defaultSourceControlName = null;
        }
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(iSQLResource.getISQLString("AboutSourceControl"));
        this._enableSourceControl = new SybCheckBox(iSQLResource.getISQLString("EnableSourceControl"));
        if (Platform.isWindows() && this._defaultSourceControlName != null) {
            this._win32SCC = new SybRadioButton(ISQLResource.getFormattedString(GeneralResources.getName(), "CurrentSourceControlSystem", this._defaultSourceControlName));
            this._customSCC = new SybRadioButton(ISQLResource.getISQLString(GeneralResources.getName(), "CustomSourceControlSystem"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._win32SCC);
            buttonGroup.add((AbstractButton)this._customSCC);
        }
        this._configure = new SybButton(iSQLResource.getISQLString("ConfigureSourceControl"));
        this._autoCheckout = new SybCheckBox(iSQLResource.getISQLString("AutoCheckout"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.gridwidth = 0;
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)sybMultiLineLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._enableSourceControl, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        if (this._win32SCC != null) {
            this._label = new SybLabel(iSQLResource.getISQLString("SourceControlSystem"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this._label, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this._win32SCC, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this._customSCC, gridBagConstraints);
            gridBagConstraints.insets.left += 20;
            this._aboutCustom = new SybMultiLineLabel(iSQLResource.getISQLString("AboutCustomSCCOnWindows"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            this.add((Component)this._aboutCustom, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            this.add((Component)this._configure, gridBagConstraints);
            gridBagConstraints.insets.left -= 20;
        } else {
            this._aboutCustom = new SybMultiLineLabel(iSQLResource.getISQLString("AboutCustomSCC"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            this.add((Component)this._aboutCustom, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            this.add((Component)this._configure, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        this.add((Component)this._autoCheckout, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    @Override
    public void initialize() {
        this.removeListeners();
        this._enableSourceControl.setSelected(this._opt_enableSourceControl);
        this._autoCheckout.setSelected(this._opt_autoCheckout);
        if (this._win32SCC != null) {
            if (this._opt_sourceControlSystem != null && this._opt_sourceControlSystem.equals(this._customSourceControlName)) {
                this._customSCC.setSelected(true);
            } else {
                this._win32SCC.setSelected(true);
            }
        }
        this.enableControls();
        this.addListeners();
    }

    private void addListeners() {
        this._configure.addActionListener((ActionListener)this);
        this._enableSourceControl.addActionListener((ActionListener)this);
        if (this._win32SCC != null) {
            this._win32SCC.addItemListener((ItemListener)this);
            this._customSCC.addItemListener((ItemListener)this);
        }
    }

    private void removeListeners() {
        this._configure.removeActionListener((ActionListener)this);
        this._enableSourceControl.removeActionListener((ActionListener)this);
        if (this._win32SCC != null) {
            this._win32SCC.removeItemListener((ItemListener)this);
            this._customSCC.removeItemListener((ItemListener)this);
        }
    }

    public String getTitle() {
        return ISQLResource.getISQLString(GeneralResources.getName(), "SourceControlPageTitle");
    }

    public void showHelp() {
        ISQLHelpManager.showHelp((ISQLConnectionImpl)this._connection, (Window)this._parent, "HELP_ISQL_OPTIONS_SOURCE_CONTROL");
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public void acceptChanges() {
        boolean bl = false;
        boolean bl2 = this._enableSourceControl.isSelected();
        if (bl2 != this._opt_enableSourceControl) {
            this._opt_enableSourceControl = bl2;
            bl = true;
        }
        if (this._opt_enableSourceControl) {
            String string = this._customSourceControlName;
            if (this._win32SCC != null && this._win32SCC.isSelected()) {
                string = this._defaultSourceControlName;
            }
            if (!string.equals(this._opt_sourceControlSystem)) {
                this._opt_sourceControlSystem = string;
                bl = true;
            }
        } else {
            this._opt_sourceControlSystem = null;
        }
        this._opt_autoCheckout = this._autoCheckout.isSelected();
        this.saveSettings();
        if (bl) {
            Preferences.setSourceControlUser(Preferences.DEFAULT_SOURCE_CONTROL_USER);
            Preferences.setSourceControlProject(Preferences.DEFAULT_SOURCE_CONTROL_PROJECT);
            Preferences.setSourceControlProjectPath(Preferences.DEFAULT_SOURCE_CONTROL_PROJPATH);
            Preferences.setSourceControlAuxProjectPath(Preferences.DEFAULT_SOURCE_CONTROL_AUXPROJPATH);
            WindowManager.getWindowManager().discardSCC();
            if (bl2) {
                WindowManager.getWindowManager().getSCC();
            }
        }
    }

    @Override
    public void destroy() {
        this.removeListeners();
        this._configure = null;
        this._enableSourceControl = null;
        this._autoCheckout = null;
        this._win32SCC = null;
        this._customSCC = null;
        this._label = null;
        this._aboutCustom = null;
        super.destroy();
    }

    @Override
    public Icon getCustomizationGroupIcon() {
        return ISQLImages.getImageIcon("sourcecontrol2");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._configure) {
            this.handleConfigure();
        } else if (object == this._enableSourceControl) {
            this.enableControls();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConfigure() {
        SCC sCC = null;
        int[] nArray = new int[]{0, 1, 2, 3, 6, 7, 9};
        try {
            sCC = SCCFactory.getSCC(null, (String)this._customSourceControlName, (String)"dbisql");
            this._configure.setEnabled(false);
            sCC.getCommandOptions(10, (Window)this._parent, nArray);
        }
        catch (SCCException sCCException) {
            Dbg.printlnEx((Throwable)sCCException, (String)"Could not call getCommandOptions");
        }
        finally {
            if (sCC != null) {
                sCC.destroy();
            }
            this._configure.setEnabled(true);
        }
    }

    private void enableControls() {
        boolean bl = this._enableSourceControl.isSelected();
        if (this._win32SCC != null) {
            this._label.setEnabled(bl);
            this._win32SCC.setEnabled(bl);
            this._customSCC.setEnabled(bl);
        }
        this._aboutCustom.setEnabled(bl);
        this._autoCheckout.setEnabled(bl);
        if (bl && this._win32SCC != null && this._win32SCC.isSelected()) {
            bl = false;
        }
        this._configure.setEnabled(bl);
    }
}

