/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import sybase.isql.ColumnInfo;
import sybase.isql.ISQLResultSet;
import sybase.isql.StaticResultSetMetaData;

class StaticResultSet
implements InvocationHandler {
    private ColumnInfo[] _columnInfo;
    private Object[][] _data;
    private int _currentRow = -1;
    private Object _lastValue = null;
    private ResultSetMetaData _metaData = null;

    static ResultSet newInstance(ColumnInfo[] columnInfoArray, Object[][] objectArray) {
        Object object = Proxy.newProxyInstance(columnInfoArray.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new StaticResultSet(columnInfoArray, objectArray));
        return (ResultSet)object;
    }

    private StaticResultSet(ColumnInfo[] columnInfoArray, Object[][] objectArray) {
        this._columnInfo = columnInfoArray;
        this._data = objectArray;
    }

    static boolean isStaticResultSet(ISQLResultSet iSQLResultSet) {
        ResultSet resultSet = iSQLResultSet.getScrollableResultSet().getJDBCResultSet();
        return StaticResultSet.isStaticResultSet(resultSet);
    }

    static boolean isStaticResultSet(ResultSet resultSet) {
        boolean bl = resultSet instanceof Proxy;
        return bl;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        String string = method.getName();
        if (string.equals("next")) {
            if (this._currentRow < this._data.length) {
                ++this._currentRow;
            }
            object2 = this._currentRow != this._data.length;
        } else if (string.equals("getString")) {
            int n = (Integer)objectArray[0];
            this._lastValue = this._data[this._currentRow][n - 1];
            object2 = this._lastValue == null ? null : this._lastValue.toString();
        } else if (string.equals("getBoolean")) {
            int n = (Integer)objectArray[0];
            object2 = this._lastValue = this._data[this._currentRow][n - 1];
        } else if (string.equals("getInt")) {
            int n = (Integer)objectArray[0];
            this._lastValue = this._data[this._currentRow][n - 1];
            object2 = this._lastValue == null ? null : (Integer)this._lastValue;
        } else if (string.equals("getLong")) {
            int n = (Integer)objectArray[0];
            this._lastValue = this._data[this._currentRow][n - 1];
            object2 = this._lastValue == null ? null : (this._lastValue instanceof Integer ? Long.valueOf(((Integer)this._lastValue).longValue()) : (Long)this._lastValue);
        } else if (string.equals("wasNull")) {
            object2 = this._lastValue == null;
        } else if (string.equals("getConcurrency")) {
            object2 = 1007;
        } else if (string.equals("getStatement")) {
            object2 = null;
        } else if (string.equals("getMetaData")) {
            if (this._metaData == null) {
                this._metaData = StaticResultSetMetaData.newInstance(this._columnInfo);
            }
            object2 = this._metaData;
        } else if (!(string.equals("close") || string.equals("clearWarnings") || string.equals("getWarnings"))) {
            if (string.equals("hashCode")) {
                object2 = this.hashCode();
            } else if (string.equals("isClosed")) {
                object2 = Boolean.FALSE;
            } else {
                throw new SQLException(string + " not implemented");
            }
        }
        return object2;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

