/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import sybase.isql.ColumnInfo;

class StaticResultSetMetaData
implements InvocationHandler {
    private ColumnInfo[] _columnInfo;

    static ResultSetMetaData newInstance(ColumnInfo[] columnInfoArray) {
        Object object = Proxy.newProxyInstance(columnInfoArray.getClass().getClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new StaticResultSetMetaData(columnInfoArray));
        return (ResultSetMetaData)object;
    }

    private StaticResultSetMetaData(ColumnInfo[] columnInfoArray) {
        this._columnInfo = columnInfoArray;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        String string = method.getName();
        if (string.equals("getColumnCount")) {
            object2 = this._columnInfo.length;
        } else if (string.equals("getColumnDisplaySize") || string.equals("getPrecision")) {
            int n = (Integer)objectArray[0];
            object2 = this._columnInfo[n - 1].width;
        } else if (string.equals("getScale")) {
            int n = (Integer)objectArray[0];
            object2 = this._columnInfo[n - 1].scale;
        } else if (string.equals("getColumnName") || string.equals("getColumnLabel")) {
            int n = (Integer)objectArray[0];
            object2 = this._columnInfo[n - 1].name;
        } else if (string.equals("getColumnType")) {
            int n = (Integer)objectArray[0];
            object2 = this._columnInfo[n - 1].type.getSQLType();
        } else if (string.equals("getColumnTypeName")) {
            int n = (Integer)objectArray[0];
            object2 = this._columnInfo[n - 1].type.getName();
        } else if (string.equals("getCatalogName") || string.equals("getSchemaName") || string.equals("getTableName")) {
            object2 = null;
        } else if (string.equals("isNullable")) {
            int n = (Integer)objectArray[0];
            object2 = this._columnInfo[n - 1].nullable ? Integer.valueOf(1) : Integer.valueOf(0);
        } else if (string.equals("isAutoIncrement")) {
            object2 = Boolean.FALSE;
        } else if (string.equals("isReadOnly")) {
            object2 = Boolean.TRUE;
        } else if (string.equals("isWritable")) {
            object2 = Boolean.FALSE;
        } else if (string.equals("isSigned")) {
            object2 = Boolean.FALSE;
        } else if (string.equals("toString")) {
            object2 = "";
        } else {
            throw new SQLException(string + " not implemented");
        }
        return object2;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

