/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.CompoundBorder;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;

class StatusBar
extends JPanel {
    public static final int NOT_CONTROLLED = 0;
    public static final int CHECKED_IN = 1;
    public static final int CHECKED_OUT = 2;
    private SybLabel _lineLabel;
    private SybLabel _line;
    private SybLabel _columnLabel;
    private SybLabel _column;
    private SybLabel _statusMsg;
    private JPanel _cursorPositionPanel;
    private JPanel _statusPanel;
    private JPanel _sourceControlPanel;
    private SybLabel _sourceControlMessage;
    private Icon _checkedInIcon = null;
    private Icon _checkedOutIcon = null;

    StatusBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this._cursorPositionPanel = new JPanel();
        this._cursorPositionPanel.setLayout(new BoxLayout(this._cursorPositionPanel, 0));
        this._cursorPositionPanel.setBorder(compoundBorder);
        this._lineLabel = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "Line"));
        this._cursorPositionPanel.add((Component)this._lineLabel);
        this._cursorPositionPanel.add(Box.createHorizontalStrut(4));
        this._line = new SybLabel();
        this._cursorPositionPanel.add((Component)this._line);
        this._cursorPositionPanel.add(Box.createHorizontalStrut(10));
        this._columnLabel = new SybLabel(ISQLResource.getISQLString(GeneralResources.getName(), "Column"));
        this._cursorPositionPanel.add((Component)this._columnLabel);
        this._cursorPositionPanel.add(Box.createHorizontalStrut(4));
        this._column = new SybLabel();
        this._cursorPositionPanel.add((Component)this._column);
        this.add(this._cursorPositionPanel);
        this.add(Box.createHorizontalStrut(4));
        this._sourceControlPanel = new JPanel();
        this._sourceControlPanel.setBorder(compoundBorder);
        this._sourceControlPanel.setLayout(new BoxLayout(this._sourceControlPanel, 0));
        this._sourceControlMessage = new SybLabel(" ");
        this._sourceControlMessage.setIconTextGap(4);
        this._sourceControlPanel.add((Component)this._sourceControlMessage);
        int n = -1;
        this.setSourceControlIndicator(1);
        Dimension dimension = this._sourceControlMessage.getPreferredSize();
        n = Math.max(dimension.width, n);
        this.setSourceControlIndicator(2);
        dimension = this._sourceControlMessage.getPreferredSize();
        n = Math.max(dimension.width, n);
        this.setSourceControlIndicator(0);
        dimension = this._sourceControlMessage.getPreferredSize();
        dimension.width = n;
        this._sourceControlMessage.setPreferredSize(dimension);
        this._sourceControlMessage.setMinimumSize(dimension);
        this._sourceControlMessage.setMaximumSize(dimension);
        this.add(this._sourceControlPanel);
        this.add(Box.createHorizontalStrut(4));
        this._statusPanel = new JPanel();
        this._statusPanel.setBorder(compoundBorder);
        this._statusPanel.setLayout(new BoxLayout(this._statusPanel, 0));
        this._statusMsg = new SybLabel(" ");
        this._statusMsg.setIconTextGap(4);
        this._statusPanel.add((Component)this._statusMsg);
        this._statusPanel.add(Box.createHorizontalGlue());
        this.add(this._statusPanel);
    }

    void destroy() {
        this._lineLabel = null;
        this._line = null;
        this._columnLabel = null;
        this._column = null;
        this._statusMsg = null;
        this._cursorPositionPanel = null;
        this._statusPanel = null;
        this._sourceControlPanel = null;
        this._sourceControlMessage = null;
    }

    void setCursorLocation(int n, int n2) {
        this._line.setText(Integer.toString(n));
        this._column.setText(Integer.toString(n2));
    }

    void setSourceControlIndicatorVisible(boolean bl) {
        this._sourceControlPanel.setVisible(bl);
    }

    void setSourceControlIndicator(int n) {
        switch (n) {
            case 1: {
                if (this._checkedInIcon == null) {
                    this._checkedInIcon = this.createIcon(ISQLImages.getImage("checkedin"));
                }
                this._sourceControlMessage.setIcon(this._checkedInIcon);
                this._sourceControlMessage.setText(GeneralResources.getISQLString(GeneralResources.getName(), "CheckedIn"));
                break;
            }
            case 2: {
                if (this._checkedOutIcon == null) {
                    this._checkedOutIcon = this.createIcon(ISQLImages.getImage("checkedout"));
                }
                this._sourceControlMessage.setIcon(this._checkedOutIcon);
                this._sourceControlMessage.setText(GeneralResources.getISQLString(GeneralResources.getName(), "CheckedOut"));
                break;
            }
            case 0: {
                this._sourceControlMessage.setIcon(null);
                this._sourceControlMessage.setText(" ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal state:" + n);
            }
        }
    }

    private Icon createIcon(Image image) {
        MonochromeImageFilter monochromeImageFilter = new MonochromeImageFilter();
        Image image2 = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), monochromeImageFilter));
        return new ImageIcon(image2);
    }

    void setStatusMessage(Icon icon, String string) {
        if (string == null) {
            string = " ";
        }
        this._statusMsg.setIcon(icon);
        this._statusMsg.setText(string);
    }

    void addProgressBar(JProgressBar jProgressBar, String string, Icon icon) {
        Dimension dimension = this._cursorPositionPanel.getPreferredSize();
        jProgressBar.setPreferredSize(dimension);
        jProgressBar.setMaximumSize(dimension);
        jProgressBar.setMinimumSize(dimension);
        this._cursorPositionPanel.setVisible(false);
        this.add(jProgressBar);
        if (string != null) {
            this._statusMsg.setText(string);
        }
        this._statusMsg.setIcon(icon);
        this.revalidate();
    }

    void removeProgressBar(JProgressBar jProgressBar, String string, Icon icon) {
        this.remove(jProgressBar);
        this._cursorPositionPanel.setVisible(true);
        if (string == null) {
            string = " ";
        }
        this._statusMsg.setText(string);
        this._statusMsg.setIcon(icon);
        this.revalidate();
    }

    private static class MonochromeImageFilter
    extends RGBImageFilter {
        MonochromeImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            return SystemColor.controlText.getRGB();
        }
    }
}

