/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import sybase.isql.ColumnBrowser;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLResource;
import sybase.isql.OwnerAndName;
import sybase.isql.TableBrowserResources;

class TableBrowser
extends JDialog
implements ActionListener,
DocumentListener,
MouseListener {
    static final int SINGLE_SELECTION = 1;
    static final int MULTI_SELECTION = 2;
    private static boolean _initShowTables = true;
    private static boolean _initShowSystemTables = false;
    private static boolean _initShowViews = false;
    private static boolean _initShowOwnerNames = false;
    private static final int FIELD_WIDTH = 10;
    private static final int VERT_SPACING = 8;
    private static final int MAJOR_VERT_SPACING = 16;
    private static final int HORIZ_SPACING = 5;
    private static final int HORIZ_INDENT = 16;
    private static final int TIMER_DELAY = 800;
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String SHOW_COLUMNS_COMMAND = "ShowColumns";
    private static final String F1_KEY = "F1_KEY";
    private String[] _tableNames = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _help = null;
    private SybButton _showColumns = null;
    private JList _list = null;
    private JTextField _pattern = null;
    private SybCheckBox _tables = null;
    private SybCheckBox _systemTables = null;
    private SybCheckBox _views = null;
    private SybCheckBox _showOwnerNames = null;
    private ISQLConnection _connection;
    private Timer _timer = null;
    private SybComboBox _dbComboBox = null;
    private String _dbName = null;
    private boolean _refreshInProgress = false;

    private TableBrowser(JDialog jDialog, ISQLConnection iSQLConnection, String string, String string2, int n) {
        super((Window)jDialog, string, Dialog.ModalityType.DOCUMENT_MODAL);
        this.constructor(jDialog, iSQLConnection, string, string2, n);
    }

    private TableBrowser(JFrame jFrame, ISQLConnection iSQLConnection, String string, String string2, int n) {
        super((Window)jFrame, string, Dialog.ModalityType.DOCUMENT_MODAL);
        this.constructor(jFrame, iSQLConnection, string, string2, n);
    }

    private void constructor(Component component, ISQLConnection iSQLConnection, String string, String string2, int n) {
        Object object;
        Serializable serializable;
        this._connection = iSQLConnection;
        this._timer = new Timer(800, this);
        this._timer.setRepeats(false);
        ISQLResource iSQLResource = ISQLResource.getISQLResource(TableBrowserResources.getName());
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        int n2 = 0;
        SybLabel sybLabel = new SybLabel(iSQLResource.getISQLString("1."));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        jPanel.add((Component)sybLabel);
        sybLabel = new SybLabel(iSQLResource.getISQLString("Type the first few characters of the table you're looking for"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        jPanel.add((Component)sybLabel);
        this._pattern = new JTextField();
        new FontHelper((JTextComponent)this._pattern);
        this._pattern.getDocument().addDocumentListener(this);
        sybLabel.setLabelFor((Component)this._pattern);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(this._pattern, gridBagConstraints);
        jPanel.add(this._pattern);
        sybLabel = new SybLabel(iSQLResource.getISQLString("2."));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(16, 0, 0, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        jPanel.add((Component)sybLabel);
        sybLabel = new SybLabel(iSQLResource.getISQLString("Click the table you want, then click OK or Show Columns"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints);
        jPanel.add((Component)sybLabel);
        if (this._connection.getDatabaseType() == 1) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            this._dbComboBox = new SybComboBox();
            gridBagLayout.setConstraints((Component)this._dbComboBox, gridBagConstraints);
            jPanel.add((Component)this._dbComboBox);
            this._dbName = this._connection.getCatalog();
            serializable = this._connection.getDatabaseNames();
            object = serializable.iterator();
            while (object.hasNext()) {
                this._dbComboBox.addItem((Object)object.next());
            }
            this._dbComboBox.setSelectedItem((Object)this._dbName);
            this._dbComboBox.addActionListener((ActionListener)this);
            ++n2;
        }
        this._list = new JList();
        this._list.setCellRenderer(FontHelper.getListCellRenderer());
        this._list.setSelectionMode((n & 1) != 0 ? 0 : 2);
        this._list.addMouseListener(this);
        sybLabel.setLabelFor((Component)this._list);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this._tables = new SybCheckBox(iSQLResource.getISQLString("Tables"));
        this._tables.setSelected(_initShowTables);
        this._tables.addActionListener((ActionListener)this);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 5);
        jPanel.add((Component)this._tables, gridBagConstraints);
        this._systemTables = new SybCheckBox(iSQLResource.getISQLString("System tables"));
        this._systemTables.setSelected(_initShowSystemTables);
        this._systemTables.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._systemTables, gridBagConstraints);
        if (this._connection.getDatabaseType() != 3) {
            this._views = new SybCheckBox(iSQLResource.getISQLString("Views"));
            this._views.setSelected(_initShowViews);
            this._views.addActionListener((ActionListener)this);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)this._views, gridBagConstraints);
        }
        ++n2;
        if (this._connection.getDatabaseType() != 3) {
            this._showOwnerNames = new SybCheckBox(iSQLResource.getISQLString("Show owner names"));
            this._showOwnerNames.setSelected(_initShowOwnerNames);
            this._showOwnerNames.addActionListener((ActionListener)this);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)this._showOwnerNames, gridBagConstraints);
        }
        serializable = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)serializable, gridBagConstraints);
        this._showColumns = new SybButton(iSQLResource.getISQLString("Show Columns..."));
        this._showColumns.addActionListener((ActionListener)this);
        this._ok = new SybButton(iSQLResource.getISQLString("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._cancel = new SybButton(iSQLResource.getISQLString("Cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this._help = new SybButton(iSQLResource.getISQLString("Help"));
        this._help.addActionListener((ActionListener)this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._showColumns);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add((Component)this._ok);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add((Component)this._cancel);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add((Component)this._help);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JButton[]{this._ok, this._cancel, this._help});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        Container container = this.getContentPane();
        container.add(jPanel);
        this._pattern.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        this.getRootPane().registerKeyboardAction(this, F1_KEY, KeyStroke.getKeyStroke(112, 0, true), 2);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getRootPane().registerKeyboardAction(this, SHOW_COLUMNS_COMMAND, KeyStroke.getKeyStroke(118, 0, false), 1);
        String string3 = "ScrollUp";
        String string4 = "ScrollDown";
        object = this._pattern.getInputMap(0);
        ((InputMap)object).put(KeyStroke.getKeyStroke(38, 0, false), string3);
        ((InputMap)object).put(KeyStroke.getKeyStroke(40, 0, false), string4);
        ActionMap actionMap = this._pattern.getActionMap();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TableBrowser.this._list.getSelectedIndex();
                if (--n < 0) {
                    n = 0;
                }
                TableBrowser.this._list.setSelectedIndex(n);
                TableBrowser.this._list.ensureIndexIsVisible(n);
            }
        };
        actionMap.put(string3, abstractAction);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TableBrowser.this._list.getSelectedIndex();
                int n2 = TableBrowser.this._list.getModel().getSize();
                if (++n == n2) {
                    n = n2 - 1;
                }
                TableBrowser.this._list.setSelectedIndex(n);
                TableBrowser.this._list.ensureIndexIsVisible(n);
            }
        };
        actionMap.put(string4, abstractAction);
        if (string == null) {
            this.setTitle(iSQLResource.getISQLString("Select Table"));
        } else {
            this.setTitle(string);
        }
        this.refreshList();
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width = Math.max(dimension.width, 300);
        jPanel.setPreferredSize(dimension);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(component);
        UIUtils.ensureWindowIsVisible((Window)this);
    }

    private void destroyGUI() {
        if (this._timer.isRunning()) {
            this._timer.stop();
            this._timer.removeActionListener(this);
            this._timer = null;
        }
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, true));
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(118, 0, false));
        this.getRootPane().setDefaultButton(null);
        this._pattern.getDocument().removeDocumentListener(this);
        this._pattern = null;
        this._tables.removeActionListener((ActionListener)this);
        this._tables = null;
        this._systemTables.removeActionListener((ActionListener)this);
        this._systemTables = null;
        if (this._views != null) {
            this._views.removeActionListener((ActionListener)this);
            this._views = null;
        }
        if (this._showOwnerNames != null) {
            this._showOwnerNames.removeActionListener((ActionListener)this);
            this._showOwnerNames = null;
        }
        this._showColumns.removeActionListener((ActionListener)this);
        this._showColumns = null;
        this._ok.removeActionListener((ActionListener)this);
        this._ok = null;
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._help.removeActionListener((ActionListener)this);
        this._help = null;
        if (this._dbComboBox != null) {
            this._dbComboBox.removeActionListener((ActionListener)this);
            this._dbComboBox = null;
        }
        this._list.removeMouseListener(this);
        this._list = null;
        this._connection = null;
        DialogUtils.removeComponents((Container)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        if (this._refreshInProgress) {
            this._timer.restart();
            return;
        }
        try {
            this._refreshInProgress = true;
            this.refreshList2();
        }
        finally {
            this._refreshInProgress = false;
        }
    }

    private void refreshList2() {
        int n;
        OwnerAndName ownerAndName = null;
        Component component = this.getFocusOwner();
        ownerAndName = (OwnerAndName)this._list.getSelectedValue();
        String string = this._pattern.getText();
        if (string.indexOf(37) == -1) {
            string = string + "%";
        }
        int n2 = 0;
        if (this._tables.isSelected()) {
            n2 = n2 + 1 + 8;
        }
        if (this._systemTables.isSelected()) {
            n2 += 2;
        }
        if (this._views != null && this._views.isSelected()) {
            n2 += 4;
        }
        if ((n2 & 7) == 0) {
            this._list.setListData(new Object[0]);
            return;
        }
        String string2 = this._dbComboBox != null ? this._dbComboBox.getSelectedItem().toString() : null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._connection.listTables(string2, null, string, n2, arrayList, arrayList2);
        this.setCursor(Cursor.getPredefinedCursor(0));
        OwnerAndName.sortByOwnerThenName = this._showOwnerNames != null && this._showOwnerNames.isSelected();
        Object[] objectArray = new OwnerAndName[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            objectArray[n] = new OwnerAndName(arrayList.get(n), arrayList2.get(n));
        }
        Arrays.sort(objectArray);
        this._list.setListData(objectArray);
        if (objectArray.length > 0) {
            n = 0;
            if (ownerAndName != null && (n = Arrays.binarySearch(objectArray, ownerAndName)) < 0) {
                n = 0;
            }
            this._list.setSelectedIndex(n);
            this._list.ensureIndexIsVisible(n);
        }
        if (component != null) {
            component.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (object == this._tables || this._views != null && object == this._views || object == this._systemTables || object == this._showOwnerNames) {
            if (object == this._tables) {
                _initShowTables = this._tables.isSelected();
            } else if (object == this._views) {
                _initShowViews = this._views.isSelected();
            } else if (object == this._systemTables) {
                _initShowSystemTables = this._systemTables.isSelected();
            } else if (object == this._showOwnerNames) {
                _initShowOwnerNames = this._showOwnerNames.isSelected();
            }
            this._timer.stop();
            this.refreshList();
        } else if (object == this._dbComboBox) {
            this._timer.stop();
            this.refreshList();
        } else if (object == this._timer) {
            this.refreshList();
        } else if (object == this._showColumns) {
            this.handleBrowseColumns();
        } else if (object == this._help || actionEvent.getActionCommand().equals(F1_KEY)) {
            this.handleHelp();
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals(ESCAPE_KEY_COMMAND)) {
                    this.handleCancel();
                } else if (string.equals(SHOW_COLUMNS_COMMAND)) {
                    this.handleBrowseColumns();
                }
            }
        }
    }

    private void handleBrowseColumns() {
        String string;
        String string2;
        OwnerAndName ownerAndName = (OwnerAndName)this._list.getSelectedValue();
        if (ownerAndName != null && (string2 = ColumnBrowser.create(this, this._connection, string = this._dbComboBox != null ? this._dbComboBox.getSelectedItem().toString() : null, ownerAndName)) != null) {
            this._tableNames = new String[1];
            this._tableNames[0] = string2;
            this._ok.setEnabled(false);
            this._cancel.setEnabled(false);
            this._help.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TableBrowser.this.isActive()) {
                        TableBrowser.this._cancel.setEnabled(true);
                        TableBrowser.this._cancel.doClick();
                    } else {
                        SwingUtilities.invokeLater(this);
                    }
                }
            });
        }
    }

    private void handleInsert() {
        Object[] objectArray = this._list.getSelectedValues();
        int n = objectArray.length;
        this._tableNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this._tableNames[i] = objectArray[i].toString();
        }
    }

    private void handleOK() {
        this.handleInsert();
        this.setVisible(false);
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    private void handleHelp() {
        ISQLHelpManager.showHelp((ISQLConnectionImpl)this._connection, this, "HELP_ISQL_TABLE_BROWSER");
    }

    static String[] create(JDialog jDialog, ISQLConnection iSQLConnection, String string, String string2, int n) {
        TableBrowser tableBrowser = new TableBrowser(jDialog, iSQLConnection, string, string2, n);
        tableBrowser.setVisible(true);
        tableBrowser.destroyGUI();
        return tableBrowser._tableNames;
    }

    static String[] create(JFrame jFrame, ISQLConnection iSQLConnection, String string, String string2, int n) {
        TableBrowser tableBrowser = new TableBrowser(jFrame, iSQLConnection, string, string2, n);
        tableBrowser.setVisible(true);
        tableBrowser.destroyGUI();
        return tableBrowser._tableNames;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n = this._list.locationToIndex(mouseEvent.getPoint());
            this._list.setSelectedIndex(n);
            this.handleOK();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this._timer.restart();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this._timer.restart();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this._timer.restart();
    }
}

