/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

class TerminatedFileReader
extends InputStreamReader {
    boolean _returnedFinalNewline = false;
    boolean _checkForEndianIndicator = this.shouldCheckForEndianIndicator();

    TerminatedFileReader(File file) throws FileNotFoundException {
        super(new FileInputStream(file));
    }

    TerminatedFileReader(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        super((InputStream)new FileInputStream(file), string);
    }

    private boolean shouldCheckForEndianIndicator() {
        String string = super.getEncoding();
        boolean bl = string.equals("UTF8") || string.equals("UTF-16") || string.equals("UnicodeLittleUnmarked") || string.equals("UnicodeBigUnmarked");
        return bl;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            if (!this._returnedFinalNewline) {
                this._returnedFinalNewline = true;
                n = 10;
            }
        } else if (this._checkForEndianIndicator) {
            if (n == 65279 || n == 65534) {
                n = super.read();
            }
            this._checkForEndianIndicator = false;
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 == -1) {
            if (!this._returnedFinalNewline) {
                this._returnedFinalNewline = true;
                cArray[n] = 10;
                n3 = 1;
            }
        } else if (this._checkForEndianIndicator && n3 > 0) {
            if (cArray[0] == '\ufeff' || cArray[0] == '\ufffe') {
                System.arraycopy(cArray, 1, cArray, 0, --n3);
            }
            this._checkForEndianIndicator = false;
        }
        return n3;
    }
}

