/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Vector;
import sybase.isql.DataTypeMetaData;
import sybase.isql.ErrorMessages;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLResource;
import sybase.isql.Importer;
import sybase.isql.ImporterFailedException;
import sybase.isql.ImporterMissingMetaDataException;
import sybase.isql.ImporterPreviewer;
import sybase.isql.InputOutputOptions;
import sybase.isql.InputStatement;
import sybase.isql.ParserUtils;
import sybase.isql.TableGenitor;
import sybase.isql.TableInfo;
import sybase.isql.isql;

class TextImporter
implements Importer,
ImporterPreviewer,
TableGenitor {
    private static final String TEXT_FILE_EXTENSION = ".txt";
    private static final String SQL_FILE_EXTENSION = ".sql";
    private InputOutputOptions _options;
    private Reader _reader;
    private String _line;
    private TableInfo _tableInfo = null;
    private int _columnCount = -1;
    private Throwable _lastError = null;

    TextImporter(InputOutputOptions inputOutputOptions) {
        this._options = inputOutputOptions;
    }

    @Override
    public void readPreviewData(ISQLConnection iSQLConnection) throws ImporterFailedException {
        try {
            this.open(iSQLConnection);
            this.readMetaData(iSQLConnection);
            boolean bl = this.createTable(iSQLConnection);
            if (bl) {
                bl = this.populateTable(iSQLConnection);
            }
            this.close();
        }
        catch (ImporterMissingMetaDataException importerMissingMetaDataException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._lastError != null) {
            if (this._lastError instanceof ImporterFailedException) {
                throw (ImporterFailedException)this._lastError;
            }
            throw new ImporterFailedException(ISQLResource.getISQLString(ErrorMessages.getName(), "COULD_NOT_READ_PREVIEW_DATA"), this._lastError);
        }
    }

    @Override
    public int getPreviewColumnCount() throws ImporterFailedException {
        int n;
        switch (this._options.getFormat()) {
            case 1: {
                n = this.guessColumnCountFromAsciiFile();
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int guessColumnCountFromAsciiFile() throws ImporterFailedException {
        int n;
        try {
            this.open(null);
            this._line = this.readLine();
            if (this._line != null) {
                Vector<Object> vector = TextImporter.getAsciiRowData(this._options, this._line);
                n = vector.size();
                if (n == 0) {
                    n = 1;
                }
            } else {
                n = 1;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            n = 1;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            n = 0;
        }
        catch (IOException iOException) {
            n = 0;
        }
        finally {
            this.close();
        }
        return n;
    }

    public static int guessFormat(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 4) {
            String string2 = string.substring(n2 - 4, n2);
            if (string2.equalsIgnoreCase(TEXT_FILE_EXTENSION)) {
                n = 1;
            } else if (string2.equalsIgnoreCase(SQL_FILE_EXTENSION)) {
                n = 4;
            }
        }
        return n;
    }

    @Override
    public boolean open(ISQLConnection iSQLConnection) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        this._reader = this._options.getSQLReader();
        if (this._reader == null) {
            String string = this._options.getEncoding();
            boolean bl = false;
            if (this._options.getFormat() == 1) {
                String string2;
                if (string == null) {
                    String string3;
                    if (this._options.useByteOrderMark && (string3 = this.getUTFEncodingFromFile(this._options.getFileName())) != null) {
                        string = string3;
                        bl = true;
                    }
                } else if (this._options.useByteOrderMark && (string2 = this.getUTFEncodingFromFile(this._options.getFileName())) != null) {
                    if ((string.equalsIgnoreCase("utf-16be") || string.equalsIgnoreCase("utf-16le") || string.equalsIgnoreCase("utf-8")) && !string.equalsIgnoreCase(string2)) {
                        throw new IOException(ISQLResource.getFormattedString(ErrorMessages.getName(), "INPUT_STATEMENT_ENDIAN_MISMATCH", string, string2));
                    }
                    if (string.equalsIgnoreCase("utf-16")) {
                        string = string2;
                    }
                    if (string.equalsIgnoreCase("utf-8") || string.equalsIgnoreCase("utf-16le") || string.equalsIgnoreCase("utf-16be")) {
                        bl = true;
                    }
                }
                if (string == null) {
                    string = ParserUtils.getDefaultEncoding(iSQLConnection);
                }
                this._reader = this._options.getEscapes() ? new ASCIIFileReader(this._options.getFileName(), this._options.getEscapeCharacter(), string, bl) : new TextFileReader(this._options.getFileName(), string, bl);
            } else {
                if (string == null) {
                    string = ParserUtils.getDefaultEncoding(iSQLConnection);
                }
                this._reader = new TextFileReader(this._options.getFileName(), string, bl);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUTFEncodingFromFile(String string) {
        FileInputStream fileInputStream = null;
        String string2 = null;
        try {
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[3];
            int n = fileInputStream.read(byArray);
            if (n == 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                string2 = "utf-8";
            } else if (n >= 2) {
                if (byArray[0] == -1 && byArray[1] == -2) {
                    string2 = "utf-16le";
                } else if (byArray[0] == -2 && byArray[1] == -1) {
                    string2 = "utf-16be";
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    @Override
    public void readMetaData(ISQLConnection iSQLConnection) throws ImporterMissingMetaDataException, ImporterFailedException {
        int n;
        this._tableInfo = iSQLConnection.getTableInfo(this._options.getCatalog(), this._options.getOwner(), this._options.getTableName());
        if (this._tableInfo == null) {
            throw new ImporterMissingMetaDataException();
        }
        this._columnCount = this._options.getColumnList().size();
        if (this._columnCount == 0) {
            this._columnCount = this._tableInfo.column.length;
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < this._columnCount; ++n) {
                vector.add(this._tableInfo.column[n].name);
            }
            this._options.setColumnList(vector);
        }
        if (this._options.getFormat() == 2 && this._options.getColumnWidthCount() != this._columnCount) {
            for (n = this._options.getColumnWidthCount(); n < this._columnCount; ++n) {
                int n2;
                int n3;
                boolean bl = false;
                String string = this._options.getColumnList().get(n);
                for (n3 = 0; n3 < this._tableInfo.column.length; ++n3) {
                    if (!this._tableInfo.column[n3].name.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    n2 = this._tableInfo.column[n3].width;
                    switch (this._tableInfo.column[n3].type.getSQLType()) {
                        case 2: 
                        case 3: {
                            n2 += 2;
                            break;
                        }
                        case -7: 
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            ++n2;
                            break;
                        }
                        case 7: {
                            n2 += 6;
                            break;
                        }
                        case 6: 
                        case 8: {
                            n2 += 7;
                        }
                    }
                    if (n2 > 32768) {
                        n2 = 32768;
                    }
                } else {
                    throw new ImporterFailedException(ISQLResource.getFormattedString(ErrorMessages.getName(), "ColumnIsNotInTable", string, this._options.getQuotedOwnerAndTableName(iSQLConnection)));
                }
                this._options.addColumnWidth(n2);
            }
        }
    }

    @Override
    public boolean createTable(ISQLConnection iSQLConnection) {
        String string;
        String string2;
        String string3 = this._options.getCatalog();
        boolean bl = iSQLConnection.tableExists(string3, string2 = this._options.getOwner(), string = this._options.getTableName());
        if (!bl) {
            isql.getIO(iSQLConnection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "The table you selected ({0}) does not exist. Create it first, then try importing the data again.", string), 0);
        }
        return bl;
    }

    @Override
    public boolean populateTable(ISQLConnection iSQLConnection) throws ImporterFailedException {
        boolean bl = iSQLConnection.addTableData(this._options.getCatalog(), this._options.getOwner(), this._options.getTableName(), this);
        return bl;
    }

    @Override
    public boolean close() {
        this._tableInfo = null;
        if (this._reader != null) {
            this._reader.close();
            this._reader = null;
        }
        return true;
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public boolean knowsColumnNames() {
        boolean bl = false;
        boolean bl2 = bl = this._options.getColumnMatchingTechnique() == 2;
        if (!bl) {
            Vector<String> vector = this._options.getColumnList();
            bl = vector.size() != 0;
        }
        return bl;
    }

    @Override
    public String getColumnName(int n) {
        String string = this._options.getColumnList().size() != 0 ? this._options.getColumnList().elementAt(n) : this._tableInfo.column[n].name;
        return string;
    }

    @Override
    public DataTypeMetaData getColumnTypeMetaData(int n) {
        return this._tableInfo.column[n].type;
    }

    @Override
    public int getColumnWidth(int n) {
        return 0;
    }

    @Override
    public int getColumnScale(int n) {
        return 0;
    }

    @Override
    public boolean isColumnInPrimaryKey(int n) {
        return false;
    }

    @Override
    public boolean isNullableColumn(int n) {
        return true;
    }

    private String readLine() throws ImporterFailedException {
        String string;
        try {
            string = this._reader.readLine();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new ImporterFailedException(ISQLResource.getISQLString(ErrorMessages.getName(), "CANNOT_IMPORT_LINE_TOO_LONG"), outOfMemoryError);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = null;
        }
        return string;
    }

    @Override
    public Vector<Object> getRowData() {
        Vector<Object> vector;
        switch (this._options.getFormat()) {
            case 1: {
                vector = TextImporter.getAsciiRowData(this._options, this._line);
                this.convertDataForBinaryColumns(vector);
                break;
            }
            case 2: {
                vector = this.getFixedRowData();
                break;
            }
            default: {
                vector = null;
            }
        }
        return vector;
    }

    private Vector<Object> getFixedRowData() {
        Vector<Object> vector = new Vector<Object>();
        vector.setSize(this._columnCount);
        int n = 0;
        for (int i = 0; i < this._columnCount; ++i) {
            String string;
            int n2;
            int n3 = n + this._options.getColumnWidth(i);
            if (this._line.length() < n3) break;
            if (!this._options.getNoStrip()) {
                for (n2 = n3 - 1; n2 > n && Character.isWhitespace(this._line.charAt(n2)); --n2) {
                }
            } else {
                n2 = n3 - 1;
            }
            if ((string = this._line.substring(n, n2 + 1)).length() != 0) {
                vector.setElementAt(string, i);
            }
            n = n3;
        }
        return vector;
    }

    static Vector<Object> getAsciiRowData(InputOutputOptions inputOutputOptions, String string) {
        boolean bl = !inputOutputOptions.getNoStrip();
        String string2 = inputOutputOptions.getDelimiter();
        if (string2.equals("\\t")) {
            string2 = "\t";
        }
        int n = string2.length();
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n4 = 0;
        while (n4 < n3) {
            boolean bl2;
            boolean bl3;
            char c;
            char c2;
            int n5;
            for (n5 = n4; n5 < n3; ++n5) {
                c2 = string.charAt(n5);
                if (c2 != string2.charAt(0) && Character.isWhitespace(c2)) continue;
                n4 = n5;
                break;
            }
            if ((c2 = string.charAt(n4)) == '\'' || c2 == '\"') {
                c = c2;
                ++n4;
                bl3 = true;
                bl2 = true;
            } else {
                c = '\u0000';
                bl3 = false;
                bl2 = false;
            }
            stringBuffer.setLength(0);
            boolean bl4 = false;
            for (n5 = n4; n5 < n3 && (bl3 || !string.regionMatches(false, n5, string2, 0, n)); ++n5) {
                c2 = string.charAt(n5);
                if (c2 == c) {
                    if (n5 < n3 - 1 && string.charAt(n5 + 1) == c) {
                        ++n5;
                    } else if (bl3) {
                        bl4 = true;
                        break;
                    }
                }
                stringBuffer.append(c2);
            }
            if (bl4) {
                while (n5 < n3 && !string.regionMatches(false, n5, string2, 0, n)) {
                    ++n5;
                }
            }
            n4 = n5 + n;
            if (bl && !bl3) {
                for (n5 = stringBuffer.length() - 1; n5 >= 0; --n5) {
                    if (Character.isWhitespace(stringBuffer.charAt(n5))) continue;
                    stringBuffer.setLength(n5 + 1);
                    break;
                }
            }
            if (bl2 || stringBuffer.length() > 0) {
                vector.addElement(stringBuffer.toString());
            } else {
                vector.addElement(null);
            }
            ++n2;
        }
        if (string.endsWith(string2)) {
            vector.addElement(null);
        }
        return vector;
    }

    private void convertDataForBinaryColumns(Vector<Object> vector) {
        int n;
        int n2;
        Vector<String> vector2 = this._options.getColumnList();
        int n3 = vector2.size();
        boolean[] blArray = new boolean[n3];
        Arrays.fill(blArray, false);
        block0: for (n2 = 0; n2 < n3; ++n2) {
            String string = vector2.elementAt(n2).toString();
            for (n = 0; n < this._tableInfo.column.length; ++n) {
                if (!this._tableInfo.column[n].name.equals(string)) continue;
                int n4 = this._tableInfo.column[n].type.getSQLType();
                blArray[n2] = n4 == -2 || n4 == -3 || n4 == -4;
                continue block0;
            }
        }
        n3 = Math.min(vector.size(), vector2.size());
        for (n2 = 0; n2 < n3; ++n2) {
            String string;
            Object object;
            if (!blArray[n2] || (object = vector.elementAt(n2)) == null || !(string = object.toString()).startsWith("0x") || string.length() <= 2 || (string.length() & 1) != 0) continue;
            int n5 = (string.length() - 2) / 2;
            byte[] byArray = new byte[n5];
            for (n = 0; n < n5; ++n) {
                int n6 = (Character.digit(string.charAt(n * 2 + 2), 16) << 4) + Character.digit(string.charAt(n * 2 + 3), 16);
                byArray[n] = (byte)(n6 & 0xFF);
            }
            vector.set(n2, byArray);
        }
    }

    @Override
    public boolean moveNext() {
        boolean bl = false;
        try {
            while (!this._reader.eof()) {
                this._line = this.readLine();
                if (this._line == null || this._reader.eof()) continue;
                bl = true;
                break;
            }
        }
        catch (ImporterFailedException importerFailedException) {
            this._lastError = importerFailedException;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean keepGoing(ISQLConnection iSQLConnection) {
        return InputStatement.keepGoing(iSQLConnection);
    }

    private static class TextFileReader
    implements Reader {
        private BufferedReader _in;
        private boolean _eof;

        TextFileReader(String string, String string2, boolean bl) throws FileNotFoundException, IOException, UnsupportedEncodingException {
            FileInputStream fileInputStream = new FileInputStream(string);
            if (bl) {
                if (string2.equalsIgnoreCase("utf-8")) {
                    fileInputStream.skip(3L);
                } else if (string2.equalsIgnoreCase("utf-16le") || string2.equalsIgnoreCase("utf-16be")) {
                    fileInputStream.skip(2L);
                }
            }
            this._in = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string2));
            this._eof = false;
        }

        @Override
        public String readLine() {
            try {
                StringBuilder stringBuilder = new StringBuilder(512);
                while (true) {
                    int n;
                    if ((n = this._in.read()) == -1) {
                        if (stringBuilder.length() != 0) break;
                        this._eof = true;
                        break;
                    }
                    if (n == 13) {
                        this._in.read();
                        break;
                    }
                    if (n == 10) break;
                    stringBuilder.append((char)n);
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public boolean eof() {
            return this._eof;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this._in != null) {
                try {
                    this._in.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this._in = null;
                }
            }
        }
    }

    private class ASCIIFileReader
    implements Reader {
        private BufferedInputStream _in;
        private boolean _eof;
        private char _escape;
        private String _encoding;
        private boolean _isUnicode;
        private boolean _checkForEndianIndicator;
        private boolean _isBigEndian;

        ASCIIFileReader(String string, char c, String string2, boolean bl) throws FileNotFoundException {
            this._in = new BufferedInputStream(new FileInputStream(string));
            this._escape = c;
            this._eof = false;
            this._encoding = string2;
            if (this._encoding.equalsIgnoreCase("UTF-16BE")) {
                this._isBigEndian = true;
                this._isUnicode = true;
                this._checkForEndianIndicator = bl;
            } else if (this._encoding.equalsIgnoreCase("UTF-16LE")) {
                this._isBigEndian = false;
                this._isUnicode = true;
                this._checkForEndianIndicator = bl;
            } else if (this._encoding.equalsIgnoreCase("UTF-8")) {
                this._isUnicode = false;
                this._checkForEndianIndicator = bl;
            } else {
                this._isUnicode = false;
                this._checkForEndianIndicator = false;
            }
        }

        private int getChar(int n, int n2) {
            int n3 = this._isBigEndian ? n << 8 | n2 : n | n2 << 8;
            return n3;
        }

        @Override
        public String readLine() throws ImporterFailedException, UnsupportedEncodingException {
            String string;
            char c = '\u0000';
            char c2 = '\u0000';
            char c3 = '\u0000';
            char c4 = '\u0000';
            char c5 = '\u0000';
            char c6 = '\u0000';
            boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder(512);
            try {
                while (true) {
                    char c7 = this._in.read();
                    if (this._checkForEndianIndicator && c7 != '\uffffffff') {
                        this._checkForEndianIndicator = false;
                        this._in.mark(3);
                        if (this._isUnicode) {
                            c6 = c7;
                            c5 = this._in.read();
                            if ((c7 = c6 << 8 | c5) == '\ufffe') {
                                this._isBigEndian = false;
                                this._encoding = "UTF-16LE";
                                continue;
                            }
                            if (c7 == '\ufeff') {
                                this._encoding = "UTF-16BE";
                                this._isBigEndian = true;
                                continue;
                            }
                        } else if (c7 == '\u00ef' && (c7 = this._in.read()) == '\u00bb' && (c7 = this._in.read()) == '\u00bf') continue;
                        this._in.reset();
                    }
                    if (this._isUnicode && c7 != '\uffffffff') {
                        c6 = c7;
                        c5 = this._in.read();
                        c7 = this.getChar(c6, c5);
                    }
                    if (c7 == '\uffffffff') {
                        if (stringBuilder.length() == 0) {
                            this._eof = true;
                        }
                    } else if (c7 == '\r') {
                        this._in.read();
                        if (this._isUnicode) {
                            this._in.read();
                        }
                    } else if (c7 != '\n') {
                        if (c7 == this._escape && this._in.available() > 1) {
                            char c8;
                            c4 = c8 = this._in.read();
                            if (this._isUnicode && c8 != '\uffffffff') {
                                c3 = this._in.read();
                                c8 = this.getChar(c4, c3);
                            }
                            if (c8 != this._escape) {
                                if (c8 == 'n') {
                                    c8 = '\n';
                                } else {
                                    if ((c8 == 'x' || c8 == 'X') && this._in.available() >= 2) {
                                        char c9 = (char)this._in.read();
                                        if (this._isUnicode) {
                                            c2 = (char)this._in.read();
                                            c9 = (char)this.getChar(c9, c2);
                                        }
                                        char c10 = (char)this._in.read();
                                        if (this._isUnicode) {
                                            c = (char)this._in.read();
                                            c10 = (char)this.getChar(c10, c);
                                        }
                                        if (Character.digit(c9, 16) != -1 && Character.digit(c10, 16) != -1) {
                                            c7 = (char)((Character.digit(c9, 16) << 4) + Character.digit(c10, 16));
                                            bl &= c7 < '\u0080';
                                            stringBuilder.append(c7);
                                            continue;
                                        }
                                        if (this._isUnicode) {
                                            stringBuilder.append((int)c6);
                                            stringBuilder.append((int)c5);
                                            stringBuilder.append((int)c4);
                                            stringBuilder.append((int)c3);
                                            stringBuilder.append(c9);
                                            stringBuilder.append(c2);
                                            stringBuilder.append(c10);
                                            stringBuilder.append(c);
                                            continue;
                                        }
                                        stringBuilder.append(this._escape);
                                        stringBuilder.append((int)c8);
                                        stringBuilder.append(c9);
                                        stringBuilder.append(c10);
                                        continue;
                                    }
                                    if (this._isUnicode) {
                                        stringBuilder.append((int)c6);
                                        stringBuilder.append((int)c5);
                                        c7 = c8;
                                        c6 = c4;
                                        c5 = c3;
                                    } else {
                                        stringBuilder.append(this._escape);
                                        c7 = c8;
                                    }
                                }
                            }
                        }
                        if (this._isUnicode) {
                            bl &= c6 < '\u0080';
                            bl &= c5 < '\u0080';
                            stringBuilder.append(c6);
                            stringBuilder.append(c5);
                            continue;
                        }
                        bl &= c7 < '\u0080';
                        stringBuilder.append(c7);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new ImporterFailedException(ISQLResource.getFormattedString(ErrorMessages.getName(), "Error reading file \"{0}\".\n{1}", TextImporter.this._options.getFileName(), iOException.getLocalizedMessage()), iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                stringBuilder.setLength(0);
                throw new ImporterFailedException(ISQLResource.getISQLString(ErrorMessages.getName(), "NOT_ENOUGH_MEMORY_TO_IMPORT"));
            }
            if (bl && this._encoding.equals(System.getProperty("file.encoding"))) {
                string = stringBuilder.toString();
            } else {
                byte[] byArray = new byte[stringBuilder.length()];
                int n = stringBuilder.length();
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)stringBuilder.charAt(i);
                }
                string = new String(byArray, 0, n, this._encoding);
            }
            return string;
        }

        @Override
        public boolean eof() {
            return this._eof;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this._in != null) {
                try {
                    this._in.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this._in = null;
                }
            }
        }
    }

    static interface Reader {
        public String readLine() throws ImporterFailedException, UnsupportedEncodingException;

        public boolean eof();

        public void close();
    }
}

